/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.view.editors.ComboBoxCompletionContributor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.RelativeFont;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TableNameComboBox
extends ComboBox<String> {
    public static final JBColor NEW_TABLE_FOREGROUND = new JBColor(46397, 7054941);
    public static final JBColor NEW_TABLE_BACKGROUND = new JBColor(15465713, 3226418);
    public static final JBColor EXISTING_TABLE_FOREGROUND = new JBColor(464273, 6854587);
    public static final JBColor EXISTING_TABLE_BACKGROUND = new JBColor(15595263, 3224891);
    private final LanguageTextField myEditorTextField;
    private final JPanel myTagPanel;
    private final JLabel myLabel;
    private ImportEditorContext myContext;

    TableNameComboBox(@NotNull Project project, @NotNull ImportEditorContext context, @NotNull Disposable parent) {
        if (project == null) {
            TableNameComboBox.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TableNameComboBox.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            TableNameComboBox.$$$reportNull$$$0(2);
        }
        this.setSwingPopup(false);
        this.myContext = context;
        this.createModel();
        this.myLabel = new JLabel();
        this.myLabel.setFont(RelativeFont.TINY.derive(this.getFont()));
        this.myLabel.setOpaque(true);
        this.myLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)1, (int)2));
        this.myTagPanel = new JPanel(new BorderLayout());
        this.myTagPanel.setOpaque(true);
        this.myTagPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)1, (int)2, (int)0));
        this.myTagPanel.add((Component)this.myLabel, "Center");
        this.myEditorTextField = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, project, "");
        DocumentListener listener2 = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TableNameComboBox.this.updateTag();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/TableNameComboBox$1", "documentChanged"));
            }
        };
        this.myEditorTextField.addDocumentListener(listener2);
        this.myEditorTextField.getDocument().putUserData(ComboBoxCompletionContributor.COMBO_BOX_KEY, (Object)this);
        ComboBoxCompositeEditor compositeEditor = new ComboBoxCompositeEditor((JComponent)this.myEditorTextField, new JComponent[]{this.myTagPanel});
        this.myEditorTextField.addSettingsProvider(editor2 -> {
            Color editorBackgroundColor = editor2.getBackgroundColor();
            this.myTagPanel.setBackground(editorBackgroundColor);
            compositeEditor.setBackground(editorBackgroundColor);
        });
        this.setEditor((ComboBoxEditor)compositeEditor);
        this.setEditable(true);
        Disposer.register((Disposable)parent, () -> {
            this.myEditorTextField.removeDocumentListener(listener2);
            this.myEditorTextField.getDocument().putUserData(ComboBoxCompletionContributor.COMBO_BOX_KEY, null);
        });
        this.setSelectedItem(null);
    }

    private void updateTag() {
        String changeListName = this.getEditorTextField().getText();
        if (StringUtil.isEmptyOrSpaces((String)changeListName)) {
            this.myTagPanel.setVisible(false);
            return;
        }
        this.myTagPanel.setVisible(true);
        if (this.myContext.isTableExists(changeListName)) {
            this.myLabel.setText(DatabaseBundle.message("import.table.dialog.existing.table.label", new Object[0]));
            this.myLabel.setBackground((Color)EXISTING_TABLE_BACKGROUND);
            this.myLabel.setForeground((Color)EXISTING_TABLE_FOREGROUND);
        } else {
            this.myLabel.setText(DatabaseBundle.message("import.table.dialog.new.table.label", new Object[0]));
            this.myLabel.setBackground((Color)NEW_TABLE_BACKGROUND);
            this.myLabel.setForeground((Color)NEW_TABLE_FOREGROUND);
        }
    }

    @NotNull
    public EditorTextField getEditorTextField() {
        LanguageTextField languageTextField = this.myEditorTextField;
        if (languageTextField == null) {
            TableNameComboBox.$$$reportNull$$$0(3);
        }
        return languageTextField;
    }

    public void update(@NotNull ImportEditorContext context) {
        if (context == null) {
            TableNameComboBox.$$$reportNull$$$0(4);
        }
        if (this.myContext == context) {
            return;
        }
        this.myContext = context;
        String text = this.getEditorTextField().getText();
        this.createModel();
        this.getEditorTextField().setText(text);
        this.updateTag();
    }

    private void createModel() {
        List names = ContainerUtil.map(this.myContext.getTables(), table -> table.getName());
        this.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray((Collection)names)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/TableNameComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/TableNameComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

