/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.cassandra.CassTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CassGeneratedParserUtil
extends SqlGeneratedParserUtil {
    private static final Pattern uuidPattern = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
    private static final Pattern durationPattern = Pattern.compile("(\\d+(y|mo|w|d|h|m|s|ms|us|\u00b5s|ns))+");
    private static final Pattern iso8601Pattern = Pattern.compile("P(\\d+Y)?(\\d+M)?(\\d+D)?T(\\d+H)?(\\d+M)?(\\d+S)?");
    private static final Pattern iso8601Weeks = Pattern.compile("P\\d+W");

    public static TokenSet create_token_set_(IElementType ... tokenTypes_) {
        TokenSet set = SqlGeneratedParserUtil.create_token_set_(tokenTypes_);
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE})});
        }
        return set;
    }

    public static boolean collapseXPath(PsiBuilder builder, int level) {
        IElementType type = builder.getTokenType();
        if (type != SqlTokens.SQL_IDENT && !(type instanceof SqlKeywordTokenType)) {
            return false;
        }
        PsiBuilder.Marker exprMark = builder.mark();
        PsiBuilder.Marker mark2 = builder.mark();
        for (boolean open = false; type != SqlTokens.SQL_RIGHT_BRACKET && type != SqlTokens.SQL_SEMICOLON && (type == SqlTokens.SQL_IDENT || type instanceof SqlKeywordTokenType || type == SqlTokens.SQL_PERIOD || type == SqlTokens.SQL_LEFT_BRACKET || open); open |= type == SqlTokens.SQL_LEFT_BRACKET) {
            builder.advanceLexer();
            type = builder.getTokenType();
        }
        if (type == SqlTokens.SQL_RIGHT_BRACKET) {
            builder.advanceLexer();
        }
        mark2.collapse((IElementType)SqlTokens.SQL_RAW_INPUT);
        exprMark.done((IElementType)SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT);
        return true;
    }

    public static boolean parseUUIDLiteral(PsiBuilder builder, int level) {
        IElementType type = builder.getTokenType();
        if (!CassGeneratedParserUtil.isUUIDType(type)) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        StringBuilder sb = new StringBuilder();
        int uuidLength = 36;
        sb.append(builder.getTokenText());
        while (sb.length() < uuidLength) {
            if (!CassGeneratedParserUtil.isUUIDType(builder.rawLookup(1))) {
                return false;
            }
            builder.advanceLexer();
            sb.append(builder.getTokenText());
        }
        if (sb.length() == uuidLength && uuidPattern.matcher(sb.toString()).matches()) {
            builder.advanceLexer();
            mark2.collapse((IElementType)CassTokens.CASS_UUID_TOKEN);
            return true;
        }
        return false;
    }

    private static boolean isUUIDType(IElementType type) {
        return type == SqlTokens.SQL_INTEGER_TOKEN || type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_OP_MINUS || type == SqlTokens.SQL_FLOAT_TOKEN;
    }

    public static boolean parseDurationLiteral(PsiBuilder builder, int level) {
        return CassGeneratedParserUtil.parseCassandraDuration(builder) || CassGeneratedParserUtil.parseIso8601(builder) || CassGeneratedParserUtil.parseIso8601Alt(builder);
    }

    private static boolean parseIso8601Alt(PsiBuilder builder) {
        if (builder.getTokenType() != SqlTokens.SQL_IDENT) {
            return false;
        }
        String text = builder.getTokenText();
        if (text == null) {
            return false;
        }
        if (!CassGeneratedParserUtil.isBeginningOfIso8601Alt(text)) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        if (!CassGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_OP_MINUS)) {
            return false;
        }
        if (!CassGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_OP_MINUS)) {
            return false;
        }
        if (builder.rawLookup(1) != SqlTokens.SQL_IDENT) {
            return false;
        }
        builder.advanceLexer();
        text = builder.getTokenText();
        if (text == null || text.length() != 3 || text.charAt(0) != 'T' || !CassGeneratedParserUtil.isInteger(text, 1)) {
            return false;
        }
        if (!CassGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_COLON)) {
            return false;
        }
        if (!CassGeneratedParserUtil.isTwoDigitsPart(builder, SqlTokens.SQL_COLON)) {
            return false;
        }
        builder.advanceLexer();
        mark2.collapse((IElementType)CassTokens.CASS_DURATION_TOKEN);
        return true;
    }

    @Contract(mutates="param1")
    private static boolean isTwoDigitsPart(PsiBuilder builder, SqlTokenType delimiterToken) {
        if (builder.rawLookup(1) != delimiterToken) {
            return false;
        }
        if (builder.rawLookup(2) != SqlTokens.SQL_INTEGER_TOKEN) {
            return false;
        }
        builder.advanceLexer();
        builder.advanceLexer();
        String text = builder.getTokenText();
        if (text == null) {
            return false;
        }
        return text.length() == 2;
    }

    private static boolean isInteger(String text, int offset) {
        for (int i2 = offset; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isBeginningOfIso8601Alt(@NotNull String text) {
        if (text == null) {
            CassGeneratedParserUtil.$$$reportNull$$$0(0);
        }
        if (text.length() != 5) {
            return false;
        }
        if (text.charAt(0) != 'P') {
            return false;
        }
        return CassGeneratedParserUtil.isInteger(text, 1);
    }

    private static boolean parseIso8601(PsiBuilder builder) {
        if (builder.getTokenType() != SqlTokens.SQL_IDENT) {
            return false;
        }
        String text = builder.getTokenText();
        if (text == null || text.charAt(0) != 'P') {
            return false;
        }
        if (!iso8601Pattern.matcher(text).matches() && !iso8601Weeks.matcher(text).matches()) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        builder.advanceLexer();
        mark2.collapse((IElementType)CassTokens.CASS_DURATION_TOKEN);
        return true;
    }

    private static boolean parseCassandraDuration(PsiBuilder builder) {
        if (builder.getTokenType() != SqlTokens.SQL_INTEGER_TOKEN) {
            return false;
        }
        if (builder.rawLookup(1) != SqlTokens.SQL_IDENT) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        String number = builder.getTokenText();
        builder.advanceLexer();
        String durationLiteral = number + builder.getTokenText();
        if (durationPattern.matcher(durationLiteral).matches()) {
            builder.advanceLexer();
            mark2.collapse((IElementType)CassTokens.CASS_DURATION_TOKEN);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/dialects/cassandra/CassGeneratedParserUtil", "isBeginningOfIso8601Alt"));
    }
}

