/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse.psi;

import com.intellij.database.dialects.clickhouse.types.CHouseLowCardinalityType;
import com.intellij.database.dialects.clickhouse.types.CHouseNullableType;
import com.intellij.database.types.DasType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseColumnDefinition
extends SqlColumnDefinitionImpl {
    public CHouseColumnDefinition(@NotNull ASTNode node) {
        if (node == null) {
            CHouseColumnDefinition.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public CHouseColumnDefinition(SqlColumnStub stub) {
        super(stub);
    }

    @Override
    @Nullable
    protected String calcName() {
        boolean qualified;
        SqlNameElement element = this.getNameElement();
        if (element == null) {
            return null;
        }
        String outer = this.getOuterName();
        boolean bl = qualified = element instanceof SqlReferenceExpression && ((SqlReferenceExpression)element).getQualifierExpression() != null;
        if (outer == null && !qualified) {
            return element.getName();
        }
        StringBuilder name2 = new StringBuilder();
        if (outer != null) {
            name2.append(outer);
        }
        CHouseColumnDefinition.appendQualification(name2, element);
        return name2.toString();
    }

    @Nullable
    private String getOuterName() {
        SqlColumnDefinition def;
        if (this.getStub() == null) {
            PsiElement parent = this.getParent();
            parent = parent == null ? null : parent.getParent();
            def = (SqlColumnDefinition)ObjectUtils.tryCast((Object)parent, SqlColumnDefinition.class);
        } else {
            def = (SqlColumnDefinition)ObjectUtils.tryCast((Object)SqlImplUtil.getStubOrPsiParent((PsiElement)this), SqlColumnDefinition.class);
        }
        return def == null ? null : def.getName();
    }

    private static void appendQualification(StringBuilder name2, SqlNameElement element) {
        SqlNameElement qualifier;
        SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element, SqlReferenceExpression.class);
        SqlNameElement sqlNameElement = qualifier = ref2 != null ? (SqlNameElement)ObjectUtils.tryCast((Object)ref2.getQualifierExpression(), SqlNameElement.class) : null;
        if (qualifier != null) {
            CHouseColumnDefinition.appendQualification(name2, qualifier);
        }
        if (name2.length() != 0) {
            name2.append(".");
        }
        name2.append(element.getName());
    }

    @Override
    public boolean isNotNull() {
        DasType dasType = this.getDasType();
        if (dasType instanceof CHouseLowCardinalityType) {
            dasType = ((CHouseLowCardinalityType)dasType).getInnerType();
        }
        return !(dasType instanceof CHouseNullableType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/clickhouse/psi/CHouseColumnDefinition", "<init>"));
    }
}

