/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.support;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.impl.support.SqlCommenter;
import com.intellij.util.PairConsumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNestedCommenter
extends SqlCommenter
implements SelfManagingCommenter {
    public static final String LINE_PREFIX_NO_SPACE = "--";

    @Nullable
    public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SqlNestedCommenter.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SqlNestedCommenter.$$$reportNull$$$0(3);
        }
        return null;
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(4);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(5);
        }
        document.insertString(offset, (CharSequence)"-- ");
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(6);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(7);
        }
        if (offset == 0 && line > 0) {
            return;
        }
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)LINE_PREFIX_NO_SPACE)) {
            boolean extra = CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)"-- ");
            document.deleteString(offset, offset + LINE_PREFIX_NO_SPACE.length() + (extra ? 1 : 0));
        }
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(8);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(9);
        }
        CharSequence sequence = document.getCharsSequence();
        return CharArrayUtil.regionMatches((CharSequence)sequence, (int)offset, (CharSequence)LINE_PREFIX_NO_SPACE);
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(10);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(11);
        }
        return this.getLineCommentPrefix();
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(12);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(13);
        }
        return SelfManagingCommenterUtil.getBlockCommentRange((int)selectionStart, (int)selectionEnd, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(14);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(15);
        }
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            SqlNestedCommenter.$$$reportNull$$$0(16);
        }
        if (data == null) {
            SqlNestedCommenter.$$$reportNull$$$0(17);
        }
        return this.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        ArrayList ranges = new ArrayList();
        this.walkRanges(document.getText(), startOffset, endOffset, (PairConsumer<Integer, Integer>)((PairConsumer)(o, c2) -> {
            ranges.add(TextRange.from((int)o, (int)2));
            ranges.add(TextRange.from((int)(c2 - 2), (int)2));
        }));
        for (int i2 = ranges.size() - 1; i2 >= 0; --i2) {
            TextRange range = (TextRange)ranges.get(i2);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        TextRange textRange = SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
        if (textRange == null) {
            SqlNestedCommenter.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    public void walkRanges(@NotNull CharSequence text, int from, int to, PairConsumer<Integer, Integer> consumer) {
        if (text == null) {
            SqlNestedCommenter.$$$reportNull$$$0(19);
        }
        int o = from;
        while (true) {
            int c2;
            int n = c2 = (o = this.findOpen(o, to, text)) == -1 ? -1 : this.skipBalanced(o, to, text);
            if (c2 == -1) break;
            consumer.consume((Object)o, (Object)c2);
            o = c2;
        }
    }

    private int skipBalanced(int from, int to, CharSequence text) {
        assert (this.findOpen(from, to, text) == from);
        int balance = 1;
        int o = this.findOpen(from + 2, to, text);
        int c2 = this.findClose(from + 2, to, text);
        while (c2 != -1) {
            boolean close;
            boolean bl = close = o == -1 || c2 < o;
            if (close) {
                if (--balance == 0) {
                    return c2 + 2;
                }
                if (o < c2 + 2) {
                    o = this.findOpen(c2 + 2, to, text);
                }
                c2 = this.findClose(c2 + 2, to, text);
                continue;
            }
            ++balance;
            if (c2 < o + 2) {
                c2 = this.findClose(o + 2, to, text);
            }
            o = this.findOpen(o + 2, to, text);
        }
        return -1;
    }

    private int findOpen(int from, int to, CharSequence text) {
        return StringUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentPrefix(), (int)from, (int)to);
    }

    private int findClose(int from, int to, CharSequence text) {
        return StringUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentSuffix(), (int)from, (int)to);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/support/SqlNestedCommenter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/support/SqlNestedCommenter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBlockComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentingState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentingState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commentLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uncommentLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommented";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentPrefix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentSuffix";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "walkRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }
}

