/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class StringUtils {
    public static String clean(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String deleteWhitespace(String str) {
        StringBuilder buffer = new StringBuilder();
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            buffer.append(str.charAt(i2));
        }
        return buffer.toString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    @Deprecated
    public static boolean equals(String str1, String str2) {
        return Objects.equals(str1, str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static int indexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        for (String searchStr : searchStrs) {
            int tmp = str.indexOf(searchStr);
            if (tmp == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int lastIndexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = -1;
        for (String searchStr : searchStrs) {
            int tmp = str.lastIndexOf(searchStr);
            if (tmp <= ret) continue;
            ret = tmp;
        }
        return ret;
    }

    public static String substring(String str, int start2) {
        if (str == null) {
            return null;
        }
        if (start2 < 0) {
            start2 = str.length() + start2;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        if (start2 > str.length()) {
            return "";
        }
        return str.substring(start2);
    }

    public static String substring(String str, int start2, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start2 < 0) {
            start2 = str.length() + start2;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start2 > end) {
            return "";
        }
        if (start2 < 0) {
            start2 = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start2, end);
    }

    public static String left(String str, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str == null || str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str == null || str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (pos < 0 || str != null && pos > str.length()) {
            throw new StringIndexOutOfBoundsException("String index " + pos + " is out of bounds");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str == null) {
            return null;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null, -1);
    }

    public static String[] split(String text, String separator) {
        return StringUtils.split(text, separator, -1);
    }

    public static String[] split(String str, String separator, int max) {
        StringTokenizer tok2 = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok2.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i2 = 0;
        int lastTokenEnd = 0;
        while (tok2.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i2 == listSize - 1) {
                String endToken = tok2.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list[i2] = str.substring(lastTokenBegin);
                break;
            }
            list[i2] = tok2.nextToken();
            lastTokenBegin = str.indexOf(list[i2], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i2].length();
            ++i2;
        }
        return list;
    }

    public static String concatenate(Object[] array) {
        return StringUtils.join(array, "");
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : (array[0].toString().length() + separator.length()) * arraySize;
        StringBuilder buf = new StringBuilder(bufSize);
        for (int i2 = 0; i2 < arraySize; ++i2) {
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(array[i2]);
        }
        return buf.toString();
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (separator == null) {
            separator = "";
        }
        StringBuilder buf = new StringBuilder(256);
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String replaceOnce(String text, char repl, char with) {
        return StringUtils.replace(text, repl, with, 1);
    }

    public static String replace(String text, char repl, char with) {
        return StringUtils.replace(text, repl, with, -1);
    }

    public static String replace(String text, char repl, char with, int max) {
        return StringUtils.replace(text, String.valueOf(repl), String.valueOf(with), max);
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        int end;
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start2 = 0;
        while ((end = text.indexOf(repl, start2)) != -1) {
            buf.append(text, start2, end).append(with);
            start2 = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text, start2, text.length());
        return buf.toString();
    }

    public static String overlayString(String text, String overlay, int start2, int end) {
        return new StringBuilder(start2 + overlay.length() + text.length() - end + 1).append(text, 0, start2).append(overlay).append(text, end, text.length()).toString();
    }

    public static String center(String str, int size) {
        return StringUtils.center(str, size, " ");
    }

    public static String center(String str, int size, String delim) {
        int sz = str.length();
        int p2 = size - sz;
        if (p2 < 1) {
            return str;
        }
        str = StringUtils.leftPad(str, sz + p2 / 2, delim);
        str = StringUtils.rightPad(str, size, delim);
        return str;
    }

    public static String chomp(String str) {
        return StringUtils.chomp(str, "\n");
    }

    public static String chomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx);
        }
        return str;
    }

    public static String chompLast(String str) {
        return StringUtils.chompLast(str, "\n");
    }

    public static String chompLast(String str, String sep) {
        if (str.length() == 0) {
            return str;
        }
        String sub = str.substring(str.length() - sep.length());
        if (sep.equals(sub)) {
            return str.substring(0, str.length() - sep.length());
        }
        return str;
    }

    public static String getChomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx == str.length() - sep.length()) {
            return sep;
        }
        if (idx != -1) {
            return str.substring(idx);
        }
        return "";
    }

    public static String prechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(idx + sep.length());
        }
        return str;
    }

    public static String getPrechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx + sep.length());
        }
        return "";
    }

    public static String chop(String str) {
        if ("".equals(str)) {
            return "";
        }
        if (str.length() == 1) {
            return "";
        }
        int lastIdx = str.length() - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String chopNewline(String str) {
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String escape(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(2 * sz);
        block12: for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (ch > '\u0fff') {
                buffer.append("\\u" + Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u00ff') {
                buffer.append("\\u0" + Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u007f') {
                buffer.append("\\u00" + Integer.toHexString(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00" + Integer.toHexString(ch));
                            break;
                        }
                        buffer.append("\\u000" + Integer.toHexString(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block12;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block12;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block12;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String repeat(String str, int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i2 = 0; i2 < repeat; ++i2) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, " ");
    }

    public static String rightPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = str + StringUtils.repeat(delim, size);
        }
        return str;
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, " ");
    }

    public static String leftPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = StringUtils.repeat(delim, size) + str;
        }
        return str;
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String delim) {
        str = StringUtils.stripStart(str, delim);
        return StringUtils.stripEnd(str, delim);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String delimiter) {
        if (strs == null || strs.length == 0) {
            return strs;
        }
        int sz = strs.length;
        String[] newArr = new String[sz];
        for (int i2 = 0; i2 < sz; ++i2) {
            newArr[i2] = StringUtils.strip(strs[i2], delimiter);
        }
        return newArr;
    }

    public static String stripEnd(String str, String strip) {
        int end;
        if (str == null) {
            return null;
        }
        if (strip == null) {
            for (end = str.length(); end != 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
            }
        } else {
            while (end != 0 && strip.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String stripStart(String str, String strip) {
        int start2;
        if (str == null) {
            return null;
        }
        int sz = str.length();
        if (strip == null) {
            for (start2 = 0; start2 != sz && Character.isWhitespace(str.charAt(start2)); ++start2) {
            }
        } else {
            while (start2 != sz && strip.indexOf(str.charAt(start2)) != -1) {
                ++start2;
            }
        }
        return str.substring(start2);
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String uncapitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        return new StringBuilder(str.length()).append(Character.toLowerCase(str.charAt(0))).append(str, 1, str.length()).toString();
    }

    public static String capitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        return new StringBuilder(str.length()).append(Character.toTitleCase(str.charAt(0))).append(str, 1, str.length()).toString();
    }

    public static String swapCase(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean whitespace = false;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            char tmp = Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isTitleCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? (whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch)) : ch));
            buffer.append(tmp);
            whitespace = Character.isWhitespace(ch);
        }
        return buffer.toString();
    }

    public static String capitaliseAllWords(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String uncapitaliseAllWords(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toLowerCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String getNestedString(String str, String tag) {
        return StringUtils.getNestedString(str, tag, tag);
    }

    public static String getNestedString(String str, String open, String close) {
        int end;
        if (str == null) {
            return null;
        }
        int start2 = str.indexOf(open);
        if (start2 != -1 && (end = str.indexOf(close, start2 + open.length())) != -1) {
            return str.substring(start2 + open.length(), end);
        }
        return null;
    }

    public static int countMatches(String str, String sub) {
        if (sub.equals("")) {
            return 0;
        }
        if (str == null) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetter(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetter(str.charAt(i2)) || str.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetterOrDigit(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetterOrDigit(str.charAt(i2)) || str.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isDigit(str.charAt(i2)) || str.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String defaultString(Object obj2) {
        return StringUtils.defaultString(obj2, "");
    }

    @Deprecated
    public static String defaultString(Object obj2, String defaultString) {
        return Objects.toString(obj2, defaultString);
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String reverseDelimitedString(String str, String delimiter) {
        Object[] strs = StringUtils.split(str, delimiter);
        StringUtils.reverseArray(strs);
        return StringUtils.join(strs, delimiter);
    }

    private static void reverseArray(Object[] array) {
        int i2 = 0;
        for (int j = array.length - 1; j > i2; --j, ++i2) {
            Object tmp = array[j];
            array[j] = array[i2];
            array[i2] = tmp;
        }
    }

    public static String abbreviate(String s, int maxWidth) {
        return StringUtils.abbreviate(s, 0, maxWidth);
    }

    public static String abbreviate(String s, int offset, int maxWidth) {
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (s.length() <= maxWidth) {
            return s;
        }
        if (offset > s.length()) {
            offset = s.length();
        }
        if (s.length() - offset < maxWidth - 3) {
            offset = s.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return s.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < s.length()) {
            return "..." + StringUtils.abbreviate(s.substring(offset), maxWidth - 3);
        }
        return "..." + s.substring(s.length() - (maxWidth - 3));
    }

    public static String difference(String s1, String s2) {
        int at = StringUtils.differenceAt(s1, s2);
        if (at == -1) {
            return "";
        }
        return s2.substring(at);
    }

    public static int differenceAt(String s1, String s2) {
        int i2;
        for (i2 = 0; i2 < s1.length() && i2 < s2.length() && s1.charAt(i2) == s2.charAt(i2); ++i2) {
        }
        if (i2 < s2.length() || i2 < s1.length()) {
            return i2;
        }
        return -1;
    }

    public static String interpolate(String text, Map<?, ?> namespace) {
        Iterator<?> keys = namespace.keySet().iterator();
        while (keys.hasNext()) {
            String key2 = keys.next().toString();
            Object obj2 = namespace.get(key2);
            if (obj2 == null) {
                throw new NullPointerException("The value of the key '" + key2 + "' is null.");
            }
            String value = obj2.toString();
            text = StringUtils.replace(text, "${" + key2 + "}", value);
            if (key2.contains(" ")) continue;
            text = StringUtils.replace(text, "$" + key2, value);
        }
        return text;
    }

    public static String removeAndHump(String data, String replaceThis) {
        StringBuilder out = new StringBuilder();
        String temp = data;
        StringTokenizer st = new StringTokenizer(temp, replaceThis);
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(StringUtils.capitalizeFirstLetter(element));
        }
        return out.toString();
    }

    public static String capitalizeFirstLetter(String data) {
        char firstLetter = Character.toTitleCase(data.substring(0, 1).charAt(0));
        String restLetters = data.substring(1);
        return firstLetter + restLetters;
    }

    public static String lowercaseFirstLetter(String data) {
        char firstLetter = Character.toLowerCase(data.substring(0, 1).charAt(0));
        String restLetters = data.substring(1);
        return firstLetter + restLetters;
    }

    public static String addAndDeHump(String view) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < view.length(); ++i2) {
            if (i2 != 0 && Character.isUpperCase(view.charAt(i2))) {
                sb.append('-');
            }
            sb.append(view.charAt(i2));
        }
        return sb.toString().trim().toLowerCase(Locale.ENGLISH);
    }

    public static String quoteAndEscape(String source, char quoteChar) {
        return StringUtils.quoteAndEscape(source, quoteChar, new char[]{quoteChar}, new char[]{' '}, '\\', false);
    }

    public static String quoteAndEscape(String source, char quoteChar, char[] quotingTriggers) {
        return StringUtils.quoteAndEscape(source, quoteChar, new char[]{quoteChar}, quotingTriggers, '\\', false);
    }

    public static String quoteAndEscape(String source, char quoteChar, char[] escapedChars, char escapeChar, boolean force) {
        return StringUtils.quoteAndEscape(source, quoteChar, escapedChars, new char[]{' '}, escapeChar, force);
    }

    public static String quoteAndEscape(String source, char quoteChar, char[] escapedChars, char[] quotingTriggers, char escapeChar, boolean force) {
        return StringUtils.quoteAndEscape(source, quoteChar, escapedChars, quotingTriggers, escapeChar + "%s", force);
    }

    public static String quoteAndEscape(String source, char quoteChar, char[] escapedChars, char[] quotingTriggers, String escapePattern, boolean force) {
        if (source == null) {
            return null;
        }
        if (!force && source.startsWith(Character.toString(quoteChar)) && source.endsWith(Character.toString(quoteChar))) {
            return source;
        }
        String escaped = StringUtils.escape(source, escapedChars, escapePattern);
        boolean quote = false;
        if (force) {
            quote = true;
        } else if (!escaped.equals(source)) {
            quote = true;
        } else {
            for (char quotingTrigger : quotingTriggers) {
                if (escaped.indexOf(quotingTrigger) <= -1) continue;
                quote = true;
                break;
            }
        }
        if (quote) {
            return quoteChar + escaped + quoteChar;
        }
        return escaped;
    }

    public static String escape(String source, char[] escapedChars, char escapeChar) {
        return StringUtils.escape(source, escapedChars, escapeChar + "%s");
    }

    public static String escape(String source, char[] escapedChars, String escapePattern) {
        if (source == null) {
            return null;
        }
        char[] eqc = new char[escapedChars.length];
        System.arraycopy(escapedChars, 0, eqc, 0, escapedChars.length);
        Arrays.sort(eqc);
        StringBuilder buffer = new StringBuilder(source.length());
        for (int i2 = 0; i2 < source.length(); ++i2) {
            char c2 = source.charAt(i2);
            int result2 = Arrays.binarySearch(eqc, c2);
            if (result2 > -1) {
                buffer.append(String.format(escapePattern, Character.valueOf(c2)));
                continue;
            }
            buffer.append(c2);
        }
        return buffer.toString();
    }

    public static String removeDuplicateWhitespace(String s) {
        StringBuilder result2 = new StringBuilder();
        int length = s.length();
        boolean isPreviousWhiteSpace = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s.charAt(i2);
            boolean thisCharWhiteSpace = Character.isWhitespace(c2);
            if (!isPreviousWhiteSpace || !thisCharWhiteSpace) {
                result2.append(c2);
            }
            isPreviousWhiteSpace = thisCharWhiteSpace;
        }
        return result2.toString();
    }

    public static String unifyLineSeparators(String s) {
        return StringUtils.unifyLineSeparators(s, System.getProperty("line.separator"));
    }

    public static String unifyLineSeparators(String s, String ls) {
        if (s == null) {
            return null;
        }
        if (ls == null) {
            ls = System.getProperty("line.separator");
        }
        if (!(ls.equals("\n") || ls.equals("\r") || ls.equals("\r\n"))) {
            throw new IllegalArgumentException("Requested line separator is invalid.");
        }
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (s.charAt(i2) == '\r') {
                if (i2 + 1 < length && s.charAt(i2 + 1) == '\n') {
                    ++i2;
                }
                buffer.append(ls);
                continue;
            }
            if (s.charAt(i2) == '\n') {
                buffer.append(ls);
                continue;
            }
            buffer.append(s.charAt(i2));
        }
        return buffer.toString();
    }

    public static boolean contains(String str, char searchChar) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.contains(searchStr);
    }
}

