/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingGroupBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingItem;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalUsageData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cH\u0002R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0094\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalUsageData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myFeedbackReportId", "", "getMyFeedbackReportId", "()Ljava/lang/String;", "myTitle", "getMyTitle", "mySystemInfoData", "getMySystemInfoData", "()Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalUsageData;", "mySystemInfoData$delegate", "Lkotlin/Lazy;", "myShowFeedbackSystemInfoDialog", "Lkotlin/Function0;", "", "getMyShowFeedbackSystemInfoDialog$annotations", "()V", "getMyShowFeedbackSystemInfoDialog", "()Lkotlin/jvm/functions/Function0;", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "createRatingItems", "Lcom/intellij/platform/feedback/dialog/uiBlocks/RatingItem;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalFeedbackDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalFeedbackDialog.kt\norg/jetbrains/plugins/terminal/block/feedback/BlockTerminalFeedbackDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n24#2:103\n*S KotlinDebug\n*F\n+ 1 BlockTerminalFeedbackDialog.kt\norg/jetbrains/plugins/terminal/block/feedback/BlockTerminalFeedbackDialog\n*L\n29#1:103\n*E\n"})
public final class BlockTerminalFeedbackDialog
extends BlockBasedFeedbackDialog<BlockTerminalUsageData> {
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final Lazy mySystemInfoData$delegate;
    @NotNull
    private final Function0<Unit> myShowFeedbackSystemInfoDialog;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public BlockTerminalFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        this.myFeedbackReportId = "new_terminal";
        String string = TerminalBundle.message("feedback.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myTitle = string;
        this.mySystemInfoData$delegate = LazyKt.lazy(() -> BlockTerminalFeedbackDialog.mySystemInfoData_delegate$lambda$0(forTest, this, project));
        this.myShowFeedbackSystemInfoDialog = () -> BlockTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$5(this);
        Object[] objectArray = new FeedbackBlock[4];
        String string2 = TerminalBundle.message("feedback.dialog.header", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[0] = new TopLabelBlock(string2);
        String string3 = TerminalBundle.message("feedback.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[1] = new DescriptionBlock(string3);
        String string4 = TerminalBundle.message("feedback.dialog.rating.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        RatingGroupBlock ratingGroupBlock = new RatingGroupBlock(string4, this.createRatingItems());
        String string5 = TerminalBundle.message("feedback.dialog.rating.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[2] = ratingGroupBlock.setHint(string5).setRandomOrder(true);
        String string6 = TerminalBundle.message("feedback.dialog.other", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        TextAreaBlock textAreaBlock = new TextAreaBlock(string6, "other");
        String string7 = TerminalBundle.message("feedback.dialog.other.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        objectArray[3] = textAreaBlock.setPlaceholder(string7);
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected BlockTerminalUsageData getMySystemInfoData() {
        Lazy lazy = this.mySystemInfoData$delegate;
        return (BlockTerminalUsageData)lazy.getValue();
    }

    @NotNull
    protected Function0<Unit> getMyShowFeedbackSystemInfoDialog() {
        return this.myShowFeedbackSystemInfoDialog;
    }

    protected static /* synthetic */ void getMyShowFeedbackSystemInfoDialog$annotations() {
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    private final List<RatingItem> createRatingItems() {
        Object[] objectArray = new RatingItem[3];
        String string = TerminalBundle.message("feedback.dialog.rating.interface", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new RatingItem(string, "interface");
        String string2 = TerminalBundle.message("feedback.dialog.rating.feature.set", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = new RatingItem(string2, "feature_set");
        String string3 = TerminalBundle.message("feedback.dialog.rating.performance", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[2] = new RatingItem(string3, "performance");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final BlockTerminalUsageData mySystemInfoData_delegate$lambda$0(boolean $forTest, BlockTerminalFeedbackDialog this$0, Project $project) {
        String string;
        TerminalUsageLocalStorage usageStorage = TerminalUsageLocalStorage.Companion.getInstance();
        String rawMostUsedShell = usageStorage.getMostUsedShell();
        if (rawMostUsedShell == null && $forTest) {
            BlockTerminalFeedbackDialog $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BlockTerminalFeedbackDialog.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No information about most used shell, because no commands were executed in the terminal");
            string = "none";
        } else {
            String string2 = rawMostUsedShell;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String mostUsedShell = string;
        return new BlockTerminalUsageData(mostUsedShell, usageStorage.getExecutedCommandsNumber(), BlockTerminalFeedbackSurveyKt.getFeedbackMoment($project), CommonFeedbackSystemData.Companion.getCurrentData());
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$5$lambda$4$lambda$1(BlockTerminalFeedbackDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.getMySystemInfoData().getMostUsedShell());
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$5$lambda$4$lambda$2(BlockTerminalFeedbackDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getExecutedCommandsNumber()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$5$lambda$4$lambda$3(BlockTerminalFeedbackDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.getMySystemInfoData().getFeedbackMoment().toString());
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$5$lambda$4(BlockTerminalFeedbackDialog this$0, Panel $this$showFeedbackSystemInfoDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
        String string = TerminalBundle.message("feedback.system.info.shell", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string, arg_0 -> BlockTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$5$lambda$4$lambda$1(this$0, arg_0));
        String string2 = TerminalBundle.message("feedback.system.info.commands.number", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string2, arg_0 -> BlockTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$5$lambda$4$lambda$2(this$0, arg_0));
        String string3 = TerminalBundle.message("feedback.system.info.moment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string3, arg_0 -> BlockTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$5$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$5(BlockTerminalFeedbackDialog this$0) {
        BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)this$0.getMyProject(), (CommonFeedbackSystemData)this$0.getMySystemInfoData().getSystemInfo(), arg_0 -> BlockTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

