/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCommandsSupport;
import com.intellij.platform.lsp.impl.completion.LspCompletionItemInsertHandlerKt;
import com.intellij.platform.lsp.impl.completion.SnippetToTemplateConverter;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/lsp/impl/completion/LspCompletionItemInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "LspCompletionItemInsertHandler", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "lookupElement", "Q", "S", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspCompletionItemInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspCompletionItemInsertHandler.kt\ncom/intellij/platform/lsp/impl/completion/LspCompletionItemInsertHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1#2:179\n774#3:180\n865#3,2:181\n*S KotlinDebug\n*F\n+ 1 LspCompletionItemInsertHandler.kt\ncom/intellij/platform/lsp/impl/completion/LspCompletionItemInsertHandler\n*L\n35#1:180\n35#1:181,2\n*E\n"})
public final class LspCompletionItemInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final LspCompletionItemInsertHandler INSTANCE = new LspCompletionItemInsertHandler();

    private LspCompletionItemInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
            this.Q(context, lookupElement);
            LookupElementDecorator lookupElementDecorator = lookupElement instanceof LookupElementDecorator ? (LookupElementDecorator)lookupElement : null;
            if (lookupElementDecorator != null && (lookupElementDecorator = lookupElementDecorator.getDelegate()) != null) {
                lookupElementDecorator.handleInsert(context);
            }
            this.S(context, lookupElement);
            CompletionItem completionItem = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
            if (completionItem == null || (completionItem = completionItem.getCommand()) == null) break block2;
            CompletionItem completionItem2 = completionItem;
            boolean bl = false;
            LspServer lspServer = LspCompletionItemInsertHandlerKt.access$getLspServer(lookupElement);
            Object object = lspServer;
            if (object != null && (object = object.getDescriptor()) != null && (object = ((LspServerDescriptor)object).getLspCommandsSupport()) != null) {
                VirtualFile virtualFile = context.getFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                ((LspCommandsSupport)object).executeCommand(lspServer, virtualFile, (Command)completionItem2);
            }
        }
    }

    private final void Q(InsertionContext insertionContext, LookupElement lookupElement) {
        CompletionItem completionItem;
        Object object;
        block6: {
            block5: {
                Object object2 = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
                if (object2 == null || (object2 = object2.getAdditionalTextEdits()) == null) {
                    return;
                }
                object = object2;
                completionItem = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
                if (completionItem == null || (completionItem = completionItem.getTextEdit()) == null) break block5;
                CompletionItem completionItem2 = completionItem;
                boolean bl = false;
                Range range = completionItem2.isLeft() ? ((TextEdit)completionItem2.getLeft()).getRange() : ((InsertReplaceEdit)completionItem2.getRight()).getInsert();
                completionItem = range;
                if (range != null) break block6;
            }
            return;
        }
        CompletionItem completionItem3 = completionItem;
        Iterable iterable = (Iterable)object;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            TextEdit textEdit = (TextEdit)t2;
            boolean bl3 = false;
            if (!(completionItem3.getStart().getLine() - textEdit.getRange().getStart().getLine() > 0 || completionItem3.getStart().getCharacter() - textEdit.getRange().getStart().getCharacter() > 0)) continue;
            collection.add(t2);
        }
        List list = (List)collection;
        boolean bl4 = false;
        Document document = insertionContext.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Lsp4jUtilKt.applyTextEdits(document, list);
    }

    private final void S(InsertionContext insertionContext, LookupElement lookupElement) {
        CompletionItem completionItem = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
        if ((completionItem != null ? completionItem.getInsertTextFormat() : null) != InsertTextFormat.Snippet) {
            return;
        }
        insertionContext.getDocument().replaceString(insertionContext.getStartOffset(), insertionContext.getTailOffset(), (CharSequence)"");
        TemplateManager templateManager = TemplateManager.getInstance((Project)insertionContext.getProject());
        Editor editor = insertionContext.getEditor();
        Project project = insertionContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = lookupElement.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        templateManager.runTemplate(editor, new SnippetToTemplateConverter(project, string).computeTemplate$intellij_platform_lsp_impl());
    }
}

