/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ContentFolderRef;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ExternalContentFolderRef;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import icons.WebideApiIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class WebIdeProjectStructureConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private static final Color RESOURCES_COLOR = JBColor.MAGENTA;
    private final Module myModule;
    private final JPanel myTopPanel = new JPanel(new BorderLayout());
    protected ModifiableRootModel myModifiableModel;
    protected CommonContentEntriesEditor myEditor;

    public WebIdeProjectStructureConfigurable(Module module) {
        this.myModule = module;
    }

    public String getDisplayName() {
        return WebCoreBundle.message((String)"configurable.WebIdeProjectStructureConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.webide.settings.project.settings.directories";
    }

    public JComponent createComponent() {
        this.c();
        return this.myTopPanel;
    }

    private void c() {
        if (this.myModule == null) {
            return;
        }
        this.myModifiableModel = (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel());
        ModuleConfigurationStateImpl moduleConfigurationStateImpl = new ModuleConfigurationStateImpl(this.myModule.getProject(), (ModulesProvider)new DefaultModulesProvider(this.myModule.getProject())){

            public ModifiableRootModel getModifiableRootModel() {
                return WebIdeProjectStructureConfigurable.this.myModifiableModel;
            }

            public ModuleRootModel getCurrentRootModel() {
                return WebIdeProjectStructureConfigurable.this.myModifiableModel;
            }
        };
        this.myEditor = this.createEditor(this.myModule, (ModuleConfigurationState)moduleConfigurationStateImpl);
        JComponent jComponent = (JComponent)ReadAction.compute(() -> this.myEditor.createComponent());
        this.myTopPanel.add((Component)jComponent, "Center");
    }

    protected CommonContentEntriesEditor createEditor(@NotNull Module module, @NotNull ModuleConfigurationState state) {
        if (module == null) {
            WebIdeProjectStructureConfigurable.Q(0);
        }
        if (state == null) {
            WebIdeProjectStructureConfigurable.Q(1);
        }
        return new MyCommonContentEntriesEditor(module, state, true, new JpsModuleSourceRootType[]{JavaSourceRootType.TEST_SOURCE});
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor == null) {
            return;
        }
        this.myEditor.apply();
        if (this.myModifiableModel.isChanged()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
            this.Q();
        }
    }

    public void reset() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        this.Q();
    }

    private void Q() {
        this.myEditor.disposeUIResources();
        this.myTopPanel.remove(this.myEditor.getComponent());
        this.c();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myTopPanel.remove(this.myEditor.getComponent());
            this.myEditor = null;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
            this.myModifiableModel = null;
        }
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[0];
    }

    @NotNull
    public String getId() {
        return "web-ide.project.structure";
    }

    private static /* synthetic */ void Q(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
        }
        objectArray[1] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable";
        objectArray[2] = "createEditor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class MyCommonContentEntriesEditor
    extends CommonContentEntriesEditor {
        private final MultiMap<ContentEntry, VirtualFilePointer> myResourcesRoots = new MultiMap();
        private Disposable myFilePointersDisposable;
        private final VirtualFilePointerListener DUMMY_LISTENER = new VirtualFilePointerListener(){};

        public MyCommonContentEntriesEditor(Module module, ModuleConfigurationState moduleConfigurationState, boolean withBorders, JpsModuleSourceRootType<?> ... rootTypes) {
            super(module.getName(), moduleConfigurationState, withBorders, rootTypes);
            this.reset();
        }

        protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
            return new MyContentEntryTreeEditor(project, this.getEditHandlers());
        }

        protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
            List list = super.addContentEntries(files);
            this.addContentEntryPanels(list.toArray(new ContentEntry[0]));
            return list;
        }

        public void reset() {
            ContentEntryEditor contentEntryEditor;
            if (this.myFilePointersDisposable != null) {
                Disposer.dispose((Disposable)this.myFilePointersDisposable);
            }
            this.myResourcesRoots.clear();
            this.myFilePointersDisposable = Disposer.newDisposable();
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(this.myProject);
            if (webResourcesPathsConfiguration != null) {
                contentEntryEditor = webResourcesPathsConfiguration.getResourceRoots();
                for (String string : contentEntryEditor.keySet()) {
                    ContentEntry contentEntry = this.Q(string);
                    if (contentEntry == null) continue;
                    for (String string2 : contentEntryEditor.get((Object)string)) {
                        this.myResourcesRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(string2, this.myFilePointersDisposable, this.DUMMY_LISTENER));
                    }
                }
            }
            if (this.myRootTreeEditor != null) {
                contentEntryEditor = this.myRootTreeEditor.getContentEntryEditor();
                if (contentEntryEditor != null) {
                    contentEntryEditor.update();
                }
                this.myRootTreeEditor.update();
            }
        }

        @Nullable
        private ContentEntry Q(String string) {
            for (ContentEntry contentEntry : this.getModel().getContentEntries()) {
                if (!contentEntry.getUrl().equals(string)) continue;
                return contentEntry;
            }
            return null;
        }

        public void disposeUIResources() {
            super.disposeUIResources();
            if (this.myFilePointersDisposable != null) {
                Disposer.dispose((Disposable)this.myFilePointersDisposable);
            }
        }

        public void apply() throws ConfigurationException {
            super.apply();
            MultiMap<String, String> multiMap = this.Q();
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(this.myProject);
            if (webResourcesPathsConfiguration != null) {
                webResourcesPathsConfiguration.setResourceRoots(multiMap);
            }
        }

        private MultiMap<String, String> Q() {
            MultiMap multiMap = new MultiMap();
            for (ContentEntry contentEntry : this.myResourcesRoots.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (VirtualFilePointer virtualFilePointer : this.myResourcesRoots.get((Object)contentEntry)) {
                    arrayList.add(virtualFilePointer.getUrl());
                }
                multiMap.put((Object)contentEntry.getUrl(), arrayList);
            }
            return multiMap;
        }

        public boolean isModified() {
            if (super.isModified()) {
                return true;
            }
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(this.myProject);
            if (webResourcesPathsConfiguration != null) {
                MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
                MultiMap<String, String> multiMap2 = this.Q();
                if (!Comparing.haveEqualElements((Collection)multiMap.keySet(), (Collection)multiMap2.keySet())) {
                    return true;
                }
                for (String string : multiMap.keySet()) {
                    if (Comparing.haveEqualElements((Collection)multiMap.get((Object)string), (Collection)multiMap2.get((Object)string))) continue;
                    return true;
                }
            }
            return false;
        }

        protected MyContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
            return new MyContentEntryEditor(contentEntryUrl, this.getEditHandlers());
        }

        protected class MyContentEntryEditor
        extends ContentEntryEditor {
            private final EventDispatcher<ChangeListener> myEventDispatcher;

            public MyContentEntryEditor(String contentEntryUrl, List<ModuleSourceRootEditHandler<?>> handlers) {
                super(contentEntryUrl, handlers);
                this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
            }

            protected ModifiableRootModel getModel() {
                return MyCommonContentEntriesEditor.this.getModel();
            }

            public void addListener(ChangeListener changeListener) {
                this.myEventDispatcher.addListener((EventListener)changeListener);
            }

            public void removeListener(ChangeListener changeListener) {
                this.myEventDispatcher.removeListener((EventListener)changeListener);
            }

            protected ContentRootPanel createContentRootPane() {
                return new MyContentRootPanel();
            }

            public void deleteContentFolder(ContentEntry contentEntry, ContentFolderRef folder) {
                if (folder instanceof ExternalContentFolderRef) {
                    this.removeResourceRoot(folder.getUrl());
                } else {
                    super.deleteContentFolder(contentEntry, folder);
                }
            }

            public void addResourceRoot(@NotNull VirtualFile file) {
                if (file == null) {
                    MyContentEntryEditor.Q(0);
                }
                VirtualFilePointer virtualFilePointer = VirtualFilePointerManager.getInstance().create(file, MyCommonContentEntriesEditor.this.myFilePointersDisposable, MyCommonContentEntriesEditor.this.DUMMY_LISTENER);
                MyCommonContentEntriesEditor.this.myResourcesRoots.putValue((Object)this.getContentEntry(), (Object)virtualFilePointer);
                ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
                this.update();
            }

            public void removeResourceRoot(@NotNull String url) {
                VirtualFilePointer virtualFilePointer;
                if (url == null) {
                    MyContentEntryEditor.Q(1);
                }
                if ((virtualFilePointer = this.getResourceRoot(url)) != null) {
                    MyCommonContentEntriesEditor.this.myResourcesRoots.remove((Object)this.getContentEntry(), (Object)virtualFilePointer);
                    ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
                    this.update();
                }
            }

            public boolean hasResourceRoot(@NotNull VirtualFile file) {
                if (file == null) {
                    MyContentEntryEditor.Q(2);
                }
                return this.getResourceRoot(file.getUrl()) != null;
            }

            @Nullable
            public VirtualFilePointer getResourceRoot(@NotNull String url) {
                if (url == null) {
                    MyContentEntryEditor.Q(3);
                }
                for (VirtualFilePointer virtualFilePointer : MyCommonContentEntriesEditor.this.myResourcesRoots.get((Object)this.getContentEntry())) {
                    if (!Objects.equals(virtualFilePointer.getUrl(), url)) continue;
                    return virtualFilePointer;
                }
                return null;
            }

            private static /* synthetic */ void Q(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "url";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addResourceRoot";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeResourceRoot";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasResourceRoot";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getResourceRoot";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            protected class MyContentRootPanel
            extends ContentRootPanel {
                public MyContentRootPanel() {
                    super((ContentRootPanel.ActionCallback)MyContentEntryEditor.this, MyContentEntryEditor.this.getEditHandlers());
                }

                @NotNull
                protected ContentEntry getContentEntry() {
                    ContentEntry contentEntry = MyContentEntryEditor.this.getContentEntry();
                    if (contentEntry == null) {
                        MyContentRootPanel.Q(0);
                    }
                    return contentEntry;
                }

                protected void addFolderGroupComponents() {
                    super.addFolderGroupComponents();
                    if (!MyCommonContentEntriesEditor.this.myResourcesRoots.get((Object)this.getContentEntry()).isEmpty()) {
                        ArrayList<ExternalContentFolderRef> arrayList = new ArrayList<ExternalContentFolderRef>(MyCommonContentEntriesEditor.this.myResourcesRoots.size());
                        for (VirtualFilePointer virtualFilePointer : MyCommonContentEntriesEditor.this.myResourcesRoots.get((Object)this.getContentEntry())) {
                            arrayList.add(new ExternalContentFolderRef(virtualFilePointer));
                        }
                        JComponent jComponent = this.createFolderGroupComponent(WebCoreBundle.message((String)"resource.root.path.component.title", (Object[])new Object[0]), arrayList, RESOURCES_COLOR, null);
                        this.add(jComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
                    }
                }

                private static /* synthetic */ void Q(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor$MyContentRootPanel", "getContentEntry"));
                }
            }
        }
    }

    static final class OptionContributor
    extends SearchableOptionContributor {
        OptionContributor() {
        }

        public void processOptions(@NotNull SearchableOptionProcessor processor) {
            if (processor == null) {
                OptionContributor.Q(0);
            }
            processor.addOptions("directories project structure exclude resource test root content", null, "Directories", "web-ide.project.structure", "Directories", true);
        }

        private static /* synthetic */ void Q(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$OptionContributor", "processOptions"));
        }
    }

    private static class MyContentEntryTreeEditor
    extends ContentEntryTreeEditor {
        private final ChangeListener myListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                this.update();
            }
        };

        MyContentEntryTreeEditor(Project project, List<ModuleSourceRootEditHandler<?>> handlers) {
            super(project, handlers);
        }

        public void setContentEntryEditor(ContentEntryEditor newEditor) {
            MyCommonContentEntriesEditor.MyContentEntryEditor myContentEntryEditor = this.getContentEntryEditor();
            if (Comparing.equal((Object)((Object)myContentEntryEditor), (Object)newEditor)) {
                return;
            }
            if (myContentEntryEditor != null) {
                myContentEntryEditor.removeListener(this.myListener);
            }
            if (newEditor != null) {
                ((MyCommonContentEntriesEditor.MyContentEntryEditor)newEditor).addListener(this.myListener);
            }
            super.setContentEntryEditor(newEditor);
        }

        public MyCommonContentEntriesEditor.MyContentEntryEditor getContentEntryEditor() {
            return (MyCommonContentEntriesEditor.MyContentEntryEditor)super.getContentEntryEditor();
        }

        protected void createEditingActions() {
            super.createEditingActions();
            ContentEntryEditingAction contentEntryEditingAction = new ContentEntryEditingAction((JTree)this.myTree){
                {
                    super(arg0);
                    Presentation presentation = this.getTemplatePresentation();
                    presentation.setText(WebCoreBundle.messagePointer((String)"resource.root.action.title", (Object[])new Object[0]));
                    presentation.setDescription(WebCoreBundle.messagePointer((String)"resource.root.action.description", (Object[])new Object[0]));
                    presentation.setIcon(WebideApiIcons.ResourceRoot);
                }

                public boolean isSelected(@NotNull AnActionEvent e2) {
                    if (e2 == null) {
                        2.Q(0);
                    }
                    VirtualFile[] virtualFileArray = this.getSelectedFiles();
                    MyCommonContentEntriesEditor.MyContentEntryEditor myContentEntryEditor = this.getContentEntryEditor();
                    return virtualFileArray.length != 0 && myContentEntryEditor != null && myContentEntryEditor.hasResourceRoot(virtualFileArray[0]);
                }

                public void setSelected(@NotNull AnActionEvent e2, boolean isSelected) {
                    if (e2 == null) {
                        2.Q(1);
                    }
                    VirtualFile[] virtualFileArray = this.getSelectedFiles();
                    assert (virtualFileArray.length != 0);
                    MyCommonContentEntriesEditor.MyContentEntryEditor myContentEntryEditor = this.getContentEntryEditor();
                    if (myContentEntryEditor == null) {
                        return;
                    }
                    for (VirtualFile virtualFile : virtualFileArray) {
                        boolean bl = myContentEntryEditor.hasResourceRoot(virtualFile);
                        if (isSelected) {
                            if (bl) continue;
                            myContentEntryEditor.addResourceRoot(virtualFile);
                            continue;
                        }
                        if (!bl) continue;
                        myContentEntryEditor.removeResourceRoot(virtualFile.getUrl());
                    }
                }

                private static /* synthetic */ void Q(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyContentEntryTreeEditor$2";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myEditingActionsGroup.add((AnAction)contentEntryEditingAction);
            contentEntryEditingAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8)), (JComponent)this.myTree);
        }

        protected TreeCellRenderer getContentEntryCellRenderer(@NotNull ContentEntry contentEntry) {
            if (contentEntry == null) {
                MyContentEntryTreeEditor.Q(0);
            }
            return new ContentEntryTreeCellRenderer(this, contentEntry, this.getEditHandlers()){

                protected Icon updateIcon(ContentEntry entry, VirtualFile file, Icon originalIcon) {
                    MyCommonContentEntriesEditor.MyContentEntryEditor myContentEntryEditor = this.getContentEntryEditor();
                    if (myContentEntryEditor != null && myContentEntryEditor.hasResourceRoot(file)) {
                        return WebideApiIcons.ResourceRoot;
                    }
                    return super.updateIcon(entry, file, originalIcon);
                }
            };
        }

        private static /* synthetic */ void Q(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyContentEntryTreeEditor", "getContentEntryCellRenderer"));
        }
    }
}

