/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import java.util.Properties;

public enum TracerProperties {
    averageTimesInterval("perforce.tracer.average.times.interval", 3600000L),
    averageTimesQueueSize("perforce.tracer.average.times.queue.size", 1L),
    numberConcurrentThreadsInterval("perforce.tracer.number.concurrent.threads.interval", 10000L),
    numberConcurrentThreadsQueueSize("perforce.tracer.number.concurrent.threads.queue.size", 10L),
    longCallsInterval("perforce.tracer.long.calls.interval", 10000L),
    longCallsQueueSize("perforce.tracer.long.calls.queue.size", 10L),
    longCallsMaxKept("perforce.tracer.long.max.kept", 10L),
    longCallsLowerBound("perforce.tracer.long.calls.lower.bound", 5000L),
    outputInterval("perforce.tracer.log.interval", 1800000L);

    public static final String GATHER_AVERAGE_TIMES = "perforce.tracer.average.gather";
    public static final String GATHER_CONCURRENT_THREADS = "perforce.tracer.number.concurrent.threads.gather";
    public static final String GATHER_LONG_CALLS = "perforce.tracer.long.calls.gather";
    private final String myName;
    private final long myDefault;

    private TracerProperties(String name, long aDefault) {
        this.myName = name;
        this.myDefault = aDefault;
    }

    public long getDefault() {
        return this.myDefault;
    }

    public long getValue(Properties properties) {
        Long value;
        String stringValue = properties.getProperty(this.myName);
        Long l = value = stringValue == null ? null : Long.valueOf(stringValue);
        return value == null ? this.myDefault : (value <= 0L ? this.myDefault : value);
    }
}

