/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.CellLinesActionBaseKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isModifyingSourceCode", "", "actionPerformed", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "intellij.jupyter.core"})
public abstract class NotebookCellLinesActionBase
extends DumbAwareAction
implements JupyterEditorAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        presentation.setEnabled(NotebookDataContext.INSTANCE.getNotebookEditor(dataContext) != null);
    }

    public boolean isModifyingSourceCode() {
        return true;
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull EditorImpl var2, @NotNull NotebookCellLines var3);

    public final void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isModifyingSourceCode() && !CellLinesActionBaseKt.isEditingAllowed((AnActionEvent)event)) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get((Editor)editor);
        this.actionPerformed(event, editor, cellLines);
    }
}

