/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution;

import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServers;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ManagedServerJupyterModuleConnectionSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u00a8\u0006\f"}, d2={"isRemoteJupyterServerSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJupyterServer", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServer;", "isRemote", "Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterModuleConnectionSettings;", "isLocal", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterConnectionSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionSettingsUtil.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/JupyterConnectionSettingsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class JupyterConnectionSettingsUtilKt {
    public static final boolean isRemoteJupyterServerSettings(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        boolean bl;
        JupyterNotebookRuntimeSettings notebookSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl2 = false;
            v1 = JupyterRuntimeService.Companion.getInstance(project).getRuntime(it);
        } else {
            v1 = notebookSettings = null;
        }
        if (notebookSettings instanceof JupyterNotebookOfflineSettings) {
            bl = JupyterConnectionSettingsUtilKt.isRemote(((JupyterNotebookOfflineSettings)notebookSettings).getConnectionSettings());
        } else if (notebookSettings instanceof JupyterNotebookSessionSettings) {
            bl = JupyterConnectionSettingsUtilKt.isLocal(((JupyterNotebookSessionSettings)notebookSettings).getSession().getJupyterServer().getConnectionParameters());
        } else if (notebookSettings instanceof ManagedJupyterServerNotebookSessionSettings) {
            bl = false;
        } else if (notebookSettings == null) {
            bl = JupyterConnectionSettingsUtilKt.isRemote(JupyterConnectionParametersSettings.Companion.getInstance(project).guessConnectionSettings(project, virtualFile));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final JupyterServer getJupyterServer(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        JupyterServer jupyterServer;
        JupyterConnectionParameters effectiveConnectionParameters;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterModuleConnectionSettings guessedConnectionSettings = JupyterConnectionParametersSettings.Companion.getInstance(project).guessConnectionSettings(project, virtualFile);
        JupyterConnectionParameters jupyterConnectionParameters = effectiveConnectionParameters = guessedConnectionSettings.getConnectionParameters(project, virtualFile);
        if (jupyterConnectionParameters != null) {
            JupyterConnectionParameters it = jupyterConnectionParameters;
            boolean bl = false;
            jupyterServer = JupyterServers.Companion.getInstance().getServer(it);
        } else {
            jupyterServer = null;
        }
        return jupyterServer;
    }

    public static final boolean isRemote(@NotNull JupyterModuleConnectionSettings $this$isRemote) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isRemote, (String)"<this>");
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = $this$isRemote;
        if (jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            bl = false;
        } else if (jupyterModuleConnectionSettings instanceof ConfiguredServerJupyterModuleConnectionSettings) {
            bl = !((ConfiguredServerJupyterModuleConnectionSettings)$this$isRemote).isLocal();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isLocal(@NotNull JupyterConnectionParameters $this$isLocal) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocal, (String)"<this>");
        JupyterConnectionParameters.Location location = $this$isLocal.getLocation();
        if (location instanceof JupyterConnectionParameters.Location.Direct) {
            boolean bl2;
            try {
                InetAddress $this$isLocal_u24lambda_u242 = InetAddress.getByName(((JupyterConnectionParameters.Location.Direct)$this$isLocal.getLocation()).getUri().getHost());
                boolean bl3 = false;
                bl2 = $this$isLocal_u24lambda_u242.isAnyLocalAddress() || $this$isLocal_u24lambda_u242.isLoopbackAddress();
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(exception instanceof UnknownHostException) && !(exception instanceof SecurityException)) {
                    throw e;
                }
                bl2 = false;
            }
            bl = bl2;
        } else if (location instanceof JupyterConnectionParameters.Location.Tunneled) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

