/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.error;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/PythonStacktraceUtils;", "", "<init>", "()V", "fileRegex", "Lkotlin/text/Regex;", "cellRegex", "inputRegex", "lineNumberRegex", "linkifyStackLine", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/PythonStacktraceUtils$CellHighlightInfo;", "line", "", "entireLength", "", "stripFormatting", "text", "CellHighlightInfo", "intellij.jupyter.core"})
public final class PythonStacktraceUtils {
    @NotNull
    public static final PythonStacktraceUtils INSTANCE = new PythonStacktraceUtils();
    @NotNull
    private static final Regex fileRegex = new Regex("File\\s+(?:\\u001b\\[.+?m)?(.+):(\\d+)");
    @NotNull
    private static final Regex cellRegex = new Regex("(?<prefix>Cell\\s+(?:\\u001b\\[.+?m)?In\\s*\\[(?<executionCount>\\d+)\\],\\s*)(?<lineLabel>line (?<lineNumber>\\d+)).*");
    @NotNull
    private static final Regex inputRegex = new Regex("(?<prefix>Input\\s+?(?:\\u001b\\[.+?m)(?<cellLabel>In\\s*\\[(?<executionCount>\\d+)\\]))(?<postfix>.*)");
    @NotNull
    private static final Regex lineNumberRegex = new Regex("^((?:\\u001b\\[.+?m)?[ \\->]+?)(\\d+)(?:\\u001b\\[0m)?( .*)");

    private PythonStacktraceUtils() {
    }

    @Nullable
    public final CellHighlightInfo linkifyStackLine(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult matchResult = Regex.find$default((Regex)cellRegex, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null || (matchResult = matchResult.get(3)) == null) {
            return null;
        }
        MatchResult highlightText = matchResult;
        MatchResult matchResult2 = Regex.find$default((Regex)cellRegex, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult2 == null || (matchResult2 = matchResult2.getGroups()) == null || (matchResult2 = matchResult2.get(2)) == null) {
            return null;
        }
        MatchResult runCountRaw = matchResult2;
        MatchResult matchResult3 = Regex.find$default((Regex)cellRegex, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult3 == null || (matchResult3 = matchResult3.getGroups()) == null || (matchResult3 = (MatchGroup)CollectionsKt.lastOrNull((Iterable)((Iterable)matchResult3))) == null) {
            return null;
        }
        MatchResult cellLineRaw = matchResult3;
        Integer n = StringsKt.toIntOrNull((String)this.stripFormatting(runCountRaw.getValue()));
        if (n == null) {
            return null;
        }
        int runCount = n;
        Integer n2 = StringsKt.toIntOrNull((String)this.stripFormatting(cellLineRaw.getValue()));
        if (n2 == null) {
            return null;
        }
        int cellLine = n2;
        IntRange range = highlightText.getRange();
        int startLine = entireLength - line.length();
        return new CellHighlightInfo(new IntRange(startLine + range.getFirst(), startLine + range.getLast() + 1), runCount, cellLine);
    }

    private final String stripFormatting(String text) {
        Pattern formatSequence = Pattern.compile("\u001b\\[.+?m");
        String string = formatSequence.matcher(text).replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/error/PythonStacktraceUtils$CellHighlightInfo;", "", "highlightRange", "Lkotlin/ranges/IntRange;", "runCount", "", "cellLine", "<init>", "(Lkotlin/ranges/IntRange;II)V", "getHighlightRange", "()Lkotlin/ranges/IntRange;", "getRunCount", "()I", "getCellLine", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.jupyter.core"})
    public static final class CellHighlightInfo {
        @NotNull
        private final IntRange highlightRange;
        private final int runCount;
        private final int cellLine;

        public CellHighlightInfo(@NotNull IntRange highlightRange, int runCount, int cellLine) {
            Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
            this.highlightRange = highlightRange;
            this.runCount = runCount;
            this.cellLine = cellLine;
        }

        @NotNull
        public final IntRange getHighlightRange() {
            return this.highlightRange;
        }

        public final int getRunCount() {
            return this.runCount;
        }

        public final int getCellLine() {
            return this.cellLine;
        }

        @NotNull
        public final IntRange component1() {
            return this.highlightRange;
        }

        public final int component2() {
            return this.runCount;
        }

        public final int component3() {
            return this.cellLine;
        }

        @NotNull
        public final CellHighlightInfo copy(@NotNull IntRange highlightRange, int runCount, int cellLine) {
            Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
            return new CellHighlightInfo(highlightRange, runCount, cellLine);
        }

        public static /* synthetic */ CellHighlightInfo copy$default(CellHighlightInfo cellHighlightInfo, IntRange intRange, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                intRange = cellHighlightInfo.highlightRange;
            }
            if ((n3 & 2) != 0) {
                n = cellHighlightInfo.runCount;
            }
            if ((n3 & 4) != 0) {
                n2 = cellHighlightInfo.cellLine;
            }
            return cellHighlightInfo.copy(intRange, n, n2);
        }

        @NotNull
        public String toString() {
            return "CellHighlightInfo(highlightRange=" + this.highlightRange + ", runCount=" + this.runCount + ", cellLine=" + this.cellLine + ")";
        }

        public int hashCode() {
            int result2 = this.highlightRange.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.runCount);
            result2 = result2 * 31 + Integer.hashCode(this.cellLine);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CellHighlightInfo)) {
                return false;
            }
            CellHighlightInfo cellHighlightInfo = (CellHighlightInfo)other;
            if (!Intrinsics.areEqual((Object)this.highlightRange, (Object)cellHighlightInfo.highlightRange)) {
                return false;
            }
            if (this.runCount != cellHighlightInfo.runCount) {
                return false;
            }
            return this.cellLine == cellHighlightInfo.cellLine;
        }
    }
}

