/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.lang.JupyterDialectProvider;
import com.intellij.jupyter.core.jupyter.nbformat.CellAdded;
import com.intellij.jupyter.core.jupyter.nbformat.CellRemoved;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellCountListener;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListeners;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAwareBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookException;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchemaKt;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.LineSeparator;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 S2\u00020\u00012\u00020\u0002:\u0002RSB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J!\u0010)\u001a\u00020\u00192\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+\u00a2\u0006\u0002\b.H\u0016J)\u0010)\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+\u00a2\u0006\u0002\b.H\u0016J\u0010\u00101\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00102\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0016J\u0012\u00103\u001a\u0004\u0018\u00010\u00192\u0006\u0010/\u001a\u000200H\u0016J\b\u00104\u001a\u000200H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u0010*\u001a\u00020,H\u0002J\b\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0004H\u0002J\u0018\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u001a\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020-2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020BH\u0002J\u0010\u0010E\u001a\u00020B2\u0006\u0010F\u001a\u00020\u0019H\u0002J\u0018\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u0002002\u0006\u0010I\u001a\u000200H\u0016J\u001a\u0010J\u001a\u00020-2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010=H\u0016J\u0006\u0010N\u001a\u00020-J\u0010\u0010O\u001a\u0004\u0018\u00010\u00192\u0006\u0010P\u001a\u00020QR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010:\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\n\u00a8\u0006T"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadataAwareBase;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "schema", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;", "<init>", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;)V", "getJson", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "listeners", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterListeners;", "getListeners", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterListeners;", "setListeners", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterListeners;)V", "cellsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "version", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "getVersion", "()Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "computeCells", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "value", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "kernelSpec", "getKernelSpec", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "setKernelSpec", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;)V", "metadata", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;", "getMetadata", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "addCell", "builder", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBuilder;", "", "Lkotlin/ExtensionFunctionType;", "index", "", "removeCell", "getCell", "getCellOrNull", "cellsCount", "checkCellBuilder", "getCellsNode", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "createCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBase;", "content", "setMetadata", "key", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "removeMetadata", "getContent", "asSource", "", "commentHeaders", "source", "getCellMarkerSource", "cell", "swapIdsAndOutputs", "firstOrdinal", "secondOrdinal", "writeJson", "writer", "Ljava/io/Writer;", "lineSeparator", "checkNotebook", "getCellByInterval", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "JupyterPrettyPrinter", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,300:1\n1557#2:301\n1628#2,3:302\n183#3,2:305\n1#4:307\n24#5:308\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase\n*L\n47#1:301\n47#1:302,3\n65#1:305,2\n179#1:308\n*E\n"})
public final class JupyterNotebookBase
extends JupyterMetadataAwareBase
implements JupyterNotebook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectNode json;
    @NotNull
    private final JupyterNotebookSchema schema;
    @NotNull
    private volatile JupyterListeners listeners;
    @NotNull
    private final ReentrantReadWriteLock cellsLock;
    @NotNull
    private final JupyterMetadata metadata;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<Function1<JupyterNotebook, Language>> LANGUAGE_CANDIDATES;

    public JupyterNotebookBase(@NotNull ObjectNode json, @NotNull JupyterNotebookSchema schema) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.json = json;
        this.schema = schema;
        this.listeners = new JupyterListeners();
        this.cellsLock = new ReentrantReadWriteLock();
        this.metadata = this.schema.getMetadata(this.getJson());
    }

    @Override
    @NotNull
    public ObjectNode getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public JupyterListeners getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(@NotNull JupyterListeners jupyterListeners) {
        Intrinsics.checkNotNullParameter((Object)jupyterListeners, (String)"<set-?>");
        this.listeners = jupyterListeners;
    }

    @Override
    @NotNull
    public JupyterNotebookSchemaVersion getVersion() {
        return this.schema.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JupyterCell> computeCells() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.cellsLock.readLock();
        readLock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)this.getCellsNode();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                collection.add(this.createCell((ObjectNode)it));
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    @Override
    @Nullable
    public JupyterKernelSpec getKernelSpec() {
        return this.schema.getJupyterKernelSpec(this.getJson());
    }

    @Override
    public void setKernelSpec(@Nullable JupyterKernelSpec value) {
        this.schema.setJupyterKernelSpec(this.getJson(), value);
        JupyterListenersKt.notifyNotebookChanged(this);
    }

    @Override
    @NotNull
    public JupyterMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language;
        Object v0;
        block2: {
            Sequence $this$firstOrNull$iv = SequencesKt.ifEmpty((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)LANGUAGE_CANDIDATES), arg_0 -> JupyterNotebookBase._get_language_$lambda$2(this, arg_0)), JupyterNotebookBase::_get_language_$lambda$3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Language it = (Language)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)Language.ANY))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((language = (Language)v0) == null) {
            language = Language.ANY;
        }
        Language language2 = language;
        Intrinsics.checkNotNull((Object)language2);
        return JupyterNotebookBase.Companion.promoteToJupyterPythonIfNecessary(language2);
    }

    @Override
    @NotNull
    public JupyterCell addCell(@NotNull Function1<? super JupyterCellBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return this.addCell(this.getCellsNode().size(), builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public JupyterCell addCell(int index, @NotNull Function1<? super JupyterCellBuilder, Unit> builder) {
        JupyterCell jupyterCell;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        JupyterCellBase.JupyterCellBuilderBase jupyterCellBuilderBase = new JupyterCellBase.JupyterCellBuilderBase(this, null, null, null, false, null, null, this.schema, 126, null);
        builder.invoke((Object)jupyterCellBuilderBase);
        JupyterCellBase.JupyterCellBuilderBase cellBuilder = jupyterCellBuilderBase;
        this.checkCellBuilder(cellBuilder);
        ReentrantReadWriteLock reentrantReadWriteLock = this.cellsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            ArrayNode cells = this.getCellsNode();
            if (index > cells.size() + 1) {
                throw new IllegalStateException(("Trying to add cell to index " + index + " outside of cells range " + cells.size()).toString());
            }
            ObjectNode objectNode = cells.insertObject(index);
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"insertObject(...)");
            jupyterCell = cellBuilder.build(objectNode);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        JupyterCell cell = jupyterCell;
        JupyterListenersKt.notifyNotebookChanged(this);
        ((JupyterCellCountListener)this.getListeners().getCellCountListeners().getMulticaster()).onCellCountChanged(new CellAdded(this, cell, index));
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCell(int index) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.cellsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            ArrayNode cellsElement = this.getCellsNode();
            if (index >= cellsElement.size()) {
                LOG.warn("Trying to remove cell from index " + index + " outside of cells range " + cellsElement.size());
                return;
            }
            JsonNode jsonNode = cellsElement.remove(index);
        }
        finally {
            for (int cellsElement = 0; cellsElement < n; ++cellsElement) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        JupyterListenersKt.notifyNotebookChanged(this);
        ((JupyterCellCountListener)this.getListeners().getCellCountListeners().getMulticaster()).onCellCountChanged(new CellRemoved(this, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public JupyterCell getCell(int index) {
        JupyterCellBase jupyterCellBase;
        ReentrantReadWriteLock.ReadLock readLock = this.cellsLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            JsonNode jsonNode = this.getCellsNode().get(index);
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            jupyterCellBase = this.createCell((ObjectNode)jsonNode);
        }
        finally {
            readLock.unlock();
        }
        return jupyterCellBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public JupyterCell getCellOrNull(int index) {
        JupyterCell jupyterCell;
        ReentrantReadWriteLock.ReadLock readLock = this.cellsLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            jupyterCell = index >= 0 && index < this.getCellsNode().size() ? this.getCell(index) : null;
        }
        finally {
            readLock.unlock();
        }
        return jupyterCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cellsCount() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.cellsLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.getCellsNode().size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    private final void checkCellBuilder(JupyterCellBuilder builder) {
        if (!builder.isCompatible(this.schema)) {
            throw new JupyterNotebookException("Version of notebook cell builder " + builder + " is incompatible with notebook version " + this.schema, null, 2, null);
        }
    }

    private final ArrayNode getCellsNode() {
        JsonNode cellsElement = this.schema.getCells(this.getJson());
        if (cellsElement == null || !cellsElement.isArray()) {
            throw new JupyterNotebookException("Can't find proper cells element: " + cellsElement, null, 2, null);
        }
        return (ArrayNode)cellsElement;
    }

    private final JupyterCellBase createCell(ObjectNode content) {
        return new JupyterCellBase(this, content, this.schema.getCellSchema());
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull JsonNode value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.setMetadata(key, value);
        JupyterListenersKt.notifyNotebookChanged(this);
    }

    @Override
    public void removeMetadata(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super.removeMetadata(key);
        JupyterListenersKt.notifyNotebookChanged(this);
    }

    @Override
    @NotNull
    protected ObjectNode getContent() {
        return this.getJson();
    }

    @Override
    @NotNull
    public CharSequence asSource() {
        StringBuilder builder = new StringBuilder();
        SequencesKt.joinTo$default((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.computeCells()), arg_0 -> JupyterNotebookBase.asSource$lambda$10(this, arg_0)), (Appendable)builder, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
        return builder;
    }

    private final String commentHeaders(CharSequence source) {
        String header = "#%%";
        Object withCommentedFirstHeader = StringsKt.startsWith$default((CharSequence)source, (CharSequence)header, (boolean)false, (int)2, null) ? "#" + source : ((Object)source).toString();
        String[] stringArray = new String[]{"\n" + header};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)((CharSequence)withCommentedFirstHeader), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)("\n#" + header), null, null, (int)0, null, null, (int)62, null);
    }

    private final CharSequence getCellMarkerSource(JupyterCell cell) {
        String string = JupyterNotebookSchemaKt.getNonCodeCellTypeToSuffix().get(cell.getCellType());
        if (string == null) {
            string = "";
        }
        String cellSuffix = string;
        return "#%%" + cellSuffix + "\n";
    }

    @Override
    public void swapIdsAndOutputs(int firstOrdinal, int secondOrdinal) {
        ArrayNode cells = this.getCellsNode();
        JsonNode jsonNode = cells.get(firstOrdinal);
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode firstNode = (ObjectNode)jsonNode;
        JsonNode jsonNode2 = cells.get(secondOrdinal);
        Intrinsics.checkNotNull((Object)jsonNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode secondNode = (ObjectNode)jsonNode2;
        JupyterCellBase first = this.createCell(firstNode);
        JupyterCellBase second = this.createCell(secondNode);
        if (first.getCellType() != second.getCellType()) {
            JupyterNotebookBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterNotebookBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("cannot swap cells with different types " + first.getCellType() + " and " + second.getCellType());
        }
        this.schema.getCellSchema().swapIdsAndOutputs(firstNode, secondNode);
        JupyterListenersKt.notifyNotebookChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeJson(@NotNull Writer writer, @Nullable String lineSeparator) {
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ThreadingAssertions.assertWriteAccess();
        ReentrantReadWriteLock.ReadLock readLock = this.cellsLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            objectNode = this.getJson().deepCopy();
        }
        finally {
            readLock.unlock();
        }
        ObjectNode jsonDeepCopy = objectNode;
        Intrinsics.checkNotNull((Object)jsonDeepCopy);
        JupyterNotebookBase notebookDeepCopyWithNoListeners = new JupyterNotebookBase(jsonDeepCopy, this.schema);
        this.schema.beforeSave(jsonDeepCopy);
        JupyterNotebookConverter.Companion.convertBeforeSave(notebookDeepCopyWithNoListeners);
        JupyterJsonKt.getJackson().writer(JupyterPrettyPrinter.Companion.getPrettyPrinter(lineSeparator)).writeValue(writer, (Object)jsonDeepCopy);
    }

    public final void checkNotebook() {
        this.computeCells();
    }

    @Nullable
    public final JupyterCell getCellByInterval(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return null;
        }
        int index = interval.getOrdinal();
        return this.getCellOrNull(index);
    }

    private static final Language _get_language_$lambda$2(JupyterNotebookBase this$0, Function1 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Language)it.invoke((Object)this$0);
    }

    private static final Sequence _get_language_$lambda$3() {
        Object[] objectArray = new Language[]{JupyterDialectProvider.Companion.getDefaultDialect()};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private static final Sequence asSource$lambda$10(JupyterNotebookBase this$0, JupyterCell it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new String[]{this$0.getCellMarkerSource(it) + this$0.commentHeaders(it.getSource())};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private static final Language LANGUAGE_CANDIDATES$lambda$12(JupyterNotebook $this$listOf) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return JupyterNotebookBase.Companion.getLanguageFromKernelspecLanguage($this$listOf);
    }

    private static final Language LANGUAGE_CANDIDATES$lambda$13(JupyterNotebook $this$listOf) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return JupyterNotebookBase.Companion.getLanguageFromLanguageInfo($this$listOf);
    }

    private static final Language LANGUAGE_CANDIDATES$lambda$14(JupyterNotebook $this$listOf) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return JupyterNotebookBase.Companion.getLanguageFromKernelspecName($this$listOf);
    }

    private static final Language LANGUAGE_CANDIDATES$lambda$15(JupyterNotebook $this$listOf) {
        Intrinsics.checkNotNullParameter((Object)$this$listOf, (String)"$this$listOf");
        return JupyterNotebookBase.Companion.getLanguageFromMimetype($this$listOf);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new Function1[]{JupyterNotebookBase::LANGUAGE_CANDIDATES$lambda$12, JupyterNotebookBase::LANGUAGE_CANDIDATES$lambda$13, JupyterNotebookBase::LANGUAGE_CANDIDATES$lambda$14, JupyterNotebookBase::LANGUAGE_CANDIDATES$lambda$15};
        LANGUAGE_CANDIDATES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000b*\u00020\nH\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\nH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u000b*\u00020\nH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\u001b\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0002\b\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LANGUAGE_CANDIDATES", "", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "Lcom/intellij/lang/Language;", "Lkotlin/ExtensionFunctionType;", "getLanguageFromKernelspecLanguage", "getLanguageFromLanguageInfo", "getLanguageFromKernelspecName", "getLanguageFromMimetype", "promoteToJupyterPythonIfNecessary", "language", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Language getLanguageFromKernelspecLanguage(JupyterNotebook $this$getLanguageFromKernelspecLanguage) {
            Object object = $this$getLanguageFromKernelspecLanguage.getKernelSpec();
            if (object == null || (object = object.getLanguage()) == null) {
                return null;
            }
            Object languageField = object;
            return JupyterDialectProvider.Companion.provideDialectByKernelSpecLanguage((String)languageField);
        }

        private final Language getLanguageFromLanguageInfo(JupyterNotebook $this$getLanguageFromLanguageInfo) {
            String extension;
            Object object;
            JupyterMetadata jupyterMetadata = $this$getLanguageFromLanguageInfo.getMetadata().getObject("language_info");
            if (jupyterMetadata == null) {
                return null;
            }
            JupyterMetadata languageInfo = jupyterMetadata;
            String string = languageInfo.getString("file_extension");
            if (string != null) {
                object = new char[]{'.'};
                v2 = StringsKt.trimStart((String)string, (char[])object);
            } else {
                v2 = extension = null;
            }
            if (extension != null) {
                LanguageFileType fileType;
                object = FileTypeRegistry.getInstance().getFileTypeByExtension(extension);
                LanguageFileType languageFileType = fileType = object instanceof LanguageFileType ? (LanguageFileType)object : null;
                return languageFileType != null ? languageFileType.getLanguage() : null;
            }
            String languageName = languageInfo.getString("name");
            object = languageName;
            if (!(object == null || object.length() == 0)) {
                Language language = Language.findLanguageByID((String)Strings.capitalize((String)languageName));
                if (language == null) {
                    language = Language.ANY;
                }
                return language;
            }
            return null;
        }

        private final Language getLanguageFromKernelspecName(JupyterNotebook $this$getLanguageFromKernelspecName) {
            Object object = $this$getLanguageFromKernelspecName.getKernelSpec();
            if (object == null || (object = object.getName()) == null) {
                return null;
            }
            Object kernelName = object;
            return JupyterDialectProvider.Companion.provideDialectByKernelName((String)kernelName);
        }

        private final Language getLanguageFromMimetype(JupyterNotebook $this$getLanguageFromMimetype) {
            Object object = $this$getLanguageFromMimetype.getMetadata().getObject("language_info");
            if (object == null || (object = ((JupyterMetadata)object).getString("mimetype")) == null) {
                return null;
            }
            Object mimeType = object;
            return JupyterDialectProvider.Companion.provideLanguageFromMimeType((String)mimeType);
        }

        private final Language promoteToJupyterPythonIfNecessary(Language language) {
            return JupyterDialectProvider.Companion.provideDialect(language);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\t\u001a\u00020\u0001H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase$JupyterPrettyPrinter;", "Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;", "indenter", "Lcom/fasterxml/jackson/core/util/DefaultIndenter;", "<init>", "(Lcom/fasterxml/jackson/core/util/DefaultIndenter;)V", "lineSeparator", "", "(Ljava/lang/String;)V", "createInstance", "writeObjectFieldValueSeparator", "", "g", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeEndObject", "nrOfEntries", "", "writeEndArray", "nrOfValues", "Companion", "intellij.jupyter.core"})
    public static final class JupyterPrettyPrinter
    extends DefaultPrettyPrinter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DefaultIndenter indenter;
        @NotNull
        private static final Map<String, JupyterPrettyPrinter> printersCache;
        @NotNull
        private static final PrettyPrinter defaultPrinter;

        private JupyterPrettyPrinter(DefaultIndenter indenter) {
            this.indenter = indenter;
        }

        private JupyterPrettyPrinter(String lineSeparator) {
            this(new DefaultIndenter(" ", lineSeparator));
        }

        @NotNull
        public DefaultPrettyPrinter createInstance() {
            JupyterPrettyPrinter jupyterPrettyPrinter;
            JupyterPrettyPrinter $this$createInstance_u24lambda_u240 = jupyterPrettyPrinter = new JupyterPrettyPrinter(this.indenter);
            boolean bl = false;
            $this$createInstance_u24lambda_u240.indentArraysWith((DefaultPrettyPrinter.Indenter)$this$createInstance_u24lambda_u240.indenter);
            $this$createInstance_u24lambda_u240.indentObjectsWith((DefaultPrettyPrinter.Indenter)$this$createInstance_u24lambda_u240.indenter);
            return jupyterPrettyPrinter;
        }

        public void writeObjectFieldValueSeparator(@NotNull JsonGenerator g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.writeRaw(": ");
        }

        public void writeEndObject(@Nullable JsonGenerator g, int nrOfEntries) throws IOException {
            if (!this._objectIndenter.isInline()) {
                this._nesting += -1;
            }
            if (nrOfEntries > 0) {
                this._objectIndenter.writeIndentation(g, this._nesting);
            }
            JsonGenerator jsonGenerator = g;
            Intrinsics.checkNotNull((Object)jsonGenerator);
            jsonGenerator.writeRaw('}');
            if (this._nesting == 0 && Registry.Companion.get("jupyter.ipynb.eol.file.ending").asBoolean()) {
                g.writeRaw(this.indenter.getEol());
            }
        }

        public void writeEndArray(@NotNull JsonGenerator g, int nrOfValues) throws IOException {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this._arrayIndenter.isInline()) {
                this._nesting += -1;
            }
            if (nrOfValues > 0) {
                this._arrayIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw(']');
        }

        public /* synthetic */ JupyterPrettyPrinter(String lineSeparator, DefaultConstructorMarker $constructor_marker) {
            this(lineSeparator);
        }

        static {
            Map map = ContainerUtil.createSoftValueMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSoftValueMap(...)");
            printersCache = map;
            String string = LineSeparator.LF.getSeparatorString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparatorString(...)");
            defaultPrinter = (PrettyPrinter)new JupyterPrettyPrinter(string);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0006R\\\u0010\u0004\u001aN\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*%\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u000b\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase$JupyterPrettyPrinter$Companion;", "", "<init>", "()V", "printersCache", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase$JupyterPrettyPrinter;", "kotlin.jvm.PlatformType", "", "Ljava/util/Map;", "defaultPrinter", "Lcom/fasterxml/jackson/core/PrettyPrinter;", "getPrettyPrinter", "lineSeparator", "intellij.jupyter.core"})
        @SourceDebugExtension(value={"SMAP\nJupyterNotebookBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase$JupyterPrettyPrinter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PrettyPrinter getPrettyPrinter(@Nullable String lineSeparator) {
                PrettyPrinter prettyPrinter;
                if (lineSeparator == null) {
                    return defaultPrinter;
                }
                JupyterPrettyPrinter jupyterPrettyPrinter = (JupyterPrettyPrinter)((Object)printersCache.get(lineSeparator));
                if (jupyterPrettyPrinter != null) {
                    prettyPrinter = (PrettyPrinter)jupyterPrettyPrinter;
                } else {
                    JupyterPrettyPrinter jupyterPrettyPrinter2;
                    JupyterPrettyPrinter $this$getPrettyPrinter_u24lambda_u240 = jupyterPrettyPrinter2 = new JupyterPrettyPrinter(lineSeparator, null);
                    boolean bl = false;
                    printersCache.put(lineSeparator, $this$getPrettyPrinter_u24lambda_u240);
                    prettyPrinter = (PrettyPrinter)jupyterPrettyPrinter2;
                }
                return prettyPrinter;
            }

            public static /* synthetic */ PrettyPrinter getPrettyPrinter$default(Companion companion, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = LineSeparator.LF.getSeparatorString();
                }
                return companion.getPrettyPrinter(string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

