/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.scientific.py.tables.panel.datawrangler.CellContent;
import com.intellij.scientific.py.tables.panel.datawrangler.DSSummaryCreationSettings;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreeModel;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreePart;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\rH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeTable;", "", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "<init>", "(Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)V", "getTable", "()Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "summaryTreeModel", "Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeModel;", "getSummaryTreeModel", "()Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeModel;", "myTreeTable", "Lcom/intellij/ui/components/JBTreeTable;", "getMyTreeTable", "()Lcom/intellij/ui/components/JBTreeTable;", "setMyTreeTable", "(Lcom/intellij/ui/components/JBTreeTable;)V", "createTreeTable", "addNewSummary", "", "settings", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;", "deleteSummary", "summaryName", "", "replaceWithOneTree", "expand", "", "setSummaryVisible", "isVisible", "intellij.scientific.py.tables"})
public final class SummaryTreeTable {
    @NotNull
    private final DSTableWithStatistics table;
    @NotNull
    private final SummaryTreeModel summaryTreeModel;
    @NotNull
    private JBTreeTable myTreeTable;

    public SummaryTreeTable(@NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.summaryTreeModel = new SummaryTreeModel(this.table);
        this.myTreeTable = this.createTreeTable();
    }

    @NotNull
    public final DSTableWithStatistics getTable() {
        return this.table;
    }

    @NotNull
    public final SummaryTreeModel getSummaryTreeModel() {
        return this.summaryTreeModel;
    }

    @NotNull
    public final JBTreeTable getMyTreeTable() {
        return this.myTreeTable;
    }

    public final void setMyTreeTable(@NotNull JBTreeTable jBTreeTable) {
        Intrinsics.checkNotNullParameter((Object)jBTreeTable, (String)"<set-?>");
        this.myTreeTable = jBTreeTable;
    }

    private final JBTreeTable createTreeTable() {
        this.myTreeTable = new JBTreeTable((TreeTableModel)this.summaryTreeModel);
        this.myTreeTable.setDefaultRenderer(CellContent.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                if (!(value2 instanceof CellContent)) {
                    return;
                }
                this.append(((CellContent)value2).getDisplayedText(), ((CellContent)value2).isGrey() ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                this.setTextAlign(4);
            }
        });
        return this.myTreeTable;
    }

    public final void addNewSummary(@NotNull DSSummaryCreationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.summaryTreeModel.addSummaryTreeModel(SummaryTreePart.Companion.createNewTreeFromSettings(this.table, settings));
        this.myTreeTable = this.createTreeTable();
    }

    public final void deleteSummary(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.summaryTreeModel.deleteSummaryTreeModel(summaryName);
        this.myTreeTable = this.createTreeTable();
    }

    public final void replaceWithOneTree(@NotNull DSSummaryCreationSettings settings, boolean expand) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.summaryTreeModel.replaceWithOneSummaryTreeModel(SummaryTreePart.Companion.createNewTreeFromSettings(this.table, settings));
        this.myTreeTable = this.createTreeTable();
        if (expand) {
            this.myTreeTable.getTree().expandRow(0);
        }
    }

    public static /* synthetic */ void replaceWithOneTree$default(SummaryTreeTable summaryTreeTable, DSSummaryCreationSettings dSSummaryCreationSettings, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        summaryTreeTable.replaceWithOneTree(dSSummaryCreationSettings, bl);
    }

    public final void setSummaryVisible(@NotNull String summaryName, boolean isVisible2) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.summaryTreeModel.setSummaryVisible(summaryName, isVisible2);
        this.myTreeTable = this.createTreeTable();
    }
}

