/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.observable.property;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.observable.collections.CollectionAdapter;
import org.jetbrains.letsPlot.commons.intern.observable.collections.CollectionItemEvent;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.intern.observable.event.ListenerCaller;
import org.jetbrains.letsPlot.commons.intern.observable.event.Listeners;
import org.jetbrains.letsPlot.commons.intern.observable.property.BaseReadableProperty;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.PropertyChangeEvent;
import org.jetbrains.letsPlot.commons.intern.observable.property.ValueProperty;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u00020\u0004B\u001d\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0017\u001a\u00020\u00162\u0016\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u00140\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000f\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0017\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/observable/property/ListItemProperty;", "ValueT", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/BaseReadableProperty;", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "myList", "Lorg/jetbrains/letsPlot/commons/intern/observable/collections/list/ObservableList;", "index", "", "(Lorg/jetbrains/letsPlot/commons/intern/observable/collections/list/ObservableList;I)V", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/ValueProperty;", "getIndex", "()Lorg/jetbrains/letsPlot/commons/intern/observable/property/ValueProperty;", "isValid", "", "()Z", "myDisposed", "myHandlers", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/Listeners;", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/EventHandler;", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/PropertyChangeEvent;", "myReg", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "addHandler", "handler", "dispose", "", "get", "()Ljava/lang/Object;", "invalidate", "set", "value", "(Ljava/lang/Object;)V", "commons"})
public final class ListItemProperty<ValueT>
extends BaseReadableProperty<ValueT>
implements Property<ValueT>,
Disposable {
    @NotNull
    private final ObservableList<ValueT> myList;
    @NotNull
    private final Listeners<EventHandler<PropertyChangeEvent<? extends ValueT>>> myHandlers;
    @NotNull
    private final Registration myReg;
    private boolean myDisposed;
    @NotNull
    private final ValueProperty<Integer> index;

    public ListItemProperty(@NotNull ObservableList<ValueT> myList, int index) {
        Intrinsics.checkNotNullParameter(myList, (String)"myList");
        this.myList = myList;
        this.myHandlers = new Listeners();
        this.index = new ValueProperty<Integer>(index);
        if (index < 0 || index >= this.myList.size()) {
            throw new IndexOutOfBoundsException(index + " >= size " + this.myList.size());
        }
        this.myReg = this.myList.addListener(new CollectionAdapter<ValueT>(){

            @Override
            public void onItemAdded(@NotNull CollectionItemEvent<? extends ValueT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Integer index = this.getIndex().get();
                if (index != null && event.getIndex() <= index) {
                    this.getIndex().set(index + 1);
                }
            }

            @Override
            public void onItemSet(@NotNull CollectionItemEvent<? extends ValueT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Integer n = this.getIndex().get();
                if (n != null && event.getIndex() == n.intValue()) {
                    PropertyChangeEvent e = new PropertyChangeEvent(event.getOldItem(), event.getNewItem());
                    myHandlers.fire(new ListenerCaller<EventHandler<? super PropertyChangeEvent<? extends ValueT>>>(e){
                        final /* synthetic */ PropertyChangeEvent<ValueT> $e;
                        {
                            this.$e = $e;
                        }

                        public void call(@NotNull EventHandler<? super PropertyChangeEvent<? extends ValueT>> l) {
                            Intrinsics.checkNotNullParameter(l, (String)"l");
                            l.onEvent(this.$e);
                        }
                    });
                }
            }

            @Override
            public void onItemRemoved(@NotNull CollectionItemEvent<? extends ValueT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Integer index = this.getIndex().get();
                if (index != null) {
                    if (event.getIndex() < index) {
                        this.getIndex().set(index - 1);
                    } else if (event.getIndex() == index.intValue()) {
                        this.invalidate();
                        PropertyChangeEvent<Object> e = new PropertyChangeEvent<Object>(event.getOldItem(), null);
                        myHandlers.fire(new ListenerCaller<EventHandler<? super PropertyChangeEvent<? extends ValueT>>>(e){
                            final /* synthetic */ PropertyChangeEvent<ValueT> $e;
                            {
                                this.$e = $e;
                            }

                            public void call(@NotNull EventHandler<? super PropertyChangeEvent<? extends ValueT>> l) {
                                Intrinsics.checkNotNullParameter(l, (String)"l");
                                l.onEvent(this.$e);
                            }
                        });
                    }
                }
            }
        });
    }

    @NotNull
    public final ValueProperty<Integer> getIndex() {
        return this.index;
    }

    public final boolean isValid() {
        return this.index.get() != null;
    }

    @Override
    @NotNull
    public Registration addHandler(@NotNull EventHandler<? super PropertyChangeEvent<? extends ValueT>> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return this.myHandlers.add(handler2);
    }

    @Override
    @Nullable
    public ValueT get() {
        ValueT ValueT;
        if (this.isValid()) {
            Integer n = this.index.get();
            Intrinsics.checkNotNull((Object)n);
            ValueT = (ValueT)this.myList.get(((Number)n).intValue());
        } else {
            ValueT = null;
        }
        return ValueT;
    }

    @Override
    public void set(@Nullable ValueT value2) {
        if (!this.isValid()) {
            throw new IllegalStateException("Property points to an invalid item, can\u2019t set");
        }
        Integer n = this.index.get();
        Intrinsics.checkNotNull((Object)n);
        this.myList.set(((Number)n).intValue(), value2);
    }

    private final void invalidate() {
        this.index.set(null);
        this.myReg.dispose();
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            throw new IllegalStateException("Double dispose");
        }
        if (this.isValid()) {
            this.myReg.dispose();
        }
        this.myDisposed = true;
    }
}

