/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 47140964534018L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(596499570 - 17062, 596499570 - 4668, (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(596499570 - 17061, 596499570 - 14546, (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 131424631480851L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.Q();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1367846520 - (char)-20071, -1367846520 - -((char)-14732), (int)l) + string + WindowsNamedPipeAgentIpc.b(1367846520 - (char)-20070, -1367846520 - -((char)-2403), (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(1367846520 - (char)-20065, -1367846520 - -((char)-16987), (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l;
        block14: {
            block15: {
                l = 26705827813659L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.Q();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(278785890 + (char)-10130, -278785890 + -((char)-26444), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(278785890 + (char)-10127, -278916960 - -((char)-874), (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(278785890 + (char)-10128, 278785890 + (char)-10202, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(278785890 + (char)-10117, -278785890 + -((char)-12988), (int)l) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(278785890 + (char)-10118, 278785890 + (char)-18708, (int)l));
            logger.info(WindowsNamedPipeAgentIpc.b(278785890 + (char)-10128, 278785890 + (char)-10202, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(278785890 + (char)-10115, -278785890 + -((char)-27279), (int)l));
            if (ActionTimestamp.Q() != null) {
                SshAgentIpcService.Q(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l = 7650810629027L;
                    nArray = SshAgentIpcService.Q();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l;
        block27: {
            block28: {
                l = 55174097412979L;
                int[] nArray2 = SshAgentIpcService.Q();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-947505030 + -31428, 947505030 + (char)-32668, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31433, 947505030 + 23978, (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31434, 947505030 + 29558, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-947505030 + -31428, 947505030 + (char)-32668, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31431, 947505030 + 23680, (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-947505030 + -31428, 947505030 + (char)-32668, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31432, 947505030 + (char)-22806, (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31437, 947505030 + 18229, (int)l) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31434, 947505030 + 29558, (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-947505030 + -31428, 947505030 + (char)-32668, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-947505030 + -31424, -947505030 + -31386, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-947505030 + -31438, -947505030 + -21582, (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 120519221090578L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1856213340 - -15964, 1856213340 - 23184, (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 23542320481880L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1604690010 + (char)-11791, 1604690010 + (char)-21035, (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "A\u008d-~\u0016y#O\u001a\u00b6G\r\u00132m^\u007fAi\u0014\u001fs\u00e6\u00a7t\u0080\u0012\u00f5\u00be\u00e7\u0016\u00f3\u00fb\u0014\u00b1\u0011\tn\u00a0\u00a9";
                        var4_3 = "A\u008d-~\u0016y#O\u001a\u00b6G\r\u00132m^\u007fAi\u0014\u001fs\u00e6\u00a7t\u0080\u0012\u00f5\u00be\u00e7\u0016\u00f3\u00fb\u0014\u00b1\u0011\tn\u00a0\u00a9".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 57;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 54;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 32;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 9;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 85;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 123;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 18;
                                        break;
                                    }
                                    default: {
                                        v11 = 70;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x3412) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 233;
                            case 1 -> 232;
                            case 2 -> 188;
                            case 3 -> 58;
                            case 4 -> 197;
                            case 5 -> 119;
                            case 6 -> 210;
                            case 7 -> 176;
                            case 8 -> 67;
                            case 9 -> 6;
                            case 10 -> 55;
                            case 11 -> 195;
                            case 12 -> 133;
                            case 13 -> 178;
                            case 14 -> 2;
                            case 15 -> 250;
                            case 16 -> 249;
                            case 17 -> 102;
                            case 18 -> 113;
                            case 19 -> 243;
                            case 20 -> 15;
                            case 21 -> 184;
                            case 22 -> 111;
                            case 23 -> 201;
                            case 24 -> 220;
                            case 25 -> 235;
                            case 26 -> 21;
                            case 27 -> 117;
                            case 28 -> 244;
                            case 29 -> 46;
                            case 30 -> 158;
                            case 31 -> 204;
                            case 32 -> 97;
                            case 33 -> 83;
                            case 34 -> 154;
                            case 35 -> 26;
                            case 36 -> 198;
                            case 37 -> 8;
                            case 38 -> 192;
                            case 39 -> 78;
                            case 40 -> 168;
                            case 41 -> 28;
                            case 42 -> 44;
                            case 43 -> 22;
                            case 44 -> 139;
                            case 45 -> 68;
                            case 46 -> 146;
                            case 47 -> 247;
                            case 48 -> 37;
                            case 49 -> 173;
                            case 50 -> 60;
                            case 51 -> 65;
                            case 52 -> 203;
                            case 53 -> 71;
                            case 54 -> 14;
                            case 55 -> 238;
                            case 56 -> 185;
                            case 57 -> 48;
                            case 58 -> 182;
                            case 59 -> 226;
                            case 60 -> 177;
                            case 61 -> 209;
                            case 62 -> 142;
                            case 63 -> 241;
                            case 64 -> 56;
                            case 65 -> 225;
                            case 66 -> 137;
                            case 67 -> 211;
                            case 68 -> 180;
                            case 69 -> 79;
                            case 70 -> 91;
                            case 71 -> 100;
                            case 72 -> 187;
                            case 73 -> 54;
                            case 74 -> 13;
                            case 75 -> 163;
                            case 76 -> 136;
                            case 77 -> 59;
                            case 78 -> 190;
                            case 79 -> 196;
                            case 80 -> 81;
                            case 81 -> 166;
                            case 82 -> 174;
                            case 83 -> 87;
                            case 84 -> 31;
                            case 85 -> 255;
                            case 86 -> 245;
                            case 87 -> 23;
                            case 88 -> 86;
                            case 89 -> 181;
                            case 90 -> 89;
                            case 91 -> 104;
                            case 92 -> 221;
                            case 93 -> 112;
                            case 94 -> 66;
                            case 95 -> 234;
                            case 96 -> 189;
                            case 97 -> 207;
                            case 98 -> 51;
                            case 99 -> 129;
                            case 100 -> 61;
                            case 101 -> 75;
                            case 102 -> 105;
                            case 103 -> 170;
                            case 104 -> 27;
                            case 105 -> 164;
                            case 106 -> 216;
                            case 107 -> 254;
                            case 108 -> 0;
                            case 109 -> 252;
                            case 110 -> 161;
                            case 111 -> 92;
                            case 112 -> 135;
                            case 113 -> 10;
                            case 114 -> 205;
                            case 115 -> 116;
                            case 116 -> 219;
                            case 117 -> 152;
                            case 118 -> 157;
                            case 119 -> 194;
                            case 120 -> 11;
                            case 121 -> 231;
                            case 122 -> 93;
                            case 123 -> 52;
                            case 124 -> 9;
                            case 125 -> 50;
                            case 126 -> 217;
                            case 127 -> 35;
                            case 128 -> 62;
                            case 129 -> 138;
                            case 130 -> 41;
                            case 131 -> 103;
                            case 132 -> 169;
                            case 133 -> 186;
                            case 134 -> 57;
                            case 135 -> 148;
                            case 136 -> 122;
                            case 137 -> 30;
                            case 138 -> 213;
                            case 139 -> 45;
                            case 140 -> 239;
                            case 141 -> 106;
                            case 142 -> 160;
                            case 143 -> 69;
                            case 144 -> 72;
                            case 145 -> 90;
                            case 146 -> 127;
                            case 147 -> 95;
                            case 148 -> 206;
                            case 149 -> 228;
                            case 150 -> 36;
                            case 151 -> 108;
                            case 152 -> 110;
                            case 153 -> 114;
                            case 154 -> 149;
                            case 155 -> 222;
                            case 156 -> 34;
                            case 157 -> 115;
                            case 158 -> 70;
                            case 159 -> 88;
                            case 160 -> 175;
                            case 161 -> 214;
                            case 162 -> 253;
                            case 163 -> 17;
                            case 164 -> 248;
                            case 165 -> 47;
                            case 166 -> 156;
                            case 167 -> 109;
                            case 168 -> 172;
                            case 169 -> 32;
                            case 170 -> 25;
                            case 171 -> 151;
                            case 172 -> 165;
                            case 173 -> 183;
                            case 174 -> 131;
                            case 175 -> 4;
                            case 176 -> 124;
                            case 177 -> 80;
                            case 178 -> 153;
                            case 179 -> 24;
                            case 180 -> 134;
                            case 181 -> 96;
                            case 182 -> 53;
                            case 183 -> 43;
                            case 184 -> 218;
                            case 185 -> 224;
                            case 186 -> 223;
                            case 187 -> 98;
                            case 188 -> 132;
                            case 189 -> 82;
                            case 190 -> 147;
                            case 191 -> 40;
                            case 192 -> 42;
                            case 193 -> 39;
                            case 194 -> 33;
                            case 195 -> 229;
                            case 196 -> 126;
                            case 197 -> 38;
                            case 198 -> 200;
                            case 199 -> 251;
                            case 200 -> 145;
                            case 201 -> 94;
                            case 202 -> 212;
                            case 203 -> 171;
                            case 204 -> 12;
                            case 205 -> 16;
                            case 206 -> 159;
                            case 207 -> 215;
                            case 208 -> 1;
                            case 209 -> 179;
                            case 210 -> 236;
                            case 211 -> 199;
                            case 212 -> 3;
                            case 213 -> 246;
                            case 214 -> 240;
                            case 215 -> 84;
                            case 216 -> 167;
                            case 217 -> 29;
                            case 218 -> 155;
                            case 219 -> 128;
                            case 220 -> 20;
                            case 221 -> 107;
                            case 222 -> 77;
                            case 223 -> 120;
                            case 224 -> 85;
                            case 225 -> 227;
                            case 226 -> 162;
                            case 227 -> 74;
                            case 228 -> 76;
                            case 229 -> 208;
                            case 230 -> 123;
                            case 231 -> 5;
                            case 232 -> 191;
                            case 233 -> 99;
                            case 234 -> 7;
                            case 235 -> 101;
                            case 236 -> 150;
                            case 237 -> 242;
                            case 238 -> 125;
                            case 239 -> 18;
                            case 240 -> 63;
                            case 241 -> 237;
                            case 242 -> 130;
                            case 243 -> 64;
                            case 244 -> 143;
                            case 245 -> 141;
                            case 246 -> 73;
                            case 247 -> 49;
                            case 248 -> 19;
                            case 249 -> 121;
                            case 250 -> 230;
                            case 251 -> 118;
                            case 252 -> 202;
                            case 253 -> 193;
                            case 254 -> 140;
                            default -> 144;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray != null) {
                ActionTimestamp.Q(new String[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 132148606128387L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.Q();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1052361030 - -4364, 1052361030 - 2988, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1052361030 - -4368, -1052361030 - -4310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1052361030 - -4389, -1052361030 - -6443, (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1052361030 - -4364, 1052361030 - 2988, (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1052361030 - -4368, -1052361030 - -4310, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1052361030 - -4388, 1052361030 + 3613, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l = 128413721508381L;
                        int[] nArray2 = SshAgentIpcService.Q();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1505601090 + (char)-379, -1505601090 + -((char)-6095), (int)l));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1505601090 + (char)-380, -1505732160 - -((char)-13331), (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l;
        block25: {
            block26: {
                l = 68035789987266L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    nArray = SshAgentIpcService.Q();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(786944280 - 19985, -786944280 - -19059, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(786944280 - 19981, 786944280 - 19911, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(786944280 - 19966, -786944280 + -7743, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(786944280 - 19981, 786944280 - 19911, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(786944280 - 19991, -786944280 + -10907, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(786944280 - 19985, -786944280 - -19059, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(786944280 - 19981, 786944280 - 19911, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(786944280 - 19965, 786944280 - 8190, (int)l));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(786944280 - 19985, -786944280 - -19059, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(786944280 - 19981, 786944280 - 19911, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(786944280 - 19972, 786944280 + 6918, (int)l) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(786944280 - 19985, -786944280 - -19059, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(786944280 - 19981, 786944280 - 19911, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(786944280 - 19971, -786944280 + -7277, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                int[] nArray;
                block16: {
                    l = 121645757732193L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.Q();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(600955950 + 12150, -600955950 + -12762, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(600955950 + 12154, 600955950 + 12228, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(600955950 + 12167, 600955950 + 19664, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(600955950 + 12166, 600955950 + (char)-30462, (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(600955950 + 12150, -600955950 + -12762, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(600955950 + 12154, 600955950 + 12228, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(600955950 + 12165, -600955950 + -((char)-30018), (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(600955950 + 12150, -600955950 + -12762, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(600955950 + 12154, 600955950 + 12228, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(600955950 + 12164, 600955950 + (char)-26644, (int)l) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(600955950 + 12150, -600955950 + -12762, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(600955950 + 12154, 600955950 + 12228, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(600955950 + 12163, 600955950 + (char)-30976, (int)l));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(600955950 + 12150, -600955950 + -12762, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(600955950 + 12154, 600955950 + 12228, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(600955950 + 12162, -600955950 + -((char)-23824), (int)l) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u0013\u00ecr|S\u00a5\u0088\u00c7\u0014p.&\u00c3'\u00da\u00a92\u00b4\u00adY\u00abb0\u0080\u00b8\u00fb\u0007p\u00e2\u0006\u0081M Hsb\u0018\u0002\u001e\b\u00f5`\u00d9C\u0092!\u00c4\u00e4\u00f6\u00b3d\u00e8\u00b0_o\u00car(r\u009e\u00a4\t\u0010r\u00d4\u00c9\u0090\u00c1E\u00d9\u00dd\u0005TQ\u009a\u00cb>\b\u0006z\u00d0\u00dfU\u00f7No\u0005U$\u00bae:\u001e\u0091=7\"\u0016\u00e7//\tg\u00aa\u00056:\u00fa\u001f\u00fc\u000bl\nPR\u009dm+\u0016x]\u0017\u0011\u0010\u00f5B_\bL\u0090\u00928\u00c37~\u00f2\u00aa\u0091\u00c6\u00f5\tJcI\u00fap\u0080\u007fnt\u0010I\u00e1\u00c8|\u00be\u001e\u00cc\u00e9\b\r\u0007\u00b5\u0085y#\u00e8?us\u00a3\u00eb\u0089\u00d7YE\u00b6\u00fb\u0018m\u00df\u00c1\u00faY9\u00a6\u00a9zf\u000e \u0080\u008cC\u0081C\u001f\u0084z\u0006\u00de\u001d_\u0095|G<\u00f8\u008ax\u00cdO\u00c6\n'\u0014\u008aO\u0013\u00d9\u00c8w&rH\u00d3G\u00c6Ur\u00a1\bN\u009d\u00d9#thj\u009c\f:\u0089G\u00ba\u00ba9]\u00b1\u0013N6\u00d9Fo\u00fc\u00ed\u0014\u00ef\u00ec\u00f7\u000bF\u0015\u0096v\u0098\u00aa\r\u0012;\u00a8\u00e9\u0014|\u0091`A\u00b2P\u00b5*&\u0080g\u00baA<n\u0090\u0080\u00aa\b\u0081\u009fB\u00e4\u00f3=\u0018\f+\bP%\u0090\u00e1\u00c8\u0015\u009e\u00b1:\u00eeGS+=\u00d9\u008a\u0081\b\u0082\u00a9\u00bd\u001f\u0082\u00bcU\u0012Z\u00e1\u00a6\u00ef8\u007f\u008c\u0006\u00f2Gi\u0001\u00f5 0\u00a5\u0010'Bh\u00b1f<\u009f\u0082\u00b8\u00f1\u000b\u00e6\u001b\u00dc\u00e8\u00c9s3\u00f8\u00dek\u0085\u0015\u0017\u00f2\u00e2\u00d6\t\u00dc\u00c7p~\u009aYq\u00f6\u0005\u00f4\u001f\u00bdw\u00e46\u00bc)\u0015\u0096\u00a7W\u0004Im\u00faA\u00dd\u00a3R\u0013\u00c7\u00cb\u0014\u00fe\n\u008aG\u00b7\u0003p\u00f4\u0098\u00bc\u00ce\u00bc\u00f3(]\u0091\u00f8\u00fc?\u0005\u00b4\u0005\u0005\u00dd\u009d\u0007\u00bd\u00a7\u00b8k\u00c3\u0093\u000e\u0007h\u0088f\u00e2\u00ffM\u009f(:\u00ce\u000e}\u0081f+8\u00f9R\u009e\u0095\u0097\u00be\u0019\u00b8\u00a32\u008f\u0003v\u00b5'\u00e9\u00e2\u00a37$\u00fb[\u0087\u00e6Xy\u00b5\u0018_\u00db\u00eb\u00f5\u000f~\u0007\u00c8m\u00b1\b\u00886\u00f8\u001e\u001fM\u0007\u00f1\u0095\"\u0016x\u00c7\u008a\b\u00f2\u00ec\u008dq3\u00a5\u008f\u00d0p\u00d7,\u0096$\r\u00c0\u00ad\u00f3\u0093\u00baw!\u00fe\u00d1\u00d1\u00b7\u00bbe\n\u0091\u000eb\u008dK<\u00c1\"\u0086s9\u00b6'X\fY\u001b\u00d5\u00b6\u00ba^\u0004\u00db\u00ab\u0010\u00cb]\u00f4$&\u00e0/(!\u000eF\u0019\u00ff\u00fc\u00aa\u00fd\u001b\u00a4&\n6\u0084\u0002\u001f\u0007\u0017\u0018\u00a3\u0016I\u0018:\u0086GU\u00ba\u0006]\u00f5\u000b(.\u0015\u00c4\u0095\u008f\u00a7B\u00fe\u00fd~\u00f0[\u0010Z)}\u0096\u00aaW\u00a5IY\u00fa\u00c7\u00ddsR\r\u00ce\u0097N\u000b4\u00ebE\u00a1S\u00fb\u00f2\u009c\u00ee\u00d3\u001a\u0003\u00a0\u00f8\u0011i2\u00d8H\u0096\u0088Al\u0015";
                var4_3 = "\u0013\u00ecr|S\u00a5\u0088\u00c7\u0014p.&\u00c3'\u00da\u00a92\u00b4\u00adY\u00abb0\u0080\u00b8\u00fb\u0007p\u00e2\u0006\u0081M Hsb\u0018\u0002\u001e\b\u00f5`\u00d9C\u0092!\u00c4\u00e4\u00f6\u00b3d\u00e8\u00b0_o\u00car(r\u009e\u00a4\t\u0010r\u00d4\u00c9\u0090\u00c1E\u00d9\u00dd\u0005TQ\u009a\u00cb>\b\u0006z\u00d0\u00dfU\u00f7No\u0005U$\u00bae:\u001e\u0091=7\"\u0016\u00e7//\tg\u00aa\u00056:\u00fa\u001f\u00fc\u000bl\nPR\u009dm+\u0016x]\u0017\u0011\u0010\u00f5B_\bL\u0090\u00928\u00c37~\u00f2\u00aa\u0091\u00c6\u00f5\tJcI\u00fap\u0080\u007fnt\u0010I\u00e1\u00c8|\u00be\u001e\u00cc\u00e9\b\r\u0007\u00b5\u0085y#\u00e8?us\u00a3\u00eb\u0089\u00d7YE\u00b6\u00fb\u0018m\u00df\u00c1\u00faY9\u00a6\u00a9zf\u000e \u0080\u008cC\u0081C\u001f\u0084z\u0006\u00de\u001d_\u0095|G<\u00f8\u008ax\u00cdO\u00c6\n'\u0014\u008aO\u0013\u00d9\u00c8w&rH\u00d3G\u00c6Ur\u00a1\bN\u009d\u00d9#thj\u009c\f:\u0089G\u00ba\u00ba9]\u00b1\u0013N6\u00d9Fo\u00fc\u00ed\u0014\u00ef\u00ec\u00f7\u000bF\u0015\u0096v\u0098\u00aa\r\u0012;\u00a8\u00e9\u0014|\u0091`A\u00b2P\u00b5*&\u0080g\u00baA<n\u0090\u0080\u00aa\b\u0081\u009fB\u00e4\u00f3=\u0018\f+\bP%\u0090\u00e1\u00c8\u0015\u009e\u00b1:\u00eeGS+=\u00d9\u008a\u0081\b\u0082\u00a9\u00bd\u001f\u0082\u00bcU\u0012Z\u00e1\u00a6\u00ef8\u007f\u008c\u0006\u00f2Gi\u0001\u00f5 0\u00a5\u0010'Bh\u00b1f<\u009f\u0082\u00b8\u00f1\u000b\u00e6\u001b\u00dc\u00e8\u00c9s3\u00f8\u00dek\u0085\u0015\u0017\u00f2\u00e2\u00d6\t\u00dc\u00c7p~\u009aYq\u00f6\u0005\u00f4\u001f\u00bdw\u00e46\u00bc)\u0015\u0096\u00a7W\u0004Im\u00faA\u00dd\u00a3R\u0013\u00c7\u00cb\u0014\u00fe\n\u008aG\u00b7\u0003p\u00f4\u0098\u00bc\u00ce\u00bc\u00f3(]\u0091\u00f8\u00fc?\u0005\u00b4\u0005\u0005\u00dd\u009d\u0007\u00bd\u00a7\u00b8k\u00c3\u0093\u000e\u0007h\u0088f\u00e2\u00ffM\u009f(:\u00ce\u000e}\u0081f+8\u00f9R\u009e\u0095\u0097\u00be\u0019\u00b8\u00a32\u008f\u0003v\u00b5'\u00e9\u00e2\u00a37$\u00fb[\u0087\u00e6Xy\u00b5\u0018_\u00db\u00eb\u00f5\u000f~\u0007\u00c8m\u00b1\b\u00886\u00f8\u001e\u001fM\u0007\u00f1\u0095\"\u0016x\u00c7\u008a\b\u00f2\u00ec\u008dq3\u00a5\u008f\u00d0p\u00d7,\u0096$\r\u00c0\u00ad\u00f3\u0093\u00baw!\u00fe\u00d1\u00d1\u00b7\u00bbe\n\u0091\u000eb\u008dK<\u00c1\"\u0086s9\u00b6'X\fY\u001b\u00d5\u00b6\u00ba^\u0004\u00db\u00ab\u0010\u00cb]\u00f4$&\u00e0/(!\u000eF\u0019\u00ff\u00fc\u00aa\u00fd\u001b\u00a4&\n6\u0084\u0002\u001f\u0007\u0017\u0018\u00a3\u0016I\u0018:\u0086GU\u00ba\u0006]\u00f5\u000b(.\u0015\u00c4\u0095\u008f\u00a7B\u00fe\u00fd~\u00f0[\u0010Z)}\u0096\u00aaW\u00a5IY\u00fa\u00c7\u00ddsR\r\u00ce\u0097N\u000b4\u00ebE\u00a1S\u00fb\u00f2\u009c\u00ee\u00d3\u001a\u0003\u00a0\u00f8\u0011i2\u00d8H\u0096\u0088Al\u0015".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 96;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00859sl\u00fe^;-\u0082\u001d>\u00c9\u0001\u007f\u0013\u008fL\u00e1\u00a6}\u009c\u00853\u00f7\u0093\u00aaHg\u0010hH\n\u00f6\u00c4U\u00f7\u00b8\u00bf=";
                    var4_3 = "\u00859sl\u00fe^;-\u0082\u001d>\u00c9\u0001\u007f\u0013\u008fL\u00e1\u00a6}\u009c\u00853\u00f7\u0093\u00aaHg\u0010hH\n\u00f6\u00c4U\u00f7\u00b8\u00bf=".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 71;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 83;
                            break;
                        }
                        case 1: {
                            v15 = 12;
                            break;
                        }
                        case 2: {
                            v15 = 24;
                            break;
                        }
                        case 3: {
                            v15 = 45;
                            break;
                        }
                        case 4: {
                            v15 = 92;
                            break;
                        }
                        case 5: {
                            v15 = 75;
                            break;
                        }
                        default: {
                            v15 = 43;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF9ECE) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 156;
                case 1 -> 206;
                case 2 -> 172;
                case 3 -> 227;
                case 4 -> 232;
                case 5 -> 40;
                case 6 -> 14;
                case 7 -> 50;
                case 8 -> 110;
                case 9 -> 66;
                case 10 -> 81;
                case 11 -> 1;
                case 12 -> 5;
                case 13 -> 154;
                case 14 -> 35;
                case 15 -> 171;
                case 16 -> 99;
                case 17 -> 105;
                case 18 -> 209;
                case 19 -> 116;
                case 20 -> 145;
                case 21 -> 109;
                case 22 -> 17;
                case 23 -> 214;
                case 24 -> 113;
                case 25 -> 36;
                case 26 -> 95;
                case 27 -> 96;
                case 28 -> 74;
                case 29 -> 63;
                case 30 -> 244;
                case 31 -> 3;
                case 32 -> 228;
                case 33 -> 134;
                case 34 -> 176;
                case 35 -> 47;
                case 36 -> 200;
                case 37 -> 189;
                case 38 -> 68;
                case 39 -> 42;
                case 40 -> 251;
                case 41 -> 143;
                case 42 -> 115;
                case 43 -> 248;
                case 44 -> 194;
                case 45 -> 223;
                case 46 -> 39;
                case 47 -> 122;
                case 48 -> 147;
                case 49 -> 37;
                case 50 -> 241;
                case 51 -> 250;
                case 52 -> 254;
                case 53 -> 30;
                case 54 -> 233;
                case 55 -> 4;
                case 56 -> 150;
                case 57 -> 62;
                case 58 -> 208;
                case 59 -> 12;
                case 60 -> 11;
                case 61 -> 28;
                case 62 -> 222;
                case 63 -> 163;
                case 64 -> 155;
                case 65 -> 77;
                case 66 -> 67;
                case 67 -> 152;
                case 68 -> 140;
                case 69 -> 219;
                case 70 -> 199;
                case 71 -> 73;
                case 72 -> 126;
                case 73 -> 48;
                case 74 -> 201;
                case 75 -> 86;
                case 76 -> 182;
                case 77 -> 97;
                case 78 -> 7;
                case 79 -> 59;
                case 80 -> 151;
                case 81 -> 78;
                case 82 -> 58;
                case 83 -> 43;
                case 84 -> 83;
                case 85 -> 85;
                case 86 -> 92;
                case 87 -> 118;
                case 88 -> 221;
                case 89 -> 107;
                case 90 -> 224;
                case 91 -> 136;
                case 92 -> 157;
                case 93 -> 165;
                case 94 -> 20;
                case 95 -> 190;
                case 96 -> 127;
                case 97 -> 70;
                case 98 -> 46;
                case 99 -> 230;
                case 100 -> 9;
                case 101 -> 204;
                case 102 -> 125;
                case 103 -> 218;
                case 104 -> 84;
                case 105 -> 23;
                case 106 -> 104;
                case 107 -> 238;
                case 108 -> 246;
                case 109 -> 8;
                case 110 -> 245;
                case 111 -> 249;
                case 112 -> 102;
                case 113 -> 33;
                case 114 -> 205;
                case 115 -> 162;
                case 116 -> 197;
                case 117 -> 179;
                case 118 -> 160;
                case 119 -> 55;
                case 120 -> 101;
                case 121 -> 243;
                case 122 -> 124;
                case 123 -> 138;
                case 124 -> 18;
                case 125 -> 72;
                case 126 -> 239;
                case 127 -> 38;
                case 128 -> 181;
                case 129 -> 51;
                case 130 -> 56;
                case 131 -> 49;
                case 132 -> 148;
                case 133 -> 192;
                case 134 -> 170;
                case 135 -> 202;
                case 136 -> 193;
                case 137 -> 216;
                case 138 -> 129;
                case 139 -> 175;
                case 140 -> 247;
                case 141 -> 178;
                case 142 -> 146;
                case 143 -> 27;
                case 144 -> 252;
                case 145 -> 164;
                case 146 -> 64;
                case 147 -> 65;
                case 148 -> 89;
                case 149 -> 211;
                case 150 -> 167;
                case 151 -> 153;
                case 152 -> 75;
                case 153 -> 255;
                case 154 -> 131;
                case 155 -> 231;
                case 156 -> 22;
                case 157 -> 0;
                case 158 -> 119;
                case 159 -> 93;
                case 160 -> 173;
                case 161 -> 132;
                case 162 -> 169;
                case 163 -> 87;
                case 164 -> 106;
                case 165 -> 120;
                case 166 -> 34;
                case 167 -> 188;
                case 168 -> 144;
                case 169 -> 130;
                case 170 -> 21;
                case 171 -> 137;
                case 172 -> 53;
                case 173 -> 212;
                case 174 -> 234;
                case 175 -> 57;
                case 176 -> 210;
                case 177 -> 61;
                case 178 -> 45;
                case 179 -> 237;
                case 180 -> 25;
                case 181 -> 141;
                case 182 -> 52;
                case 183 -> 213;
                case 184 -> 149;
                case 185 -> 236;
                case 186 -> 207;
                case 187 -> 215;
                case 188 -> 235;
                case 189 -> 117;
                case 190 -> 44;
                case 191 -> 29;
                case 192 -> 15;
                case 193 -> 229;
                case 194 -> 91;
                case 195 -> 139;
                case 196 -> 187;
                case 197 -> 123;
                case 198 -> 180;
                case 199 -> 69;
                case 200 -> 98;
                case 201 -> 158;
                case 202 -> 26;
                case 203 -> 253;
                case 204 -> 159;
                case 205 -> 225;
                case 206 -> 135;
                case 207 -> 198;
                case 208 -> 161;
                case 209 -> 60;
                case 210 -> 174;
                case 211 -> 13;
                case 212 -> 121;
                case 213 -> 112;
                case 214 -> 111;
                case 215 -> 186;
                case 216 -> 220;
                case 217 -> 79;
                case 218 -> 31;
                case 219 -> 88;
                case 220 -> 100;
                case 221 -> 217;
                case 222 -> 24;
                case 223 -> 114;
                case 224 -> 108;
                case 225 -> 32;
                case 226 -> 128;
                case 227 -> 2;
                case 228 -> 82;
                case 229 -> 142;
                case 230 -> 195;
                case 231 -> 196;
                case 232 -> 10;
                case 233 -> 16;
                case 234 -> 226;
                case 235 -> 54;
                case 236 -> 6;
                case 237 -> 71;
                case 238 -> 242;
                case 239 -> 94;
                case 240 -> 90;
                case 241 -> 19;
                case 242 -> 185;
                case 243 -> 103;
                case 244 -> 184;
                case 245 -> 166;
                case 246 -> 41;
                case 247 -> 177;
                case 248 -> 183;
                case 249 -> 80;
                case 250 -> 133;
                case 251 -> 76;
                case 252 -> 240;
                case 253 -> 203;
                case 254 -> 191;
                default -> 168;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 5149626958182L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(38796720 + 17967, -38796720 + -21087, (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l = 26574990438500L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.Q();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2027783970 - -14846, -2027783970 - -25686, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2027783970 - -14849, -2027783970 - -2159, (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2027783970 - -14848, -2027783970 - -15310, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00d5-K*z\u00af\r_\u0010n\u0087\u00cd\u00de\u0010\u008a\u00b9\u00a2\u00e5\u0085\u00d4\u00aa?:\u00ad\u00c3";
                    var4_3 = "\u00d5-K*z\u00af\r_\u0010n\u0087\u00cd\u00de\u0010\u008a\u00b9\u00a2\u00e5\u0085\u00d4\u00aa?:\u00ad\u00c3".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 120;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00f2{\u0000O\u00cc5\u00c9\u0097p\u00be\u0010\u0010\u000e\u00f5\u00cb{,\u001axi\u00ef\u008c\u00cb\u0014\u00c1\u00d2x\u00e8\u00a3F\\\u0095\u00eb\u00bc\u00b4\u00a7\u0090\u00e4\u00de\u0092TS4\u00fb\u00b0\u00a5\u00c4\u00f3\u00e5:\u00d8\u008e\u00b7y#b\u00d9\u0017\u0015";
                        var4_3 = "\u00f2{\u0000O\u00cc5\u00c9\u0097p\u00be\u0010\u0010\u000e\u00f5\u00cb{,\u001axi\u00ef\u008c\u00cb\u0014\u00c1\u00d2x\u00e8\u00a3F\\\u0095\u00eb\u00bc\u00b4\u00a7\u0090\u00e4\u00de\u0092TS4\u00fb\u00b0\u00a5\u00c4\u00f3\u00e5:\u00d8\u008e\u00b7y#b\u00d9\u0017\u0015".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 63;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 22;
                                break;
                            }
                            case 1: {
                                v15 = 94;
                                break;
                            }
                            case 2: {
                                v15 = 74;
                                break;
                            }
                            case 3: {
                                v15 = 18;
                                break;
                            }
                            case 4: {
                                v15 = 3;
                                break;
                            }
                            case 5: {
                                v15 = 119;
                                break;
                            }
                            default: {
                                v15 = 123;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC2B9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 233;
                    case 1 -> 185;
                    case 2 -> 38;
                    case 3 -> 33;
                    case 4 -> 209;
                    case 5 -> 245;
                    case 6 -> 148;
                    case 7 -> 164;
                    case 8 -> 107;
                    case 9 -> 70;
                    case 10 -> 181;
                    case 11 -> 168;
                    case 12 -> 84;
                    case 13 -> 57;
                    case 14 -> 82;
                    case 15 -> 178;
                    case 16 -> 216;
                    case 17 -> 206;
                    case 18 -> 48;
                    case 19 -> 53;
                    case 20 -> 217;
                    case 21 -> 240;
                    case 22 -> 208;
                    case 23 -> 56;
                    case 24 -> 85;
                    case 25 -> 239;
                    case 26 -> 248;
                    case 27 -> 0;
                    case 28 -> 176;
                    case 29 -> 28;
                    case 30 -> 199;
                    case 31 -> 196;
                    case 32 -> 115;
                    case 33 -> 143;
                    case 34 -> 26;
                    case 35 -> 155;
                    case 36 -> 97;
                    case 37 -> 106;
                    case 38 -> 118;
                    case 39 -> 69;
                    case 40 -> 5;
                    case 41 -> 134;
                    case 42 -> 188;
                    case 43 -> 21;
                    case 44 -> 87;
                    case 45 -> 90;
                    case 46 -> 19;
                    case 47 -> 93;
                    case 48 -> 183;
                    case 49 -> 13;
                    case 50 -> 210;
                    case 51 -> 24;
                    case 52 -> 187;
                    case 53 -> 47;
                    case 54 -> 246;
                    case 55 -> 113;
                    case 56 -> 159;
                    case 57 -> 34;
                    case 58 -> 120;
                    case 59 -> 54;
                    case 60 -> 193;
                    case 61 -> 191;
                    case 62 -> 232;
                    case 63 -> 65;
                    case 64 -> 45;
                    case 65 -> 112;
                    case 66 -> 231;
                    case 67 -> 157;
                    case 68 -> 16;
                    case 69 -> 175;
                    case 70 -> 104;
                    case 71 -> 146;
                    case 72 -> 63;
                    case 73 -> 166;
                    case 74 -> 40;
                    case 75 -> 195;
                    case 76 -> 203;
                    case 77 -> 131;
                    case 78 -> 250;
                    case 79 -> 237;
                    case 80 -> 10;
                    case 81 -> 102;
                    case 82 -> 23;
                    case 83 -> 51;
                    case 84 -> 254;
                    case 85 -> 72;
                    case 86 -> 86;
                    case 87 -> 27;
                    case 88 -> 205;
                    case 89 -> 207;
                    case 90 -> 201;
                    case 91 -> 32;
                    case 92 -> 78;
                    case 93 -> 35;
                    case 94 -> 100;
                    case 95 -> 142;
                    case 96 -> 17;
                    case 97 -> 251;
                    case 98 -> 77;
                    case 99 -> 224;
                    case 100 -> 73;
                    case 101 -> 138;
                    case 102 -> 39;
                    case 103 -> 4;
                    case 104 -> 61;
                    case 105 -> 226;
                    case 106 -> 58;
                    case 107 -> 1;
                    case 108 -> 135;
                    case 109 -> 37;
                    case 110 -> 123;
                    case 111 -> 50;
                    case 112 -> 75;
                    case 113 -> 130;
                    case 114 -> 242;
                    case 115 -> 83;
                    case 116 -> 197;
                    case 117 -> 225;
                    case 118 -> 223;
                    case 119 -> 31;
                    case 120 -> 9;
                    case 121 -> 74;
                    case 122 -> 125;
                    case 123 -> 247;
                    case 124 -> 230;
                    case 125 -> 255;
                    case 126 -> 133;
                    case 127 -> 127;
                    case 128 -> 147;
                    case 129 -> 184;
                    case 130 -> 94;
                    case 131 -> 215;
                    case 132 -> 80;
                    case 133 -> 145;
                    case 134 -> 177;
                    case 135 -> 128;
                    case 136 -> 173;
                    case 137 -> 6;
                    case 138 -> 109;
                    case 139 -> 41;
                    case 140 -> 249;
                    case 141 -> 144;
                    case 142 -> 202;
                    case 143 -> 43;
                    case 144 -> 12;
                    case 145 -> 163;
                    case 146 -> 192;
                    case 147 -> 180;
                    case 148 -> 121;
                    case 149 -> 46;
                    case 150 -> 212;
                    case 151 -> 150;
                    case 152 -> 8;
                    case 153 -> 235;
                    case 154 -> 92;
                    case 155 -> 160;
                    case 156 -> 15;
                    case 157 -> 154;
                    case 158 -> 139;
                    case 159 -> 55;
                    case 160 -> 132;
                    case 161 -> 25;
                    case 162 -> 236;
                    case 163 -> 140;
                    case 164 -> 44;
                    case 165 -> 30;
                    case 166 -> 149;
                    case 167 -> 108;
                    case 168 -> 234;
                    case 169 -> 172;
                    case 170 -> 137;
                    case 171 -> 96;
                    case 172 -> 252;
                    case 173 -> 174;
                    case 174 -> 129;
                    case 175 -> 189;
                    case 176 -> 105;
                    case 177 -> 114;
                    case 178 -> 81;
                    case 179 -> 167;
                    case 180 -> 64;
                    case 181 -> 221;
                    case 182 -> 122;
                    case 183 -> 68;
                    case 184 -> 222;
                    case 185 -> 152;
                    case 186 -> 170;
                    case 187 -> 204;
                    case 188 -> 7;
                    case 189 -> 79;
                    case 190 -> 22;
                    case 191 -> 182;
                    case 192 -> 29;
                    case 193 -> 20;
                    case 194 -> 49;
                    case 195 -> 88;
                    case 196 -> 111;
                    case 197 -> 243;
                    case 198 -> 91;
                    case 199 -> 228;
                    case 200 -> 220;
                    case 201 -> 169;
                    case 202 -> 66;
                    case 203 -> 211;
                    case 204 -> 103;
                    case 205 -> 95;
                    case 206 -> 179;
                    case 207 -> 214;
                    case 208 -> 11;
                    case 209 -> 71;
                    case 210 -> 162;
                    case 211 -> 190;
                    case 212 -> 60;
                    case 213 -> 186;
                    case 214 -> 76;
                    case 215 -> 52;
                    case 216 -> 198;
                    case 217 -> 141;
                    case 218 -> 158;
                    case 219 -> 126;
                    case 220 -> 116;
                    case 221 -> 136;
                    case 222 -> 219;
                    case 223 -> 18;
                    case 224 -> 238;
                    case 225 -> 3;
                    case 226 -> 59;
                    case 227 -> 227;
                    case 228 -> 14;
                    case 229 -> 42;
                    case 230 -> 36;
                    case 231 -> 119;
                    case 232 -> 161;
                    case 233 -> 153;
                    case 234 -> 124;
                    case 235 -> 253;
                    case 236 -> 151;
                    case 237 -> 244;
                    case 238 -> 67;
                    case 239 -> 156;
                    case 240 -> 200;
                    case 241 -> 110;
                    case 242 -> 213;
                    case 243 -> 171;
                    case 244 -> 218;
                    case 245 -> 241;
                    case 246 -> 89;
                    case 247 -> 98;
                    case 248 -> 2;
                    case 249 -> 117;
                    case 250 -> 194;
                    case 251 -> 229;
                    case 252 -> 99;
                    case 253 -> 101;
                    case 254 -> 62;
                    default -> 165;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 102870089540372L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "J(}\u0004ATH\u0013\tM\"n\u000e\f\u0016U\u000fd";
                    var5_4 = "J(}\u0004ATH\u0013\tM\"n\u000e\f\u0016U\u000fd".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 67;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 98;
                                    break;
                                }
                                case 1: {
                                    v11 = 14;
                                    break;
                                }
                                case 2: {
                                    v11 = 76;
                                    break;
                                }
                                case 3: {
                                    v11 = 41;
                                    break;
                                }
                                case 4: {
                                    v11 = 103;
                                    break;
                                }
                                case 5: {
                                    v11 = 123;
                                    break;
                                }
                                default: {
                                    v11 = 56;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 112211455364022L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u007fUY1\u001beP\u0004yKU+\nuT^+\u0017gH_UW\tuT^+\u0017gHS_\rrRC&\u001djRSXD,\u001cc";
                    var5_4 = "\u007fUY1\u001beP\u0004yKU+\nuT^+\u0017gH_UW\tuT^+\u0017gHS_\rrRC&\u001djRSXD,\u001cc".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 12;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Kia\b%Te\u0006Kia\b)^";
                        var5_4 = "Kia\b%Te\u0006Kia\b)^".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 50;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 58;
                                break;
                            }
                            case 1: {
                                v15 = 55;
                                break;
                            }
                            case 2: {
                                v15 = 60;
                                break;
                            }
                            case 3: {
                                v15 = 73;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 8;
                                break;
                            }
                            default: {
                                v15 = 48;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 26689425568460L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-498852420 - -((char)-6656), -498721350 + -((char)-6288), (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 83338324657283L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "w!d\u007f\u00cc\u0003\u0002.~\u00053\u00e2\u00ca\u00c3\u00fa\roHw\u00dc\u00b85k\u00a6\u00e3\u00dc\u00e7\f\u00d5\u0010\u0019H~7\u00a6\u00dd\u0083\u00867\\\u009eQ\u001c\u00a9\u0007$\u0005\u00b8d\u00bb\u0013\u00d43\u00d9\u0005\u0086Hlv\u00ea\u00e7g\u008d\u001fB\u00ea\u009a\u00f5]J\u008a\u00e9\u00c4\u0099M\u00c3\u0088$\u00bc\u00c8\u008c\u000f/*\u0017'\u008f\u00c8\u00fag~\u00d5p0P\u000bF\u0086\u00cc}\u00de\u00b0\u00c7a";
                    var4_3 = "w!d\u007f\u00cc\u0003\u0002.~\u00053\u00e2\u00ca\u00c3\u00fa\roHw\u00dc\u00b85k\u00a6\u00e3\u00dc\u00e7\f\u00d5\u0010\u0019H~7\u00a6\u00dd\u0083\u00867\\\u009eQ\u001c\u00a9\u0007$\u0005\u00b8d\u00bb\u0013\u00d43\u00d9\u0005\u0086Hlv\u00ea\u00e7g\u008d\u001fB\u00ea\u009a\u00f5]J\u008a\u00e9\u00c4\u0099M\u00c3\u0088$\u00bc\u00c8\u008c\u000f/*\u0017'\u008f\u00c8\u00fag~\u00d5p0P\u000bF\u0086\u00cc}\u00de\u00b0\u00c7a".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 84;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u009c\u001a\u00b6\u0005\u00c7\u00e3\u00d79\u00c5\u00d3\u00b8\u00d8\u00a0\u00e0\u00e8uL\u00eet\u000f\u0002\u00da\u00cb\u001aR\u00f5-\u0012\u00be\u00fb\u00a2\u0010D\u008b\u0000V\u001b~\u00aam\u00ae\u00aa\u00ebD\u00d8\u001c\u0094\u00dfw\u00f1\u0015\u001b\u00cdW>\u0091f\u00f6\u0017d\u00ab\u0006\u00d7\u00de\u00fdN\u00ef.\u00b8F4\u00da\u00dc\u00bc|\u00d2\fe\u0081;\u0096\u0091\u00ac\u0097\u00f0!\u0090\u001d\u00d2\u00c5\u00ed\u00921";
                        var4_3 = "\u009c\u001a\u00b6\u0005\u00c7\u00e3\u00d79\u00c5\u00d3\u00b8\u00d8\u00a0\u00e0\u00e8uL\u00eet\u000f\u0002\u00da\u00cb\u001aR\u00f5-\u0012\u00be\u00fb\u00a2\u0010D\u008b\u0000V\u001b~\u00aam\u00ae\u00aa\u00ebD\u00d8\u001c\u0094\u00dfw\u00f1\u0015\u001b\u00cdW>\u0091f\u00f6\u0017d\u00ab\u0006\u00d7\u00de\u00fdN\u00ef.\u00b8F4\u00da\u00dc\u00bc|\u00d2\fe\u0081;\u0096\u0091\u00ac\u0097\u00f0!\u0090\u001d\u00d2\u00c5\u00ed\u00921".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 79;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 113;
                                break;
                            }
                            case 1: {
                                v15 = 99;
                                break;
                            }
                            case 2: {
                                v15 = 82;
                                break;
                            }
                            case 3: {
                                v15 = 12;
                                break;
                            }
                            case 4: {
                                v15 = 105;
                                break;
                            }
                            case 5: {
                                v15 = 119;
                                break;
                            }
                            default: {
                                v15 = 115;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF170) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 60;
                    case 1 -> 144;
                    case 2 -> 204;
                    case 3 -> 176;
                    case 4 -> 53;
                    case 5 -> 41;
                    case 6 -> 136;
                    case 7 -> 207;
                    case 8 -> 24;
                    case 9 -> 169;
                    case 10 -> 100;
                    case 11 -> 15;
                    case 12 -> 101;
                    case 13 -> 240;
                    case 14 -> 109;
                    case 15 -> 186;
                    case 16 -> 8;
                    case 17 -> 147;
                    case 18 -> 26;
                    case 19 -> 19;
                    case 20 -> 72;
                    case 21 -> 180;
                    case 22 -> 106;
                    case 23 -> 223;
                    case 24 -> 148;
                    case 25 -> 157;
                    case 26 -> 104;
                    case 27 -> 14;
                    case 28 -> 99;
                    case 29 -> 48;
                    case 30 -> 43;
                    case 31 -> 219;
                    case 32 -> 108;
                    case 33 -> 45;
                    case 34 -> 22;
                    case 35 -> 6;
                    case 36 -> 164;
                    case 37 -> 251;
                    case 38 -> 145;
                    case 39 -> 167;
                    case 40 -> 7;
                    case 41 -> 153;
                    case 42 -> 200;
                    case 43 -> 125;
                    case 44 -> 63;
                    case 45 -> 117;
                    case 46 -> 174;
                    case 47 -> 189;
                    case 48 -> 13;
                    case 49 -> 165;
                    case 50 -> 42;
                    case 51 -> 126;
                    case 52 -> 28;
                    case 53 -> 218;
                    case 54 -> 149;
                    case 55 -> 21;
                    case 56 -> 47;
                    case 57 -> 244;
                    case 58 -> 252;
                    case 59 -> 196;
                    case 60 -> 221;
                    case 61 -> 171;
                    case 62 -> 193;
                    case 63 -> 253;
                    case 64 -> 112;
                    case 65 -> 236;
                    case 66 -> 35;
                    case 67 -> 235;
                    case 68 -> 62;
                    case 69 -> 95;
                    case 70 -> 224;
                    case 71 -> 168;
                    case 72 -> 23;
                    case 73 -> 202;
                    case 74 -> 172;
                    case 75 -> 3;
                    case 76 -> 203;
                    case 77 -> 212;
                    case 78 -> 30;
                    case 79 -> 119;
                    case 80 -> 226;
                    case 81 -> 89;
                    case 82 -> 83;
                    case 83 -> 55;
                    case 84 -> 213;
                    case 85 -> 183;
                    case 86 -> 129;
                    case 87 -> 166;
                    case 88 -> 40;
                    case 89 -> 137;
                    case 90 -> 191;
                    case 91 -> 217;
                    case 92 -> 214;
                    case 93 -> 179;
                    case 94 -> 44;
                    case 95 -> 85;
                    case 96 -> 154;
                    case 97 -> 12;
                    case 98 -> 110;
                    case 99 -> 37;
                    case 100 -> 232;
                    case 101 -> 98;
                    case 102 -> 79;
                    case 103 -> 111;
                    case 104 -> 25;
                    case 105 -> 233;
                    case 106 -> 29;
                    case 107 -> 158;
                    case 108 -> 210;
                    case 109 -> 82;
                    case 110 -> 56;
                    case 111 -> 16;
                    case 112 -> 87;
                    case 113 -> 156;
                    case 114 -> 198;
                    case 115 -> 139;
                    case 116 -> 124;
                    case 117 -> 141;
                    case 118 -> 152;
                    case 119 -> 31;
                    case 120 -> 162;
                    case 121 -> 151;
                    case 122 -> 38;
                    case 123 -> 173;
                    case 124 -> 241;
                    case 125 -> 161;
                    case 126 -> 71;
                    case 127 -> 5;
                    case 128 -> 78;
                    case 129 -> 205;
                    case 130 -> 105;
                    case 131 -> 52;
                    case 132 -> 239;
                    case 133 -> 114;
                    case 134 -> 237;
                    case 135 -> 4;
                    case 136 -> 2;
                    case 137 -> 254;
                    case 138 -> 146;
                    case 139 -> 188;
                    case 140 -> 96;
                    case 141 -> 247;
                    case 142 -> 187;
                    case 143 -> 61;
                    case 144 -> 93;
                    case 145 -> 209;
                    case 146 -> 34;
                    case 147 -> 84;
                    case 148 -> 120;
                    case 149 -> 58;
                    case 150 -> 88;
                    case 151 -> 199;
                    case 152 -> 216;
                    case 153 -> 121;
                    case 154 -> 231;
                    case 155 -> 90;
                    case 156 -> 68;
                    case 157 -> 131;
                    case 158 -> 10;
                    case 159 -> 9;
                    case 160 -> 211;
                    case 161 -> 229;
                    case 162 -> 194;
                    case 163 -> 54;
                    case 164 -> 201;
                    case 165 -> 123;
                    case 166 -> 115;
                    case 167 -> 51;
                    case 168 -> 36;
                    case 169 -> 118;
                    case 170 -> 132;
                    case 171 -> 246;
                    case 172 -> 74;
                    case 173 -> 57;
                    case 174 -> 73;
                    case 175 -> 192;
                    case 176 -> 50;
                    case 177 -> 91;
                    case 178 -> 175;
                    case 179 -> 143;
                    case 180 -> 190;
                    case 181 -> 64;
                    case 182 -> 243;
                    case 183 -> 242;
                    case 184 -> 133;
                    case 185 -> 33;
                    case 186 -> 255;
                    case 187 -> 182;
                    case 188 -> 17;
                    case 189 -> 206;
                    case 190 -> 69;
                    case 191 -> 32;
                    case 192 -> 80;
                    case 193 -> 70;
                    case 194 -> 107;
                    case 195 -> 102;
                    case 196 -> 1;
                    case 197 -> 11;
                    case 198 -> 20;
                    case 199 -> 59;
                    case 200 -> 170;
                    case 201 -> 97;
                    case 202 -> 150;
                    case 203 -> 177;
                    case 204 -> 66;
                    case 205 -> 234;
                    case 206 -> 94;
                    case 207 -> 227;
                    case 208 -> 39;
                    case 209 -> 49;
                    case 210 -> 250;
                    case 211 -> 163;
                    case 212 -> 184;
                    case 213 -> 103;
                    case 214 -> 249;
                    case 215 -> 222;
                    case 216 -> 134;
                    case 217 -> 215;
                    case 218 -> 135;
                    case 219 -> 138;
                    case 220 -> 0;
                    case 221 -> 181;
                    case 222 -> 197;
                    case 223 -> 81;
                    case 224 -> 228;
                    case 225 -> 18;
                    case 226 -> 46;
                    case 227 -> 208;
                    case 228 -> 185;
                    case 229 -> 27;
                    case 230 -> 113;
                    case 231 -> 86;
                    case 232 -> 155;
                    case 233 -> 128;
                    case 234 -> 92;
                    case 235 -> 77;
                    case 236 -> 75;
                    case 237 -> 230;
                    case 238 -> 178;
                    case 239 -> 245;
                    case 240 -> 248;
                    case 241 -> 116;
                    case 242 -> 65;
                    case 243 -> 195;
                    case 244 -> 142;
                    case 245 -> 76;
                    case 246 -> 127;
                    case 247 -> 67;
                    case 248 -> 160;
                    case 249 -> 122;
                    case 250 -> 159;
                    case 251 -> 225;
                    case 252 -> 220;
                    case 253 -> 130;
                    case 254 -> 140;
                    default -> 238;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 68986182466805L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-417720090 + -10401, 417720090 + (char)-28796, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 9586491247463L;
                    int[] nArray = SshAgentIpcService.Q();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-124254360 - -16494, -124254360 - -1861, (int)l));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 104966497429597L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "F\u0016\u008c\u00f0\u00fa\u0003\u00cd\u00fc\u00ab";
                var4_3 = "F\u0016\u008c\u00f0\u00fa\u0003\u00cd\u00fc\u00ab".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 59;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 115;
                                break;
                            }
                            case 1: {
                                v11 = 68;
                                break;
                            }
                            case 2: {
                                v11 = 94;
                                break;
                            }
                            case 3: {
                                v11 = 3;
                                break;
                            }
                            case 4: {
                                v11 = 65;
                                break;
                            }
                            case 5: {
                                v11 = 39;
                                break;
                            }
                            default: {
                                v11 = 113;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8CB0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 190;
                    case 1 -> 38;
                    case 2 -> 34;
                    case 3 -> 12;
                    case 4 -> 2;
                    case 5 -> 13;
                    case 6 -> 225;
                    case 7 -> 174;
                    case 8 -> 3;
                    case 9 -> 93;
                    case 10 -> 197;
                    case 11 -> 209;
                    case 12 -> 57;
                    case 13 -> 29;
                    case 14 -> 252;
                    case 15 -> 164;
                    case 16 -> 37;
                    case 17 -> 208;
                    case 18 -> 162;
                    case 19 -> 98;
                    case 20 -> 31;
                    case 21 -> 161;
                    case 22 -> 152;
                    case 23 -> 104;
                    case 24 -> 105;
                    case 25 -> 101;
                    case 26 -> 9;
                    case 27 -> 183;
                    case 28 -> 111;
                    case 29 -> 83;
                    case 30 -> 244;
                    case 31 -> 165;
                    case 32 -> 21;
                    case 33 -> 75;
                    case 34 -> 102;
                    case 35 -> 70;
                    case 36 -> 97;
                    case 37 -> 151;
                    case 38 -> 124;
                    case 39 -> 10;
                    case 40 -> 253;
                    case 41 -> 224;
                    case 42 -> 69;
                    case 43 -> 131;
                    case 44 -> 134;
                    case 45 -> 204;
                    case 46 -> 65;
                    case 47 -> 230;
                    case 48 -> 20;
                    case 49 -> 35;
                    case 50 -> 22;
                    case 51 -> 143;
                    case 52 -> 149;
                    case 53 -> 192;
                    case 54 -> 112;
                    case 55 -> 188;
                    case 56 -> 217;
                    case 57 -> 11;
                    case 58 -> 7;
                    case 59 -> 68;
                    case 60 -> 232;
                    case 61 -> 109;
                    case 62 -> 123;
                    case 63 -> 125;
                    case 64 -> 14;
                    case 65 -> 246;
                    case 66 -> 54;
                    case 67 -> 189;
                    case 68 -> 148;
                    case 69 -> 33;
                    case 70 -> 6;
                    case 71 -> 62;
                    case 72 -> 153;
                    case 73 -> 238;
                    case 74 -> 90;
                    case 75 -> 220;
                    case 76 -> 42;
                    case 77 -> 108;
                    case 78 -> 228;
                    case 79 -> 18;
                    case 80 -> 166;
                    case 81 -> 46;
                    case 82 -> 25;
                    case 83 -> 231;
                    case 84 -> 79;
                    case 85 -> 227;
                    case 86 -> 154;
                    case 87 -> 107;
                    case 88 -> 170;
                    case 89 -> 116;
                    case 90 -> 89;
                    case 91 -> 119;
                    case 92 -> 86;
                    case 93 -> 76;
                    case 94 -> 198;
                    case 95 -> 0;
                    case 96 -> 130;
                    case 97 -> 137;
                    case 98 -> 53;
                    case 99 -> 23;
                    case 100 -> 157;
                    case 101 -> 58;
                    case 102 -> 78;
                    case 103 -> 44;
                    case 104 -> 138;
                    case 105 -> 176;
                    case 106 -> 19;
                    case 107 -> 67;
                    case 108 -> 206;
                    case 109 -> 95;
                    case 110 -> 103;
                    case 111 -> 17;
                    case 112 -> 85;
                    case 113 -> 169;
                    case 114 -> 30;
                    case 115 -> 100;
                    case 116 -> 72;
                    case 117 -> 4;
                    case 118 -> 219;
                    case 119 -> 126;
                    case 120 -> 41;
                    case 121 -> 52;
                    case 122 -> 8;
                    case 123 -> 200;
                    case 124 -> 36;
                    case 125 -> 249;
                    case 126 -> 110;
                    case 127 -> 84;
                    case 128 -> 159;
                    case 129 -> 26;
                    case 130 -> 207;
                    case 131 -> 201;
                    case 132 -> 196;
                    case 133 -> 212;
                    case 134 -> 94;
                    case 135 -> 63;
                    case 136 -> 213;
                    case 137 -> 251;
                    case 138 -> 242;
                    case 139 -> 141;
                    case 140 -> 92;
                    case 141 -> 236;
                    case 142 -> 106;
                    case 143 -> 16;
                    case 144 -> 180;
                    case 145 -> 193;
                    case 146 -> 234;
                    case 147 -> 186;
                    case 148 -> 178;
                    case 149 -> 203;
                    case 150 -> 48;
                    case 151 -> 202;
                    case 152 -> 172;
                    case 153 -> 136;
                    case 154 -> 239;
                    case 155 -> 28;
                    case 156 -> 142;
                    case 157 -> 59;
                    case 158 -> 15;
                    case 159 -> 74;
                    case 160 -> 182;
                    case 161 -> 145;
                    case 162 -> 195;
                    case 163 -> 40;
                    case 164 -> 155;
                    case 165 -> 150;
                    case 166 -> 118;
                    case 167 -> 115;
                    case 168 -> 205;
                    case 169 -> 171;
                    case 170 -> 47;
                    case 171 -> 158;
                    case 172 -> 250;
                    case 173 -> 113;
                    case 174 -> 114;
                    case 175 -> 140;
                    case 176 -> 82;
                    case 177 -> 235;
                    case 178 -> 55;
                    case 179 -> 64;
                    case 180 -> 215;
                    case 181 -> 1;
                    case 182 -> 185;
                    case 183 -> 237;
                    case 184 -> 187;
                    case 185 -> 191;
                    case 186 -> 226;
                    case 187 -> 87;
                    case 188 -> 167;
                    case 189 -> 211;
                    case 190 -> 160;
                    case 191 -> 221;
                    case 192 -> 66;
                    case 193 -> 77;
                    case 194 -> 60;
                    case 195 -> 96;
                    case 196 -> 121;
                    case 197 -> 81;
                    case 198 -> 247;
                    case 199 -> 5;
                    case 200 -> 216;
                    case 201 -> 27;
                    case 202 -> 175;
                    case 203 -> 194;
                    case 204 -> 248;
                    case 205 -> 129;
                    case 206 -> 229;
                    case 207 -> 32;
                    case 208 -> 117;
                    case 209 -> 163;
                    case 210 -> 56;
                    case 211 -> 50;
                    case 212 -> 91;
                    case 213 -> 127;
                    case 214 -> 39;
                    case 215 -> 233;
                    case 216 -> 144;
                    case 217 -> 128;
                    case 218 -> 132;
                    case 219 -> 43;
                    case 220 -> 245;
                    case 221 -> 156;
                    case 222 -> 240;
                    case 223 -> 61;
                    case 224 -> 181;
                    case 225 -> 147;
                    case 226 -> 184;
                    case 227 -> 24;
                    case 228 -> 71;
                    case 229 -> 177;
                    case 230 -> 214;
                    case 231 -> 88;
                    case 232 -> 255;
                    case 233 -> 241;
                    case 234 -> 254;
                    case 235 -> 133;
                    case 236 -> 223;
                    case 237 -> 122;
                    case 238 -> 135;
                    case 239 -> 120;
                    case 240 -> 210;
                    case 241 -> 139;
                    case 242 -> 173;
                    case 243 -> 243;
                    case 244 -> 45;
                    case 245 -> 146;
                    case 246 -> 49;
                    case 247 -> 51;
                    case 248 -> 80;
                    case 249 -> 179;
                    case 250 -> 218;
                    case 251 -> 168;
                    case 252 -> 199;
                    case 253 -> 73;
                    case 254 -> 99;
                    default -> 222;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

