/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connection.throwable.info;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.RuntimeErrorActionProvider;
import com.intellij.database.connection.throwable.info.ThrowableInfo;
import com.intellij.database.datagrid.GridUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ThrowableInfoUtil {
    private ThrowableInfoUtil() {
    }

    @Nls
    @NotNull
    public static String getDefaultMessage(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableInfoUtil.$$$reportNull$$$0(0);
        }
        String string = GridUtilCore.getLongMessage(throwable);
        if (string == null) {
            ThrowableInfoUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Throwable getActualThrowable(@NotNull ThrowableInfo info) {
        if (info == null) {
            ThrowableInfoUtil.$$$reportNull$$$0(2);
        }
        String message = info.getMessage();
        Throwable originalThrowable = info.getOriginalThrowable();
        return originalThrowable != null && ThrowableInfoUtil.getDefaultMessage(originalThrowable).equals(message) ? originalThrowable : new RuntimeException(message, originalThrowable);
    }

    public static List<ErrorInfo.Fix> getAllFixes(@NotNull ErrorInfo error) {
        if (error == null) {
            ThrowableInfoUtil.$$$reportNull$$$0(3);
        }
        ArrayList<ErrorInfo.Fix> fixes = new ArrayList<ErrorInfo.Fix>(error.getFixes());
        for (RuntimeErrorActionProvider provider : RuntimeErrorActionProvider.getProviders()) {
            ErrorInfo.Fix fix = provider.createAction(error);
            if (fix == null) continue;
            fixes.add(fix);
        }
        return fixes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/connection/throwable/info/ThrowableInfoUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/connection/throwable/info/ThrowableInfoUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMessage";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActualThrowable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

