/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class PointSet<T> {
    private static final List<PointSet<?>> ourGroups = new ArrayList();
    public static final PointSet<Object> UNKNOWN = new PointSet<Object>("UNKNOWN", Object.class, ConversionPoint.UNKNOWN);
    public static final PointSet<String> UUID_TEXT = new PointSet<String>("UUID_TEXT", String.class, ConversionPoint.UUID_TEXT);
    public static final PointSet<UUID> UUID = new PointSet<UUID>("UUID", UUID.class, ConversionPoint.UUID);
    public static final PointSet<byte[]> BINARY = new PointSet<byte[]>("BINARY", byte[].class, ConversionPoint.BINARY, ConversionPoint.BINARY_ID, ConversionPoint.VARBINARY, ConversionPoint.BLOB, ConversionPoint.GRAPHIC);
    public static final PointSet<String> TEXT = new PointSet<String>("TEXT", String.class, ConversionPoint.CLOB, ConversionPoint.INTERVAL, ConversionPoint.JSON, ConversionPoint.POINT, ConversionPoint.GEOMETRY, ConversionPoint.GEOGRAPHY, ConversionPoint.TEXT, ConversionPoint.NTEXT, ConversionPoint.TEXT_TIMESTAMP, ConversionPoint.TEXT_DATE, ConversionPoint.BLOB_TEXT, ConversionPoint.TEXT_ID, ConversionPoint.TEXT_GRAPHIC, ConversionPoint.CHAR, ConversionPoint.VARCHAR, ConversionPoint.NCHAR, ConversionPoint.NVARCHAR, ConversionPoint.XML, ConversionPoint.INET, ConversionPoint.TSVECTOR);
    public static final PointSet<Map> MAP = new PointSet<Map>("MAP", Map.class, ConversionPoint.MAP);
    public static final PointSet<String> BINARY_STRING = new PointSet<String>("BINARY_STRING", String.class, ConversionPoint.BINARY_STRING);
    public static final PointSet<String> BIT_STRING = new PointSet<String>("BIT_STRING", String.class, ConversionPoint.BIT_STRING);
    public static final PointSet<Boolean> BOOLEAN = new PointSet<Boolean>("BOOLEAN", Boolean.class, ConversionPoint.BOOLEAN);
    public static final PointSet<Number> BOOLEAN_NUMBER = new PointSet<Number>("NUMBER", Number.class, ConversionPoint.BOOLEAN_NUMBER);
    public static final PointSet<Date> DATE = new PointSet<Date>("DATE", Date.class, ConversionPoint.DATE);
    public static final PointSet<Time> TIME = new PointSet<Time>("TIME", Time.class, ConversionPoint.TIME);
    public static final PointSet<String> NUMBER_RANGE = new PointSet<String>("NUMBER_RANGE", String.class, ConversionPoint.NUMBER_RANGE);
    public static final PointSet<String> DATE_RANGE = new PointSet<String>("DATE_RANGE", String.class, ConversionPoint.DATE_RANGE);
    public static final PointSet<String> TIMESTAMP_RANGE = new PointSet<String>("TIMESTAMP_RANGE", String.class, ConversionPoint.TIMESTAMP_RANGE, ConversionPoint.TIMESTAMP_TZ_RANGE);
    public static final PointSet<Timestamp> TIMESTAMP = new PointSet<Timestamp>("TIMESTAMP", Timestamp.class, ConversionPoint.TIMESTAMP);
    public static final PointSet<TemporalAccessor> TEMPORAL_TIMESTAMP = new PointSet<TemporalAccessor>("TEMPORAL_TIMESTAMP", TemporalAccessor.class, ConversionPoint.TEMPORAL_TIMESTAMP);
    public static final PointSet<TemporalAccessor> TEMPORAL_TIME = new PointSet<TemporalAccessor>("TEMPORAL_TIME", TemporalAccessor.class, ConversionPoint.TEMPORAL_TIME);
    public static final PointSet<Number> NUMBER = new PointSet<Number>("NUMBER", Number.class, ConversionPoint.NUMBER, ConversionPoint.UNSIGNED_NUMBER, ConversionPoint.SERIAL_NUMBER, ConversionPoint.BIG_DECIMAL, ConversionPoint.DOUBLE_PRECISION, ConversionPoint.SINGLE_PRECISION);
    public static final PointSet<Number> MONEY = new PointSet<Number>("MONEY", Number.class, ConversionPoint.MONEY);
    private final String myName;
    private final ConversionPoint<T>[] myTypes;
    private final Class<T> myClass;

    public PointSet(@NotNull String name, @NotNull Class<T> aClass, ConversionPoint<T> ... types) {
        if (name == null) {
            PointSet.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            PointSet.$$$reportNull$$$0(1);
        }
        if (types == null) {
            PointSet.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myTypes = types;
        this.myClass = aClass;
        ourGroups.add(this);
    }

    @NotNull
    public Class<T> getObjectClass() {
        Class<T> clazz = this.myClass;
        if (clazz == null) {
            PointSet.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    public boolean contains(@NotNull ConversionPoint type) {
        if (type == null) {
            PointSet.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists((Object[])this.myTypes, desc -> desc.getLogicalType() == type.getLogicalType() && StringUtil.equals((CharSequence)desc.toString(), (CharSequence)type.toString()) && desc.getObjectClass().isAssignableFrom(type.getObjectClass()));
    }

    @NotNull
    public ConversionPoint<T>[] getTypes() {
        if (this.myTypes == null) {
            PointSet.$$$reportNull$$$0(5);
        }
        return this.myTypes;
    }

    @NotNull
    public static PointSet of(@NotNull ConversionPoint type) {
        if (type == null) {
            PointSet.$$$reportNull$$$0(6);
        }
        for (PointSet<?> group : ourGroups) {
            if (!group.contains(type)) continue;
            PointSet<?> pointSet = group;
            if (pointSet == null) {
                PointSet.$$$reportNull$$$0(7);
            }
            return pointSet;
        }
        PointSet<Object> pointSet = UNKNOWN;
        if (pointSet == null) {
            PointSet.$$$reportNull$$$0(8);
        }
        return pointSet;
    }

    public boolean equals(Object obj) {
        return obj instanceof PointSet && StringUtil.equals((CharSequence)this.myName, (CharSequence)((PointSet)obj).myName) && Comparing.equal(this.myClass, ((PointSet)obj).myClass) && Arrays.equals(this.myTypes, ((PointSet)obj).myTypes);
    }

    public int hashCode() {
        return this.myName.hashCode() + this.myClass.hashCode() + Arrays.hashCode(this.myTypes);
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/PointSet";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/PointSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

