/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfoUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorHandler {
    private static final Logger LOG = Logger.getInstance(ErrorHandler.class);
    private final Set<String> myMessages = new HashSet<String>();
    private final List<ErrorInfo.Fix> myFixes = new ArrayList<ErrorInfo.Fix>();
    @NlsSafe
    private final StringBuilder myErrors = new StringBuilder();
    private boolean myTruncated;
    private int mySkippedErrors;

    public boolean hasErrors() {
        return this.myErrors.length() > 0;
    }

    @NotNull
    public List<ErrorInfo.Fix> getFixes() {
        List<ErrorInfo.Fix> list = this.myFixes;
        if (list == null) {
            ErrorHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void add(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            ErrorHandler.$$$reportNull$$$0(1);
        }
        this.add(errorInfo, false);
    }

    public void add(@NotNull ErrorInfo errorInfo, boolean needToWarn) {
        if (errorInfo == null) {
            ErrorHandler.$$$reportNull$$$0(2);
        }
        this.addError(errorInfo.getMessage(), null);
        this.myFixes.addAll(ThrowableInfoUtil.getAllFixes(errorInfo));
        Throwable throwable = errorInfo.getOriginalThrowable();
        if (needToWarn && throwable != null) {
            LOG.warn(throwable);
        }
    }

    public boolean addError(@Nls @Nullable String message, @Nullable Throwable ex) {
        String exMessage;
        if (ex instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)ex;
        }
        if (this.myTruncated) {
            ++this.mySkippedErrors;
            return true;
        }
        if (ex != null) {
            String m = GridUtilCore.getLongMessage(ex);
            m = StringUtil.isNotEmpty((String)m) ? m : ex.getClass().getName();
            exMessage = m.equals(message) ? null : m;
        } else {
            exMessage = null;
        }
        if (message != null && !this.myMessages.add(message) || exMessage != null && !this.myMessages.add(exMessage)) {
            ++this.mySkippedErrors;
            return true;
        }
        if (ex != null) {
            LOG.warn(ex);
        }
        if (message != null) {
            this.appendMessage(message);
        }
        if (exMessage != null) {
            Throwable cause = ex.getCause();
            if (cause instanceof UnknownHostException) {
                this.appendMessage(DataGridBundle.message("host.0.is.unknown", cause.getMessage()));
            }
            this.appendMessage(StringUtil.replace((String)exMessage, (String)"\n\n", (String)".\n"));
        }
        if (this.myErrors.length() > 10240) {
            this.myTruncated = true;
        }
        return true;
    }

    private void appendMessage(@Nls @NotNull String message) {
        if (message == null) {
            ErrorHandler.$$$reportNull$$$0(3);
        }
        String trimmed = message.trim();
        this.myErrors.append(trimmed);
        this.myErrors.append(trimmed.endsWith(".") ? "\n" : ".\n");
    }

    @Nls
    public String getSummary() {
        if (this.mySkippedErrors > 0) {
            this.myErrors.append(DataGridBundle.message("and.0.1.choice.0.more.1.duplicate.reports", this.mySkippedErrors, this.myTruncated ? 0 : 1));
            this.mySkippedErrors = 0;
        }
        return this.myErrors.toString();
    }

    @Nls
    public String getSummary(@Nls String alt) {
        return this.hasErrors() ? this.getSummary() : alt;
    }

    public void setCaption(@Nls String message) {
        this.myErrors.insert(0, message + "\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ErrorHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

