#ifndef BUFFER_H
# define BUFFER_H

#include <sys/time.h>
#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif

struct SOK_BUFFER {
	char *start;
	size_t offset;
	size_t bufsize;
	time_t timeout; /* seconds. (0 for no timeout) */
};

typedef struct SOK_s {
	int sd;
	struct SOK_BUFFER in;
	struct SOK_BUFFER out;
} SOK;

extern SOK *sdopen(int sd);
extern bool sclose(SOK *stream);
extern int ssend(SOK *stream, const char *msg);
extern int ssendn(SOK *stream, const char *msg, size_t msglen);
extern int srecv(SOK *stream, char *buf, size_t bufsize);
int sflush(SOK *stream);
bool discard(SOK *stream, char *buf, ssize_t bufsize);
extern int SOK_select(int n, fd_set *readfds, fd_set *writefds,
		fd_set *exceptfds, struct timeval *timeout, SOK **streams);

#endif
