#include "bool.h"
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include "connect.h"
#include "util.h"
#include "exec.h"
#include "disconnect.h"
#include "state.h"
#include "main.h"

/* Only set state->con = CONS_DISCONNECTING if disconnect() returns FALSE. */
bool disconnect(pid_t commandon_pid, pid_t *commandoff_pid)
{
	if (set.commandoff) {
		*commandoff_pid = run_fd3open(set.commandoff);
		/* If this command fails, e.g. we run "killall pppd", and
		 * the commandon script is running but hasn't yet started
		 * pppd, (which it does just after we run killall),
		 * all is sweet. When we receive SIGUSR1, we will disconnect
		 * again. (If we get SIGUSR2 we just won't reconnect).
		 * [On the other hand, it does mean that the ip-up scripts will
		 * be started, so we will have to wait for them to timeout
		 * after we immediately disconnect.]
		 */
		if (-1==*commandoff_pid) {
			notice("disconnecting failed\n");
			return TRUE;
		}
	}
	/* if (!set.commandoff), dial_hack will kill the script. */
	if (-1==kill(commandon_pid, SIGTERM)) {
		notice("disconnecting failed\n");
		return TRUE;
	}
	notice("disconnecting\n");
	return FALSE;
}

pid_t disconnect_timer(void)
{
	pid_t pid = xfork();
	if (pid==-1) {
		notice_err("fork failed");
		return -1;
	} else if (pid==0) {
		if (cleanup_signals() || cleanup_fds()) {
			notice("cleanup failed for disconnect timer\n");
			_exit(EXIT_FAILURE);
		}
		unblock_all_signals(NULL);
		sleep(set.disconnect_wait);
		_exit(0);
	}
	return pid;
}
