#define HASARG TRUE /* !HASARG==FALSE */
enum {
	AUTH_NONE,
	AUTH_HALF,
	AUTH_NORMAL,
	AUTH_ADMIN
};

struct cmdlist {
	char *command;
	char *help; /* or NULL for same as command */
	int tag;
	bool hasarg;
};

/************************************************************************
 * 				What					* 	 ***********************************************************************/

enum {
	COM_ALIVE,
	COM_HELP,
	COM_QUIT,
	COM_TIMEOUT,
	COM_USER,
	COM_PASS,
	COM_RESTART,
	COM_SHUTDOWN,
	COM_LIST,
	COM_SHOWLOCKS,
	COM_STATUS,
	COM_UPTIME,
	COM_KILL,
	COM_LOCK,
	COM_UNLOCK,
	COM_ZAP,
	COM_RECONNECT,
	COM_CLOSE,
	COM_CONNECT,
	COM_DISCONNECT,

	COM_INVALID,
	COM_DONT_WANT_ARG,
	COM_NEED_ARG,
	COM_INVALID_ARG,
	COM_INVALID_NOARG,
	COM_TOOLONG,
	FATAL_TIMEOUT,
	FATAL_TERM,
	FATAL_SIGNAL
};

struct cmdlist std_cmds[] = {
	{ "ALIVE", 	NULL, 			COM_ALIVE,	!HASARG },
	{ "HELP", 	NULL, 			COM_HELP,	!HASARG },
	{ "QUIT", 	NULL, 			COM_QUIT,	!HASARG },
	{ "TIMEOUT",	"TIMEOUT seconds", 	COM_TIMEOUT,	 HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist auth_cmds[] = {
	{ "USER",	"USER username",	COM_USER,	 HASARG },
	{ "PASS",	"PASS password",	COM_PASS,	 HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist server_cmds[] = {
	{ "RESTART",	NULL,			COM_RESTART,	!HASARG },
	{ "SHUTDOWN",	NULL,			COM_SHUTDOWN,	!HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist user_info_cmds[] = {
	{ "LIST",	NULL,			COM_LIST,	!HASARG },
	{ "SHOWLOCKS",	NULL,			COM_SHOWLOCKS,	!HASARG },
	{ "STATUS",	NULL,			COM_STATUS,	!HASARG },
	{ "UPTIME",	NULL,			COM_UPTIME,	!HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist user_action_cmds[] = {
	{ "KILL",	"KILL user or pid",	COM_KILL,	 HASARG },
	{ "LOCK",	"LOCK user or pid",	COM_LOCK,	 HASARG },
	{ "UNLOCK",	"UNLOCK user or pid",	COM_UNLOCK,	 HASARG },
	{ "ZAP",	"ZAP user or pid",	COM_ZAP,	 HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist restricted_control_cmds[] = {
	{ "RECONNECT",	NULL,			COM_RECONNECT,	!HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist authed_user_cmds[] = {
	{ "CLOSE",	NULL,			COM_CLOSE,	!HASARG },
	{ NULL, NULL, -1, !HASARG }
};

struct cmdlist control_cmds[] = {
	{ "CONNECT",	NULL,			COM_CONNECT,	!HASARG },
	{ "DISCONNECT",	NULL,			COM_DISCONNECT,	!HASARG },
	{ NULL, NULL, -1, !HASARG }
};

/************************************************************************
 * 				Who					* 	 ***********************************************************************/

/* user groups */
struct cmdlist *normal_user[] = {
	std_cmds,
	authed_user_cmds,
	control_cmds,
	NULL
};

struct cmdlist *admin_user[] = {
	std_cmds,
	authed_user_cmds,
	user_info_cmds,
	user_action_cmds,
	server_cmds,
	restricted_control_cmds,
	NULL
};

struct cmdlist *unauthed_user[] = {
	std_cmds,
	auth_cmds,
	NULL
};
