/* inserts a string given by the argument before each line read from stdin.
 * e.g.
 * 	tail -f /var/log/ppp.log | dwunprepend %%con:\# > /usr/lib/dwun-msg
 *
 * Can also ignore lines which don't contain a string.
 * e.g.
 * 	tail -f /var/log/messages | dwunprepend 'pppd[' '%%con:#'
 *
 * A command involving grep will *not* work. Grep will do nothing, waiting for
 * the EOF which will not come.
 *
 * Copyright 2000 Tim Sutherland.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFLEN 1024 /* syslog limit */

int main(int argc, char *argv[])
{
	char buf[BUFLEN];
	char *match;
	char *pre;
	char *progname;
	char c;

	progname = argv[0];
	switch(argc) {
	case 2: /* progname pre */
		match = NULL;
		pre = argv[1];
		break;
	case 3: /* progname match pre */
		match = argv[1];
		if (!*match)
			match = NULL;
		pre = argv[2];
		break;
	default:
		fprintf(stderr, "usage: %s [match] string\n", progname);
		return EXIT_FAILURE;
	}
	while (fgets(buf, BUFLEN, stdin)) {
		if (!strchr(buf, '\n')) {
			fprintf(stderr, "%s: fgets input too long\n", progname);
			while((c = getchar())!=EOF && c!='\n');
			return EXIT_FAILURE;
		}
		if (!match || strstr(buf, match)) {
			printf("%s%s", pre, buf);
			fflush(stdout);
		}
	}
	if (feof(stdin))
		return EXIT_SUCCESS;
	fprintf(stderr, "%s: fgets failed\n", progname);
	return EXIT_FAILURE;
}
