#ifndef SOCKET_H
# define SOCKET_H

#include "bool.h"
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#else
# include <time.h>
#endif

#define SOK_SEND_TIMEOUT_SECS 10

enum {
	SOK_SUCCESS,
	SOK_FAILED,
	SOK_TIMEOUT,
	SOK_TOOLONG /* not for sok_send */
};

extern char *makepeername_alloc(int sok);
extern int sok_send(int sok, struct timeval *tv, const void *msg,
		size_t msglen);
extern int sok_recv(int sok, struct timeval *tv, void *msg, size_t bufsize);
extern int sok_getexternal(char *msg, int maxline, int sok, struct timeval *tv);
#endif
