/*
  File: config.h

  Copyright (C) 2007
  Marcin 'Morgoth' Kurek <morgoth6@box43.pl>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef BOOTCREATOR_CONFIG_H
#define BOOTCREATOR_CONFIG_H

/*
 * Buffers
 */

#define ARGS_BUF_SIZE   (1024 * 2)
#define FILE_BUF_SIZE   (1024 * 8)

/*
 * Permissions
 */

#define DEF_PERMS (S_IRUSR|S_IWUSR|S_IRGRP)

/*
 * Parser
 */

#define PARSE_SECTION   '['
#define PARSE_COMMENT   '#'
#define GETVAR_DELIM "="

/*
 * Defaults
 */

#define DEF_VERSION  (1)
#define DEF_TIMEOUT  (3)
#define DEF_ABORTOK  (false)
#define DEF_DEFAULT  (1)
#define DEF_REM_V2   (false)

#define DEF_TITLE "Boot menu"

/*
 * Limits
 */

#define SECTION_LIMIT   (10)

#endif /* BOOTCREATOR_CONFIG_H */
