/** @file cdstatus.h Header file with declarations for cdstatus, primarily for things defined in cdstatus.c.
 *  Defines 3 structures used to contain various program data and declares all the functions in cdstatus.c.
 */

#ifndef _CDSTATUS_H
#define _CDSTATUS_H

#include "gimme_config_h.h"

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_LINUX_CDROM_H
#include <linux/cdrom.h>
#endif

#ifdef STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

/* Give the SUSv3/POSIX version of this value a shot, otherwise use the POSIX
 * minimum acceptable value for max portability */
#ifdef PATH_MAX
#define CDSTATUS_PATH_MAX PATH_MAX
#else
#ifdef _POSIX_PATH_MAX
#define CDSTATUS_PATH_MAX _POSIX_PATH_MAX
#else
#define CDSTATUS_PATH_MAX 256
#endif
#endif

#ifdef HOST_NAME_MAX
#define CDSTATUS_HOST_NAME_MAX HOST_NAME_MAX
#else
#ifdef _POSIX_HOST_NAME_MAX
#define CDSTATUS_HOST_NAME_MAX _POSIX_HOST_NAME_MAX
#else
#define CDSTATUS_HOST_NAME_MAX 255
#endif
#endif

#ifdef NAME_MAX
#define CDSTATUS_NAME_MAX NAME_MAX
#else
#ifdef _POSIX_NAME_MAX
#define CDSTATUS_NAME_MAX _POSIX_NAME_MAX
#else
#ifdef _XOPEN_NAME_MAX
#define CDSTATUS_NAME_MAX _XOPEN_NAME_MAX
#else
/* Wow this is short... posix minimum though for portability */
#define CDSTATUS_NAME_MAX 14
#endif
#endif
#endif

#define CDSTATUS_MIN(A,B) (((A)<(B))?(A):(B))

#include "args.h"

#include "print_help.h"

#endif
