
#include <stdio.h>
#include <stdarg.h>

#include "cdstatus_output.h"

void conditional_puts(enum OUTPUT_PRIORITY pri, const char * message)
{
	if(pri >= current_priority)
	{
		(void)puts(message);
	}
}

void conditional_perror(enum OUTPUT_PRIORITY pri, const char * message)
{
	if(pri >= current_priority)
	{
		perror(message);
	}
}

int conditional_printf(enum OUTPUT_PRIORITY pri, const char * format, ...)
{
	va_list otherargs;

	if(pri >= current_priority)
	{
		va_start(otherargs, format);
		return vprintf(format, otherargs);
	}
	return 0;
}
