/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreSerializer;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.LevelDBIterator;
import org.apache.spark.util.kvstore.LevelDBTypeInfo;
import org.apache.spark.util.kvstore.UnsupportedStoreVersionException;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.base.Throwables;

@Private
public class LevelDB
implements KVStore {
    @VisibleForTesting
    static final long STORE_VERSION = 1L;
    @VisibleForTesting
    static final byte[] STORE_VERSION_KEY = "__version__".getBytes(StandardCharsets.UTF_8);
    private static final byte[] METADATA_KEY = "__meta__".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TYPE_ALIASES_KEY = "__types__".getBytes(StandardCharsets.UTF_8);
    final AtomicReference<DB> _db;
    final KVStoreSerializer serializer;
    private final ConcurrentMap<String, byte[]> typeAliases;
    private final ConcurrentMap<Class<?>, LevelDBTypeInfo> types;
    private final ConcurrentLinkedQueue<SoftReference<LevelDBIterator<?>>> iteratorTracker;

    public LevelDB(File path) throws Exception {
        this(path, new KVStoreSerializer());
    }

    public LevelDB(File path, KVStoreSerializer serializer) throws Exception {
        Map<Object, Object> aliases;
        this.serializer = serializer;
        this.types = new ConcurrentHashMap();
        Options options = new Options();
        options.createIfMissing(true);
        this._db = new AtomicReference<DB>(JniDBFactory.factory.open(path, options));
        byte[] versionData = this.db().get(STORE_VERSION_KEY);
        if (versionData != null) {
            long version = serializer.deserializeLong(versionData);
            if (version != 1L) {
                this.close();
                throw new UnsupportedStoreVersionException();
            }
        } else {
            this.db().put(STORE_VERSION_KEY, serializer.serialize(1L));
        }
        try {
            aliases = this.get((byte[])LevelDB.TYPE_ALIASES_KEY, TypeAliases.class).aliases;
        }
        catch (NoSuchElementException e) {
            aliases = new HashMap();
        }
        this.typeAliases = new ConcurrentHashMap<String, byte[]>(aliases);
        this.iteratorTracker = new ConcurrentLinkedQueue();
    }

    @Override
    public <T> T getMetadata(Class<T> klass) throws Exception {
        try {
            return this.get(METADATA_KEY, klass);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    @Override
    public void setMetadata(Object value) throws Exception {
        if (value != null) {
            this.put(METADATA_KEY, value);
        } else {
            this.db().delete(METADATA_KEY);
        }
    }

    <T> T get(byte[] key, Class<T> klass) throws Exception {
        byte[] data = this.db().get(key);
        if (data == null) {
            throw new NoSuchElementException(new String(key, StandardCharsets.UTF_8));
        }
        return this.serializer.deserialize(data, klass);
    }

    private void put(byte[] key, Object value) throws Exception {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Null values are not allowed.");
        this.db().put(key, this.serializer.serialize(value));
    }

    @Override
    public <T> T read(Class<T> klass, Object naturalKey) throws Exception {
        Preconditions.checkArgument((naturalKey != null ? 1 : 0) != 0, (Object)"Null keys are not allowed.");
        byte[] key = this.getTypeInfo(klass).naturalIndex().start(null, naturalKey);
        return this.get(key, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object value) throws Exception {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Null values are not allowed.");
        LevelDBTypeInfo ti = this.getTypeInfo(value.getClass());
        try (WriteBatch batch = this.db().createWriteBatch();){
            byte[] data = this.serializer.serialize(value);
            LevelDBTypeInfo levelDBTypeInfo = ti;
            synchronized (levelDBTypeInfo) {
                this.updateBatch(batch, value, data, value.getClass(), ti.naturalIndex(), ti.indices());
                this.db().write(batch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAll(List<?> values) throws Exception {
        Preconditions.checkArgument((values != null && !values.isEmpty() ? 1 : 0) != 0, (Object)"Non-empty values required.");
        for (Map.Entry<Class, List<Object>> entry : values.stream().collect(Collectors.groupingBy(Object::getClass)).entrySet()) {
            LevelDBTypeInfo ti;
            Iterator<Object> valueIter = entry.getValue().iterator();
            ArrayList<byte[]> list = new ArrayList<byte[]>(entry.getValue().size());
            for (Object value : values) {
                list.add(this.serializer.serialize(value));
            }
            Iterator serializedValueIter = list.iterator();
            Class klass = entry.getKey();
            LevelDBTypeInfo levelDBTypeInfo = ti = this.getTypeInfo(klass);
            synchronized (levelDBTypeInfo) {
                LevelDBTypeInfo.Index naturalIndex = ti.naturalIndex();
                Collection<LevelDBTypeInfo.Index> indices = ti.indices();
                try (WriteBatch batch = this.db().createWriteBatch();){
                    while (valueIter.hasNext()) {
                        this.updateBatch(batch, valueIter.next(), (byte[])serializedValueIter.next(), klass, naturalIndex, indices);
                    }
                    this.db().write(batch);
                }
            }
        }
    }

    private void updateBatch(WriteBatch batch, Object value, byte[] data, Class<?> klass, LevelDBTypeInfo.Index naturalIndex, Collection<LevelDBTypeInfo.Index> indices) throws Exception {
        Object existing;
        try {
            existing = this.get(naturalIndex.entityKey(null, value), klass);
        }
        catch (NoSuchElementException e) {
            existing = null;
        }
        PrefixCache cache = new PrefixCache(value);
        byte[] naturalKey = naturalIndex.toKey(naturalIndex.getValue(value));
        for (LevelDBTypeInfo.Index idx : indices) {
            byte[] prefix = cache.getPrefix(idx);
            idx.add(batch, value, existing, data, naturalKey, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Class<?> type, Object naturalKey) throws Exception {
        Preconditions.checkArgument((naturalKey != null ? 1 : 0) != 0, (Object)"Null keys are not allowed.");
        try (WriteBatch batch = this.db().createWriteBatch();){
            LevelDBTypeInfo ti = this.getTypeInfo(type);
            byte[] key = ti.naturalIndex().start(null, naturalKey);
            LevelDBTypeInfo levelDBTypeInfo = ti;
            synchronized (levelDBTypeInfo) {
                byte[] data = this.db().get(key);
                if (data != null) {
                    Object existing = this.serializer.deserialize(data, type);
                    PrefixCache cache = new PrefixCache(existing);
                    byte[] keyBytes = ti.naturalIndex().toKey(ti.naturalIndex().getValue(existing));
                    for (LevelDBTypeInfo.Index idx : ti.indices()) {
                        idx.remove(batch, existing, keyBytes, cache.getPrefix(idx));
                    }
                    this.db().write(batch);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public <T> KVStoreView<T> view(final Class<T> type) throws Exception {
        return new KVStoreView<T>(){

            @Override
            public Iterator<T> iterator() {
                try {
                    LevelDBIterator it = new LevelDBIterator(type, LevelDB.this, this);
                    LevelDB.this.iteratorTracker.add(new SoftReference(it));
                    return it;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    @Override
    public <T> boolean removeAllByIndexValues(Class<T> klass, String index, Collection<?> indexValues) throws Exception {
        LevelDBTypeInfo.Index naturalIndex = this.getTypeInfo(klass).naturalIndex();
        boolean removed = false;
        KVStoreView<T> view = this.view(klass).index(index);
        for (Object indexValue : indexValues) {
            for (Object value : view.first(indexValue).last(indexValue)) {
                Object itemKey = naturalIndex.getValue(value);
                this.delete(klass, itemKey);
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public long count(Class<?> type) throws Exception {
        LevelDBTypeInfo.Index idx = this.getTypeInfo(type).naturalIndex();
        return idx.getCount(idx.end(null));
    }

    @Override
    public long count(Class<?> type, String index, Object indexedValue) throws Exception {
        LevelDBTypeInfo.Index idx = this.getTypeInfo(type).index(index);
        return idx.getCount(idx.end(null, indexedValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AtomicReference<DB> atomicReference = this._db;
        synchronized (atomicReference) {
            DB _db = this._db.getAndSet(null);
            if (_db == null) {
                return;
            }
            try {
                if (this.iteratorTracker != null) {
                    for (SoftReference<LevelDBIterator<?>> ref : this.iteratorTracker) {
                        LevelDBIterator<?> it = ref.get();
                        if (it == null) continue;
                        it.close();
                    }
                }
                _db.close();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeIterator(LevelDBIterator<?> it) throws IOException {
        this.notifyIteratorClosed(it);
        AtomicReference<DB> atomicReference = this._db;
        synchronized (atomicReference) {
            DB _db = this._db.get();
            if (_db != null) {
                it.close();
            }
        }
    }

    void notifyIteratorClosed(LevelDBIterator<?> it) {
        this.iteratorTracker.removeIf(ref -> it.equals(ref.get()));
    }

    LevelDBTypeInfo getTypeInfo(Class<?> type) throws Exception {
        LevelDBTypeInfo tmp;
        LevelDBTypeInfo ti = (LevelDBTypeInfo)this.types.get(type);
        if (ti == null && (ti = this.types.putIfAbsent(type, tmp = new LevelDBTypeInfo(this, type, this.getTypeAlias(type)))) == null) {
            ti = tmp;
        }
        return ti;
    }

    DB db() {
        DB _db = this._db.get();
        if (_db == null) {
            throw new IllegalStateException("DB is closed.");
        }
        return _db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTypeAlias(Class<?> klass) throws Exception {
        byte[] alias = (byte[])this.typeAliases.get(klass.getName());
        if (alias == null) {
            ConcurrentMap<String, byte[]> concurrentMap = this.typeAliases;
            synchronized (concurrentMap) {
                byte[] tmp = String.valueOf(this.typeAliases.size()).getBytes(StandardCharsets.UTF_8);
                alias = this.typeAliases.putIfAbsent(klass.getName(), tmp);
                if (alias == null) {
                    alias = tmp;
                    this.put(TYPE_ALIASES_KEY, new TypeAliases(this.typeAliases));
                }
            }
        }
        return alias;
    }

    private static class PrefixCache {
        private final Object entity;
        private final Map<LevelDBTypeInfo.Index, byte[]> prefixes;

        PrefixCache(Object entity) {
            this.entity = entity;
            this.prefixes = new HashMap<LevelDBTypeInfo.Index, byte[]>();
        }

        byte[] getPrefix(LevelDBTypeInfo.Index idx) throws Exception {
            byte[] prefix = null;
            if (idx.isChild() && (prefix = this.prefixes.get(idx.parent())) == null) {
                prefix = idx.parent().childPrefix(idx.parent().getValue(this.entity));
                this.prefixes.put(idx.parent(), prefix);
            }
            return prefix;
        }
    }

    public static class TypeAliases {
        public Map<String, byte[]> aliases;

        TypeAliases(Map<String, byte[]> aliases) {
            this.aliases = aliases;
        }

        TypeAliases() {
            this(null);
        }
    }
}

