/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitwiseCount$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the number of bits that are set in the argument expr as an unsigned 64-bit integer, or NULL if the argument is NULL.", examples="\n    Examples:\n      > SELECT _FUNC_(0);\n       0\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\r\u001b\u0001\u001eB\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\")Q\t\u0001C\u0001\r\")\u0011\n\u0001C!\u0015\")A\f\u0001C!;\")\u0011\r\u0001C!E\")1\u000e\u0001C!Y\")Q\u000e\u0001C!]\")A\u0010\u0001C){\"I\u0011q\u0001\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003\u001b\u0001\u0011\u0013!C\u0001\u0003\u001fA\u0011\"!\n\u0001\u0003\u0003%\t%a\n\t\u0013\u0005]\u0002!!A\u0005\u0002\u0005e\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\tI\u0005AA\u0001\n\u0003\nY\u0005C\u0005\u0002Z\u0001\t\t\u0011\"\u0001\u0002\\!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0013qM\u0004\n\u0003\u000bS\u0012\u0011!E\u0001\u0003\u000f3\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011\u0011\u0012\u0005\u0007\u000bN!\t!a&\t\u0011\u0005\u001c\u0012\u0011!C#\u00033C\u0011\"a'\u0014\u0003\u0003%\t)!(\t\u0013\u0005\u00056#!A\u0005\u0002\u0006\r\u0006\"CAX'\u0005\u0005I\u0011BAY\u00051\u0011\u0015\u000e^<jg\u0016\u001cu.\u001e8u\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011C\u0002\u0001)Y=2D\b\u0005\u0002*U5\t!$\u0003\u0002,5\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002*[%\u0011aF\u0007\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u00194\u001d\tI\u0013'\u0003\u000235\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001b6\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!A\r\u000e\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011q'P\u0005\u0003}a\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012!\u0011\t\u0003S\tK!a\u0011\u000e\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dC\u0005CA\u0015\u0001\u0011\u0015y4\u00011\u0001B\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002\u0017B\u0019Aj\u0015,\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)'\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u00023q%\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001\u001a9!\t9&,D\u0001Y\u0015\tIf$A\u0003usB,7/\u0003\u0002\\1\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\ta\f\u0005\u0002X?&\u0011\u0001\r\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006AAo\\*ue&tw\rF\u0001d!\t!\u0007N\u0004\u0002fMB\u0011a\nO\u0005\u0003Ob\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q\rO\u0001\u000baJ,G\u000f^=OC6,W#A2\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA8vuB\u0011\u0001o]\u0007\u0002c*\u0011!OG\u0001\bG>$WmZ3o\u0013\t!\u0018O\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151\b\u00021\u0001x\u0003\r\u0019G\u000f\u001f\t\u0003abL!!_9\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u0010\u0003a\u0001_\u0006\u0011QM^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004}\u0006\r\u0001CA\u001c\u0000\u0013\r\t\t\u0001\u000f\u0002\u0004\u0003:L\bBBA\u0003\u0013\u0001\u0007a0A\u0003j]B,H/\u0001\u0003d_BLHcA$\u0002\f!9qH\u0003I\u0001\u0002\u0004\t\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#Q3!QA\nW\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0010q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001\u00027b]\u001eT!!a\r\u0002\t)\fg/Y\u0005\u0004S\u00065\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001e!\r9\u0014QH\u0005\u0004\u0003\u007fA$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001@\u0002F!I\u0011q\t\b\u0002\u0002\u0003\u0007\u00111H\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0003#BA(\u0003+rXBAA)\u0015\r\t\u0019\u0006O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA,\u0003#\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QLA2!\r9\u0014qL\u0005\u0004\u0003CB$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u000f\u0002\u0012\u0011!a\u0001}\u00061Q-];bYN$B!!\u0018\u0002j!A\u0011qI\t\u0002\u0002\u0003\u0007a\u0010K\b\u0001\u0003[\n\u0019(!\u001e\u0002z\u0005m\u0014qPAA!\rI\u0013qN\u0005\u0004\u0003cR\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003o\n\u0011qC0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!E&$8\u000f\t;iCR\u0004\u0013M]3!g\u0016$\b%\u001b8!i\",\u0007%\u0019:hk6,g\u000e\u001e\u0011fqB\u0014\b%Y:!C:\u0004SO\\:jO:,G\r\t\u001c5[\tLG\u000fI5oi\u0016<WM\u001d\u0017!_J\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA\u0005\u0014x-^7f]R\u0004\u0013n\u001d\u0011O+2ce&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti(\u0001\u001b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\nQa]5oG\u0016\f#!a!\u0002\u000bMr\u0003G\f\u0019\u0002\u0019\tKGo^5tK\u000e{WO\u001c;\u0011\u0005%\u001a2\u0003B\n\u0002\fr\u0002b!!$\u0002\u0014\u0006;UBAAH\u0015\r\t\t\nO\u0001\beVtG/[7f\u0013\u0011\t)*a$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002\bR\u0011\u0011\u0011F\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u000f\u0006}\u0005\"B \u0017\u0001\u0004\t\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\u000bY\u000b\u0005\u00038\u0003O\u000b\u0015bAAUq\t1q\n\u001d;j_:D\u0001\"!,\u0018\u0003\u0003\u0005\raR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a-\u0011\t\u0005-\u0012QW\u0005\u0005\u0003o\u000biC\u0001\u0004PE*,7\r\u001e")
public class BitwiseCount
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitwiseCount bitwiseCount) {
        return BitwiseCount$.MODULE$.unapply(bitwiseCount);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitwiseCount, A> function1) {
        return BitwiseCount$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitwiseCount> compose(Function1<A, Expression> function1) {
        return BitwiseCount$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, BooleanType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String toString() {
        return new StringBuilder(11).append("bit_count(").append(this.child()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "bit_count";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        ExprCode exprCode = BooleanType$.MODULE$.equals(dataType) ? this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(14).append("if (").append((String)c).append(") 1 else 0").toString()) : this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(25).append("java.lang.Long.bitCount(").append((String)c).append(")").toString());
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.unboxToBoolean((Object)input) ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToByte((Object)input)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToShort((Object)input)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToInt((Object)input)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToLong((Object)input)));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    public BitwiseCount copy(Expression child) {
        return new BitwiseCount(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitwiseCount";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseCount bitwiseCount = (BitwiseCount)x$1;
        Expression expression = this.child();
        Expression expression2 = bitwiseCount.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitwiseCount.canEqual(this)) return false;
        return true;
    }

    public BitwiseCount(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

