/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\u0010 \u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\tE\t\u0015!\u0003C\u0011!I\u0005A!f\u0001\n\u0003Q\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\u000bU\u0003A\u0011\t&\t\u000bY\u0003A\u0011I,\t\u000b\u0005\u0004A\u0011\u000b2\t\u000bA\u0004A\u0011I9\t\u000b\u0011\u0002A\u0011I?\t\u000fy\u0004\u0011\u0011!C\u0001\u007f\"I\u0011q\u0001\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003?\u0001\u0011\u0013!C\u0001\u0003CA\u0011\"!\n\u0001#\u0003%\t!a\n\t\u0013\u0005-\u0002!!A\u0005B\u00055\u0002\"CA\u001f\u0001\u0005\u0005I\u0011AA \u0011%\t9\u0005AA\u0001\n\u0003\tI\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0011\u0002R!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003O:\u0011\"a\u001b \u0003\u0003E\t!!\u001c\u0007\u0011yy\u0012\u0011!E\u0001\u0003_Baa\u0014\r\u0005\u0002\u0005u\u0004\u0002\u00039\u0019\u0003\u0003%)%a \t\u0013\u0005\u0005\u0005$!A\u0005\u0002\u0006\r\u0005\"CAF1\u0005\u0005I\u0011QAG\u0011%\ty\nGA\u0001\n\u0013\t\tK\u0001\nDQ\u0016\u001c7n\u0014<fe\u001adwn^%o'Vl'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001i\u0013g\u000e\t\u0003]=j\u0011aH\u0005\u0003a}\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\b!J|G-^2u!\t\u0011\u0004(\u0003\u0002:g\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\tA\b\u0005\u0002/{%\u0011ah\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0005eCR\fG+\u001f9f+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#$\u0003\u0015!\u0018\u0010]3t\u0013\t9EIA\u0006EK\u000eLW.\u00197UsB,\u0017!\u00033bi\u0006$\u0016\u0010]3!\u00039qW\u000f\u001c7P]>3XM\u001d4m_^,\u0012a\u0013\t\u0003e1K!!T\u001a\u0003\u000f\t{w\u000e\\3b]\u0006ya.\u001e7m\u001f:|e/\u001a:gY><\b%\u0001\u0004=S:LGO\u0010\u000b\u0005#J\u001bF\u000b\u0005\u0002/\u0001!)!h\u0002a\u0001y!)\u0001i\u0002a\u0001\u0005\")\u0011j\u0002a\u0001\u0017\u0006Aa.\u001e7mC\ndW-\u0001\u0003fm\u0006dGC\u0001-\\!\t\u0011\u0014,\u0003\u0002[g\t\u0019\u0011I\\=\t\u000fqK\u0001\u0013!a\u0001;\u0006)\u0011N\u001c9viB\u0011alX\u0007\u0002C%\u0011\u0001-\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u00191-\u001b8\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019|\u0012aB2pI\u0016<WM\\\u0005\u0003Q\u0016\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006U*\u0001\ra[\u0001\u0004GRD\bC\u00013m\u0013\tiWM\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b=T\u0001\u0019A2\u0002\u0005\u00154\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003I\u0004\"a\u001d>\u000f\u0005QD\bCA;4\u001b\u00051(BA<,\u0003\u0019a$o\\8u}%\u0011\u0011pM\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002zgU\t!/\u0001\u0003d_BLHcB)\u0002\u0002\u0005\r\u0011Q\u0001\u0005\bu5\u0001\n\u00111\u0001=\u0011\u001d\u0001U\u0002%AA\u0002\tCq!S\u0007\u0011\u0002\u0003\u00071*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-!f\u0001\u001f\u0002\u000e-\u0012\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001aM\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti\"a\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r\"f\u0001\"\u0002\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0015U\rY\u0015QB\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005Y\u0006twM\u0003\u0002\u0002:\u0005!!.\u0019<b\u0013\rY\u00181G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0003\u00022AMA\"\u0013\r\t)e\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u00041\u0006-\u0003\"CA''\u0005\u0005\t\u0019AA!\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000b\t\u0006\u0003+\nY\u0006W\u0007\u0003\u0003/R1!!\u00174\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\n9F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA&\u0002d!A\u0011QJ\u000b\u0002\u0002\u0003\u0007\u0001,\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0017\u0006%\u0004\u0002CA'-\u0005\u0005\t\u0019\u0001-\u0002%\rCWmY6Pm\u0016\u0014h\r\\8x\u0013:\u001cV/\u001c\t\u0003]a\u0019B\u0001GA9oAA\u00111OA=y\t[\u0015+\u0004\u0002\u0002v)\u0019\u0011qO\u001a\u0002\u000fI,h\u000e^5nK&!\u00111PA;\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003[\"\"!a\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fE\u000b))a\"\u0002\n\")!h\u0007a\u0001y!)\u0001i\u0007a\u0001\u0005\")\u0011j\u0007a\u0001\u0017\u00069QO\\1qa2LH\u0003BAH\u00037\u0003RAMAI\u0003+K1!a%4\u0005\u0019y\u0005\u000f^5p]B1!'a&=\u0005.K1!!'4\u0005\u0019!V\u000f\u001d7fg!A\u0011Q\u0014\u000f\u0002\u0002\u0003\u0007\u0011+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0015\t\u0005\u0003c\t)+\u0003\u0003\u0002(\u0006M\"AB(cU\u0016\u001cG\u000f")
public class CheckOverflowInSum
extends UnaryExpression
implements Serializable {
    private final Expression child;
    private final DecimalType dataType;
    private final boolean nullOnOverflow;

    public static Option<Tuple3<Expression, DecimalType, Object>> unapply(CheckOverflowInSum checkOverflowInSum) {
        return CheckOverflowInSum$.MODULE$.unapply(checkOverflowInSum);
    }

    public static Function1<Tuple3<Expression, DecimalType, Object>, CheckOverflowInSum> tupled() {
        return CheckOverflowInSum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<DecimalType, Function1<Object, CheckOverflowInSum>>> curried() {
        return CheckOverflowInSum$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DecimalType dataType() {
        return this.dataType;
    }

    public boolean nullOnOverflow() {
        return this.nullOnOverflow;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object eval(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            if (!this.nullOnOverflow()) throw new ArithmeticException("Overflow in sum of decimals.");
            return null;
        }
        Decimal decimal = ((Decimal)value).toPrecision(this.dataType().precision(), this.dataType().scale(), Decimal$.MODULE$.ROUND_HALF_UP(), this.nullOnOverflow());
        return decimal;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode childGen = this.child().genCode(ctx);
        String nullHandling = this.nullOnOverflow() ? "" : new StringOps(Predef$.MODULE$.augmentString("\n         |throw new ArithmeticException(\"Overflow in sum of decimals.\");\n         |")).stripMargin();
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", "\n       |boolean ", " = ", ";\n       |Decimal ", " = null;\n       |if (", ") {\n       |  ", "\n       |} else {\n       |  ", " = ", ".toPrecision(\n       |    ", ", ", ", Decimal.ROUND_HALF_UP(), ", ");\n       |  ", " = ", " == null;\n       |}\n       |"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childGen.code(), ev.isNull(), childGen.isNull(), ev.value(), childGen.isNull(), nullHandling, ev.value(), childGen.value(), BoxesRunTime.boxToInteger((int)this.dataType().precision()), BoxesRunTime.boxToInteger((int)this.dataType().scale()), BoxesRunTime.boxToBoolean((boolean)this.nullOnOverflow()), ev.isNull(), ev.value()})).stripMargin();
        return ev.copy(code, ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String toString() {
        return new StringBuilder(24).append("CheckOverflowInSum(").append(this.child()).append(", ").append(this.dataType()).append(", ").append(this.nullOnOverflow()).append(")").toString();
    }

    @Override
    public String sql() {
        return this.child().sql();
    }

    public CheckOverflowInSum copy(Expression child, DecimalType dataType, boolean nullOnOverflow) {
        return new CheckOverflowInSum(child, dataType, nullOnOverflow);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public DecimalType copy$default$2() {
        return this.dataType();
    }

    public boolean copy$default$3() {
        return this.nullOnOverflow();
    }

    @Override
    public String productPrefix() {
        return "CheckOverflowInSum";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.dataType();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.nullOnOverflow());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CheckOverflowInSum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CheckOverflowInSum)) return false;
        boolean bl = true;
        if (!bl) return false;
        CheckOverflowInSum checkOverflowInSum = (CheckOverflowInSum)x$1;
        Expression expression = this.child();
        Expression expression2 = checkOverflowInSum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        DecimalType decimalType = this.dataType();
        DecimalType decimalType2 = checkOverflowInSum.dataType();
        if (decimalType == null) {
            if (decimalType2 != null) {
                return false;
            }
        } else if (!((Object)decimalType).equals(decimalType2)) return false;
        if (this.nullOnOverflow() != checkOverflowInSum.nullOnOverflow()) return false;
        if (!checkOverflowInSum.canEqual(this)) return false;
        return true;
    }

    public CheckOverflowInSum(Expression child, DecimalType dataType, boolean nullOnOverflow) {
        this.child = child;
        this.dataType = dataType;
        this.nullOnOverflow = nullOnOverflow;
    }
}

