/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(unix_time[, fmt]) - Returns `unix_time` in the specified `fmt`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns. The 'yyyy-MM-dd HH:mm:ss' pattern is used if omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1969-12-31 16:00:00\n\n      > SELECT _FUNC_(0);\n       1969-12-31 16:00:00\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0015*\u0001ZB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002C5\u0001\u0005#\u0005\u000b\u0011B.\t\u000b)\u0004A\u0011A6\t\u000b)\u0004A\u0011\u00019\t\u000bM\u0004A\u0011\t*\t\u000bQ\u0004A\u0011\t*\t\u000bU\u0004A\u0011\t<\t\u000b)\u0004A\u0011A<\t\u000bi\u0004A\u0011I>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBa!a\u0019\u0001\t#\u0012\u0006bBA3\u0001\u0011E\u0013q\u0001\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003SB\u0011\"!\u001d\u0001#\u0003%\t!a\u001d\t\u0013\u0005%\u0005!%A\u0005\u0002\u0005M\u0004\"CAF\u0001E\u0005I\u0011AAG\u0011%\t\t\nAA\u0001\n\u0003\n\u0019\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003k\u0003\u0011\u0011!C!\u0003oC\u0011\"!2\u0001\u0003\u0003%\t!a2\t\u0013\u0005-\u0007!!A\u0005B\u00055w!CA|S\u0005\u0005\t\u0012AA}\r!A\u0013&!A\t\u0002\u0005m\bB\u00026!\t\u0003\u0011I\u0001C\u0005\u0003\f\u0001\n\t\u0011\"\u0012\u0003\u000e!I!q\u0002\u0011\u0002\u0002\u0013\u0005%\u0011\u0003\u0005\n\u00053\u0001\u0013\u0013!C\u0001\u0003\u001bC\u0011Ba\u0007!\u0003\u0003%\tI!\b\t\u0013\t-\u0002%%A\u0005\u0002\u00055\u0005\"\u0003B\u0017A\u0005\u0005I\u0011\u0002B\u0018\u000511%o\\7V]&DH+[7f\u0015\tQ3&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0017.\u0003!\u0019\u0017\r^1msN$(B\u0001\u00180\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO\u000e\u00011c\u0002\u00018wy\n\u0005J\u0014\t\u0003qej\u0011!K\u0005\u0003u%\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ab\u0014BA\u001f*\u0005a!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:IK2\u0004XM\u001d\t\u0003q}J!\u0001Q\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AQ#\u000f\u0005a\u001a\u0015B\u0001#*\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011A)\u000b\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\b!J|G-^2u!\tIu*\u0003\u0002Q\u0015\na1+\u001a:jC2L'0\u00192mK\u0006\u00191/Z2\u0016\u0003M\u0003\"\u0001\u000f+\n\u0005UK#AC#yaJ,7o]5p]\u0006!1/Z2!\u0003\u00191wN]7bi\u00069am\u001c:nCR\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\t1\fE\u0002J9zK!!\u0018&\u0003\r=\u0003H/[8o!\tyfM\u0004\u0002aIB\u0011\u0011MS\u0007\u0002E*\u00111-N\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015T\u0015A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a&\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1lgn\u001c\t\u0003q\u0001AQ!U\u0004A\u0002MCQaV\u0004A\u0002MCq!W\u0004\u0011\u0002\u0003\u00071\fF\u0002mcJDQ!\u0015\u0005A\u0002MCQa\u0016\u0005A\u0002M\u000bA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003y#\"\u0001\u001c=\t\u000bed\u0001\u0019A*\u0002\tUt\u0017\u000e_\u0001\tI\u0006$\u0018\rV=qKV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f6\nQ\u0001^=qKNL1!a\u0001\u007f\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005%\u0001cA%\u0002\f%\u0019\u0011Q\u0002&\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005M\u0001CBA\u000b\u0003;\t\u0019C\u0004\u0003\u0002\u0018\u0005mabA1\u0002\u001a%\t1*\u0003\u0002E\u0015&!\u0011qDA\u0011\u0005\r\u0019V-\u001d\u0006\u0003\t*\u00032!`A\u0013\u0013\r\t9C \u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fAb^5uQRKW.\u001a.p]\u0016$B!!\f\u00024A\u0019\u0001(a\f\n\u0007\u0005E\u0012FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]\")\u0011\f\u0005a\u0001=\u0006aa.\u001e7m'\u00064W-\u0012<bYR1\u0011\u0011HA \u0003\u0007\u00022!SA\u001e\u0013\r\tiD\u0013\u0002\u0004\u0003:L\bbBA!#\u0001\u0007\u0011\u0011H\u0001\bg\u0016\u001cwN\u001c3t\u0011\u00199\u0016\u00031\u0001\u0002:\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0013\n)&a\u0018\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014*\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0015\u0002N\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002XI\u0001\r!!\u0017\u0002\u0007\r$\b\u0010\u0005\u0003\u0002L\u0005m\u0013\u0002BA/\u0003\u001b\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002bI\u0001\r!!\u0013\u0002\u0005\u00154\u0018\u0001\u00044pe6\fGo\u0015;sS:<\u0017!C5t!\u0006\u00148/\u001b8h\u0003\u0011\u0019w\u000e]=\u0015\u000f1\fY'!\u001c\u0002p!9\u0011+\u0006I\u0001\u0002\u0004\u0019\u0006bB,\u0016!\u0003\u0005\ra\u0015\u0005\b3V\u0001\n\u00111\u0001\\\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001e+\u0007M\u000b9h\u000b\u0002\u0002zA!\u00111PAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015!C;oG\",7m[3e\u0015\r\t\u0019IS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAD\u0003{\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0010*\u001a1,a\u001e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\t1\fgn\u001a\u0006\u0003\u0003?\u000bAA[1wC&\u0019q-!'\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0006cA%\u0002*&\u0019\u00111\u0016&\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0012\u0011\u0017\u0005\n\u0003g[\u0012\u0011!a\u0001\u0003O\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA]!\u0019\tY,!1\u0002:5\u0011\u0011Q\u0018\u0006\u0004\u0003\u007fS\u0015AC2pY2,7\r^5p]&!\u00111YA_\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0011\u0011\u001a\u0005\n\u0003gk\u0012\u0011!a\u0001\u0003s\ta!Z9vC2\u001cH\u0003BA\u0005\u0003\u001fD\u0011\"a-\u001f\u0003\u0003\u0005\r!!\u000f)/\u0001\t\u0019.!7\u0002\\\u0006}\u0017\u0011]As\u0003O\fY/!<\u0002r\u0006M\bc\u0001\u001d\u0002V&\u0019\u0011q[\u0015\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011Q\\\u0001G?\u001a+fjQ0)k:L\u0007p\u0018;j[\u0016\\F\u0006\t4nivK\u0003%\f\u0011SKR,(O\\:!AVt\u0017\u000e_0uS6,\u0007\rI5oAQDW\rI:qK\u000eLg-[3eA\u00014W\u000e\u001e1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002d\u0006\u00119M\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!k:L\u0007p\u0018;j[\u0016\u0004S\u0006I+O\u0013b\u0003C+[7fgR\fW\u000e\u001d\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fAA\u0014xN^5eK\u0012\u0004cm\u001c:nCRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0CzR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t]\u0001\"\u0006.\u001a\u0011(sfL\u00180L'N[\u0011$\u0007\u0005\u0013%;[6T4o]\u0014!a\u0006$H/\u001a:oA%\u001c\b%^:fI\u0002Jg\rI8nSR$X\r\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003S\f\u0011q\u0005\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a1\u0002s%_=zs6jU*\f3eA!C%(\\7;gN<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112sYJT&\r\u001a.gE\u0002\u0013G\u000e\u001e1ai\u0002\u0004G\u0003\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a%Z$\u0002\t\u0011!A\u0001\u0002\u0003%M\u001d7s5\n$'L\u001a2AE2$\b\r\u0019;aAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003_\fa\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002v\u0006)\u0011GL\u001b/a\u0005aaI]8n+:L\u0007\u0010V5nKB\u0011\u0001\bI\n\u0005A\u0005uh\n\u0005\u0005\u0002\u0000\n\u00151kU.m\u001b\t\u0011\tAC\u0002\u0003\u0004)\u000bqA];oi&lW-\u0003\u0003\u0003\b\t\u0005!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011\u0011`\u0001\ti>\u001cFO]5oOR\u0011\u0011QS\u0001\u0006CB\u0004H.\u001f\u000b\bY\nM!Q\u0003B\f\u0011\u0015\t6\u00051\u0001T\u0011\u001596\u00051\u0001T\u0011\u001dI6\u0005%AA\u0002m\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yBa\n\u0011\t%c&\u0011\u0005\t\u0007\u0013\n\r2kU.\n\u0007\t\u0015\"J\u0001\u0004UkBdWm\r\u0005\t\u0005S)\u0013\u0011!a\u0001Y\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tE\u0002\u0003BAL\u0005gIAA!\u000e\u0002\u001a\n1qJ\u00196fGR\u0004")
public class FromUnixTime
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime fromUnixTime) {
        return FromUnixTime$.MODULE$.unapply(fromUnixTime);
    }

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object seconds, Object format) {
        TimestampFormatter fmt = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)fmt.format(BoxesRunTime.unboxToLong((Object)seconds) * 1000000L));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable & scala.Serializable)f -> {
            String formatterName = ctx.addReferenceObj("formatter", f, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, x$4) -> new StringBuilder(43).append("UTF8String.fromString(").append(formatterName).append(".format(").append((String)seconds).append(" * 1000000L))").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n           |UTF8String.fromString(\n           |  ").append(tf).append("$.MODULE$.apply(").append((String)format).append(".toString(),\n           |  ").append(zid).append(",\n           |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n           |  false).format(").append((String)seconds).append(" * 1000000L))\n           |").toString())).stripMargin());
        });
    }

    @Override
    public Expression formatString() {
        return this.format();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.sec();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

