/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Literal$
implements scala.Serializable {
    public static Literal$ MODULE$;
    private final Literal TrueLiteral;
    private final Literal FalseLiteral;

    static {
        new Literal$();
    }

    public Literal TrueLiteral() {
        return this.TrueLiteral;
    }

    public Literal FalseLiteral() {
        return this.FalseLiteral;
    }

    public Literal apply(Object v) {
        Literal literal;
        block27: {
            Object object;
            while (true) {
                if ((object = v) instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    literal = new Literal(BoxesRunTime.boxToInteger((int)n), IntegerType$.MODULE$);
                    break block27;
                }
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    literal = new Literal(BoxesRunTime.boxToLong((long)l), LongType$.MODULE$);
                    break block27;
                }
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    literal = new Literal(BoxesRunTime.boxToDouble((double)d), DoubleType$.MODULE$);
                    break block27;
                }
                if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    literal = new Literal(BoxesRunTime.boxToFloat((float)f), FloatType$.MODULE$);
                    break block27;
                }
                if (object instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte((Object)object);
                    literal = new Literal(BoxesRunTime.boxToByte((byte)by), ByteType$.MODULE$);
                    break block27;
                }
                if (object instanceof Short) {
                    short s = BoxesRunTime.unboxToShort((Object)object);
                    literal = new Literal(BoxesRunTime.boxToShort((short)s), ShortType$.MODULE$);
                    break block27;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    literal = new Literal(UTF8String.fromString((String)string), StringType$.MODULE$);
                    break block27;
                }
                if (object instanceof Character) {
                    char c = BoxesRunTime.unboxToChar((Object)object);
                    literal = new Literal(UTF8String.fromString((String)((Object)BoxesRunTime.boxToCharacter((char)c)).toString()), StringType$.MODULE$);
                    break block27;
                }
                if (object instanceof char[]) {
                    char[] cArray = (char[])object;
                    literal = new Literal(UTF8String.fromString((String)String.valueOf(cArray)), StringType$.MODULE$);
                    break block27;
                }
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    literal = new Literal(BoxesRunTime.boxToBoolean((boolean)bl), BooleanType$.MODULE$);
                    break block27;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    Decimal decimal = Decimal$.MODULE$.apply(bigDecimal);
                    literal = new Literal(decimal, DecimalType$.MODULE$.fromDecimal(decimal));
                    break block27;
                }
                if (object instanceof java.math.BigDecimal) {
                    java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                    Decimal decimal = Decimal$.MODULE$.apply(bigDecimal);
                    literal = new Literal(decimal, DecimalType$.MODULE$.fromDecimal(decimal));
                    break block27;
                }
                if (object instanceof Decimal) {
                    Decimal decimal = (Decimal)object;
                    literal = new Literal(decimal, new DecimalType(Math.max(decimal.precision(), decimal.scale()), decimal.scale()));
                    break block27;
                }
                if (object instanceof Instant) {
                    Instant instant = (Instant)object;
                    literal = new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant)), TimestampType$.MODULE$);
                    break block27;
                }
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    literal = new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp)), TimestampType$.MODULE$);
                    break block27;
                }
                if (object instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)object;
                    literal = new Literal(BoxesRunTime.boxToInteger((int)((int)localDate.toEpochDay())), DateType$.MODULE$);
                    break block27;
                }
                if (object instanceof Date) {
                    Date date = (Date)object;
                    literal = new Literal(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date)), DateType$.MODULE$);
                    break block27;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    literal = new Literal(byArray, BinaryType$.MODULE$);
                    break block27;
                }
                if (!(object instanceof WrappedArray)) break;
                WrappedArray wrappedArray = (WrappedArray)object;
                v = wrappedArray.array();
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                DataType elementType = this.componentTypeToDataType(object2.getClass().getComponentType());
                ArrayType dataType = ArrayType$.MODULE$.apply(elementType);
                Function1<Object, Object> convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType);
                literal = new Literal(convert.apply(object2), dataType);
            } else if (object instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)object;
                literal = new Literal(calendarInterval, CalendarIntervalType$.MODULE$);
            } else if (object == null) {
                literal = new Literal(null, NullType$.MODULE$);
            } else if (object instanceof Literal) {
                Literal literal2;
                literal = literal2 = (Literal)object;
            } else {
                throw new RuntimeException(new StringBuilder(26).append("Unsupported literal type ").append(v.getClass()).append(" ").append(v).toString());
            }
        }
        return literal;
    }

    private DataType componentTypeToDataType(Class<?> clz) {
        DataType dataType;
        Class<?> clazz = clz;
        Class<Short> clazz2 = Short.TYPE;
        Class<?> clazz3 = clazz;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            dataType = ShortType$.MODULE$;
        } else {
            Class<Integer> clazz4 = Integer.TYPE;
            Class<?> clazz5 = clazz;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                dataType = IntegerType$.MODULE$;
            } else {
                Class<Long> clazz6 = Long.TYPE;
                Class<?> clazz7 = clazz;
                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                    dataType = LongType$.MODULE$;
                } else {
                    Class<Double> clazz8 = Double.TYPE;
                    Class<?> clazz9 = clazz;
                    if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                        dataType = DoubleType$.MODULE$;
                    } else {
                        Class<Byte> clazz10 = Byte.TYPE;
                        Class<?> clazz11 = clazz;
                        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                            dataType = ByteType$.MODULE$;
                        } else {
                            Class<Float> clazz12 = Float.TYPE;
                            Class<?> clazz13 = clazz;
                            if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                dataType = FloatType$.MODULE$;
                            } else {
                                Class<Boolean> clazz14 = Boolean.TYPE;
                                Class<?> clazz15 = clazz;
                                if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                    dataType = BooleanType$.MODULE$;
                                } else {
                                    Class<Character> clazz16 = Character.TYPE;
                                    Class<?> clazz17 = clazz;
                                    if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
                                        dataType = StringType$.MODULE$;
                                    } else {
                                        Class<?> clazz18 = clz;
                                        Class<LocalDate> clazz19 = LocalDate.class;
                                        if (!(clazz18 != null ? !clazz18.equals(clazz19) : clazz19 != null)) {
                                            dataType = DateType$.MODULE$;
                                        } else {
                                            Class<?> clazz20 = clz;
                                            Class<Date> clazz21 = Date.class;
                                            if (!(clazz20 != null ? !clazz20.equals(clazz21) : clazz21 != null)) {
                                                dataType = DateType$.MODULE$;
                                            } else {
                                                Class<?> clazz22 = clz;
                                                Class<Instant> clazz23 = Instant.class;
                                                if (!(clazz22 != null ? !clazz22.equals(clazz23) : clazz23 != null)) {
                                                    dataType = TimestampType$.MODULE$;
                                                } else {
                                                    Class<?> clazz24 = clz;
                                                    Class<Timestamp> clazz25 = Timestamp.class;
                                                    if (!(clazz24 != null ? !clazz24.equals(clazz25) : clazz25 != null)) {
                                                        dataType = TimestampType$.MODULE$;
                                                    } else {
                                                        Class<?> clazz26 = clz;
                                                        Class<java.math.BigDecimal> clazz27 = java.math.BigDecimal.class;
                                                        if (!(clazz26 != null ? !clazz26.equals(clazz27) : clazz27 != null)) {
                                                            dataType = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                                                        } else {
                                                            Class<?> clazz28 = clz;
                                                            Class<byte[]> clazz29 = byte[].class;
                                                            if (!(clazz28 != null ? !clazz28.equals(clazz29) : clazz29 != null)) {
                                                                dataType = BinaryType$.MODULE$;
                                                            } else {
                                                                Class<?> clazz30 = clz;
                                                                Class<char[]> clazz31 = char[].class;
                                                                if (!(clazz30 != null ? !clazz30.equals(clazz31) : clazz31 != null)) {
                                                                    dataType = StringType$.MODULE$;
                                                                } else {
                                                                    Class<?> clazz32 = clz;
                                                                    Class<Short> clazz33 = Short.class;
                                                                    if (!(clazz32 != null ? !clazz32.equals(clazz33) : clazz33 != null)) {
                                                                        dataType = ShortType$.MODULE$;
                                                                    } else {
                                                                        Class<?> clazz34 = clz;
                                                                        Class<Integer> clazz35 = Integer.class;
                                                                        if (!(clazz34 != null ? !clazz34.equals(clazz35) : clazz35 != null)) {
                                                                            dataType = IntegerType$.MODULE$;
                                                                        } else {
                                                                            Class<?> clazz36 = clz;
                                                                            Class<Long> clazz37 = Long.class;
                                                                            if (!(clazz36 != null ? !clazz36.equals(clazz37) : clazz37 != null)) {
                                                                                dataType = LongType$.MODULE$;
                                                                            } else {
                                                                                Class<?> clazz38 = clz;
                                                                                Class<Double> clazz39 = Double.class;
                                                                                if (!(clazz38 != null ? !clazz38.equals(clazz39) : clazz39 != null)) {
                                                                                    dataType = DoubleType$.MODULE$;
                                                                                } else {
                                                                                    Class<?> clazz40 = clz;
                                                                                    Class<Byte> clazz41 = Byte.class;
                                                                                    if (!(clazz40 != null ? !clazz40.equals(clazz41) : clazz41 != null)) {
                                                                                        dataType = ByteType$.MODULE$;
                                                                                    } else {
                                                                                        Class<?> clazz42 = clz;
                                                                                        Class<Float> clazz43 = Float.class;
                                                                                        if (!(clazz42 != null ? !clazz42.equals(clazz43) : clazz43 != null)) {
                                                                                            dataType = FloatType$.MODULE$;
                                                                                        } else {
                                                                                            Class<?> clazz44 = clz;
                                                                                            Class<Boolean> clazz45 = Boolean.class;
                                                                                            if (!(clazz44 != null ? !clazz44.equals(clazz45) : clazz45 != null)) {
                                                                                                dataType = BooleanType$.MODULE$;
                                                                                            } else {
                                                                                                Class<?> clazz46 = clz;
                                                                                                Class<String> clazz47 = String.class;
                                                                                                if (!(clazz46 != null ? !clazz46.equals(clazz47) : clazz47 != null)) {
                                                                                                    dataType = StringType$.MODULE$;
                                                                                                } else {
                                                                                                    Class<?> clazz48 = clz;
                                                                                                    Class<BigInt> clazz49 = BigInt.class;
                                                                                                    if (!(clazz48 != null ? !clazz48.equals(clazz49) : clazz49 != null)) {
                                                                                                        dataType = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                                                                                                    } else {
                                                                                                        Class<?> clazz50 = clz;
                                                                                                        Class<BigDecimal> clazz51 = BigDecimal.class;
                                                                                                        if (!(clazz50 != null ? !clazz50.equals(clazz51) : clazz51 != null)) {
                                                                                                            dataType = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                                                                                                        } else {
                                                                                                            Class<?> clazz52 = clz;
                                                                                                            Class<CalendarInterval> clazz53 = CalendarInterval.class;
                                                                                                            if (!(clazz52 != null ? !clazz52.equals(clazz53) : clazz53 != null)) {
                                                                                                                dataType = CalendarIntervalType$.MODULE$;
                                                                                                            } else if (clz.isArray()) {
                                                                                                                dataType = ArrayType$.MODULE$.apply(this.componentTypeToDataType(clz.getComponentType()));
                                                                                                            } else {
                                                                                                                throw new AnalysisException(new StringBuilder(37).append("Unsupported component type ").append(clz).append(" in arrays").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return dataType;
    }

    public Literal fromObject(Object obj, DataType objType) {
        return new Literal(obj, objType);
    }

    public Literal fromObject(Object obj) {
        return new Literal(obj, new ObjectType(obj.getClass()));
    }

    public Literal create(Object v, DataType dataType) {
        return new Literal(CatalystTypeConverters$.MODULE$.convertToCatalyst(v), dataType);
    }

    public <T> Literal create(T v, TypeTags.TypeTag<T> evidence$1) {
        return (Literal)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            DataType dataType;
            ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor(evidence$1);
            if (schema == null) {
                throw new MatchError((Object)schema);
            }
            DataType dataType2 = dataType = schema.dataType();
            DataType dataType3 = dataType2;
            Function1<Object, Object> convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType3);
            return new Literal(convert.apply(v), dataType3);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.apply(v));
    }

    public Literal default(DataType dataType) {
        Literal literal;
        DataType dataType2 = dataType;
        if (NullType$.MODULE$.equals(dataType2)) {
            literal = this.create(null, NullType$.MODULE$);
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToBoolean((boolean)false));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToByte((byte)((byte)0)));
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToShort((short)((short)0)));
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToInteger((int)0));
        } else if (LongType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToLong((long)0L));
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToFloat((float)0.0f));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToDouble((double)0.0));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            literal = this.apply(Decimal$.MODULE$.apply(0L, decimalType.precision(), decimalType.scale()));
        } else if (DateType$.MODULE$.equals(dataType2)) {
            literal = this.create(BoxesRunTime.boxToInteger((int)0), DateType$.MODULE$);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            literal = this.create(BoxesRunTime.boxToLong((long)0L), TimestampType$.MODULE$);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            literal = this.apply("");
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            literal = this.apply("".getBytes(StandardCharsets.UTF_8));
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            literal = this.apply(new CalendarInterval(0, 0, 0L));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            literal = this.create(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()), arrayType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            literal = this.create(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), mapType);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            literal = this.create(InternalRow$.MODULE$.fromSeq((Seq<Object>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.default(f.dataType()).value(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))), structType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            literal = new Literal(this.default(userDefinedType.sqlType()).value(), userDefinedType);
        } else {
            throw new RuntimeException(new StringBuilder(20).append("no default for type ").append(dataType).toString());
        }
        return literal;
    }

    public void validateLiteralValue(Object value, DataType dataType) {
        Predef$.MODULE$.require(this.doValidate$1(value, dataType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Literal must have a corresponding value to ").append(dataType.catalogString()).append(", ").append("but class ").append(Utils$.MODULE$.getSimpleName(value.getClass())).append(" found.").toString());
    }

    public Literal apply(Object value, DataType dataType) {
        return new Literal(value, dataType);
    }

    public Option<Tuple2<Object, DataType>> unapply(Literal x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.value(), (Object)x$0.dataType()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateLiteralValue$2(Literal$ $this, InternalRow row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType dt = (DataType)tuple2._1();
        int i = tuple2._2$mcI$sp();
        boolean bl = $this.doValidate$1(row$1.get(i, dt), dt);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean doValidate$1(Object v, DataType dataType) {
        while (true) {
            DataType dataType2 = dataType;
            if (v == null) {
                return true;
            }
            if (BooleanType$.MODULE$.equals(dataType2)) {
                return v instanceof Boolean;
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return v instanceof Byte;
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return v instanceof Short;
            }
            boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : DateType$.MODULE$.equals(dataType2);
            if (bl) {
                return v instanceof Integer;
            }
            boolean bl2 = LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2);
            if (bl2) {
                return v instanceof Long;
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return v instanceof Float;
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return v instanceof Double;
            }
            if (dataType2 instanceof DecimalType) {
                return v instanceof Decimal;
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                return v instanceof CalendarInterval;
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return v instanceof byte[];
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return v instanceof UTF8String;
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                if (!(v instanceof InternalRow)) return false;
                InternalRow row = (InternalRow)v;
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Literal$.$anonfun$validateLiteralValue$2(this, row, x0$1)))) return false;
                return true;
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                if (!(v instanceof ArrayData)) return false;
                ArrayData ar = (ArrayData)v;
                if (ar.numElements() != 0) {
                    dataType = arrayType.elementType();
                    v = ar.get(0, arrayType.elementType());
                    continue;
                }
                if (!true) return false;
                return true;
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                if (!(v instanceof MapData)) return false;
                MapData map = (MapData)v;
                if (this.doValidate$1(map.keyArray(), ArrayType$.MODULE$.apply(mapType.keyType()))) {
                    dataType = ArrayType$.MODULE$.apply(mapType.valueType());
                    v = map.valueArray();
                    continue;
                }
                if (!false) return false;
                return true;
            }
            if (dataType2 instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType2;
                Class<?> cls = objectType.cls();
                return cls.isInstance(v);
            }
            if (!(dataType2 instanceof UserDefinedType)) return false;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
    }

    private Literal$() {
        MODULE$ = this;
        this.TrueLiteral = new Literal(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$);
        this.FalseLiteral = new Literal(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$);
    }
}

