/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(years, months, weeks, days, hours, mins, secs) - Make interval from years, months, weeks, days, hours, mins and secs.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n      * weeks - the number of weeks, positive or negative\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(100, 11, 1, 1, 12, 30, 01.001001);\n       100 years 11 months 8 days 12 hours 30 minutes 1.001001 seconds\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n      > SELECT _FUNC_(0, 1, 0, 1, 0, 0, 100.000001);\n       1 months 1 days 1 minutes 40.000001 seconds\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t-g\u0001B\u001d;\u0001\u001eC\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005C\"AQ\r\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005g\u0001\tE\t\u0015!\u0003b\u0011!9\u0007A!f\u0001\n\u0003\u0001\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B1\t\u0011%\u0004!Q3A\u0005\u0002\u0001D\u0001B\u001b\u0001\u0003\u0012\u0003\u0006I!\u0019\u0005\tW\u0002\u0011)\u001a!C\u0001A\"AA\u000e\u0001B\tB\u0003%\u0011\r\u0003\u0005n\u0001\tU\r\u0011\"\u0001a\u0011!q\u0007A!E!\u0002\u0013\t\u0007\u0002C8\u0001\u0005+\u0007I\u0011\u00011\t\u0011A\u0004!\u0011#Q\u0001\n\u0005D\u0001\"\u001d\u0001\u0003\u0016\u0004%\tA\u001d\u0005\tm\u0002\u0011\t\u0012)A\u0005g\")q\u000f\u0001C\u0001q\"1q\u000f\u0001C\u0001\u0003\u000bAaa\u001e\u0001\u0005\u0002\u0005]\u0001BB<\u0001\t\u0003\t)\u0003\u0003\u0004x\u0001\u0011\u0005\u0011\u0011\u0007\u0005\u0007o\u0002!\t!a\u000f\t\r]\u0004A\u0011AA\"\u0011\u00199\b\u0001\"\u0001\u0002J!1q\u000f\u0001C\u0001\u0003\u001bBq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!1\u0011Q\u0011\u0001\u0005BIDq!a\"\u0001\t\u0003\nI\tC\u0004\u00022\u0002!\t%a-\t\u000f\u0005=\u0007\u0001\"\u0011\u0002R\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003sD\u0011Ba\u0004\u0001#\u0003%\t!!?\t\u0013\tE\u0001!%A\u0005\u0002\u0005e\b\"\u0003B\n\u0001E\u0005I\u0011AA}\u0011%\u0011)\u0002AI\u0001\n\u0003\tI\u0010C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0002z\"I!\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u00057\u0001\u0011\u0013!C\u0001\u0005;A\u0011B!\t\u0001\u0003\u0003%\tEa\t\t\u0013\tM\u0002!!A\u0005\u0002\tU\u0002\"\u0003B\u001f\u0001\u0005\u0005I\u0011\u0001B \u0011%\u0011)\u0005AA\u0001\n\u0003\u00129\u0005C\u0005\u0003V\u0001\t\t\u0011\"\u0001\u0003X!I!1\f\u0001\u0002\u0002\u0013\u0005#QL\u0004\n\u0005\u0003S\u0014\u0011!E\u0001\u0005\u00073\u0001\"\u000f\u001e\u0002\u0002#\u0005!Q\u0011\u0005\u0007oF\"\tAa%\t\u0013\tU\u0015'!A\u0005F\t]\u0005\"\u0003BMc\u0005\u0005I\u0011\u0011BN\u0011%\u0011i+MI\u0001\n\u0003\u0011i\u0002C\u0005\u00030F\n\t\u0011\"!\u00032\"I!qX\u0019\u0012\u0002\u0013\u0005!Q\u0004\u0005\n\u0005\u0003\f\u0014\u0011!C\u0005\u0005\u0007\u0014A\"T1lK&sG/\u001a:wC2T!a\u000f\u001f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003{y\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u007f\u0001\u000b1a]9m\u0015\t\t%)A\u0003ta\u0006\u00148N\u0003\u0002D\t\u00061\u0011\r]1dQ\u0016T\u0011!R\u0001\u0004_J<7\u0001A\n\u0007\u0001!cuJ\u0016/\u0011\u0005%SU\"\u0001\u001e\n\u0005-S$aE*faR,g.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA%N\u0013\tq%H\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\u00016K\u0004\u0002J#&\u0011!KO\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005IS\u0004CA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&a\u0002)s_\u0012,8\r\u001e\t\u0003/vK!A\u0018-\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000be,\u0017M]:\u0016\u0003\u0005\u0004\"!\u00132\n\u0005\rT$AC#yaJ,7o]5p]\u00061\u00110Z1sg\u0002\na!\\8oi\"\u001c\u0018aB7p]RD7\u000fI\u0001\u0006o\u0016,7n]\u0001\u0007o\u0016,7n\u001d\u0011\u0002\t\u0011\f\u0017p]\u0001\u0006I\u0006L8\u000fI\u0001\u0006Q>,(o]\u0001\u0007Q>,(o\u001d\u0011\u0002\t5Lgn]\u0001\u0006[&t7\u000fI\u0001\u0005g\u0016\u001c7/A\u0003tK\u000e\u001c\b%A\u0006gC&dwJ\\#se>\u0014X#A:\u0011\u0005]#\u0018BA;Y\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDcC={wrlhp`A\u0001\u0003\u0007\u0001\"!\u0013\u0001\t\u000b}\u000b\u0002\u0019A1\t\u000b\u0015\f\u0002\u0019A1\t\u000b\u001d\f\u0002\u0019A1\t\u000b%\f\u0002\u0019A1\t\u000b-\f\u0002\u0019A1\t\u000b5\f\u0002\u0019A1\t\u000b=\f\u0002\u0019A1\t\u000fE\f\u0002\u0013!a\u0001gRy\u00110a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\u0002C\u0003`%\u0001\u0007\u0011\rC\u0003f%\u0001\u0007\u0011\rC\u0003h%\u0001\u0007\u0011\rC\u0003j%\u0001\u0007\u0011\rC\u0003l%\u0001\u0007\u0011\rC\u0003n%\u0001\u0007\u0011\r\u0003\u0004\u0002\u0016I\u0001\r!Y\u0001\u0004g\u0016\u001cG#D=\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019\u0003C\u0003`'\u0001\u0007\u0011\rC\u0003f'\u0001\u0007\u0011\rC\u0003h'\u0001\u0007\u0011\rC\u0003j'\u0001\u0007\u0011\rC\u0003l'\u0001\u0007\u0011\rC\u0003n'\u0001\u0007\u0011\rF\u0006z\u0003O\tI#a\u000b\u0002.\u0005=\u0002\"B0\u0015\u0001\u0004\t\u0007\"B3\u0015\u0001\u0004\t\u0007\"B4\u0015\u0001\u0004\t\u0007\"B5\u0015\u0001\u0004\t\u0007\"B6\u0015\u0001\u0004\tG#C=\u00024\u0005U\u0012qGA\u001d\u0011\u0015yV\u00031\u0001b\u0011\u0015)W\u00031\u0001b\u0011\u00159W\u00031\u0001b\u0011\u0015IW\u00031\u0001b)\u001dI\u0018QHA \u0003\u0003BQa\u0018\fA\u0002\u0005DQ!\u001a\fA\u0002\u0005DQa\u001a\fA\u0002\u0005$R!_A#\u0003\u000fBQaX\fA\u0002\u0005DQ!Z\fA\u0002\u0005$2!_A&\u0011\u0015y\u0006\u00041\u0001b)\u0005I\u0018\u0001C2iS2$'/\u001a8\u0016\u0005\u0005M\u0003#BA+\u0003G\ng\u0002BA,\u0003CrA!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;2\u0015A\u0002\u001fs_>$h(C\u0001Z\u0013\t\u0011\u0006,\u0003\u0003\u0002f\u0005\u001d$aA*fc*\u0011!\u000bW\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA7!\u0019\t)&a\u0019\u0002pA!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vy\nQ\u0001^=qKNLA!!\u001f\u0002t\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0010\t\u0005\u0003c\n\t)\u0003\u0003\u0002\u0004\u0006M$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$\u0002#a#\u0002\u0012\u0006U\u0015\u0011TAO\u0003C\u000b)+!+\u0011\u0007]\u000bi)C\u0002\u0002\u0010b\u00131!\u00118z\u0011\u001d\t\u0019J\ba\u0001\u0003\u0017\u000bA!_3be\"9\u0011q\u0013\u0010A\u0002\u0005-\u0015!B7p]RD\u0007bBAN=\u0001\u0007\u00111R\u0001\u0005o\u0016,7\u000eC\u0004\u0002 z\u0001\r!a#\u0002\u0007\u0011\f\u0017\u0010C\u0004\u0002$z\u0001\r!a#\u0002\t!|WO\u001d\u0005\b\u0003Os\u0002\u0019AAF\u0003\ri\u0017N\u001c\u0005\b\u0003+q\u0002\u0019AAV!\u00159\u0016QVAF\u0013\r\ty\u000b\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA[\u0003\u0003\fY\r\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tYLO\u0001\bG>$WmZ3o\u0013\u0011\ty,!/\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a1 \u0001\u0004\t)-A\u0002dib\u0004B!a.\u0002H&!\u0011\u0011ZA]\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!4 \u0001\u0004\t),\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005M\u0007\u0003BAk\u0003;tA!a6\u0002ZB\u0019\u0011\u0011\f-\n\u0007\u0005m\u0007,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\f\tO\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037D\u0016\u0001B2paf$\u0012#_At\u0003S\fY/!<\u0002p\u0006E\u00181_A{\u0011\u001dy\u0016\u0005%AA\u0002\u0005Dq!Z\u0011\u0011\u0002\u0003\u0007\u0011\rC\u0004hCA\u0005\t\u0019A1\t\u000f%\f\u0003\u0013!a\u0001C\"91.\tI\u0001\u0002\u0004\t\u0007bB7\"!\u0003\u0005\r!\u0019\u0005\b_\u0006\u0002\n\u00111\u0001b\u0011\u001d\t\u0018\u0005%AA\u0002M\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002|*\u001a\u0011-!@,\u0005\u0005}\b\u0003\u0002B\u0001\u0005\u0017i!Aa\u0001\u000b\t\t\u0015!qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0003Y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0011\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"Aa\b+\u0007M\fi0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005K\u0001BAa\n\u000325\u0011!\u0011\u0006\u0006\u0005\u0005W\u0011i#\u0001\u0003mC:<'B\u0001B\u0018\u0003\u0011Q\u0017M^1\n\t\u0005}'\u0011F\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005o\u00012a\u0016B\u001d\u0013\r\u0011Y\u0004\u0017\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\u0013\t\u0005C\u0005\u0003D1\n\t\u00111\u0001\u00038\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0013\u0011\r\t-#\u0011KAF\u001b\t\u0011iEC\u0002\u0003Pa\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019F!\u0014\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004g\ne\u0003\"\u0003B\"]\u0005\u0005\t\u0019AAF\u0003\u0019)\u0017/^1mgR\u00191Oa\u0018\t\u0013\t\rs&!AA\u0002\u0005-\u0005f\u0005\u0001\u0003d\t%$1\u000eB8\u0005c\u0012)Ha\u001e\u0003|\tu\u0004cA%\u0003f%\u0019!q\r\u001e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QN\u0001}?\u001a+fjQ0)s\u0016\f'o\u001d\u0017![>tG\u000f[:-A],Wm[:-A\u0011\f\u0017p\u001d\u0017!Q>,(o\u001d\u0017![&t7\u000f\f\u0011tK\u000e\u001c\u0018\u0006I\u0017!\u001b\u0006\\W\rI5oi\u0016\u0014h/\u00197!MJ|W\u000eI=fCJ\u001cH\u0006I7p]RD7\u000f\f\u0011xK\u0016\\7\u000f\f\u0011eCf\u001cH\u0006\t5pkJ\u001cH\u0006I7j]N\u0004\u0013M\u001c3!g\u0016\u001c7OL\u0001\nCJ<W/\\3oiN\f#Aa\u001d\u0002\u0007\u001fS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I=fCJ\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011zK\u0006\u00148\u000f\f\u0011q_NLG/\u001b<fA=\u0014\bE\\3hCRLg/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f[:![\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002jwN\u001c;ig2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003e^3fWN\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI<fK.\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCf\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011eCf\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011i_V\u00148\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!Q>,(o\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A5Lgn\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gA5Lg.\u001e;fg2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003e]3dg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007e]3d_:$7\u000fI<ji\"\u0004C\u000f[3!MJ\f7\r^5p]\u0006d\u0007\u0005]1si\u0002Jg\u000eI7jGJ|7/Z2p]\u0012\u0004\u0003O]3dSNLwN\u001c\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005s\n!Q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cA\u0002D\u0006I\u00192Y\u0001\nD\u0006I\u0019-AE\u0012D\u0006I\u001a1Y\u0001\u0002\u0014G\f\u00191cA\u0002\u0014'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cA\u0002\u0004%_3beN\u0004\u0013'\r\u0011n_:$\bn\u001d\u00119A\u0011\f\u0017p\u001d\u00112e\u0001Bw.\u001e:tAM\u0002\u0004%\\5okR,7\u000fI\u0019/aA\n\u0004\u0007M\u0019!g\u0016\u001cwN\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\r\u0017!]VdG\u000e\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002D\u0006I\u0019-AAb\u0003%\r\u0017!a1\u0002\u0003\u0007\f\u00112aAr\u0003\u0007\r\u00191aEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019![>tG\u000f[:!c\u0001\"\u0017-_:!c\u0001j\u0017N\\;uKN\u0004C\u0007\r\u00181aA\u0002\u0004'\r\u0011tK\u000e|g\u000eZ:\u000bA\u0001\nQa]5oG\u0016\f#Aa \u0002\u000bMr\u0003G\f\u0019\u0002\u00195\u000b7.Z%oi\u0016\u0014h/\u00197\u0011\u0005%\u000b4\u0003B\u0019\u0003\br\u0003RB!#\u0003\u0010\u0006\f\u0017-Y1bCNLXB\u0001BF\u0015\r\u0011i\tW\u0001\beVtG/[7f\u0013\u0011\u0011\tJa#\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\b\u0006\u0002\u0003\u0004\u0006AAo\\*ue&tw\r\u0006\u0002\u0003&\u0005)\u0011\r\u001d9msR\t\u0012P!(\u0003 \n\u0005&1\u0015BS\u0005O\u0013IKa+\t\u000b}#\u0004\u0019A1\t\u000b\u0015$\u0004\u0019A1\t\u000b\u001d$\u0004\u0019A1\t\u000b%$\u0004\u0019A1\t\u000b-$\u0004\u0019A1\t\u000b5$\u0004\u0019A1\t\u000b=$\u0004\u0019A1\t\u000fE$\u0004\u0013!a\u0001g\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM&1\u0018\t\u0006/\u00065&Q\u0017\t\f/\n]\u0016-Y1bC\u0006\f7/C\u0002\u0003:b\u0013a\u0001V;qY\u0016D\u0004\u0002\u0003B_m\u0005\u0005\t\u0019A=\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003FB!!q\u0005Bd\u0013\u0011\u0011IM!\u000b\u0003\r=\u0013'.Z2u\u0001")
public class MakeInterval
extends SeptenaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression years;
    private final Expression months;
    private final Expression weeks;
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$8() {
        return MakeInterval$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>> unapply(MakeInterval makeInterval) {
        return MakeInterval$.MODULE$.unapply(makeInterval);
    }

    public static boolean apply$default$8() {
        return MakeInterval$.MODULE$.apply$default$8();
    }

    public static Function1<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>, MakeInterval> tupled() {
        return MakeInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeInterval>>>>>>>> curried() {
        return MakeInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    public Expression weeks() {
        return this.weeks;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.years(), this.months(), this.weeks(), this.days(), this.hours(), this.mins(), this.secs()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)}));
    }

    @Override
    public DataType dataType() {
        return CalendarIntervalType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object week, Object day, Object hour, Object min, Option<Object> sec) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = IntervalUtils$.MODULE$.makeInterval(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)week), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec.map((Function1 & Serializable & scala.Serializable)x$2 -> (Decimal)x$2).getOrElse((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ArithmeticException) || this.failOnError()) {
                throw throwable;
            }
            CalendarInterval calendarInterval2 = null;
            calendarInterval = calendarInterval2;
        }
        return calendarInterval;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, week, day, hour, min, sec) -> {
            String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            String secFrac = (String)sec.getOrElse((Function0 & Serializable & scala.Serializable)() -> "0");
            String faileOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
            return new StringBuilder(136).append("\n        try {\n          ").append(ev.value()).append(" = ").append(iu).append(".makeInterval(").append((String)year).append(", ").append((String)month).append(", ").append((String)week).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", ").append(secFrac).append(");\n        } catch (java.lang.ArithmeticException e) {\n          ").append(faileOnErrorBranch).append("\n        }\n      ").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_interval";
    }

    public MakeInterval copy(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        return new MakeInterval(years, months, weeks, days, hours, mins, secs, failOnError);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    public Expression copy$default$3() {
        return this.weeks();
    }

    public Expression copy$default$4() {
        return this.days();
    }

    public Expression copy$default$5() {
        return this.hours();
    }

    public Expression copy$default$6() {
        return this.mins();
    }

    public Expression copy$default$7() {
        return this.secs();
    }

    public boolean copy$default$8() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeInterval";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.years();
                break;
            }
            case 1: {
                object = this.months();
                break;
            }
            case 2: {
                object = this.weeks();
                break;
            }
            case 3: {
                object = this.days();
                break;
            }
            case 4: {
                object = this.hours();
                break;
            }
            case 5: {
                object = this.mins();
                break;
            }
            case 6: {
                object = this.secs();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeInterval makeInterval = (MakeInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = makeInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.weeks();
        Expression expression6 = makeInterval.weeks();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.days();
        Expression expression8 = makeInterval.days();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.hours();
        Expression expression10 = makeInterval.hours();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.mins();
        Expression expression12 = makeInterval.mins();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Expression expression13 = this.secs();
        Expression expression14 = makeInterval.secs();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (this.failOnError() != makeInterval.failOnError()) return false;
        if (!makeInterval.canEqual(this)) return false;
        return true;
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression sec) {
        this(years, months, weeks, days, hours, mins, sec, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins) {
        this(years, months, weeks, days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours) {
        this(years, months, weeks, days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days) {
        this(years, months, weeks, days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks) {
        this(years, months, weeks, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months) {
        this(years, months, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

