/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015Y\u0007\u0001\"\u0011m\u0011!\u0001\b\u0001#b\u0001\n\u0013\t\b\"\u0002=\u0001\t\u0003J\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011%\t)\u0004AA\u0001\n\u0003\t9\u0004C\u0005\u0002>\u0001\t\n\u0011\"\u0001\u0002@!I\u0011Q\u000b\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u0018\u0002\t\t\u0011\"\u0011\u0002\u001a\u001eI\u0011q\u0017\u0010\u0002\u0002#\u0005\u0011\u0011\u0018\u0004\t;y\t\t\u0011#\u0001\u0002<\"11j\u0006C\u0001\u0003\u0013D\u0011\"a3\u0018\u0003\u0003%)%!4\t\u0013\u0005=w#!A\u0005\u0002\u0006E\u0007\"CAl/\u0005\u0005I\u0011QAm\u0011%\tYoFA\u0001\n\u0013\tiOA\u0007NCB4%o\\7BeJ\f\u0017p\u001d\u0006\u0003?\u0001\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011EI\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0005J\u0001\u0004gFd'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\f\u00194u\u0001\u0003\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00172\u0013\t\u0011dDA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"\u0001N\u001c\u000f\u00055*\u0014B\u0001\u001c\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001O\u001d\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011aG\b\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\b!J|G-^2u!\tY\u0014)\u0003\u0002Cy\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005)\u0005CA\u0017G\u0013\t9eD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002N\u001d>\u0003\"!\f\u0001\t\u000b\r+\u0001\u0019A#\t\u000b%+\u0001\u0019A#\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001S!\r\u0019&,\u0018\b\u0003)fs!!\u0016-\u000e\u0003YS!a\u0016\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0014B\u0001\u001c=\u0013\tYFLA\u0002TKFT!A\u000e\u001f\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u0014\u0013!\u0002;za\u0016\u001c\u0018B\u00012`\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001f!\t1\u0017.D\u0001h\u0015\tA\u0007%\u0001\u0005b]\u0006d\u0017p]5t\u0013\tQwMA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!!\u0017\r^1UsB,W#A7\u0011\u0005ys\u0017BA8`\u0005\u001di\u0015\r\u001d+za\u0016\f!\"\\1q\u0005VLG\u000eZ3s+\u0005\u0011\bCA:w\u001b\u0005!(BA;!\u0003\u0011)H/\u001b7\n\u0005]$(\u0001F!se\u0006L()Y:fI6\u000b\u0007OQ;jY\u0012,'/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002{{~\u0004\"aO>\n\u0005qd$aA!os\")aP\u0003a\u0001u\u0006A1.Z=BeJ\f\u0017\u0010\u0003\u0004\u0002\u0002)\u0001\rA_\u0001\u000bm\u0006dW/Z!se\u0006L\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9!a\u0005\u0002\u001eA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000ey\tqaY8eK\u001e,g.\u0003\u0003\u0002\u0012\u0005-!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005U1\u00021\u0001\u0002\u0018\u0005\u00191\r\u001e=\u0011\t\u0005%\u0011\u0011D\u0005\u0005\u00037\tYA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005}1\u00021\u0001\u0002\b\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\u0013!\u0011\t9#a\f\u000f\t\u0005%\u00121\u0006\t\u0003+rJ1!!\f=\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011GA\u001a\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0006\u001f\u0002\t\r|\u0007/\u001f\u000b\u0006\u001b\u0006e\u00121\b\u0005\b\u00076\u0001\n\u00111\u0001F\u0011\u001dIU\u0002%AA\u0002\u0015\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002B)\u001aQ)a\u0011,\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0014=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\nIEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0003mC:<'BAA3\u0003\u0011Q\u0017M^1\n\t\u0005E\u0012qL\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003[\u00022aOA8\u0013\r\t\t\b\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004u\u0006]\u0004\"CA=%\u0005\u0005\t\u0019AA7\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0010\t\u0006\u0003\u0003\u000b9I_\u0007\u0003\u0003\u0007S1!!\"=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\u000b\u0019I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAH\u0003+\u00032aOAI\u0013\r\t\u0019\n\u0010\u0002\b\u0005>|G.Z1o\u0011!\tI\bFA\u0001\u0002\u0004Q\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0010\u0006m\u0005\u0002CA=+\u0005\u0005\t\u0019\u0001>)\u001f\u0001\ty*!*\u0002(\u0006-\u0016QVAY\u0003g\u00032!LAQ\u0013\r\t\u0019K\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI+AA\u0003\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK6fsNd\u0003E^1mk\u0016\u001c\u0018\u0006I\u0017!\u0007J,\u0017\r^3tA\u0005\u0004S.\u00199!o&$\b\u000eI1!a\u0006L'\u000fI8gAQDW\rI4jm\u0016t\u0007e[3z_Y\fG.^3!CJ\u0014\u0018-_:/A\u0005cG\u000eI3mK6,g\u000e^:\u000bA\u0001\u0002\u0003\u0005\t\u0011j]\u0002ZW-_:!g\"|W\u000f\u001c3!]>$\bEY3!]VdG.\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty+A2\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c9\u0002D\u0006I\u001a/a%b\u0003%\u0019:sCfDsEM\u0014-A\u001d\"t%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\fd\u0006\r\u001e#e\tb3G\f\u0019;EQ\u0012SP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t),A\u00033]Qr\u0003'A\u0007NCB4%o\\7BeJ\f\u0017p\u001d\t\u0003[]\u0019BaFA_\u0001B9\u0011qXAc\u000b\u0016kUBAAa\u0015\r\t\u0019\rP\u0001\beVtG/[7f\u0013\u0011\t9-!1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002:\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\\\u0005)\u0011\r\u001d9msR)Q*a5\u0002V\")1I\u0007a\u0001\u000b\")\u0011J\u0007a\u0001\u000b\u00069QO\\1qa2LH\u0003BAn\u0003O\u0004RaOAo\u0003CL1!a8=\u0005\u0019y\u0005\u000f^5p]B)1(a9F\u000b&\u0019\u0011Q\u001d\u001f\u0003\rQ+\b\u000f\\33\u0011!\tIoGA\u0001\u0002\u0004i\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u000f\u0005\u0003\u0002^\u0005E\u0018\u0002BAz\u0003?\u0012aa\u00142kK\u000e$\b")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays mapFromArrays) {
        return MapFromArrays$.MODULE$.unapply(mapFromArrays);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            typeCheckResult = defaultCheck;
        } else {
            DataType keyType = ((ArrayType)this.left().dataType()).elementType();
            typeCheckResult = TypeUtils$.MODULE$.checkForMapKeyType(keyType);
        }
        return typeCheckResult;
    }

    @Override
    public MapType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        MapFromArrays mapFromArrays = this;
        synchronized (mapFromArrays) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        return this.mapBuilder().from(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(keyArrayData, valueArrayData) -> {
            String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
            return new StringBuilder(27).append(ev.value()).append(" = ").append(builderTerm).append(".from(").append((String)keyArrayData).append(".copy(), ").append((String)valueArrayData).append(".copy());").toString();
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

