/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1")
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B&\t\u000bM\u0003A\u0011\u0001+\t\u000bM\u0003A\u0011A-\t\u000bM\u0003A\u0011A/\t\u000b}\u0003A\u0011\t1\t\u000b1\u0004A\u0011I7\t\u000bU\u0004A\u0011\t<\t\u000bi\u0004A\u0011I>\t\u0015\u0005\u0015\u0001\u0001#b\u0001\n\u0013\t9\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005-\u0002\u0001\"\u0015\u0002.!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003\"CA/\u0001\u0005\u0005I\u0011AA0\u0011%\t9\u0007AI\u0001\n\u0003\tI\u0007C\u0005\u0002\u0000\u0001\t\n\u0011\"\u0001\u0002j!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000bC\u0011\"!&\u0001\u0003\u0003%\t!a&\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0006\"CAT\u0001\u0005\u0005I\u0011IAU\u0011%\t9\fAA\u0001\n\u0003\tI\fC\u0005\u0002D\u0002\t\t\u0011\"\u0011\u0002F\u001eI\u00111\u001d\u0013\u0002\u0002#\u0005\u0011Q\u001d\u0004\tG\u0011\n\t\u0011#\u0001\u0002h\"11+\bC\u0001\u0003kD\u0011\"a>\u001e\u0003\u0003%)%!?\t\u0013\u0005mX$!A\u0005\u0002\u0006u\b\"\u0003B\u0003;\u0005\u0005I\u0011\u0011B\u0004\u0011%\u0011I\"HA\u0001\n\u0013\u0011YBA\u0006TiJLgn\u001a+p\u001b\u0006\u0004(BA\u0013'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dB\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0011d'\u000f!G!\t\u0019D'D\u0001%\u0013\t)DEA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"aM\u001c\n\u0005a\"#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011!(\u0010\b\u0003gmJ!\u0001\u0010\u0013\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\taD\u0005\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005;\u0015B\u0001%C\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011!X\r\u001f;\u0016\u0003-\u0003\"a\r'\n\u00055##AC#yaJ,7o]5p]\u0006)A/\u001a=uA\u0005I\u0001/Y5s\t\u0016d\u0017.\\\u0001\u000ba\u0006L'\u000fR3mS6\u0004\u0013!D6fsZ\u000bG.^3EK2LW.\u0001\blKf4\u0016\r\\;f\t\u0016d\u0017.\u001c\u0011\u0002\rqJg.\u001b;?)\u0011)fk\u0016-\u0011\u0005M\u0002\u0001\"B%\b\u0001\u0004Y\u0005\"B(\b\u0001\u0004Y\u0005\"B)\b\u0001\u0004YEcA+[9\")1\f\u0003a\u0001\u0017\u0006)1\r[5mI\")q\n\u0003a\u0001\u0017R\u0011QK\u0018\u0005\u00067&\u0001\raS\u0001\tG\"LG\u000e\u001a:f]V\t\u0011\rE\u0002cS.s!a\u00195\u000f\u0005\u0011<W\"A3\u000b\u0005\u0019\u0004\u0014A\u0002\u001fs_>$h(C\u0001D\u0013\ta$)\u0003\u0002kW\n\u00191+Z9\u000b\u0005q\u0012\u0015AC5oaV$H+\u001f9fgV\ta\u000eE\u0002cS>\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0015\u0002\u000bQL\b/Z:\n\u0005Q\f(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A<\u0011\u0005AD\u0018BA=r\u0005!!\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh%\u0001\u0005b]\u0006d\u0017p]5t\u0013\r\t\u0019A \u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006QQ.\u00199Ck&dG-\u001a:\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=a%\u0001\u0003vi&d\u0017\u0002BA\n\u0003\u001b\u0011A#\u0011:sCf\u0014\u0015m]3e\u001b\u0006\u0004()^5mI\u0016\u0014\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\r\u0003?\t\u0019#a\n\u0011\u0007\u0005\u000bY\"C\u0002\u0002\u001e\t\u00131!\u00118z\u0011\u001d\t\tc\u0004a\u0001\u00033\t1\"\u001b8qkR\u001cFO]5oO\"9\u0011QE\bA\u0002\u0005e\u0011aD:ue&tw\rR3mS6LG/\u001a:\t\u000f\u0005%r\u00021\u0001\u0002\u001a\u0005\t2.Z=WC2,X\rR3mS6LG/\u001a:\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0018\u0003w\t)\u0005\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004J\u0001\bG>$WmZ3o\u0013\u0011\tI$a\r\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0010\u0011\u0001\u0004\ty$A\u0002dib\u0004B!!\r\u0002B%!\u00111IA\u001a\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0012\u0011\u0001\u0004\ty#\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u00055\u0003\u0003BA(\u0003/rA!!\u0015\u0002TA\u0011AMQ\u0005\u0004\u0003+\u0012\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002Z\u0005m#AB*ue&twMC\u0002\u0002V\t\u000bAaY8qsR9Q+!\u0019\u0002d\u0005\u0015\u0004bB%\u0013!\u0003\u0005\ra\u0013\u0005\b\u001fJ\u0001\n\u00111\u0001L\u0011\u001d\t&\u0003%AA\u0002-\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002l)\u001a1*!\u001c,\u0005\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001fC\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\n\u0019HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\t\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\t1\fgn\u001a\u0006\u0003\u0003#\u000bAA[1wC&!\u0011\u0011LAF\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\nE\u0002B\u00037K1!!(C\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI\"a)\t\u0013\u0005\u0015\u0006$!AA\u0002\u0005e\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002,B1\u0011QVAZ\u00033i!!a,\u000b\u0007\u0005E&)\u0001\u0006d_2dWm\u0019;j_:LA!!.\u00020\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY,!1\u0011\u0007\u0005\u000bi,C\u0002\u0002@\n\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002&j\t\t\u00111\u0001\u0002\u001a\u00051Q-];bYN$B!a/\u0002H\"I\u0011QU\u000e\u0002\u0002\u0003\u0007\u0011\u0011\u0004\u0015\u0010\u0001\u0005-\u0017\u0011[Aj\u0003/\fI.!8\u0002`B\u00191'!4\n\u0007\u0005=GEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0017Aa\u0006`\rVs5i\u0018\u0015uKb$8\f\f\u0011qC&\u0014H)\u001a7j[nc\u0003e[3z-\u0006dW/\u001a#fY&lW,X\u0015![\u0001\u001a%/Z1uKN\u0004\u0013\rI7ba\u0002\ng\r^3sAM\u0004H.\u001b;uS:<\u0007\u0005\u001e5fAQ,\u0007\u0010\u001e\u0011j]R|\u0007e[3z_Y\fG.^3!a\u0006L'o\u001d\u0011vg&tw\r\t3fY&l\u0017\u000e^3sg:\u0002C)\u001a4bk2$\b\u0005Z3mS6LG/\u001a:tA\u0005\u0014X\rI\u0014-O\u00012wN\u001d\u0011aa\u0006L'\u000fR3mS6\u0004\u0007%\u00198eA\u001dRt\u0005\t4pe\u0002\u00027.Z=WC2,X\rR3mS6\u0004g\u0006\t\"pi\"\u0004\u0003\r]1je\u0012+G.[7aA\u0005tG\r\t1lKf4\u0016\r\\;f\t\u0016d\u0017.\u001c1!CJ,\u0007\u0005\u001e:fCR,G\rI1tAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\\:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAn\u0003\u0005\u0005\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014buEb#M\u000f\u001a-Gj\u001at\u0005\f\u0011(Y\u001db\u0003e\n\u001e(SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#u\t\n$\u0005\f\u0012cEi\u0012#G\t\u0017#G\nR$e\r\u0012~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001eok2dWP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\t/A\u00033]Ar\u0013'A\u0006TiJLgn\u001a+p\u001b\u0006\u0004\bCA\u001a\u001e'\u0011i\u0012\u0011\u001e$\u0011\u0011\u0005-\u0018\u0011_&L\u0017Vk!!!<\u000b\u0007\u0005=()A\u0004sk:$\u0018.\\3\n\t\u0005M\u0018Q\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAs\u0003!!xn\u0015;sS:<GCAAD\u0003\u0015\t\u0007\u000f\u001d7z)\u001d)\u0016q B\u0001\u0005\u0007AQ!\u0013\u0011A\u0002-CQa\u0014\u0011A\u0002-CQ!\u0015\u0011A\u0002-\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\n\tU\u0001#B!\u0003\f\t=\u0011b\u0001B\u0007\u0005\n1q\n\u001d;j_:\u0004b!\u0011B\t\u0017.[\u0015b\u0001B\n\u0005\n1A+\u001e9mKNB\u0001Ba\u0006\"\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\b\u0011\t\u0005%%qD\u0005\u0005\u0005C\tYI\u0001\u0004PE*,7\r\u001e")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$28))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(text, pd, kvd) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.text();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$28) {
        return !x$28.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

