/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timeExp[, fmt]) - Returns the UNIX timestamp of the given time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string which is returned as a UNIX timestamp.\n      * fmt - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n              Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460098800\n  ", group="datetime_funcs", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0014(\u0001RB\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011!Q\u0005A!f\u0001\n\u0003Y\u0005\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u0011m\u0003!Q3A\u0005\u0002qC\u0001\u0002\u0019\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\u0006C\u0002!\t\u0001\u001b\u0005\u0006W\u0002!\te\u0011\u0005\u0006Y\u0002!\te\u0011\u0005\u0006[\u0002!\tE\u001c\u0005\u0006C\u0002!\ta\u001d\u0005\u0006m\u0002!\te\u001e\u0005\bq\u0002\t\t\u0011\"\u0001z\u0011\u001dq\b!%A\u0005\u0002}D\u0001\"!\u0006\u0001#\u0003%\ta \u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033A\u0011\"!\b\u0001#\u0003%\t!a\b\t\u0013\u0005\r\u0002!!A\u0005B\u0005\u0015\u0002\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0011%\ty\u0004AA\u0001\n\u0003\t\t\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003G\u0002\u0011\u0011!C!\u0003K:\u0011\"a$(\u0003\u0003E\t!!%\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0003'Ca!\u0019\u000f\u0005\u0002\u0005\u0005\u0006\"CAR9\u0005\u0005IQIAS\u0011%\t9\u000bHA\u0001\n\u0003\u000bI\u000bC\u0005\u00024r\t\n\u0011\"\u0001\u0002\u001a!I\u0011Q\u0017\u000f\u0012\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003oc\u0012\u0011!CA\u0003sC\u0011\"a2\u001d#\u0003%\t!!\u0007\t\u0013\u0005%G$%A\u0005\u0002\u0005}\u0001\"CAf9\u0005\u0005I\u0011BAg\u0005=!v.\u00168jqRKW.Z:uC6\u0004(B\u0001\u0015*\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005)Z\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00051j\u0013aA:rY*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001)\u0014h\u0010\t\u0003m]j\u0011aJ\u0005\u0003q\u001d\u0012\u0001\"\u00168jqRKW.\u001a\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b!J|G-^2u!\tQ\u0004)\u0003\u0002Bw\ta1+\u001a:jC2L'0\u00192mK\u00069A/[7f\u000bb\u0004X#\u0001#\u0011\u0005Y*\u0015B\u0001$(\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\ti&lW-\u0012=qA\u00051am\u001c:nCR\fqAZ8s[\u0006$\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u0014\t\u0004u5{\u0015B\u0001(<\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001k\u0016\b\u0003#V\u0003\"AU\u001e\u000e\u0003MS!\u0001V\u001a\u0002\rq\u0012xn\u001c;?\u0013\t16(\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,<\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002;B\u0011!HX\u0005\u0003?n\u0012qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0006G\u0012,gm\u001a\t\u0003m\u0001AQAQ\u0005A\u0002\u0011CQ\u0001S\u0005A\u0002\u0011CqAS\u0005\u0011\u0002\u0003\u0007A\nC\u0004\\\u0013A\u0005\t\u0019A/\u0015\u0007\rL'\u000eC\u0003C\u0015\u0001\u0007A\tC\u0003I\u0015\u0001\u0007A)\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001D<ji\"$\u0016.\\3[_:,GCA8s!\t1\u0004/\u0003\u0002rO\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006\u00156\u0001\ra\u0014\u000b\u0003GRDQ!\u001e\bA\u0002\u0011\u000bA\u0001^5nK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003=\u000bAaY8qsR)1M_>}{\"9!\t\u0005I\u0001\u0002\u0004!\u0005b\u0002%\u0011!\u0003\u0005\r\u0001\u0012\u0005\b\u0015B\u0001\n\u00111\u0001M\u0011\u001dY\u0006\u0003%AA\u0002u\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0002)\u001aA)a\u0001,\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0004<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\tIAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m!f\u0001'\u0002\u0004\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA\u0011U\ri\u00161A\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005Y\u0006twM\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\rA\u00161F\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003s\u00012AOA\u001e\u0013\r\tid\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0007\nI\u0005E\u0002;\u0003\u000bJ1!a\u0012<\u0005\r\te.\u001f\u0005\n\u0003\u0017:\u0012\u0011!a\u0001\u0003s\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA)!\u0019\t\u0019&!\u0017\u0002D5\u0011\u0011Q\u000b\u0006\u0004\u0003/Z\u0014AC2pY2,7\r^5p]&!\u00111LA+\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007u\u000b\t\u0007C\u0005\u0002Le\t\t\u00111\u0001\u0002D\u00051Q-];bYN$2!XA4\u0011%\tYEGA\u0001\u0002\u0004\t\u0019\u0005K\f\u0001\u0003W\n\t(a\u001d\u0002x\u0005e\u0014QPA@\u0003\u0007\u000b))!#\u0002\fB\u0019a'!\u001c\n\u0007\u0005=tEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0014AR0G+:\u001bu\f\u000b;j[\u0016,\u0005\u0010].-A\u0019lG/X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!+:K\u0005\f\t;j[\u0016\u001cH/Y7qA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!i&lWML\u0001\nCJ<W/\\3oiN\f#!a\u001f\u0002\u0007KQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016,\u0005\u0010\u001d\u0011.A\u0005\u0003C-\u0019;f_QLW.Z:uC6\u0004\be\u001c:!gR\u0014\u0018N\\4!o\"L7\r\u001b\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%Y:!C\u0002*f*\u0013-!i&lWm\u001d;b[Bt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I%h]>\u0014X\r\u001a\u0011jM\u0002\u0002G/[7f\u000bb\u0004\b\rI5tA9|G\u000fI1!gR\u0014\u0018N\\4/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0011+g-Y;mi\u00022\u0018\r\\;fA%\u001c\bEI=zsflS*T\u0017eI\u0002B\u0005JO7nuM\u001c(E\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8sAY\fG.\u001b3!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011Q\u0001W\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[A\"T\u0006\r\u001d(Y\u0001:\u00130_=z[5kU\u0006\u001a3(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\u000e\u001c1aeB\u0004\b\r\u0019\u000bA\u0001\nQa\u001a:pkB\f#!a\"\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011QR\u0001\u0006c92d\u0006M\u0001\u0010)>,f.\u001b=US6,7\u000f^1naB\u0011a\u0007H\n\u00059\u0005Uu\bE\u0005\u0002\u0018\u0006uE\t\u0012'^G6\u0011\u0011\u0011\u0014\u0006\u0004\u00037[\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003?\u000bIJA\tBEN$(/Y2u\rVt7\r^5p]R\"\"!!%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\n\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013\r\fY+!,\u00020\u0006E\u0006\"\u0002\" \u0001\u0004!\u0005\"\u0002% \u0001\u0004!\u0005b\u0002& !\u0003\u0005\r\u0001\u0014\u0005\b7~\u0001\n\u00111\u0001^\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u00111XAb!\u0011QT*!0\u0011\u000fi\ny\f\u0012#M;&\u0019\u0011\u0011Y\u001e\u0003\rQ+\b\u000f\\35\u0011!\t)MIA\u0001\u0002\u0004\u0019\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a4\u0011\t\u0005%\u0012\u0011[\u0005\u0005\u0003'\fYC\u0001\u0004PE*,7\r\u001e")
public class ToUnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(ToUnixTimestamp toUnixTimestamp) {
        return ToUnixTimestamp$.MODULE$.unapply(toUnixTimestamp);
    }

    public static boolean apply$default$4() {
        return ToUnixTimestamp$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return ToUnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, ToUnixTimestamp> tupled() {
        return ToUnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, ToUnixTimestamp>>>> curried() {
        return ToUnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public String prettyName() {
        return "to_unix_timestamp";
    }

    public ToUnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        return new ToUnixTimestamp(timeExp, format, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ToUnixTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeExp();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = toUnixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = toUnixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = toUnixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != toUnixTimestamp.failOnError()) return false;
        if (!toUnixTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public ToUnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

