/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Serializable;

public final class ArrayData$
implements Serializable {
    public static ArrayData$ MODULE$;

    static {
        new ArrayData$();
    }

    public ArrayData toArrayData(Object input) {
        ArrayData arrayData;
        Object object = input;
        if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(blArray);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(byArray);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(sArray);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(nArray);
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(lArray);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(fArray);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            arrayData = UnsafeArrayData.fromPrimitiveArray(dArray);
        } else {
            arrayData = new GenericArrayData(object);
        }
        return arrayData;
    }

    public ArrayData allocateArrayData(int elementSize, long numElements, String additionalErrorMessage) {
        ArrayData arrayData;
        if (elementSize >= 0 && !UnsafeArrayData.shouldUseGenericArrayData(elementSize, numElements)) {
            arrayData = UnsafeArrayData.createFreshArray((int)numElements, elementSize);
        } else if (numElements <= (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
            arrayData = new GenericArrayData(new Object[(int)numElements]);
        } else {
            throw new RuntimeException(new StringBuilder(95).append("Cannot create array with ").append(numElements).append(" ").append("elements of data due to exceeding the limit ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(" elements for ArrayData. ").append(additionalErrorMessage).toString());
        }
        return arrayData;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ArrayData$() {
        MODULE$ = this;
    }
}

