/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.Semiring;
import cats.kernel.Eq;
import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spire.math.Algebraic$;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.Real$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots;
import spire.math.poly.Roots$;

@ScalaSignature(bytes="\u0006\u0001=3QAC\u0006\u0001\u0017EA\u0001\u0002\u0004\u0001\u0003\u0006\u0004%\t!\t\u0005\tK\u0001\u0011\t\u0011)A\u0005E!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003BB\u001d\u0001A\u0003%A\u0006C\u0004;\u0001\t\u0007I\u0011B\u001e\t\r\u0015\u0003\u0001\u0015!\u0003=\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0001M\u000591\u0015\u000e_3e%\u0016\fGNU8piNT!\u0001D\u0007\u0002\tA|G.\u001f\u0006\u0003\u001d=\tA!\\1uQ*\t\u0001#A\u0003ta&\u0014XmE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007cA\r\u001b95\t1\"\u0003\u0002\u001c\u0017\t)!k\\8ugB\u0011QDH\u0007\u0002\u001b%\u0011q$\u0004\u0002\u0005%\u0016\fGn\u0001\u0001\u0016\u0003\t\u00022!H\u0012\u001d\u0013\t!SB\u0001\u0006Q_2Lhn\\7jC2\fQ\u0001]8ms\u0002\na\u0001P5oSRtDC\u0001\u0015*!\tI\u0002\u0001C\u0003\r\u0007\u0001\u0007!%A\u0003{a>d\u00170F\u0001-!\ri2%\f\t\u0003]Yr!a\f\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0005I\u0002\u0013A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t)D#A\u0004qC\u000e\\\u0017mZ3\n\u0005]B$A\u0002\"jO&sGO\u0003\u00026)\u00051!\u0010]8ms\u0002\n\u0001\"[:pY\u0006$X\rZ\u000b\u0002yA\u0019a&P \n\u0005yB$A\u0002,fGR|'\u000fE\u0002\u001e\u0001\nK!!Q\u0007\u0003\u0011%sG/\u001a:wC2\u0004\"!H\"\n\u0005\u0011k!\u0001\u0003*bi&|g.\u00197\u0002\u0013%\u001cx\u000e\\1uK\u0012\u0004\u0013!B2pk:$X#\u0001%\u0011\u0005MI\u0015B\u0001&\u0015\u0005\rIe\u000e^\u0001\u0004O\u0016$HC\u0001\u000fN\u0011\u0015q\u0015\u00021\u0001I\u0003\u0005I\u0007")
public class FixedRealRoots
implements Roots<Real> {
    private final Polynomial<Real> poly;
    private final Polynomial<BigInt> zpoly;
    private final Vector<Interval<Rational>> isolated;

    @Override
    public Iterator<Real> iterator() {
        return Roots.iterator$(this);
    }

    @Override
    public int size() {
        return Roots.size$(this);
    }

    @Override
    public String toString() {
        return Roots.toString$(this);
    }

    public GenericCompanion<Iterable> companion() {
        return Iterable.companion$((Iterable)this);
    }

    public Iterable<Real> seq() {
        return Iterable.seq$((Iterable)this);
    }

    public Iterable<Real> thisCollection() {
        return IterableLike.thisCollection$((IterableLike)this);
    }

    public Iterable toCollection(Object repr) {
        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
    }

    public <U> void foreach(Function1<Real, U> f) {
        IterableLike.foreach$((IterableLike)this, f);
    }

    public boolean forall(Function1<Real, Object> p) {
        return IterableLike.forall$((IterableLike)this, p);
    }

    public boolean exists(Function1<Real, Object> p) {
        return IterableLike.exists$((IterableLike)this, p);
    }

    public Option<Real> find(Function1<Real, Object> p) {
        return IterableLike.find$((IterableLike)this, p);
    }

    public boolean isEmpty() {
        return IterableLike.isEmpty$((IterableLike)this);
    }

    public <B> B foldRight(B z, Function2<Real, B, B> op) {
        return (B)IterableLike.foldRight$((IterableLike)this, z, op);
    }

    public <B> B reduceRight(Function2<Real, B, B> op) {
        return (B)IterableLike.reduceRight$((IterableLike)this, op);
    }

    public Iterable<Real> toIterable() {
        return IterableLike.toIterable$((IterableLike)this);
    }

    public Iterator<Real> toIterator() {
        return IterableLike.toIterator$((IterableLike)this);
    }

    public Object head() {
        return IterableLike.head$((IterableLike)this);
    }

    public Object slice(int from, int until) {
        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
    }

    public Object take(int n) {
        return IterableLike.take$((IterableLike)this, (int)n);
    }

    public Object drop(int n) {
        return IterableLike.drop$((IterableLike)this, (int)n);
    }

    public Object takeWhile(Function1 p) {
        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
    }

    public Iterator<Iterable<Real>> grouped(int size) {
        return IterableLike.grouped$((IterableLike)this, (int)size);
    }

    public Iterator<Iterable<Real>> sliding(int size) {
        return IterableLike.sliding$((IterableLike)this, (int)size);
    }

    public Iterator<Iterable<Real>> sliding(int size, int step) {
        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
    }

    public Object takeRight(int n) {
        return IterableLike.takeRight$((IterableLike)this, (int)n);
    }

    public Object dropRight(int n) {
        return IterableLike.dropRight$((IterableLike)this, (int)n);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
    }

    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<Real>, Tuple2<A1, B>, That> bf) {
        return (That)IterableLike.zip$((IterableLike)this, that, bf);
    }

    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<Real>, Tuple2<A1, B>, That> bf) {
        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
    }

    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<Real>, Tuple2<A1, Object>, That> bf) {
        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
    }

    public <B> boolean sameElements(GenIterable<B> that) {
        return IterableLike.sameElements$((IterableLike)this, that);
    }

    public Stream<Real> toStream() {
        return IterableLike.toStream$((IterableLike)this);
    }

    public boolean canEqual(Object that) {
        return IterableLike.canEqual$((IterableLike)this, (Object)that);
    }

    public IterableView<Real, Iterable<Real>> view() {
        return IterableLike.view$((IterableLike)this);
    }

    public IterableView<Real, Iterable<Real>> view(int from, int until) {
        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
    }

    public Builder<Real, Iterable<Real>> newBuilder() {
        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
    }

    public <B> Builder<B, Iterable<B>> genericBuilder() {
        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
    }

    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Real, Tuple2<A1, A2>> asPair) {
        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
    }

    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Real, Tuple3<A1, A2, A3>> asTriple) {
        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
    }

    public GenTraversable flatten(Function1 asTraversable) {
        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
    }

    public GenTraversable transpose(Function1 asTraversable) {
        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
    }

    public Object repr() {
        return TraversableLike.repr$((TraversableLike)this);
    }

    public final boolean isTraversableAgain() {
        return TraversableLike.isTraversableAgain$((TraversableLike)this);
    }

    public Combiner<Real, ParIterable<Real>> parCombiner() {
        return TraversableLike.parCombiner$((TraversableLike)this);
    }

    public boolean hasDefiniteSize() {
        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
    }

    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
    }

    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
    }

    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
    }

    public <B, That> That map(Function1<Real, B> f, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
    }

    public <B, That> That flatMap(Function1<Real, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
    }

    public Object filterImpl(Function1 p, boolean isFlipped) {
        return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
    }

    public Object filter(Function1 p) {
        return TraversableLike.filter$((TraversableLike)this, (Function1)p);
    }

    public Object filterNot(Function1 p) {
        return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
    }

    public <B, That> That collect(PartialFunction<Real, B> pf, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
    }

    public Tuple2<Iterable<Real>, Iterable<Real>> partition(Function1<Real, Object> p) {
        return TraversableLike.partition$((TraversableLike)this, p);
    }

    public <K> Map<K, Iterable<Real>> groupBy(Function1<Real, K> f) {
        return TraversableLike.groupBy$((TraversableLike)this, f);
    }

    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<Real>, B, That> cbf) {
        return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
    }

    public <B, That> That scanLeft(B z, Function2<B, Real, B> op, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
    }

    public <B, That> That scanRight(B z, Function2<Real, B, B> op, CanBuildFrom<Iterable<Real>, B, That> bf) {
        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
    }

    public Option<Real> headOption() {
        return TraversableLike.headOption$((TraversableLike)this);
    }

    public Object tail() {
        return TraversableLike.tail$((TraversableLike)this);
    }

    public Object last() {
        return TraversableLike.last$((TraversableLike)this);
    }

    public Option<Real> lastOption() {
        return TraversableLike.lastOption$((TraversableLike)this);
    }

    public Object init() {
        return TraversableLike.init$((TraversableLike)this);
    }

    public Object sliceWithKnownDelta(int from, int until, int delta) {
        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
    }

    public Object sliceWithKnownBound(int from, int until) {
        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
    }

    public Object dropWhile(Function1 p) {
        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
    }

    public Tuple2<Iterable<Real>, Iterable<Real>> span(Function1<Real, Object> p) {
        return TraversableLike.span$((TraversableLike)this, p);
    }

    public Tuple2<Iterable<Real>, Iterable<Real>> splitAt(int n) {
        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
    }

    public Iterator<Iterable<Real>> tails() {
        return TraversableLike.tails$((TraversableLike)this);
    }

    public Iterator<Iterable<Real>> inits() {
        return TraversableLike.inits$((TraversableLike)this);
    }

    public Traversable<Real> toTraversable() {
        return TraversableLike.toTraversable$((TraversableLike)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, Real, Col> cbf) {
        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
    }

    public String stringPrefix() {
        return TraversableLike.stringPrefix$((TraversableLike)this);
    }

    public FilterMonadic<Real, Iterable<Real>> withFilter(Function1<Real, Object> p) {
        return TraversableLike.withFilter$((TraversableLike)this, p);
    }

    public Parallel par() {
        return Parallelizable.par$((Parallelizable)this);
    }

    public List<Real> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<Real, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<Real, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, Real, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<Real, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, Real, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, Real, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, Real, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<Real, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, Real, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<Real> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Seq<Real> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<Real> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<Real> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Real, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    @Override
    public Polynomial<Real> poly() {
        return this.poly;
    }

    private Polynomial<BigInt> zpoly() {
        return this.zpoly;
    }

    private Vector<Interval<Rational>> isolated() {
        return this.isolated;
    }

    @Override
    public int count() {
        return this.isolated().size();
    }

    @Override
    public Real get(int i) {
        Real real;
        if (i < 0 || i >= this.count()) {
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        }
        Interval interval = (Interval)this.isolated().apply(i);
        if (interval instanceof Point) {
            Point point = (Point)interval;
            Rational value = (Rational)((Object)point.value());
            real = Real$.MODULE$.apply(value);
        } else if (interval instanceof Bounded) {
            Bounded bounded = (Bounded)interval;
            Rational lb = (Rational)((Object)bounded.lower());
            Rational ub = (Rational)((Object)bounded.upper());
            real = Real$.MODULE$.apply(Algebraic$.MODULE$.unsafeRoot(this.zpoly(), i, lb, ub).toBigDecimal(new MathContext(Real$.MODULE$.digits(), RoundingMode.HALF_EVEN)));
        } else {
            throw new RuntimeException("invalid isolated root interval");
        }
        return real;
    }

    public FixedRealRoots(Polynomial<Real> poly) {
        this.poly = poly;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Parallelizable.$init$((Parallelizable)this);
        TraversableLike.$init$((TraversableLike)this);
        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
        GenTraversable.$init$((GenTraversable)this);
        Traversable.$init$((Traversable)this);
        GenIterable.$init$((GenIterable)this);
        IterableLike.$init$((IterableLike)this);
        Iterable.$init$((Iterable)this);
        Roots.$init$(this);
        this.zpoly = Roots$.MODULE$.removeFractions(poly.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toRational(), Rational$.MODULE$.RationalAlgebra(), Rational$.MODULE$.RationalAlgebra(), ClassTag$.MODULE$.apply(Rational.class), (Semiring<Real>)Real$.MODULE$.algebra(), (Eq<Real>)Real$.MODULE$.algebra()));
        this.isolated = Roots$.MODULE$.isolateRoots(this.zpoly(), RootIsolator$.MODULE$.BigIntRootIsolator());
    }
}

