/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.CleanAccum;
import org.apache.spark.CleanBroadcast;
import org.apache.spark.CleanCheckpoint;
import org.apache.spark.CleanRDD;
import org.apache.spark.CleanShuffle;
import org.apache.spark.CleanSparkListener;
import org.apache.spark.CleanerListener;
import org.apache.spark.CleanupTask;
import org.apache.spark.CleanupTaskWeakReference;
import org.apache.spark.ContextCleaner$;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableRDDCheckpointData$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.shuffle.api.ShuffleDriverComponents;
import org.apache.spark.util.AccumulatorContext$;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tud!B\u00181\u0001A2\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011%\u0003!\u0011!Q\u0001\n)CQA\u0015\u0001\u0005\u0002MCqa\u0016\u0001C\u0002\u0013%\u0001\f\u0003\u0004e\u0001\u0001\u0006I!\u0017\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019y\u0007\u0001)A\u0005O\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bBB>\u0001A\u0003%!\u000fC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005\u0015\u0001\u0001)A\u0005}\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0003\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011q\u0004\u0001C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002$!I\u00111\u0006\u0001C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002$!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\n\u0003c\u0001\u0001\u0019!C\u0005\u0003gA\u0001\"a\u0010\u0001A\u0003&\u00111\u0005\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0016\u0001\t\u0003\t\u0019\u0006C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003$\u0001!I!a\u0015\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqA!\u0016\u0001\t\u0003\u00119\u0006C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h\u001d9!q\u000e\u0019\t\n\tEdAB\u00181\u0011\u0013\u0011\u0019\b\u0003\u0004SW\u0011\u0005!Q\u000f\u0005\n\u0005oZ#\u0019!C\u0005\u0005sB\u0001Ba\u001f,A\u0003%\u00111\u001f\u0002\u000f\u0007>tG/\u001a=u\u00072,\u0017M\\3s\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7c\u0001\u00018{A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0019\u0002\u0011%tG/\u001a:oC2L!AQ \u0003\u000f1{wmZ5oO\u0006\u00111oY\u0002\u0001!\t1u)D\u00011\u0013\tA\u0005G\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\ftQV4g\r\\3Ee&4XM]\"p[B|g.\u001a8ugB\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u0004CBL'BA(1\u0003\u001d\u0019\b.\u001e4gY\u0016L!!\u0015'\u0003/MCWO\u001a4mK\u0012\u0013\u0018N^3s\u0007>l\u0007o\u001c8f]R\u001c\u0018A\u0002\u001fj]&$h\bF\u0002U+Z\u0003\"A\u0012\u0001\t\u000b\r\u001b\u0001\u0019A#\t\u000b%\u001b\u0001\u0019\u0001&\u0002\u001fI,g-\u001a:f]\u000e,')\u001e4gKJ,\u0012!\u0017\t\u00045~\u000bW\"A.\u000b\u0005qk\u0016\u0001B;uS2T\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u0002a7\n\u00191+\u001a;\u0011\u0005\u0019\u0013\u0017BA21\u0005a\u0019E.Z1okB$\u0016m]6XK\u0006\\'+\u001a4fe\u0016t7-Z\u0001\u0011e\u00164WM]3oG\u0016\u0014UO\u001a4fe\u0002\naB]3gKJ,gnY3Rk\u0016,X-F\u0001h!\rAWnN\u0007\u0002S*\u0011!n[\u0001\u0004e\u00164'B\u00017^\u0003\u0011a\u0017M\\4\n\u00059L'A\u0004*fM\u0016\u0014XM\\2f#V,W/Z\u0001\u0010e\u00164WM]3oG\u0016\fV/Z;fA\u0005IA.[:uK:,'o]\u000b\u0002eB\u00191O\u001e=\u000e\u0003QT!!^.\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002xi\n)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007C\u0001$z\u0013\tQ\bGA\bDY\u0016\fg.\u001a:MSN$XM\\3s\u0003)a\u0017n\u001d;f]\u0016\u00148\u000fI\u0001\u000fG2,\u0017M\\5oORC'/Z1e+\u0005q\bcA@\u0002\u00025\t1.C\u0002\u0002\u0004-\u0014a\u0001\u00165sK\u0006$\u0017aD2mK\u0006t\u0017N\\4UQJ,\u0017\r\u001a\u0011\u0002#A,'/[8eS\u000e<5iU3sm&\u001cW-\u0006\u0002\u0002\fA\u00191/!\u0004\n\u0007\u0005=AO\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f!\u0003]3sS>$\u0017nY$D'\u0016\u0014h/[2fA\u0005\u0011\u0002/\u001a:j_\u0012L7mR\"J]R,'O^1m+\t\t9\u0002E\u00029\u00033I1!a\u0007:\u0005\u0011auN\\4\u0002'A,'/[8eS\u000e<5)\u00138uKJ4\u0018\r\u001c\u0011\u0002'\tdwnY6P]\u000ecW-\u00198vaR\u000b7o[:\u0016\u0005\u0005\r\u0002c\u0001\u001d\u0002&%\u0019\u0011qE\u001d\u0003\u000f\t{w\u000e\\3b]\u0006!\"\r\\8dW>s7\t\\3b]V\u0004H+Y:lg\u0002\n!D\u00197pG.|en\u00155vM\u001adWm\u00117fC:,\b\u000fV1tWN\f1D\u00197pG.|en\u00155vM\u001adWm\u00117fC:,\b\u000fV1tWN\u0004\u0013aB:u_B\u0004X\rZ\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005m\u0002c\u0001\u001d\u00028%\u0019\u0011\u0011H\u001d\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{)\u0012\u0011!a\u0001\u0003G\t1\u0001\u001f\u00132\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003f\u0001\f\u0002DA\u0019\u0001(!\u0012\n\u0007\u0005\u001d\u0013H\u0001\u0005w_2\fG/\u001b7f\u00039\tG\u000f^1dQ2K7\u000f^3oKJ$B!!\u000e\u0002N!1\u0011qJ\fA\u0002a\f\u0001\u0002\\5ti\u0016tWM]\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003k\tAa\u001d;pa\u0006)\"/Z4jgR,'O\u0015#E\r>\u00148\t\\3b]V\u0004H\u0003BA\u001b\u00037Bq!!\u0018\u001b\u0001\u0004\ty&A\u0002sI\u0012\u0004D!!\u0019\u0002pA1\u00111MA4\u0003Wj!!!\u001a\u000b\u0007\u0005u\u0003'\u0003\u0003\u0002j\u0005\u0015$a\u0001*E\tB!\u0011QNA8\u0019\u0001!A\"!\u001d\u0002\\\u0005\u0005\t\u0011!B\u0001\u0003g\u00121a\u0018\u00132#\u0011\t)(a\u001f\u0011\u0007a\n9(C\u0002\u0002ze\u0012qAT8uQ&tw\rE\u00029\u0003{J1!a :\u0005\r\te._\u0001\u001ee\u0016<\u0017n\u001d;fe\u0006\u001b7-^7vY\u0006$xN\u001d$pe\u000ecW-\u00198vaR!\u0011QGAC\u0011\u001d\t9i\u0007a\u0001\u0003\u0013\u000b\u0011!\u0019\u0019\u0007\u0003\u0017\u000b9*!(\u0011\u0011\u00055\u0015\u0011SAK\u00037k!!a$\u000b\u0005q\u0003\u0014\u0002BAJ\u0003\u001f\u0013Q\"Q2dk6,H.\u0019;peZ\u0013\u0004\u0003BA7\u0003/#A\"!'\u0002\u0006\u0006\u0005\t\u0011!B\u0001\u0003g\u00121a\u0018\u00133!\u0011\ti'!(\u0005\u0019\u0005}\u0015QQA\u0001\u0002\u0003\u0015\t!a\u001d\u0003\u0007}#3'A\rsK\u001eL7\u000f^3s'\",hM\u001a7f\r>\u00148\t\\3b]V\u0004H\u0003BA\u001b\u0003KCq!a*\u001d\u0001\u0004\tI+A\ttQV4g\r\\3EKB,g\u000eZ3oGf\u0004\u0004\"a+\u00024\u0006e\u0016q\u0018\t\n\r\u00065\u0016\u0011WA\\\u0003{K1!a,1\u0005E\u0019\u0006.\u001e4gY\u0016$U\r]3oI\u0016t7-\u001f\t\u0005\u0003[\n\u0019\f\u0002\u0007\u00026\u0006\u0015\u0016\u0011!A\u0001\u0006\u0003\t\u0019HA\u0002`IQ\u0002B!!\u001c\u0002:\u0012a\u00111XAS\u0003\u0003\u0005\tQ!\u0001\u0002t\t\u0019q\fJ\u001b\u0011\t\u00055\u0014q\u0018\u0003\r\u0003\u0003\f)+!A\u0001\u0002\u000b\u0005\u00111\u000f\u0002\u0004?\u00122\u0014a\u0007:fO&\u001cH/\u001a:Ce>\fGmY1ti\u001a{'o\u00117fC:,\b/\u0006\u0003\u0002H\u0006eG\u0003BA\u001b\u0003\u0013Dq!a3\u001e\u0001\u0004\ti-A\u0005ce>\fGmY1tiB1\u0011qZAj\u0003/l!!!5\u000b\u0007\u0005-\u0007'\u0003\u0003\u0002V\u0006E'!\u0003\"s_\u0006$7-Y:u!\u0011\ti'!7\u0005\u000f\u0005mWD1\u0001\u0002t\t\tA+A\u0012sK\u001eL7\u000f^3s%\u0012#5\t[3dWB|\u0017N\u001c;ECR\fgi\u001c:DY\u0016\fg.\u001e9\u0016\t\u0005\u0005\u0018\u0011 \u000b\u0007\u0003k\t\u0019/a<\t\u000f\u0005uc\u00041\u0001\u0002fB\"\u0011q]Av!\u0019\t\u0019'a\u001a\u0002jB!\u0011QNAv\t1\ti/a9\u0002\u0002\u0003\u0005)\u0011AA:\u0005\ryFe\u000e\u0005\b\u0003ct\u0002\u0019AAz\u0003!\u0001\u0018M]3oi&#\u0007c\u0001\u001d\u0002v&\u0019\u0011q_\u001d\u0003\u0007%sG\u000fB\u0004\u0002\\z\u0011\r!a\u001d\u0002%I,w-[:uKJ4uN]\"mK\u0006tW\u000f\u001d\u000b\u0007\u0003k\tyPa\u0001\t\r\t\u0005q\u00041\u00018\u0003Ay'M[3di\u001a{'o\u00117fC:,\b\u000fC\u0004\u0003\u0006}\u0001\rAa\u0002\u0002\tQ\f7o\u001b\t\u0004\r\n%\u0011b\u0001B\u0006a\tY1\t\\3b]V\u0004H+Y:l\u0003}\u0011XmZ5ti\u0016\u00148\u000b]1sW2K7\u000f^3oKJ4uN]\"mK\u0006tW\u000f\u001d\u000b\u0007\u0003k\u0011\tB!\u0006\t\r\tM\u0001\u00051\u00018\u00035a\u0017n\u001d;f]\u0016\u0014xj\u001e8fe\"9\u0011q\n\u0011A\u0002\t]\u0001\u0003\u0002B\r\u0005?i!Aa\u0007\u000b\u0007\tu\u0001'A\u0005tG\",G-\u001e7fe&!!\u0011\u0005B\u000e\u00055\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0006a1.Z3q\u00072,\u0017M\\5oO\u0006aAm\\\"mK\u0006tW\u000f\u001d*E\tR1\u0011Q\u0007B\u0015\u0005[AqAa\u000b#\u0001\u0004\t\u00190A\u0003sI\u0012LE\rC\u0004\u00030\t\u0002\r!a\t\u0002\u0011\tdwnY6j]\u001e\f\u0001\u0003Z8DY\u0016\fg.\u001e9TQV4g\r\\3\u0015\r\u0005U\"Q\u0007B\u001d\u0011\u001d\u00119d\ta\u0001\u0003g\f\u0011b\u001d5vM\u001adW-\u00133\t\u000f\t=2\u00051\u0001\u0002$\u0005\u0011Bm\\\"mK\u0006tW\u000f\u001d\"s_\u0006$7-Y:u)\u0019\t)Da\u0010\u0003D!9!\u0011\t\u0013A\u0002\u0005]\u0011a\u00032s_\u0006$7-Y:u\u0013\u0012DqAa\f%\u0001\u0004\t\u0019#\u0001\be_\u000ecW-\u00198va\u0006\u001b7-^7\u0015\r\u0005U\"\u0011\nB'\u0011\u001d\u0011Y%\na\u0001\u0003/\tQ!Y2d\u0013\u0012DqAa\f&\u0001\u0004\t\u0019#A\te_\u000ecW-\u00198DQ\u0016\u001c7\u000e]8j]R$B!!\u000e\u0003T!9!1\u0006\u0014A\u0002\u0005M\u0018\u0001\u00063p\u00072,\u0017M\\*qCJ\\G*[:uK:,'\u000f\u0006\u0003\u00026\te\u0003bBA(O\u0001\u0007!qC\u0001\u0011EJ|\u0017\rZ2bgRl\u0015M\\1hKJ,\"Aa\u0018\u0011\t\u0005='\u0011M\u0005\u0005\u0005G\n\tN\u0001\tCe>\fGmY1ti6\u000bg.Y4fe\u00061R.\u00199PkR\u0004X\u000f\u001e+sC\u000e\\WM]'bgR,'/\u0006\u0002\u0003jA\u0019aIa\u001b\n\u0007\t5\u0004G\u0001\fNCB|U\u000f\u001e9viR\u0013\u0018mY6fe6\u000b7\u000f^3s\u00039\u0019uN\u001c;fqR\u001cE.Z1oKJ\u0004\"AR\u0016\u0014\u0005-:DC\u0001B9\u0003Y\u0011VIR0R+\u0016+Vi\u0018)P\u00192{F+S'F\u001fV#VCAAz\u0003]\u0011VIR0R+\u0016+Vi\u0018)P\u00192{F+S'F\u001fV#\u0006\u0005")
public class ContextCleaner
implements Logging {
    private final SparkContext sc;
    private final ShuffleDriverComponents shuffleDriverComponents;
    private final Set<CleanupTaskWeakReference> referenceBuffer;
    private final ReferenceQueue<Object> referenceQueue;
    private final ConcurrentLinkedQueue<CleanerListener> listeners;
    private final Thread cleaningThread;
    private final ScheduledExecutorService periodicGCService;
    private final long periodicGCInterval;
    private final boolean blockOnCleanupTasks;
    private final boolean blockOnShuffleCleanupTasks;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Set<CleanupTaskWeakReference> referenceBuffer() {
        return this.referenceBuffer;
    }

    private ReferenceQueue<Object> referenceQueue() {
        return this.referenceQueue;
    }

    private ConcurrentLinkedQueue<CleanerListener> listeners() {
        return this.listeners;
    }

    private Thread cleaningThread() {
        return this.cleaningThread;
    }

    private ScheduledExecutorService periodicGCService() {
        return this.periodicGCService;
    }

    private long periodicGCInterval() {
        return this.periodicGCInterval;
    }

    private boolean blockOnCleanupTasks() {
        return this.blockOnCleanupTasks;
    }

    private boolean blockOnShuffleCleanupTasks() {
        return this.blockOnShuffleCleanupTasks;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public void attachListener(CleanerListener listener) {
        this.listeners().add(listener);
    }

    public void start() {
        this.cleaningThread().setDaemon(true);
        this.cleaningThread().setName("Spark Context Cleaner");
        this.cleaningThread().start();
        this.periodicGCService().scheduleAtFixedRate(() -> System.gc(), this.periodicGCInterval(), this.periodicGCInterval(), TimeUnit.SECONDS);
    }

    public void stop() {
        this.stopped_$eq(true);
        ContextCleaner contextCleaner = this;
        synchronized (contextCleaner) {
            this.cleaningThread().interrupt();
        }
        this.cleaningThread().join();
        this.periodicGCService().shutdown();
    }

    public void registerRDDForCleanup(RDD<?> rdd) {
        this.registerForCleanup(rdd, new CleanRDD(rdd.id()));
    }

    public void registerAccumulatorForCleanup(AccumulatorV2<?, ?> a) {
        this.registerForCleanup(a, new CleanAccum(a.id()));
    }

    public void registerShuffleForCleanup(ShuffleDependency<?, ?, ?> shuffleDependency) {
        this.registerForCleanup(shuffleDependency, new CleanShuffle(shuffleDependency.shuffleId()));
    }

    public <T> void registerBroadcastForCleanup(Broadcast<T> broadcast) {
        this.registerForCleanup(broadcast, new CleanBroadcast(broadcast.id()));
    }

    public <T> void registerRDDCheckpointDataForCleanup(RDD<?> rdd, int parentId) {
        this.registerForCleanup(rdd, new CleanCheckpoint(parentId));
    }

    private void registerForCleanup(Object objectForCleanup, CleanupTask task) {
        this.referenceBuffer().add(new CleanupTaskWeakReference(task, objectForCleanup, this.referenceQueue()));
    }

    public void registerSparkListenerForCleanup(Object listenerOwner, SparkListener listener) {
        this.registerForCleanup(listenerOwner, new CleanSparkListener(listener));
    }

    public void org$apache$spark$ContextCleaner$$keepCleaning() {
        Utils$.MODULE$.tryOrStopSparkContext(this.sc, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (!this.stopped()) {
                try {
                    Option reference = Option$.MODULE$.apply(this.referenceQueue().remove(ContextCleaner$.MODULE$.org$apache$spark$ContextCleaner$$REF_QUEUE_POLL_TIMEOUT())).map((Function1 & Serializable & scala.Serializable)x$1 -> (CleanupTaskWeakReference)x$1);
                    ContextCleaner contextCleaner = this;
                    synchronized (contextCleaner) {
                        reference.foreach((Function1 & Serializable & scala.Serializable)ref -> {
                            ContextCleaner.$anonfun$keepCleaning$3(this, ref);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InterruptedException && this.stopped()) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable2 instanceof Exception) {
                        Exception exception = (Exception)throwable2;
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in cleaning thread", exception);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw throwable;
                }
            }
        });
    }

    public void doCleanupRDD(int rddId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Cleaning RDD ").append(rddId).toString());
            this.sc.unpersistRDD(rddId, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.rddCleaned(rddId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Cleaned RDD ").append(rddId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Error cleaning RDD ").append(rddId).toString(), e);
        }
    }

    public void doCleanupShuffle(int shuffleId, boolean blocking) {
        block3: {
            try {
                if (this.mapOutputTrackerMaster().containsShuffle(shuffleId)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Cleaning shuffle ").append(shuffleId).toString());
                    this.mapOutputTrackerMaster().unregisterShuffle(shuffleId);
                    this.shuffleDriverComponents.removeShuffle(shuffleId, blocking);
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                        x$3.shuffleCleaned(shuffleId);
                        return BoxedUnit.UNIT;
                    });
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Cleaned shuffle ").append(shuffleId).toString());
                    break block3;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cleanup non-existent shuffle (maybe it was already removed)");
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error cleaning shuffle ").append(shuffleId).toString(), e);
            }
        }
    }

    public void doCleanupBroadcast(long broadcastId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Cleaning broadcast ").append(broadcastId).toString());
            this.broadcastManager().unbroadcast(broadcastId, true, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.broadcastCleaned(broadcastId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Cleaned broadcast ").append(broadcastId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Error cleaning broadcast ").append(broadcastId).toString(), e);
        }
    }

    public void doCleanupAccum(long accId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Cleaning accumulator ").append(accId).toString());
            AccumulatorContext$.MODULE$.remove(accId);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.accumCleaned(accId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Cleaned accumulator ").append(accId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error cleaning accumulator ").append(accId).toString(), e);
        }
    }

    public void doCleanCheckpoint(int rddId) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cleaning rdd checkpoint data ").append(rddId).toString());
            ReliableRDDCheckpointData$.MODULE$.cleanCheckpoint(this.sc, rddId);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.checkpointCleaned(rddId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Cleaned rdd checkpoint data ").append(rddId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error cleaning rdd checkpoint data ").append(rddId).toString(), e);
        }
    }

    public void doCleanSparkListener(SparkListener listener) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Cleaning Spark listener ").append(listener).toString());
            this.sc.listenerBus().removeListener(listener);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Cleaned Spark listener ").append(listener).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error cleaning Spark listener ").append(listener).toString(), e);
        }
    }

    private BroadcastManager broadcastManager() {
        return this.sc.env().broadcastManager();
    }

    private MapOutputTrackerMaster mapOutputTrackerMaster() {
        return (MapOutputTrackerMaster)this.sc.env().mapOutputTracker();
    }

    public static final /* synthetic */ void $anonfun$keepCleaning$3(ContextCleaner $this, CleanupTaskWeakReference ref) {
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Got cleaning task ").append(ref.task()).toString());
        $this.referenceBuffer().remove(ref);
        CleanupTask cleanupTask = ref.task();
        if (cleanupTask instanceof CleanRDD) {
            CleanRDD cleanRDD = (CleanRDD)cleanupTask;
            int rddId = cleanRDD.rddId();
            $this.doCleanupRDD(rddId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanShuffle) {
            CleanShuffle cleanShuffle = (CleanShuffle)cleanupTask;
            int shuffleId = cleanShuffle.shuffleId();
            $this.doCleanupShuffle(shuffleId, $this.blockOnShuffleCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanBroadcast) {
            CleanBroadcast cleanBroadcast = (CleanBroadcast)cleanupTask;
            long broadcastId = cleanBroadcast.broadcastId();
            $this.doCleanupBroadcast(broadcastId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanAccum) {
            CleanAccum cleanAccum = (CleanAccum)cleanupTask;
            long accId = cleanAccum.accId();
            $this.doCleanupAccum(accId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanCheckpoint) {
            CleanCheckpoint cleanCheckpoint = (CleanCheckpoint)cleanupTask;
            int rddId = cleanCheckpoint.rddId();
            $this.doCleanCheckpoint(rddId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanSparkListener) {
            CleanSparkListener cleanSparkListener = (CleanSparkListener)cleanupTask;
            SparkListener listener = cleanSparkListener.listener();
            $this.doCleanSparkListener(listener);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)cleanupTask);
        }
    }

    public ContextCleaner(SparkContext sc, ShuffleDriverComponents shuffleDriverComponents) {
        this.sc = sc;
        this.shuffleDriverComponents = shuffleDriverComponents;
        Logging.$init$(this);
        this.referenceBuffer = Collections.newSetFromMap(new ConcurrentHashMap());
        this.referenceQueue = new ReferenceQueue();
        this.listeners = new ConcurrentLinkedQueue();
        this.cleaningThread = new Thread(this){
            private final /* synthetic */ ContextCleaner $outer;

            public void run() {
                this.$outer.org$apache$spark$ContextCleaner$$keepCleaning();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.periodicGCService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("context-cleaner-periodic-gc");
        this.periodicGCInterval = BoxesRunTime.unboxToLong((Object)sc.conf().get(package$.MODULE$.CLEANER_PERIODIC_GC_INTERVAL()));
        this.blockOnCleanupTasks = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.CLEANER_REFERENCE_TRACKING_BLOCKING()));
        this.blockOnShuffleCleanupTasks = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.CLEANER_REFERENCE_TRACKING_BLOCKING_SHUFFLE()));
        this.stopped = false;
    }
}

