/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.concurrent.CompletableFuture;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.shuffle.BlockStoreClient;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0003\u0006\u0001\u0019IA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00035\u0001\u0011\u0005Q\u0007C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\t\r]\u0003\u0001\u0015!\u0003>\u0011\u0019A\u0006\u0001\"\u0001\r3\"1Q\f\u0001C\u0001\u0019y\u00131\u0003S8ti2{7-\u00197ESJl\u0015M\\1hKJT!a\u0003\u0007\u0002\u000fM$xN]1hK*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xmE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\r\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001e\faCZ;ukJ,W\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0002\u0001!\t\u0011S%D\u0001$\u0015\t!S#\u0001\u0006d_:\u001cWO\u001d:f]RL!AJ\u0012\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!C2bG\",7+\u001b>f!\t!\u0012&\u0003\u0002++\t\u0019\u0011J\u001c;\u0002!\tdwnY6Ti>\u0014Xm\u00117jK:$\bCA\u00173\u001b\u0005q#BA\u00181\u0003\u001d\u0019\b.\u001e4gY\u0016T!!\r\u0007\u0002\u000f9,Go^8sW&\u00111G\f\u0002\u0011\u00052|7m[*u_J,7\t\\5f]R\fa\u0001P5oSRtD\u0003\u0002\u001c9si\u0002\"a\u000e\u0001\u000e\u0003)AQa\b\u0003A\u0002\u0005BQa\n\u0003A\u0002!BQa\u000b\u0003A\u00021\n!$\u001a=fGV$xN]%e)>dunY1m\t&\u00148oQ1dQ\u0016,\u0012!\u0010\t\u0005}\u001dKE+D\u0001@\u0015\t\u0001\u0015)A\u0003dC\u000eDWM\u0003\u0002C\u0007\u000611m\\7n_:T!\u0001R#\u0002\r\u001d|wn\u001a7f\u0015\u00051\u0015aA2p[&\u0011\u0001j\u0010\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003\u0015Fs!aS(\u0011\u00051+R\"A'\u000b\u00059\u0003\u0013A\u0002\u001fs_>$h(\u0003\u0002Q+\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001V\u0003E\u0002\u0015+&K!AV\u000b\u0003\u000b\u0005\u0013(/Y=\u00027\u0015DXmY;u_JLE\rV8M_\u000e\fG\u000eR5sg\u000e\u000b7\r[3!\u0003Y9W\r^\"bG\",G\rS8ti2{7-\u00197ESJ\u001cX#\u0001.\u0011\t)[\u0016\nV\u0005\u00039N\u00131!T1q\u0003A9W\r\u001e%pgRdunY1m\t&\u00148\u000f\u0006\u0003`]B\u0014HC\u00011d!\t!\u0012-\u0003\u0002c+\t!QK\\5u\u0011\u0015!\u0007\u00021\u0001f\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003\u0002\u000bgQ\u0002L!aZ\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA5m56\t!N\u0003\u0002l+\u0005!Q\u000f^5m\u0013\ti'NA\u0002UefDQa\u001c\u0005A\u0002%\u000bA\u0001[8ti\")\u0011\u000f\u0003a\u0001Q\u0005!\u0001o\u001c:u\u0011\u0015\u0019\b\u00021\u0001U\u0003-)\u00070Z2vi>\u0014\u0018\nZ:")
public class HostLocalDirManager
implements Logging {
    private final BlockStoreClient blockStoreClient;
    private final Cache<String, String[]> executorIdToLocalDirsCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Cache<String, String[]> executorIdToLocalDirsCache() {
        return this.executorIdToLocalDirsCache;
    }

    public Map<String, String[]> getCachedHostLocalDirs() {
        Map map;
        Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
        synchronized (cache) {
            map = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executorIdToLocalDirsCache().asMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public void getHostLocalDirs(String host, int port, String[] executorIds, Function1<Try<Map<String, String[]>>, BoxedUnit> callback) {
        CompletableFuture hostLocalDirsCompletable = new CompletableFuture();
        this.blockStoreClient.getHostLocalDirs(host, port, executorIds, hostLocalDirsCompletable);
        hostLocalDirsCompletable.whenComplete((hostLocalDirs, throwable) -> {
            if (hostLocalDirs != null) {
                callback.apply((Object)new Success((Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(hostLocalDirs).asScala()).toMap(Predef$.MODULE$.$conforms())));
                Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
                synchronized (cache) {
                    this.executorIdToLocalDirsCache().putAll(hostLocalDirs);
                }
            } else {
                callback.apply((Object)new Failure(throwable));
            }
        });
    }

    public HostLocalDirManager(ExecutionContext futureExecutionContext, int cacheSize, BlockStoreClient blockStoreClient) {
        this.blockStoreClient = blockStoreClient;
        Logging.$init$(this);
        this.executorIdToLocalDirsCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
    }
}

