/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Silhouette;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class CosineSilhouette$
extends Silhouette {
    public static CosineSilhouette$ MODULE$;
    private final String normalizedFeaturesColName;

    static {
        new CosineSilhouette$();
    }

    public Map<Object, Tuple2<Vector, Object>> computeClusterStats(Dataset<Row> df, String featuresCol, String predictionCol, String weightCol) {
        int numFeatures = MetadataUtils$.MODULE$.getNumFeatures(df, featuresCol);
        RDD clustersStatsRDD = RDD$.MODULE$.rddToPairRDDFunctions(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.normalizedFeaturesColName), functions$.MODULE$.col(weightCol)})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)row.getDouble(0)), (Object)new Tuple2(row.getAs(1), (Object)BoxesRunTime.boxToDouble((double)row.getDouble(2)))), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Double$.MODULE$).aggregateByKey((Object)new Tuple2((Object)Vectors$.MODULE$.zeros(numFeatures).toDense(), (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            double d;
            DenseVector denseVector;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    DenseVector normalizedFeaturesSum = (DenseVector)tuple23._1();
                    double weightSum = tuple23._2$mcD$sp();
                    if (normalizedFeaturesSum == null) break block2;
                    denseVector = normalizedFeaturesSum;
                    d = weightSum;
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Vector normalizedFeatures = (Vector)tuple2._1();
            double weight = tuple2._2$mcD$sp();
            BLAS$.MODULE$.axpy(weight, normalizedFeatures, (Vector)denseVector);
            Tuple2 tuple24 = new Tuple2((Object)denseVector, (Object)BoxesRunTime.boxToDouble((double)(d + weight)));
            return tuple24;
        }, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            double weightSum1;
            DenseVector normalizedFeaturesSum1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    normalizedFeaturesSum1 = (DenseVector)tuple23._1();
                    weightSum1 = tuple23._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            DenseVector normalizedFeaturesSum2 = (DenseVector)tuple2._1();
            double weightSum2 = tuple2._2$mcD$sp();
            BLAS$.MODULE$.axpy(1.0, (Vector)normalizedFeaturesSum2, (Vector)normalizedFeaturesSum1);
            Tuple2 tuple24 = new Tuple2((Object)normalizedFeaturesSum1, (Object)BoxesRunTime.boxToDouble((double)(weightSum1 + weightSum2)));
            return tuple24;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(clustersStatsRDD, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Double$.MODULE$).collectAsMap().toMap(Predef$.MODULE$.$conforms());
    }

    public double computeSilhouetteCoefficient(Broadcast<Map<Object, Tuple2<Vector, Object>>> broadcastedClustersMap, Vector normalizedFeatures, double clusterId, double weight) {
        return this.pointSilhouetteCoefficient((Set<Object>)((scala.collection.immutable.MapLike)broadcastedClustersMap.value()).keySet(), clusterId, ((Tuple2)((MapLike)broadcastedClustersMap.value()).apply((Object)BoxesRunTime.boxToDouble((double)clusterId)))._2$mcD$sp(), weight, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)targetClusterId -> CosineSilhouette$.compute$2(targetClusterId, broadcastedClustersMap, normalizedFeatures));
    }

    public double computeSilhouetteScore(Dataset<?> dataset, String predictionCol, String featuresCol, String weightCol) {
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2() {
            }
        }
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2() {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        UserDefinedFunction normalizeFeatureUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> {
            double norm = Vectors$.MODULE$.norm(features, 2.0);
            BLAS$.MODULE$.scal(1.0 / norm, features);
            return features;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2()));
        Dataset dfWithNormalizedFeatures = dataset.withColumn(this.normalizedFeaturesColName, normalizeFeatureUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})));
        Map<Object, Tuple2<Vector, Object>> clustersStatsMap = this.computeClusterStats((Dataset<Row>)dfWithNormalizedFeatures, featuresCol, predictionCol, weightCol);
        Predef$.MODULE$.assert(clustersStatsMap.size() > 1, (Function0 & Serializable & scala.Serializable)() -> "Number of clusters must be greater than one.");
        Broadcast bClustersStatsMap = dataset.sparkSession().sparkContext().broadcast(clustersStatsMap, ClassTag$.MODULE$.apply(Map.class));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1() {
            }
        }
        UserDefinedFunction computeSilhouetteCoefficientUDF = functions$.MODULE$.udf((Function3 & Serializable & scala.Serializable)(x$7, x$8, x$9) -> BoxesRunTime.boxToDouble((double)CosineSilhouette$.MODULE$.computeSilhouetteCoefficient((Broadcast<Map<Object, Tuple2<Vector, Object>>>)bClustersStatsMap, x$7, BoxesRunTime.unboxToDouble((Object)x$8), BoxesRunTime.unboxToDouble((Object)x$9))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        double silhouetteScore = this.overallScore((Dataset<Row>)dfWithNormalizedFeatures, computeSilhouetteCoefficientUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.normalizedFeaturesColName), functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(weightCol)})), functions$.MODULE$.col(weightCol));
        bClustersStatsMap.destroy();
        return silhouetteScore;
    }

    private static final double compute$2(double targetClusterId, Broadcast broadcastedClustersMap$2, Vector normalizedFeatures$1) {
        Tuple2 tuple2 = (Tuple2)((MapLike)broadcastedClustersMap$2.value()).apply((Object)BoxesRunTime.boxToDouble((double)targetClusterId));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector normalizedFeatureSum = (Vector)tuple2._1();
        double numOfPoints = tuple2._2$mcD$sp();
        Tuple2 tuple22 = new Tuple2((Object)normalizedFeatureSum, (Object)BoxesRunTime.boxToDouble((double)numOfPoints));
        Tuple2 tuple23 = tuple22;
        Vector normalizedFeatureSum2 = (Vector)tuple23._1();
        double numOfPoints2 = tuple23._2$mcD$sp();
        return 1.0 - BLAS$.MODULE$.dot(normalizedFeatures$1, normalizedFeatureSum2) / numOfPoints2;
    }

    private CosineSilhouette$() {
        MODULE$ = this;
        this.normalizedFeaturesColName = "normalizedFeatures";
    }
}

