/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming.clickstream;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.examples.streaming.clickstream.PageView;
import org.apache.spark.examples.streaming.clickstream.PageView$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class PageViewStream$ {
    public static PageViewStream$ MODULE$;

    static {
        new PageViewStream$();
    }

    public void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: PageViewStream <metric> <host> <port>");
            System.err.println("<metric> must be one of pageCounts, slidingPageCounts, errorRatePerZipCode, activeUserCount, popularUsersSeen");
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String metric = args[0];
        String host = args[1];
        int port = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        StreamingContext ssc = new StreamingContext("local[2]", "PageViewStream", Seconds$.MODULE$.apply(1L), System.getenv("SPARK_HOME"), Option$.MODULE$.option2Iterable(StreamingContext$.MODULE$.jarOfClass(this.getClass())).toSeq(), StreamingContext$.MODULE$.$lessinit$greater$default$6());
        DStream pageViews = ssc.socketTextStream(host, port, ssc.socketTextStream$default$3()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split("\n"))), ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable & scala.Serializable)x$2 -> PageView$.MODULE$.fromString((String)x$2), ClassTag$.MODULE$.apply(PageView.class));
        DStream qual$1 = pageViews.map((Function1 & Serializable & scala.Serializable)view -> view.url(), ClassTag$.MODULE$.apply(String.class));
        int x$12 = qual$1.countByValue$default$1();
        DStream pageCounts = qual$1.countByValue(x$12, (Ordering)Ordering.String$.MODULE$);
        DStream qual$2 = pageViews.map((Function1 & Serializable & scala.Serializable)view -> view.url(), ClassTag$.MODULE$.apply(String.class));
        Duration x$22 = Seconds$.MODULE$.apply(10L);
        Duration x$3 = Seconds$.MODULE$.apply(2L);
        int x$42 = qual$2.countByValueAndWindow$default$3();
        DStream slidingPageCounts = qual$2.countByValueAndWindow(x$22, x$3, x$42, (Ordering)Ordering.String$.MODULE$);
        DStream statusesPerZipCode = DStream$.MODULE$.toPairDStreamFunctions(pageViews.window(Seconds$.MODULE$.apply(30L), Seconds$.MODULE$.apply(2L)).map((Function1 & Serializable & scala.Serializable)view -> new Tuple2.mcII.sp(view.zipCode(), view.status()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).groupByKey();
        DStream errorRatePerZipCode = statusesPerZipCode.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int zip = tuple2._1$mcI$sp();
            Iterable statuses = (Iterable)tuple2._2();
            int normalCount = statuses.count((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 == 200);
            int errorCount = statuses.size() - normalCount;
            float errorRatio = (float)errorCount / (float)statuses.size();
            String string = (double)errorRatio > 0.05 ? new StringOps(Predef$.MODULE$.augmentString("%s: **%s**")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zip), BoxesRunTime.boxToFloat((float)errorRatio)})) : new StringOps(Predef$.MODULE$.augmentString("%s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zip), BoxesRunTime.boxToFloat((float)errorRatio)}));
            return string;
        }, ClassTag$.MODULE$.apply(String.class));
        DStream activeUserCount = DStream$.MODULE$.toPairDStreamFunctions(pageViews.window(Seconds$.MODULE$.apply(15L), Seconds$.MODULE$.apply(2L)).map((Function1 & Serializable & scala.Serializable)view -> new Tuple2.mcII.sp(view.userID(), 1), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).groupByKey().count().map((Function1 & Serializable & scala.Serializable)x$4 -> PageViewStream$.$anonfun$main$9(BoxesRunTime.unboxToLong((Object)x$4)), ClassTag$.MODULE$.apply(String.class));
        SparkContext qual$3 = ssc.sparkContext();
        Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"Patrick Wendell"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"Reynold Xin"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"Matei Zaharia")}));
        int x$6 = qual$3.parallelize$default$2();
        RDD userList = qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
        String string = metric;
        if ("pageCounts".equals(string)) {
            pageCounts.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("slidingPageCounts".equals(string)) {
            slidingPageCounts.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("errorRatePerZipCode".equals(string)) {
            errorRatePerZipCode.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("activeUserCount".equals(string)) {
            activeUserCount.print();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("popularUsersSeen".equals(string)) {
            pageViews.map((Function1 & Serializable & scala.Serializable)view -> new Tuple2.mcII.sp(view.userID(), 1), ClassTag$.MODULE$.apply(Tuple2.class)).foreachRDD((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
                PageViewStream$.$anonfun$main$11(userList, rdd, time);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("Invalid metric entered: ").append(metric).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ssc.start();
        ssc.awaitTermination();
    }

    public static final /* synthetic */ String $anonfun$main$9(long x$4) {
        return new StringBuilder(21).append("Unique active users: ").append(x$4).toString();
    }

    public static final /* synthetic */ void $anonfun$main$11(RDD userList$1, RDD rdd, Time time) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(rdd, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).join(userList$1).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)((Tuple2)x$5._2())._2(), ClassTag$.MODULE$.apply(String.class)).take(10))).foreach((Function1 & Serializable & scala.Serializable)u -> {
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("Saw user ").append(u).append(" at time ").append(time).toString());
            return BoxedUnit.UNIT;
        });
    }

    private PageViewStream$() {
        MODULE$ = this;
    }
}

