/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Logging.h"
#include "Globals.h"

#include <fstream>
#include <iostream>
#include <ctime>

using std::ofstream;
using std::cout;
using std::endl;
using std::ctime;

void WriteLog(const std::string& logMsg) {
	#ifndef WIN32
		cout << logMsg << endl;
	#endif
	string concatString = globalSettings.bdp + "galaxyhack-log.txt";
	ofstream output(concatString.c_str(), std::ios::app | std::ios::out);

	time_t theTime = time(0);
	output << ctime(&theTime) << logMsg << endl << endl;
}

void WriteText(const std::string& logMsg, bool toFile) {
	#ifndef WIN32
		cout << logMsg << endl;
	#endif
	if (toFile) {
		string concatString = globalSettings.bdp + "galaxyhack-log.txt";
		ofstream output(concatString.c_str(), std::ios::app | std::ios::out);	
		output << logMsg << endl;
	}
}

