---
title: wezterm.nerdfonts
tags:
 - utility
 - font
 - string
---
# `wezterm.nerdfonts`

{{since('20220319-142410-0fcdea07')}}

A special userdata value that can be used to resolve the symbolic name
of a glyph from the [Nerd Fonts](https://www.nerdfonts.com/cheat-sheet)
font set into a string that can be used for example when formatting
status lines and titles in your wezterm configuration.

WezTerm includes `Nerd Font Symbols Font` as a default font fallback
which means that these special symbols are available even without 
requiring you to use a patched font.

This example shows how to lookup `wezterm.nerdfonts.fa_clock_o`, the Font
Awesome glyph representing a clock, and use that together with the current
date/time in the status area:

```lua
local wezterm = require 'wezterm'

wezterm.on('update-right-status', function(window, pane)
  -- "Wed Mar 3 08:14"
  local date = wezterm.strftime '%a %b %-d %H:%M '

  window:set_right_status(wezterm.format {
    { Text = wezterm.nerdfonts.fa_clock_o .. ' ' .. date },
  })
end)
```

{{since('20230712-072601-f4abf8fd')}}

The bundled `Nerd Font Symbols Font` was updated to version 3.0 which,
unfortunately, makes [breaking
changes](https://github.com/ryanoasis/nerd-fonts/releases/tag/v3.0.0) to a
number of symbol assignments, and renames all of the Material Design Icons so
that they no longer have an `mdi_` prefix and instead have an `md_` prefix.


The following symbols are defined:

<style>
.big {
  font-size: 3em;
}
</style>

<!--
This block generated by:
:r! cd termwiz && cargo run --example gennerdfonts 2>/dev/null
-->
| | |
|-|-|
|<span class="nerdfont big">&#xeb99;</span>|cod_account|
|<span class="nerdfont big">&#xea97;</span>|cod_activate_breakpoints|
|<span class="nerdfont big">&#xea60;</span>|cod_add|
|<span class="nerdfont big">&#xea98;</span>|cod_archive|
|<span class="nerdfont big">&#xea99;</span>|cod_arrow_both|
|<span class="nerdfont big">&#xea9a;</span>|cod_arrow_down|
|<span class="nerdfont big">&#xea9b;</span>|cod_arrow_left|
|<span class="nerdfont big">&#xea9c;</span>|cod_arrow_right|
|<span class="nerdfont big">&#xea9d;</span>|cod_arrow_small_down|
|<span class="nerdfont big">&#xea9e;</span>|cod_arrow_small_left|
|<span class="nerdfont big">&#xea9f;</span>|cod_arrow_small_right|
|<span class="nerdfont big">&#xeaa0;</span>|cod_arrow_small_up|
|<span class="nerdfont big">&#xebcb;</span>|cod_arrow_swap|
|<span class="nerdfont big">&#xeaa1;</span>|cod_arrow_up|
|<span class="nerdfont big">&#xebd8;</span>|cod_azure|
|<span class="nerdfont big">&#xebe8;</span>|cod_azure_devops|
|<span class="nerdfont big">&#xea79;</span>|cod_beaker|
|<span class="nerdfont big">&#xebe1;</span>|cod_beaker_stop|
|<span class="nerdfont big">&#xeaa2;</span>|cod_bell|
|<span class="nerdfont big">&#xeb9a;</span>|cod_bell_dot|
|<span class="nerdfont big">&#xeaa3;</span>|cod_bold|
|<span class="nerdfont big">&#xeaa4;</span>|cod_book|
|<span class="nerdfont big">&#xeaa5;</span>|cod_bookmark|
|<span class="nerdfont big">&#xebe5;</span>|cod_bracket_dot|
|<span class="nerdfont big">&#xebe6;</span>|cod_bracket_error|
|<span class="nerdfont big">&#xeaac;</span>|cod_briefcase|
|<span class="nerdfont big">&#xeaad;</span>|cod_broadcast|
|<span class="nerdfont big">&#xeaae;</span>|cod_browser|
|<span class="nerdfont big">&#xeaaf;</span>|cod_bug|
|<span class="nerdfont big">&#xeab0;</span>|cod_calendar|
|<span class="nerdfont big">&#xeb92;</span>|cod_call_incoming|
|<span class="nerdfont big">&#xeb93;</span>|cod_call_outgoing|
|<span class="nerdfont big">&#xeab1;</span>|cod_case_sensitive|
|<span class="nerdfont big">&#xeab2;</span>|cod_check|
|<span class="nerdfont big">&#xebb1;</span>|cod_check_all|
|<span class="nerdfont big">&#xeab3;</span>|cod_checklist|
|<span class="nerdfont big">&#xeab4;</span>|cod_chevron_down|
|<span class="nerdfont big">&#xeab5;</span>|cod_chevron_left|
|<span class="nerdfont big">&#xeab6;</span>|cod_chevron_right|
|<span class="nerdfont big">&#xeab7;</span>|cod_chevron_up|
|<span class="nerdfont big">&#xeab8;</span>|cod_chrome_close|
|<span class="nerdfont big">&#xeab9;</span>|cod_chrome_maximize|
|<span class="nerdfont big">&#xeaba;</span>|cod_chrome_minimize|
|<span class="nerdfont big">&#xeabb;</span>|cod_chrome_restore|
|<span class="nerdfont big">&#xeabc;</span>|cod_circle|
|<span class="nerdfont big">&#xea71;</span>|cod_circle_filled|
|<span class="nerdfont big">&#xebb5;</span>|cod_circle_large|
|<span class="nerdfont big">&#xebb4;</span>|cod_circle_large_filled|
|<span class="nerdfont big">&#xeabd;</span>|cod_circle_slash|
|<span class="nerdfont big">&#xeb8a;</span>|cod_circle_small_filled|
|<span class="nerdfont big">&#xeabe;</span>|cod_circuit_board|
|<span class="nerdfont big">&#xeabf;</span>|cod_clear_all|
|<span class="nerdfont big">&#xeac0;</span>|cod_clippy|
|<span class="nerdfont big">&#xea76;</span>|cod_close|
|<span class="nerdfont big">&#xeac1;</span>|cod_close_all|
|<span class="nerdfont big">&#xebaa;</span>|cod_cloud|
|<span class="nerdfont big">&#xeac2;</span>|cod_cloud_download|
|<span class="nerdfont big">&#xeac3;</span>|cod_cloud_upload|
|<span class="nerdfont big">&#xeac4;</span>|cod_code|
|<span class="nerdfont big">&#xeac5;</span>|cod_collapse_all|
|<span class="nerdfont big">&#xeac6;</span>|cod_color_mode|
|<span class="nerdfont big">&#xebb6;</span>|cod_combine|
|<span class="nerdfont big">&#xea6b;</span>|cod_comment|
|<span class="nerdfont big">&#xeac7;</span>|cod_comment_discussion|
|<span class="nerdfont big">&#xebd5;</span>|cod_compass|
|<span class="nerdfont big">&#xebd7;</span>|cod_compass_active|
|<span class="nerdfont big">&#xebd6;</span>|cod_compass_dot|
|<span class="nerdfont big">&#xebcc;</span>|cod_copy|
|<span class="nerdfont big">&#xeac9;</span>|cod_credit_card|
|<span class="nerdfont big">&#xeacc;</span>|cod_dash|
|<span class="nerdfont big">&#xeacd;</span>|cod_dashboard|
|<span class="nerdfont big">&#xeace;</span>|cod_database|
|<span class="nerdfont big">&#xead8;</span>|cod_debug|
|<span class="nerdfont big">&#xebdc;</span>|cod_debug_all|
|<span class="nerdfont big">&#xeb91;</span>|cod_debug_alt|
|<span class="nerdfont big">&#xeba8;</span>|cod_debug_alt_small|
|<span class="nerdfont big">&#xeaa7;</span>|cod_debug_breakpoint_conditional|
|<span class="nerdfont big">&#xeaa6;</span>|cod_debug_breakpoint_conditional_unverified|
|<span class="nerdfont big">&#xeaa9;</span>|cod_debug_breakpoint_data|
|<span class="nerdfont big">&#xeaa8;</span>|cod_debug_breakpoint_data_unverified|
|<span class="nerdfont big">&#xeb88;</span>|cod_debug_breakpoint_function|
|<span class="nerdfont big">&#xeb87;</span>|cod_debug_breakpoint_function_unverified|
|<span class="nerdfont big">&#xeaab;</span>|cod_debug_breakpoint_log|
|<span class="nerdfont big">&#xeaaa;</span>|cod_debug_breakpoint_log_unverified|
|<span class="nerdfont big">&#xeb8c;</span>|cod_debug_breakpoint_unsupported|
|<span class="nerdfont big">&#xeb9b;</span>|cod_debug_console|
|<span class="nerdfont big">&#xeacf;</span>|cod_debug_continue|
|<span class="nerdfont big">&#xebe0;</span>|cod_debug_continue_small|
|<span class="nerdfont big">&#xebdd;</span>|cod_debug_coverage|
|<span class="nerdfont big">&#xead0;</span>|cod_debug_disconnect|
|<span class="nerdfont big">&#xebd0;</span>|cod_debug_line_by_line|
|<span class="nerdfont big">&#xead1;</span>|cod_debug_pause|
|<span class="nerdfont big">&#xebc0;</span>|cod_debug_rerun|
|<span class="nerdfont big">&#xead2;</span>|cod_debug_restart|
|<span class="nerdfont big">&#xeb90;</span>|cod_debug_restart_frame|
|<span class="nerdfont big">&#xeb8e;</span>|cod_debug_reverse_continue|
|<span class="nerdfont big">&#xeb8b;</span>|cod_debug_stackframe|
|<span class="nerdfont big">&#xeb89;</span>|cod_debug_stackframe_active|
|<span class="nerdfont big">&#xead3;</span>|cod_debug_start|
|<span class="nerdfont big">&#xeb8f;</span>|cod_debug_step_back|
|<span class="nerdfont big">&#xead4;</span>|cod_debug_step_into|
|<span class="nerdfont big">&#xead5;</span>|cod_debug_step_out|
|<span class="nerdfont big">&#xead6;</span>|cod_debug_step_over|
|<span class="nerdfont big">&#xead7;</span>|cod_debug_stop|
|<span class="nerdfont big">&#xea78;</span>|cod_desktop_download|
|<span class="nerdfont big">&#xeada;</span>|cod_device_camera|
|<span class="nerdfont big">&#xead9;</span>|cod_device_camera_video|
|<span class="nerdfont big">&#xeadb;</span>|cod_device_mobile|
|<span class="nerdfont big">&#xeae1;</span>|cod_diff|
|<span class="nerdfont big">&#xeadc;</span>|cod_diff_added|
|<span class="nerdfont big">&#xeadd;</span>|cod_diff_ignored|
|<span class="nerdfont big">&#xeade;</span>|cod_diff_modified|
|<span class="nerdfont big">&#xeadf;</span>|cod_diff_removed|
|<span class="nerdfont big">&#xeae0;</span>|cod_diff_renamed|
|<span class="nerdfont big">&#xeae2;</span>|cod_discard|
|<span class="nerdfont big">&#xea73;</span>|cod_edit|
|<span class="nerdfont big">&#xeae3;</span>|cod_editor_layout|
|<span class="nerdfont big">&#xea7c;</span>|cod_ellipsis|
|<span class="nerdfont big">&#xeae4;</span>|cod_empty_window|
|<span class="nerdfont big">&#xea87;</span>|cod_error|
|<span class="nerdfont big">&#xeae5;</span>|cod_exclude|
|<span class="nerdfont big">&#xeb95;</span>|cod_expand_all|
|<span class="nerdfont big">&#xebac;</span>|cod_export|
|<span class="nerdfont big">&#xeae6;</span>|cod_extensions|
|<span class="nerdfont big">&#xea70;</span>|cod_eye|
|<span class="nerdfont big">&#xeae7;</span>|cod_eye_closed|
|<span class="nerdfont big">&#xeb96;</span>|cod_feedback|
|<span class="nerdfont big">&#xea7b;</span>|cod_file|
|<span class="nerdfont big">&#xeae8;</span>|cod_file_binary|
|<span class="nerdfont big">&#xeae9;</span>|cod_file_code|
|<span class="nerdfont big">&#xeaea;</span>|cod_file_media|
|<span class="nerdfont big">&#xeaeb;</span>|cod_file_pdf|
|<span class="nerdfont big">&#xeaec;</span>|cod_file_submodule|
|<span class="nerdfont big">&#xeaed;</span>|cod_file_symlink_directory|
|<span class="nerdfont big">&#xeaee;</span>|cod_file_symlink_file|
|<span class="nerdfont big">&#xeaef;</span>|cod_file_zip|
|<span class="nerdfont big">&#xeaf0;</span>|cod_files|
|<span class="nerdfont big">&#xeaf1;</span>|cod_filter|
|<span class="nerdfont big">&#xebce;</span>|cod_filter_filled|
|<span class="nerdfont big">&#xeaf2;</span>|cod_flame|
|<span class="nerdfont big">&#xeaf5;</span>|cod_fold|
|<span class="nerdfont big">&#xeaf3;</span>|cod_fold_down|
|<span class="nerdfont big">&#xeaf4;</span>|cod_fold_up|
|<span class="nerdfont big">&#xea83;</span>|cod_folder|
|<span class="nerdfont big">&#xeaf6;</span>|cod_folder_active|
|<span class="nerdfont big">&#xebdf;</span>|cod_folder_library|
|<span class="nerdfont big">&#xeaf7;</span>|cod_folder_opened|
|<span class="nerdfont big">&#xeaf8;</span>|cod_gear|
|<span class="nerdfont big">&#xeaf9;</span>|cod_gift|
|<span class="nerdfont big">&#xeafa;</span>|cod_gist_secret|
|<span class="nerdfont big">&#xeafc;</span>|cod_git_commit|
|<span class="nerdfont big">&#xeafd;</span>|cod_git_compare|
|<span class="nerdfont big">&#xeafe;</span>|cod_git_merge|
|<span class="nerdfont big">&#xea64;</span>|cod_git_pull_request|
|<span class="nerdfont big">&#xebda;</span>|cod_git_pull_request_closed|
|<span class="nerdfont big">&#xebbc;</span>|cod_git_pull_request_create|
|<span class="nerdfont big">&#xebdb;</span>|cod_git_pull_request_draft|
|<span class="nerdfont big">&#xea84;</span>|cod_github|
|<span class="nerdfont big">&#xeaff;</span>|cod_github_action|
|<span class="nerdfont big">&#xeb00;</span>|cod_github_alt|
|<span class="nerdfont big">&#xeba1;</span>|cod_github_inverted|
|<span class="nerdfont big">&#xeb01;</span>|cod_globe|
|<span class="nerdfont big">&#xea94;</span>|cod_go_to_file|
|<span class="nerdfont big">&#xeb02;</span>|cod_grabber|
|<span class="nerdfont big">&#xeb03;</span>|cod_graph|
|<span class="nerdfont big">&#xebad;</span>|cod_graph_left|
|<span class="nerdfont big">&#xebe2;</span>|cod_graph_line|
|<span class="nerdfont big">&#xebe3;</span>|cod_graph_scatter|
|<span class="nerdfont big">&#xeb04;</span>|cod_gripper|
|<span class="nerdfont big">&#xeb97;</span>|cod_group_by_ref_type|
|<span class="nerdfont big">&#xeb05;</span>|cod_heart|
|<span class="nerdfont big">&#xea82;</span>|cod_history|
|<span class="nerdfont big">&#xeb06;</span>|cod_home|
|<span class="nerdfont big">&#xeb07;</span>|cod_horizontal_rule|
|<span class="nerdfont big">&#xeb08;</span>|cod_hubot|
|<span class="nerdfont big">&#xeb09;</span>|cod_inbox|
|<span class="nerdfont big">&#xea74;</span>|cod_info|
|<span class="nerdfont big">&#xebd1;</span>|cod_inspect|
|<span class="nerdfont big">&#xebd9;</span>|cod_issue_draft|
|<span class="nerdfont big">&#xeb0b;</span>|cod_issue_reopened|
|<span class="nerdfont big">&#xeb0c;</span>|cod_issues|
|<span class="nerdfont big">&#xeb0d;</span>|cod_italic|
|<span class="nerdfont big">&#xeb0e;</span>|cod_jersey|
|<span class="nerdfont big">&#xeb0f;</span>|cod_json|
|<span class="nerdfont big">&#xeb10;</span>|cod_kebab_vertical|
|<span class="nerdfont big">&#xeb11;</span>|cod_key|
|<span class="nerdfont big">&#xeb12;</span>|cod_law|
|<span class="nerdfont big">&#xebd2;</span>|cod_layers|
|<span class="nerdfont big">&#xebd4;</span>|cod_layers_active|
|<span class="nerdfont big">&#xebd3;</span>|cod_layers_dot|
|<span class="nerdfont big">&#xebeb;</span>|cod_layout|
|<span class="nerdfont big">&#xeb9c;</span>|cod_library|
|<span class="nerdfont big">&#xea61;</span>|cod_lightbulb|
|<span class="nerdfont big">&#xeb13;</span>|cod_lightbulb_autofix|
|<span class="nerdfont big">&#xeb15;</span>|cod_link|
|<span class="nerdfont big">&#xeb14;</span>|cod_link_external|
|<span class="nerdfont big">&#xeb83;</span>|cod_list_filter|
|<span class="nerdfont big">&#xeb84;</span>|cod_list_flat|
|<span class="nerdfont big">&#xeb16;</span>|cod_list_ordered|
|<span class="nerdfont big">&#xeb85;</span>|cod_list_selection|
|<span class="nerdfont big">&#xeb86;</span>|cod_list_tree|
|<span class="nerdfont big">&#xeb17;</span>|cod_list_unordered|
|<span class="nerdfont big">&#xeb18;</span>|cod_live_share|
|<span class="nerdfont big">&#xeb19;</span>|cod_loading|
|<span class="nerdfont big">&#xeb1a;</span>|cod_location|
|<span class="nerdfont big">&#xea75;</span>|cod_lock|
|<span class="nerdfont big">&#xebe7;</span>|cod_lock_small|
|<span class="nerdfont big">&#xebae;</span>|cod_magnet|
|<span class="nerdfont big">&#xeb1c;</span>|cod_mail|
|<span class="nerdfont big">&#xeb1b;</span>|cod_mail_read|
|<span class="nerdfont big">&#xeb1d;</span>|cod_markdown|
|<span class="nerdfont big">&#xeb1e;</span>|cod_megaphone|
|<span class="nerdfont big">&#xeb1f;</span>|cod_mention|
|<span class="nerdfont big">&#xeb94;</span>|cod_menu|
|<span class="nerdfont big">&#xebab;</span>|cod_merge|
|<span class="nerdfont big">&#xeb20;</span>|cod_milestone|
|<span class="nerdfont big">&#xea69;</span>|cod_mirror|
|<span class="nerdfont big">&#xeb21;</span>|cod_mortar_board|
|<span class="nerdfont big">&#xeb22;</span>|cod_move|
|<span class="nerdfont big">&#xeb23;</span>|cod_multiple_windows|
|<span class="nerdfont big">&#xeb24;</span>|cod_mute|
|<span class="nerdfont big">&#xea7f;</span>|cod_new_file|
|<span class="nerdfont big">&#xea80;</span>|cod_new_folder|
|<span class="nerdfont big">&#xebea;</span>|cod_newline|
|<span class="nerdfont big">&#xeb25;</span>|cod_no_newline|
|<span class="nerdfont big">&#xeb26;</span>|cod_note|
|<span class="nerdfont big">&#xebaf;</span>|cod_notebook|
|<span class="nerdfont big">&#xebbf;</span>|cod_notebook_template|
|<span class="nerdfont big">&#xeb27;</span>|cod_octoface|
|<span class="nerdfont big">&#xeb28;</span>|cod_open_preview|
|<span class="nerdfont big">&#xea7e;</span>|cod_organization|
|<span class="nerdfont big">&#xeb9d;</span>|cod_output|
|<span class="nerdfont big">&#xeb29;</span>|cod_package|
|<span class="nerdfont big">&#xeb2a;</span>|cod_paintcan|
|<span class="nerdfont big">&#xeba4;</span>|cod_pass|
|<span class="nerdfont big">&#xebb3;</span>|cod_pass_filled|
|<span class="nerdfont big">&#xea67;</span>|cod_person|
|<span class="nerdfont big">&#xebcd;</span>|cod_person_add|
|<span class="nerdfont big">&#xebe4;</span>|cod_pie_chart|
|<span class="nerdfont big">&#xeb2b;</span>|cod_pin|
|<span class="nerdfont big">&#xeba0;</span>|cod_pinned|
|<span class="nerdfont big">&#xebb2;</span>|cod_pinned_dirty|
|<span class="nerdfont big">&#xeb2c;</span>|cod_play|
|<span class="nerdfont big">&#xeba6;</span>|cod_play_circle|
|<span class="nerdfont big">&#xeb2d;</span>|cod_plug|
|<span class="nerdfont big">&#xeb2e;</span>|cod_preserve_case|
|<span class="nerdfont big">&#xeb2f;</span>|cod_preview|
|<span class="nerdfont big">&#xea72;</span>|cod_primitive_square|
|<span class="nerdfont big">&#xeb30;</span>|cod_project|
|<span class="nerdfont big">&#xeb31;</span>|cod_pulse|
|<span class="nerdfont big">&#xeb32;</span>|cod_question|
|<span class="nerdfont big">&#xeb33;</span>|cod_quote|
|<span class="nerdfont big">&#xeb34;</span>|cod_radio_tower|
|<span class="nerdfont big">&#xeb35;</span>|cod_reactions|
|<span class="nerdfont big">&#xeba7;</span>|cod_record|
|<span class="nerdfont big">&#xea65;</span>|cod_record_keys|
|<span class="nerdfont big">&#xebb0;</span>|cod_redo|
|<span class="nerdfont big">&#xeb36;</span>|cod_references|
|<span class="nerdfont big">&#xeb37;</span>|cod_refresh|
|<span class="nerdfont big">&#xeb38;</span>|cod_regex|
|<span class="nerdfont big">&#xeb3a;</span>|cod_remote|
|<span class="nerdfont big">&#xeb39;</span>|cod_remote_explorer|
|<span class="nerdfont big">&#xeb3b;</span>|cod_remove|
|<span class="nerdfont big">&#xeb3d;</span>|cod_replace|
|<span class="nerdfont big">&#xeb3c;</span>|cod_replace_all|
|<span class="nerdfont big">&#xea7d;</span>|cod_reply|
|<span class="nerdfont big">&#xea62;</span>|cod_repo|
|<span class="nerdfont big">&#xeb3e;</span>|cod_repo_clone|
|<span class="nerdfont big">&#xeb3f;</span>|cod_repo_force_push|
|<span class="nerdfont big">&#xea63;</span>|cod_repo_forked|
|<span class="nerdfont big">&#xeb40;</span>|cod_repo_pull|
|<span class="nerdfont big">&#xeb41;</span>|cod_repo_push|
|<span class="nerdfont big">&#xeb42;</span>|cod_report|
|<span class="nerdfont big">&#xeb43;</span>|cod_request_changes|
|<span class="nerdfont big">&#xeb44;</span>|cod_rocket|
|<span class="nerdfont big">&#xeb46;</span>|cod_root_folder|
|<span class="nerdfont big">&#xeb45;</span>|cod_root_folder_opened|
|<span class="nerdfont big">&#xeb47;</span>|cod_rss|
|<span class="nerdfont big">&#xeb48;</span>|cod_ruby|
|<span class="nerdfont big">&#xebbd;</span>|cod_run_above|
|<span class="nerdfont big">&#xeb9e;</span>|cod_run_all|
|<span class="nerdfont big">&#xebbe;</span>|cod_run_below|
|<span class="nerdfont big">&#xebde;</span>|cod_run_errors|
|<span class="nerdfont big">&#xeb4b;</span>|cod_save|
|<span class="nerdfont big">&#xeb49;</span>|cod_save_all|
|<span class="nerdfont big">&#xeb4a;</span>|cod_save_as|
|<span class="nerdfont big">&#xeb4c;</span>|cod_screen_full|
|<span class="nerdfont big">&#xeb4d;</span>|cod_screen_normal|
|<span class="nerdfont big">&#xea6d;</span>|cod_search|
|<span class="nerdfont big">&#xeb4e;</span>|cod_search_stop|
|<span class="nerdfont big">&#xeb50;</span>|cod_server|
|<span class="nerdfont big">&#xeba3;</span>|cod_server_environment|
|<span class="nerdfont big">&#xeba2;</span>|cod_server_process|
|<span class="nerdfont big">&#xeb52;</span>|cod_settings|
|<span class="nerdfont big">&#xeb51;</span>|cod_settings_gear|
|<span class="nerdfont big">&#xeb53;</span>|cod_shield|
|<span class="nerdfont big">&#xea6f;</span>|cod_sign_in|
|<span class="nerdfont big">&#xea6e;</span>|cod_sign_out|
|<span class="nerdfont big">&#xeb54;</span>|cod_smiley|
|<span class="nerdfont big">&#xeb55;</span>|cod_sort_precedence|
|<span class="nerdfont big">&#xea68;</span>|cod_source_control|
|<span class="nerdfont big">&#xeb56;</span>|cod_split_horizontal|
|<span class="nerdfont big">&#xeb57;</span>|cod_split_vertical|
|<span class="nerdfont big">&#xeb58;</span>|cod_squirrel|
|<span class="nerdfont big">&#xea6a;</span>|cod_star_empty|
|<span class="nerdfont big">&#xeb59;</span>|cod_star_full|
|<span class="nerdfont big">&#xeb5a;</span>|cod_star_half|
|<span class="nerdfont big">&#xeba5;</span>|cod_stop_circle|
|<span class="nerdfont big">&#xea8a;</span>|cod_symbol_array|
|<span class="nerdfont big">&#xea8f;</span>|cod_symbol_boolean|
|<span class="nerdfont big">&#xeb5b;</span>|cod_symbol_class|
|<span class="nerdfont big">&#xeb5c;</span>|cod_symbol_color|
|<span class="nerdfont big">&#xeb5d;</span>|cod_symbol_constant|
|<span class="nerdfont big">&#xea95;</span>|cod_symbol_enum|
|<span class="nerdfont big">&#xeb5e;</span>|cod_symbol_enum_member|
|<span class="nerdfont big">&#xea86;</span>|cod_symbol_event|
|<span class="nerdfont big">&#xeb5f;</span>|cod_symbol_field|
|<span class="nerdfont big">&#xeb60;</span>|cod_symbol_file|
|<span class="nerdfont big">&#xeb61;</span>|cod_symbol_interface|
|<span class="nerdfont big">&#xea93;</span>|cod_symbol_key|
|<span class="nerdfont big">&#xeb62;</span>|cod_symbol_keyword|
|<span class="nerdfont big">&#xea8c;</span>|cod_symbol_method|
|<span class="nerdfont big">&#xeb63;</span>|cod_symbol_misc|
|<span class="nerdfont big">&#xea8b;</span>|cod_symbol_namespace|
|<span class="nerdfont big">&#xea90;</span>|cod_symbol_numeric|
|<span class="nerdfont big">&#xeb64;</span>|cod_symbol_operator|
|<span class="nerdfont big">&#xea92;</span>|cod_symbol_parameter|
|<span class="nerdfont big">&#xeb65;</span>|cod_symbol_property|
|<span class="nerdfont big">&#xea96;</span>|cod_symbol_ruler|
|<span class="nerdfont big">&#xeb66;</span>|cod_symbol_snippet|
|<span class="nerdfont big">&#xeb8d;</span>|cod_symbol_string|
|<span class="nerdfont big">&#xea91;</span>|cod_symbol_structure|
|<span class="nerdfont big">&#xea88;</span>|cod_symbol_variable|
|<span class="nerdfont big">&#xea77;</span>|cod_sync|
|<span class="nerdfont big">&#xeb9f;</span>|cod_sync_ignored|
|<span class="nerdfont big">&#xebb7;</span>|cod_table|
|<span class="nerdfont big">&#xea66;</span>|cod_tag|
|<span class="nerdfont big">&#xeb67;</span>|cod_tasklist|
|<span class="nerdfont big">&#xeb68;</span>|cod_telescope|
|<span class="nerdfont big">&#xea85;</span>|cod_terminal|
|<span class="nerdfont big">&#xebca;</span>|cod_terminal_bash|
|<span class="nerdfont big">&#xebc4;</span>|cod_terminal_cmd|
|<span class="nerdfont big">&#xebc5;</span>|cod_terminal_debian|
|<span class="nerdfont big">&#xebc6;</span>|cod_terminal_linux|
|<span class="nerdfont big">&#xebc7;</span>|cod_terminal_powershell|
|<span class="nerdfont big">&#xebc8;</span>|cod_terminal_tmux|
|<span class="nerdfont big">&#xebc9;</span>|cod_terminal_ubuntu|
|<span class="nerdfont big">&#xeb69;</span>|cod_text_size|
|<span class="nerdfont big">&#xeb6a;</span>|cod_three_bars|
|<span class="nerdfont big">&#xeb6b;</span>|cod_thumbsdown|
|<span class="nerdfont big">&#xeb6c;</span>|cod_thumbsup|
|<span class="nerdfont big">&#xeb6d;</span>|cod_tools|
|<span class="nerdfont big">&#xea81;</span>|cod_trash|
|<span class="nerdfont big">&#xeb6e;</span>|cod_triangle_down|
|<span class="nerdfont big">&#xeb6f;</span>|cod_triangle_left|
|<span class="nerdfont big">&#xeb70;</span>|cod_triangle_right|
|<span class="nerdfont big">&#xeb71;</span>|cod_triangle_up|
|<span class="nerdfont big">&#xeb72;</span>|cod_twitter|
|<span class="nerdfont big">&#xebb9;</span>|cod_type_hierarchy|
|<span class="nerdfont big">&#xebba;</span>|cod_type_hierarchy_sub|
|<span class="nerdfont big">&#xebbb;</span>|cod_type_hierarchy_super|
|<span class="nerdfont big">&#xeb73;</span>|cod_unfold|
|<span class="nerdfont big">&#xeb98;</span>|cod_ungroup_by_ref_type|
|<span class="nerdfont big">&#xeb74;</span>|cod_unlock|
|<span class="nerdfont big">&#xeb75;</span>|cod_unmute|
|<span class="nerdfont big">&#xeb76;</span>|cod_unverified|
|<span class="nerdfont big">&#xebb8;</span>|cod_variable_group|
|<span class="nerdfont big">&#xeb77;</span>|cod_verified|
|<span class="nerdfont big">&#xebe9;</span>|cod_verified_filled|
|<span class="nerdfont big">&#xeb78;</span>|cod_versions|
|<span class="nerdfont big">&#xea7a;</span>|cod_vm|
|<span class="nerdfont big">&#xeb79;</span>|cod_vm_active|
|<span class="nerdfont big">&#xeba9;</span>|cod_vm_connect|
|<span class="nerdfont big">&#xeb7a;</span>|cod_vm_outline|
|<span class="nerdfont big">&#xeb7b;</span>|cod_vm_running|
|<span class="nerdfont big">&#xebcf;</span>|cod_wand|
|<span class="nerdfont big">&#xea6c;</span>|cod_warning|
|<span class="nerdfont big">&#xeb7c;</span>|cod_watch|
|<span class="nerdfont big">&#xeb7d;</span>|cod_whitespace|
|<span class="nerdfont big">&#xeb7e;</span>|cod_whole_word|
|<span class="nerdfont big">&#xeb7f;</span>|cod_window|
|<span class="nerdfont big">&#xeb80;</span>|cod_word_wrap|
|<span class="nerdfont big">&#xebc1;</span>|cod_workspace_trusted|
|<span class="nerdfont big">&#xebc3;</span>|cod_workspace_unknown|
|<span class="nerdfont big">&#xebc2;</span>|cod_workspace_untrusted|
|<span class="nerdfont big">&#xeb81;</span>|cod_zoom_in|
|<span class="nerdfont big">&#xeb82;</span>|cod_zoom_out|
|<span class="nerdfont big">&#xe6ab;</span>|custom_asm|
|<span class="nerdfont big">&#xe61e;</span>|custom_c|
|<span class="nerdfont big">&#xe6b0;</span>|custom_common_lisp|
|<span class="nerdfont big">&#xe61d;</span>|custom_cpp|
|<span class="nerdfont big">&#xe62f;</span>|custom_crystal|
|<span class="nerdfont big">&#xe612;</span>|custom_default|
|<span class="nerdfont big">&#xe62e;</span>|custom_electron|
|<span class="nerdfont big">&#xe62d;</span>|custom_elixir|
|<span class="nerdfont big">&#xe62c;</span>|custom_elm|
|<span class="nerdfont big">&#xe632;</span>|custom_emacs|
|<span class="nerdfont big">&#xe6af;</span>|custom_fennel|
|<span class="nerdfont big">&#xe5ff;</span>|custom_folder|
|<span class="nerdfont big">&#xe5fc;</span>|custom_folder_config|
|<span class="nerdfont big">&#xe5fb;</span>|custom_folder_git|
|<span class="nerdfont big">&#xe5fd;</span>|custom_folder_github|
|<span class="nerdfont big">&#xe5fa;</span>|custom_folder_npm|
|<span class="nerdfont big">&#xe6ad;</span>|custom_folder_oct|
|<span class="nerdfont big">&#xe5fe;</span>|custom_folder_open|
|<span class="nerdfont big">&#xe626;</span>|custom_go|
|<span class="nerdfont big">&#xe617;</span>|custom_home|
|<span class="nerdfont big">&#xe634;</span>|custom_kotlin|
|<span class="nerdfont big">&#xe629;</span>|custom_msdos|
|<span class="nerdfont big">&#xe6ae;</span>|custom_neovim|
|<span class="nerdfont big">&#xe633;</span>|custom_orgmode|
|<span class="nerdfont big">&#xe602;</span>|custom_play_arrow|
|<span class="nerdfont big">&#xe630;</span>|custom_purescript|
|<span class="nerdfont big">&#xe6b1;</span>|custom_scheme|
|<span class="nerdfont big">&#xe6b2;</span>|custom_toml|
|<span class="nerdfont big">&#xe6ac;</span>|custom_v_lang|
|<span class="nerdfont big">&#xe62b;</span>|custom_vim|
|<span class="nerdfont big">&#xe62a;</span>|custom_windows|
|<span class="nerdfont big">&#xe70e;</span>|dev_android|
|<span class="nerdfont big">&#xe753;</span>|dev_angular|
|<span class="nerdfont big">&#xe7ab;</span>|dev_appcelerator|
|<span class="nerdfont big">&#xe711;</span>|dev_apple|
|<span class="nerdfont big">&#xe713;</span>|dev_appstore|
|<span class="nerdfont big">&#xe799;</span>|dev_aptana|
|<span class="nerdfont big">&#xe7ac;</span>|dev_asterisk|
|<span class="nerdfont big">&#xe75b;</span>|dev_atlassian|
|<span class="nerdfont big">&#xe764;</span>|dev_atom|
|<span class="nerdfont big">&#xe7ad;</span>|dev_aws|
|<span class="nerdfont big">&#xe752;</span>|dev_backbone|
|<span class="nerdfont big">&#xe700;</span>|dev_bing_small|
|<span class="nerdfont big">&#xe794;</span>|dev_bintray|
|<span class="nerdfont big">&#xe703;</span>|dev_bitbucket|
|<span class="nerdfont big">&#xe723;</span>|dev_blackberry|
|<span class="nerdfont big">&#xe747;</span>|dev_bootstrap|
|<span class="nerdfont big">&#xe74d;</span>|dev_bower|
|<span class="nerdfont big">&#xe79d;</span>|dev_brackets|
|<span class="nerdfont big">&#xe78d;</span>|dev_bugsense|
|<span class="nerdfont big">&#xe76b;</span>|dev_celluloid|
|<span class="nerdfont big">&#xe760;</span>|dev_chart|
|<span class="nerdfont big">&#xe743;</span>|dev_chrome|
|<span class="nerdfont big">&#xe765;</span>|dev_cisco|
|<span class="nerdfont big">&#xe768;</span>|dev_clojure|
|<span class="nerdfont big">&#xe76a;</span>|dev_clojure_alt|
|<span class="nerdfont big">&#xe79f;</span>|dev_cloud9|
|<span class="nerdfont big">&#xe793;</span>|dev_coda|
|<span class="nerdfont big">&#xe796;</span>|dev_code|
|<span class="nerdfont big">&#xe7a3;</span>|dev_code_badge|
|<span class="nerdfont big">&#xe780;</span>|dev_codeigniter|
|<span class="nerdfont big">&#xe716;</span>|dev_codepen|
|<span class="nerdfont big">&#xe72f;</span>|dev_codrops|
|<span class="nerdfont big">&#xe751;</span>|dev_coffeescript|
|<span class="nerdfont big">&#xe761;</span>|dev_compass|
|<span class="nerdfont big">&#xe783;</span>|dev_composer|
|<span class="nerdfont big">&#xe789;</span>|dev_creativecommons|
|<span class="nerdfont big">&#xe78a;</span>|dev_creativecommons_badge|
|<span class="nerdfont big">&#xe749;</span>|dev_css3|
|<span class="nerdfont big">&#xe74a;</span>|dev_css3_full|
|<span class="nerdfont big">&#xe701;</span>|dev_css_tricks|
|<span class="nerdfont big">&#xe72a;</span>|dev_cssdeck|
|<span class="nerdfont big">&#xe798;</span>|dev_dart|
|<span class="nerdfont big">&#xe706;</span>|dev_database|
|<span class="nerdfont big">&#xe77d;</span>|dev_debian|
|<span class="nerdfont big">&#xe7ae;</span>|dev_digital_ocean|
|<span class="nerdfont big">&#xe71d;</span>|dev_django|
|<span class="nerdfont big">&#xe7af;</span>|dev_dlang|
|<span class="nerdfont big">&#xe7b0;</span>|dev_docker|
|<span class="nerdfont big">&#xe774;</span>|dev_doctrine|
|<span class="nerdfont big">&#xe71c;</span>|dev_dojo|
|<span class="nerdfont big">&#xe77f;</span>|dev_dotnet|
|<span class="nerdfont big">&#xe79c;</span>|dev_dreamweaver|
|<span class="nerdfont big">&#xe707;</span>|dev_dropbox|
|<span class="nerdfont big">&#xe742;</span>|dev_drupal|
|<span class="nerdfont big">&#xe79e;</span>|dev_eclipse|
|<span class="nerdfont big">&#xe71b;</span>|dev_ember|
|<span class="nerdfont big">&#xe75d;</span>|dev_envato|
|<span class="nerdfont big">&#xe7b1;</span>|dev_erlang|
|<span class="nerdfont big">&#xe78e;</span>|dev_extjs|
|<span class="nerdfont big">&#xe787;</span>|dev_firebase|
|<span class="nerdfont big">&#xe745;</span>|dev_firefox|
|<span class="nerdfont big">&#xe7a7;</span>|dev_fsharp|
|<span class="nerdfont big">&#xe71f;</span>|dev_ghost|
|<span class="nerdfont big">&#xe714;</span>|dev_ghost_small|
|<span class="nerdfont big">&#xe702;</span>|dev_git|
|<span class="nerdfont big">&#xe725;</span>|dev_git_branch|
|<span class="nerdfont big">&#xe729;</span>|dev_git_commit|
|<span class="nerdfont big">&#xe728;</span>|dev_git_compare|
|<span class="nerdfont big">&#xe727;</span>|dev_git_merge|
|<span class="nerdfont big">&#xe726;</span>|dev_git_pull_request|
|<span class="nerdfont big">&#xe70a;</span>|dev_github|
|<span class="nerdfont big">&#xe708;</span>|dev_github_alt|
|<span class="nerdfont big">&#xe709;</span>|dev_github_badge|
|<span class="nerdfont big">&#xe717;</span>|dev_github_full|
|<span class="nerdfont big">&#xe779;</span>|dev_gnu|
|<span class="nerdfont big">&#xe724;</span>|dev_go|
|<span class="nerdfont big">&#xe7b2;</span>|dev_google_cloud_platform|
|<span class="nerdfont big">&#xe731;</span>|dev_google_drive|
|<span class="nerdfont big">&#xe7b3;</span>|dev_grails|
|<span class="nerdfont big">&#xe775;</span>|dev_groovy|
|<span class="nerdfont big">&#xe74c;</span>|dev_grunt|
|<span class="nerdfont big">&#xe763;</span>|dev_gulp|
|<span class="nerdfont big">&#xe71a;</span>|dev_hackernews|
|<span class="nerdfont big">&#xe777;</span>|dev_haskell|
|<span class="nerdfont big">&#xe77b;</span>|dev_heroku|
|<span class="nerdfont big">&#xe736;</span>|dev_html5|
|<span class="nerdfont big">&#xe735;</span>|dev_html5_3d_effects|
|<span class="nerdfont big">&#xe734;</span>|dev_html5_connectivity|
|<span class="nerdfont big">&#xe733;</span>|dev_html5_device_access|
|<span class="nerdfont big">&#xe732;</span>|dev_html5_multimedia|
|<span class="nerdfont big">&#xe744;</span>|dev_ie|
|<span class="nerdfont big">&#xe7b4;</span>|dev_illustrator|
|<span class="nerdfont big">&#xe7b5;</span>|dev_intellij|
|<span class="nerdfont big">&#xe7a9;</span>|dev_ionic|
|<span class="nerdfont big">&#xe738;</span>|dev_java|
|<span class="nerdfont big">&#xe74e;</span>|dev_javascript|
|<span class="nerdfont big">&#xe781;</span>|dev_javascript_badge|
|<span class="nerdfont big">&#xe74f;</span>|dev_javascript_shield|
|<span class="nerdfont big">&#xe70d;</span>|dev_jekyll_small|
|<span class="nerdfont big">&#xe767;</span>|dev_jenkins|
|<span class="nerdfont big">&#xe75c;</span>|dev_jira|
|<span class="nerdfont big">&#xe741;</span>|dev_joomla|
|<span class="nerdfont big">&#xe750;</span>|dev_jquery|
|<span class="nerdfont big">&#xe754;</span>|dev_jquery_ui|
|<span class="nerdfont big">&#xe792;</span>|dev_komodo|
|<span class="nerdfont big">&#xe785;</span>|dev_krakenjs|
|<span class="nerdfont big">&#xe784;</span>|dev_krakenjs_badge|
|<span class="nerdfont big">&#xe73f;</span>|dev_laravel|
|<span class="nerdfont big">&#xe758;</span>|dev_less|
|<span class="nerdfont big">&#xe712;</span>|dev_linux|
|<span class="nerdfont big">&#xe740;</span>|dev_magento|
|<span class="nerdfont big">&#xe79a;</span>|dev_mailchimp|
|<span class="nerdfont big">&#xe73e;</span>|dev_markdown|
|<span class="nerdfont big">&#xe7b6;</span>|dev_materializecss|
|<span class="nerdfont big">&#xe7a5;</span>|dev_meteor|
|<span class="nerdfont big">&#xe7a6;</span>|dev_meteorfull|
|<span class="nerdfont big">&#xe78b;</span>|dev_mitlicence|
|<span class="nerdfont big">&#xe720;</span>|dev_modernizr|
|<span class="nerdfont big">&#xe7a4;</span>|dev_mongodb|
|<span class="nerdfont big">&#xe790;</span>|dev_mootools|
|<span class="nerdfont big">&#xe78f;</span>|dev_mootools_badge|
|<span class="nerdfont big">&#xe786;</span>|dev_mozilla|
|<span class="nerdfont big">&#xe77c;</span>|dev_msql_server|
|<span class="nerdfont big">&#xe704;</span>|dev_mysql|
|<span class="nerdfont big">&#xe766;</span>|dev_nancy|
|<span class="nerdfont big">&#xe79b;</span>|dev_netbeans|
|<span class="nerdfont big">&#xe72e;</span>|dev_netmagazine|
|<span class="nerdfont big">&#xe776;</span>|dev_nginx|
|<span class="nerdfont big">&#xe719;</span>|dev_nodejs|
|<span class="nerdfont big">&#xe718;</span>|dev_nodejs_small|
|<span class="nerdfont big">&#xe71e;</span>|dev_npm|
|<span class="nerdfont big">&#xe762;</span>|dev_onedrive|
|<span class="nerdfont big">&#xe7b7;</span>|dev_openshift|
|<span class="nerdfont big">&#xe771;</span>|dev_opensource|
|<span class="nerdfont big">&#xe746;</span>|dev_opera|
|<span class="nerdfont big">&#xe769;</span>|dev_perl|
|<span class="nerdfont big">&#xe730;</span>|dev_phonegap|
|<span class="nerdfont big">&#xe7b8;</span>|dev_photoshop|
|<span class="nerdfont big">&#xe73d;</span>|dev_php|
|<span class="nerdfont big">&#xe76e;</span>|dev_postgresql|
|<span class="nerdfont big">&#xe7a1;</span>|dev_prolog|
|<span class="nerdfont big">&#xe73c;</span>|dev_python|
|<span class="nerdfont big">&#xe7b9;</span>|dev_rackspace|
|<span class="nerdfont big">&#xe75f;</span>|dev_raphael|
|<span class="nerdfont big">&#xe722;</span>|dev_rasberry_pi|
|<span class="nerdfont big">&#xe7ba;</span>|dev_react|
|<span class="nerdfont big">&#xe7bb;</span>|dev_redhat|
|<span class="nerdfont big">&#xe76d;</span>|dev_redis|
|<span class="nerdfont big">&#xe770;</span>|dev_requirejs|
|<span class="nerdfont big">&#xe797;</span>|dev_responsive|
|<span class="nerdfont big">&#xe739;</span>|dev_ruby|
|<span class="nerdfont big">&#xe73b;</span>|dev_ruby_on_rails|
|<span class="nerdfont big">&#xe791;</span>|dev_ruby_rough|
|<span class="nerdfont big">&#xe7a8;</span>|dev_rust|
|<span class="nerdfont big">&#xe748;</span>|dev_safari|
|<span class="nerdfont big">&#xe74b;</span>|dev_sass|
|<span class="nerdfont big">&#xe737;</span>|dev_scala|
|<span class="nerdfont big">&#xe7bc;</span>|dev_scriptcs|
|<span class="nerdfont big">&#xe7a0;</span>|dev_scrum|
|<span class="nerdfont big">&#xe78c;</span>|dev_senchatouch|
|<span class="nerdfont big">&#xe788;</span>|dev_sizzlejs|
|<span class="nerdfont big">&#xe72d;</span>|dev_smashing_magazine|
|<span class="nerdfont big">&#xe75e;</span>|dev_snap_svg|
|<span class="nerdfont big">&#xe7c4;</span>|dev_sqllite|
|<span class="nerdfont big">&#xe710;</span>|dev_stackoverflow|
|<span class="nerdfont big">&#xe705;</span>|dev_streamline|
|<span class="nerdfont big">&#xe759;</span>|dev_stylus|
|<span class="nerdfont big">&#xe7aa;</span>|dev_sublime|
|<span class="nerdfont big">&#xe755;</span>|dev_swift|
|<span class="nerdfont big">&#xe756;</span>|dev_symfony|
|<span class="nerdfont big">&#xe757;</span>|dev_symfony_badge|
|<span class="nerdfont big">&#xe72c;</span>|dev_techcrunch|
|<span class="nerdfont big">&#xe795;</span>|dev_terminal|
|<span class="nerdfont big">&#xe7a2;</span>|dev_terminal_badge|
|<span class="nerdfont big">&#xe77e;</span>|dev_travis|
|<span class="nerdfont big">&#xe75a;</span>|dev_trello|
|<span class="nerdfont big">&#xe772;</span>|dev_typo3|
|<span class="nerdfont big">&#xe73a;</span>|dev_ubuntu|
|<span class="nerdfont big">&#xe773;</span>|dev_uikit|
|<span class="nerdfont big">&#xe721;</span>|dev_unity_small|
|<span class="nerdfont big">&#xe7c5;</span>|dev_vim|
|<span class="nerdfont big">&#xe70c;</span>|dev_visualstudio|
|<span class="nerdfont big">&#xe76c;</span>|dev_w3c|
|<span class="nerdfont big">&#xe76f;</span>|dev_webplatform|
|<span class="nerdfont big">&#xe70f;</span>|dev_windows|
|<span class="nerdfont big">&#xe70b;</span>|dev_wordpress|
|<span class="nerdfont big">&#xe715;</span>|dev_yahoo|
|<span class="nerdfont big">&#xe72b;</span>|dev_yahoo_small|
|<span class="nerdfont big">&#xe77a;</span>|dev_yeoman|
|<span class="nerdfont big">&#xe782;</span>|dev_yii|
|<span class="nerdfont big">&#xe778;</span>|dev_zend|
|<span class="nerdfont big">&#xf26e;</span>|fa_500px|
|<span class="nerdfont big">&#xf2b9;</span>|fa_address_book|
|<span class="nerdfont big">&#xf2ba;</span>|fa_address_book_o|
|<span class="nerdfont big">&#xf2bb;</span>|fa_address_card|
|<span class="nerdfont big">&#xf2bc;</span>|fa_address_card_o|
|<span class="nerdfont big">&#xf042;</span>|fa_adjust|
|<span class="nerdfont big">&#xf170;</span>|fa_adn|
|<span class="nerdfont big">&#xf037;</span>|fa_align_center|
|<span class="nerdfont big">&#xf039;</span>|fa_align_justify|
|<span class="nerdfont big">&#xf036;</span>|fa_align_left|
|<span class="nerdfont big">&#xf038;</span>|fa_align_right|
|<span class="nerdfont big">&#xf270;</span>|fa_amazon|
|<span class="nerdfont big">&#xf0f9;</span>|fa_ambulance|
|<span class="nerdfont big">&#xf2a3;</span>|fa_american_sign_language_interpreting|
|<span class="nerdfont big">&#xf13d;</span>|fa_anchor|
|<span class="nerdfont big">&#xf17b;</span>|fa_android|
|<span class="nerdfont big">&#xf209;</span>|fa_angellist|
|<span class="nerdfont big">&#xf103;</span>|fa_angle_double_down|
|<span class="nerdfont big">&#xf100;</span>|fa_angle_double_left|
|<span class="nerdfont big">&#xf101;</span>|fa_angle_double_right|
|<span class="nerdfont big">&#xf102;</span>|fa_angle_double_up|
|<span class="nerdfont big">&#xf107;</span>|fa_angle_down|
|<span class="nerdfont big">&#xf104;</span>|fa_angle_left|
|<span class="nerdfont big">&#xf105;</span>|fa_angle_right|
|<span class="nerdfont big">&#xf106;</span>|fa_angle_up|
|<span class="nerdfont big">&#xf179;</span>|fa_apple|
|<span class="nerdfont big">&#xf187;</span>|fa_archive|
|<span class="nerdfont big">&#xf1fe;</span>|fa_area_chart|
|<span class="nerdfont big">&#xf0ab;</span>|fa_arrow_circle_down|
|<span class="nerdfont big">&#xf0a8;</span>|fa_arrow_circle_left|
|<span class="nerdfont big">&#xf01a;</span>|fa_arrow_circle_o_down|
|<span class="nerdfont big">&#xf190;</span>|fa_arrow_circle_o_left|
|<span class="nerdfont big">&#xf18e;</span>|fa_arrow_circle_o_right|
|<span class="nerdfont big">&#xf01b;</span>|fa_arrow_circle_o_up|
|<span class="nerdfont big">&#xf0a9;</span>|fa_arrow_circle_right|
|<span class="nerdfont big">&#xf0aa;</span>|fa_arrow_circle_up|
|<span class="nerdfont big">&#xf063;</span>|fa_arrow_down|
|<span class="nerdfont big">&#xf060;</span>|fa_arrow_left|
|<span class="nerdfont big">&#xf061;</span>|fa_arrow_right|
|<span class="nerdfont big">&#xf062;</span>|fa_arrow_up|
|<span class="nerdfont big">&#xf047;</span>|fa_arrows|
|<span class="nerdfont big">&#xf0b2;</span>|fa_arrows_alt|
|<span class="nerdfont big">&#xf07e;</span>|fa_arrows_h|
|<span class="nerdfont big">&#xf07d;</span>|fa_arrows_v|
|<span class="nerdfont big">&#xf2a2;</span>|fa_assistive_listening_systems|
|<span class="nerdfont big">&#xf069;</span>|fa_asterisk|
|<span class="nerdfont big">&#xf1fa;</span>|fa_at|
|<span class="nerdfont big">&#xf29e;</span>|fa_audio_description|
|<span class="nerdfont big">&#xf04a;</span>|fa_backward|
|<span class="nerdfont big">&#xf24e;</span>|fa_balance_scale|
|<span class="nerdfont big">&#xf05e;</span>|fa_ban|
|<span class="nerdfont big">&#xf2d5;</span>|fa_bandcamp|
|<span class="nerdfont big">&#xf080;</span>|fa_bar_chart|
|<span class="nerdfont big">&#xf02a;</span>|fa_barcode|
|<span class="nerdfont big">&#xf0c9;</span>|fa_bars|
|<span class="nerdfont big">&#xf2cd;</span>|fa_bath|
|<span class="nerdfont big">&#xf244;</span>|fa_battery_empty|
|<span class="nerdfont big">&#xf240;</span>|fa_battery_full|
|<span class="nerdfont big">&#xf242;</span>|fa_battery_half|
|<span class="nerdfont big">&#xf243;</span>|fa_battery_quarter|
|<span class="nerdfont big">&#xf241;</span>|fa_battery_three_quarters|
|<span class="nerdfont big">&#xf236;</span>|fa_bed|
|<span class="nerdfont big">&#xf0fc;</span>|fa_beer|
|<span class="nerdfont big">&#xf1b4;</span>|fa_behance|
|<span class="nerdfont big">&#xf1b5;</span>|fa_behance_square|
|<span class="nerdfont big">&#xf0f3;</span>|fa_bell|
|<span class="nerdfont big">&#xf0a2;</span>|fa_bell_o|
|<span class="nerdfont big">&#xf1f6;</span>|fa_bell_slash|
|<span class="nerdfont big">&#xf1f7;</span>|fa_bell_slash_o|
|<span class="nerdfont big">&#xf206;</span>|fa_bicycle|
|<span class="nerdfont big">&#xf1e5;</span>|fa_binoculars|
|<span class="nerdfont big">&#xf1fd;</span>|fa_birthday_cake|
|<span class="nerdfont big">&#xf171;</span>|fa_bitbucket|
|<span class="nerdfont big">&#xf172;</span>|fa_bitbucket_square|
|<span class="nerdfont big">&#xf27e;</span>|fa_black_tie|
|<span class="nerdfont big">&#xf29d;</span>|fa_blind|
|<span class="nerdfont big">&#xf293;</span>|fa_bluetooth|
|<span class="nerdfont big">&#xf294;</span>|fa_bluetooth_b|
|<span class="nerdfont big">&#xf032;</span>|fa_bold|
|<span class="nerdfont big">&#xf0e7;</span>|fa_bolt|
|<span class="nerdfont big">&#xf1e2;</span>|fa_bomb|
|<span class="nerdfont big">&#xf02d;</span>|fa_book|
|<span class="nerdfont big">&#xf02e;</span>|fa_bookmark|
|<span class="nerdfont big">&#xf097;</span>|fa_bookmark_o|
|<span class="nerdfont big">&#xf2a1;</span>|fa_braille|
|<span class="nerdfont big">&#xf0b1;</span>|fa_briefcase|
|<span class="nerdfont big">&#xf15a;</span>|fa_btc|
|<span class="nerdfont big">&#xf188;</span>|fa_bug|
|<span class="nerdfont big">&#xf1ad;</span>|fa_building|
|<span class="nerdfont big">&#xf0f7;</span>|fa_building_o|
|<span class="nerdfont big">&#xf0a1;</span>|fa_bullhorn|
|<span class="nerdfont big">&#xf140;</span>|fa_bullseye|
|<span class="nerdfont big">&#xf207;</span>|fa_bus|
|<span class="nerdfont big">&#xf20d;</span>|fa_buysellads|
|<span class="nerdfont big">&#xf1ec;</span>|fa_calculator|
|<span class="nerdfont big">&#xf073;</span>|fa_calendar|
|<span class="nerdfont big">&#xf274;</span>|fa_calendar_check_o|
|<span class="nerdfont big">&#xf272;</span>|fa_calendar_minus_o|
|<span class="nerdfont big">&#xf133;</span>|fa_calendar_o|
|<span class="nerdfont big">&#xf271;</span>|fa_calendar_plus_o|
|<span class="nerdfont big">&#xf273;</span>|fa_calendar_times_o|
|<span class="nerdfont big">&#xf030;</span>|fa_camera|
|<span class="nerdfont big">&#xf083;</span>|fa_camera_retro|
|<span class="nerdfont big">&#xf1b9;</span>|fa_car|
|<span class="nerdfont big">&#xf0d7;</span>|fa_caret_down|
|<span class="nerdfont big">&#xf0d9;</span>|fa_caret_left|
|<span class="nerdfont big">&#xf0da;</span>|fa_caret_right|
|<span class="nerdfont big">&#xf150;</span>|fa_caret_square_o_down|
|<span class="nerdfont big">&#xf191;</span>|fa_caret_square_o_left|
|<span class="nerdfont big">&#xf152;</span>|fa_caret_square_o_right|
|<span class="nerdfont big">&#xf151;</span>|fa_caret_square_o_up|
|<span class="nerdfont big">&#xf0d8;</span>|fa_caret_up|
|<span class="nerdfont big">&#xf218;</span>|fa_cart_arrow_down|
|<span class="nerdfont big">&#xf217;</span>|fa_cart_plus|
|<span class="nerdfont big">&#xf20a;</span>|fa_cc|
|<span class="nerdfont big">&#xf1f3;</span>|fa_cc_amex|
|<span class="nerdfont big">&#xf24c;</span>|fa_cc_diners_club|
|<span class="nerdfont big">&#xf1f2;</span>|fa_cc_discover|
|<span class="nerdfont big">&#xf24b;</span>|fa_cc_jcb|
|<span class="nerdfont big">&#xf1f1;</span>|fa_cc_mastercard|
|<span class="nerdfont big">&#xf1f4;</span>|fa_cc_paypal|
|<span class="nerdfont big">&#xf1f5;</span>|fa_cc_stripe|
|<span class="nerdfont big">&#xf1f0;</span>|fa_cc_visa|
|<span class="nerdfont big">&#xf0a3;</span>|fa_certificate|
|<span class="nerdfont big">&#xf127;</span>|fa_chain_broken|
|<span class="nerdfont big">&#xf00c;</span>|fa_check|
|<span class="nerdfont big">&#xf058;</span>|fa_check_circle|
|<span class="nerdfont big">&#xf05d;</span>|fa_check_circle_o|
|<span class="nerdfont big">&#xf14a;</span>|fa_check_square|
|<span class="nerdfont big">&#xf046;</span>|fa_check_square_o|
|<span class="nerdfont big">&#xf13a;</span>|fa_chevron_circle_down|
|<span class="nerdfont big">&#xf137;</span>|fa_chevron_circle_left|
|<span class="nerdfont big">&#xf138;</span>|fa_chevron_circle_right|
|<span class="nerdfont big">&#xf139;</span>|fa_chevron_circle_up|
|<span class="nerdfont big">&#xf078;</span>|fa_chevron_down|
|<span class="nerdfont big">&#xf053;</span>|fa_chevron_left|
|<span class="nerdfont big">&#xf054;</span>|fa_chevron_right|
|<span class="nerdfont big">&#xf077;</span>|fa_chevron_up|
|<span class="nerdfont big">&#xf1ae;</span>|fa_child|
|<span class="nerdfont big">&#xf268;</span>|fa_chrome|
|<span class="nerdfont big">&#xf111;</span>|fa_circle|
|<span class="nerdfont big">&#xf10c;</span>|fa_circle_o|
|<span class="nerdfont big">&#xf1ce;</span>|fa_circle_o_notch|
|<span class="nerdfont big">&#xf1db;</span>|fa_circle_thin|
|<span class="nerdfont big">&#xf0ea;</span>|fa_clipboard|
|<span class="nerdfont big">&#xf017;</span>|fa_clock_o|
|<span class="nerdfont big">&#xf24d;</span>|fa_clone|
|<span class="nerdfont big">&#xf0c2;</span>|fa_cloud|
|<span class="nerdfont big">&#xf0ed;</span>|fa_cloud_download|
|<span class="nerdfont big">&#xf0ee;</span>|fa_cloud_upload|
|<span class="nerdfont big">&#xf121;</span>|fa_code|
|<span class="nerdfont big">&#xf126;</span>|fa_code_fork|
|<span class="nerdfont big">&#xf1cb;</span>|fa_codepen|
|<span class="nerdfont big">&#xf284;</span>|fa_codiepie|
|<span class="nerdfont big">&#xf0f4;</span>|fa_coffee|
|<span class="nerdfont big">&#xf013;</span>|fa_cog|
|<span class="nerdfont big">&#xf085;</span>|fa_cogs|
|<span class="nerdfont big">&#xf0db;</span>|fa_columns|
|<span class="nerdfont big">&#xf075;</span>|fa_comment|
|<span class="nerdfont big">&#xf0e5;</span>|fa_comment_o|
|<span class="nerdfont big">&#xf27a;</span>|fa_commenting|
|<span class="nerdfont big">&#xf27b;</span>|fa_commenting_o|
|<span class="nerdfont big">&#xf086;</span>|fa_comments|
|<span class="nerdfont big">&#xf0e6;</span>|fa_comments_o|
|<span class="nerdfont big">&#xf14e;</span>|fa_compass|
|<span class="nerdfont big">&#xf066;</span>|fa_compress|
|<span class="nerdfont big">&#xf20e;</span>|fa_connectdevelop|
|<span class="nerdfont big">&#xf26d;</span>|fa_contao|
|<span class="nerdfont big">&#xf1f9;</span>|fa_copyright|
|<span class="nerdfont big">&#xf25e;</span>|fa_creative_commons|
|<span class="nerdfont big">&#xf09d;</span>|fa_credit_card|
|<span class="nerdfont big">&#xf283;</span>|fa_credit_card_alt|
|<span class="nerdfont big">&#xf125;</span>|fa_crop|
|<span class="nerdfont big">&#xf05b;</span>|fa_crosshairs|
|<span class="nerdfont big">&#xf13c;</span>|fa_css3|
|<span class="nerdfont big">&#xf1b2;</span>|fa_cube|
|<span class="nerdfont big">&#xf1b3;</span>|fa_cubes|
|<span class="nerdfont big">&#xf0f5;</span>|fa_cutlery|
|<span class="nerdfont big">&#xf210;</span>|fa_dashcube|
|<span class="nerdfont big">&#xf1c0;</span>|fa_database|
|<span class="nerdfont big">&#xf2a4;</span>|fa_deaf|
|<span class="nerdfont big">&#xf1a5;</span>|fa_delicious|
|<span class="nerdfont big">&#xf108;</span>|fa_desktop|
|<span class="nerdfont big">&#xf1bd;</span>|fa_deviantart|
|<span class="nerdfont big">&#xf219;</span>|fa_diamond|
|<span class="nerdfont big">&#xf1a6;</span>|fa_digg|
|<span class="nerdfont big">&#xf192;</span>|fa_dot_circle_o|
|<span class="nerdfont big">&#xf019;</span>|fa_download|
|<span class="nerdfont big">&#xf17d;</span>|fa_dribbble|
|<span class="nerdfont big">&#xf16b;</span>|fa_dropbox|
|<span class="nerdfont big">&#xf1a9;</span>|fa_drupal|
|<span class="nerdfont big">&#xf282;</span>|fa_edge|
|<span class="nerdfont big">&#xf2da;</span>|fa_eercast|
|<span class="nerdfont big">&#xf052;</span>|fa_eject|
|<span class="nerdfont big">&#xf141;</span>|fa_ellipsis_h|
|<span class="nerdfont big">&#xf142;</span>|fa_ellipsis_v|
|<span class="nerdfont big">&#xf1d1;</span>|fa_empire|
|<span class="nerdfont big">&#xf0e0;</span>|fa_envelope|
|<span class="nerdfont big">&#xf003;</span>|fa_envelope_o|
|<span class="nerdfont big">&#xf2b6;</span>|fa_envelope_open|
|<span class="nerdfont big">&#xf2b7;</span>|fa_envelope_open_o|
|<span class="nerdfont big">&#xf199;</span>|fa_envelope_square|
|<span class="nerdfont big">&#xf299;</span>|fa_envira|
|<span class="nerdfont big">&#xf12d;</span>|fa_eraser|
|<span class="nerdfont big">&#xf2d7;</span>|fa_etsy|
|<span class="nerdfont big">&#xf153;</span>|fa_eur|
|<span class="nerdfont big">&#xf0ec;</span>|fa_exchange|
|<span class="nerdfont big">&#xf12a;</span>|fa_exclamation|
|<span class="nerdfont big">&#xf06a;</span>|fa_exclamation_circle|
|<span class="nerdfont big">&#xf071;</span>|fa_exclamation_triangle|
|<span class="nerdfont big">&#xf065;</span>|fa_expand|
|<span class="nerdfont big">&#xf23e;</span>|fa_expeditedssl|
|<span class="nerdfont big">&#xf08e;</span>|fa_external_link|
|<span class="nerdfont big">&#xf14c;</span>|fa_external_link_square|
|<span class="nerdfont big">&#xf06e;</span>|fa_eye|
|<span class="nerdfont big">&#xf070;</span>|fa_eye_slash|
|<span class="nerdfont big">&#xf1fb;</span>|fa_eyedropper|
|<span class="nerdfont big">&#xf09a;</span>|fa_facebook|
|<span class="nerdfont big">&#xf230;</span>|fa_facebook_official|
|<span class="nerdfont big">&#xf082;</span>|fa_facebook_square|
|<span class="nerdfont big">&#xf049;</span>|fa_fast_backward|
|<span class="nerdfont big">&#xf050;</span>|fa_fast_forward|
|<span class="nerdfont big">&#xf1ac;</span>|fa_fax|
|<span class="nerdfont big">&#xf182;</span>|fa_female|
|<span class="nerdfont big">&#xf0fb;</span>|fa_fighter_jet|
|<span class="nerdfont big">&#xf15b;</span>|fa_file|
|<span class="nerdfont big">&#xf1c6;</span>|fa_file_archive_o|
|<span class="nerdfont big">&#xf1c7;</span>|fa_file_audio_o|
|<span class="nerdfont big">&#xf1c9;</span>|fa_file_code_o|
|<span class="nerdfont big">&#xf1c3;</span>|fa_file_excel_o|
|<span class="nerdfont big">&#xf1c5;</span>|fa_file_image_o|
|<span class="nerdfont big">&#xf016;</span>|fa_file_o|
|<span class="nerdfont big">&#xf1c1;</span>|fa_file_pdf_o|
|<span class="nerdfont big">&#xf1c4;</span>|fa_file_powerpoint_o|
|<span class="nerdfont big">&#xf15c;</span>|fa_file_text|
|<span class="nerdfont big">&#xf0f6;</span>|fa_file_text_o|
|<span class="nerdfont big">&#xf1c8;</span>|fa_file_video_o|
|<span class="nerdfont big">&#xf1c2;</span>|fa_file_word_o|
|<span class="nerdfont big">&#xf0c5;</span>|fa_files_o|
|<span class="nerdfont big">&#xf008;</span>|fa_film|
|<span class="nerdfont big">&#xf0b0;</span>|fa_filter|
|<span class="nerdfont big">&#xf06d;</span>|fa_fire|
|<span class="nerdfont big">&#xf134;</span>|fa_fire_extinguisher|
|<span class="nerdfont big">&#xf269;</span>|fa_firefox|
|<span class="nerdfont big">&#xf2b0;</span>|fa_first_order|
|<span class="nerdfont big">&#xf024;</span>|fa_flag|
|<span class="nerdfont big">&#xf11e;</span>|fa_flag_checkered|
|<span class="nerdfont big">&#xf11d;</span>|fa_flag_o|
|<span class="nerdfont big">&#xf0c3;</span>|fa_flask|
|<span class="nerdfont big">&#xf16e;</span>|fa_flickr|
|<span class="nerdfont big">&#xf0c7;</span>|fa_floppy_o|
|<span class="nerdfont big">&#xf07b;</span>|fa_folder|
|<span class="nerdfont big">&#xf114;</span>|fa_folder_o|
|<span class="nerdfont big">&#xf07c;</span>|fa_folder_open|
|<span class="nerdfont big">&#xf115;</span>|fa_folder_open_o|
|<span class="nerdfont big">&#xf031;</span>|fa_font|
|<span class="nerdfont big">&#xf2b4;</span>|fa_font_awesome|
|<span class="nerdfont big">&#xf280;</span>|fa_fonticons|
|<span class="nerdfont big">&#xf286;</span>|fa_fort_awesome|
|<span class="nerdfont big">&#xf211;</span>|fa_forumbee|
|<span class="nerdfont big">&#xf04e;</span>|fa_forward|
|<span class="nerdfont big">&#xf180;</span>|fa_foursquare|
|<span class="nerdfont big">&#xf2c5;</span>|fa_free_code_camp|
|<span class="nerdfont big">&#xf119;</span>|fa_frown_o|
|<span class="nerdfont big">&#xf1e3;</span>|fa_futbol_o|
|<span class="nerdfont big">&#xf11b;</span>|fa_gamepad|
|<span class="nerdfont big">&#xf0e3;</span>|fa_gavel|
|<span class="nerdfont big">&#xf154;</span>|fa_gbp|
|<span class="nerdfont big">&#xf22d;</span>|fa_genderless|
|<span class="nerdfont big">&#xf265;</span>|fa_get_pocket|
|<span class="nerdfont big">&#xf260;</span>|fa_gg|
|<span class="nerdfont big">&#xf261;</span>|fa_gg_circle|
|<span class="nerdfont big">&#xf06b;</span>|fa_gift|
|<span class="nerdfont big">&#xf1d3;</span>|fa_git|
|<span class="nerdfont big">&#xf1d2;</span>|fa_git_square|
|<span class="nerdfont big">&#xf09b;</span>|fa_github|
|<span class="nerdfont big">&#xf113;</span>|fa_github_alt|
|<span class="nerdfont big">&#xf092;</span>|fa_github_square|
|<span class="nerdfont big">&#xf296;</span>|fa_gitlab|
|<span class="nerdfont big">&#xf000;</span>|fa_glass|
|<span class="nerdfont big">&#xf2a5;</span>|fa_glide|
|<span class="nerdfont big">&#xf2a6;</span>|fa_glide_g|
|<span class="nerdfont big">&#xf0ac;</span>|fa_globe|
|<span class="nerdfont big">&#xf1a0;</span>|fa_google|
|<span class="nerdfont big">&#xf0d5;</span>|fa_google_plus|
|<span class="nerdfont big">&#xf2b3;</span>|fa_google_plus_official|
|<span class="nerdfont big">&#xf0d4;</span>|fa_google_plus_square|
|<span class="nerdfont big">&#xf1ee;</span>|fa_google_wallet|
|<span class="nerdfont big">&#xf19d;</span>|fa_graduation_cap|
|<span class="nerdfont big">&#xf184;</span>|fa_gratipay|
|<span class="nerdfont big">&#xf2d6;</span>|fa_grav|
|<span class="nerdfont big">&#xf0fd;</span>|fa_h_square|
|<span class="nerdfont big">&#xf1d4;</span>|fa_hacker_news|
|<span class="nerdfont big">&#xf258;</span>|fa_hand_lizard_o|
|<span class="nerdfont big">&#xf0a7;</span>|fa_hand_o_down|
|<span class="nerdfont big">&#xf0a5;</span>|fa_hand_o_left|
|<span class="nerdfont big">&#xf0a4;</span>|fa_hand_o_right|
|<span class="nerdfont big">&#xf0a6;</span>|fa_hand_o_up|
|<span class="nerdfont big">&#xf256;</span>|fa_hand_paper_o|
|<span class="nerdfont big">&#xf25b;</span>|fa_hand_peace_o|
|<span class="nerdfont big">&#xf25a;</span>|fa_hand_pointer_o|
|<span class="nerdfont big">&#xf255;</span>|fa_hand_rock_o|
|<span class="nerdfont big">&#xf257;</span>|fa_hand_scissors_o|
|<span class="nerdfont big">&#xf259;</span>|fa_hand_spock_o|
|<span class="nerdfont big">&#xf2b5;</span>|fa_handshake_o|
|<span class="nerdfont big">&#xf292;</span>|fa_hashtag|
|<span class="nerdfont big">&#xf0a0;</span>|fa_hdd_o|
|<span class="nerdfont big">&#xf1dc;</span>|fa_header|
|<span class="nerdfont big">&#xf025;</span>|fa_headphones|
|<span class="nerdfont big">&#xf004;</span>|fa_heart|
|<span class="nerdfont big">&#xf08a;</span>|fa_heart_o|
|<span class="nerdfont big">&#xf21e;</span>|fa_heartbeat|
|<span class="nerdfont big">&#xf1da;</span>|fa_history|
|<span class="nerdfont big">&#xf015;</span>|fa_home|
|<span class="nerdfont big">&#xf0f8;</span>|fa_hospital_o|
|<span class="nerdfont big">&#xf254;</span>|fa_hourglass|
|<span class="nerdfont big">&#xf253;</span>|fa_hourglass_end|
|<span class="nerdfont big">&#xf252;</span>|fa_hourglass_half|
|<span class="nerdfont big">&#xf250;</span>|fa_hourglass_o|
|<span class="nerdfont big">&#xf251;</span>|fa_hourglass_start|
|<span class="nerdfont big">&#xf27c;</span>|fa_houzz|
|<span class="nerdfont big">&#xf13b;</span>|fa_html5|
|<span class="nerdfont big">&#xf246;</span>|fa_i_cursor|
|<span class="nerdfont big">&#xf2c1;</span>|fa_id_badge|
|<span class="nerdfont big">&#xf2c2;</span>|fa_id_card|
|<span class="nerdfont big">&#xf2c3;</span>|fa_id_card_o|
|<span class="nerdfont big">&#xf20b;</span>|fa_ils|
|<span class="nerdfont big">&#xf2d8;</span>|fa_imdb|
|<span class="nerdfont big">&#xf01c;</span>|fa_inbox|
|<span class="nerdfont big">&#xf03c;</span>|fa_indent|
|<span class="nerdfont big">&#xf275;</span>|fa_industry|
|<span class="nerdfont big">&#xf129;</span>|fa_info|
|<span class="nerdfont big">&#xf05a;</span>|fa_info_circle|
|<span class="nerdfont big">&#xf156;</span>|fa_inr|
|<span class="nerdfont big">&#xf16d;</span>|fa_instagram|
|<span class="nerdfont big">&#xf26b;</span>|fa_internet_explorer|
|<span class="nerdfont big">&#xf208;</span>|fa_ioxhost|
|<span class="nerdfont big">&#xf033;</span>|fa_italic|
|<span class="nerdfont big">&#xf1aa;</span>|fa_joomla|
|<span class="nerdfont big">&#xf157;</span>|fa_jpy|
|<span class="nerdfont big">&#xf1cc;</span>|fa_jsfiddle|
|<span class="nerdfont big">&#xf084;</span>|fa_key|
|<span class="nerdfont big">&#xf11c;</span>|fa_keyboard_o|
|<span class="nerdfont big">&#xf159;</span>|fa_krw|
|<span class="nerdfont big">&#xf1ab;</span>|fa_language|
|<span class="nerdfont big">&#xf109;</span>|fa_laptop|
|<span class="nerdfont big">&#xf202;</span>|fa_lastfm|
|<span class="nerdfont big">&#xf203;</span>|fa_lastfm_square|
|<span class="nerdfont big">&#xf06c;</span>|fa_leaf|
|<span class="nerdfont big">&#xf212;</span>|fa_leanpub|
|<span class="nerdfont big">&#xf094;</span>|fa_lemon_o|
|<span class="nerdfont big">&#xf149;</span>|fa_level_down|
|<span class="nerdfont big">&#xf148;</span>|fa_level_up|
|<span class="nerdfont big">&#xf1cd;</span>|fa_life_ring|
|<span class="nerdfont big">&#xf0eb;</span>|fa_lightbulb_o|
|<span class="nerdfont big">&#xf201;</span>|fa_line_chart|
|<span class="nerdfont big">&#xf0c1;</span>|fa_link|
|<span class="nerdfont big">&#xf0e1;</span>|fa_linkedin|
|<span class="nerdfont big">&#xf08c;</span>|fa_linkedin_square|
|<span class="nerdfont big">&#xf2b8;</span>|fa_linode|
|<span class="nerdfont big">&#xf17c;</span>|fa_linux|
|<span class="nerdfont big">&#xf03a;</span>|fa_list|
|<span class="nerdfont big">&#xf022;</span>|fa_list_alt|
|<span class="nerdfont big">&#xf0cb;</span>|fa_list_ol|
|<span class="nerdfont big">&#xf0ca;</span>|fa_list_ul|
|<span class="nerdfont big">&#xf124;</span>|fa_location_arrow|
|<span class="nerdfont big">&#xf023;</span>|fa_lock|
|<span class="nerdfont big">&#xf175;</span>|fa_long_arrow_down|
|<span class="nerdfont big">&#xf177;</span>|fa_long_arrow_left|
|<span class="nerdfont big">&#xf178;</span>|fa_long_arrow_right|
|<span class="nerdfont big">&#xf176;</span>|fa_long_arrow_up|
|<span class="nerdfont big">&#xf2a8;</span>|fa_low_vision|
|<span class="nerdfont big">&#xf0d0;</span>|fa_magic|
|<span class="nerdfont big">&#xf076;</span>|fa_magnet|
|<span class="nerdfont big">&#xf183;</span>|fa_male|
|<span class="nerdfont big">&#xf279;</span>|fa_map|
|<span class="nerdfont big">&#xf041;</span>|fa_map_marker|
|<span class="nerdfont big">&#xf278;</span>|fa_map_o|
|<span class="nerdfont big">&#xf276;</span>|fa_map_pin|
|<span class="nerdfont big">&#xf277;</span>|fa_map_signs|
|<span class="nerdfont big">&#xf222;</span>|fa_mars|
|<span class="nerdfont big">&#xf227;</span>|fa_mars_double|
|<span class="nerdfont big">&#xf229;</span>|fa_mars_stroke|
|<span class="nerdfont big">&#xf22b;</span>|fa_mars_stroke_h|
|<span class="nerdfont big">&#xf22a;</span>|fa_mars_stroke_v|
|<span class="nerdfont big">&#xf136;</span>|fa_maxcdn|
|<span class="nerdfont big">&#xf20c;</span>|fa_meanpath|
|<span class="nerdfont big">&#xf23a;</span>|fa_medium|
|<span class="nerdfont big">&#xf0fa;</span>|fa_medkit|
|<span class="nerdfont big">&#xf2e0;</span>|fa_meetup|
|<span class="nerdfont big">&#xf11a;</span>|fa_meh_o|
|<span class="nerdfont big">&#xf223;</span>|fa_mercury|
|<span class="nerdfont big">&#xf2db;</span>|fa_microchip|
|<span class="nerdfont big">&#xf130;</span>|fa_microphone|
|<span class="nerdfont big">&#xf131;</span>|fa_microphone_slash|
|<span class="nerdfont big">&#xf068;</span>|fa_minus|
|<span class="nerdfont big">&#xf056;</span>|fa_minus_circle|
|<span class="nerdfont big">&#xf146;</span>|fa_minus_square|
|<span class="nerdfont big">&#xf147;</span>|fa_minus_square_o|
|<span class="nerdfont big">&#xf289;</span>|fa_mixcloud|
|<span class="nerdfont big">&#xf10b;</span>|fa_mobile|
|<span class="nerdfont big">&#xf285;</span>|fa_modx|
|<span class="nerdfont big">&#xf0d6;</span>|fa_money|
|<span class="nerdfont big">&#xf186;</span>|fa_moon_o|
|<span class="nerdfont big">&#xf21c;</span>|fa_motorcycle|
|<span class="nerdfont big">&#xf245;</span>|fa_mouse_pointer|
|<span class="nerdfont big">&#xf001;</span>|fa_music|
|<span class="nerdfont big">&#xf22c;</span>|fa_neuter|
|<span class="nerdfont big">&#xf1ea;</span>|fa_newspaper_o|
|<span class="nerdfont big">&#xf247;</span>|fa_object_group|
|<span class="nerdfont big">&#xf248;</span>|fa_object_ungroup|
|<span class="nerdfont big">&#xf263;</span>|fa_odnoklassniki|
|<span class="nerdfont big">&#xf264;</span>|fa_odnoklassniki_square|
|<span class="nerdfont big">&#xf23d;</span>|fa_opencart|
|<span class="nerdfont big">&#xf19b;</span>|fa_openid|
|<span class="nerdfont big">&#xf26a;</span>|fa_opera|
|<span class="nerdfont big">&#xf23c;</span>|fa_optin_monster|
|<span class="nerdfont big">&#xf03b;</span>|fa_outdent|
|<span class="nerdfont big">&#xf18c;</span>|fa_pagelines|
|<span class="nerdfont big">&#xf1fc;</span>|fa_paint_brush|
|<span class="nerdfont big">&#xf1d8;</span>|fa_paper_plane|
|<span class="nerdfont big">&#xf1d9;</span>|fa_paper_plane_o|
|<span class="nerdfont big">&#xf0c6;</span>|fa_paperclip|
|<span class="nerdfont big">&#xf1dd;</span>|fa_paragraph|
|<span class="nerdfont big">&#xf04c;</span>|fa_pause|
|<span class="nerdfont big">&#xf28b;</span>|fa_pause_circle|
|<span class="nerdfont big">&#xf28c;</span>|fa_pause_circle_o|
|<span class="nerdfont big">&#xf1b0;</span>|fa_paw|
|<span class="nerdfont big">&#xf1ed;</span>|fa_paypal|
|<span class="nerdfont big">&#xf040;</span>|fa_pencil|
|<span class="nerdfont big">&#xf14b;</span>|fa_pencil_square|
|<span class="nerdfont big">&#xf044;</span>|fa_pencil_square_o|
|<span class="nerdfont big">&#xf295;</span>|fa_percent|
|<span class="nerdfont big">&#xf095;</span>|fa_phone|
|<span class="nerdfont big">&#xf098;</span>|fa_phone_square|
|<span class="nerdfont big">&#xf03e;</span>|fa_picture_o|
|<span class="nerdfont big">&#xf200;</span>|fa_pie_chart|
|<span class="nerdfont big">&#xf2ae;</span>|fa_pied_piper|
|<span class="nerdfont big">&#xf1a8;</span>|fa_pied_piper_alt|
|<span class="nerdfont big">&#xf1a7;</span>|fa_pied_piper_pp|
|<span class="nerdfont big">&#xf0d2;</span>|fa_pinterest|
|<span class="nerdfont big">&#xf231;</span>|fa_pinterest_p|
|<span class="nerdfont big">&#xf0d3;</span>|fa_pinterest_square|
|<span class="nerdfont big">&#xf072;</span>|fa_plane|
|<span class="nerdfont big">&#xf04b;</span>|fa_play|
|<span class="nerdfont big">&#xf144;</span>|fa_play_circle|
|<span class="nerdfont big">&#xf01d;</span>|fa_play_circle_o|
|<span class="nerdfont big">&#xf1e6;</span>|fa_plug|
|<span class="nerdfont big">&#xf067;</span>|fa_plus|
|<span class="nerdfont big">&#xf055;</span>|fa_plus_circle|
|<span class="nerdfont big">&#xf0fe;</span>|fa_plus_square|
|<span class="nerdfont big">&#xf196;</span>|fa_plus_square_o|
|<span class="nerdfont big">&#xf2ce;</span>|fa_podcast|
|<span class="nerdfont big">&#xf011;</span>|fa_power_off|
|<span class="nerdfont big">&#xf02f;</span>|fa_print|
|<span class="nerdfont big">&#xf288;</span>|fa_product_hunt|
|<span class="nerdfont big">&#xf12e;</span>|fa_puzzle_piece|
|<span class="nerdfont big">&#xf1d6;</span>|fa_qq|
|<span class="nerdfont big">&#xf029;</span>|fa_qrcode|
|<span class="nerdfont big">&#xf128;</span>|fa_question|
|<span class="nerdfont big">&#xf059;</span>|fa_question_circle|
|<span class="nerdfont big">&#xf29c;</span>|fa_question_circle_o|
|<span class="nerdfont big">&#xf2c4;</span>|fa_quora|
|<span class="nerdfont big">&#xf10d;</span>|fa_quote_left|
|<span class="nerdfont big">&#xf10e;</span>|fa_quote_right|
|<span class="nerdfont big">&#xf074;</span>|fa_random|
|<span class="nerdfont big">&#xf2d9;</span>|fa_ravelry|
|<span class="nerdfont big">&#xf1d0;</span>|fa_rebel|
|<span class="nerdfont big">&#xf1b8;</span>|fa_recycle|
|<span class="nerdfont big">&#xf1a1;</span>|fa_reddit|
|<span class="nerdfont big">&#xf281;</span>|fa_reddit_alien|
|<span class="nerdfont big">&#xf1a2;</span>|fa_reddit_square|
|<span class="nerdfont big">&#xf021;</span>|fa_refresh|
|<span class="nerdfont big">&#xf25d;</span>|fa_registered|
|<span class="nerdfont big">&#xf18b;</span>|fa_renren|
|<span class="nerdfont big">&#xf01e;</span>|fa_repeat|
|<span class="nerdfont big">&#xf112;</span>|fa_reply|
|<span class="nerdfont big">&#xf122;</span>|fa_reply_all|
|<span class="nerdfont big">&#xf079;</span>|fa_retweet|
|<span class="nerdfont big">&#xf018;</span>|fa_road|
|<span class="nerdfont big">&#xf135;</span>|fa_rocket|
|<span class="nerdfont big">&#xf09e;</span>|fa_rss|
|<span class="nerdfont big">&#xf143;</span>|fa_rss_square|
|<span class="nerdfont big">&#xf158;</span>|fa_rub|
|<span class="nerdfont big">&#xf267;</span>|fa_safari|
|<span class="nerdfont big">&#xf0c4;</span>|fa_scissors|
|<span class="nerdfont big">&#xf28a;</span>|fa_scribd|
|<span class="nerdfont big">&#xf002;</span>|fa_search|
|<span class="nerdfont big">&#xf010;</span>|fa_search_minus|
|<span class="nerdfont big">&#xf00e;</span>|fa_search_plus|
|<span class="nerdfont big">&#xf213;</span>|fa_sellsy|
|<span class="nerdfont big">&#xf233;</span>|fa_server|
|<span class="nerdfont big">&#xf064;</span>|fa_share|
|<span class="nerdfont big">&#xf1e0;</span>|fa_share_alt|
|<span class="nerdfont big">&#xf1e1;</span>|fa_share_alt_square|
|<span class="nerdfont big">&#xf14d;</span>|fa_share_square|
|<span class="nerdfont big">&#xf045;</span>|fa_share_square_o|
|<span class="nerdfont big">&#xf132;</span>|fa_shield|
|<span class="nerdfont big">&#xf21a;</span>|fa_ship|
|<span class="nerdfont big">&#xf214;</span>|fa_shirtsinbulk|
|<span class="nerdfont big">&#xf290;</span>|fa_shopping_bag|
|<span class="nerdfont big">&#xf291;</span>|fa_shopping_basket|
|<span class="nerdfont big">&#xf07a;</span>|fa_shopping_cart|
|<span class="nerdfont big">&#xf2cc;</span>|fa_shower|
|<span class="nerdfont big">&#xf090;</span>|fa_sign_in|
|<span class="nerdfont big">&#xf2a7;</span>|fa_sign_language|
|<span class="nerdfont big">&#xf08b;</span>|fa_sign_out|
|<span class="nerdfont big">&#xf012;</span>|fa_signal|
|<span class="nerdfont big">&#xf215;</span>|fa_simplybuilt|
|<span class="nerdfont big">&#xf0e8;</span>|fa_sitemap|
|<span class="nerdfont big">&#xf216;</span>|fa_skyatlas|
|<span class="nerdfont big">&#xf17e;</span>|fa_skype|
|<span class="nerdfont big">&#xf198;</span>|fa_slack|
|<span class="nerdfont big">&#xf1de;</span>|fa_sliders|
|<span class="nerdfont big">&#xf1e7;</span>|fa_slideshare|
|<span class="nerdfont big">&#xf118;</span>|fa_smile_o|
|<span class="nerdfont big">&#xf2ab;</span>|fa_snapchat|
|<span class="nerdfont big">&#xf2ac;</span>|fa_snapchat_ghost|
|<span class="nerdfont big">&#xf2ad;</span>|fa_snapchat_square|
|<span class="nerdfont big">&#xf2dc;</span>|fa_snowflake_o|
|<span class="nerdfont big">&#xf0dc;</span>|fa_sort|
|<span class="nerdfont big">&#xf15d;</span>|fa_sort_alpha_asc|
|<span class="nerdfont big">&#xf15e;</span>|fa_sort_alpha_desc|
|<span class="nerdfont big">&#xf160;</span>|fa_sort_amount_asc|
|<span class="nerdfont big">&#xf161;</span>|fa_sort_amount_desc|
|<span class="nerdfont big">&#xf0de;</span>|fa_sort_asc|
|<span class="nerdfont big">&#xf0dd;</span>|fa_sort_desc|
|<span class="nerdfont big">&#xf162;</span>|fa_sort_numeric_asc|
|<span class="nerdfont big">&#xf163;</span>|fa_sort_numeric_desc|
|<span class="nerdfont big">&#xf1be;</span>|fa_soundcloud|
|<span class="nerdfont big">&#xf197;</span>|fa_space_shuttle|
|<span class="nerdfont big">&#xf110;</span>|fa_spinner|
|<span class="nerdfont big">&#xf1b1;</span>|fa_spoon|
|<span class="nerdfont big">&#xf1bc;</span>|fa_spotify|
|<span class="nerdfont big">&#xf0c8;</span>|fa_square|
|<span class="nerdfont big">&#xf096;</span>|fa_square_o|
|<span class="nerdfont big">&#xf18d;</span>|fa_stack_exchange|
|<span class="nerdfont big">&#xf16c;</span>|fa_stack_overflow|
|<span class="nerdfont big">&#xf005;</span>|fa_star|
|<span class="nerdfont big">&#xf089;</span>|fa_star_half|
|<span class="nerdfont big">&#xf123;</span>|fa_star_half_o|
|<span class="nerdfont big">&#xf006;</span>|fa_star_o|
|<span class="nerdfont big">&#xf1b6;</span>|fa_steam|
|<span class="nerdfont big">&#xf1b7;</span>|fa_steam_square|
|<span class="nerdfont big">&#xf048;</span>|fa_step_backward|
|<span class="nerdfont big">&#xf051;</span>|fa_step_forward|
|<span class="nerdfont big">&#xf0f1;</span>|fa_stethoscope|
|<span class="nerdfont big">&#xf249;</span>|fa_sticky_note|
|<span class="nerdfont big">&#xf24a;</span>|fa_sticky_note_o|
|<span class="nerdfont big">&#xf04d;</span>|fa_stop|
|<span class="nerdfont big">&#xf28d;</span>|fa_stop_circle|
|<span class="nerdfont big">&#xf28e;</span>|fa_stop_circle_o|
|<span class="nerdfont big">&#xf21d;</span>|fa_street_view|
|<span class="nerdfont big">&#xf0cc;</span>|fa_strikethrough|
|<span class="nerdfont big">&#xf1a4;</span>|fa_stumbleupon|
|<span class="nerdfont big">&#xf1a3;</span>|fa_stumbleupon_circle|
|<span class="nerdfont big">&#xf12c;</span>|fa_subscript|
|<span class="nerdfont big">&#xf239;</span>|fa_subway|
|<span class="nerdfont big">&#xf0f2;</span>|fa_suitcase|
|<span class="nerdfont big">&#xf185;</span>|fa_sun_o|
|<span class="nerdfont big">&#xf2dd;</span>|fa_superpowers|
|<span class="nerdfont big">&#xf12b;</span>|fa_superscript|
|<span class="nerdfont big">&#xf0ce;</span>|fa_table|
|<span class="nerdfont big">&#xf10a;</span>|fa_tablet|
|<span class="nerdfont big">&#xf0e4;</span>|fa_tachometer|
|<span class="nerdfont big">&#xf02b;</span>|fa_tag|
|<span class="nerdfont big">&#xf02c;</span>|fa_tags|
|<span class="nerdfont big">&#xf0ae;</span>|fa_tasks|
|<span class="nerdfont big">&#xf1ba;</span>|fa_taxi|
|<span class="nerdfont big">&#xf2c6;</span>|fa_telegram|
|<span class="nerdfont big">&#xf26c;</span>|fa_television|
|<span class="nerdfont big">&#xf1d5;</span>|fa_tencent_weibo|
|<span class="nerdfont big">&#xf120;</span>|fa_terminal|
|<span class="nerdfont big">&#xf034;</span>|fa_text_height|
|<span class="nerdfont big">&#xf035;</span>|fa_text_width|
|<span class="nerdfont big">&#xf00a;</span>|fa_th|
|<span class="nerdfont big">&#xf009;</span>|fa_th_large|
|<span class="nerdfont big">&#xf00b;</span>|fa_th_list|
|<span class="nerdfont big">&#xf2b2;</span>|fa_themeisle|
|<span class="nerdfont big">&#xf2cb;</span>|fa_thermometer_empty|
|<span class="nerdfont big">&#xf2c7;</span>|fa_thermometer_full|
|<span class="nerdfont big">&#xf2c9;</span>|fa_thermometer_half|
|<span class="nerdfont big">&#xf2ca;</span>|fa_thermometer_quarter|
|<span class="nerdfont big">&#xf2c8;</span>|fa_thermometer_three_quarters|
|<span class="nerdfont big">&#xf08d;</span>|fa_thumb_tack|
|<span class="nerdfont big">&#xf165;</span>|fa_thumbs_down|
|<span class="nerdfont big">&#xf088;</span>|fa_thumbs_o_down|
|<span class="nerdfont big">&#xf087;</span>|fa_thumbs_o_up|
|<span class="nerdfont big">&#xf164;</span>|fa_thumbs_up|
|<span class="nerdfont big">&#xf145;</span>|fa_ticket|
|<span class="nerdfont big">&#xf00d;</span>|fa_times|
|<span class="nerdfont big">&#xf057;</span>|fa_times_circle|
|<span class="nerdfont big">&#xf05c;</span>|fa_times_circle_o|
|<span class="nerdfont big">&#xf043;</span>|fa_tint|
|<span class="nerdfont big">&#xf204;</span>|fa_toggle_off|
|<span class="nerdfont big">&#xf205;</span>|fa_toggle_on|
|<span class="nerdfont big">&#xf25c;</span>|fa_trademark|
|<span class="nerdfont big">&#xf238;</span>|fa_train|
|<span class="nerdfont big">&#xf224;</span>|fa_transgender|
|<span class="nerdfont big">&#xf225;</span>|fa_transgender_alt|
|<span class="nerdfont big">&#xf1f8;</span>|fa_trash|
|<span class="nerdfont big">&#xf014;</span>|fa_trash_o|
|<span class="nerdfont big">&#xf1bb;</span>|fa_tree|
|<span class="nerdfont big">&#xf181;</span>|fa_trello|
|<span class="nerdfont big">&#xf262;</span>|fa_tripadvisor|
|<span class="nerdfont big">&#xf091;</span>|fa_trophy|
|<span class="nerdfont big">&#xf0d1;</span>|fa_truck|
|<span class="nerdfont big">&#xf195;</span>|fa_try|
|<span class="nerdfont big">&#xf1e4;</span>|fa_tty|
|<span class="nerdfont big">&#xf173;</span>|fa_tumblr|
|<span class="nerdfont big">&#xf174;</span>|fa_tumblr_square|
|<span class="nerdfont big">&#xf1e8;</span>|fa_twitch|
|<span class="nerdfont big">&#xf099;</span>|fa_twitter|
|<span class="nerdfont big">&#xf081;</span>|fa_twitter_square|
|<span class="nerdfont big">&#xf0e9;</span>|fa_umbrella|
|<span class="nerdfont big">&#xf0cd;</span>|fa_underline|
|<span class="nerdfont big">&#xf0e2;</span>|fa_undo|
|<span class="nerdfont big">&#xf29a;</span>|fa_universal_access|
|<span class="nerdfont big">&#xf19c;</span>|fa_university|
|<span class="nerdfont big">&#xf09c;</span>|fa_unlock|
|<span class="nerdfont big">&#xf13e;</span>|fa_unlock_alt|
|<span class="nerdfont big">&#xf093;</span>|fa_upload|
|<span class="nerdfont big">&#xf287;</span>|fa_usb|
|<span class="nerdfont big">&#xf155;</span>|fa_usd|
|<span class="nerdfont big">&#xf007;</span>|fa_user|
|<span class="nerdfont big">&#xf2bd;</span>|fa_user_circle|
|<span class="nerdfont big">&#xf2be;</span>|fa_user_circle_o|
|<span class="nerdfont big">&#xf0f0;</span>|fa_user_md|
|<span class="nerdfont big">&#xf2c0;</span>|fa_user_o|
|<span class="nerdfont big">&#xf234;</span>|fa_user_plus|
|<span class="nerdfont big">&#xf21b;</span>|fa_user_secret|
|<span class="nerdfont big">&#xf235;</span>|fa_user_times|
|<span class="nerdfont big">&#xf0c0;</span>|fa_users|
|<span class="nerdfont big">&#xf221;</span>|fa_venus|
|<span class="nerdfont big">&#xf226;</span>|fa_venus_double|
|<span class="nerdfont big">&#xf228;</span>|fa_venus_mars|
|<span class="nerdfont big">&#xf237;</span>|fa_viacoin|
|<span class="nerdfont big">&#xf2a9;</span>|fa_viadeo|
|<span class="nerdfont big">&#xf2aa;</span>|fa_viadeo_square|
|<span class="nerdfont big">&#xf03d;</span>|fa_video_camera|
|<span class="nerdfont big">&#xf27d;</span>|fa_vimeo|
|<span class="nerdfont big">&#xf194;</span>|fa_vimeo_square|
|<span class="nerdfont big">&#xf1ca;</span>|fa_vine|
|<span class="nerdfont big">&#xf189;</span>|fa_vk|
|<span class="nerdfont big">&#xf2a0;</span>|fa_volume_control_phone|
|<span class="nerdfont big">&#xf027;</span>|fa_volume_down|
|<span class="nerdfont big">&#xf026;</span>|fa_volume_off|
|<span class="nerdfont big">&#xf028;</span>|fa_volume_up|
|<span class="nerdfont big">&#xf18a;</span>|fa_weibo|
|<span class="nerdfont big">&#xf1d7;</span>|fa_weixin|
|<span class="nerdfont big">&#xf232;</span>|fa_whatsapp|
|<span class="nerdfont big">&#xf193;</span>|fa_wheelchair|
|<span class="nerdfont big">&#xf29b;</span>|fa_wheelchair_alt|
|<span class="nerdfont big">&#xf1eb;</span>|fa_wifi|
|<span class="nerdfont big">&#xf266;</span>|fa_wikipedia_w|
|<span class="nerdfont big">&#xf2d3;</span>|fa_window_close|
|<span class="nerdfont big">&#xf2d4;</span>|fa_window_close_o|
|<span class="nerdfont big">&#xf2d0;</span>|fa_window_maximize|
|<span class="nerdfont big">&#xf2d1;</span>|fa_window_minimize|
|<span class="nerdfont big">&#xf2d2;</span>|fa_window_restore|
|<span class="nerdfont big">&#xf17a;</span>|fa_windows|
|<span class="nerdfont big">&#xf19a;</span>|fa_wordpress|
|<span class="nerdfont big">&#xf297;</span>|fa_wpbeginner|
|<span class="nerdfont big">&#xf2de;</span>|fa_wpexplorer|
|<span class="nerdfont big">&#xf298;</span>|fa_wpforms|
|<span class="nerdfont big">&#xf0ad;</span>|fa_wrench|
|<span class="nerdfont big">&#xf168;</span>|fa_xing|
|<span class="nerdfont big">&#xf169;</span>|fa_xing_square|
|<span class="nerdfont big">&#xf23b;</span>|fa_y_combinator|
|<span class="nerdfont big">&#xf19e;</span>|fa_yahoo|
|<span class="nerdfont big">&#xf1e9;</span>|fa_yelp|
|<span class="nerdfont big">&#xf2b1;</span>|fa_yoast|
|<span class="nerdfont big">&#xf167;</span>|fa_youtube|
|<span class="nerdfont big">&#xf16a;</span>|fa_youtube_play|
|<span class="nerdfont big">&#xf166;</span>|fa_youtube_square|
|<span class="nerdfont big">&#xe29e;</span>|fae_apple_fruit|
|<span class="nerdfont big">&#xe27f;</span>|fae_atom|
|<span class="nerdfont big">&#xe280;</span>|fae_bacteria|
|<span class="nerdfont big">&#xe281;</span>|fae_banana|
|<span class="nerdfont big">&#xe282;</span>|fae_bath|
|<span class="nerdfont big">&#xe283;</span>|fae_bed|
|<span class="nerdfont big">&#xe284;</span>|fae_benzene|
|<span class="nerdfont big">&#xe285;</span>|fae_bigger|
|<span class="nerdfont big">&#xe286;</span>|fae_biohazard|
|<span class="nerdfont big">&#xe287;</span>|fae_blogger_circle|
|<span class="nerdfont big">&#xe288;</span>|fae_blogger_square|
|<span class="nerdfont big">&#xe289;</span>|fae_bones|
|<span class="nerdfont big">&#xe28a;</span>|fae_book_open|
|<span class="nerdfont big">&#xe28b;</span>|fae_book_open_o|
|<span class="nerdfont big">&#xe28c;</span>|fae_brain|
|<span class="nerdfont big">&#xe28d;</span>|fae_bread|
|<span class="nerdfont big">&#xe28e;</span>|fae_butterfly|
|<span class="nerdfont big">&#xe28f;</span>|fae_carot|
|<span class="nerdfont big">&#xe290;</span>|fae_cc_by|
|<span class="nerdfont big">&#xe291;</span>|fae_cc_cc|
|<span class="nerdfont big">&#xe292;</span>|fae_cc_nc|
|<span class="nerdfont big">&#xe293;</span>|fae_cc_nc_eu|
|<span class="nerdfont big">&#xe294;</span>|fae_cc_nc_jp|
|<span class="nerdfont big">&#xe295;</span>|fae_cc_nd|
|<span class="nerdfont big">&#xe296;</span>|fae_cc_remix|
|<span class="nerdfont big">&#xe297;</span>|fae_cc_sa|
|<span class="nerdfont big">&#xe298;</span>|fae_cc_share|
|<span class="nerdfont big">&#xe299;</span>|fae_cc_zero|
|<span class="nerdfont big">&#xe29a;</span>|fae_checklist_o|
|<span class="nerdfont big">&#xe264;</span>|fae_cheese|
|<span class="nerdfont big">&#xe29b;</span>|fae_cherry|
|<span class="nerdfont big">&#xe29c;</span>|fae_chess_bishop|
|<span class="nerdfont big">&#xe25f;</span>|fae_chess_horse|
|<span class="nerdfont big">&#xe260;</span>|fae_chess_king|
|<span class="nerdfont big">&#xe261;</span>|fae_chess_pawn|
|<span class="nerdfont big">&#xe262;</span>|fae_chess_queen|
|<span class="nerdfont big">&#xe263;</span>|fae_chess_tower|
|<span class="nerdfont big">&#xe29f;</span>|fae_chicken_thigh|
|<span class="nerdfont big">&#xe265;</span>|fae_chilli|
|<span class="nerdfont big">&#xe266;</span>|fae_chip|
|<span class="nerdfont big">&#xe267;</span>|fae_cicling|
|<span class="nerdfont big">&#xe268;</span>|fae_cloud|
|<span class="nerdfont big">&#xe269;</span>|fae_cockroach|
|<span class="nerdfont big">&#xe26a;</span>|fae_coffe_beans|
|<span class="nerdfont big">&#xe26b;</span>|fae_coins|
|<span class="nerdfont big">&#xe26c;</span>|fae_comb|
|<span class="nerdfont big">&#xe26d;</span>|fae_comet|
|<span class="nerdfont big">&#xe26e;</span>|fae_crown|
|<span class="nerdfont big">&#xe26f;</span>|fae_cup_coffe|
|<span class="nerdfont big">&#xe270;</span>|fae_dice|
|<span class="nerdfont big">&#xe271;</span>|fae_disco|
|<span class="nerdfont big">&#xe272;</span>|fae_dna|
|<span class="nerdfont big">&#xe273;</span>|fae_donut|
|<span class="nerdfont big">&#xe274;</span>|fae_dress|
|<span class="nerdfont big">&#xe275;</span>|fae_drop|
|<span class="nerdfont big">&#xe276;</span>|fae_ello|
|<span class="nerdfont big">&#xe277;</span>|fae_envelope_open|
|<span class="nerdfont big">&#xe278;</span>|fae_envelope_open_o|
|<span class="nerdfont big">&#xe279;</span>|fae_equal|
|<span class="nerdfont big">&#xe27a;</span>|fae_equal_bigger|
|<span class="nerdfont big">&#xe27b;</span>|fae_feedly|
|<span class="nerdfont big">&#xe27c;</span>|fae_file_export|
|<span class="nerdfont big">&#xe27d;</span>|fae_file_import|
|<span class="nerdfont big">&#xe23f;</span>|fae_fingerprint|
|<span class="nerdfont big">&#xe240;</span>|fae_floppy|
|<span class="nerdfont big">&#xe241;</span>|fae_footprint|
|<span class="nerdfont big">&#xe242;</span>|fae_freecodecamp|
|<span class="nerdfont big">&#xe243;</span>|fae_galaxy|
|<span class="nerdfont big">&#xe244;</span>|fae_galery|
|<span class="nerdfont big">&#xe2a0;</span>|fae_gift_card|
|<span class="nerdfont big">&#xe245;</span>|fae_glass|
|<span class="nerdfont big">&#xe246;</span>|fae_google_drive|
|<span class="nerdfont big">&#xe247;</span>|fae_google_play|
|<span class="nerdfont big">&#xe248;</span>|fae_gps|
|<span class="nerdfont big">&#xe249;</span>|fae_grav|
|<span class="nerdfont big">&#xe24a;</span>|fae_guitar|
|<span class="nerdfont big">&#xe24b;</span>|fae_gut|
|<span class="nerdfont big">&#xe24c;</span>|fae_halter|
|<span class="nerdfont big">&#xe24d;</span>|fae_hamburger|
|<span class="nerdfont big">&#xe24e;</span>|fae_hat|
|<span class="nerdfont big">&#xe24f;</span>|fae_hexagon|
|<span class="nerdfont big">&#xe250;</span>|fae_high_heel|
|<span class="nerdfont big">&#xe251;</span>|fae_hotdog|
|<span class="nerdfont big">&#xe252;</span>|fae_ice_cream|
|<span class="nerdfont big">&#xe253;</span>|fae_id_card|
|<span class="nerdfont big">&#xe254;</span>|fae_imdb|
|<span class="nerdfont big">&#xe255;</span>|fae_infinity|
|<span class="nerdfont big">&#xe2a1;</span>|fae_injection|
|<span class="nerdfont big">&#xe2a2;</span>|fae_isle|
|<span class="nerdfont big">&#xe256;</span>|fae_java|
|<span class="nerdfont big">&#xe257;</span>|fae_layers|
|<span class="nerdfont big">&#xe258;</span>|fae_lips|
|<span class="nerdfont big">&#xe259;</span>|fae_lipstick|
|<span class="nerdfont big">&#xe25a;</span>|fae_liver|
|<span class="nerdfont big">&#xe2a3;</span>|fae_lollipop|
|<span class="nerdfont big">&#xe2a4;</span>|fae_loyalty_card|
|<span class="nerdfont big">&#xe25b;</span>|fae_lung|
|<span class="nerdfont big">&#xe25c;</span>|fae_makeup_brushes|
|<span class="nerdfont big">&#xe25d;</span>|fae_maximize|
|<span class="nerdfont big">&#xe2a5;</span>|fae_meat|
|<span class="nerdfont big">&#xe221;</span>|fae_medicine|
|<span class="nerdfont big">&#xe222;</span>|fae_microscope|
|<span class="nerdfont big">&#xe223;</span>|fae_milk_bottle|
|<span class="nerdfont big">&#xe224;</span>|fae_minimize|
|<span class="nerdfont big">&#xe225;</span>|fae_molecule|
|<span class="nerdfont big">&#xe226;</span>|fae_moon_cloud|
|<span class="nerdfont big">&#xe2a6;</span>|fae_mountains|
|<span class="nerdfont big">&#xe227;</span>|fae_mushroom|
|<span class="nerdfont big">&#xe228;</span>|fae_mustache|
|<span class="nerdfont big">&#xe229;</span>|fae_mysql|
|<span class="nerdfont big">&#xe22a;</span>|fae_nintendo|
|<span class="nerdfont big">&#xe2a7;</span>|fae_orange|
|<span class="nerdfont big">&#xe22b;</span>|fae_palette_color|
|<span class="nerdfont big">&#xe2a8;</span>|fae_peach|
|<span class="nerdfont big">&#xe2a9;</span>|fae_pear|
|<span class="nerdfont big">&#xe22c;</span>|fae_pi|
|<span class="nerdfont big">&#xe22d;</span>|fae_pizza|
|<span class="nerdfont big">&#xe22e;</span>|fae_planet|
|<span class="nerdfont big">&#xe22f;</span>|fae_plant|
|<span class="nerdfont big">&#xe230;</span>|fae_playstation|
|<span class="nerdfont big">&#xe231;</span>|fae_poison|
|<span class="nerdfont big">&#xe232;</span>|fae_popcorn|
|<span class="nerdfont big">&#xe233;</span>|fae_popsicle|
|<span class="nerdfont big">&#xe234;</span>|fae_pulse|
|<span class="nerdfont big">&#xe235;</span>|fae_python|
|<span class="nerdfont big">&#xe236;</span>|fae_quora_circle|
|<span class="nerdfont big">&#xe237;</span>|fae_quora_square|
|<span class="nerdfont big">&#xe238;</span>|fae_radioactive|
|<span class="nerdfont big">&#xe239;</span>|fae_raining|
|<span class="nerdfont big">&#xe23a;</span>|fae_real_heart|
|<span class="nerdfont big">&#xe23b;</span>|fae_refrigerator|
|<span class="nerdfont big">&#xe23c;</span>|fae_restore|
|<span class="nerdfont big">&#xe23d;</span>|fae_ring|
|<span class="nerdfont big">&#xe23e;</span>|fae_ruby|
|<span class="nerdfont big">&#xe21e;</span>|fae_ruby_o|
|<span class="nerdfont big">&#xe21f;</span>|fae_ruler|
|<span class="nerdfont big">&#xe218;</span>|fae_shirt|
|<span class="nerdfont big">&#xe216;</span>|fae_slash|
|<span class="nerdfont big">&#xe200;</span>|fae_smaller|
|<span class="nerdfont big">&#xe201;</span>|fae_snowing|
|<span class="nerdfont big">&#xe202;</span>|fae_soda|
|<span class="nerdfont big">&#xe203;</span>|fae_sofa|
|<span class="nerdfont big">&#xe204;</span>|fae_soup|
|<span class="nerdfont big">&#xe205;</span>|fae_spermatozoon|
|<span class="nerdfont big">&#xe206;</span>|fae_spin_double|
|<span class="nerdfont big">&#xe207;</span>|fae_stomach|
|<span class="nerdfont big">&#xe208;</span>|fae_storm|
|<span class="nerdfont big">&#xe21d;</span>|fae_sun_cloud|
|<span class="nerdfont big">&#xe21a;</span>|fae_sushi|
|<span class="nerdfont big">&#xe219;</span>|fae_tacos|
|<span class="nerdfont big">&#xe217;</span>|fae_telegram|
|<span class="nerdfont big">&#xe215;</span>|fae_telegram_circle|
|<span class="nerdfont big">&#xe209;</span>|fae_telescope|
|<span class="nerdfont big">&#xe20a;</span>|fae_thermometer|
|<span class="nerdfont big">&#xe20b;</span>|fae_thermometer_high|
|<span class="nerdfont big">&#xe20c;</span>|fae_thermometer_low|
|<span class="nerdfont big">&#xe20d;</span>|fae_thin_close|
|<span class="nerdfont big">&#xe20e;</span>|fae_toilet|
|<span class="nerdfont big">&#xe20f;</span>|fae_tools|
|<span class="nerdfont big">&#xe210;</span>|fae_tooth|
|<span class="nerdfont big">&#xe21c;</span>|fae_tree|
|<span class="nerdfont big">&#xe21b;</span>|fae_triangle_ruler|
|<span class="nerdfont big">&#xe220;</span>|fae_umbrella|
|<span class="nerdfont big">&#xe211;</span>|fae_uterus|
|<span class="nerdfont big">&#xe214;</span>|fae_virus|
|<span class="nerdfont big">&#xe212;</span>|fae_w3c|
|<span class="nerdfont big">&#xe213;</span>|fae_walking|
|<span class="nerdfont big">&#xe25e;</span>|fae_wallet|
|<span class="nerdfont big">&#xe27e;</span>|fae_wind|
|<span class="nerdfont big">&#xe29d;</span>|fae_xbox|
|<span class="nerdfont big">&#x23fb;</span>|iec_power|
|<span class="nerdfont big">&#x2b58;</span>|iec_power_off|
|<span class="nerdfont big">&#x23fd;</span>|iec_power_on|
|<span class="nerdfont big">&#x23fe;</span>|iec_sleep_mode|
|<span class="nerdfont big">&#x23fc;</span>|iec_toggle_power|
|<span class="nerdfont big">&#xe621;</span>|indent_line|
|<span class="nerdfont big">&#xf31d;</span>|linux_almalinux|
|<span class="nerdfont big">&#xf300;</span>|linux_alpine|
|<span class="nerdfont big">&#xf301;</span>|linux_aosc|
|<span class="nerdfont big">&#xf302;</span>|linux_apple|
|<span class="nerdfont big">&#xf345;</span>|linux_archcraft|
|<span class="nerdfont big">&#xf31e;</span>|linux_archlabs|
|<span class="nerdfont big">&#xf303;</span>|linux_archlinux|
|<span class="nerdfont big">&#xf346;</span>|linux_arcolinux|
|<span class="nerdfont big">&#xf34b;</span>|linux_arduino|
|<span class="nerdfont big">&#xf31f;</span>|linux_artix|
|<span class="nerdfont big">&#xf354;</span>|linux_awesome|
|<span class="nerdfont big">&#xf347;</span>|linux_biglinux|
|<span class="nerdfont big">&#xf355;</span>|linux_bspwm|
|<span class="nerdfont big">&#xf320;</span>|linux_budgie|
|<span class="nerdfont big">&#xf304;</span>|linux_centos|
|<span class="nerdfont big">&#xf35f;</span>|linux_cinnamon|
|<span class="nerdfont big">&#xf330;</span>|linux_codeberg|
|<span class="nerdfont big">&#xf305;</span>|linux_coreos|
|<span class="nerdfont big">&#xf348;</span>|linux_crystal|
|<span class="nerdfont big">&#xf306;</span>|linux_debian|
|<span class="nerdfont big">&#xf321;</span>|linux_deepin|
|<span class="nerdfont big">&#xf307;</span>|linux_devuan|
|<span class="nerdfont big">&#xf308;</span>|linux_docker|
|<span class="nerdfont big">&#xf356;</span>|linux_dwm|
|<span class="nerdfont big">&#xf309;</span>|linux_elementary|
|<span class="nerdfont big">&#xf322;</span>|linux_endeavour|
|<span class="nerdfont big">&#xf357;</span>|linux_enlightenment|
|<span class="nerdfont big">&#xf36a;</span>|linux_fdroid|
|<span class="nerdfont big">&#xf30a;</span>|linux_fedora|
|<span class="nerdfont big">&#xf30b;</span>|linux_fedora_inverse|
|<span class="nerdfont big">&#xf323;</span>|linux_ferris|
|<span class="nerdfont big">&#xf324;</span>|linux_flathub|
|<span class="nerdfont big">&#xf358;</span>|linux_fluxbox|
|<span class="nerdfont big">&#xf335;</span>|linux_forgejo|
|<span class="nerdfont big">&#xf36b;</span>|linux_fosdem|
|<span class="nerdfont big">&#xf30c;</span>|linux_freebsd|
|<span class="nerdfont big">&#xf336;</span>|linux_freecad|
|<span class="nerdfont big">&#xf360;</span>|linux_freedesktop|
|<span class="nerdfont big">&#xf337;</span>|linux_garuda|
|<span class="nerdfont big">&#xf30d;</span>|linux_gentoo|
|<span class="nerdfont big">&#xf338;</span>|linux_gimp|
|<span class="nerdfont big">&#xf339;</span>|linux_gitea|
|<span class="nerdfont big">&#xf361;</span>|linux_gnome|
|<span class="nerdfont big">&#xf325;</span>|linux_gnu_guix|
|<span class="nerdfont big">&#xf362;</span>|linux_gtk|
|<span class="nerdfont big">&#xf33a;</span>|linux_hyperbola|
|<span class="nerdfont big">&#xf359;</span>|linux_hyprland|
|<span class="nerdfont big">&#xf35a;</span>|linux_i3|
|<span class="nerdfont big">&#xf326;</span>|linux_illumos|
|<span class="nerdfont big">&#xf33b;</span>|linux_inkscape|
|<span class="nerdfont big">&#xf35b;</span>|linux_jwm|
|<span class="nerdfont big">&#xf327;</span>|linux_kali_linux|
|<span class="nerdfont big">&#xf331;</span>|linux_kde_neon|
|<span class="nerdfont big">&#xf332;</span>|linux_kde_plasma|
|<span class="nerdfont big">&#xf33c;</span>|linux_kdenlive|
|<span class="nerdfont big">&#xf34c;</span>|linux_kicad|
|<span class="nerdfont big">&#xf33d;</span>|linux_krita|
|<span class="nerdfont big">&#xf333;</span>|linux_kubuntu|
|<span class="nerdfont big">&#xf334;</span>|linux_kubuntu_inverse|
|<span class="nerdfont big">&#xf30e;</span>|linux_linuxmint|
|<span class="nerdfont big">&#xf30f;</span>|linux_linuxmint_inverse|
|<span class="nerdfont big">&#xf349;</span>|linux_locos|
|<span class="nerdfont big">&#xf363;</span>|linux_lxde|
|<span class="nerdfont big">&#xf33e;</span>|linux_lxle|
|<span class="nerdfont big">&#xf364;</span>|linux_lxqt|
|<span class="nerdfont big">&#xf310;</span>|linux_mageia|
|<span class="nerdfont big">&#xf311;</span>|linux_mandriva|
|<span class="nerdfont big">&#xf312;</span>|linux_manjaro|
|<span class="nerdfont big">&#xf365;</span>|linux_mate|
|<span class="nerdfont big">&#xf36e;</span>|linux_mpv|
|<span class="nerdfont big">&#xf33f;</span>|linux_mxlinux|
|<span class="nerdfont big">&#xf36f;</span>|linux_neovim|
|<span class="nerdfont big">&#xf313;</span>|linux_nixos|
|<span class="nerdfont big">&#xf34d;</span>|linux_octoprint|
|<span class="nerdfont big">&#xf328;</span>|linux_openbsd|
|<span class="nerdfont big">&#xf34e;</span>|linux_openscad|
|<span class="nerdfont big">&#xf314;</span>|linux_opensuse|
|<span class="nerdfont big">&#xf34f;</span>|linux_osh|
|<span class="nerdfont big">&#xf350;</span>|linux_oshwa|
|<span class="nerdfont big">&#xf36c;</span>|linux_osi|
|<span class="nerdfont big">&#xf340;</span>|linux_parabola|
|<span class="nerdfont big">&#xf329;</span>|linux_parrot|
|<span class="nerdfont big">&#xf32a;</span>|linux_pop_os|
|<span class="nerdfont big">&#xf351;</span>|linux_prusaslicer|
|<span class="nerdfont big">&#xf341;</span>|linux_puppy|
|<span class="nerdfont big">&#xf35c;</span>|linux_qtile|
|<span class="nerdfont big">&#xf342;</span>|linux_qubesos|
|<span class="nerdfont big">&#xf315;</span>|linux_raspberry_pi|
|<span class="nerdfont big">&#xf316;</span>|linux_redhat|
|<span class="nerdfont big">&#xf352;</span>|linux_reprap|
|<span class="nerdfont big">&#xf353;</span>|linux_riscv|
|<span class="nerdfont big">&#xf32b;</span>|linux_rocky_linux|
|<span class="nerdfont big">&#xf317;</span>|linux_sabayon|
|<span class="nerdfont big">&#xf318;</span>|linux_slackware|
|<span class="nerdfont big">&#xf319;</span>|linux_slackware_inverse|
|<span class="nerdfont big">&#xf32c;</span>|linux_snappy|
|<span class="nerdfont big">&#xf32d;</span>|linux_solus|
|<span class="nerdfont big">&#xf35d;</span>|linux_sway|
|<span class="nerdfont big">&#xf343;</span>|linux_tails|
|<span class="nerdfont big">&#xf370;</span>|linux_thunderbird|
|<span class="nerdfont big">&#xf371;</span>|linux_tor|
|<span class="nerdfont big">&#xf344;</span>|linux_trisquel|
|<span class="nerdfont big">&#xf31a;</span>|linux_tux|
|<span class="nerdfont big">&#xf31b;</span>|linux_ubuntu|
|<span class="nerdfont big">&#xf31c;</span>|linux_ubuntu_inverse|
|<span class="nerdfont big">&#xf366;</span>|linux_vanilla|
|<span class="nerdfont big">&#xf32e;</span>|linux_void|
|<span class="nerdfont big">&#xf372;</span>|linux_vscodium|
|<span class="nerdfont big">&#xf367;</span>|linux_wayland|
|<span class="nerdfont big">&#xf36d;</span>|linux_wikimedia|
|<span class="nerdfont big">&#xf34a;</span>|linux_xerolinux|
|<span class="nerdfont big">&#xf368;</span>|linux_xfce|
|<span class="nerdfont big">&#xf35e;</span>|linux_xmonad|
|<span class="nerdfont big">&#xf369;</span>|linux_xorg|
|<span class="nerdfont big">&#xf32f;</span>|linux_zorin|
|<span class="nerdfont big">&#xf01c9;</span>|md_ab_testing|
|<span class="nerdfont big">&#xf16e0;</span>|md_abacus|
|<span class="nerdfont big">&#xf1328;</span>|md_abjad_arabic|
|<span class="nerdfont big">&#xf1329;</span>|md_abjad_hebrew|
|<span class="nerdfont big">&#xf132a;</span>|md_abugida_devanagari|
|<span class="nerdfont big">&#xf132b;</span>|md_abugida_thai|
|<span class="nerdfont big">&#xf0003;</span>|md_access_point|
|<span class="nerdfont big">&#xf1538;</span>|md_access_point_check|
|<span class="nerdfont big">&#xf1539;</span>|md_access_point_minus|
|<span class="nerdfont big">&#xf0002;</span>|md_access_point_network|
|<span class="nerdfont big">&#xf0be1;</span>|md_access_point_network_off|
|<span class="nerdfont big">&#xf1511;</span>|md_access_point_off|
|<span class="nerdfont big">&#xf153a;</span>|md_access_point_plus|
|<span class="nerdfont big">&#xf153b;</span>|md_access_point_remove|
|<span class="nerdfont big">&#xf0004;</span>|md_account|
|<span class="nerdfont big">&#xf0005;</span>|md_account_alert|
|<span class="nerdfont big">&#xf0b50;</span>|md_account_alert_outline|
|<span class="nerdfont big">&#xf1868;</span>|md_account_arrow_down|
|<span class="nerdfont big">&#xf1869;</span>|md_account_arrow_down_outline|
|<span class="nerdfont big">&#xf0b51;</span>|md_account_arrow_left|
|<span class="nerdfont big">&#xf0b52;</span>|md_account_arrow_left_outline|
|<span class="nerdfont big">&#xf0b53;</span>|md_account_arrow_right|
|<span class="nerdfont big">&#xf0b54;</span>|md_account_arrow_right_outline|
|<span class="nerdfont big">&#xf1867;</span>|md_account_arrow_up|
|<span class="nerdfont big">&#xf186a;</span>|md_account_arrow_up_outline|
|<span class="nerdfont big">&#xf0006;</span>|md_account_box|
|<span class="nerdfont big">&#xf0934;</span>|md_account_box_multiple|
|<span class="nerdfont big">&#xf100a;</span>|md_account_box_multiple_outline|
|<span class="nerdfont big">&#xf0007;</span>|md_account_box_outline|
|<span class="nerdfont big">&#xf12df;</span>|md_account_cancel|
|<span class="nerdfont big">&#xf12e0;</span>|md_account_cancel_outline|
|<span class="nerdfont big">&#xf1097;</span>|md_account_cash|
|<span class="nerdfont big">&#xf1098;</span>|md_account_cash_outline|
|<span class="nerdfont big">&#xf0008;</span>|md_account_check|
|<span class="nerdfont big">&#xf0be2;</span>|md_account_check_outline|
|<span class="nerdfont big">&#xf0a89;</span>|md_account_child|
|<span class="nerdfont big">&#xf0a8a;</span>|md_account_child_circle|
|<span class="nerdfont big">&#xf10c8;</span>|md_account_child_outline|
|<span class="nerdfont big">&#xf0009;</span>|md_account_circle|
|<span class="nerdfont big">&#xf0b55;</span>|md_account_circle_outline|
|<span class="nerdfont big">&#xf0b56;</span>|md_account_clock|
|<span class="nerdfont big">&#xf0b57;</span>|md_account_clock_outline|
|<span class="nerdfont big">&#xf1370;</span>|md_account_cog|
|<span class="nerdfont big">&#xf1371;</span>|md_account_cog_outline|
|<span class="nerdfont big">&#xf000a;</span>|md_account_convert|
|<span class="nerdfont big">&#xf1301;</span>|md_account_convert_outline|
|<span class="nerdfont big">&#xf0e9b;</span>|md_account_cowboy_hat|
|<span class="nerdfont big">&#xf17f3;</span>|md_account_cowboy_hat_outline|
|<span class="nerdfont big">&#xf0631;</span>|md_account_details|
|<span class="nerdfont big">&#xf1372;</span>|md_account_details_outline|
|<span class="nerdfont big">&#xf06bc;</span>|md_account_edit|
|<span class="nerdfont big">&#xf0ffb;</span>|md_account_edit_outline|
|<span class="nerdfont big">&#xf0420;</span>|md_account_eye|
|<span class="nerdfont big">&#xf127b;</span>|md_account_eye_outline|
|<span class="nerdfont big">&#xf0936;</span>|md_account_filter|
|<span class="nerdfont big">&#xf0f9d;</span>|md_account_filter_outline|
|<span class="nerdfont big">&#xf0849;</span>|md_account_group|
|<span class="nerdfont big">&#xf0b58;</span>|md_account_group_outline|
|<span class="nerdfont big">&#xf05b5;</span>|md_account_hard_hat|
|<span class="nerdfont big">&#xf1a1f;</span>|md_account_hard_hat_outline|
|<span class="nerdfont big">&#xf0899;</span>|md_account_heart|
|<span class="nerdfont big">&#xf0be3;</span>|md_account_heart_outline|
|<span class="nerdfont big">&#xf1815;</span>|md_account_injury|
|<span class="nerdfont big">&#xf1816;</span>|md_account_injury_outline|
|<span class="nerdfont big">&#xf000b;</span>|md_account_key|
|<span class="nerdfont big">&#xf0be4;</span>|md_account_key_outline|
|<span class="nerdfont big">&#xf115e;</span>|md_account_lock|
|<span class="nerdfont big">&#xf1960;</span>|md_account_lock_open|
|<span class="nerdfont big">&#xf1961;</span>|md_account_lock_open_outline|
|<span class="nerdfont big">&#xf115f;</span>|md_account_lock_outline|
|<span class="nerdfont big">&#xf000d;</span>|md_account_minus|
|<span class="nerdfont big">&#xf0aec;</span>|md_account_minus_outline|
|<span class="nerdfont big">&#xf000e;</span>|md_account_multiple|
|<span class="nerdfont big">&#xf08c5;</span>|md_account_multiple_check|
|<span class="nerdfont big">&#xf11fe;</span>|md_account_multiple_check_outline|
|<span class="nerdfont big">&#xf05d3;</span>|md_account_multiple_minus|
|<span class="nerdfont big">&#xf0be5;</span>|md_account_multiple_minus_outline|
|<span class="nerdfont big">&#xf000f;</span>|md_account_multiple_outline|
|<span class="nerdfont big">&#xf0010;</span>|md_account_multiple_plus|
|<span class="nerdfont big">&#xf0800;</span>|md_account_multiple_plus_outline|
|<span class="nerdfont big">&#xf120a;</span>|md_account_multiple_remove|
|<span class="nerdfont big">&#xf120b;</span>|md_account_multiple_remove_outline|
|<span class="nerdfont big">&#xf0803;</span>|md_account_music|
|<span class="nerdfont big">&#xf0ce9;</span>|md_account_music_outline|
|<span class="nerdfont big">&#xf0011;</span>|md_account_network|
|<span class="nerdfont big">&#xf0be6;</span>|md_account_network_outline|
|<span class="nerdfont big">&#xf0012;</span>|md_account_off|
|<span class="nerdfont big">&#xf0be7;</span>|md_account_off_outline|
|<span class="nerdfont big">&#xf0013;</span>|md_account_outline|
|<span class="nerdfont big">&#xf0014;</span>|md_account_plus|
|<span class="nerdfont big">&#xf0801;</span>|md_account_plus_outline|
|<span class="nerdfont big">&#xf0b59;</span>|md_account_question|
|<span class="nerdfont big">&#xf0b5a;</span>|md_account_question_outline|
|<span class="nerdfont big">&#xf152b;</span>|md_account_reactivate|
|<span class="nerdfont big">&#xf152c;</span>|md_account_reactivate_outline|
|<span class="nerdfont big">&#xf0015;</span>|md_account_remove|
|<span class="nerdfont big">&#xf0aed;</span>|md_account_remove_outline|
|<span class="nerdfont big">&#xf1a20;</span>|md_account_school|
|<span class="nerdfont big">&#xf1a21;</span>|md_account_school_outline|
|<span class="nerdfont big">&#xf0016;</span>|md_account_search|
|<span class="nerdfont big">&#xf0935;</span>|md_account_search_outline|
|<span class="nerdfont big">&#xf0630;</span>|md_account_settings|
|<span class="nerdfont big">&#xf10c9;</span>|md_account_settings_outline|
|<span class="nerdfont big">&#xf0017;</span>|md_account_star|
|<span class="nerdfont big">&#xf0be8;</span>|md_account_star_outline|
|<span class="nerdfont big">&#xf0a8b;</span>|md_account_supervisor|
|<span class="nerdfont big">&#xf0a8c;</span>|md_account_supervisor_circle|
|<span class="nerdfont big">&#xf14ec;</span>|md_account_supervisor_circle_outline|
|<span class="nerdfont big">&#xf112d;</span>|md_account_supervisor_outline|
|<span class="nerdfont big">&#xf0019;</span>|md_account_switch|
|<span class="nerdfont big">&#xf04cb;</span>|md_account_switch_outline|
|<span class="nerdfont big">&#xf191b;</span>|md_account_sync|
|<span class="nerdfont big">&#xf191c;</span>|md_account_sync_outline|
|<span class="nerdfont big">&#xf0ce3;</span>|md_account_tie|
|<span class="nerdfont big">&#xf1898;</span>|md_account_tie_hat|
|<span class="nerdfont big">&#xf1899;</span>|md_account_tie_hat_outline|
|<span class="nerdfont big">&#xf10ca;</span>|md_account_tie_outline|
|<span class="nerdfont big">&#xf1308;</span>|md_account_tie_voice|
|<span class="nerdfont big">&#xf130a;</span>|md_account_tie_voice_off|
|<span class="nerdfont big">&#xf130b;</span>|md_account_tie_voice_off_outline|
|<span class="nerdfont big">&#xf1309;</span>|md_account_tie_voice_outline|
|<span class="nerdfont big">&#xf1a8c;</span>|md_account_tie_woman|
|<span class="nerdfont big">&#xf05cb;</span>|md_account_voice|
|<span class="nerdfont big">&#xf0ed4;</span>|md_account_voice_off|
|<span class="nerdfont big">&#xf189a;</span>|md_account_wrench|
|<span class="nerdfont big">&#xf189b;</span>|md_account_wrench_outline|
|<span class="nerdfont big">&#xf001a;</span>|md_adjust|
|<span class="nerdfont big">&#xf192a;</span>|md_advertisements|
|<span class="nerdfont big">&#xf192b;</span>|md_advertisements_off|
|<span class="nerdfont big">&#xf001b;</span>|md_air_conditioner|
|<span class="nerdfont big">&#xf0d43;</span>|md_air_filter|
|<span class="nerdfont big">&#xf0dac;</span>|md_air_horn|
|<span class="nerdfont big">&#xf1099;</span>|md_air_humidifier|
|<span class="nerdfont big">&#xf1466;</span>|md_air_humidifier_off|
|<span class="nerdfont big">&#xf0d44;</span>|md_air_purifier|
|<span class="nerdfont big">&#xf0be9;</span>|md_airbag|
|<span class="nerdfont big">&#xf001c;</span>|md_airballoon|
|<span class="nerdfont big">&#xf100b;</span>|md_airballoon_outline|
|<span class="nerdfont big">&#xf001d;</span>|md_airplane|
|<span class="nerdfont big">&#xf187a;</span>|md_airplane_alert|
|<span class="nerdfont big">&#xf187b;</span>|md_airplane_check|
|<span class="nerdfont big">&#xf187c;</span>|md_airplane_clock|
|<span class="nerdfont big">&#xf187d;</span>|md_airplane_cog|
|<span class="nerdfont big">&#xf187e;</span>|md_airplane_edit|
|<span class="nerdfont big">&#xf05d4;</span>|md_airplane_landing|
|<span class="nerdfont big">&#xf187f;</span>|md_airplane_marker|
|<span class="nerdfont big">&#xf1880;</span>|md_airplane_minus|
|<span class="nerdfont big">&#xf001e;</span>|md_airplane_off|
|<span class="nerdfont big">&#xf1881;</span>|md_airplane_plus|
|<span class="nerdfont big">&#xf1882;</span>|md_airplane_remove|
|<span class="nerdfont big">&#xf1883;</span>|md_airplane_search|
|<span class="nerdfont big">&#xf1884;</span>|md_airplane_settings|
|<span class="nerdfont big">&#xf05d5;</span>|md_airplane_takeoff|
|<span class="nerdfont big">&#xf084b;</span>|md_airport|
|<span class="nerdfont big">&#xf0020;</span>|md_alarm|
|<span class="nerdfont big">&#xf078e;</span>|md_alarm_bell|
|<span class="nerdfont big">&#xf0021;</span>|md_alarm_check|
|<span class="nerdfont big">&#xf078f;</span>|md_alarm_light|
|<span class="nerdfont big">&#xf171e;</span>|md_alarm_light_off|
|<span class="nerdfont big">&#xf171f;</span>|md_alarm_light_off_outline|
|<span class="nerdfont big">&#xf0bea;</span>|md_alarm_light_outline|
|<span class="nerdfont big">&#xf0022;</span>|md_alarm_multiple|
|<span class="nerdfont big">&#xf0e71;</span>|md_alarm_note|
|<span class="nerdfont big">&#xf0e72;</span>|md_alarm_note_off|
|<span class="nerdfont big">&#xf0023;</span>|md_alarm_off|
|<span class="nerdfont big">&#xf15c4;</span>|md_alarm_panel|
|<span class="nerdfont big">&#xf15c5;</span>|md_alarm_panel_outline|
|<span class="nerdfont big">&#xf0024;</span>|md_alarm_plus|
|<span class="nerdfont big">&#xf068e;</span>|md_alarm_snooze|
|<span class="nerdfont big">&#xf0025;</span>|md_album|
|<span class="nerdfont big">&#xf0026;</span>|md_alert|
|<span class="nerdfont big">&#xf0027;</span>|md_alert_box|
|<span class="nerdfont big">&#xf0ce4;</span>|md_alert_box_outline|
|<span class="nerdfont big">&#xf0028;</span>|md_alert_circle|
|<span class="nerdfont big">&#xf11ed;</span>|md_alert_circle_check|
|<span class="nerdfont big">&#xf11ee;</span>|md_alert_circle_check_outline|
|<span class="nerdfont big">&#xf05d6;</span>|md_alert_circle_outline|
|<span class="nerdfont big">&#xf06bd;</span>|md_alert_decagram|
|<span class="nerdfont big">&#xf0ce5;</span>|md_alert_decagram_outline|
|<span class="nerdfont big">&#xf14bb;</span>|md_alert_minus|
|<span class="nerdfont big">&#xf14be;</span>|md_alert_minus_outline|
|<span class="nerdfont big">&#xf0029;</span>|md_alert_octagon|
|<span class="nerdfont big">&#xf0ce6;</span>|md_alert_octagon_outline|
|<span class="nerdfont big">&#xf0767;</span>|md_alert_octagram|
|<span class="nerdfont big">&#xf0ce7;</span>|md_alert_octagram_outline|
|<span class="nerdfont big">&#xf002a;</span>|md_alert_outline|
|<span class="nerdfont big">&#xf14ba;</span>|md_alert_plus|
|<span class="nerdfont big">&#xf14bd;</span>|md_alert_plus_outline|
|<span class="nerdfont big">&#xf14bc;</span>|md_alert_remove|
|<span class="nerdfont big">&#xf14bf;</span>|md_alert_remove_outline|
|<span class="nerdfont big">&#xf11ce;</span>|md_alert_rhombus|
|<span class="nerdfont big">&#xf11cf;</span>|md_alert_rhombus_outline|
|<span class="nerdfont big">&#xf089a;</span>|md_alien|
|<span class="nerdfont big">&#xf10cb;</span>|md_alien_outline|
|<span class="nerdfont big">&#xf11c3;</span>|md_align_horizontal_center|
|<span class="nerdfont big">&#xf1962;</span>|md_align_horizontal_distribute|
|<span class="nerdfont big">&#xf11c2;</span>|md_align_horizontal_left|
|<span class="nerdfont big">&#xf11c4;</span>|md_align_horizontal_right|
|<span class="nerdfont big">&#xf11c5;</span>|md_align_vertical_bottom|
|<span class="nerdfont big">&#xf11c6;</span>|md_align_vertical_center|
|<span class="nerdfont big">&#xf1963;</span>|md_align_vertical_distribute|
|<span class="nerdfont big">&#xf11c7;</span>|md_align_vertical_top|
|<span class="nerdfont big">&#xf06be;</span>|md_all_inclusive|
|<span class="nerdfont big">&#xf188d;</span>|md_all_inclusive_box|
|<span class="nerdfont big">&#xf188e;</span>|md_all_inclusive_box_outline|
|<span class="nerdfont big">&#xf1258;</span>|md_allergy|
|<span class="nerdfont big">&#xf002b;</span>|md_alpha|
|<span class="nerdfont big">&#xf0aee;</span>|md_alpha_a|
|<span class="nerdfont big">&#xf0b08;</span>|md_alpha_a_box|
|<span class="nerdfont big">&#xf0beb;</span>|md_alpha_a_box_outline|
|<span class="nerdfont big">&#xf0bec;</span>|md_alpha_a_circle|
|<span class="nerdfont big">&#xf0bed;</span>|md_alpha_a_circle_outline|
|<span class="nerdfont big">&#xf0aef;</span>|md_alpha_b|
|<span class="nerdfont big">&#xf0b09;</span>|md_alpha_b_box|
|<span class="nerdfont big">&#xf0bee;</span>|md_alpha_b_box_outline|
|<span class="nerdfont big">&#xf0bef;</span>|md_alpha_b_circle|
|<span class="nerdfont big">&#xf0bf0;</span>|md_alpha_b_circle_outline|
|<span class="nerdfont big">&#xf0af0;</span>|md_alpha_c|
|<span class="nerdfont big">&#xf0b0a;</span>|md_alpha_c_box|
|<span class="nerdfont big">&#xf0bf1;</span>|md_alpha_c_box_outline|
|<span class="nerdfont big">&#xf0bf2;</span>|md_alpha_c_circle|
|<span class="nerdfont big">&#xf0bf3;</span>|md_alpha_c_circle_outline|
|<span class="nerdfont big">&#xf0af1;</span>|md_alpha_d|
|<span class="nerdfont big">&#xf0b0b;</span>|md_alpha_d_box|
|<span class="nerdfont big">&#xf0bf4;</span>|md_alpha_d_box_outline|
|<span class="nerdfont big">&#xf0bf5;</span>|md_alpha_d_circle|
|<span class="nerdfont big">&#xf0bf6;</span>|md_alpha_d_circle_outline|
|<span class="nerdfont big">&#xf0af2;</span>|md_alpha_e|
|<span class="nerdfont big">&#xf0b0c;</span>|md_alpha_e_box|
|<span class="nerdfont big">&#xf0bf7;</span>|md_alpha_e_box_outline|
|<span class="nerdfont big">&#xf0bf8;</span>|md_alpha_e_circle|
|<span class="nerdfont big">&#xf0bf9;</span>|md_alpha_e_circle_outline|
|<span class="nerdfont big">&#xf0af3;</span>|md_alpha_f|
|<span class="nerdfont big">&#xf0b0d;</span>|md_alpha_f_box|
|<span class="nerdfont big">&#xf0bfa;</span>|md_alpha_f_box_outline|
|<span class="nerdfont big">&#xf0bfb;</span>|md_alpha_f_circle|
|<span class="nerdfont big">&#xf0bfc;</span>|md_alpha_f_circle_outline|
|<span class="nerdfont big">&#xf0af4;</span>|md_alpha_g|
|<span class="nerdfont big">&#xf0b0e;</span>|md_alpha_g_box|
|<span class="nerdfont big">&#xf0bfd;</span>|md_alpha_g_box_outline|
|<span class="nerdfont big">&#xf0bfe;</span>|md_alpha_g_circle|
|<span class="nerdfont big">&#xf0bff;</span>|md_alpha_g_circle_outline|
|<span class="nerdfont big">&#xf0af5;</span>|md_alpha_h|
|<span class="nerdfont big">&#xf0b0f;</span>|md_alpha_h_box|
|<span class="nerdfont big">&#xf0c00;</span>|md_alpha_h_box_outline|
|<span class="nerdfont big">&#xf0c01;</span>|md_alpha_h_circle|
|<span class="nerdfont big">&#xf0c02;</span>|md_alpha_h_circle_outline|
|<span class="nerdfont big">&#xf1088;</span>|md_alpha_i|
|<span class="nerdfont big">&#xf1088;</span>|md_alpha_i|
|<span class="nerdfont big">&#xf0b10;</span>|md_alpha_i_box|
|<span class="nerdfont big">&#xf0c03;</span>|md_alpha_i_box_outline|
|<span class="nerdfont big">&#xf0c04;</span>|md_alpha_i_circle|
|<span class="nerdfont big">&#xf0c05;</span>|md_alpha_i_circle_outline|
|<span class="nerdfont big">&#xf0af7;</span>|md_alpha_j|
|<span class="nerdfont big">&#xf0b11;</span>|md_alpha_j_box|
|<span class="nerdfont big">&#xf0c06;</span>|md_alpha_j_box_outline|
|<span class="nerdfont big">&#xf0c07;</span>|md_alpha_j_circle|
|<span class="nerdfont big">&#xf0c08;</span>|md_alpha_j_circle_outline|
|<span class="nerdfont big">&#xf0af8;</span>|md_alpha_k|
|<span class="nerdfont big">&#xf0b12;</span>|md_alpha_k_box|
|<span class="nerdfont big">&#xf0c09;</span>|md_alpha_k_box_outline|
|<span class="nerdfont big">&#xf0c0a;</span>|md_alpha_k_circle|
|<span class="nerdfont big">&#xf0c0b;</span>|md_alpha_k_circle_outline|
|<span class="nerdfont big">&#xf13a6;</span>|md_alpha_l|
|<span class="nerdfont big">&#xf13a6;</span>|md_alpha_l|
|<span class="nerdfont big">&#xf0b13;</span>|md_alpha_l_box|
|<span class="nerdfont big">&#xf0c0c;</span>|md_alpha_l_box_outline|
|<span class="nerdfont big">&#xf0c0d;</span>|md_alpha_l_circle|
|<span class="nerdfont big">&#xf0c0e;</span>|md_alpha_l_circle_outline|
|<span class="nerdfont big">&#xf0afa;</span>|md_alpha_m|
|<span class="nerdfont big">&#xf0b14;</span>|md_alpha_m_box|
|<span class="nerdfont big">&#xf0c0f;</span>|md_alpha_m_box_outline|
|<span class="nerdfont big">&#xf0c10;</span>|md_alpha_m_circle|
|<span class="nerdfont big">&#xf0c11;</span>|md_alpha_m_circle_outline|
|<span class="nerdfont big">&#xf0afb;</span>|md_alpha_n|
|<span class="nerdfont big">&#xf0b15;</span>|md_alpha_n_box|
|<span class="nerdfont big">&#xf0c12;</span>|md_alpha_n_box_outline|
|<span class="nerdfont big">&#xf0c13;</span>|md_alpha_n_circle|
|<span class="nerdfont big">&#xf0c14;</span>|md_alpha_n_circle_outline|
|<span class="nerdfont big">&#xf0b39;</span>|md_alpha_o|
|<span class="nerdfont big">&#xf0b39;</span>|md_alpha_o|
|<span class="nerdfont big">&#xf0b16;</span>|md_alpha_o_box|
|<span class="nerdfont big">&#xf0c15;</span>|md_alpha_o_box_outline|
|<span class="nerdfont big">&#xf0c9e;</span>|md_alpha_o_circle|
|<span class="nerdfont big">&#xf0c9e;</span>|md_alpha_o_circle|
|<span class="nerdfont big">&#xf0c9f;</span>|md_alpha_o_circle_outline|
|<span class="nerdfont big">&#xf0c9f;</span>|md_alpha_o_circle_outline|
|<span class="nerdfont big">&#xf0afd;</span>|md_alpha_p|
|<span class="nerdfont big">&#xf0b17;</span>|md_alpha_p_box|
|<span class="nerdfont big">&#xf0c18;</span>|md_alpha_p_box_outline|
|<span class="nerdfont big">&#xf0c19;</span>|md_alpha_p_circle|
|<span class="nerdfont big">&#xf0c1a;</span>|md_alpha_p_circle_outline|
|<span class="nerdfont big">&#xf0afe;</span>|md_alpha_q|
|<span class="nerdfont big">&#xf0b18;</span>|md_alpha_q_box|
|<span class="nerdfont big">&#xf0c1b;</span>|md_alpha_q_box_outline|
|<span class="nerdfont big">&#xf0c1c;</span>|md_alpha_q_circle|
|<span class="nerdfont big">&#xf0c1d;</span>|md_alpha_q_circle_outline|
|<span class="nerdfont big">&#xf0aff;</span>|md_alpha_r|
|<span class="nerdfont big">&#xf0b19;</span>|md_alpha_r_box|
|<span class="nerdfont big">&#xf0c1e;</span>|md_alpha_r_box_outline|
|<span class="nerdfont big">&#xf0c1f;</span>|md_alpha_r_circle|
|<span class="nerdfont big">&#xf0c20;</span>|md_alpha_r_circle_outline|
|<span class="nerdfont big">&#xf0b00;</span>|md_alpha_s|
|<span class="nerdfont big">&#xf0b1a;</span>|md_alpha_s_box|
|<span class="nerdfont big">&#xf0c21;</span>|md_alpha_s_box_outline|
|<span class="nerdfont big">&#xf0c22;</span>|md_alpha_s_circle|
|<span class="nerdfont big">&#xf0c23;</span>|md_alpha_s_circle_outline|
|<span class="nerdfont big">&#xf0b01;</span>|md_alpha_t|
|<span class="nerdfont big">&#xf0b1b;</span>|md_alpha_t_box|
|<span class="nerdfont big">&#xf0c24;</span>|md_alpha_t_box_outline|
|<span class="nerdfont big">&#xf0c25;</span>|md_alpha_t_circle|
|<span class="nerdfont big">&#xf0c26;</span>|md_alpha_t_circle_outline|
|<span class="nerdfont big">&#xf0b02;</span>|md_alpha_u|
|<span class="nerdfont big">&#xf0b1c;</span>|md_alpha_u_box|
|<span class="nerdfont big">&#xf0c27;</span>|md_alpha_u_box_outline|
|<span class="nerdfont big">&#xf0c28;</span>|md_alpha_u_circle|
|<span class="nerdfont big">&#xf0c29;</span>|md_alpha_u_circle_outline|
|<span class="nerdfont big">&#xf108c;</span>|md_alpha_v|
|<span class="nerdfont big">&#xf108c;</span>|md_alpha_v|
|<span class="nerdfont big">&#xf0b1d;</span>|md_alpha_v_box|
|<span class="nerdfont big">&#xf0c2a;</span>|md_alpha_v_box_outline|
|<span class="nerdfont big">&#xf0c2b;</span>|md_alpha_v_circle|
|<span class="nerdfont big">&#xf0c2c;</span>|md_alpha_v_circle_outline|
|<span class="nerdfont big">&#xf0b04;</span>|md_alpha_w|
|<span class="nerdfont big">&#xf0b1e;</span>|md_alpha_w_box|
|<span class="nerdfont big">&#xf0c2d;</span>|md_alpha_w_box_outline|
|<span class="nerdfont big">&#xf0c2e;</span>|md_alpha_w_circle|
|<span class="nerdfont big">&#xf0c2f;</span>|md_alpha_w_circle_outline|
|<span class="nerdfont big">&#xf1091;</span>|md_alpha_x|
|<span class="nerdfont big">&#xf1091;</span>|md_alpha_x|
|<span class="nerdfont big">&#xf0b1f;</span>|md_alpha_x_box|
|<span class="nerdfont big">&#xf0c30;</span>|md_alpha_x_box_outline|
|<span class="nerdfont big">&#xf0c31;</span>|md_alpha_x_circle|
|<span class="nerdfont big">&#xf0c32;</span>|md_alpha_x_circle_outline|
|<span class="nerdfont big">&#xf0b06;</span>|md_alpha_y|
|<span class="nerdfont big">&#xf0b20;</span>|md_alpha_y_box|
|<span class="nerdfont big">&#xf0c33;</span>|md_alpha_y_box_outline|
|<span class="nerdfont big">&#xf0c34;</span>|md_alpha_y_circle|
|<span class="nerdfont big">&#xf0c35;</span>|md_alpha_y_circle_outline|
|<span class="nerdfont big">&#xf0b07;</span>|md_alpha_z|
|<span class="nerdfont big">&#xf0b21;</span>|md_alpha_z_box|
|<span class="nerdfont big">&#xf0c36;</span>|md_alpha_z_box_outline|
|<span class="nerdfont big">&#xf0c37;</span>|md_alpha_z_circle|
|<span class="nerdfont big">&#xf0c38;</span>|md_alpha_z_circle_outline|
|<span class="nerdfont big">&#xf132c;</span>|md_alphabet_aurebesh|
|<span class="nerdfont big">&#xf132d;</span>|md_alphabet_cyrillic|
|<span class="nerdfont big">&#xf132e;</span>|md_alphabet_greek|
|<span class="nerdfont big">&#xf132f;</span>|md_alphabet_latin|
|<span class="nerdfont big">&#xf1330;</span>|md_alphabet_piqad|
|<span class="nerdfont big">&#xf1337;</span>|md_alphabet_tengwar|
|<span class="nerdfont big">&#xf002c;</span>|md_alphabetical|
|<span class="nerdfont big">&#xf100c;</span>|md_alphabetical_off|
|<span class="nerdfont big">&#xf100d;</span>|md_alphabetical_variant|
|<span class="nerdfont big">&#xf100e;</span>|md_alphabetical_variant_off|
|<span class="nerdfont big">&#xf05d7;</span>|md_altimeter|
|<span class="nerdfont big">&#xf002f;</span>|md_ambulance|
|<span class="nerdfont big">&#xf0ce8;</span>|md_ammunition|
|<span class="nerdfont big">&#xf0a8d;</span>|md_ampersand|
|<span class="nerdfont big">&#xf0030;</span>|md_amplifier|
|<span class="nerdfont big">&#xf11b5;</span>|md_amplifier_off|
|<span class="nerdfont big">&#xf0031;</span>|md_anchor|
|<span class="nerdfont big">&#xf0032;</span>|md_android|
|<span class="nerdfont big">&#xf0d45;</span>|md_android_messages|
|<span class="nerdfont big">&#xf0034;</span>|md_android_studio|
|<span class="nerdfont big">&#xf0937;</span>|md_angle_acute|
|<span class="nerdfont big">&#xf0938;</span>|md_angle_obtuse|
|<span class="nerdfont big">&#xf0939;</span>|md_angle_right|
|<span class="nerdfont big">&#xf06b2;</span>|md_angular|
|<span class="nerdfont big">&#xf06bf;</span>|md_angularjs|
|<span class="nerdfont big">&#xf05d8;</span>|md_animation|
|<span class="nerdfont big">&#xf0a8f;</span>|md_animation_outline|
|<span class="nerdfont big">&#xf093a;</span>|md_animation_play|
|<span class="nerdfont big">&#xf0a90;</span>|md_animation_play_outline|
|<span class="nerdfont big">&#xf109a;</span>|md_ansible|
|<span class="nerdfont big">&#xf1119;</span>|md_antenna|
|<span class="nerdfont big">&#xf089b;</span>|md_anvil|
|<span class="nerdfont big">&#xf100f;</span>|md_apache_kafka|
|<span class="nerdfont big">&#xf109b;</span>|md_api|
|<span class="nerdfont big">&#xf1257;</span>|md_api_off|
|<span class="nerdfont big">&#xf0035;</span>|md_apple|
|<span class="nerdfont big">&#xf0036;</span>|md_apple_finder|
|<span class="nerdfont big">&#xf0038;</span>|md_apple_icloud|
|<span class="nerdfont big">&#xf0037;</span>|md_apple_ios|
|<span class="nerdfont big">&#xf0632;</span>|md_apple_keyboard_caps|
|<span class="nerdfont big">&#xf0633;</span>|md_apple_keyboard_command|
|<span class="nerdfont big">&#xf0634;</span>|md_apple_keyboard_control|
|<span class="nerdfont big">&#xf0635;</span>|md_apple_keyboard_option|
|<span class="nerdfont big">&#xf0636;</span>|md_apple_keyboard_shift|
|<span class="nerdfont big">&#xf0039;</span>|md_apple_safari|
|<span class="nerdfont big">&#xf08c6;</span>|md_application|
|<span class="nerdfont big">&#xf10f5;</span>|md_application_array|
|<span class="nerdfont big">&#xf10f6;</span>|md_application_array_outline|
|<span class="nerdfont big">&#xf10f7;</span>|md_application_braces|
|<span class="nerdfont big">&#xf10f8;</span>|md_application_braces_outline|
|<span class="nerdfont big">&#xf0c8b;</span>|md_application_brackets|
|<span class="nerdfont big">&#xf0c8c;</span>|md_application_brackets_outline|
|<span class="nerdfont big">&#xf0675;</span>|md_application_cog|
|<span class="nerdfont big">&#xf1577;</span>|md_application_cog_outline|
|<span class="nerdfont big">&#xf00ae;</span>|md_application_edit|
|<span class="nerdfont big">&#xf0619;</span>|md_application_edit_outline|
|<span class="nerdfont big">&#xf0dad;</span>|md_application_export|
|<span class="nerdfont big">&#xf0dae;</span>|md_application_import|
|<span class="nerdfont big">&#xf0614;</span>|md_application_outline|
|<span class="nerdfont big">&#xf10f9;</span>|md_application_parentheses|
|<span class="nerdfont big">&#xf10fa;</span>|md_application_parentheses_outline|
|<span class="nerdfont big">&#xf0b60;</span>|md_application_settings|
|<span class="nerdfont big">&#xf1555;</span>|md_application_settings_outline|
|<span class="nerdfont big">&#xf10fb;</span>|md_application_variable|
|<span class="nerdfont big">&#xf10fc;</span>|md_application_variable_outline|
|<span class="nerdfont big">&#xf0f9e;</span>|md_approximately_equal|
|<span class="nerdfont big">&#xf0f9f;</span>|md_approximately_equal_box|
|<span class="nerdfont big">&#xf003b;</span>|md_apps|
|<span class="nerdfont big">&#xf0d46;</span>|md_apps_box|
|<span class="nerdfont big">&#xf08c7;</span>|md_arch|
|<span class="nerdfont big">&#xf003c;</span>|md_archive|
|<span class="nerdfont big">&#xf14fd;</span>|md_archive_alert|
|<span class="nerdfont big">&#xf14fe;</span>|md_archive_alert_outline|
|<span class="nerdfont big">&#xf1259;</span>|md_archive_arrow_down|
|<span class="nerdfont big">&#xf125a;</span>|md_archive_arrow_down_outline|
|<span class="nerdfont big">&#xf125b;</span>|md_archive_arrow_up|
|<span class="nerdfont big">&#xf125c;</span>|md_archive_arrow_up_outline|
|<span class="nerdfont big">&#xf174b;</span>|md_archive_cancel|
|<span class="nerdfont big">&#xf174c;</span>|md_archive_cancel_outline|
|<span class="nerdfont big">&#xf174d;</span>|md_archive_check|
|<span class="nerdfont big">&#xf174e;</span>|md_archive_check_outline|
|<span class="nerdfont big">&#xf174f;</span>|md_archive_clock|
|<span class="nerdfont big">&#xf1750;</span>|md_archive_clock_outline|
|<span class="nerdfont big">&#xf1751;</span>|md_archive_cog|
|<span class="nerdfont big">&#xf1752;</span>|md_archive_cog_outline|
|<span class="nerdfont big">&#xf1753;</span>|md_archive_edit|
|<span class="nerdfont big">&#xf1754;</span>|md_archive_edit_outline|
|<span class="nerdfont big">&#xf1755;</span>|md_archive_eye|
|<span class="nerdfont big">&#xf1756;</span>|md_archive_eye_outline|
|<span class="nerdfont big">&#xf1757;</span>|md_archive_lock|
|<span class="nerdfont big">&#xf1758;</span>|md_archive_lock_open|
|<span class="nerdfont big">&#xf1759;</span>|md_archive_lock_open_outline|
|<span class="nerdfont big">&#xf175a;</span>|md_archive_lock_outline|
|<span class="nerdfont big">&#xf175b;</span>|md_archive_marker|
|<span class="nerdfont big">&#xf175c;</span>|md_archive_marker_outline|
|<span class="nerdfont big">&#xf175d;</span>|md_archive_minus|
|<span class="nerdfont big">&#xf175e;</span>|md_archive_minus_outline|
|<span class="nerdfont big">&#xf175f;</span>|md_archive_music|
|<span class="nerdfont big">&#xf1760;</span>|md_archive_music_outline|
|<span class="nerdfont big">&#xf1761;</span>|md_archive_off|
|<span class="nerdfont big">&#xf1762;</span>|md_archive_off_outline|
|<span class="nerdfont big">&#xf120e;</span>|md_archive_outline|
|<span class="nerdfont big">&#xf1763;</span>|md_archive_plus|
|<span class="nerdfont big">&#xf1764;</span>|md_archive_plus_outline|
|<span class="nerdfont big">&#xf1765;</span>|md_archive_refresh|
|<span class="nerdfont big">&#xf1766;</span>|md_archive_refresh_outline|
|<span class="nerdfont big">&#xf1767;</span>|md_archive_remove|
|<span class="nerdfont big">&#xf1768;</span>|md_archive_remove_outline|
|<span class="nerdfont big">&#xf1769;</span>|md_archive_search|
|<span class="nerdfont big">&#xf176a;</span>|md_archive_search_outline|
|<span class="nerdfont big">&#xf176b;</span>|md_archive_settings|
|<span class="nerdfont big">&#xf176c;</span>|md_archive_settings_outline|
|<span class="nerdfont big">&#xf176d;</span>|md_archive_star|
|<span class="nerdfont big">&#xf176e;</span>|md_archive_star_outline|
|<span class="nerdfont big">&#xf176f;</span>|md_archive_sync|
|<span class="nerdfont big">&#xf1770;</span>|md_archive_sync_outline|
|<span class="nerdfont big">&#xf0fd7;</span>|md_arm_flex|
|<span class="nerdfont big">&#xf0fd6;</span>|md_arm_flex_outline|
|<span class="nerdfont big">&#xf003d;</span>|md_arrange_bring_forward|
|<span class="nerdfont big">&#xf003e;</span>|md_arrange_bring_to_front|
|<span class="nerdfont big">&#xf003f;</span>|md_arrange_send_backward|
|<span class="nerdfont big">&#xf0040;</span>|md_arrange_send_to_back|
|<span class="nerdfont big">&#xf0041;</span>|md_arrow_all|
|<span class="nerdfont big">&#xf0042;</span>|md_arrow_bottom_left|
|<span class="nerdfont big">&#xf1964;</span>|md_arrow_bottom_left_bold_box|
|<span class="nerdfont big">&#xf1965;</span>|md_arrow_bottom_left_bold_box_outline|
|<span class="nerdfont big">&#xf09b7;</span>|md_arrow_bottom_left_bold_outline|
|<span class="nerdfont big">&#xf09b8;</span>|md_arrow_bottom_left_thick|
|<span class="nerdfont big">&#xf19b6;</span>|md_arrow_bottom_left_thin|
|<span class="nerdfont big">&#xf1596;</span>|md_arrow_bottom_left_thin_circle_outline|
|<span class="nerdfont big">&#xf0043;</span>|md_arrow_bottom_right|
|<span class="nerdfont big">&#xf1966;</span>|md_arrow_bottom_right_bold_box|
|<span class="nerdfont big">&#xf1967;</span>|md_arrow_bottom_right_bold_box_outline|
|<span class="nerdfont big">&#xf09b9;</span>|md_arrow_bottom_right_bold_outline|
|<span class="nerdfont big">&#xf09ba;</span>|md_arrow_bottom_right_thick|
|<span class="nerdfont big">&#xf19b7;</span>|md_arrow_bottom_right_thin|
|<span class="nerdfont big">&#xf1595;</span>|md_arrow_bottom_right_thin_circle_outline|
|<span class="nerdfont big">&#xf0615;</span>|md_arrow_collapse|
|<span class="nerdfont big">&#xf0044;</span>|md_arrow_collapse_all|
|<span class="nerdfont big">&#xf0792;</span>|md_arrow_collapse_down|
|<span class="nerdfont big">&#xf084c;</span>|md_arrow_collapse_horizontal|
|<span class="nerdfont big">&#xf0793;</span>|md_arrow_collapse_left|
|<span class="nerdfont big">&#xf0794;</span>|md_arrow_collapse_right|
|<span class="nerdfont big">&#xf0795;</span>|md_arrow_collapse_up|
|<span class="nerdfont big">&#xf084d;</span>|md_arrow_collapse_vertical|
|<span class="nerdfont big">&#xf09bb;</span>|md_arrow_decision|
|<span class="nerdfont big">&#xf09bc;</span>|md_arrow_decision_auto|
|<span class="nerdfont big">&#xf09bd;</span>|md_arrow_decision_auto_outline|
|<span class="nerdfont big">&#xf09be;</span>|md_arrow_decision_outline|
|<span class="nerdfont big">&#xf0045;</span>|md_arrow_down|
|<span class="nerdfont big">&#xf072e;</span>|md_arrow_down_bold|
|<span class="nerdfont big">&#xf072f;</span>|md_arrow_down_bold_box|
|<span class="nerdfont big">&#xf0730;</span>|md_arrow_down_bold_box_outline|
|<span class="nerdfont big">&#xf0047;</span>|md_arrow_down_bold_circle|
|<span class="nerdfont big">&#xf0048;</span>|md_arrow_down_bold_circle_outline|
|<span class="nerdfont big">&#xf0049;</span>|md_arrow_down_bold_hexagon_outline|
|<span class="nerdfont big">&#xf09bf;</span>|md_arrow_down_bold_outline|
|<span class="nerdfont big">&#xf06c0;</span>|md_arrow_down_box|
|<span class="nerdfont big">&#xf0cdb;</span>|md_arrow_down_circle|
|<span class="nerdfont big">&#xf0cdc;</span>|md_arrow_down_circle_outline|
|<span class="nerdfont big">&#xf004a;</span>|md_arrow_down_drop_circle|
|<span class="nerdfont big">&#xf004b;</span>|md_arrow_down_drop_circle_outline|
|<span class="nerdfont big">&#xf17a1;</span>|md_arrow_down_left|
|<span class="nerdfont big">&#xf17a2;</span>|md_arrow_down_left_bold|
|<span class="nerdfont big">&#xf17a3;</span>|md_arrow_down_right|
|<span class="nerdfont big">&#xf17a4;</span>|md_arrow_down_right_bold|
|<span class="nerdfont big">&#xf0046;</span>|md_arrow_down_thick|
|<span class="nerdfont big">&#xf19b3;</span>|md_arrow_down_thin|
|<span class="nerdfont big">&#xf1599;</span>|md_arrow_down_thin_circle_outline|
|<span class="nerdfont big">&#xf0616;</span>|md_arrow_expand|
|<span class="nerdfont big">&#xf004c;</span>|md_arrow_expand_all|
|<span class="nerdfont big">&#xf0796;</span>|md_arrow_expand_down|
|<span class="nerdfont big">&#xf084e;</span>|md_arrow_expand_horizontal|
|<span class="nerdfont big">&#xf0797;</span>|md_arrow_expand_left|
|<span class="nerdfont big">&#xf0798;</span>|md_arrow_expand_right|
|<span class="nerdfont big">&#xf0799;</span>|md_arrow_expand_up|
|<span class="nerdfont big">&#xf084f;</span>|md_arrow_expand_vertical|
|<span class="nerdfont big">&#xf115b;</span>|md_arrow_horizontal_lock|
|<span class="nerdfont big">&#xf004d;</span>|md_arrow_left|
|<span class="nerdfont big">&#xf0731;</span>|md_arrow_left_bold|
|<span class="nerdfont big">&#xf0732;</span>|md_arrow_left_bold_box|
|<span class="nerdfont big">&#xf0733;</span>|md_arrow_left_bold_box_outline|
|<span class="nerdfont big">&#xf004f;</span>|md_arrow_left_bold_circle|
|<span class="nerdfont big">&#xf0050;</span>|md_arrow_left_bold_circle_outline|
|<span class="nerdfont big">&#xf0051;</span>|md_arrow_left_bold_hexagon_outline|
|<span class="nerdfont big">&#xf09c0;</span>|md_arrow_left_bold_outline|
|<span class="nerdfont big">&#xf17a5;</span>|md_arrow_left_bottom|
|<span class="nerdfont big">&#xf17a6;</span>|md_arrow_left_bottom_bold|
|<span class="nerdfont big">&#xf06c1;</span>|md_arrow_left_box|
|<span class="nerdfont big">&#xf0cdd;</span>|md_arrow_left_circle|
|<span class="nerdfont big">&#xf0cde;</span>|md_arrow_left_circle_outline|
|<span class="nerdfont big">&#xf0052;</span>|md_arrow_left_drop_circle|
|<span class="nerdfont big">&#xf0053;</span>|md_arrow_left_drop_circle_outline|
|<span class="nerdfont big">&#xf0e73;</span>|md_arrow_left_right|
|<span class="nerdfont big">&#xf0e74;</span>|md_arrow_left_right_bold|
|<span class="nerdfont big">&#xf09c1;</span>|md_arrow_left_right_bold_outline|
|<span class="nerdfont big">&#xf004e;</span>|md_arrow_left_thick|
|<span class="nerdfont big">&#xf19b1;</span>|md_arrow_left_thin|
|<span class="nerdfont big">&#xf159a;</span>|md_arrow_left_thin_circle_outline|
|<span class="nerdfont big">&#xf17a7;</span>|md_arrow_left_top|
|<span class="nerdfont big">&#xf17a8;</span>|md_arrow_left_top_bold|
|<span class="nerdfont big">&#xf1840;</span>|md_arrow_projectile|
|<span class="nerdfont big">&#xf183f;</span>|md_arrow_projectile_multiple|
|<span class="nerdfont big">&#xf0054;</span>|md_arrow_right|
|<span class="nerdfont big">&#xf0734;</span>|md_arrow_right_bold|
|<span class="nerdfont big">&#xf0735;</span>|md_arrow_right_bold_box|
|<span class="nerdfont big">&#xf0736;</span>|md_arrow_right_bold_box_outline|
|<span class="nerdfont big">&#xf0056;</span>|md_arrow_right_bold_circle|
|<span class="nerdfont big">&#xf0057;</span>|md_arrow_right_bold_circle_outline|
|<span class="nerdfont big">&#xf0058;</span>|md_arrow_right_bold_hexagon_outline|
|<span class="nerdfont big">&#xf09c2;</span>|md_arrow_right_bold_outline|
|<span class="nerdfont big">&#xf17a9;</span>|md_arrow_right_bottom|
|<span class="nerdfont big">&#xf17aa;</span>|md_arrow_right_bottom_bold|
|<span class="nerdfont big">&#xf06c2;</span>|md_arrow_right_box|
|<span class="nerdfont big">&#xf0cdf;</span>|md_arrow_right_circle|
|<span class="nerdfont big">&#xf0ce0;</span>|md_arrow_right_circle_outline|
|<span class="nerdfont big">&#xf0059;</span>|md_arrow_right_drop_circle|
|<span class="nerdfont big">&#xf005a;</span>|md_arrow_right_drop_circle_outline|
|<span class="nerdfont big">&#xf0055;</span>|md_arrow_right_thick|
|<span class="nerdfont big">&#xf19b0;</span>|md_arrow_right_thin|
|<span class="nerdfont big">&#xf1598;</span>|md_arrow_right_thin_circle_outline|
|<span class="nerdfont big">&#xf17ab;</span>|md_arrow_right_top|
|<span class="nerdfont big">&#xf17ac;</span>|md_arrow_right_top_bold|
|<span class="nerdfont big">&#xf093b;</span>|md_arrow_split_horizontal|
|<span class="nerdfont big">&#xf093c;</span>|md_arrow_split_vertical|
|<span class="nerdfont big">&#xf005b;</span>|md_arrow_top_left|
|<span class="nerdfont big">&#xf1968;</span>|md_arrow_top_left_bold_box|
|<span class="nerdfont big">&#xf1969;</span>|md_arrow_top_left_bold_box_outline|
|<span class="nerdfont big">&#xf09c3;</span>|md_arrow_top_left_bold_outline|
|<span class="nerdfont big">&#xf0e75;</span>|md_arrow_top_left_bottom_right|
|<span class="nerdfont big">&#xf0e76;</span>|md_arrow_top_left_bottom_right_bold|
|<span class="nerdfont big">&#xf09c4;</span>|md_arrow_top_left_thick|
|<span class="nerdfont big">&#xf19b5;</span>|md_arrow_top_left_thin|
|<span class="nerdfont big">&#xf1593;</span>|md_arrow_top_left_thin_circle_outline|
|<span class="nerdfont big">&#xf005c;</span>|md_arrow_top_right|
|<span class="nerdfont big">&#xf196a;</span>|md_arrow_top_right_bold_box|
|<span class="nerdfont big">&#xf196b;</span>|md_arrow_top_right_bold_box_outline|
|<span class="nerdfont big">&#xf09c5;</span>|md_arrow_top_right_bold_outline|
|<span class="nerdfont big">&#xf0e77;</span>|md_arrow_top_right_bottom_left|
|<span class="nerdfont big">&#xf0e78;</span>|md_arrow_top_right_bottom_left_bold|
|<span class="nerdfont big">&#xf09c6;</span>|md_arrow_top_right_thick|
|<span class="nerdfont big">&#xf19b4;</span>|md_arrow_top_right_thin|
|<span class="nerdfont big">&#xf1594;</span>|md_arrow_top_right_thin_circle_outline|
|<span class="nerdfont big">&#xf17ad;</span>|md_arrow_u_down_left|
|<span class="nerdfont big">&#xf17ae;</span>|md_arrow_u_down_left_bold|
|<span class="nerdfont big">&#xf17af;</span>|md_arrow_u_down_right|
|<span class="nerdfont big">&#xf17b0;</span>|md_arrow_u_down_right_bold|
|<span class="nerdfont big">&#xf17b1;</span>|md_arrow_u_left_bottom|
|<span class="nerdfont big">&#xf17b2;</span>|md_arrow_u_left_bottom_bold|
|<span class="nerdfont big">&#xf17b3;</span>|md_arrow_u_left_top|
|<span class="nerdfont big">&#xf17b4;</span>|md_arrow_u_left_top_bold|
|<span class="nerdfont big">&#xf17b5;</span>|md_arrow_u_right_bottom|
|<span class="nerdfont big">&#xf17b6;</span>|md_arrow_u_right_bottom_bold|
|<span class="nerdfont big">&#xf17b7;</span>|md_arrow_u_right_top|
|<span class="nerdfont big">&#xf17b8;</span>|md_arrow_u_right_top_bold|
|<span class="nerdfont big">&#xf17b9;</span>|md_arrow_u_up_left|
|<span class="nerdfont big">&#xf17ba;</span>|md_arrow_u_up_left_bold|
|<span class="nerdfont big">&#xf17bb;</span>|md_arrow_u_up_right|
|<span class="nerdfont big">&#xf17bc;</span>|md_arrow_u_up_right_bold|
|<span class="nerdfont big">&#xf005d;</span>|md_arrow_up|
|<span class="nerdfont big">&#xf0737;</span>|md_arrow_up_bold|
|<span class="nerdfont big">&#xf0738;</span>|md_arrow_up_bold_box|
|<span class="nerdfont big">&#xf0739;</span>|md_arrow_up_bold_box_outline|
|<span class="nerdfont big">&#xf005f;</span>|md_arrow_up_bold_circle|
|<span class="nerdfont big">&#xf0060;</span>|md_arrow_up_bold_circle_outline|
|<span class="nerdfont big">&#xf0061;</span>|md_arrow_up_bold_hexagon_outline|
|<span class="nerdfont big">&#xf09c7;</span>|md_arrow_up_bold_outline|
|<span class="nerdfont big">&#xf06c3;</span>|md_arrow_up_box|
|<span class="nerdfont big">&#xf0ce1;</span>|md_arrow_up_circle|
|<span class="nerdfont big">&#xf0ce2;</span>|md_arrow_up_circle_outline|
|<span class="nerdfont big">&#xf0e79;</span>|md_arrow_up_down|
|<span class="nerdfont big">&#xf0e7a;</span>|md_arrow_up_down_bold|
|<span class="nerdfont big">&#xf09c8;</span>|md_arrow_up_down_bold_outline|
|<span class="nerdfont big">&#xf0062;</span>|md_arrow_up_drop_circle|
|<span class="nerdfont big">&#xf0063;</span>|md_arrow_up_drop_circle_outline|
|<span class="nerdfont big">&#xf17bd;</span>|md_arrow_up_left|
|<span class="nerdfont big">&#xf17be;</span>|md_arrow_up_left_bold|
|<span class="nerdfont big">&#xf17bf;</span>|md_arrow_up_right|
|<span class="nerdfont big">&#xf17c0;</span>|md_arrow_up_right_bold|
|<span class="nerdfont big">&#xf005e;</span>|md_arrow_up_thick|
|<span class="nerdfont big">&#xf19b2;</span>|md_arrow_up_thin|
|<span class="nerdfont big">&#xf1597;</span>|md_arrow_up_thin_circle_outline|
|<span class="nerdfont big">&#xf115c;</span>|md_arrow_vertical_lock|
|<span class="nerdfont big">&#xf0b5b;</span>|md_artstation|
|<span class="nerdfont big">&#xf0a24;</span>|md_aspect_ratio|
|<span class="nerdfont big">&#xf0064;</span>|md_assistant|
|<span class="nerdfont big">&#xf06c4;</span>|md_asterisk|
|<span class="nerdfont big">&#xf1a27;</span>|md_asterisk_circle_outline|
|<span class="nerdfont big">&#xf0065;</span>|md_at|
|<span class="nerdfont big">&#xf0804;</span>|md_atlassian|
|<span class="nerdfont big">&#xf0d47;</span>|md_atm|
|<span class="nerdfont big">&#xf0768;</span>|md_atom|
|<span class="nerdfont big">&#xf0e7b;</span>|md_atom_variant|
|<span class="nerdfont big">&#xf0066;</span>|md_attachment|
|<span class="nerdfont big">&#xf1ac1;</span>|md_attachment_check|
|<span class="nerdfont big">&#xf19c4;</span>|md_attachment_lock|
|<span class="nerdfont big">&#xf1ac2;</span>|md_attachment_minus|
|<span class="nerdfont big">&#xf1ac3;</span>|md_attachment_off|
|<span class="nerdfont big">&#xf1ac4;</span>|md_attachment_plus|
|<span class="nerdfont big">&#xf1ac5;</span>|md_attachment_remove|
|<span class="nerdfont big">&#xf186b;</span>|md_audio_input_rca|
|<span class="nerdfont big">&#xf186c;</span>|md_audio_input_stereo_minijack|
|<span class="nerdfont big">&#xf186d;</span>|md_audio_input_xlr|
|<span class="nerdfont big">&#xf093d;</span>|md_audio_video|
|<span class="nerdfont big">&#xf11b6;</span>|md_audio_video_off|
|<span class="nerdfont big">&#xf0850;</span>|md_augmented_reality|
|<span class="nerdfont big">&#xf137e;</span>|md_auto_download|
|<span class="nerdfont big">&#xf0068;</span>|md_auto_fix|
|<span class="nerdfont big">&#xf0069;</span>|md_auto_upload|
|<span class="nerdfont big">&#xf006a;</span>|md_autorenew|
|<span class="nerdfont big">&#xf19e7;</span>|md_autorenew_off|
|<span class="nerdfont big">&#xf006b;</span>|md_av_timer|
|<span class="nerdfont big">&#xf0e0f;</span>|md_aws|
|<span class="nerdfont big">&#xf08c8;</span>|md_axe|
|<span class="nerdfont big">&#xf1842;</span>|md_axe_battle|
|<span class="nerdfont big">&#xf0d48;</span>|md_axis|
|<span class="nerdfont big">&#xf0d49;</span>|md_axis_arrow|
|<span class="nerdfont big">&#xf140e;</span>|md_axis_arrow_info|
|<span class="nerdfont big">&#xf0d4a;</span>|md_axis_arrow_lock|
|<span class="nerdfont big">&#xf0d4b;</span>|md_axis_lock|
|<span class="nerdfont big">&#xf0d4c;</span>|md_axis_x_arrow|
|<span class="nerdfont big">&#xf0d4d;</span>|md_axis_x_arrow_lock|
|<span class="nerdfont big">&#xf0d4e;</span>|md_axis_x_rotate_clockwise|
|<span class="nerdfont big">&#xf0d4f;</span>|md_axis_x_rotate_counterclockwise|
|<span class="nerdfont big">&#xf0d50;</span>|md_axis_x_y_arrow_lock|
|<span class="nerdfont big">&#xf0d51;</span>|md_axis_y_arrow|
|<span class="nerdfont big">&#xf0d52;</span>|md_axis_y_arrow_lock|
|<span class="nerdfont big">&#xf0d53;</span>|md_axis_y_rotate_clockwise|
|<span class="nerdfont big">&#xf0d54;</span>|md_axis_y_rotate_counterclockwise|
|<span class="nerdfont big">&#xf0d55;</span>|md_axis_z_arrow|
|<span class="nerdfont big">&#xf0d56;</span>|md_axis_z_arrow_lock|
|<span class="nerdfont big">&#xf0d57;</span>|md_axis_z_rotate_clockwise|
|<span class="nerdfont big">&#xf0d58;</span>|md_axis_z_rotate_counterclockwise|
|<span class="nerdfont big">&#xf0a25;</span>|md_babel|
|<span class="nerdfont big">&#xf006c;</span>|md_baby|
|<span class="nerdfont big">&#xf0f39;</span>|md_baby_bottle|
|<span class="nerdfont big">&#xf0f3a;</span>|md_baby_bottle_outline|
|<span class="nerdfont big">&#xf13e0;</span>|md_baby_buggy|
|<span class="nerdfont big">&#xf068f;</span>|md_baby_carriage|
|<span class="nerdfont big">&#xf0fa0;</span>|md_baby_carriage_off|
|<span class="nerdfont big">&#xf0e7c;</span>|md_baby_face|
|<span class="nerdfont big">&#xf0e7d;</span>|md_baby_face_outline|
|<span class="nerdfont big">&#xf006d;</span>|md_backburger|
|<span class="nerdfont big">&#xf006e;</span>|md_backspace|
|<span class="nerdfont big">&#xf0b5c;</span>|md_backspace_outline|
|<span class="nerdfont big">&#xf0e7e;</span>|md_backspace_reverse|
|<span class="nerdfont big">&#xf0e7f;</span>|md_backspace_reverse_outline|
|<span class="nerdfont big">&#xf006f;</span>|md_backup_restore|
|<span class="nerdfont big">&#xf0ed5;</span>|md_bacteria|
|<span class="nerdfont big">&#xf0ed6;</span>|md_bacteria_outline|
|<span class="nerdfont big">&#xf0da7;</span>|md_badge_account|
|<span class="nerdfont big">&#xf0da8;</span>|md_badge_account_alert|
|<span class="nerdfont big">&#xf0da9;</span>|md_badge_account_alert_outline|
|<span class="nerdfont big">&#xf0e0d;</span>|md_badge_account_horizontal|
|<span class="nerdfont big">&#xf0e0e;</span>|md_badge_account_horizontal_outline|
|<span class="nerdfont big">&#xf0daa;</span>|md_badge_account_outline|
|<span class="nerdfont big">&#xf0851;</span>|md_badminton|
|<span class="nerdfont big">&#xf0f3b;</span>|md_bag_carry_on|
|<span class="nerdfont big">&#xf0d65;</span>|md_bag_carry_on_check|
|<span class="nerdfont big">&#xf0f3c;</span>|md_bag_carry_on_off|
|<span class="nerdfont big">&#xf0f3d;</span>|md_bag_checked|
|<span class="nerdfont big">&#xf0e10;</span>|md_bag_personal|
|<span class="nerdfont big">&#xf0e11;</span>|md_bag_personal_off|
|<span class="nerdfont big">&#xf0e12;</span>|md_bag_personal_off_outline|
|<span class="nerdfont big">&#xf0e13;</span>|md_bag_personal_outline|
|<span class="nerdfont big">&#xf158b;</span>|md_bag_suitcase|
|<span class="nerdfont big">&#xf158d;</span>|md_bag_suitcase_off|
|<span class="nerdfont big">&#xf158e;</span>|md_bag_suitcase_off_outline|
|<span class="nerdfont big">&#xf158c;</span>|md_bag_suitcase_outline|
|<span class="nerdfont big">&#xf0f3e;</span>|md_baguette|
|<span class="nerdfont big">&#xf1817;</span>|md_balcony|
|<span class="nerdfont big">&#xf0a26;</span>|md_balloon|
|<span class="nerdfont big">&#xf09c9;</span>|md_ballot|
|<span class="nerdfont big">&#xf09ca;</span>|md_ballot_outline|
|<span class="nerdfont big">&#xf0c39;</span>|md_ballot_recount|
|<span class="nerdfont big">&#xf0c3a;</span>|md_ballot_recount_outline|
|<span class="nerdfont big">&#xf0daf;</span>|md_bandage|
|<span class="nerdfont big">&#xf0070;</span>|md_bank|
|<span class="nerdfont big">&#xf1655;</span>|md_bank_check|
|<span class="nerdfont big">&#xf0db0;</span>|md_bank_minus|
|<span class="nerdfont big">&#xf1656;</span>|md_bank_off|
|<span class="nerdfont big">&#xf1657;</span>|md_bank_off_outline|
|<span class="nerdfont big">&#xf0e80;</span>|md_bank_outline|
|<span class="nerdfont big">&#xf0db1;</span>|md_bank_plus|
|<span class="nerdfont big">&#xf0db2;</span>|md_bank_remove|
|<span class="nerdfont big">&#xf0a27;</span>|md_bank_transfer|
|<span class="nerdfont big">&#xf0a28;</span>|md_bank_transfer_in|
|<span class="nerdfont big">&#xf0a29;</span>|md_bank_transfer_out|
|<span class="nerdfont big">&#xf0071;</span>|md_barcode|
|<span class="nerdfont big">&#xf1236;</span>|md_barcode_off|
|<span class="nerdfont big">&#xf0072;</span>|md_barcode_scan|
|<span class="nerdfont big">&#xf0073;</span>|md_barley|
|<span class="nerdfont big">&#xf0b5d;</span>|md_barley_off|
|<span class="nerdfont big">&#xf0b5e;</span>|md_barn|
|<span class="nerdfont big">&#xf0074;</span>|md_barrel|
|<span class="nerdfont big">&#xf1a28;</span>|md_barrel_outline|
|<span class="nerdfont big">&#xf0852;</span>|md_baseball|
|<span class="nerdfont big">&#xf0853;</span>|md_baseball_bat|
|<span class="nerdfont big">&#xf15ec;</span>|md_baseball_diamond|
|<span class="nerdfont big">&#xf15ed;</span>|md_baseball_diamond_outline|
|<span class="nerdfont big">&#xf1183;</span>|md_bash|
|<span class="nerdfont big">&#xf0076;</span>|md_basket|
|<span class="nerdfont big">&#xf18e5;</span>|md_basket_check|
|<span class="nerdfont big">&#xf18e6;</span>|md_basket_check_outline|
|<span class="nerdfont big">&#xf0077;</span>|md_basket_fill|
|<span class="nerdfont big">&#xf1523;</span>|md_basket_minus|
|<span class="nerdfont big">&#xf1524;</span>|md_basket_minus_outline|
|<span class="nerdfont big">&#xf1525;</span>|md_basket_off|
|<span class="nerdfont big">&#xf1526;</span>|md_basket_off_outline|
|<span class="nerdfont big">&#xf1181;</span>|md_basket_outline|
|<span class="nerdfont big">&#xf1527;</span>|md_basket_plus|
|<span class="nerdfont big">&#xf1528;</span>|md_basket_plus_outline|
|<span class="nerdfont big">&#xf1529;</span>|md_basket_remove|
|<span class="nerdfont big">&#xf152a;</span>|md_basket_remove_outline|
|<span class="nerdfont big">&#xf0078;</span>|md_basket_unfill|
|<span class="nerdfont big">&#xf0806;</span>|md_basketball|
|<span class="nerdfont big">&#xf0c3b;</span>|md_basketball_hoop|
|<span class="nerdfont big">&#xf0c3c;</span>|md_basketball_hoop_outline|
|<span class="nerdfont big">&#xf0b5f;</span>|md_bat|
|<span class="nerdfont big">&#xf1818;</span>|md_bathtub|
|<span class="nerdfont big">&#xf1819;</span>|md_bathtub_outline|
|<span class="nerdfont big">&#xf0079;</span>|md_battery|
|<span class="nerdfont big">&#xf007a;</span>|md_battery_10|
|<span class="nerdfont big">&#xf093e;</span>|md_battery_10_bluetooth|
|<span class="nerdfont big">&#xf007b;</span>|md_battery_20|
|<span class="nerdfont big">&#xf093f;</span>|md_battery_20_bluetooth|
|<span class="nerdfont big">&#xf007c;</span>|md_battery_30|
|<span class="nerdfont big">&#xf0940;</span>|md_battery_30_bluetooth|
|<span class="nerdfont big">&#xf007d;</span>|md_battery_40|
|<span class="nerdfont big">&#xf0941;</span>|md_battery_40_bluetooth|
|<span class="nerdfont big">&#xf007e;</span>|md_battery_50|
|<span class="nerdfont big">&#xf0942;</span>|md_battery_50_bluetooth|
|<span class="nerdfont big">&#xf007f;</span>|md_battery_60|
|<span class="nerdfont big">&#xf0943;</span>|md_battery_60_bluetooth|
|<span class="nerdfont big">&#xf0080;</span>|md_battery_70|
|<span class="nerdfont big">&#xf0944;</span>|md_battery_70_bluetooth|
|<span class="nerdfont big">&#xf0081;</span>|md_battery_80|
|<span class="nerdfont big">&#xf0945;</span>|md_battery_80_bluetooth|
|<span class="nerdfont big">&#xf0082;</span>|md_battery_90|
|<span class="nerdfont big">&#xf0946;</span>|md_battery_90_bluetooth|
|<span class="nerdfont big">&#xf0083;</span>|md_battery_alert|
|<span class="nerdfont big">&#xf0947;</span>|md_battery_alert_bluetooth|
|<span class="nerdfont big">&#xf10cc;</span>|md_battery_alert_variant|
|<span class="nerdfont big">&#xf10cd;</span>|md_battery_alert_variant_outline|
|<span class="nerdfont big">&#xf17de;</span>|md_battery_arrow_down|
|<span class="nerdfont big">&#xf17df;</span>|md_battery_arrow_down_outline|
|<span class="nerdfont big">&#xf17e0;</span>|md_battery_arrow_up|
|<span class="nerdfont big">&#xf17e1;</span>|md_battery_arrow_up_outline|
|<span class="nerdfont big">&#xf0948;</span>|md_battery_bluetooth|
|<span class="nerdfont big">&#xf0949;</span>|md_battery_bluetooth_variant|
|<span class="nerdfont big">&#xf0084;</span>|md_battery_charging|
|<span class="nerdfont big">&#xf089c;</span>|md_battery_charging_10|
|<span class="nerdfont big">&#xf0086;</span>|md_battery_charging_20|
|<span class="nerdfont big">&#xf0087;</span>|md_battery_charging_30|
|<span class="nerdfont big">&#xf0088;</span>|md_battery_charging_40|
|<span class="nerdfont big">&#xf089d;</span>|md_battery_charging_50|
|<span class="nerdfont big">&#xf0089;</span>|md_battery_charging_60|
|<span class="nerdfont big">&#xf089e;</span>|md_battery_charging_70|
|<span class="nerdfont big">&#xf008a;</span>|md_battery_charging_80|
|<span class="nerdfont big">&#xf008b;</span>|md_battery_charging_90|
|<span class="nerdfont big">&#xf0085;</span>|md_battery_charging_100|
|<span class="nerdfont big">&#xf12a6;</span>|md_battery_charging_high|
|<span class="nerdfont big">&#xf12a4;</span>|md_battery_charging_low|
|<span class="nerdfont big">&#xf12a5;</span>|md_battery_charging_medium|
|<span class="nerdfont big">&#xf089f;</span>|md_battery_charging_outline|
|<span class="nerdfont big">&#xf0807;</span>|md_battery_charging_wireless|
|<span class="nerdfont big">&#xf0808;</span>|md_battery_charging_wireless_10|
|<span class="nerdfont big">&#xf0809;</span>|md_battery_charging_wireless_20|
|<span class="nerdfont big">&#xf080a;</span>|md_battery_charging_wireless_30|
|<span class="nerdfont big">&#xf080b;</span>|md_battery_charging_wireless_40|
|<span class="nerdfont big">&#xf080c;</span>|md_battery_charging_wireless_50|
|<span class="nerdfont big">&#xf080d;</span>|md_battery_charging_wireless_60|
|<span class="nerdfont big">&#xf080e;</span>|md_battery_charging_wireless_70|
|<span class="nerdfont big">&#xf080f;</span>|md_battery_charging_wireless_80|
|<span class="nerdfont big">&#xf0810;</span>|md_battery_charging_wireless_90|
|<span class="nerdfont big">&#xf0811;</span>|md_battery_charging_wireless_alert|
|<span class="nerdfont big">&#xf0812;</span>|md_battery_charging_wireless_outline|
|<span class="nerdfont big">&#xf17e2;</span>|md_battery_check|
|<span class="nerdfont big">&#xf17e3;</span>|md_battery_check_outline|
|<span class="nerdfont big">&#xf19e5;</span>|md_battery_clock|
|<span class="nerdfont big">&#xf19e6;</span>|md_battery_clock_outline|
|<span class="nerdfont big">&#xf120f;</span>|md_battery_heart|
|<span class="nerdfont big">&#xf1210;</span>|md_battery_heart_outline|
|<span class="nerdfont big">&#xf1211;</span>|md_battery_heart_variant|
|<span class="nerdfont big">&#xf12a3;</span>|md_battery_high|
|<span class="nerdfont big">&#xf179c;</span>|md_battery_lock|
|<span class="nerdfont big">&#xf179d;</span>|md_battery_lock_open|
|<span class="nerdfont big">&#xf12a1;</span>|md_battery_low|
|<span class="nerdfont big">&#xf12a2;</span>|md_battery_medium|
|<span class="nerdfont big">&#xf17e4;</span>|md_battery_minus|
|<span class="nerdfont big">&#xf17e5;</span>|md_battery_minus_outline|
|<span class="nerdfont big">&#xf008c;</span>|md_battery_minus_variant|
|<span class="nerdfont big">&#xf008d;</span>|md_battery_negative|
|<span class="nerdfont big">&#xf125d;</span>|md_battery_off|
|<span class="nerdfont big">&#xf125e;</span>|md_battery_off_outline|
|<span class="nerdfont big">&#xf008e;</span>|md_battery_outline|
|<span class="nerdfont big">&#xf17e6;</span>|md_battery_plus|
|<span class="nerdfont big">&#xf17e7;</span>|md_battery_plus_outline|
|<span class="nerdfont big">&#xf008f;</span>|md_battery_plus_variant|
|<span class="nerdfont big">&#xf0090;</span>|md_battery_positive|
|<span class="nerdfont big">&#xf17e8;</span>|md_battery_remove|
|<span class="nerdfont big">&#xf17e9;</span>|md_battery_remove_outline|
|<span class="nerdfont big">&#xf1834;</span>|md_battery_sync|
|<span class="nerdfont big">&#xf1835;</span>|md_battery_sync_outline|
|<span class="nerdfont big">&#xf0091;</span>|md_battery_unknown|
|<span class="nerdfont big">&#xf094a;</span>|md_battery_unknown_bluetooth|
|<span class="nerdfont big">&#xf0092;</span>|md_beach|
|<span class="nerdfont big">&#xf0cea;</span>|md_beaker|
|<span class="nerdfont big">&#xf1229;</span>|md_beaker_alert|
|<span class="nerdfont big">&#xf122a;</span>|md_beaker_alert_outline|
|<span class="nerdfont big">&#xf122b;</span>|md_beaker_check|
|<span class="nerdfont big">&#xf122c;</span>|md_beaker_check_outline|
|<span class="nerdfont big">&#xf122d;</span>|md_beaker_minus|
|<span class="nerdfont big">&#xf122e;</span>|md_beaker_minus_outline|
|<span class="nerdfont big">&#xf0690;</span>|md_beaker_outline|
|<span class="nerdfont big">&#xf122f;</span>|md_beaker_plus|
|<span class="nerdfont big">&#xf1230;</span>|md_beaker_plus_outline|
|<span class="nerdfont big">&#xf1231;</span>|md_beaker_question|
|<span class="nerdfont big">&#xf1232;</span>|md_beaker_question_outline|
|<span class="nerdfont big">&#xf1233;</span>|md_beaker_remove|
|<span class="nerdfont big">&#xf1234;</span>|md_beaker_remove_outline|
|<span class="nerdfont big">&#xf02e3;</span>|md_bed|
|<span class="nerdfont big">&#xf0fd4;</span>|md_bed_double|
|<span class="nerdfont big">&#xf0fd3;</span>|md_bed_double_outline|
|<span class="nerdfont big">&#xf08a0;</span>|md_bed_empty|
|<span class="nerdfont big">&#xf0fd2;</span>|md_bed_king|
|<span class="nerdfont big">&#xf0fd1;</span>|md_bed_king_outline|
|<span class="nerdfont big">&#xf0099;</span>|md_bed_outline|
|<span class="nerdfont big">&#xf0fd0;</span>|md_bed_queen|
|<span class="nerdfont big">&#xf0fdb;</span>|md_bed_queen_outline|
|<span class="nerdfont big">&#xf106d;</span>|md_bed_single|
|<span class="nerdfont big">&#xf106e;</span>|md_bed_single_outline|
|<span class="nerdfont big">&#xf0fa1;</span>|md_bee|
|<span class="nerdfont big">&#xf0fa2;</span>|md_bee_flower|
|<span class="nerdfont big">&#xf13ed;</span>|md_beehive_off_outline|
|<span class="nerdfont big">&#xf10ce;</span>|md_beehive_outline|
|<span class="nerdfont big">&#xf14e2;</span>|md_beekeeper|
|<span class="nerdfont big">&#xf0098;</span>|md_beer|
|<span class="nerdfont big">&#xf130c;</span>|md_beer_outline|
|<span class="nerdfont big">&#xf009a;</span>|md_bell|
|<span class="nerdfont big">&#xf0d59;</span>|md_bell_alert|
|<span class="nerdfont big">&#xf0e81;</span>|md_bell_alert_outline|
|<span class="nerdfont big">&#xf116b;</span>|md_bell_badge|
|<span class="nerdfont big">&#xf0178;</span>|md_bell_badge_outline|
|<span class="nerdfont big">&#xf13e7;</span>|md_bell_cancel|
|<span class="nerdfont big">&#xf13e8;</span>|md_bell_cancel_outline|
|<span class="nerdfont big">&#xf11e5;</span>|md_bell_check|
|<span class="nerdfont big">&#xf11e6;</span>|md_bell_check_outline|
|<span class="nerdfont big">&#xf0d5a;</span>|md_bell_circle|
|<span class="nerdfont big">&#xf0d5b;</span>|md_bell_circle_outline|
|<span class="nerdfont big">&#xf1a29;</span>|md_bell_cog|
|<span class="nerdfont big">&#xf1a2a;</span>|md_bell_cog_outline|
|<span class="nerdfont big">&#xf13e9;</span>|md_bell_minus|
|<span class="nerdfont big">&#xf13ea;</span>|md_bell_minus_outline|
|<span class="nerdfont big">&#xf009b;</span>|md_bell_off|
|<span class="nerdfont big">&#xf0a91;</span>|md_bell_off_outline|
|<span class="nerdfont big">&#xf009c;</span>|md_bell_outline|
|<span class="nerdfont big">&#xf009d;</span>|md_bell_plus|
|<span class="nerdfont big">&#xf0a92;</span>|md_bell_plus_outline|
|<span class="nerdfont big">&#xf13eb;</span>|md_bell_remove|
|<span class="nerdfont big">&#xf13ec;</span>|md_bell_remove_outline|
|<span class="nerdfont big">&#xf009e;</span>|md_bell_ring|
|<span class="nerdfont big">&#xf009f;</span>|md_bell_ring_outline|
|<span class="nerdfont big">&#xf00a0;</span>|md_bell_sleep|
|<span class="nerdfont big">&#xf0a93;</span>|md_bell_sleep_outline|
|<span class="nerdfont big">&#xf00a1;</span>|md_beta|
|<span class="nerdfont big">&#xf09cb;</span>|md_betamax|
|<span class="nerdfont big">&#xf0e14;</span>|md_biathlon|
|<span class="nerdfont big">&#xf109c;</span>|md_bicycle|
|<span class="nerdfont big">&#xf1235;</span>|md_bicycle_basket|
|<span class="nerdfont big">&#xf189c;</span>|md_bicycle_cargo|
|<span class="nerdfont big">&#xf15b4;</span>|md_bicycle_electric|
|<span class="nerdfont big">&#xf15e9;</span>|md_bicycle_penny_farthing|
|<span class="nerdfont big">&#xf00a3;</span>|md_bike|
|<span class="nerdfont big">&#xf111f;</span>|md_bike_fast|
|<span class="nerdfont big">&#xf1010;</span>|md_billboard|
|<span class="nerdfont big">&#xf0b61;</span>|md_billiards|
|<span class="nerdfont big">&#xf0b62;</span>|md_billiards_rack|
|<span class="nerdfont big">&#xf00a5;</span>|md_binoculars|
|<span class="nerdfont big">&#xf00a6;</span>|md_bio|
|<span class="nerdfont big">&#xf00a7;</span>|md_biohazard|
|<span class="nerdfont big">&#xf15c6;</span>|md_bird|
|<span class="nerdfont big">&#xf00a8;</span>|md_bitbucket|
|<span class="nerdfont big">&#xf0813;</span>|md_bitcoin|
|<span class="nerdfont big">&#xf00a9;</span>|md_black_mesa|
|<span class="nerdfont big">&#xf0ceb;</span>|md_blender|
|<span class="nerdfont big">&#xf181a;</span>|md_blender_outline|
|<span class="nerdfont big">&#xf00ab;</span>|md_blender_software|
|<span class="nerdfont big">&#xf00ac;</span>|md_blinds|
|<span class="nerdfont big">&#xf1a2b;</span>|md_blinds_horizontal|
|<span class="nerdfont big">&#xf1a2c;</span>|md_blinds_horizontal_closed|
|<span class="nerdfont big">&#xf1011;</span>|md_blinds_open|
|<span class="nerdfont big">&#xf1a2d;</span>|md_blinds_vertical|
|<span class="nerdfont big">&#xf1a2e;</span>|md_blinds_vertical_closed|
|<span class="nerdfont big">&#xf00ad;</span>|md_block_helper|
|<span class="nerdfont big">&#xf0cec;</span>|md_blood_bag|
|<span class="nerdfont big">&#xf00af;</span>|md_bluetooth|
|<span class="nerdfont big">&#xf00b0;</span>|md_bluetooth_audio|
|<span class="nerdfont big">&#xf00b1;</span>|md_bluetooth_connect|
|<span class="nerdfont big">&#xf00b2;</span>|md_bluetooth_off|
|<span class="nerdfont big">&#xf00b3;</span>|md_bluetooth_settings|
|<span class="nerdfont big">&#xf00b4;</span>|md_bluetooth_transfer|
|<span class="nerdfont big">&#xf00b5;</span>|md_blur|
|<span class="nerdfont big">&#xf00b6;</span>|md_blur_linear|
|<span class="nerdfont big">&#xf00b7;</span>|md_blur_off|
|<span class="nerdfont big">&#xf00b8;</span>|md_blur_radial|
|<span class="nerdfont big">&#xf0db3;</span>|md_bolt|
|<span class="nerdfont big">&#xf0691;</span>|md_bomb|
|<span class="nerdfont big">&#xf06c5;</span>|md_bomb_off|
|<span class="nerdfont big">&#xf00b9;</span>|md_bone|
|<span class="nerdfont big">&#xf19e0;</span>|md_bone_off|
|<span class="nerdfont big">&#xf00ba;</span>|md_book|
|<span class="nerdfont big">&#xf13ad;</span>|md_book_account|
|<span class="nerdfont big">&#xf13ae;</span>|md_book_account_outline|
|<span class="nerdfont big">&#xf167c;</span>|md_book_alert|
|<span class="nerdfont big">&#xf167d;</span>|md_book_alert_outline|
|<span class="nerdfont big">&#xf061d;</span>|md_book_alphabet|
|<span class="nerdfont big">&#xf167e;</span>|md_book_arrow_down|
|<span class="nerdfont big">&#xf167f;</span>|md_book_arrow_down_outline|
|<span class="nerdfont big">&#xf1680;</span>|md_book_arrow_left|
|<span class="nerdfont big">&#xf1681;</span>|md_book_arrow_left_outline|
|<span class="nerdfont big">&#xf1682;</span>|md_book_arrow_right|
|<span class="nerdfont big">&#xf1683;</span>|md_book_arrow_right_outline|
|<span class="nerdfont big">&#xf1684;</span>|md_book_arrow_up|
|<span class="nerdfont big">&#xf1685;</span>|md_book_arrow_up_outline|
|<span class="nerdfont big">&#xf1686;</span>|md_book_cancel|
|<span class="nerdfont big">&#xf1687;</span>|md_book_cancel_outline|
|<span class="nerdfont big">&#xf14f3;</span>|md_book_check|
|<span class="nerdfont big">&#xf14f4;</span>|md_book_check_outline|
|<span class="nerdfont big">&#xf1688;</span>|md_book_clock|
|<span class="nerdfont big">&#xf1689;</span>|md_book_clock_outline|
|<span class="nerdfont big">&#xf168a;</span>|md_book_cog|
|<span class="nerdfont big">&#xf168b;</span>|md_book_cog_outline|
|<span class="nerdfont big">&#xf00a2;</span>|md_book_cross|
|<span class="nerdfont big">&#xf168c;</span>|md_book_edit|
|<span class="nerdfont big">&#xf168d;</span>|md_book_edit_outline|
|<span class="nerdfont big">&#xf16c9;</span>|md_book_education|
|<span class="nerdfont big">&#xf16ca;</span>|md_book_education_outline|
|<span class="nerdfont big">&#xf1a1d;</span>|md_book_heart|
|<span class="nerdfont big">&#xf1a1e;</span>|md_book_heart_outline|
|<span class="nerdfont big">&#xf106f;</span>|md_book_information_variant|
|<span class="nerdfont big">&#xf079a;</span>|md_book_lock|
|<span class="nerdfont big">&#xf079b;</span>|md_book_lock_open|
|<span class="nerdfont big">&#xf168e;</span>|md_book_lock_open_outline|
|<span class="nerdfont big">&#xf168f;</span>|md_book_lock_outline|
|<span class="nerdfont big">&#xf1690;</span>|md_book_marker|
|<span class="nerdfont big">&#xf1691;</span>|md_book_marker_outline|
|<span class="nerdfont big">&#xf05d9;</span>|md_book_minus|
|<span class="nerdfont big">&#xf0a94;</span>|md_book_minus_multiple|
|<span class="nerdfont big">&#xf090b;</span>|md_book_minus_multiple_outline|
|<span class="nerdfont big">&#xf1692;</span>|md_book_minus_outline|
|<span class="nerdfont big">&#xf00bb;</span>|md_book_multiple|
|<span class="nerdfont big">&#xf0436;</span>|md_book_multiple_outline|
|<span class="nerdfont big">&#xf0067;</span>|md_book_music|
|<span class="nerdfont big">&#xf1693;</span>|md_book_music_outline|
|<span class="nerdfont big">&#xf1694;</span>|md_book_off|
|<span class="nerdfont big">&#xf1695;</span>|md_book_off_outline|
|<span class="nerdfont big">&#xf00bd;</span>|md_book_open|
|<span class="nerdfont big">&#xf00be;</span>|md_book_open_blank_variant|
|<span class="nerdfont big">&#xf0b63;</span>|md_book_open_outline|
|<span class="nerdfont big">&#xf05da;</span>|md_book_open_page_variant|
|<span class="nerdfont big">&#xf15d6;</span>|md_book_open_page_variant_outline|
|<span class="nerdfont big">&#xf14f7;</span>|md_book_open_variant|
|<span class="nerdfont big">&#xf0b64;</span>|md_book_outline|
|<span class="nerdfont big">&#xf0e82;</span>|md_book_play|
|<span class="nerdfont big">&#xf0e83;</span>|md_book_play_outline|
|<span class="nerdfont big">&#xf05db;</span>|md_book_plus|
|<span class="nerdfont big">&#xf0a95;</span>|md_book_plus_multiple|
|<span class="nerdfont big">&#xf0ade;</span>|md_book_plus_multiple_outline|
|<span class="nerdfont big">&#xf1696;</span>|md_book_plus_outline|
|<span class="nerdfont big">&#xf1697;</span>|md_book_refresh|
|<span class="nerdfont big">&#xf1698;</span>|md_book_refresh_outline|
|<span class="nerdfont big">&#xf0a97;</span>|md_book_remove|
|<span class="nerdfont big">&#xf0a96;</span>|md_book_remove_multiple|
|<span class="nerdfont big">&#xf04ca;</span>|md_book_remove_multiple_outline|
|<span class="nerdfont big">&#xf1699;</span>|md_book_remove_outline|
|<span class="nerdfont big">&#xf0e84;</span>|md_book_search|
|<span class="nerdfont big">&#xf0e85;</span>|md_book_search_outline|
|<span class="nerdfont big">&#xf169a;</span>|md_book_settings|
|<span class="nerdfont big">&#xf169b;</span>|md_book_settings_outline|
|<span class="nerdfont big">&#xf169c;</span>|md_book_sync|
|<span class="nerdfont big">&#xf16c8;</span>|md_book_sync_outline|
|<span class="nerdfont big">&#xf00bf;</span>|md_book_variant|
|<span class="nerdfont big">&#xf00bc;</span>|md_book_variant_multiple|
|<span class="nerdfont big">&#xf00c0;</span>|md_bookmark|
|<span class="nerdfont big">&#xf196c;</span>|md_bookmark_box_multiple|
|<span class="nerdfont big">&#xf196d;</span>|md_bookmark_box_multiple_outline|
|<span class="nerdfont big">&#xf00c1;</span>|md_bookmark_check|
|<span class="nerdfont big">&#xf137b;</span>|md_bookmark_check_outline|
|<span class="nerdfont big">&#xf09cc;</span>|md_bookmark_minus|
|<span class="nerdfont big">&#xf09cd;</span>|md_bookmark_minus_outline|
|<span class="nerdfont big">&#xf0e15;</span>|md_bookmark_multiple|
|<span class="nerdfont big">&#xf0e16;</span>|md_bookmark_multiple_outline|
|<span class="nerdfont big">&#xf00c2;</span>|md_bookmark_music|
|<span class="nerdfont big">&#xf1379;</span>|md_bookmark_music_outline|
|<span class="nerdfont big">&#xf09ce;</span>|md_bookmark_off|
|<span class="nerdfont big">&#xf09cf;</span>|md_bookmark_off_outline|
|<span class="nerdfont big">&#xf00c3;</span>|md_bookmark_outline|
|<span class="nerdfont big">&#xf00c5;</span>|md_bookmark_plus|
|<span class="nerdfont big">&#xf00c4;</span>|md_bookmark_plus_outline|
|<span class="nerdfont big">&#xf00c6;</span>|md_bookmark_remove|
|<span class="nerdfont big">&#xf137a;</span>|md_bookmark_remove_outline|
|<span class="nerdfont big">&#xf125f;</span>|md_bookshelf|
|<span class="nerdfont big">&#xf0e86;</span>|md_boom_gate|
|<span class="nerdfont big">&#xf0e87;</span>|md_boom_gate_alert|
|<span class="nerdfont big">&#xf0e88;</span>|md_boom_gate_alert_outline|
|<span class="nerdfont big">&#xf0e89;</span>|md_boom_gate_arrow_down|
|<span class="nerdfont big">&#xf0e8a;</span>|md_boom_gate_arrow_down_outline|
|<span class="nerdfont big">&#xf0e8c;</span>|md_boom_gate_arrow_up|
|<span class="nerdfont big">&#xf0e8d;</span>|md_boom_gate_arrow_up_outline|
|<span class="nerdfont big">&#xf0e8b;</span>|md_boom_gate_outline|
|<span class="nerdfont big">&#xf17f9;</span>|md_boom_gate_up|
|<span class="nerdfont big">&#xf17fa;</span>|md_boom_gate_up_outline|
|<span class="nerdfont big">&#xf05dc;</span>|md_boombox|
|<span class="nerdfont big">&#xf10cf;</span>|md_boomerang|
|<span class="nerdfont big">&#xf06c6;</span>|md_bootstrap|
|<span class="nerdfont big">&#xf00c7;</span>|md_border_all|
|<span class="nerdfont big">&#xf08a1;</span>|md_border_all_variant|
|<span class="nerdfont big">&#xf00c8;</span>|md_border_bottom|
|<span class="nerdfont big">&#xf08a2;</span>|md_border_bottom_variant|
|<span class="nerdfont big">&#xf00c9;</span>|md_border_color|
|<span class="nerdfont big">&#xf00ca;</span>|md_border_horizontal|
|<span class="nerdfont big">&#xf00cb;</span>|md_border_inside|
|<span class="nerdfont big">&#xf00cc;</span>|md_border_left|
|<span class="nerdfont big">&#xf08a3;</span>|md_border_left_variant|
|<span class="nerdfont big">&#xf00cd;</span>|md_border_none|
|<span class="nerdfont big">&#xf08a4;</span>|md_border_none_variant|
|<span class="nerdfont big">&#xf00ce;</span>|md_border_outside|
|<span class="nerdfont big">&#xf00cf;</span>|md_border_right|
|<span class="nerdfont big">&#xf08a5;</span>|md_border_right_variant|
|<span class="nerdfont big">&#xf00d0;</span>|md_border_style|
|<span class="nerdfont big">&#xf00d1;</span>|md_border_top|
|<span class="nerdfont big">&#xf08a6;</span>|md_border_top_variant|
|<span class="nerdfont big">&#xf00d2;</span>|md_border_vertical|
|<span class="nerdfont big">&#xf1070;</span>|md_bottle_soda|
|<span class="nerdfont big">&#xf1071;</span>|md_bottle_soda_classic|
|<span class="nerdfont big">&#xf1363;</span>|md_bottle_soda_classic_outline|
|<span class="nerdfont big">&#xf1072;</span>|md_bottle_soda_outline|
|<span class="nerdfont big">&#xf112e;</span>|md_bottle_tonic|
|<span class="nerdfont big">&#xf112f;</span>|md_bottle_tonic_outline|
|<span class="nerdfont big">&#xf1130;</span>|md_bottle_tonic_plus|
|<span class="nerdfont big">&#xf1131;</span>|md_bottle_tonic_plus_outline|
|<span class="nerdfont big">&#xf1132;</span>|md_bottle_tonic_skull|
|<span class="nerdfont big">&#xf1133;</span>|md_bottle_tonic_skull_outline|
|<span class="nerdfont big">&#xf0854;</span>|md_bottle_wine|
|<span class="nerdfont big">&#xf1310;</span>|md_bottle_wine_outline|
|<span class="nerdfont big">&#xf1841;</span>|md_bow_arrow|
|<span class="nerdfont big">&#xf0678;</span>|md_bow_tie|
|<span class="nerdfont big">&#xf028e;</span>|md_bowl|
|<span class="nerdfont big">&#xf0617;</span>|md_bowl_mix|
|<span class="nerdfont big">&#xf02e4;</span>|md_bowl_mix_outline|
|<span class="nerdfont big">&#xf02a9;</span>|md_bowl_outline|
|<span class="nerdfont big">&#xf00d3;</span>|md_bowling|
|<span class="nerdfont big">&#xf00d4;</span>|md_box|
|<span class="nerdfont big">&#xf00d5;</span>|md_box_cutter|
|<span class="nerdfont big">&#xf0b4a;</span>|md_box_cutter_off|
|<span class="nerdfont big">&#xf0637;</span>|md_box_shadow|
|<span class="nerdfont big">&#xf0b65;</span>|md_boxing_glove|
|<span class="nerdfont big">&#xf09d0;</span>|md_braille|
|<span class="nerdfont big">&#xf09d1;</span>|md_brain|
|<span class="nerdfont big">&#xf0cee;</span>|md_bread_slice|
|<span class="nerdfont big">&#xf0cef;</span>|md_bread_slice_outline|
|<span class="nerdfont big">&#xf0618;</span>|md_bridge|
|<span class="nerdfont big">&#xf00d6;</span>|md_briefcase|
|<span class="nerdfont big">&#xf0cf0;</span>|md_briefcase_account|
|<span class="nerdfont big">&#xf0cf1;</span>|md_briefcase_account_outline|
|<span class="nerdfont big">&#xf1a8d;</span>|md_briefcase_arrow_left_right|
|<span class="nerdfont big">&#xf1a8e;</span>|md_briefcase_arrow_left_right_outline|
|<span class="nerdfont big">&#xf1a8f;</span>|md_briefcase_arrow_up_down|
|<span class="nerdfont big">&#xf1a90;</span>|md_briefcase_arrow_up_down_outline|
|<span class="nerdfont big">&#xf00d7;</span>|md_briefcase_check|
|<span class="nerdfont big">&#xf131e;</span>|md_briefcase_check_outline|
|<span class="nerdfont big">&#xf10d0;</span>|md_briefcase_clock|
|<span class="nerdfont big">&#xf10d1;</span>|md_briefcase_clock_outline|
|<span class="nerdfont big">&#xf00d8;</span>|md_briefcase_download|
|<span class="nerdfont big">&#xf0c3d;</span>|md_briefcase_download_outline|
|<span class="nerdfont big">&#xf0a98;</span>|md_briefcase_edit|
|<span class="nerdfont big">&#xf0c3e;</span>|md_briefcase_edit_outline|
|<span class="nerdfont big">&#xf17d9;</span>|md_briefcase_eye|
|<span class="nerdfont big">&#xf17da;</span>|md_briefcase_eye_outline|
|<span class="nerdfont big">&#xf0a2a;</span>|md_briefcase_minus|
|<span class="nerdfont big">&#xf0c3f;</span>|md_briefcase_minus_outline|
|<span class="nerdfont big">&#xf1658;</span>|md_briefcase_off|
|<span class="nerdfont big">&#xf1659;</span>|md_briefcase_off_outline|
|<span class="nerdfont big">&#xf0814;</span>|md_briefcase_outline|
|<span class="nerdfont big">&#xf0a2b;</span>|md_briefcase_plus|
|<span class="nerdfont big">&#xf0c40;</span>|md_briefcase_plus_outline|
|<span class="nerdfont big">&#xf0a2c;</span>|md_briefcase_remove|
|<span class="nerdfont big">&#xf0c41;</span>|md_briefcase_remove_outline|
|<span class="nerdfont big">&#xf0a2d;</span>|md_briefcase_search|
|<span class="nerdfont big">&#xf0c42;</span>|md_briefcase_search_outline|
|<span class="nerdfont big">&#xf00d9;</span>|md_briefcase_upload|
|<span class="nerdfont big">&#xf0c43;</span>|md_briefcase_upload_outline|
|<span class="nerdfont big">&#xf1494;</span>|md_briefcase_variant|
|<span class="nerdfont big">&#xf165a;</span>|md_briefcase_variant_off|
|<span class="nerdfont big">&#xf165b;</span>|md_briefcase_variant_off_outline|
|<span class="nerdfont big">&#xf1495;</span>|md_briefcase_variant_outline|
|<span class="nerdfont big">&#xf00da;</span>|md_brightness_1|
|<span class="nerdfont big">&#xf00db;</span>|md_brightness_2|
|<span class="nerdfont big">&#xf00dc;</span>|md_brightness_3|
|<span class="nerdfont big">&#xf00dd;</span>|md_brightness_4|
|<span class="nerdfont big">&#xf00de;</span>|md_brightness_5|
|<span class="nerdfont big">&#xf00df;</span>|md_brightness_6|
|<span class="nerdfont big">&#xf00e0;</span>|md_brightness_7|
|<span class="nerdfont big">&#xf00e1;</span>|md_brightness_auto|
|<span class="nerdfont big">&#xf0cf2;</span>|md_brightness_percent|
|<span class="nerdfont big">&#xf1720;</span>|md_broadcast|
|<span class="nerdfont big">&#xf1721;</span>|md_broadcast_off|
|<span class="nerdfont big">&#xf00e2;</span>|md_broom|
|<span class="nerdfont big">&#xf00e3;</span>|md_brush|
|<span class="nerdfont big">&#xf1771;</span>|md_brush_off|
|<span class="nerdfont big">&#xf1a0d;</span>|md_brush_outline|
|<span class="nerdfont big">&#xf1813;</span>|md_brush_variant|
|<span class="nerdfont big">&#xf1415;</span>|md_bucket|
|<span class="nerdfont big">&#xf1416;</span>|md_bucket_outline|
|<span class="nerdfont big">&#xf0578;</span>|md_buffet|
|<span class="nerdfont big">&#xf00e4;</span>|md_bug|
|<span class="nerdfont big">&#xf0a2e;</span>|md_bug_check|
|<span class="nerdfont big">&#xf0a2f;</span>|md_bug_check_outline|
|<span class="nerdfont big">&#xf0a30;</span>|md_bug_outline|
|<span class="nerdfont big">&#xf0db4;</span>|md_bugle|
|<span class="nerdfont big">&#xf1a2f;</span>|md_bulkhead_light|
|<span class="nerdfont big">&#xf0b22;</span>|md_bulldozer|
|<span class="nerdfont big">&#xf0cf3;</span>|md_bullet|
|<span class="nerdfont big">&#xf00e5;</span>|md_bulletin_board|
|<span class="nerdfont big">&#xf00e6;</span>|md_bullhorn|
|<span class="nerdfont big">&#xf0b23;</span>|md_bullhorn_outline|
|<span class="nerdfont big">&#xf196e;</span>|md_bullhorn_variant|
|<span class="nerdfont big">&#xf196f;</span>|md_bullhorn_variant_outline|
|<span class="nerdfont big">&#xf05dd;</span>|md_bullseye|
|<span class="nerdfont big">&#xf08c9;</span>|md_bullseye_arrow|
|<span class="nerdfont big">&#xf12e7;</span>|md_bulma|
|<span class="nerdfont big">&#xf1302;</span>|md_bunk_bed|
|<span class="nerdfont big">&#xf0097;</span>|md_bunk_bed_outline|
|<span class="nerdfont big">&#xf00e7;</span>|md_bus|
|<span class="nerdfont big">&#xf0a99;</span>|md_bus_alert|
|<span class="nerdfont big">&#xf079c;</span>|md_bus_articulated_end|
|<span class="nerdfont big">&#xf079d;</span>|md_bus_articulated_front|
|<span class="nerdfont big">&#xf08ca;</span>|md_bus_clock|
|<span class="nerdfont big">&#xf079e;</span>|md_bus_double_decker|
|<span class="nerdfont big">&#xf191d;</span>|md_bus_electric|
|<span class="nerdfont big">&#xf1212;</span>|md_bus_marker|
|<span class="nerdfont big">&#xf0f3f;</span>|md_bus_multiple|
|<span class="nerdfont big">&#xf079f;</span>|md_bus_school|
|<span class="nerdfont big">&#xf07a0;</span>|md_bus_side|
|<span class="nerdfont big">&#xf1012;</span>|md_bus_stop|
|<span class="nerdfont big">&#xf1013;</span>|md_bus_stop_covered|
|<span class="nerdfont big">&#xf1014;</span>|md_bus_stop_uncovered|
|<span class="nerdfont big">&#xf1589;</span>|md_butterfly|
|<span class="nerdfont big">&#xf158a;</span>|md_butterfly_outline|
|<span class="nerdfont big">&#xf188c;</span>|md_cabin_a_frame|
|<span class="nerdfont big">&#xf1394;</span>|md_cable_data|
|<span class="nerdfont big">&#xf00e8;</span>|md_cached|
|<span class="nerdfont big">&#xf0db5;</span>|md_cactus|
|<span class="nerdfont big">&#xf00e9;</span>|md_cake|
|<span class="nerdfont big">&#xf00ea;</span>|md_cake_layered|
|<span class="nerdfont big">&#xf00eb;</span>|md_cake_variant|
|<span class="nerdfont big">&#xf17f0;</span>|md_cake_variant_outline|
|<span class="nerdfont big">&#xf00ec;</span>|md_calculator|
|<span class="nerdfont big">&#xf0a9a;</span>|md_calculator_variant|
|<span class="nerdfont big">&#xf15a6;</span>|md_calculator_variant_outline|
|<span class="nerdfont big">&#xf00ed;</span>|md_calendar|
|<span class="nerdfont big">&#xf0ed7;</span>|md_calendar_account|
|<span class="nerdfont big">&#xf0ed8;</span>|md_calendar_account_outline|
|<span class="nerdfont big">&#xf0a31;</span>|md_calendar_alert|
|<span class="nerdfont big">&#xf1134;</span>|md_calendar_arrow_left|
|<span class="nerdfont big">&#xf1135;</span>|md_calendar_arrow_right|
|<span class="nerdfont big">&#xf00ee;</span>|md_calendar_blank|
|<span class="nerdfont big">&#xf1073;</span>|md_calendar_blank_multiple|
|<span class="nerdfont big">&#xf0b66;</span>|md_calendar_blank_outline|
|<span class="nerdfont big">&#xf00ef;</span>|md_calendar_check|
|<span class="nerdfont big">&#xf0c44;</span>|md_calendar_check_outline|
|<span class="nerdfont big">&#xf00f0;</span>|md_calendar_clock|
|<span class="nerdfont big">&#xf16e1;</span>|md_calendar_clock_outline|
|<span class="nerdfont big">&#xf189d;</span>|md_calendar_collapse_horizontal|
|<span class="nerdfont big">&#xf157b;</span>|md_calendar_cursor|
|<span class="nerdfont big">&#xf08a7;</span>|md_calendar_edit|
|<span class="nerdfont big">&#xf166c;</span>|md_calendar_end|
|<span class="nerdfont big">&#xf189e;</span>|md_calendar_expand_horizontal|
|<span class="nerdfont big">&#xf0b24;</span>|md_calendar_export|
|<span class="nerdfont big">&#xf09d2;</span>|md_calendar_heart|
|<span class="nerdfont big">&#xf0b25;</span>|md_calendar_import|
|<span class="nerdfont big">&#xf1641;</span>|md_calendar_lock|
|<span class="nerdfont big">&#xf1642;</span>|md_calendar_lock_outline|
|<span class="nerdfont big">&#xf0d5c;</span>|md_calendar_minus|
|<span class="nerdfont big">&#xf0e17;</span>|md_calendar_month|
|<span class="nerdfont big">&#xf0e18;</span>|md_calendar_month_outline|
|<span class="nerdfont big">&#xf00f1;</span>|md_calendar_multiple|
|<span class="nerdfont big">&#xf00f2;</span>|md_calendar_multiple_check|
|<span class="nerdfont big">&#xf0a32;</span>|md_calendar_multiselect|
|<span class="nerdfont big">&#xf0b67;</span>|md_calendar_outline|
|<span class="nerdfont big">&#xf00f3;</span>|md_calendar_plus|
|<span class="nerdfont big">&#xf0692;</span>|md_calendar_question|
|<span class="nerdfont big">&#xf0679;</span>|md_calendar_range|
|<span class="nerdfont big">&#xf0b68;</span>|md_calendar_range_outline|
|<span class="nerdfont big">&#xf01e1;</span>|md_calendar_refresh|
|<span class="nerdfont big">&#xf0203;</span>|md_calendar_refresh_outline|
|<span class="nerdfont big">&#xf00f4;</span>|md_calendar_remove|
|<span class="nerdfont big">&#xf0c45;</span>|md_calendar_remove_outline|
|<span class="nerdfont big">&#xf094c;</span>|md_calendar_search|
|<span class="nerdfont big">&#xf09d3;</span>|md_calendar_star|
|<span class="nerdfont big">&#xf166d;</span>|md_calendar_start|
|<span class="nerdfont big">&#xf0e8e;</span>|md_calendar_sync|
|<span class="nerdfont big">&#xf0e8f;</span>|md_calendar_sync_outline|
|<span class="nerdfont big">&#xf00f5;</span>|md_calendar_text|
|<span class="nerdfont big">&#xf0c46;</span>|md_calendar_text_outline|
|<span class="nerdfont big">&#xf00f6;</span>|md_calendar_today|
|<span class="nerdfont big">&#xf1a30;</span>|md_calendar_today_outline|
|<span class="nerdfont big">&#xf0a33;</span>|md_calendar_week|
|<span class="nerdfont big">&#xf0a34;</span>|md_calendar_week_begin|
|<span class="nerdfont big">&#xf1a31;</span>|md_calendar_week_begin_outline|
|<span class="nerdfont big">&#xf1a32;</span>|md_calendar_week_end|
|<span class="nerdfont big">&#xf1a33;</span>|md_calendar_week_end_outline|
|<span class="nerdfont big">&#xf1a34;</span>|md_calendar_week_outline|
|<span class="nerdfont big">&#xf0ed9;</span>|md_calendar_weekend|
|<span class="nerdfont big">&#xf0eda;</span>|md_calendar_weekend_outline|
|<span class="nerdfont big">&#xf00f7;</span>|md_call_made|
|<span class="nerdfont big">&#xf00f8;</span>|md_call_merge|
|<span class="nerdfont big">&#xf00f9;</span>|md_call_missed|
|<span class="nerdfont big">&#xf00fa;</span>|md_call_received|
|<span class="nerdfont big">&#xf00fb;</span>|md_call_split|
|<span class="nerdfont big">&#xf00fc;</span>|md_camcorder|
|<span class="nerdfont big">&#xf00ff;</span>|md_camcorder_off|
|<span class="nerdfont big">&#xf0100;</span>|md_camera|
|<span class="nerdfont big">&#xf08cb;</span>|md_camera_account|
|<span class="nerdfont big">&#xf0693;</span>|md_camera_burst|
|<span class="nerdfont big">&#xf0b69;</span>|md_camera_control|
|<span class="nerdfont big">&#xf1871;</span>|md_camera_document|
|<span class="nerdfont big">&#xf1872;</span>|md_camera_document_off|
|<span class="nerdfont big">&#xf0101;</span>|md_camera_enhance|
|<span class="nerdfont big">&#xf0b6a;</span>|md_camera_enhance_outline|
|<span class="nerdfont big">&#xf15d9;</span>|md_camera_flip|
|<span class="nerdfont big">&#xf15da;</span>|md_camera_flip_outline|
|<span class="nerdfont big">&#xf0102;</span>|md_camera_front|
|<span class="nerdfont big">&#xf0103;</span>|md_camera_front_variant|
|<span class="nerdfont big">&#xf07a1;</span>|md_camera_gopro|
|<span class="nerdfont big">&#xf08cc;</span>|md_camera_image|
|<span class="nerdfont big">&#xf0104;</span>|md_camera_iris|
|<span class="nerdfont big">&#xf1a14;</span>|md_camera_lock|
|<span class="nerdfont big">&#xf1a15;</span>|md_camera_lock_outline|
|<span class="nerdfont big">&#xf19a7;</span>|md_camera_marker|
|<span class="nerdfont big">&#xf19a8;</span>|md_camera_marker_outline|
|<span class="nerdfont big">&#xf07a2;</span>|md_camera_metering_center|
|<span class="nerdfont big">&#xf07a3;</span>|md_camera_metering_matrix|
|<span class="nerdfont big">&#xf07a4;</span>|md_camera_metering_partial|
|<span class="nerdfont big">&#xf07a5;</span>|md_camera_metering_spot|
|<span class="nerdfont big">&#xf05df;</span>|md_camera_off|
|<span class="nerdfont big">&#xf19bf;</span>|md_camera_off_outline|
|<span class="nerdfont big">&#xf0d5d;</span>|md_camera_outline|
|<span class="nerdfont big">&#xf0105;</span>|md_camera_party_mode|
|<span class="nerdfont big">&#xf0edb;</span>|md_camera_plus|
|<span class="nerdfont big">&#xf0edc;</span>|md_camera_plus_outline|
|<span class="nerdfont big">&#xf0106;</span>|md_camera_rear|
|<span class="nerdfont big">&#xf0107;</span>|md_camera_rear_variant|
|<span class="nerdfont big">&#xf0e19;</span>|md_camera_retake|
|<span class="nerdfont big">&#xf0e1a;</span>|md_camera_retake_outline|
|<span class="nerdfont big">&#xf0108;</span>|md_camera_switch|
|<span class="nerdfont big">&#xf084a;</span>|md_camera_switch_outline|
|<span class="nerdfont big">&#xf0109;</span>|md_camera_timer|
|<span class="nerdfont big">&#xf0db6;</span>|md_camera_wireless|
|<span class="nerdfont big">&#xf0db7;</span>|md_camera_wireless_outline|
|<span class="nerdfont big">&#xf0edd;</span>|md_campfire|
|<span class="nerdfont big">&#xf073a;</span>|md_cancel|
|<span class="nerdfont big">&#xf17d2;</span>|md_candelabra|
|<span class="nerdfont big">&#xf17d3;</span>|md_candelabra_fire|
|<span class="nerdfont big">&#xf05e2;</span>|md_candle|
|<span class="nerdfont big">&#xf1970;</span>|md_candy|
|<span class="nerdfont big">&#xf1971;</span>|md_candy_off|
|<span class="nerdfont big">&#xf1972;</span>|md_candy_off_outline|
|<span class="nerdfont big">&#xf1973;</span>|md_candy_outline|
|<span class="nerdfont big">&#xf010a;</span>|md_candycane|
|<span class="nerdfont big">&#xf07a6;</span>|md_cannabis|
|<span class="nerdfont big">&#xf166e;</span>|md_cannabis_off|
|<span class="nerdfont big">&#xf0a9b;</span>|md_caps_lock|
|<span class="nerdfont big">&#xf010b;</span>|md_car|
|<span class="nerdfont big">&#xf1015;</span>|md_car_2_plus|
|<span class="nerdfont big">&#xf1016;</span>|md_car_3_plus|
|<span class="nerdfont big">&#xf13b2;</span>|md_car_arrow_left|
|<span class="nerdfont big">&#xf13b3;</span>|md_car_arrow_right|
|<span class="nerdfont big">&#xf0e1b;</span>|md_car_back|
|<span class="nerdfont big">&#xf010c;</span>|md_car_battery|
|<span class="nerdfont big">&#xf0c47;</span>|md_car_brake_abs|
|<span class="nerdfont big">&#xf0c48;</span>|md_car_brake_alert|
|<span class="nerdfont big">&#xf1909;</span>|md_car_brake_fluid_level|
|<span class="nerdfont big">&#xf0d5e;</span>|md_car_brake_hold|
|<span class="nerdfont big">&#xf190a;</span>|md_car_brake_low_pressure|
|<span class="nerdfont big">&#xf0d5f;</span>|md_car_brake_parking|
|<span class="nerdfont big">&#xf1017;</span>|md_car_brake_retarder|
|<span class="nerdfont big">&#xf190b;</span>|md_car_brake_temperature|
|<span class="nerdfont big">&#xf190c;</span>|md_car_brake_worn_linings|
|<span class="nerdfont big">&#xf0fa3;</span>|md_car_child_seat|
|<span class="nerdfont big">&#xf1974;</span>|md_car_clock|
|<span class="nerdfont big">&#xf1018;</span>|md_car_clutch|
|<span class="nerdfont big">&#xf13cc;</span>|md_car_cog|
|<span class="nerdfont big">&#xf010d;</span>|md_car_connected|
|<span class="nerdfont big">&#xf07a7;</span>|md_car_convertible|
|<span class="nerdfont big">&#xf1019;</span>|md_car_coolant_level|
|<span class="nerdfont big">&#xf0d60;</span>|md_car_cruise_control|
|<span class="nerdfont big">&#xf0d61;</span>|md_car_defrost_front|
|<span class="nerdfont big">&#xf0d62;</span>|md_car_defrost_rear|
|<span class="nerdfont big">&#xf0b6b;</span>|md_car_door|
|<span class="nerdfont big">&#xf109d;</span>|md_car_door_lock|
|<span class="nerdfont big">&#xf0b6c;</span>|md_car_electric|
|<span class="nerdfont big">&#xf15b5;</span>|md_car_electric_outline|
|<span class="nerdfont big">&#xf160f;</span>|md_car_emergency|
|<span class="nerdfont big">&#xf0c49;</span>|md_car_esp|
|<span class="nerdfont big">&#xf07a8;</span>|md_car_estate|
|<span class="nerdfont big">&#xf07a9;</span>|md_car_hatchback|
|<span class="nerdfont big">&#xf11be;</span>|md_car_info|
|<span class="nerdfont big">&#xf0b6d;</span>|md_car_key|
|<span class="nerdfont big">&#xf152d;</span>|md_car_lifted_pickup|
|<span class="nerdfont big">&#xf190d;</span>|md_car_light_alert|
|<span class="nerdfont big">&#xf0c4a;</span>|md_car_light_dimmed|
|<span class="nerdfont big">&#xf0c4b;</span>|md_car_light_fog|
|<span class="nerdfont big">&#xf0c4c;</span>|md_car_light_high|
|<span class="nerdfont big">&#xf08cd;</span>|md_car_limousine|
|<span class="nerdfont big">&#xf0b6e;</span>|md_car_multiple|
|<span class="nerdfont big">&#xf0e1c;</span>|md_car_off|
|<span class="nerdfont big">&#xf14ed;</span>|md_car_outline|
|<span class="nerdfont big">&#xf0d63;</span>|md_car_parking_lights|
|<span class="nerdfont big">&#xf07aa;</span>|md_car_pickup|
|<span class="nerdfont big">&#xf0fa4;</span>|md_car_seat|
|<span class="nerdfont big">&#xf0fa5;</span>|md_car_seat_cooler|
|<span class="nerdfont big">&#xf0fa6;</span>|md_car_seat_heater|
|<span class="nerdfont big">&#xf1879;</span>|md_car_select|
|<span class="nerdfont big">&#xf13cd;</span>|md_car_settings|
|<span class="nerdfont big">&#xf0f40;</span>|md_car_shift_pattern|
|<span class="nerdfont big">&#xf07ab;</span>|md_car_side|
|<span class="nerdfont big">&#xf190e;</span>|md_car_speed_limiter|
|<span class="nerdfont big">&#xf07ac;</span>|md_car_sports|
|<span class="nerdfont big">&#xf0c4d;</span>|md_car_tire_alert|
|<span class="nerdfont big">&#xf0d64;</span>|md_car_traction_control|
|<span class="nerdfont big">&#xf101a;</span>|md_car_turbocharger|
|<span class="nerdfont big">&#xf010e;</span>|md_car_wash|
|<span class="nerdfont big">&#xf101b;</span>|md_car_windshield|
|<span class="nerdfont big">&#xf101c;</span>|md_car_windshield_outline|
|<span class="nerdfont big">&#xf1878;</span>|md_car_wireless|
|<span class="nerdfont big">&#xf1814;</span>|md_car_wrench|
|<span class="nerdfont big">&#xf14c0;</span>|md_carabiner|
|<span class="nerdfont big">&#xf07ad;</span>|md_caravan|
|<span class="nerdfont big">&#xf0b6f;</span>|md_card|
|<span class="nerdfont big">&#xf05d2;</span>|md_card_account_details|
|<span class="nerdfont big">&#xf0dab;</span>|md_card_account_details_outline|
|<span class="nerdfont big">&#xf02a3;</span>|md_card_account_details_star|
|<span class="nerdfont big">&#xf06db;</span>|md_card_account_details_star_outline|
|<span class="nerdfont big">&#xf018e;</span>|md_card_account_mail|
|<span class="nerdfont big">&#xf0e98;</span>|md_card_account_mail_outline|
|<span class="nerdfont big">&#xf0e99;</span>|md_card_account_phone|
|<span class="nerdfont big">&#xf0e9a;</span>|md_card_account_phone_outline|
|<span class="nerdfont big">&#xf0b70;</span>|md_card_bulleted|
|<span class="nerdfont big">&#xf0b71;</span>|md_card_bulleted_off|
|<span class="nerdfont big">&#xf0b72;</span>|md_card_bulleted_off_outline|
|<span class="nerdfont big">&#xf0b73;</span>|md_card_bulleted_outline|
|<span class="nerdfont big">&#xf0b74;</span>|md_card_bulleted_settings|
|<span class="nerdfont big">&#xf0b75;</span>|md_card_bulleted_settings_outline|
|<span class="nerdfont big">&#xf1600;</span>|md_card_minus|
|<span class="nerdfont big">&#xf1601;</span>|md_card_minus_outline|
|<span class="nerdfont big">&#xf17f1;</span>|md_card_multiple|
|<span class="nerdfont big">&#xf17f2;</span>|md_card_multiple_outline|
|<span class="nerdfont big">&#xf1602;</span>|md_card_off|
|<span class="nerdfont big">&#xf1603;</span>|md_card_off_outline|
|<span class="nerdfont big">&#xf0b76;</span>|md_card_outline|
|<span class="nerdfont big">&#xf11ff;</span>|md_card_plus|
|<span class="nerdfont big">&#xf1200;</span>|md_card_plus_outline|
|<span class="nerdfont big">&#xf1604;</span>|md_card_remove|
|<span class="nerdfont big">&#xf1605;</span>|md_card_remove_outline|
|<span class="nerdfont big">&#xf1074;</span>|md_card_search|
|<span class="nerdfont big">&#xf1075;</span>|md_card_search_outline|
|<span class="nerdfont big">&#xf0b77;</span>|md_card_text|
|<span class="nerdfont big">&#xf0b78;</span>|md_card_text_outline|
|<span class="nerdfont big">&#xf0638;</span>|md_cards|
|<span class="nerdfont big">&#xf08ce;</span>|md_cards_club|
|<span class="nerdfont big">&#xf189f;</span>|md_cards_club_outline|
|<span class="nerdfont big">&#xf08cf;</span>|md_cards_diamond|
|<span class="nerdfont big">&#xf101d;</span>|md_cards_diamond_outline|
|<span class="nerdfont big">&#xf0639;</span>|md_cards_outline|
|<span class="nerdfont big">&#xf18a1;</span>|md_cards_playing|
|<span class="nerdfont big">&#xf18a2;</span>|md_cards_playing_club|
|<span class="nerdfont big">&#xf18a3;</span>|md_cards_playing_club_multiple|
|<span class="nerdfont big">&#xf18a4;</span>|md_cards_playing_club_multiple_outline|
|<span class="nerdfont big">&#xf18a5;</span>|md_cards_playing_club_outline|
|<span class="nerdfont big">&#xf18a6;</span>|md_cards_playing_diamond|
|<span class="nerdfont big">&#xf18a7;</span>|md_cards_playing_diamond_multiple|
|<span class="nerdfont big">&#xf18a8;</span>|md_cards_playing_diamond_multiple_outline|
|<span class="nerdfont big">&#xf18a9;</span>|md_cards_playing_diamond_outline|
|<span class="nerdfont big">&#xf18aa;</span>|md_cards_playing_heart|
|<span class="nerdfont big">&#xf18ab;</span>|md_cards_playing_heart_multiple|
|<span class="nerdfont big">&#xf18ac;</span>|md_cards_playing_heart_multiple_outline|
|<span class="nerdfont big">&#xf18ad;</span>|md_cards_playing_heart_outline|
|<span class="nerdfont big">&#xf063a;</span>|md_cards_playing_outline|
|<span class="nerdfont big">&#xf18ae;</span>|md_cards_playing_spade|
|<span class="nerdfont big">&#xf18af;</span>|md_cards_playing_spade_multiple|
|<span class="nerdfont big">&#xf18b0;</span>|md_cards_playing_spade_multiple_outline|
|<span class="nerdfont big">&#xf18b1;</span>|md_cards_playing_spade_outline|
|<span class="nerdfont big">&#xf08d1;</span>|md_cards_spade|
|<span class="nerdfont big">&#xf18b2;</span>|md_cards_spade_outline|
|<span class="nerdfont big">&#xf06c7;</span>|md_cards_variant|
|<span class="nerdfont big">&#xf010f;</span>|md_carrot|
|<span class="nerdfont big">&#xf0110;</span>|md_cart|
|<span class="nerdfont big">&#xf0d66;</span>|md_cart_arrow_down|
|<span class="nerdfont big">&#xf0c4e;</span>|md_cart_arrow_right|
|<span class="nerdfont big">&#xf0d67;</span>|md_cart_arrow_up|
|<span class="nerdfont big">&#xf15ea;</span>|md_cart_check|
|<span class="nerdfont big">&#xf18e0;</span>|md_cart_heart|
|<span class="nerdfont big">&#xf0d68;</span>|md_cart_minus|
|<span class="nerdfont big">&#xf066b;</span>|md_cart_off|
|<span class="nerdfont big">&#xf0111;</span>|md_cart_outline|
|<span class="nerdfont big">&#xf0112;</span>|md_cart_plus|
|<span class="nerdfont big">&#xf0d69;</span>|md_cart_remove|
|<span class="nerdfont big">&#xf15eb;</span>|md_cart_variant|
|<span class="nerdfont big">&#xf0113;</span>|md_case_sensitive_alt|
|<span class="nerdfont big">&#xf0114;</span>|md_cash|
|<span class="nerdfont big">&#xf0115;</span>|md_cash_100|
|<span class="nerdfont big">&#xf14ee;</span>|md_cash_check|
|<span class="nerdfont big">&#xf1a91;</span>|md_cash_clock|
|<span class="nerdfont big">&#xf185c;</span>|md_cash_fast|
|<span class="nerdfont big">&#xf14ea;</span>|md_cash_lock|
|<span class="nerdfont big">&#xf14eb;</span>|md_cash_lock_open|
|<span class="nerdfont big">&#xf0db8;</span>|md_cash_marker|
|<span class="nerdfont big">&#xf1260;</span>|md_cash_minus|
|<span class="nerdfont big">&#xf0116;</span>|md_cash_multiple|
|<span class="nerdfont big">&#xf1261;</span>|md_cash_plus|
|<span class="nerdfont big">&#xf0a9c;</span>|md_cash_refund|
|<span class="nerdfont big">&#xf0cf4;</span>|md_cash_register|
|<span class="nerdfont big">&#xf1262;</span>|md_cash_remove|
|<span class="nerdfont big">&#xf1a92;</span>|md_cash_sync|
|<span class="nerdfont big">&#xf09d4;</span>|md_cassette|
|<span class="nerdfont big">&#xf0118;</span>|md_cast|
|<span class="nerdfont big">&#xf101e;</span>|md_cast_audio|
|<span class="nerdfont big">&#xf1749;</span>|md_cast_audio_variant|
|<span class="nerdfont big">&#xf0119;</span>|md_cast_connected|
|<span class="nerdfont big">&#xf0e1d;</span>|md_cast_education|
|<span class="nerdfont big">&#xf078a;</span>|md_cast_off|
|<span class="nerdfont big">&#xf001f;</span>|md_cast_variant|
|<span class="nerdfont big">&#xf011a;</span>|md_castle|
|<span class="nerdfont big">&#xf011b;</span>|md_cat|
|<span class="nerdfont big">&#xf07ae;</span>|md_cctv|
|<span class="nerdfont big">&#xf185f;</span>|md_cctv_off|
|<span class="nerdfont big">&#xf1797;</span>|md_ceiling_fan|
|<span class="nerdfont big">&#xf1798;</span>|md_ceiling_fan_light|
|<span class="nerdfont big">&#xf0769;</span>|md_ceiling_light|
|<span class="nerdfont big">&#xf18dd;</span>|md_ceiling_light_multiple|
|<span class="nerdfont big">&#xf18de;</span>|md_ceiling_light_multiple_outline|
|<span class="nerdfont big">&#xf17c7;</span>|md_ceiling_light_outline|
|<span class="nerdfont big">&#xf011c;</span>|md_cellphone|
|<span class="nerdfont big">&#xf09d5;</span>|md_cellphone_arrow_down|
|<span class="nerdfont big">&#xf19c5;</span>|md_cellphone_arrow_down_variant|
|<span class="nerdfont big">&#xf011e;</span>|md_cellphone_basic|
|<span class="nerdfont big">&#xf1397;</span>|md_cellphone_charging|
|<span class="nerdfont big">&#xf17fd;</span>|md_cellphone_check|
|<span class="nerdfont big">&#xf0951;</span>|md_cellphone_cog|
|<span class="nerdfont big">&#xf011f;</span>|md_cellphone_dock|
|<span class="nerdfont big">&#xf0f41;</span>|md_cellphone_information|
|<span class="nerdfont big">&#xf094e;</span>|md_cellphone_key|
|<span class="nerdfont big">&#xf0121;</span>|md_cellphone_link|
|<span class="nerdfont big">&#xf0122;</span>|md_cellphone_link_off|
|<span class="nerdfont big">&#xf094f;</span>|md_cellphone_lock|
|<span class="nerdfont big">&#xf183a;</span>|md_cellphone_marker|
|<span class="nerdfont big">&#xf08d3;</span>|md_cellphone_message|
|<span class="nerdfont big">&#xf10d2;</span>|md_cellphone_message_off|
|<span class="nerdfont big">&#xf0e90;</span>|md_cellphone_nfc|
|<span class="nerdfont big">&#xf12d8;</span>|md_cellphone_nfc_off|
|<span class="nerdfont big">&#xf0950;</span>|md_cellphone_off|
|<span class="nerdfont big">&#xf101f;</span>|md_cellphone_play|
|<span class="nerdfont big">&#xf094d;</span>|md_cellphone_remove|
|<span class="nerdfont big">&#xf0a35;</span>|md_cellphone_screenshot|
|<span class="nerdfont big">&#xf0123;</span>|md_cellphone_settings|
|<span class="nerdfont big">&#xf0952;</span>|md_cellphone_sound|
|<span class="nerdfont big">&#xf08d2;</span>|md_cellphone_text|
|<span class="nerdfont big">&#xf0815;</span>|md_cellphone_wireless|
|<span class="nerdfont big">&#xf111a;</span>|md_centos|
|<span class="nerdfont big">&#xf0124;</span>|md_certificate|
|<span class="nerdfont big">&#xf1188;</span>|md_certificate_outline|
|<span class="nerdfont big">&#xf0f48;</span>|md_chair_rolling|
|<span class="nerdfont big">&#xf0125;</span>|md_chair_school|
|<span class="nerdfont big">&#xf1793;</span>|md_chandelier|
|<span class="nerdfont big">&#xf0c4f;</span>|md_charity|
|<span class="nerdfont big">&#xf0126;</span>|md_chart_arc|
|<span class="nerdfont big">&#xf0127;</span>|md_chart_areaspline|
|<span class="nerdfont big">&#xf0e91;</span>|md_chart_areaspline_variant|
|<span class="nerdfont big">&#xf0128;</span>|md_chart_bar|
|<span class="nerdfont big">&#xf076a;</span>|md_chart_bar_stacked|
|<span class="nerdfont big">&#xf0c50;</span>|md_chart_bell_curve|
|<span class="nerdfont big">&#xf0fa7;</span>|md_chart_bell_curve_cumulative|
|<span class="nerdfont big">&#xf154d;</span>|md_chart_box|
|<span class="nerdfont big">&#xf154e;</span>|md_chart_box_outline|
|<span class="nerdfont big">&#xf154f;</span>|md_chart_box_plus_outline|
|<span class="nerdfont big">&#xf05e3;</span>|md_chart_bubble|
|<span class="nerdfont big">&#xf07af;</span>|md_chart_donut|
|<span class="nerdfont big">&#xf07b0;</span>|md_chart_donut_variant|
|<span class="nerdfont big">&#xf066c;</span>|md_chart_gantt|
|<span class="nerdfont big">&#xf0129;</span>|md_chart_histogram|
|<span class="nerdfont big">&#xf012a;</span>|md_chart_line|
|<span class="nerdfont big">&#xf076b;</span>|md_chart_line_stacked|
|<span class="nerdfont big">&#xf07b1;</span>|md_chart_line_variant|
|<span class="nerdfont big">&#xf08d4;</span>|md_chart_multiline|
|<span class="nerdfont big">&#xf1213;</span>|md_chart_multiple|
|<span class="nerdfont big">&#xf012b;</span>|md_chart_pie|
|<span class="nerdfont big">&#xf1380;</span>|md_chart_ppf|
|<span class="nerdfont big">&#xf11df;</span>|md_chart_sankey|
|<span class="nerdfont big">&#xf11e0;</span>|md_chart_sankey_variant|
|<span class="nerdfont big">&#xf0e92;</span>|md_chart_scatter_plot|
|<span class="nerdfont big">&#xf066d;</span>|md_chart_scatter_plot_hexbin|
|<span class="nerdfont big">&#xf066e;</span>|md_chart_timeline|
|<span class="nerdfont big">&#xf0e93;</span>|md_chart_timeline_variant|
|<span class="nerdfont big">&#xf15b6;</span>|md_chart_timeline_variant_shimmer|
|<span class="nerdfont big">&#xf0e94;</span>|md_chart_tree|
|<span class="nerdfont big">&#xf1918;</span>|md_chart_waterfall|
|<span class="nerdfont big">&#xf0b79;</span>|md_chat|
|<span class="nerdfont big">&#xf0b7a;</span>|md_chat_alert|
|<span class="nerdfont big">&#xf12c9;</span>|md_chat_alert_outline|
|<span class="nerdfont big">&#xf1410;</span>|md_chat_minus|
|<span class="nerdfont big">&#xf1413;</span>|md_chat_minus_outline|
|<span class="nerdfont big">&#xf0ede;</span>|md_chat_outline|
|<span class="nerdfont big">&#xf140f;</span>|md_chat_plus|
|<span class="nerdfont big">&#xf1412;</span>|md_chat_plus_outline|
|<span class="nerdfont big">&#xf0b7b;</span>|md_chat_processing|
|<span class="nerdfont big">&#xf12ca;</span>|md_chat_processing_outline|
|<span class="nerdfont big">&#xf1738;</span>|md_chat_question|
|<span class="nerdfont big">&#xf1739;</span>|md_chat_question_outline|
|<span class="nerdfont big">&#xf1411;</span>|md_chat_remove|
|<span class="nerdfont big">&#xf1414;</span>|md_chat_remove_outline|
|<span class="nerdfont big">&#xf12d1;</span>|md_chat_sleep|
|<span class="nerdfont big">&#xf12d2;</span>|md_chat_sleep_outline|
|<span class="nerdfont big">&#xf012c;</span>|md_check|
|<span class="nerdfont big">&#xf012d;</span>|md_check_all|
|<span class="nerdfont big">&#xf0e1e;</span>|md_check_bold|
|<span class="nerdfont big">&#xf05e0;</span>|md_check_circle|
|<span class="nerdfont big">&#xf05e1;</span>|md_check_circle_outline|
|<span class="nerdfont big">&#xf0791;</span>|md_check_decagram|
|<span class="nerdfont big">&#xf1740;</span>|md_check_decagram_outline|
|<span class="nerdfont big">&#xf0c53;</span>|md_check_network|
|<span class="nerdfont big">&#xf0c54;</span>|md_check_network_outline|
|<span class="nerdfont big">&#xf0855;</span>|md_check_outline|
|<span class="nerdfont big">&#xf0e1f;</span>|md_check_underline|
|<span class="nerdfont big">&#xf0e20;</span>|md_check_underline_circle|
|<span class="nerdfont big">&#xf0e21;</span>|md_check_underline_circle_outline|
|<span class="nerdfont big">&#xf0a9d;</span>|md_checkbook|
|<span class="nerdfont big">&#xf012e;</span>|md_checkbox_blank|
|<span class="nerdfont big">&#xf1176;</span>|md_checkbox_blank_badge|
|<span class="nerdfont big">&#xf0117;</span>|md_checkbox_blank_badge_outline|
|<span class="nerdfont big">&#xf0765;</span>|md_checkbox_blank_circle|
|<span class="nerdfont big">&#xf0765;</span>|md_checkbox_blank_circle|
|<span class="nerdfont big">&#xf0766;</span>|md_checkbox_blank_circle_outline|
|<span class="nerdfont big">&#xf0766;</span>|md_checkbox_blank_circle_outline|
|<span class="nerdfont big">&#xf0766;</span>|md_checkbox_blank_circle_outline|
|<span class="nerdfont big">&#xf12ec;</span>|md_checkbox_blank_off|
|<span class="nerdfont big">&#xf12ed;</span>|md_checkbox_blank_off_outline|
|<span class="nerdfont big">&#xf0131;</span>|md_checkbox_blank_outline|
|<span class="nerdfont big">&#xf0856;</span>|md_checkbox_intermediate|
|<span class="nerdfont big">&#xf0132;</span>|md_checkbox_marked|
|<span class="nerdfont big">&#xf0133;</span>|md_checkbox_marked_circle|
|<span class="nerdfont big">&#xf0134;</span>|md_checkbox_marked_circle_outline|
|<span class="nerdfont big">&#xf1927;</span>|md_checkbox_marked_circle_plus_outline|
|<span class="nerdfont big">&#xf0135;</span>|md_checkbox_marked_outline|
|<span class="nerdfont big">&#xf0136;</span>|md_checkbox_multiple_blank|
|<span class="nerdfont big">&#xf063b;</span>|md_checkbox_multiple_blank_circle|
|<span class="nerdfont big">&#xf063c;</span>|md_checkbox_multiple_blank_circle_outline|
|<span class="nerdfont big">&#xf0137;</span>|md_checkbox_multiple_blank_outline|
|<span class="nerdfont big">&#xf0138;</span>|md_checkbox_multiple_marked|
|<span class="nerdfont big">&#xf063d;</span>|md_checkbox_multiple_marked_circle|
|<span class="nerdfont big">&#xf063e;</span>|md_checkbox_multiple_marked_circle_outline|
|<span class="nerdfont big">&#xf0139;</span>|md_checkbox_multiple_marked_outline|
|<span class="nerdfont big">&#xf0c51;</span>|md_checkbox_multiple_outline|
|<span class="nerdfont big">&#xf0c52;</span>|md_checkbox_outline|
|<span class="nerdfont big">&#xf013a;</span>|md_checkerboard|
|<span class="nerdfont big">&#xf1202;</span>|md_checkerboard_minus|
|<span class="nerdfont big">&#xf1201;</span>|md_checkerboard_plus|
|<span class="nerdfont big">&#xf1203;</span>|md_checkerboard_remove|
|<span class="nerdfont big">&#xf12b9;</span>|md_cheese|
|<span class="nerdfont big">&#xf13ee;</span>|md_cheese_off|
|<span class="nerdfont big">&#xf0b7c;</span>|md_chef_hat|
|<span class="nerdfont big">&#xf013b;</span>|md_chemical_weapon|
|<span class="nerdfont big">&#xf085c;</span>|md_chess_bishop|
|<span class="nerdfont big">&#xf0857;</span>|md_chess_king|
|<span class="nerdfont big">&#xf0858;</span>|md_chess_knight|
|<span class="nerdfont big">&#xf0859;</span>|md_chess_pawn|
|<span class="nerdfont big">&#xf085a;</span>|md_chess_queen|
|<span class="nerdfont big">&#xf085b;</span>|md_chess_rook|
|<span class="nerdfont big">&#xf013c;</span>|md_chevron_double_down|
|<span class="nerdfont big">&#xf013d;</span>|md_chevron_double_left|
|<span class="nerdfont big">&#xf013e;</span>|md_chevron_double_right|
|<span class="nerdfont big">&#xf013f;</span>|md_chevron_double_up|
|<span class="nerdfont big">&#xf0140;</span>|md_chevron_down|
|<span class="nerdfont big">&#xf09d6;</span>|md_chevron_down_box|
|<span class="nerdfont big">&#xf09d7;</span>|md_chevron_down_box_outline|
|<span class="nerdfont big">&#xf0b26;</span>|md_chevron_down_circle|
|<span class="nerdfont big">&#xf0b27;</span>|md_chevron_down_circle_outline|
|<span class="nerdfont big">&#xf0141;</span>|md_chevron_left|
|<span class="nerdfont big">&#xf09d8;</span>|md_chevron_left_box|
|<span class="nerdfont big">&#xf09d9;</span>|md_chevron_left_box_outline|
|<span class="nerdfont big">&#xf0b28;</span>|md_chevron_left_circle|
|<span class="nerdfont big">&#xf0b29;</span>|md_chevron_left_circle_outline|
|<span class="nerdfont big">&#xf0142;</span>|md_chevron_right|
|<span class="nerdfont big">&#xf09da;</span>|md_chevron_right_box|
|<span class="nerdfont big">&#xf09db;</span>|md_chevron_right_box_outline|
|<span class="nerdfont big">&#xf0b2a;</span>|md_chevron_right_circle|
|<span class="nerdfont big">&#xf0b2b;</span>|md_chevron_right_circle_outline|
|<span class="nerdfont big">&#xf0db9;</span>|md_chevron_triple_down|
|<span class="nerdfont big">&#xf0dba;</span>|md_chevron_triple_left|
|<span class="nerdfont big">&#xf0dbb;</span>|md_chevron_triple_right|
|<span class="nerdfont big">&#xf0dbc;</span>|md_chevron_triple_up|
|<span class="nerdfont big">&#xf0143;</span>|md_chevron_up|
|<span class="nerdfont big">&#xf09dc;</span>|md_chevron_up_box|
|<span class="nerdfont big">&#xf09dd;</span>|md_chevron_up_box_outline|
|<span class="nerdfont big">&#xf0b2c;</span>|md_chevron_up_circle|
|<span class="nerdfont big">&#xf0b2d;</span>|md_chevron_up_circle_outline|
|<span class="nerdfont big">&#xf17ea;</span>|md_chili_alert|
|<span class="nerdfont big">&#xf17eb;</span>|md_chili_alert_outline|
|<span class="nerdfont big">&#xf07b2;</span>|md_chili_hot|
|<span class="nerdfont big">&#xf17ec;</span>|md_chili_hot_outline|
|<span class="nerdfont big">&#xf07b3;</span>|md_chili_medium|
|<span class="nerdfont big">&#xf17ed;</span>|md_chili_medium_outline|
|<span class="nerdfont big">&#xf07b4;</span>|md_chili_mild|
|<span class="nerdfont big">&#xf17ee;</span>|md_chili_mild_outline|
|<span class="nerdfont big">&#xf1467;</span>|md_chili_off|
|<span class="nerdfont big">&#xf17ef;</span>|md_chili_off_outline|
|<span class="nerdfont big">&#xf061a;</span>|md_chip|
|<span class="nerdfont big">&#xf0144;</span>|md_church|
|<span class="nerdfont big">&#xf1189;</span>|md_cigar|
|<span class="nerdfont big">&#xf141b;</span>|md_cigar_off|
|<span class="nerdfont big">&#xf15dc;</span>|md_circle_box|
|<span class="nerdfont big">&#xf15dd;</span>|md_circle_box_outline|
|<span class="nerdfont big">&#xf0e95;</span>|md_circle_double|
|<span class="nerdfont big">&#xf08d5;</span>|md_circle_edit_outline|
|<span class="nerdfont big">&#xf0e96;</span>|md_circle_expand|
|<span class="nerdfont big">&#xf1395;</span>|md_circle_half|
|<span class="nerdfont big">&#xf1396;</span>|md_circle_half_full|
|<span class="nerdfont big">&#xf09de;</span>|md_circle_medium|
|<span class="nerdfont big">&#xf0b38;</span>|md_circle_multiple|
|<span class="nerdfont big">&#xf0695;</span>|md_circle_multiple_outline|
|<span class="nerdfont big">&#xf10d3;</span>|md_circle_off_outline|
|<span class="nerdfont big">&#xf1853;</span>|md_circle_opacity|
|<span class="nerdfont big">&#xf0a9e;</span>|md_circle_slice_1|
|<span class="nerdfont big">&#xf0a9f;</span>|md_circle_slice_2|
|<span class="nerdfont big">&#xf0aa0;</span>|md_circle_slice_3|
|<span class="nerdfont big">&#xf0aa1;</span>|md_circle_slice_4|
|<span class="nerdfont big">&#xf0aa2;</span>|md_circle_slice_5|
|<span class="nerdfont big">&#xf0aa3;</span>|md_circle_slice_6|
|<span class="nerdfont big">&#xf0aa4;</span>|md_circle_slice_7|
|<span class="nerdfont big">&#xf0aa5;</span>|md_circle_slice_8|
|<span class="nerdfont big">&#xf09df;</span>|md_circle_small|
|<span class="nerdfont big">&#xf0e22;</span>|md_circular_saw|
|<span class="nerdfont big">&#xf0146;</span>|md_city|
|<span class="nerdfont big">&#xf0a36;</span>|md_city_variant|
|<span class="nerdfont big">&#xf0a37;</span>|md_city_variant_outline|
|<span class="nerdfont big">&#xf0147;</span>|md_clipboard|
|<span class="nerdfont big">&#xf0148;</span>|md_clipboard_account|
|<span class="nerdfont big">&#xf0c55;</span>|md_clipboard_account_outline|
|<span class="nerdfont big">&#xf0149;</span>|md_clipboard_alert|
|<span class="nerdfont big">&#xf0cf7;</span>|md_clipboard_alert_outline|
|<span class="nerdfont big">&#xf014a;</span>|md_clipboard_arrow_down|
|<span class="nerdfont big">&#xf0c56;</span>|md_clipboard_arrow_down_outline|
|<span class="nerdfont big">&#xf014b;</span>|md_clipboard_arrow_left|
|<span class="nerdfont big">&#xf0cf8;</span>|md_clipboard_arrow_left_outline|
|<span class="nerdfont big">&#xf0cf9;</span>|md_clipboard_arrow_right|
|<span class="nerdfont big">&#xf0cfa;</span>|md_clipboard_arrow_right_outline|
|<span class="nerdfont big">&#xf0c57;</span>|md_clipboard_arrow_up|
|<span class="nerdfont big">&#xf0c58;</span>|md_clipboard_arrow_up_outline|
|<span class="nerdfont big">&#xf014e;</span>|md_clipboard_check|
|<span class="nerdfont big">&#xf1263;</span>|md_clipboard_check_multiple|
|<span class="nerdfont big">&#xf1264;</span>|md_clipboard_check_multiple_outline|
|<span class="nerdfont big">&#xf08a8;</span>|md_clipboard_check_outline|
|<span class="nerdfont big">&#xf16e2;</span>|md_clipboard_clock|
|<span class="nerdfont big">&#xf16e3;</span>|md_clipboard_clock_outline|
|<span class="nerdfont big">&#xf14e5;</span>|md_clipboard_edit|
|<span class="nerdfont big">&#xf14e6;</span>|md_clipboard_edit_outline|
|<span class="nerdfont big">&#xf1265;</span>|md_clipboard_file|
|<span class="nerdfont big">&#xf1266;</span>|md_clipboard_file_outline|
|<span class="nerdfont big">&#xf06c8;</span>|md_clipboard_flow|
|<span class="nerdfont big">&#xf1117;</span>|md_clipboard_flow_outline|
|<span class="nerdfont big">&#xf10d4;</span>|md_clipboard_list|
|<span class="nerdfont big">&#xf10d5;</span>|md_clipboard_list_outline|
|<span class="nerdfont big">&#xf1618;</span>|md_clipboard_minus|
|<span class="nerdfont big">&#xf1619;</span>|md_clipboard_minus_outline|
|<span class="nerdfont big">&#xf1267;</span>|md_clipboard_multiple|
|<span class="nerdfont big">&#xf1268;</span>|md_clipboard_multiple_outline|
|<span class="nerdfont big">&#xf161a;</span>|md_clipboard_off|
|<span class="nerdfont big">&#xf161b;</span>|md_clipboard_off_outline|
|<span class="nerdfont big">&#xf014c;</span>|md_clipboard_outline|
|<span class="nerdfont big">&#xf0c59;</span>|md_clipboard_play|
|<span class="nerdfont big">&#xf1269;</span>|md_clipboard_play_multiple|
|<span class="nerdfont big">&#xf126a;</span>|md_clipboard_play_multiple_outline|
|<span class="nerdfont big">&#xf0c5a;</span>|md_clipboard_play_outline|
|<span class="nerdfont big">&#xf0751;</span>|md_clipboard_plus|
|<span class="nerdfont big">&#xf131f;</span>|md_clipboard_plus_outline|
|<span class="nerdfont big">&#xf085d;</span>|md_clipboard_pulse|
|<span class="nerdfont big">&#xf085e;</span>|md_clipboard_pulse_outline|
|<span class="nerdfont big">&#xf161c;</span>|md_clipboard_remove|
|<span class="nerdfont big">&#xf161d;</span>|md_clipboard_remove_outline|
|<span class="nerdfont big">&#xf161e;</span>|md_clipboard_search|
|<span class="nerdfont big">&#xf161f;</span>|md_clipboard_search_outline|
|<span class="nerdfont big">&#xf014d;</span>|md_clipboard_text|
|<span class="nerdfont big">&#xf18f9;</span>|md_clipboard_text_clock|
|<span class="nerdfont big">&#xf18fa;</span>|md_clipboard_text_clock_outline|
|<span class="nerdfont big">&#xf126b;</span>|md_clipboard_text_multiple|
|<span class="nerdfont big">&#xf126c;</span>|md_clipboard_text_multiple_outline|
|<span class="nerdfont big">&#xf1620;</span>|md_clipboard_text_off|
|<span class="nerdfont big">&#xf1621;</span>|md_clipboard_text_off_outline|
|<span class="nerdfont big">&#xf0a38;</span>|md_clipboard_text_outline|
|<span class="nerdfont big">&#xf0c5b;</span>|md_clipboard_text_play|
|<span class="nerdfont big">&#xf0c5c;</span>|md_clipboard_text_play_outline|
|<span class="nerdfont big">&#xf1622;</span>|md_clipboard_text_search|
|<span class="nerdfont big">&#xf1623;</span>|md_clipboard_text_search_outline|
|<span class="nerdfont big">&#xf014f;</span>|md_clippy|
|<span class="nerdfont big">&#xf0954;</span>|md_clock|
|<span class="nerdfont big">&#xf0955;</span>|md_clock_alert|
|<span class="nerdfont big">&#xf05ce;</span>|md_clock_alert_outline|
|<span class="nerdfont big">&#xf0fa8;</span>|md_clock_check|
|<span class="nerdfont big">&#xf0fa9;</span>|md_clock_check_outline|
|<span class="nerdfont big">&#xf0e97;</span>|md_clock_digital|
|<span class="nerdfont big">&#xf19ba;</span>|md_clock_edit|
|<span class="nerdfont big">&#xf19bb;</span>|md_clock_edit_outline|
|<span class="nerdfont big">&#xf0151;</span>|md_clock_end|
|<span class="nerdfont big">&#xf0152;</span>|md_clock_fast|
|<span class="nerdfont big">&#xf0153;</span>|md_clock_in|
|<span class="nerdfont big">&#xf1863;</span>|md_clock_minus|
|<span class="nerdfont big">&#xf1864;</span>|md_clock_minus_outline|
|<span class="nerdfont big">&#xf0154;</span>|md_clock_out|
|<span class="nerdfont big">&#xf0150;</span>|md_clock_outline|
|<span class="nerdfont big">&#xf1861;</span>|md_clock_plus|
|<span class="nerdfont big">&#xf1862;</span>|md_clock_plus_outline|
|<span class="nerdfont big">&#xf1865;</span>|md_clock_remove|
|<span class="nerdfont big">&#xf1866;</span>|md_clock_remove_outline|
|<span class="nerdfont big">&#xf0155;</span>|md_clock_start|
|<span class="nerdfont big">&#xf1446;</span>|md_clock_time_eight|
|<span class="nerdfont big">&#xf1452;</span>|md_clock_time_eight_outline|
|<span class="nerdfont big">&#xf1449;</span>|md_clock_time_eleven|
|<span class="nerdfont big">&#xf1455;</span>|md_clock_time_eleven_outline|
|<span class="nerdfont big">&#xf1443;</span>|md_clock_time_five|
|<span class="nerdfont big">&#xf144f;</span>|md_clock_time_five_outline|
|<span class="nerdfont big">&#xf1442;</span>|md_clock_time_four|
|<span class="nerdfont big">&#xf144e;</span>|md_clock_time_four_outline|
|<span class="nerdfont big">&#xf1447;</span>|md_clock_time_nine|
|<span class="nerdfont big">&#xf1453;</span>|md_clock_time_nine_outline|
|<span class="nerdfont big">&#xf143f;</span>|md_clock_time_one|
|<span class="nerdfont big">&#xf144b;</span>|md_clock_time_one_outline|
|<span class="nerdfont big">&#xf1445;</span>|md_clock_time_seven|
|<span class="nerdfont big">&#xf1451;</span>|md_clock_time_seven_outline|
|<span class="nerdfont big">&#xf1444;</span>|md_clock_time_six|
|<span class="nerdfont big">&#xf1450;</span>|md_clock_time_six_outline|
|<span class="nerdfont big">&#xf1448;</span>|md_clock_time_ten|
|<span class="nerdfont big">&#xf1454;</span>|md_clock_time_ten_outline|
|<span class="nerdfont big">&#xf1441;</span>|md_clock_time_three|
|<span class="nerdfont big">&#xf144d;</span>|md_clock_time_three_outline|
|<span class="nerdfont big">&#xf144a;</span>|md_clock_time_twelve|
|<span class="nerdfont big">&#xf1456;</span>|md_clock_time_twelve_outline|
|<span class="nerdfont big">&#xf1440;</span>|md_clock_time_two|
|<span class="nerdfont big">&#xf144c;</span>|md_clock_time_two_outline|
|<span class="nerdfont big">&#xf0156;</span>|md_close|
|<span class="nerdfont big">&#xf0157;</span>|md_close_box|
|<span class="nerdfont big">&#xf0c5d;</span>|md_close_box_multiple|
|<span class="nerdfont big">&#xf0c5e;</span>|md_close_box_multiple_outline|
|<span class="nerdfont big">&#xf0158;</span>|md_close_box_outline|
|<span class="nerdfont big">&#xf0159;</span>|md_close_circle|
|<span class="nerdfont big">&#xf062a;</span>|md_close_circle_multiple|
|<span class="nerdfont big">&#xf0883;</span>|md_close_circle_multiple_outline|
|<span class="nerdfont big">&#xf015a;</span>|md_close_circle_outline|
|<span class="nerdfont big">&#xf015b;</span>|md_close_network|
|<span class="nerdfont big">&#xf0c5f;</span>|md_close_network_outline|
|<span class="nerdfont big">&#xf015c;</span>|md_close_octagon|
|<span class="nerdfont big">&#xf015d;</span>|md_close_octagon_outline|
|<span class="nerdfont big">&#xf06c9;</span>|md_close_outline|
|<span class="nerdfont big">&#xf1398;</span>|md_close_thick|
|<span class="nerdfont big">&#xf015e;</span>|md_closed_caption|
|<span class="nerdfont big">&#xf0dbd;</span>|md_closed_caption_outline|
|<span class="nerdfont big">&#xf015f;</span>|md_cloud|
|<span class="nerdfont big">&#xf09e0;</span>|md_cloud_alert|
|<span class="nerdfont big">&#xf07b5;</span>|md_cloud_braces|
|<span class="nerdfont big">&#xf0160;</span>|md_cloud_check|
|<span class="nerdfont big">&#xf12cc;</span>|md_cloud_check_outline|
|<span class="nerdfont big">&#xf0161;</span>|md_cloud_circle|
|<span class="nerdfont big">&#xf0162;</span>|md_cloud_download|
|<span class="nerdfont big">&#xf0b7d;</span>|md_cloud_download_outline|
|<span class="nerdfont big">&#xf11f1;</span>|md_cloud_lock|
|<span class="nerdfont big">&#xf11f2;</span>|md_cloud_lock_outline|
|<span class="nerdfont big">&#xf0164;</span>|md_cloud_off_outline|
|<span class="nerdfont big">&#xf0163;</span>|md_cloud_outline|
|<span class="nerdfont big">&#xf1a35;</span>|md_cloud_percent|
|<span class="nerdfont big">&#xf1a36;</span>|md_cloud_percent_outline|
|<span class="nerdfont big">&#xf0165;</span>|md_cloud_print|
|<span class="nerdfont big">&#xf0166;</span>|md_cloud_print_outline|
|<span class="nerdfont big">&#xf0a39;</span>|md_cloud_question|
|<span class="nerdfont big">&#xf052a;</span>|md_cloud_refresh|
|<span class="nerdfont big">&#xf0956;</span>|md_cloud_search|
|<span class="nerdfont big">&#xf0957;</span>|md_cloud_search_outline|
|<span class="nerdfont big">&#xf063f;</span>|md_cloud_sync|
|<span class="nerdfont big">&#xf12d6;</span>|md_cloud_sync_outline|
|<span class="nerdfont big">&#xf07b6;</span>|md_cloud_tags|
|<span class="nerdfont big">&#xf0167;</span>|md_cloud_upload|
|<span class="nerdfont big">&#xf0b7e;</span>|md_cloud_upload_outline|
|<span class="nerdfont big">&#xf0816;</span>|md_clover|
|<span class="nerdfont big">&#xf1020;</span>|md_coach_lamp|
|<span class="nerdfont big">&#xf1a37;</span>|md_coach_lamp_variant|
|<span class="nerdfont big">&#xf109e;</span>|md_coat_rack|
|<span class="nerdfont big">&#xf0168;</span>|md_code_array|
|<span class="nerdfont big">&#xf0169;</span>|md_code_braces|
|<span class="nerdfont big">&#xf10d6;</span>|md_code_braces_box|
|<span class="nerdfont big">&#xf016a;</span>|md_code_brackets|
|<span class="nerdfont big">&#xf016b;</span>|md_code_equal|
|<span class="nerdfont big">&#xf016c;</span>|md_code_greater_than|
|<span class="nerdfont big">&#xf016d;</span>|md_code_greater_than_or_equal|
|<span class="nerdfont big">&#xf0626;</span>|md_code_json|
|<span class="nerdfont big">&#xf016e;</span>|md_code_less_than|
|<span class="nerdfont big">&#xf016f;</span>|md_code_less_than_or_equal|
|<span class="nerdfont big">&#xf0170;</span>|md_code_not_equal|
|<span class="nerdfont big">&#xf0171;</span>|md_code_not_equal_variant|
|<span class="nerdfont big">&#xf0172;</span>|md_code_parentheses|
|<span class="nerdfont big">&#xf10d7;</span>|md_code_parentheses_box|
|<span class="nerdfont big">&#xf0173;</span>|md_code_string|
|<span class="nerdfont big">&#xf0174;</span>|md_code_tags|
|<span class="nerdfont big">&#xf0694;</span>|md_code_tags_check|
|<span class="nerdfont big">&#xf0175;</span>|md_codepen|
|<span class="nerdfont big">&#xf0176;</span>|md_coffee|
|<span class="nerdfont big">&#xf109f;</span>|md_coffee_maker|
|<span class="nerdfont big">&#xf1931;</span>|md_coffee_maker_check|
|<span class="nerdfont big">&#xf1932;</span>|md_coffee_maker_check_outline|
|<span class="nerdfont big">&#xf181b;</span>|md_coffee_maker_outline|
|<span class="nerdfont big">&#xf0faa;</span>|md_coffee_off|
|<span class="nerdfont big">&#xf0fab;</span>|md_coffee_off_outline|
|<span class="nerdfont big">&#xf06ca;</span>|md_coffee_outline|
|<span class="nerdfont big">&#xf0177;</span>|md_coffee_to_go|
|<span class="nerdfont big">&#xf130e;</span>|md_coffee_to_go_outline|
|<span class="nerdfont big">&#xf0b7f;</span>|md_coffin|
|<span class="nerdfont big">&#xf0493;</span>|md_cog|
|<span class="nerdfont big">&#xf0494;</span>|md_cog_box|
|<span class="nerdfont big">&#xf11dd;</span>|md_cog_clockwise|
|<span class="nerdfont big">&#xf11de;</span>|md_cog_counterclockwise|
|<span class="nerdfont big">&#xf13ce;</span>|md_cog_off|
|<span class="nerdfont big">&#xf13cf;</span>|md_cog_off_outline|
|<span class="nerdfont big">&#xf08bb;</span>|md_cog_outline|
|<span class="nerdfont big">&#xf1933;</span>|md_cog_pause|
|<span class="nerdfont big">&#xf1934;</span>|md_cog_pause_outline|
|<span class="nerdfont big">&#xf1935;</span>|md_cog_play|
|<span class="nerdfont big">&#xf1936;</span>|md_cog_play_outline|
|<span class="nerdfont big">&#xf145e;</span>|md_cog_refresh|
|<span class="nerdfont big">&#xf145f;</span>|md_cog_refresh_outline|
|<span class="nerdfont big">&#xf1937;</span>|md_cog_stop|
|<span class="nerdfont big">&#xf1938;</span>|md_cog_stop_outline|
|<span class="nerdfont big">&#xf1460;</span>|md_cog_sync|
|<span class="nerdfont big">&#xf1461;</span>|md_cog_sync_outline|
|<span class="nerdfont big">&#xf105b;</span>|md_cog_transfer|
|<span class="nerdfont big">&#xf105c;</span>|md_cog_transfer_outline|
|<span class="nerdfont big">&#xf08d6;</span>|md_cogs|
|<span class="nerdfont big">&#xf0640;</span>|md_collage|
|<span class="nerdfont big">&#xf0aa6;</span>|md_collapse_all|
|<span class="nerdfont big">&#xf0aa7;</span>|md_collapse_all_outline|
|<span class="nerdfont big">&#xf0179;</span>|md_color_helper|
|<span class="nerdfont big">&#xf0e23;</span>|md_comma|
|<span class="nerdfont big">&#xf0e2b;</span>|md_comma_box|
|<span class="nerdfont big">&#xf0e24;</span>|md_comma_box_outline|
|<span class="nerdfont big">&#xf0e25;</span>|md_comma_circle|
|<span class="nerdfont big">&#xf0e26;</span>|md_comma_circle_outline|
|<span class="nerdfont big">&#xf017a;</span>|md_comment|
|<span class="nerdfont big">&#xf017b;</span>|md_comment_account|
|<span class="nerdfont big">&#xf017c;</span>|md_comment_account_outline|
|<span class="nerdfont big">&#xf017d;</span>|md_comment_alert|
|<span class="nerdfont big">&#xf017e;</span>|md_comment_alert_outline|
|<span class="nerdfont big">&#xf09e1;</span>|md_comment_arrow_left|
|<span class="nerdfont big">&#xf09e2;</span>|md_comment_arrow_left_outline|
|<span class="nerdfont big">&#xf09e3;</span>|md_comment_arrow_right|
|<span class="nerdfont big">&#xf09e4;</span>|md_comment_arrow_right_outline|
|<span class="nerdfont big">&#xf15ae;</span>|md_comment_bookmark|
|<span class="nerdfont big">&#xf15af;</span>|md_comment_bookmark_outline|
|<span class="nerdfont big">&#xf017f;</span>|md_comment_check|
|<span class="nerdfont big">&#xf0180;</span>|md_comment_check_outline|
|<span class="nerdfont big">&#xf11bf;</span>|md_comment_edit|
|<span class="nerdfont big">&#xf12c4;</span>|md_comment_edit_outline|
|<span class="nerdfont big">&#xf0a3a;</span>|md_comment_eye|
|<span class="nerdfont big">&#xf0a3b;</span>|md_comment_eye_outline|
|<span class="nerdfont big">&#xf15b0;</span>|md_comment_flash|
|<span class="nerdfont big">&#xf15b1;</span>|md_comment_flash_outline|
|<span class="nerdfont big">&#xf15df;</span>|md_comment_minus|
|<span class="nerdfont big">&#xf15e0;</span>|md_comment_minus_outline|
|<span class="nerdfont big">&#xf085f;</span>|md_comment_multiple|
|<span class="nerdfont big">&#xf0181;</span>|md_comment_multiple_outline|
|<span class="nerdfont big">&#xf15e1;</span>|md_comment_off|
|<span class="nerdfont big">&#xf15e2;</span>|md_comment_off_outline|
|<span class="nerdfont big">&#xf0182;</span>|md_comment_outline|
|<span class="nerdfont big">&#xf09e5;</span>|md_comment_plus|
|<span class="nerdfont big">&#xf0183;</span>|md_comment_plus_outline|
|<span class="nerdfont big">&#xf0184;</span>|md_comment_processing|
|<span class="nerdfont big">&#xf0185;</span>|md_comment_processing_outline|
|<span class="nerdfont big">&#xf0817;</span>|md_comment_question|
|<span class="nerdfont big">&#xf0186;</span>|md_comment_question_outline|
|<span class="nerdfont big">&#xf1021;</span>|md_comment_quote|
|<span class="nerdfont big">&#xf1022;</span>|md_comment_quote_outline|
|<span class="nerdfont big">&#xf05de;</span>|md_comment_remove|
|<span class="nerdfont big">&#xf0187;</span>|md_comment_remove_outline|
|<span class="nerdfont big">&#xf0a3c;</span>|md_comment_search|
|<span class="nerdfont big">&#xf0a3d;</span>|md_comment_search_outline|
|<span class="nerdfont big">&#xf0188;</span>|md_comment_text|
|<span class="nerdfont big">&#xf0860;</span>|md_comment_text_multiple|
|<span class="nerdfont big">&#xf0861;</span>|md_comment_text_multiple_outline|
|<span class="nerdfont big">&#xf0189;</span>|md_comment_text_outline|
|<span class="nerdfont big">&#xf018a;</span>|md_compare|
|<span class="nerdfont big">&#xf1492;</span>|md_compare_horizontal|
|<span class="nerdfont big">&#xf18b3;</span>|md_compare_remove|
|<span class="nerdfont big">&#xf1493;</span>|md_compare_vertical|
|<span class="nerdfont big">&#xf018b;</span>|md_compass|
|<span class="nerdfont big">&#xf0b80;</span>|md_compass_off|
|<span class="nerdfont big">&#xf0b81;</span>|md_compass_off_outline|
|<span class="nerdfont big">&#xf018c;</span>|md_compass_outline|
|<span class="nerdfont big">&#xf1382;</span>|md_compass_rose|
|<span class="nerdfont big">&#xf1a38;</span>|md_compost|
|<span class="nerdfont big">&#xf194c;</span>|md_cone|
|<span class="nerdfont big">&#xf194d;</span>|md_cone_off|
|<span class="nerdfont big">&#xf1616;</span>|md_connection|
|<span class="nerdfont big">&#xf018d;</span>|md_console|
|<span class="nerdfont big">&#xf07b7;</span>|md_console_line|
|<span class="nerdfont big">&#xf08a9;</span>|md_console_network|
|<span class="nerdfont big">&#xf0c60;</span>|md_console_network_outline|
|<span class="nerdfont big">&#xf10d8;</span>|md_consolidate|
|<span class="nerdfont big">&#xf0d6a;</span>|md_contactless_payment|
|<span class="nerdfont big">&#xf0321;</span>|md_contactless_payment_circle|
|<span class="nerdfont big">&#xf0408;</span>|md_contactless_payment_circle_outline|
|<span class="nerdfont big">&#xf06cb;</span>|md_contacts|
|<span class="nerdfont big">&#xf05b8;</span>|md_contacts_outline|
|<span class="nerdfont big">&#xf0a3e;</span>|md_contain|
|<span class="nerdfont big">&#xf0a3f;</span>|md_contain_end|
|<span class="nerdfont big">&#xf0a40;</span>|md_contain_start|
|<span class="nerdfont big">&#xf018f;</span>|md_content_copy|
|<span class="nerdfont big">&#xf0190;</span>|md_content_cut|
|<span class="nerdfont big">&#xf0191;</span>|md_content_duplicate|
|<span class="nerdfont big">&#xf0192;</span>|md_content_paste|
|<span class="nerdfont big">&#xf0193;</span>|md_content_save|
|<span class="nerdfont big">&#xf0f42;</span>|md_content_save_alert|
|<span class="nerdfont big">&#xf0f43;</span>|md_content_save_alert_outline|
|<span class="nerdfont big">&#xf0194;</span>|md_content_save_all|
|<span class="nerdfont big">&#xf0f44;</span>|md_content_save_all_outline|
|<span class="nerdfont big">&#xf18ea;</span>|md_content_save_check|
|<span class="nerdfont big">&#xf18eb;</span>|md_content_save_check_outline|
|<span class="nerdfont big">&#xf145b;</span>|md_content_save_cog|
|<span class="nerdfont big">&#xf145c;</span>|md_content_save_cog_outline|
|<span class="nerdfont big">&#xf0cfb;</span>|md_content_save_edit|
|<span class="nerdfont big">&#xf0cfc;</span>|md_content_save_edit_outline|
|<span class="nerdfont big">&#xf0e27;</span>|md_content_save_move|
|<span class="nerdfont big">&#xf0e28;</span>|md_content_save_move_outline|
|<span class="nerdfont big">&#xf1643;</span>|md_content_save_off|
|<span class="nerdfont big">&#xf1644;</span>|md_content_save_off_outline|
|<span class="nerdfont big">&#xf0818;</span>|md_content_save_outline|
|<span class="nerdfont big">&#xf061b;</span>|md_content_save_settings|
|<span class="nerdfont big">&#xf0b2e;</span>|md_content_save_settings_outline|
|<span class="nerdfont big">&#xf0195;</span>|md_contrast|
|<span class="nerdfont big">&#xf0196;</span>|md_contrast_box|
|<span class="nerdfont big">&#xf0197;</span>|md_contrast_circle|
|<span class="nerdfont big">&#xf0b82;</span>|md_controller_classic|
|<span class="nerdfont big">&#xf0b83;</span>|md_controller_classic_outline|
|<span class="nerdfont big">&#xf0198;</span>|md_cookie|
|<span class="nerdfont big">&#xf16d0;</span>|md_cookie_alert|
|<span class="nerdfont big">&#xf16d1;</span>|md_cookie_alert_outline|
|<span class="nerdfont big">&#xf16d2;</span>|md_cookie_check|
|<span class="nerdfont big">&#xf16d3;</span>|md_cookie_check_outline|
|<span class="nerdfont big">&#xf16e4;</span>|md_cookie_clock|
|<span class="nerdfont big">&#xf16e5;</span>|md_cookie_clock_outline|
|<span class="nerdfont big">&#xf16d4;</span>|md_cookie_cog|
|<span class="nerdfont big">&#xf16d5;</span>|md_cookie_cog_outline|
|<span class="nerdfont big">&#xf16e6;</span>|md_cookie_edit|
|<span class="nerdfont big">&#xf16e7;</span>|md_cookie_edit_outline|
|<span class="nerdfont big">&#xf16e8;</span>|md_cookie_lock|
|<span class="nerdfont big">&#xf16e9;</span>|md_cookie_lock_outline|
|<span class="nerdfont big">&#xf16da;</span>|md_cookie_minus|
|<span class="nerdfont big">&#xf16db;</span>|md_cookie_minus_outline|
|<span class="nerdfont big">&#xf16ea;</span>|md_cookie_off|
|<span class="nerdfont big">&#xf16eb;</span>|md_cookie_off_outline|
|<span class="nerdfont big">&#xf16de;</span>|md_cookie_outline|
|<span class="nerdfont big">&#xf16d6;</span>|md_cookie_plus|
|<span class="nerdfont big">&#xf16d7;</span>|md_cookie_plus_outline|
|<span class="nerdfont big">&#xf16ec;</span>|md_cookie_refresh|
|<span class="nerdfont big">&#xf16ed;</span>|md_cookie_refresh_outline|
|<span class="nerdfont big">&#xf16d8;</span>|md_cookie_remove|
|<span class="nerdfont big">&#xf16d9;</span>|md_cookie_remove_outline|
|<span class="nerdfont big">&#xf16dc;</span>|md_cookie_settings|
|<span class="nerdfont big">&#xf16dd;</span>|md_cookie_settings_outline|
|<span class="nerdfont big">&#xf03c8;</span>|md_coolant_temperature|
|<span class="nerdfont big">&#xf1939;</span>|md_copyleft|
|<span class="nerdfont big">&#xf05e6;</span>|md_copyright|
|<span class="nerdfont big">&#xf0958;</span>|md_cordova|
|<span class="nerdfont big">&#xf07b8;</span>|md_corn|
|<span class="nerdfont big">&#xf13ef;</span>|md_corn_off|
|<span class="nerdfont big">&#xf1479;</span>|md_cosine_wave|
|<span class="nerdfont big">&#xf0199;</span>|md_counter|
|<span class="nerdfont big">&#xf181c;</span>|md_countertop|
|<span class="nerdfont big">&#xf181d;</span>|md_countertop_outline|
|<span class="nerdfont big">&#xf019a;</span>|md_cow|
|<span class="nerdfont big">&#xf18fc;</span>|md_cow_off|
|<span class="nerdfont big">&#xf0edf;</span>|md_cpu_32_bit|
|<span class="nerdfont big">&#xf0ee0;</span>|md_cpu_64_bit|
|<span class="nerdfont big">&#xf198b;</span>|md_cradle|
|<span class="nerdfont big">&#xf1991;</span>|md_cradle_outline|
|<span class="nerdfont big">&#xf0862;</span>|md_crane|
|<span class="nerdfont big">&#xf0674;</span>|md_creation|
|<span class="nerdfont big">&#xf0d6b;</span>|md_creative_commons|
|<span class="nerdfont big">&#xf0fef;</span>|md_credit_card|
|<span class="nerdfont big">&#xf13d0;</span>|md_credit_card_check|
|<span class="nerdfont big">&#xf13d1;</span>|md_credit_card_check_outline|
|<span class="nerdfont big">&#xf190f;</span>|md_credit_card_chip|
|<span class="nerdfont big">&#xf1910;</span>|md_credit_card_chip_outline|
|<span class="nerdfont big">&#xf0ee1;</span>|md_credit_card_clock|
|<span class="nerdfont big">&#xf0ee2;</span>|md_credit_card_clock_outline|
|<span class="nerdfont big">&#xf17d7;</span>|md_credit_card_edit|
|<span class="nerdfont big">&#xf17d8;</span>|md_credit_card_edit_outline|
|<span class="nerdfont big">&#xf1911;</span>|md_credit_card_fast|
|<span class="nerdfont big">&#xf1912;</span>|md_credit_card_fast_outline|
|<span class="nerdfont big">&#xf18e7;</span>|md_credit_card_lock|
|<span class="nerdfont big">&#xf18e8;</span>|md_credit_card_lock_outline|
|<span class="nerdfont big">&#xf06a8;</span>|md_credit_card_marker|
|<span class="nerdfont big">&#xf0dbe;</span>|md_credit_card_marker_outline|
|<span class="nerdfont big">&#xf0fac;</span>|md_credit_card_minus|
|<span class="nerdfont big">&#xf0fad;</span>|md_credit_card_minus_outline|
|<span class="nerdfont big">&#xf0ff0;</span>|md_credit_card_multiple|
|<span class="nerdfont big">&#xf019c;</span>|md_credit_card_multiple_outline|
|<span class="nerdfont big">&#xf0ff1;</span>|md_credit_card_off|
|<span class="nerdfont big">&#xf05e4;</span>|md_credit_card_off_outline|
|<span class="nerdfont big">&#xf019b;</span>|md_credit_card_outline|
|<span class="nerdfont big">&#xf0ff2;</span>|md_credit_card_plus|
|<span class="nerdfont big">&#xf0676;</span>|md_credit_card_plus_outline|
|<span class="nerdfont big">&#xf1645;</span>|md_credit_card_refresh|
|<span class="nerdfont big">&#xf1646;</span>|md_credit_card_refresh_outline|
|<span class="nerdfont big">&#xf0ff3;</span>|md_credit_card_refund|
|<span class="nerdfont big">&#xf0aa8;</span>|md_credit_card_refund_outline|
|<span class="nerdfont big">&#xf0fae;</span>|md_credit_card_remove|
|<span class="nerdfont big">&#xf0faf;</span>|md_credit_card_remove_outline|
|<span class="nerdfont big">&#xf0ff4;</span>|md_credit_card_scan|
|<span class="nerdfont big">&#xf019d;</span>|md_credit_card_scan_outline|
|<span class="nerdfont big">&#xf1647;</span>|md_credit_card_search|
|<span class="nerdfont big">&#xf1648;</span>|md_credit_card_search_outline|
|<span class="nerdfont big">&#xf0ff5;</span>|md_credit_card_settings|
|<span class="nerdfont big">&#xf08d7;</span>|md_credit_card_settings_outline|
|<span class="nerdfont big">&#xf1649;</span>|md_credit_card_sync|
|<span class="nerdfont big">&#xf164a;</span>|md_credit_card_sync_outline|
|<span class="nerdfont big">&#xf0802;</span>|md_credit_card_wireless|
|<span class="nerdfont big">&#xf057a;</span>|md_credit_card_wireless_off|
|<span class="nerdfont big">&#xf057b;</span>|md_credit_card_wireless_off_outline|
|<span class="nerdfont big">&#xf0d6c;</span>|md_credit_card_wireless_outline|
|<span class="nerdfont big">&#xf0d6d;</span>|md_cricket|
|<span class="nerdfont big">&#xf019e;</span>|md_crop|
|<span class="nerdfont big">&#xf019f;</span>|md_crop_free|
|<span class="nerdfont big">&#xf01a0;</span>|md_crop_landscape|
|<span class="nerdfont big">&#xf01a1;</span>|md_crop_portrait|
|<span class="nerdfont big">&#xf0696;</span>|md_crop_rotate|
|<span class="nerdfont big">&#xf01a2;</span>|md_crop_square|
|<span class="nerdfont big">&#xf0953;</span>|md_cross|
|<span class="nerdfont big">&#xf0ced;</span>|md_cross_bolnisi|
|<span class="nerdfont big">&#xf0cf5;</span>|md_cross_celtic|
|<span class="nerdfont big">&#xf0cf6;</span>|md_cross_outline|
|<span class="nerdfont big">&#xf01a3;</span>|md_crosshairs|
|<span class="nerdfont big">&#xf01a4;</span>|md_crosshairs_gps|
|<span class="nerdfont big">&#xf0f45;</span>|md_crosshairs_off|
|<span class="nerdfont big">&#xf1136;</span>|md_crosshairs_question|
|<span class="nerdfont big">&#xf1975;</span>|md_crowd|
|<span class="nerdfont big">&#xf01a5;</span>|md_crown|
|<span class="nerdfont big">&#xf17dc;</span>|md_crown_circle|
|<span class="nerdfont big">&#xf17dd;</span>|md_crown_circle_outline|
|<span class="nerdfont big">&#xf11d0;</span>|md_crown_outline|
|<span class="nerdfont big">&#xf0959;</span>|md_cryengine|
|<span class="nerdfont big">&#xf0b2f;</span>|md_crystal_ball|
|<span class="nerdfont big">&#xf01a6;</span>|md_cube|
|<span class="nerdfont big">&#xf141c;</span>|md_cube_off|
|<span class="nerdfont big">&#xf141d;</span>|md_cube_off_outline|
|<span class="nerdfont big">&#xf01a7;</span>|md_cube_outline|
|<span class="nerdfont big">&#xf0b84;</span>|md_cube_scan|
|<span class="nerdfont big">&#xf01a8;</span>|md_cube_send|
|<span class="nerdfont big">&#xf01a9;</span>|md_cube_unfolded|
|<span class="nerdfont big">&#xf01aa;</span>|md_cup|
|<span class="nerdfont big">&#xf05e5;</span>|md_cup_off|
|<span class="nerdfont big">&#xf137d;</span>|md_cup_off_outline|
|<span class="nerdfont big">&#xf130f;</span>|md_cup_outline|
|<span class="nerdfont big">&#xf01ab;</span>|md_cup_water|
|<span class="nerdfont big">&#xf0f46;</span>|md_cupboard|
|<span class="nerdfont big">&#xf0f47;</span>|md_cupboard_outline|
|<span class="nerdfont big">&#xf095a;</span>|md_cupcake|
|<span class="nerdfont big">&#xf0863;</span>|md_curling|
|<span class="nerdfont big">&#xf0864;</span>|md_currency_bdt|
|<span class="nerdfont big">&#xf0b85;</span>|md_currency_brl|
|<span class="nerdfont big">&#xf01ac;</span>|md_currency_btc|
|<span class="nerdfont big">&#xf07ba;</span>|md_currency_cny|
|<span class="nerdfont big">&#xf07bb;</span>|md_currency_eth|
|<span class="nerdfont big">&#xf01ad;</span>|md_currency_eur|
|<span class="nerdfont big">&#xf1315;</span>|md_currency_eur_off|
|<span class="nerdfont big">&#xf1a39;</span>|md_currency_fra|
|<span class="nerdfont big">&#xf01ae;</span>|md_currency_gbp|
|<span class="nerdfont big">&#xf0c61;</span>|md_currency_ils|
|<span class="nerdfont big">&#xf01af;</span>|md_currency_inr|
|<span class="nerdfont big">&#xf07bc;</span>|md_currency_jpy|
|<span class="nerdfont big">&#xf07bd;</span>|md_currency_krw|
|<span class="nerdfont big">&#xf0865;</span>|md_currency_kzt|
|<span class="nerdfont big">&#xf1512;</span>|md_currency_mnt|
|<span class="nerdfont big">&#xf01b0;</span>|md_currency_ngn|
|<span class="nerdfont big">&#xf09e6;</span>|md_currency_php|
|<span class="nerdfont big">&#xf0e9c;</span>|md_currency_rial|
|<span class="nerdfont big">&#xf01b1;</span>|md_currency_rub|
|<span class="nerdfont big">&#xf1976;</span>|md_currency_rupee|
|<span class="nerdfont big">&#xf07be;</span>|md_currency_sign|
|<span class="nerdfont big">&#xf01b2;</span>|md_currency_try|
|<span class="nerdfont big">&#xf07bf;</span>|md_currency_twd|
|<span class="nerdfont big">&#xf01c1;</span>|md_currency_usd|
|<span class="nerdfont big">&#xf067a;</span>|md_currency_usd_off|
|<span class="nerdfont big">&#xf1480;</span>|md_current_ac|
|<span class="nerdfont big">&#xf095c;</span>|md_current_dc|
|<span class="nerdfont big">&#xf01c0;</span>|md_cursor_default|
|<span class="nerdfont big">&#xf0cfd;</span>|md_cursor_default_click|
|<span class="nerdfont big">&#xf0cfe;</span>|md_cursor_default_click_outline|
|<span class="nerdfont big">&#xf1127;</span>|md_cursor_default_gesture|
|<span class="nerdfont big">&#xf1128;</span>|md_cursor_default_gesture_outline|
|<span class="nerdfont big">&#xf01bf;</span>|md_cursor_default_outline|
|<span class="nerdfont big">&#xf01be;</span>|md_cursor_move|
|<span class="nerdfont big">&#xf01bd;</span>|md_cursor_pointer|
|<span class="nerdfont big">&#xf05e7;</span>|md_cursor_text|
|<span class="nerdfont big">&#xf1846;</span>|md_curtains|
|<span class="nerdfont big">&#xf1847;</span>|md_curtains_closed|
|<span class="nerdfont big">&#xf194e;</span>|md_cylinder|
|<span class="nerdfont big">&#xf194f;</span>|md_cylinder_off|
|<span class="nerdfont big">&#xf15fb;</span>|md_dance_ballroom|
|<span class="nerdfont big">&#xf1578;</span>|md_dance_pole|
|<span class="nerdfont big">&#xf153c;</span>|md_data_matrix|
|<span class="nerdfont big">&#xf153d;</span>|md_data_matrix_edit|
|<span class="nerdfont big">&#xf153e;</span>|md_data_matrix_minus|
|<span class="nerdfont big">&#xf153f;</span>|md_data_matrix_plus|
|<span class="nerdfont big">&#xf1540;</span>|md_data_matrix_remove|
|<span class="nerdfont big">&#xf1541;</span>|md_data_matrix_scan|
|<span class="nerdfont big">&#xf01bc;</span>|md_database|
|<span class="nerdfont big">&#xf163a;</span>|md_database_alert|
|<span class="nerdfont big">&#xf1624;</span>|md_database_alert_outline|
|<span class="nerdfont big">&#xf163b;</span>|md_database_arrow_down|
|<span class="nerdfont big">&#xf1625;</span>|md_database_arrow_down_outline|
|<span class="nerdfont big">&#xf163c;</span>|md_database_arrow_left|
|<span class="nerdfont big">&#xf1626;</span>|md_database_arrow_left_outline|
|<span class="nerdfont big">&#xf163d;</span>|md_database_arrow_right|
|<span class="nerdfont big">&#xf1627;</span>|md_database_arrow_right_outline|
|<span class="nerdfont big">&#xf163e;</span>|md_database_arrow_up|
|<span class="nerdfont big">&#xf1628;</span>|md_database_arrow_up_outline|
|<span class="nerdfont big">&#xf0aa9;</span>|md_database_check|
|<span class="nerdfont big">&#xf1629;</span>|md_database_check_outline|
|<span class="nerdfont big">&#xf163f;</span>|md_database_clock|
|<span class="nerdfont big">&#xf162a;</span>|md_database_clock_outline|
|<span class="nerdfont big">&#xf164b;</span>|md_database_cog|
|<span class="nerdfont big">&#xf164c;</span>|md_database_cog_outline|
|<span class="nerdfont big">&#xf0b86;</span>|md_database_edit|
|<span class="nerdfont big">&#xf162b;</span>|md_database_edit_outline|
|<span class="nerdfont big">&#xf095e;</span>|md_database_export|
|<span class="nerdfont big">&#xf162c;</span>|md_database_export_outline|
|<span class="nerdfont big">&#xf191f;</span>|md_database_eye|
|<span class="nerdfont big">&#xf1920;</span>|md_database_eye_off|
|<span class="nerdfont big">&#xf1921;</span>|md_database_eye_off_outline|
|<span class="nerdfont big">&#xf1922;</span>|md_database_eye_outline|
|<span class="nerdfont big">&#xf095d;</span>|md_database_import|
|<span class="nerdfont big">&#xf162d;</span>|md_database_import_outline|
|<span class="nerdfont big">&#xf0aaa;</span>|md_database_lock|
|<span class="nerdfont big">&#xf162e;</span>|md_database_lock_outline|
|<span class="nerdfont big">&#xf12f6;</span>|md_database_marker|
|<span class="nerdfont big">&#xf162f;</span>|md_database_marker_outline|
|<span class="nerdfont big">&#xf01bb;</span>|md_database_minus|
|<span class="nerdfont big">&#xf1630;</span>|md_database_minus_outline|
|<span class="nerdfont big">&#xf1640;</span>|md_database_off|
|<span class="nerdfont big">&#xf1631;</span>|md_database_off_outline|
|<span class="nerdfont big">&#xf1632;</span>|md_database_outline|
|<span class="nerdfont big">&#xf01ba;</span>|md_database_plus|
|<span class="nerdfont big">&#xf1633;</span>|md_database_plus_outline|
|<span class="nerdfont big">&#xf05c2;</span>|md_database_refresh|
|<span class="nerdfont big">&#xf1634;</span>|md_database_refresh_outline|
|<span class="nerdfont big">&#xf0d00;</span>|md_database_remove|
|<span class="nerdfont big">&#xf1635;</span>|md_database_remove_outline|
|<span class="nerdfont big">&#xf0866;</span>|md_database_search|
|<span class="nerdfont big">&#xf1636;</span>|md_database_search_outline|
|<span class="nerdfont big">&#xf0d01;</span>|md_database_settings|
|<span class="nerdfont big">&#xf1637;</span>|md_database_settings_outline|
|<span class="nerdfont big">&#xf0cff;</span>|md_database_sync|
|<span class="nerdfont big">&#xf1638;</span>|md_database_sync_outline|
|<span class="nerdfont big">&#xf08d8;</span>|md_death_star|
|<span class="nerdfont big">&#xf08d9;</span>|md_death_star_variant|
|<span class="nerdfont big">&#xf0b87;</span>|md_deathly_hallows|
|<span class="nerdfont big">&#xf08da;</span>|md_debian|
|<span class="nerdfont big">&#xf01b9;</span>|md_debug_step_into|
|<span class="nerdfont big">&#xf01b8;</span>|md_debug_step_out|
|<span class="nerdfont big">&#xf01b7;</span>|md_debug_step_over|
|<span class="nerdfont big">&#xf076c;</span>|md_decagram|
|<span class="nerdfont big">&#xf076d;</span>|md_decagram_outline|
|<span class="nerdfont big">&#xf10a1;</span>|md_decimal|
|<span class="nerdfont big">&#xf10a2;</span>|md_decimal_comma|
|<span class="nerdfont big">&#xf10a3;</span>|md_decimal_comma_decrease|
|<span class="nerdfont big">&#xf10a4;</span>|md_decimal_comma_increase|
|<span class="nerdfont big">&#xf01b6;</span>|md_decimal_decrease|
|<span class="nerdfont big">&#xf01b5;</span>|md_decimal_increase|
|<span class="nerdfont big">&#xf01b4;</span>|md_delete|
|<span class="nerdfont big">&#xf10a5;</span>|md_delete_alert|
|<span class="nerdfont big">&#xf10a6;</span>|md_delete_alert_outline|
|<span class="nerdfont big">&#xf0683;</span>|md_delete_circle|
|<span class="nerdfont big">&#xf0b88;</span>|md_delete_circle_outline|
|<span class="nerdfont big">&#xf1556;</span>|md_delete_clock|
|<span class="nerdfont big">&#xf1557;</span>|md_delete_clock_outline|
|<span class="nerdfont big">&#xf06cc;</span>|md_delete_empty|
|<span class="nerdfont big">&#xf0e9d;</span>|md_delete_empty_outline|
|<span class="nerdfont big">&#xf05e8;</span>|md_delete_forever|
|<span class="nerdfont big">&#xf0b89;</span>|md_delete_forever_outline|
|<span class="nerdfont big">&#xf10a7;</span>|md_delete_off|
|<span class="nerdfont big">&#xf10a8;</span>|md_delete_off_outline|
|<span class="nerdfont big">&#xf09e7;</span>|md_delete_outline|
|<span class="nerdfont big">&#xf0819;</span>|md_delete_restore|
|<span class="nerdfont big">&#xf05e9;</span>|md_delete_sweep|
|<span class="nerdfont big">&#xf0c62;</span>|md_delete_sweep_outline|
|<span class="nerdfont big">&#xf01b3;</span>|md_delete_variant|
|<span class="nerdfont big">&#xf01c2;</span>|md_delta|
|<span class="nerdfont big">&#xf1239;</span>|md_desk|
|<span class="nerdfont big">&#xf095f;</span>|md_desk_lamp|
|<span class="nerdfont big">&#xf01c3;</span>|md_deskphone|
|<span class="nerdfont big">&#xf07c0;</span>|md_desktop_classic|
|<span class="nerdfont big">&#xf01c4;</span>|md_desktop_mac|
|<span class="nerdfont big">&#xf09e8;</span>|md_desktop_mac_dashboard|
|<span class="nerdfont big">&#xf01c5;</span>|md_desktop_tower|
|<span class="nerdfont big">&#xf0aab;</span>|md_desktop_tower_monitor|
|<span class="nerdfont big">&#xf01c6;</span>|md_details|
|<span class="nerdfont big">&#xf0d6e;</span>|md_dev_to|
|<span class="nerdfont big">&#xf0697;</span>|md_developer_board|
|<span class="nerdfont big">&#xf01c7;</span>|md_deviantart|
|<span class="nerdfont big">&#xf0fb0;</span>|md_devices|
|<span class="nerdfont big">&#xf094b;</span>|md_dharmachakra|
|<span class="nerdfont big">&#xf1126;</span>|md_diabetes|
|<span class="nerdfont big">&#xf061c;</span>|md_dialpad|
|<span class="nerdfont big">&#xf0c63;</span>|md_diameter|
|<span class="nerdfont big">&#xf0c64;</span>|md_diameter_outline|
|<span class="nerdfont big">&#xf0c65;</span>|md_diameter_variant|
|<span class="nerdfont big">&#xf0b8a;</span>|md_diamond|
|<span class="nerdfont big">&#xf0b8b;</span>|md_diamond_outline|
|<span class="nerdfont big">&#xf01c8;</span>|md_diamond_stone|
|<span class="nerdfont big">&#xf01ca;</span>|md_dice_1|
|<span class="nerdfont big">&#xf114a;</span>|md_dice_1_outline|
|<span class="nerdfont big">&#xf01cb;</span>|md_dice_2|
|<span class="nerdfont big">&#xf114b;</span>|md_dice_2_outline|
|<span class="nerdfont big">&#xf01cc;</span>|md_dice_3|
|<span class="nerdfont big">&#xf114c;</span>|md_dice_3_outline|
|<span class="nerdfont big">&#xf01cd;</span>|md_dice_4|
|<span class="nerdfont big">&#xf114d;</span>|md_dice_4_outline|
|<span class="nerdfont big">&#xf01ce;</span>|md_dice_5|
|<span class="nerdfont big">&#xf114e;</span>|md_dice_5_outline|
|<span class="nerdfont big">&#xf01cf;</span>|md_dice_6|
|<span class="nerdfont big">&#xf114f;</span>|md_dice_6_outline|
|<span class="nerdfont big">&#xf1150;</span>|md_dice_d4|
|<span class="nerdfont big">&#xf05eb;</span>|md_dice_d4_outline|
|<span class="nerdfont big">&#xf1151;</span>|md_dice_d6|
|<span class="nerdfont big">&#xf05ed;</span>|md_dice_d6_outline|
|<span class="nerdfont big">&#xf1152;</span>|md_dice_d8|
|<span class="nerdfont big">&#xf05ec;</span>|md_dice_d8_outline|
|<span class="nerdfont big">&#xf1153;</span>|md_dice_d10|
|<span class="nerdfont big">&#xf076f;</span>|md_dice_d10_outline|
|<span class="nerdfont big">&#xf1154;</span>|md_dice_d12|
|<span class="nerdfont big">&#xf0867;</span>|md_dice_d12_outline|
|<span class="nerdfont big">&#xf1155;</span>|md_dice_d20|
|<span class="nerdfont big">&#xf05ea;</span>|md_dice_d20_outline|
|<span class="nerdfont big">&#xf076e;</span>|md_dice_multiple|
|<span class="nerdfont big">&#xf1156;</span>|md_dice_multiple_outline|
|<span class="nerdfont big">&#xf1237;</span>|md_digital_ocean|
|<span class="nerdfont big">&#xf07c1;</span>|md_dip_switch|
|<span class="nerdfont big">&#xf01d0;</span>|md_directions|
|<span class="nerdfont big">&#xf0641;</span>|md_directions_fork|
|<span class="nerdfont big">&#xf05ee;</span>|md_disc|
|<span class="nerdfont big">&#xf01d1;</span>|md_disc_alert|
|<span class="nerdfont big">&#xf0960;</span>|md_disc_player|
|<span class="nerdfont big">&#xf066f;</span>|md_discord|
|<span class="nerdfont big">&#xf0aac;</span>|md_dishwasher|
|<span class="nerdfont big">&#xf11b8;</span>|md_dishwasher_alert|
|<span class="nerdfont big">&#xf11b9;</span>|md_dishwasher_off|
|<span class="nerdfont big">&#xf01d2;</span>|md_disqus|
|<span class="nerdfont big">&#xf11c9;</span>|md_distribute_horizontal_center|
|<span class="nerdfont big">&#xf11c8;</span>|md_distribute_horizontal_left|
|<span class="nerdfont big">&#xf11ca;</span>|md_distribute_horizontal_right|
|<span class="nerdfont big">&#xf11cb;</span>|md_distribute_vertical_bottom|
|<span class="nerdfont big">&#xf11cc;</span>|md_distribute_vertical_center|
|<span class="nerdfont big">&#xf11cd;</span>|md_distribute_vertical_top|
|<span class="nerdfont big">&#xf1877;</span>|md_diversify|
|<span class="nerdfont big">&#xf1977;</span>|md_diving|
|<span class="nerdfont big">&#xf0dbf;</span>|md_diving_flippers|
|<span class="nerdfont big">&#xf0dc0;</span>|md_diving_helmet|
|<span class="nerdfont big">&#xf0dc1;</span>|md_diving_scuba|
|<span class="nerdfont big">&#xf0dc2;</span>|md_diving_scuba_flag|
|<span class="nerdfont big">&#xf0dc3;</span>|md_diving_scuba_tank|
|<span class="nerdfont big">&#xf0dc4;</span>|md_diving_scuba_tank_multiple|
|<span class="nerdfont big">&#xf0dc5;</span>|md_diving_snorkel|
|<span class="nerdfont big">&#xf01d4;</span>|md_division|
|<span class="nerdfont big">&#xf01d5;</span>|md_division_box|
|<span class="nerdfont big">&#xf0a41;</span>|md_dlna|
|<span class="nerdfont big">&#xf0684;</span>|md_dna|
|<span class="nerdfont big">&#xf01d6;</span>|md_dns|
|<span class="nerdfont big">&#xf0b8c;</span>|md_dns_outline|
|<span class="nerdfont big">&#xf10a9;</span>|md_dock_bottom|
|<span class="nerdfont big">&#xf10aa;</span>|md_dock_left|
|<span class="nerdfont big">&#xf10ab;</span>|md_dock_right|
|<span class="nerdfont big">&#xf1513;</span>|md_dock_top|
|<span class="nerdfont big">&#xf10ac;</span>|md_dock_window|
|<span class="nerdfont big">&#xf0868;</span>|md_docker|
|<span class="nerdfont big">&#xf0a42;</span>|md_doctor|
|<span class="nerdfont big">&#xf0a43;</span>|md_dog|
|<span class="nerdfont big">&#xf0aad;</span>|md_dog_service|
|<span class="nerdfont big">&#xf0a44;</span>|md_dog_side|
|<span class="nerdfont big">&#xf16ee;</span>|md_dog_side_off|
|<span class="nerdfont big">&#xf06b3;</span>|md_dolby|
|<span class="nerdfont big">&#xf0e9e;</span>|md_dolly|
|<span class="nerdfont big">&#xf18b4;</span>|md_dolphin|
|<span class="nerdfont big">&#xf01d7;</span>|md_domain|
|<span class="nerdfont big">&#xf0d6f;</span>|md_domain_off|
|<span class="nerdfont big">&#xf10ad;</span>|md_domain_plus|
|<span class="nerdfont big">&#xf10ae;</span>|md_domain_remove|
|<span class="nerdfont big">&#xf141e;</span>|md_dome_light|
|<span class="nerdfont big">&#xf1023;</span>|md_domino_mask|
|<span class="nerdfont big">&#xf07c2;</span>|md_donkey|
|<span class="nerdfont big">&#xf081a;</span>|md_door|
|<span class="nerdfont big">&#xf081b;</span>|md_door_closed|
|<span class="nerdfont big">&#xf10af;</span>|md_door_closed_lock|
|<span class="nerdfont big">&#xf081c;</span>|md_door_open|
|<span class="nerdfont big">&#xf181e;</span>|md_door_sliding|
|<span class="nerdfont big">&#xf181f;</span>|md_door_sliding_lock|
|<span class="nerdfont big">&#xf1820;</span>|md_door_sliding_open|
|<span class="nerdfont big">&#xf12e6;</span>|md_doorbell|
|<span class="nerdfont big">&#xf0869;</span>|md_doorbell_video|
|<span class="nerdfont big">&#xf0aae;</span>|md_dot_net|
|<span class="nerdfont big">&#xf1978;</span>|md_dots_circle|
|<span class="nerdfont big">&#xf15fc;</span>|md_dots_grid|
|<span class="nerdfont big">&#xf15ff;</span>|md_dots_hexagon|
|<span class="nerdfont big">&#xf01d8;</span>|md_dots_horizontal|
|<span class="nerdfont big">&#xf07c3;</span>|md_dots_horizontal_circle|
|<span class="nerdfont big">&#xf0b8d;</span>|md_dots_horizontal_circle_outline|
|<span class="nerdfont big">&#xf15fd;</span>|md_dots_square|
|<span class="nerdfont big">&#xf15fe;</span>|md_dots_triangle|
|<span class="nerdfont big">&#xf01d9;</span>|md_dots_vertical|
|<span class="nerdfont big">&#xf07c4;</span>|md_dots_vertical_circle|
|<span class="nerdfont big">&#xf0b8e;</span>|md_dots_vertical_circle_outline|
|<span class="nerdfont big">&#xf01da;</span>|md_download|
|<span class="nerdfont big">&#xf1462;</span>|md_download_box|
|<span class="nerdfont big">&#xf1463;</span>|md_download_box_outline|
|<span class="nerdfont big">&#xf1464;</span>|md_download_circle|
|<span class="nerdfont big">&#xf1465;</span>|md_download_circle_outline|
|<span class="nerdfont big">&#xf1320;</span>|md_download_lock|
|<span class="nerdfont big">&#xf1321;</span>|md_download_lock_outline|
|<span class="nerdfont big">&#xf09e9;</span>|md_download_multiple|
|<span class="nerdfont big">&#xf06f4;</span>|md_download_network|
|<span class="nerdfont big">&#xf0c66;</span>|md_download_network_outline|
|<span class="nerdfont big">&#xf10b0;</span>|md_download_off|
|<span class="nerdfont big">&#xf10b1;</span>|md_download_off_outline|
|<span class="nerdfont big">&#xf0b8f;</span>|md_download_outline|
|<span class="nerdfont big">&#xf01db;</span>|md_drag|
|<span class="nerdfont big">&#xf01dc;</span>|md_drag_horizontal|
|<span class="nerdfont big">&#xf12f0;</span>|md_drag_horizontal_variant|
|<span class="nerdfont big">&#xf0b90;</span>|md_drag_variant|
|<span class="nerdfont big">&#xf01dd;</span>|md_drag_vertical|
|<span class="nerdfont big">&#xf12f1;</span>|md_drag_vertical_variant|
|<span class="nerdfont big">&#xf0d02;</span>|md_drama_masks|
|<span class="nerdfont big">&#xf0f49;</span>|md_draw|
|<span class="nerdfont big">&#xf19b9;</span>|md_draw_pen|
|<span class="nerdfont big">&#xf01de;</span>|md_drawing|
|<span class="nerdfont big">&#xf01df;</span>|md_drawing_box|
|<span class="nerdfont big">&#xf0f4a;</span>|md_dresser|
|<span class="nerdfont big">&#xf0f4b;</span>|md_dresser_outline|
|<span class="nerdfont big">&#xf01e2;</span>|md_drone|
|<span class="nerdfont big">&#xf01e3;</span>|md_dropbox|
|<span class="nerdfont big">&#xf01e4;</span>|md_drupal|
|<span class="nerdfont big">&#xf01e5;</span>|md_duck|
|<span class="nerdfont big">&#xf01e6;</span>|md_dumbbell|
|<span class="nerdfont big">&#xf0c67;</span>|md_dump_truck|
|<span class="nerdfont big">&#xf07c5;</span>|md_ear_hearing|
|<span class="nerdfont big">&#xf1aee;</span>|md_ear_hearing_loop|
|<span class="nerdfont big">&#xf0a45;</span>|md_ear_hearing_off|
|<span class="nerdfont big">&#xf184f;</span>|md_earbuds|
|<span class="nerdfont big">&#xf1850;</span>|md_earbuds_off|
|<span class="nerdfont big">&#xf1851;</span>|md_earbuds_off_outline|
|<span class="nerdfont big">&#xf1852;</span>|md_earbuds_outline|
|<span class="nerdfont big">&#xf01e7;</span>|md_earth|
|<span class="nerdfont big">&#xf1311;</span>|md_earth_arrow_right|
|<span class="nerdfont big">&#xf06cd;</span>|md_earth_box|
|<span class="nerdfont big">&#xf1407;</span>|md_earth_box_minus|
|<span class="nerdfont big">&#xf06ce;</span>|md_earth_box_off|
|<span class="nerdfont big">&#xf1406;</span>|md_earth_box_plus|
|<span class="nerdfont big">&#xf1408;</span>|md_earth_box_remove|
|<span class="nerdfont big">&#xf1404;</span>|md_earth_minus|
|<span class="nerdfont big">&#xf01e8;</span>|md_earth_off|
|<span class="nerdfont big">&#xf1403;</span>|md_earth_plus|
|<span class="nerdfont big">&#xf1405;</span>|md_earth_remove|
|<span class="nerdfont big">&#xf0aaf;</span>|md_egg|
|<span class="nerdfont big">&#xf0ab0;</span>|md_egg_easter|
|<span class="nerdfont big">&#xf184a;</span>|md_egg_fried|
|<span class="nerdfont big">&#xf13f0;</span>|md_egg_off|
|<span class="nerdfont big">&#xf13f1;</span>|md_egg_off_outline|
|<span class="nerdfont big">&#xf13f2;</span>|md_egg_outline|
|<span class="nerdfont big">&#xf156b;</span>|md_eiffel_tower|
|<span class="nerdfont big">&#xf09ea;</span>|md_eight_track|
|<span class="nerdfont big">&#xf01ea;</span>|md_eject|
|<span class="nerdfont big">&#xf0b91;</span>|md_eject_outline|
|<span class="nerdfont big">&#xf0e9f;</span>|md_electric_switch|
|<span class="nerdfont big">&#xf10d9;</span>|md_electric_switch_closed|
|<span class="nerdfont big">&#xf1024;</span>|md_electron_framework|
|<span class="nerdfont big">&#xf07c6;</span>|md_elephant|
|<span class="nerdfont big">&#xf01eb;</span>|md_elevation_decline|
|<span class="nerdfont big">&#xf01ec;</span>|md_elevation_rise|
|<span class="nerdfont big">&#xf01ed;</span>|md_elevator|
|<span class="nerdfont big">&#xf12c2;</span>|md_elevator_down|
|<span class="nerdfont big">&#xf1381;</span>|md_elevator_passenger|
|<span class="nerdfont big">&#xf1979;</span>|md_elevator_passenger_off|
|<span class="nerdfont big">&#xf197a;</span>|md_elevator_passenger_off_outline|
|<span class="nerdfont big">&#xf197b;</span>|md_elevator_passenger_outline|
|<span class="nerdfont big">&#xf12c1;</span>|md_elevator_up|
|<span class="nerdfont big">&#xf0ea0;</span>|md_ellipse|
|<span class="nerdfont big">&#xf0ea1;</span>|md_ellipse_outline|
|<span class="nerdfont big">&#xf01ee;</span>|md_email|
|<span class="nerdfont big">&#xf06cf;</span>|md_email_alert|
|<span class="nerdfont big">&#xf0d42;</span>|md_email_alert_outline|
|<span class="nerdfont big">&#xf0d03;</span>|md_email_box|
|<span class="nerdfont big">&#xf0ab1;</span>|md_email_check|
|<span class="nerdfont big">&#xf0ab2;</span>|md_email_check_outline|
|<span class="nerdfont big">&#xf0ee3;</span>|md_email_edit|
|<span class="nerdfont big">&#xf0ee4;</span>|md_email_edit_outline|
|<span class="nerdfont big">&#xf186f;</span>|md_email_fast|
|<span class="nerdfont big">&#xf1870;</span>|md_email_fast_outline|
|<span class="nerdfont big">&#xf01f1;</span>|md_email_lock|
|<span class="nerdfont big">&#xf0b92;</span>|md_email_mark_as_unread|
|<span class="nerdfont big">&#xf0ee5;</span>|md_email_minus|
|<span class="nerdfont big">&#xf0ee6;</span>|md_email_minus_outline|
|<span class="nerdfont big">&#xf0ee7;</span>|md_email_multiple|
|<span class="nerdfont big">&#xf0ee8;</span>|md_email_multiple_outline|
|<span class="nerdfont big">&#xf0fb1;</span>|md_email_newsletter|
|<span class="nerdfont big">&#xf13e3;</span>|md_email_off|
|<span class="nerdfont big">&#xf13e4;</span>|md_email_off_outline|
|<span class="nerdfont big">&#xf01ef;</span>|md_email_open|
|<span class="nerdfont big">&#xf0ee9;</span>|md_email_open_multiple|
|<span class="nerdfont big">&#xf0eea;</span>|md_email_open_multiple_outline|
|<span class="nerdfont big">&#xf05ef;</span>|md_email_open_outline|
|<span class="nerdfont big">&#xf01f0;</span>|md_email_outline|
|<span class="nerdfont big">&#xf09eb;</span>|md_email_plus|
|<span class="nerdfont big">&#xf09ec;</span>|md_email_plus_outline|
|<span class="nerdfont big">&#xf10da;</span>|md_email_receive|
|<span class="nerdfont big">&#xf10db;</span>|md_email_receive_outline|
|<span class="nerdfont big">&#xf1661;</span>|md_email_remove|
|<span class="nerdfont big">&#xf1662;</span>|md_email_remove_outline|
|<span class="nerdfont big">&#xf195b;</span>|md_email_seal|
|<span class="nerdfont big">&#xf195c;</span>|md_email_seal_outline|
|<span class="nerdfont big">&#xf0961;</span>|md_email_search|
|<span class="nerdfont big">&#xf0962;</span>|md_email_search_outline|
|<span class="nerdfont big">&#xf10dc;</span>|md_email_send|
|<span class="nerdfont big">&#xf10dd;</span>|md_email_send_outline|
|<span class="nerdfont big">&#xf12c7;</span>|md_email_sync|
|<span class="nerdfont big">&#xf12c8;</span>|md_email_sync_outline|
|<span class="nerdfont big">&#xf05f0;</span>|md_email_variant|
|<span class="nerdfont big">&#xf0b30;</span>|md_ember|
|<span class="nerdfont big">&#xf06b4;</span>|md_emby|
|<span class="nerdfont big">&#xf0c68;</span>|md_emoticon|
|<span class="nerdfont big">&#xf0c69;</span>|md_emoticon_angry|
|<span class="nerdfont big">&#xf0c6a;</span>|md_emoticon_angry_outline|
|<span class="nerdfont big">&#xf10de;</span>|md_emoticon_confused|
|<span class="nerdfont big">&#xf10df;</span>|md_emoticon_confused_outline|
|<span class="nerdfont big">&#xf0c6b;</span>|md_emoticon_cool|
|<span class="nerdfont big">&#xf01f3;</span>|md_emoticon_cool_outline|
|<span class="nerdfont big">&#xf0c6c;</span>|md_emoticon_cry|
|<span class="nerdfont big">&#xf0c6d;</span>|md_emoticon_cry_outline|
|<span class="nerdfont big">&#xf0c6e;</span>|md_emoticon_dead|
|<span class="nerdfont big">&#xf069b;</span>|md_emoticon_dead_outline|
|<span class="nerdfont big">&#xf0c6f;</span>|md_emoticon_devil|
|<span class="nerdfont big">&#xf01f4;</span>|md_emoticon_devil_outline|
|<span class="nerdfont big">&#xf0c70;</span>|md_emoticon_excited|
|<span class="nerdfont big">&#xf069c;</span>|md_emoticon_excited_outline|
|<span class="nerdfont big">&#xf0f4c;</span>|md_emoticon_frown|
|<span class="nerdfont big">&#xf0f4d;</span>|md_emoticon_frown_outline|
|<span class="nerdfont big">&#xf0c71;</span>|md_emoticon_happy|
|<span class="nerdfont big">&#xf01f5;</span>|md_emoticon_happy_outline|
|<span class="nerdfont big">&#xf0c72;</span>|md_emoticon_kiss|
|<span class="nerdfont big">&#xf0c73;</span>|md_emoticon_kiss_outline|
|<span class="nerdfont big">&#xf1214;</span>|md_emoticon_lol|
|<span class="nerdfont big">&#xf1215;</span>|md_emoticon_lol_outline|
|<span class="nerdfont big">&#xf0c74;</span>|md_emoticon_neutral|
|<span class="nerdfont big">&#xf01f6;</span>|md_emoticon_neutral_outline|
|<span class="nerdfont big">&#xf01f2;</span>|md_emoticon_outline|
|<span class="nerdfont big">&#xf01f7;</span>|md_emoticon_poop|
|<span class="nerdfont big">&#xf0c75;</span>|md_emoticon_poop_outline|
|<span class="nerdfont big">&#xf0c76;</span>|md_emoticon_sad|
|<span class="nerdfont big">&#xf01f8;</span>|md_emoticon_sad_outline|
|<span class="nerdfont big">&#xf157c;</span>|md_emoticon_sick|
|<span class="nerdfont big">&#xf157d;</span>|md_emoticon_sick_outline|
|<span class="nerdfont big">&#xf01f9;</span>|md_emoticon_tongue|
|<span class="nerdfont big">&#xf0c77;</span>|md_emoticon_tongue_outline|
|<span class="nerdfont big">&#xf0c78;</span>|md_emoticon_wink|
|<span class="nerdfont big">&#xf0c79;</span>|md_emoticon_wink_outline|
|<span class="nerdfont big">&#xf01fa;</span>|md_engine|
|<span class="nerdfont big">&#xf0a46;</span>|md_engine_off|
|<span class="nerdfont big">&#xf0a47;</span>|md_engine_off_outline|
|<span class="nerdfont big">&#xf01fb;</span>|md_engine_outline|
|<span class="nerdfont big">&#xf10e0;</span>|md_epsilon|
|<span class="nerdfont big">&#xf01fc;</span>|md_equal|
|<span class="nerdfont big">&#xf01fd;</span>|md_equal_box|
|<span class="nerdfont big">&#xf0ea2;</span>|md_equalizer|
|<span class="nerdfont big">&#xf0ea3;</span>|md_equalizer_outline|
|<span class="nerdfont big">&#xf01fe;</span>|md_eraser|
|<span class="nerdfont big">&#xf0642;</span>|md_eraser_variant|
|<span class="nerdfont big">&#xf01ff;</span>|md_escalator|
|<span class="nerdfont big">&#xf1399;</span>|md_escalator_box|
|<span class="nerdfont big">&#xf12c0;</span>|md_escalator_down|
|<span class="nerdfont big">&#xf12bf;</span>|md_escalator_up|
|<span class="nerdfont big">&#xf0c7a;</span>|md_eslint|
|<span class="nerdfont big">&#xf0ab3;</span>|md_et|
|<span class="nerdfont big">&#xf086a;</span>|md_ethereum|
|<span class="nerdfont big">&#xf0200;</span>|md_ethernet|
|<span class="nerdfont big">&#xf0201;</span>|md_ethernet_cable|
|<span class="nerdfont big">&#xf0202;</span>|md_ethernet_cable_off|
|<span class="nerdfont big">&#xf1519;</span>|md_ev_plug_ccs1|
|<span class="nerdfont big">&#xf151a;</span>|md_ev_plug_ccs2|
|<span class="nerdfont big">&#xf151b;</span>|md_ev_plug_chademo|
|<span class="nerdfont big">&#xf151c;</span>|md_ev_plug_tesla|
|<span class="nerdfont big">&#xf151d;</span>|md_ev_plug_type1|
|<span class="nerdfont big">&#xf151e;</span>|md_ev_plug_type2|
|<span class="nerdfont big">&#xf05f1;</span>|md_ev_station|
|<span class="nerdfont big">&#xf0204;</span>|md_evernote|
|<span class="nerdfont big">&#xf1025;</span>|md_excavator|
|<span class="nerdfont big">&#xf0205;</span>|md_exclamation|
|<span class="nerdfont big">&#xf1238;</span>|md_exclamation_thick|
|<span class="nerdfont big">&#xf0a48;</span>|md_exit_run|
|<span class="nerdfont big">&#xf05fc;</span>|md_exit_to_app|
|<span class="nerdfont big">&#xf05fc;</span>|md_exit_to_app|
|<span class="nerdfont big">&#xf0ab4;</span>|md_expand_all|
|<span class="nerdfont big">&#xf0ab5;</span>|md_expand_all_outline|
|<span class="nerdfont big">&#xf08ae;</span>|md_expansion_card|
|<span class="nerdfont big">&#xf0fb2;</span>|md_expansion_card_variant|
|<span class="nerdfont big">&#xf0963;</span>|md_exponent|
|<span class="nerdfont big">&#xf0964;</span>|md_exponent_box|
|<span class="nerdfont big">&#xf0207;</span>|md_export|
|<span class="nerdfont big">&#xf0b93;</span>|md_export_variant|
|<span class="nerdfont big">&#xf0208;</span>|md_eye|
|<span class="nerdfont big">&#xf18fd;</span>|md_eye_arrow_left|
|<span class="nerdfont big">&#xf18fe;</span>|md_eye_arrow_left_outline|
|<span class="nerdfont big">&#xf18ff;</span>|md_eye_arrow_right|
|<span class="nerdfont big">&#xf1900;</span>|md_eye_arrow_right_outline|
|<span class="nerdfont big">&#xf0d04;</span>|md_eye_check|
|<span class="nerdfont big">&#xf0d05;</span>|md_eye_check_outline|
|<span class="nerdfont big">&#xf0b94;</span>|md_eye_circle|
|<span class="nerdfont big">&#xf0b95;</span>|md_eye_circle_outline|
|<span class="nerdfont big">&#xf1026;</span>|md_eye_minus|
|<span class="nerdfont big">&#xf1027;</span>|md_eye_minus_outline|
|<span class="nerdfont big">&#xf0209;</span>|md_eye_off|
|<span class="nerdfont big">&#xf06d1;</span>|md_eye_off_outline|
|<span class="nerdfont big">&#xf06d0;</span>|md_eye_outline|
|<span class="nerdfont big">&#xf086b;</span>|md_eye_plus|
|<span class="nerdfont big">&#xf086c;</span>|md_eye_plus_outline|
|<span class="nerdfont big">&#xf197c;</span>|md_eye_refresh|
|<span class="nerdfont big">&#xf197d;</span>|md_eye_refresh_outline|
|<span class="nerdfont big">&#xf15e3;</span>|md_eye_remove|
|<span class="nerdfont big">&#xf15e4;</span>|md_eye_remove_outline|
|<span class="nerdfont big">&#xf086d;</span>|md_eye_settings|
|<span class="nerdfont big">&#xf086e;</span>|md_eye_settings_outline|
|<span class="nerdfont big">&#xf020a;</span>|md_eyedropper|
|<span class="nerdfont big">&#xf13dd;</span>|md_eyedropper_minus|
|<span class="nerdfont big">&#xf13df;</span>|md_eyedropper_off|
|<span class="nerdfont big">&#xf13dc;</span>|md_eyedropper_plus|
|<span class="nerdfont big">&#xf13de;</span>|md_eyedropper_remove|
|<span class="nerdfont big">&#xf020b;</span>|md_eyedropper_variant|
|<span class="nerdfont big">&#xf0d70;</span>|md_face_agent|
|<span class="nerdfont big">&#xf0643;</span>|md_face_man|
|<span class="nerdfont big">&#xf0b96;</span>|md_face_man_outline|
|<span class="nerdfont big">&#xf0644;</span>|md_face_man_profile|
|<span class="nerdfont big">&#xf15cc;</span>|md_face_man_shimmer|
|<span class="nerdfont big">&#xf15cd;</span>|md_face_man_shimmer_outline|
|<span class="nerdfont big">&#xf1586;</span>|md_face_mask|
|<span class="nerdfont big">&#xf1587;</span>|md_face_mask_outline|
|<span class="nerdfont big">&#xf0c7b;</span>|md_face_recognition|
|<span class="nerdfont big">&#xf1077;</span>|md_face_woman|
|<span class="nerdfont big">&#xf1078;</span>|md_face_woman_outline|
|<span class="nerdfont big">&#xf1076;</span>|md_face_woman_profile|
|<span class="nerdfont big">&#xf15ce;</span>|md_face_woman_shimmer|
|<span class="nerdfont big">&#xf15cf;</span>|md_face_woman_shimmer_outline|
|<span class="nerdfont big">&#xf020c;</span>|md_facebook|
|<span class="nerdfont big">&#xf07dd;</span>|md_facebook_gaming|
|<span class="nerdfont big">&#xf020e;</span>|md_facebook_messenger|
|<span class="nerdfont big">&#xf0b31;</span>|md_facebook_workplace|
|<span class="nerdfont big">&#xf020f;</span>|md_factory|
|<span class="nerdfont big">&#xf160e;</span>|md_family_tree|
|<span class="nerdfont big">&#xf0210;</span>|md_fan|
|<span class="nerdfont big">&#xf146c;</span>|md_fan_alert|
|<span class="nerdfont big">&#xf171d;</span>|md_fan_auto|
|<span class="nerdfont big">&#xf146d;</span>|md_fan_chevron_down|
|<span class="nerdfont big">&#xf146e;</span>|md_fan_chevron_up|
|<span class="nerdfont big">&#xf1a3a;</span>|md_fan_clock|
|<span class="nerdfont big">&#xf1470;</span>|md_fan_minus|
|<span class="nerdfont big">&#xf081d;</span>|md_fan_off|
|<span class="nerdfont big">&#xf146f;</span>|md_fan_plus|
|<span class="nerdfont big">&#xf1471;</span>|md_fan_remove|
|<span class="nerdfont big">&#xf1472;</span>|md_fan_speed_1|
|<span class="nerdfont big">&#xf1473;</span>|md_fan_speed_2|
|<span class="nerdfont big">&#xf1474;</span>|md_fan_speed_3|
|<span class="nerdfont big">&#xf0211;</span>|md_fast_forward|
|<span class="nerdfont big">&#xf11f8;</span>|md_fast_forward_5|
|<span class="nerdfont big">&#xf0d71;</span>|md_fast_forward_10|
|<span class="nerdfont big">&#xf193a;</span>|md_fast_forward_15|
|<span class="nerdfont big">&#xf0d06;</span>|md_fast_forward_30|
|<span class="nerdfont big">&#xf160b;</span>|md_fast_forward_60|
|<span class="nerdfont big">&#xf06d2;</span>|md_fast_forward_outline|
|<span class="nerdfont big">&#xf0212;</span>|md_fax|
|<span class="nerdfont big">&#xf06d3;</span>|md_feather|
|<span class="nerdfont big">&#xf0a49;</span>|md_feature_search|
|<span class="nerdfont big">&#xf0a4a;</span>|md_feature_search_outline|
|<span class="nerdfont big">&#xf08db;</span>|md_fedora|
|<span class="nerdfont big">&#xf179a;</span>|md_fence|
|<span class="nerdfont big">&#xf17f6;</span>|md_fence_electric|
|<span class="nerdfont big">&#xf14c1;</span>|md_fencing|
|<span class="nerdfont big">&#xf0ea4;</span>|md_ferris_wheel|
|<span class="nerdfont big">&#xf0213;</span>|md_ferry|
|<span class="nerdfont big">&#xf0214;</span>|md_file|
|<span class="nerdfont big">&#xf073b;</span>|md_file_account|
|<span class="nerdfont big">&#xf1028;</span>|md_file_account_outline|
|<span class="nerdfont big">&#xf0a4b;</span>|md_file_alert|
|<span class="nerdfont big">&#xf0a4c;</span>|md_file_alert_outline|
|<span class="nerdfont big">&#xf1a93;</span>|md_file_arrow_left_right|
|<span class="nerdfont big">&#xf1a94;</span>|md_file_arrow_left_right_outline|
|<span class="nerdfont big">&#xf1a95;</span>|md_file_arrow_up_down|
|<span class="nerdfont big">&#xf1a96;</span>|md_file_arrow_up_down_outline|
|<span class="nerdfont big">&#xf0ab6;</span>|md_file_cabinet|
|<span class="nerdfont big">&#xf0eeb;</span>|md_file_cad|
|<span class="nerdfont big">&#xf0eec;</span>|md_file_cad_box|
|<span class="nerdfont big">&#xf0dc6;</span>|md_file_cancel|
|<span class="nerdfont big">&#xf0dc7;</span>|md_file_cancel_outline|
|<span class="nerdfont big">&#xf1186;</span>|md_file_certificate|
|<span class="nerdfont big">&#xf1187;</span>|md_file_certificate_outline|
|<span class="nerdfont big">&#xf0215;</span>|md_file_chart|
|<span class="nerdfont big">&#xf19c6;</span>|md_file_chart_check|
|<span class="nerdfont big">&#xf19c7;</span>|md_file_chart_check_outline|
|<span class="nerdfont big">&#xf1029;</span>|md_file_chart_outline|
|<span class="nerdfont big">&#xf0216;</span>|md_file_check|
|<span class="nerdfont big">&#xf0e29;</span>|md_file_check_outline|
|<span class="nerdfont big">&#xf12e1;</span>|md_file_clock|
|<span class="nerdfont big">&#xf12e2;</span>|md_file_clock_outline|
|<span class="nerdfont big">&#xf0217;</span>|md_file_cloud|
|<span class="nerdfont big">&#xf102a;</span>|md_file_cloud_outline|
|<span class="nerdfont big">&#xf022e;</span>|md_file_code|
|<span class="nerdfont big">&#xf102b;</span>|md_file_code_outline|
|<span class="nerdfont big">&#xf107b;</span>|md_file_cog|
|<span class="nerdfont big">&#xf107c;</span>|md_file_cog_outline|
|<span class="nerdfont big">&#xf08aa;</span>|md_file_compare|
|<span class="nerdfont big">&#xf0218;</span>|md_file_delimited|
|<span class="nerdfont big">&#xf0ea5;</span>|md_file_delimited_outline|
|<span class="nerdfont big">&#xf0219;</span>|md_file_document|
|<span class="nerdfont big">&#xf1a97;</span>|md_file_document_alert|
|<span class="nerdfont big">&#xf1a98;</span>|md_file_document_alert_outline|
|<span class="nerdfont big">&#xf1a99;</span>|md_file_document_check|
|<span class="nerdfont big">&#xf1a9a;</span>|md_file_document_check_outline|
|<span class="nerdfont big">&#xf0dc8;</span>|md_file_document_edit|
|<span class="nerdfont big">&#xf0dc9;</span>|md_file_document_edit_outline|
|<span class="nerdfont big">&#xf1a9b;</span>|md_file_document_minus|
|<span class="nerdfont big">&#xf1a9c;</span>|md_file_document_minus_outline|
|<span class="nerdfont big">&#xf1517;</span>|md_file_document_multiple|
|<span class="nerdfont big">&#xf1518;</span>|md_file_document_multiple_outline|
|<span class="nerdfont big">&#xf09ee;</span>|md_file_document_outline|
|<span class="nerdfont big">&#xf1a9d;</span>|md_file_document_plus|
|<span class="nerdfont big">&#xf1a9e;</span>|md_file_document_plus_outline|
|<span class="nerdfont big">&#xf1a9f;</span>|md_file_document_remove|
|<span class="nerdfont big">&#xf1aa0;</span>|md_file_document_remove_outline|
|<span class="nerdfont big">&#xf0965;</span>|md_file_download|
|<span class="nerdfont big">&#xf0966;</span>|md_file_download_outline|
|<span class="nerdfont big">&#xf11e7;</span>|md_file_edit|
|<span class="nerdfont big">&#xf11e8;</span>|md_file_edit_outline|
|<span class="nerdfont big">&#xf021b;</span>|md_file_excel|
|<span class="nerdfont big">&#xf021c;</span>|md_file_excel_box|
|<span class="nerdfont big">&#xf102c;</span>|md_file_excel_box_outline|
|<span class="nerdfont big">&#xf102d;</span>|md_file_excel_outline|
|<span class="nerdfont big">&#xf021d;</span>|md_file_export|
|<span class="nerdfont big">&#xf102e;</span>|md_file_export_outline|
|<span class="nerdfont big">&#xf0dca;</span>|md_file_eye|
|<span class="nerdfont big">&#xf0dcb;</span>|md_file_eye_outline|
|<span class="nerdfont big">&#xf021e;</span>|md_file_find|
|<span class="nerdfont big">&#xf0b97;</span>|md_file_find_outline|
|<span class="nerdfont big">&#xf0d78;</span>|md_file_gif_box|
|<span class="nerdfont big">&#xf0613;</span>|md_file_hidden|
|<span class="nerdfont big">&#xf021f;</span>|md_file_image|
|<span class="nerdfont big">&#xf1772;</span>|md_file_image_marker|
|<span class="nerdfont big">&#xf1773;</span>|md_file_image_marker_outline|
|<span class="nerdfont big">&#xf193b;</span>|md_file_image_minus|
|<span class="nerdfont big">&#xf193c;</span>|md_file_image_minus_outline|
|<span class="nerdfont big">&#xf0eb0;</span>|md_file_image_outline|
|<span class="nerdfont big">&#xf193d;</span>|md_file_image_plus|
|<span class="nerdfont big">&#xf193e;</span>|md_file_image_plus_outline|
|<span class="nerdfont big">&#xf193f;</span>|md_file_image_remove|
|<span class="nerdfont big">&#xf1940;</span>|md_file_image_remove_outline|
|<span class="nerdfont big">&#xf0220;</span>|md_file_import|
|<span class="nerdfont big">&#xf102f;</span>|md_file_import_outline|
|<span class="nerdfont big">&#xf0225;</span>|md_file_jpg_box|
|<span class="nerdfont big">&#xf1184;</span>|md_file_key|
|<span class="nerdfont big">&#xf1185;</span>|md_file_key_outline|
|<span class="nerdfont big">&#xf1177;</span>|md_file_link|
|<span class="nerdfont big">&#xf1178;</span>|md_file_link_outline|
|<span class="nerdfont big">&#xf0221;</span>|md_file_lock|
|<span class="nerdfont big">&#xf19c8;</span>|md_file_lock_open|
|<span class="nerdfont big">&#xf19c9;</span>|md_file_lock_open_outline|
|<span class="nerdfont big">&#xf1030;</span>|md_file_lock_outline|
|<span class="nerdfont big">&#xf1774;</span>|md_file_marker|
|<span class="nerdfont big">&#xf1775;</span>|md_file_marker_outline|
|<span class="nerdfont big">&#xf1aa1;</span>|md_file_minus|
|<span class="nerdfont big">&#xf1aa2;</span>|md_file_minus_outline|
|<span class="nerdfont big">&#xf0ab9;</span>|md_file_move|
|<span class="nerdfont big">&#xf1031;</span>|md_file_move_outline|
|<span class="nerdfont big">&#xf0222;</span>|md_file_multiple|
|<span class="nerdfont big">&#xf1032;</span>|md_file_multiple_outline|
|<span class="nerdfont big">&#xf0223;</span>|md_file_music|
|<span class="nerdfont big">&#xf0e2a;</span>|md_file_music_outline|
|<span class="nerdfont big">&#xf0224;</span>|md_file_outline|
|<span class="nerdfont big">&#xf0226;</span>|md_file_pdf_box|
|<span class="nerdfont big">&#xf081e;</span>|md_file_percent|
|<span class="nerdfont big">&#xf1033;</span>|md_file_percent_outline|
|<span class="nerdfont big">&#xf1179;</span>|md_file_phone|
|<span class="nerdfont big">&#xf117a;</span>|md_file_phone_outline|
|<span class="nerdfont big">&#xf0752;</span>|md_file_plus|
|<span class="nerdfont big">&#xf0eed;</span>|md_file_plus_outline|
|<span class="nerdfont big">&#xf0e2d;</span>|md_file_png_box|
|<span class="nerdfont big">&#xf0227;</span>|md_file_powerpoint|
|<span class="nerdfont big">&#xf0228;</span>|md_file_powerpoint_box|
|<span class="nerdfont big">&#xf1034;</span>|md_file_powerpoint_box_outline|
|<span class="nerdfont big">&#xf1035;</span>|md_file_powerpoint_outline|
|<span class="nerdfont big">&#xf0229;</span>|md_file_presentation_box|
|<span class="nerdfont big">&#xf086f;</span>|md_file_question|
|<span class="nerdfont big">&#xf1036;</span>|md_file_question_outline|
|<span class="nerdfont big">&#xf0918;</span>|md_file_refresh|
|<span class="nerdfont big">&#xf0541;</span>|md_file_refresh_outline|
|<span class="nerdfont big">&#xf0b98;</span>|md_file_remove|
|<span class="nerdfont big">&#xf1037;</span>|md_file_remove_outline|
|<span class="nerdfont big">&#xf0b32;</span>|md_file_replace|
|<span class="nerdfont big">&#xf0b33;</span>|md_file_replace_outline|
|<span class="nerdfont big">&#xf0670;</span>|md_file_restore|
|<span class="nerdfont big">&#xf1038;</span>|md_file_restore_outline|
|<span class="nerdfont big">&#xf1a3b;</span>|md_file_rotate_left|
|<span class="nerdfont big">&#xf1a3c;</span>|md_file_rotate_left_outline|
|<span class="nerdfont big">&#xf1a3d;</span>|md_file_rotate_right|
|<span class="nerdfont big">&#xf1a3e;</span>|md_file_rotate_right_outline|
|<span class="nerdfont big">&#xf0c7c;</span>|md_file_search|
|<span class="nerdfont big">&#xf0c7d;</span>|md_file_search_outline|
|<span class="nerdfont big">&#xf022a;</span>|md_file_send|
|<span class="nerdfont big">&#xf1039;</span>|md_file_send_outline|
|<span class="nerdfont big">&#xf1079;</span>|md_file_settings|
|<span class="nerdfont big">&#xf107a;</span>|md_file_settings_outline|
|<span class="nerdfont big">&#xf19c3;</span>|md_file_sign|
|<span class="nerdfont big">&#xf103a;</span>|md_file_star|
|<span class="nerdfont big">&#xf103b;</span>|md_file_star_outline|
|<span class="nerdfont big">&#xf0fb4;</span>|md_file_swap|
|<span class="nerdfont big">&#xf0fb5;</span>|md_file_swap_outline|
|<span class="nerdfont big">&#xf1216;</span>|md_file_sync|
|<span class="nerdfont big">&#xf1217;</span>|md_file_sync_outline|
|<span class="nerdfont big">&#xf0c7e;</span>|md_file_table|
|<span class="nerdfont big">&#xf10e1;</span>|md_file_table_box|
|<span class="nerdfont big">&#xf10e2;</span>|md_file_table_box_multiple|
|<span class="nerdfont big">&#xf10e3;</span>|md_file_table_box_multiple_outline|
|<span class="nerdfont big">&#xf10e4;</span>|md_file_table_box_outline|
|<span class="nerdfont big">&#xf0c7f;</span>|md_file_table_outline|
|<span class="nerdfont big">&#xf0645;</span>|md_file_tree|
|<span class="nerdfont big">&#xf13d2;</span>|md_file_tree_outline|
|<span class="nerdfont big">&#xf08dc;</span>|md_file_undo|
|<span class="nerdfont big">&#xf103c;</span>|md_file_undo_outline|
|<span class="nerdfont big">&#xf0a4d;</span>|md_file_upload|
|<span class="nerdfont big">&#xf0a4e;</span>|md_file_upload_outline|
|<span class="nerdfont big">&#xf022b;</span>|md_file_video|
|<span class="nerdfont big">&#xf0e2c;</span>|md_file_video_outline|
|<span class="nerdfont big">&#xf022c;</span>|md_file_word|
|<span class="nerdfont big">&#xf022d;</span>|md_file_word_box|
|<span class="nerdfont big">&#xf103d;</span>|md_file_word_box_outline|
|<span class="nerdfont big">&#xf103e;</span>|md_file_word_outline|
|<span class="nerdfont big">&#xf022f;</span>|md_film|
|<span class="nerdfont big">&#xf0230;</span>|md_filmstrip|
|<span class="nerdfont big">&#xf0332;</span>|md_filmstrip_box|
|<span class="nerdfont big">&#xf0d18;</span>|md_filmstrip_box_multiple|
|<span class="nerdfont big">&#xf0231;</span>|md_filmstrip_off|
|<span class="nerdfont big">&#xf0232;</span>|md_filter|
|<span class="nerdfont big">&#xf18ec;</span>|md_filter_check|
|<span class="nerdfont big">&#xf18ed;</span>|md_filter_check_outline|
|<span class="nerdfont big">&#xf1aa3;</span>|md_filter_cog|
|<span class="nerdfont big">&#xf1aa4;</span>|md_filter_cog_outline|
|<span class="nerdfont big">&#xf10e5;</span>|md_filter_menu|
|<span class="nerdfont big">&#xf10e6;</span>|md_filter_menu_outline|
|<span class="nerdfont big">&#xf0eee;</span>|md_filter_minus|
|<span class="nerdfont big">&#xf0eef;</span>|md_filter_minus_outline|
|<span class="nerdfont big">&#xf1a3f;</span>|md_filter_multiple|
|<span class="nerdfont big">&#xf1a40;</span>|md_filter_multiple_outline|
|<span class="nerdfont big">&#xf14ef;</span>|md_filter_off|
|<span class="nerdfont big">&#xf14f0;</span>|md_filter_off_outline|
|<span class="nerdfont big">&#xf0233;</span>|md_filter_outline|
|<span class="nerdfont big">&#xf0ef0;</span>|md_filter_plus|
|<span class="nerdfont big">&#xf0ef1;</span>|md_filter_plus_outline|
|<span class="nerdfont big">&#xf0234;</span>|md_filter_remove|
|<span class="nerdfont big">&#xf0235;</span>|md_filter_remove_outline|
|<span class="nerdfont big">&#xf1aa5;</span>|md_filter_settings|
|<span class="nerdfont big">&#xf1aa6;</span>|md_filter_settings_outline|
|<span class="nerdfont big">&#xf0236;</span>|md_filter_variant|
|<span class="nerdfont big">&#xf1112;</span>|md_filter_variant_minus|
|<span class="nerdfont big">&#xf1113;</span>|md_filter_variant_plus|
|<span class="nerdfont big">&#xf103f;</span>|md_filter_variant_remove|
|<span class="nerdfont big">&#xf081f;</span>|md_finance|
|<span class="nerdfont big">&#xf06d4;</span>|md_find_replace|
|<span class="nerdfont big">&#xf0237;</span>|md_fingerprint|
|<span class="nerdfont big">&#xf0eb1;</span>|md_fingerprint_off|
|<span class="nerdfont big">&#xf0238;</span>|md_fire|
|<span class="nerdfont big">&#xf15d7;</span>|md_fire_alert|
|<span class="nerdfont big">&#xf1807;</span>|md_fire_circle|
|<span class="nerdfont big">&#xf0ef2;</span>|md_fire_extinguisher|
|<span class="nerdfont big">&#xf1137;</span>|md_fire_hydrant|
|<span class="nerdfont big">&#xf1138;</span>|md_fire_hydrant_alert|
|<span class="nerdfont big">&#xf1139;</span>|md_fire_hydrant_off|
|<span class="nerdfont big">&#xf1722;</span>|md_fire_off|
|<span class="nerdfont big">&#xf08ab;</span>|md_fire_truck|
|<span class="nerdfont big">&#xf0967;</span>|md_firebase|
|<span class="nerdfont big">&#xf0239;</span>|md_firefox|
|<span class="nerdfont big">&#xf0e2e;</span>|md_fireplace|
|<span class="nerdfont big">&#xf0e2f;</span>|md_fireplace_off|
|<span class="nerdfont big">&#xf05be;</span>|md_firewire|
|<span class="nerdfont big">&#xf0e30;</span>|md_firework|
|<span class="nerdfont big">&#xf1723;</span>|md_firework_off|
|<span class="nerdfont big">&#xf023a;</span>|md_fish|
|<span class="nerdfont big">&#xf13f3;</span>|md_fish_off|
|<span class="nerdfont big">&#xf0ef3;</span>|md_fishbowl|
|<span class="nerdfont big">&#xf0ef4;</span>|md_fishbowl_outline|
|<span class="nerdfont big">&#xf0ef5;</span>|md_fit_to_page|
|<span class="nerdfont big">&#xf0ef6;</span>|md_fit_to_page_outline|
|<span class="nerdfont big">&#xf18f4;</span>|md_fit_to_screen|
|<span class="nerdfont big">&#xf18f5;</span>|md_fit_to_screen_outline|
|<span class="nerdfont big">&#xf023b;</span>|md_flag|
|<span class="nerdfont big">&#xf023c;</span>|md_flag_checkered|
|<span class="nerdfont big">&#xf0b99;</span>|md_flag_minus|
|<span class="nerdfont big">&#xf10b2;</span>|md_flag_minus_outline|
|<span class="nerdfont big">&#xf18ee;</span>|md_flag_off|
|<span class="nerdfont big">&#xf18ef;</span>|md_flag_off_outline|
|<span class="nerdfont big">&#xf023d;</span>|md_flag_outline|
|<span class="nerdfont big">&#xf0b9a;</span>|md_flag_plus|
|<span class="nerdfont big">&#xf10b3;</span>|md_flag_plus_outline|
|<span class="nerdfont big">&#xf0b9b;</span>|md_flag_remove|
|<span class="nerdfont big">&#xf10b4;</span>|md_flag_remove_outline|
|<span class="nerdfont big">&#xf023f;</span>|md_flag_triangle|
|<span class="nerdfont big">&#xf0240;</span>|md_flag_variant|
|<span class="nerdfont big">&#xf023e;</span>|md_flag_variant_outline|
|<span class="nerdfont big">&#xf0d72;</span>|md_flare|
|<span class="nerdfont big">&#xf0241;</span>|md_flash|
|<span class="nerdfont big">&#xf0ef7;</span>|md_flash_alert|
|<span class="nerdfont big">&#xf0ef8;</span>|md_flash_alert_outline|
|<span class="nerdfont big">&#xf0242;</span>|md_flash_auto|
|<span class="nerdfont big">&#xf0243;</span>|md_flash_off|
|<span class="nerdfont big">&#xf06d5;</span>|md_flash_outline|
|<span class="nerdfont big">&#xf067b;</span>|md_flash_red_eye|
|<span class="nerdfont big">&#xf0244;</span>|md_flashlight|
|<span class="nerdfont big">&#xf0245;</span>|md_flashlight_off|
|<span class="nerdfont big">&#xf0093;</span>|md_flask|
|<span class="nerdfont big">&#xf0094;</span>|md_flask_empty|
|<span class="nerdfont big">&#xf123a;</span>|md_flask_empty_minus|
|<span class="nerdfont big">&#xf123b;</span>|md_flask_empty_minus_outline|
|<span class="nerdfont big">&#xf13f4;</span>|md_flask_empty_off|
|<span class="nerdfont big">&#xf13f5;</span>|md_flask_empty_off_outline|
|<span class="nerdfont big">&#xf0095;</span>|md_flask_empty_outline|
|<span class="nerdfont big">&#xf123c;</span>|md_flask_empty_plus|
|<span class="nerdfont big">&#xf123d;</span>|md_flask_empty_plus_outline|
|<span class="nerdfont big">&#xf123e;</span>|md_flask_empty_remove|
|<span class="nerdfont big">&#xf123f;</span>|md_flask_empty_remove_outline|
|<span class="nerdfont big">&#xf1240;</span>|md_flask_minus|
|<span class="nerdfont big">&#xf1241;</span>|md_flask_minus_outline|
|<span class="nerdfont big">&#xf13f6;</span>|md_flask_off|
|<span class="nerdfont big">&#xf13f7;</span>|md_flask_off_outline|
|<span class="nerdfont big">&#xf0096;</span>|md_flask_outline|
|<span class="nerdfont big">&#xf1242;</span>|md_flask_plus|
|<span class="nerdfont big">&#xf1243;</span>|md_flask_plus_outline|
|<span class="nerdfont big">&#xf1244;</span>|md_flask_remove|
|<span class="nerdfont big">&#xf1245;</span>|md_flask_remove_outline|
|<span class="nerdfont big">&#xf124b;</span>|md_flask_round_bottom|
|<span class="nerdfont big">&#xf124c;</span>|md_flask_round_bottom_empty|
|<span class="nerdfont big">&#xf124d;</span>|md_flask_round_bottom_empty_outline|
|<span class="nerdfont big">&#xf124e;</span>|md_flask_round_bottom_outline|
|<span class="nerdfont big">&#xf1303;</span>|md_fleur_de_lis|
|<span class="nerdfont big">&#xf10e7;</span>|md_flip_horizontal|
|<span class="nerdfont big">&#xf0247;</span>|md_flip_to_back|
|<span class="nerdfont big">&#xf0248;</span>|md_flip_to_front|
|<span class="nerdfont big">&#xf10e8;</span>|md_flip_vertical|
|<span class="nerdfont big">&#xf08dd;</span>|md_floor_lamp|
|<span class="nerdfont big">&#xf1040;</span>|md_floor_lamp_dual|
|<span class="nerdfont big">&#xf17ce;</span>|md_floor_lamp_dual_outline|
|<span class="nerdfont big">&#xf17c8;</span>|md_floor_lamp_outline|
|<span class="nerdfont big">&#xf1747;</span>|md_floor_lamp_torchiere|
|<span class="nerdfont big">&#xf17d6;</span>|md_floor_lamp_torchiere_outline|
|<span class="nerdfont big">&#xf1041;</span>|md_floor_lamp_torchiere_variant|
|<span class="nerdfont big">&#xf17cf;</span>|md_floor_lamp_torchiere_variant_outline|
|<span class="nerdfont big">&#xf0821;</span>|md_floor_plan|
|<span class="nerdfont big">&#xf0249;</span>|md_floppy|
|<span class="nerdfont big">&#xf09ef;</span>|md_floppy_variant|
|<span class="nerdfont big">&#xf024a;</span>|md_flower|
|<span class="nerdfont big">&#xf09f0;</span>|md_flower_outline|
|<span class="nerdfont big">&#xf1885;</span>|md_flower_pollen|
|<span class="nerdfont big">&#xf1886;</span>|md_flower_pollen_outline|
|<span class="nerdfont big">&#xf0d08;</span>|md_flower_poppy|
|<span class="nerdfont big">&#xf09f1;</span>|md_flower_tulip|
|<span class="nerdfont big">&#xf09f2;</span>|md_flower_tulip_outline|
|<span class="nerdfont big">&#xf0f4e;</span>|md_focus_auto|
|<span class="nerdfont big">&#xf0f4f;</span>|md_focus_field|
|<span class="nerdfont big">&#xf0f50;</span>|md_focus_field_horizontal|
|<span class="nerdfont big">&#xf0f51;</span>|md_focus_field_vertical|
|<span class="nerdfont big">&#xf024b;</span>|md_folder|
|<span class="nerdfont big">&#xf024c;</span>|md_folder_account|
|<span class="nerdfont big">&#xf0b9c;</span>|md_folder_account_outline|
|<span class="nerdfont big">&#xf0dcc;</span>|md_folder_alert|
|<span class="nerdfont big">&#xf0dcd;</span>|md_folder_alert_outline|
|<span class="nerdfont big">&#xf19e8;</span>|md_folder_arrow_down|
|<span class="nerdfont big">&#xf19e9;</span>|md_folder_arrow_down_outline|
|<span class="nerdfont big">&#xf19ea;</span>|md_folder_arrow_left|
|<span class="nerdfont big">&#xf19eb;</span>|md_folder_arrow_left_outline|
|<span class="nerdfont big">&#xf19ec;</span>|md_folder_arrow_left_right|
|<span class="nerdfont big">&#xf19ed;</span>|md_folder_arrow_left_right_outline|
|<span class="nerdfont big">&#xf19ee;</span>|md_folder_arrow_right|
|<span class="nerdfont big">&#xf19ef;</span>|md_folder_arrow_right_outline|
|<span class="nerdfont big">&#xf19f0;</span>|md_folder_arrow_up|
|<span class="nerdfont big">&#xf19f1;</span>|md_folder_arrow_up_down|
|<span class="nerdfont big">&#xf19f2;</span>|md_folder_arrow_up_down_outline|
|<span class="nerdfont big">&#xf19f3;</span>|md_folder_arrow_up_outline|
|<span class="nerdfont big">&#xf19f4;</span>|md_folder_cancel|
|<span class="nerdfont big">&#xf19f5;</span>|md_folder_cancel_outline|
|<span class="nerdfont big">&#xf197e;</span>|md_folder_check|
|<span class="nerdfont big">&#xf197f;</span>|md_folder_check_outline|
|<span class="nerdfont big">&#xf0aba;</span>|md_folder_clock|
|<span class="nerdfont big">&#xf0abb;</span>|md_folder_clock_outline|
|<span class="nerdfont big">&#xf107f;</span>|md_folder_cog|
|<span class="nerdfont big">&#xf1080;</span>|md_folder_cog_outline|
|<span class="nerdfont big">&#xf024d;</span>|md_folder_download|
|<span class="nerdfont big">&#xf10e9;</span>|md_folder_download_outline|
|<span class="nerdfont big">&#xf08de;</span>|md_folder_edit|
|<span class="nerdfont big">&#xf0dce;</span>|md_folder_edit_outline|
|<span class="nerdfont big">&#xf178a;</span>|md_folder_eye|
|<span class="nerdfont big">&#xf178b;</span>|md_folder_eye_outline|
|<span class="nerdfont big">&#xf19f6;</span>|md_folder_file|
|<span class="nerdfont big">&#xf19f7;</span>|md_folder_file_outline|
|<span class="nerdfont big">&#xf024e;</span>|md_folder_google_drive|
|<span class="nerdfont big">&#xf10ea;</span>|md_folder_heart|
|<span class="nerdfont big">&#xf10eb;</span>|md_folder_heart_outline|
|<span class="nerdfont big">&#xf179e;</span>|md_folder_hidden|
|<span class="nerdfont big">&#xf10b5;</span>|md_folder_home|
|<span class="nerdfont big">&#xf10b6;</span>|md_folder_home_outline|
|<span class="nerdfont big">&#xf024f;</span>|md_folder_image|
|<span class="nerdfont big">&#xf10b7;</span>|md_folder_information|
|<span class="nerdfont big">&#xf10b8;</span>|md_folder_information_outline|
|<span class="nerdfont big">&#xf08ac;</span>|md_folder_key|
|<span class="nerdfont big">&#xf08ad;</span>|md_folder_key_network|
|<span class="nerdfont big">&#xf0c80;</span>|md_folder_key_network_outline|
|<span class="nerdfont big">&#xf10ec;</span>|md_folder_key_outline|
|<span class="nerdfont big">&#xf0250;</span>|md_folder_lock|
|<span class="nerdfont big">&#xf0251;</span>|md_folder_lock_open|
|<span class="nerdfont big">&#xf1aa7;</span>|md_folder_lock_open_outline|
|<span class="nerdfont big">&#xf1aa8;</span>|md_folder_lock_outline|
|<span class="nerdfont big">&#xf126d;</span>|md_folder_marker|
|<span class="nerdfont big">&#xf126e;</span>|md_folder_marker_outline|
|<span class="nerdfont big">&#xf0252;</span>|md_folder_move|
|<span class="nerdfont big">&#xf1246;</span>|md_folder_move_outline|
|<span class="nerdfont big">&#xf0253;</span>|md_folder_multiple|
|<span class="nerdfont big">&#xf0254;</span>|md_folder_multiple_image|
|<span class="nerdfont big">&#xf0255;</span>|md_folder_multiple_outline|
|<span class="nerdfont big">&#xf147e;</span>|md_folder_multiple_plus|
|<span class="nerdfont big">&#xf147f;</span>|md_folder_multiple_plus_outline|
|<span class="nerdfont big">&#xf1359;</span>|md_folder_music|
|<span class="nerdfont big">&#xf135a;</span>|md_folder_music_outline|
|<span class="nerdfont big">&#xf0870;</span>|md_folder_network|
|<span class="nerdfont big">&#xf0c81;</span>|md_folder_network_outline|
|<span class="nerdfont big">&#xf19f8;</span>|md_folder_off|
|<span class="nerdfont big">&#xf19f9;</span>|md_folder_off_outline|
|<span class="nerdfont big">&#xf0770;</span>|md_folder_open|
|<span class="nerdfont big">&#xf0dcf;</span>|md_folder_open_outline|
|<span class="nerdfont big">&#xf0256;</span>|md_folder_outline|
|<span class="nerdfont big">&#xf19fa;</span>|md_folder_play|
|<span class="nerdfont big">&#xf19fb;</span>|md_folder_play_outline|
|<span class="nerdfont big">&#xf0257;</span>|md_folder_plus|
|<span class="nerdfont big">&#xf0b9d;</span>|md_folder_plus_outline|
|<span class="nerdfont big">&#xf0d09;</span>|md_folder_pound|
|<span class="nerdfont big">&#xf0d0a;</span>|md_folder_pound_outline|
|<span class="nerdfont big">&#xf19ca;</span>|md_folder_question|
|<span class="nerdfont big">&#xf19cb;</span>|md_folder_question_outline|
|<span class="nerdfont big">&#xf0749;</span>|md_folder_refresh|
|<span class="nerdfont big">&#xf0542;</span>|md_folder_refresh_outline|
|<span class="nerdfont big">&#xf0258;</span>|md_folder_remove|
|<span class="nerdfont big">&#xf0b9e;</span>|md_folder_remove_outline|
|<span class="nerdfont big">&#xf0968;</span>|md_folder_search|
|<span class="nerdfont big">&#xf0969;</span>|md_folder_search_outline|
|<span class="nerdfont big">&#xf107d;</span>|md_folder_settings|
|<span class="nerdfont big">&#xf107e;</span>|md_folder_settings_outline|
|<span class="nerdfont big">&#xf069d;</span>|md_folder_star|
|<span class="nerdfont big">&#xf13d3;</span>|md_folder_star_multiple|
|<span class="nerdfont big">&#xf13d4;</span>|md_folder_star_multiple_outline|
|<span class="nerdfont big">&#xf0b9f;</span>|md_folder_star_outline|
|<span class="nerdfont big">&#xf0fb6;</span>|md_folder_swap|
|<span class="nerdfont big">&#xf0fb7;</span>|md_folder_swap_outline|
|<span class="nerdfont big">&#xf0d0b;</span>|md_folder_sync|
|<span class="nerdfont big">&#xf0d0c;</span>|md_folder_sync_outline|
|<span class="nerdfont big">&#xf12e3;</span>|md_folder_table|
|<span class="nerdfont big">&#xf12e4;</span>|md_folder_table_outline|
|<span class="nerdfont big">&#xf0c82;</span>|md_folder_text|
|<span class="nerdfont big">&#xf0c83;</span>|md_folder_text_outline|
|<span class="nerdfont big">&#xf0259;</span>|md_folder_upload|
|<span class="nerdfont big">&#xf10ed;</span>|md_folder_upload_outline|
|<span class="nerdfont big">&#xf19fc;</span>|md_folder_wrench|
|<span class="nerdfont big">&#xf19fd;</span>|md_folder_wrench_outline|
|<span class="nerdfont big">&#xf06eb;</span>|md_folder_zip|
|<span class="nerdfont big">&#xf07b9;</span>|md_folder_zip_outline|
|<span class="nerdfont big">&#xf003a;</span>|md_font_awesome|
|<span class="nerdfont big">&#xf025a;</span>|md_food|
|<span class="nerdfont big">&#xf025b;</span>|md_food_apple|
|<span class="nerdfont big">&#xf0c84;</span>|md_food_apple_outline|
|<span class="nerdfont big">&#xf07c8;</span>|md_food_croissant|
|<span class="nerdfont big">&#xf141f;</span>|md_food_drumstick|
|<span class="nerdfont big">&#xf1468;</span>|md_food_drumstick_off|
|<span class="nerdfont big">&#xf1469;</span>|md_food_drumstick_off_outline|
|<span class="nerdfont big">&#xf1420;</span>|md_food_drumstick_outline|
|<span class="nerdfont big">&#xf05f2;</span>|md_food_fork_drink|
|<span class="nerdfont big">&#xf1572;</span>|md_food_halal|
|<span class="nerdfont big">&#xf184b;</span>|md_food_hot_dog|
|<span class="nerdfont big">&#xf1573;</span>|md_food_kosher|
|<span class="nerdfont big">&#xf05f3;</span>|md_food_off|
|<span class="nerdfont big">&#xf1915;</span>|md_food_off_outline|
|<span class="nerdfont big">&#xf1916;</span>|md_food_outline|
|<span class="nerdfont big">&#xf146a;</span>|md_food_steak|
|<span class="nerdfont big">&#xf146b;</span>|md_food_steak_off|
|<span class="nerdfont big">&#xf1836;</span>|md_food_takeout_box|
|<span class="nerdfont big">&#xf1837;</span>|md_food_takeout_box_outline|
|<span class="nerdfont big">&#xf171c;</span>|md_food_turkey|
|<span class="nerdfont big">&#xf025c;</span>|md_food_variant|
|<span class="nerdfont big">&#xf13e5;</span>|md_food_variant_off|
|<span class="nerdfont big">&#xf0f52;</span>|md_foot_print|
|<span class="nerdfont big">&#xf025d;</span>|md_football|
|<span class="nerdfont big">&#xf025e;</span>|md_football_australian|
|<span class="nerdfont big">&#xf025f;</span>|md_football_helmet|
|<span class="nerdfont big">&#xf1897;</span>|md_forest|
|<span class="nerdfont big">&#xf07c9;</span>|md_forklift|
|<span class="nerdfont big">&#xf1400;</span>|md_form_dropdown|
|<span class="nerdfont big">&#xf1401;</span>|md_form_select|
|<span class="nerdfont big">&#xf1095;</span>|md_form_textarea|
|<span class="nerdfont big">&#xf060e;</span>|md_form_textbox|
|<span class="nerdfont big">&#xf135d;</span>|md_form_textbox_lock|
|<span class="nerdfont big">&#xf07f5;</span>|md_form_textbox_password|
|<span class="nerdfont big">&#xf0753;</span>|md_format_align_bottom|
|<span class="nerdfont big">&#xf0260;</span>|md_format_align_center|
|<span class="nerdfont big">&#xf0261;</span>|md_format_align_justify|
|<span class="nerdfont big">&#xf0262;</span>|md_format_align_left|
|<span class="nerdfont big">&#xf0754;</span>|md_format_align_middle|
|<span class="nerdfont big">&#xf0263;</span>|md_format_align_right|
|<span class="nerdfont big">&#xf0755;</span>|md_format_align_top|
|<span class="nerdfont big">&#xf0abc;</span>|md_format_annotation_minus|
|<span class="nerdfont big">&#xf0646;</span>|md_format_annotation_plus|
|<span class="nerdfont big">&#xf0264;</span>|md_format_bold|
|<span class="nerdfont big">&#xf0265;</span>|md_format_clear|
|<span class="nerdfont big">&#xf0266;</span>|md_format_color_fill|
|<span class="nerdfont big">&#xf0e31;</span>|md_format_color_highlight|
|<span class="nerdfont big">&#xf1313;</span>|md_format_color_marker_cancel|
|<span class="nerdfont big">&#xf069e;</span>|md_format_color_text|
|<span class="nerdfont big">&#xf08df;</span>|md_format_columns|
|<span class="nerdfont big">&#xf0267;</span>|md_format_float_center|
|<span class="nerdfont big">&#xf0268;</span>|md_format_float_left|
|<span class="nerdfont big">&#xf0269;</span>|md_format_float_none|
|<span class="nerdfont big">&#xf026a;</span>|md_format_float_right|
|<span class="nerdfont big">&#xf06d6;</span>|md_format_font|
|<span class="nerdfont big">&#xf09f3;</span>|md_format_font_size_decrease|
|<span class="nerdfont big">&#xf09f4;</span>|md_format_font_size_increase|
|<span class="nerdfont big">&#xf026b;</span>|md_format_header_1|
|<span class="nerdfont big">&#xf026c;</span>|md_format_header_2|
|<span class="nerdfont big">&#xf026d;</span>|md_format_header_3|
|<span class="nerdfont big">&#xf026e;</span>|md_format_header_4|
|<span class="nerdfont big">&#xf026f;</span>|md_format_header_5|
|<span class="nerdfont big">&#xf0270;</span>|md_format_header_6|
|<span class="nerdfont big">&#xf0271;</span>|md_format_header_decrease|
|<span class="nerdfont big">&#xf0272;</span>|md_format_header_equal|
|<span class="nerdfont big">&#xf0273;</span>|md_format_header_increase|
|<span class="nerdfont big">&#xf0274;</span>|md_format_header_pound|
|<span class="nerdfont big">&#xf061e;</span>|md_format_horizontal_align_center|
|<span class="nerdfont big">&#xf061f;</span>|md_format_horizontal_align_left|
|<span class="nerdfont big">&#xf0620;</span>|md_format_horizontal_align_right|
|<span class="nerdfont big">&#xf0275;</span>|md_format_indent_decrease|
|<span class="nerdfont big">&#xf0276;</span>|md_format_indent_increase|
|<span class="nerdfont big">&#xf0277;</span>|md_format_italic|
|<span class="nerdfont big">&#xf0b34;</span>|md_format_letter_case|
|<span class="nerdfont big">&#xf0b35;</span>|md_format_letter_case_lower|
|<span class="nerdfont big">&#xf0b36;</span>|md_format_letter_case_upper|
|<span class="nerdfont big">&#xf0fb8;</span>|md_format_letter_ends_with|
|<span class="nerdfont big">&#xf0fb9;</span>|md_format_letter_matches|
|<span class="nerdfont big">&#xf1956;</span>|md_format_letter_spacing|
|<span class="nerdfont big">&#xf0fba;</span>|md_format_letter_starts_with|
|<span class="nerdfont big">&#xf0278;</span>|md_format_line_spacing|
|<span class="nerdfont big">&#xf05c8;</span>|md_format_line_style|
|<span class="nerdfont big">&#xf05c9;</span>|md_format_line_weight|
|<span class="nerdfont big">&#xf0279;</span>|md_format_list_bulleted|
|<span class="nerdfont big">&#xf0dd0;</span>|md_format_list_bulleted_square|
|<span class="nerdfont big">&#xf0eb2;</span>|md_format_list_bulleted_triangle|
|<span class="nerdfont big">&#xf027a;</span>|md_format_list_bulleted_type|
|<span class="nerdfont big">&#xf096a;</span>|md_format_list_checkbox|
|<span class="nerdfont big">&#xf0756;</span>|md_format_list_checks|
|<span class="nerdfont big">&#xf1860;</span>|md_format_list_group|
|<span class="nerdfont big">&#xf027b;</span>|md_format_list_numbered|
|<span class="nerdfont big">&#xf0d0d;</span>|md_format_list_numbered_rtl|
|<span class="nerdfont big">&#xf126f;</span>|md_format_list_text|
|<span class="nerdfont big">&#xf0eb3;</span>|md_format_overline|
|<span class="nerdfont big">&#xf06d7;</span>|md_format_page_break|
|<span class="nerdfont big">&#xf1917;</span>|md_format_page_split|
|<span class="nerdfont big">&#xf027c;</span>|md_format_paint|
|<span class="nerdfont big">&#xf027d;</span>|md_format_paragraph|
|<span class="nerdfont big">&#xf06d8;</span>|md_format_pilcrow|
|<span class="nerdfont big">&#xf027e;</span>|md_format_quote_close|
|<span class="nerdfont big">&#xf11a8;</span>|md_format_quote_close_outline|
|<span class="nerdfont big">&#xf0757;</span>|md_format_quote_open|
|<span class="nerdfont big">&#xf11a7;</span>|md_format_quote_open_outline|
|<span class="nerdfont big">&#xf06aa;</span>|md_format_rotate_90|
|<span class="nerdfont big">&#xf069f;</span>|md_format_section|
|<span class="nerdfont big">&#xf027f;</span>|md_format_size|
|<span class="nerdfont big">&#xf0280;</span>|md_format_strikethrough|
|<span class="nerdfont big">&#xf0281;</span>|md_format_strikethrough_variant|
|<span class="nerdfont big">&#xf0282;</span>|md_format_subscript|
|<span class="nerdfont big">&#xf0283;</span>|md_format_superscript|
|<span class="nerdfont big">&#xf0284;</span>|md_format_text|
|<span class="nerdfont big">&#xf0fbb;</span>|md_format_text_rotation_angle_down|
|<span class="nerdfont big">&#xf0fbc;</span>|md_format_text_rotation_angle_up|
|<span class="nerdfont big">&#xf0d73;</span>|md_format_text_rotation_down|
|<span class="nerdfont big">&#xf0fbd;</span>|md_format_text_rotation_down_vertical|
|<span class="nerdfont big">&#xf0d74;</span>|md_format_text_rotation_none|
|<span class="nerdfont big">&#xf0fbe;</span>|md_format_text_rotation_up|
|<span class="nerdfont big">&#xf0fbf;</span>|md_format_text_rotation_vertical|
|<span class="nerdfont big">&#xf0e32;</span>|md_format_text_variant|
|<span class="nerdfont big">&#xf150f;</span>|md_format_text_variant_outline|
|<span class="nerdfont big">&#xf0d0e;</span>|md_format_text_wrapping_clip|
|<span class="nerdfont big">&#xf0d0f;</span>|md_format_text_wrapping_overflow|
|<span class="nerdfont big">&#xf0d10;</span>|md_format_text_wrapping_wrap|
|<span class="nerdfont big">&#xf0d11;</span>|md_format_textbox|
|<span class="nerdfont big">&#xf0285;</span>|md_format_textdirection_l_to_r|
|<span class="nerdfont big">&#xf0286;</span>|md_format_textdirection_r_to_l|
|<span class="nerdfont big">&#xf05f4;</span>|md_format_title|
|<span class="nerdfont big">&#xf0287;</span>|md_format_underline|
|<span class="nerdfont big">&#xf18e9;</span>|md_format_underline_wavy|
|<span class="nerdfont big">&#xf0621;</span>|md_format_vertical_align_bottom|
|<span class="nerdfont big">&#xf0622;</span>|md_format_vertical_align_center|
|<span class="nerdfont big">&#xf0623;</span>|md_format_vertical_align_top|
|<span class="nerdfont big">&#xf0288;</span>|md_format_wrap_inline|
|<span class="nerdfont big">&#xf0289;</span>|md_format_wrap_square|
|<span class="nerdfont big">&#xf028a;</span>|md_format_wrap_tight|
|<span class="nerdfont big">&#xf028b;</span>|md_format_wrap_top_bottom|
|<span class="nerdfont big">&#xf028c;</span>|md_forum|
|<span class="nerdfont big">&#xf1aa9;</span>|md_forum_minus|
|<span class="nerdfont big">&#xf1aaa;</span>|md_forum_minus_outline|
|<span class="nerdfont big">&#xf0822;</span>|md_forum_outline|
|<span class="nerdfont big">&#xf1aab;</span>|md_forum_plus|
|<span class="nerdfont big">&#xf1aac;</span>|md_forum_plus_outline|
|<span class="nerdfont big">&#xf1aad;</span>|md_forum_remove|
|<span class="nerdfont big">&#xf1aae;</span>|md_forum_remove_outline|
|<span class="nerdfont big">&#xf028d;</span>|md_forward|
|<span class="nerdfont big">&#xf0d75;</span>|md_forwardburger|
|<span class="nerdfont big">&#xf096b;</span>|md_fountain|
|<span class="nerdfont big">&#xf0d12;</span>|md_fountain_pen|
|<span class="nerdfont big">&#xf0d13;</span>|md_fountain_pen_tip|
|<span class="nerdfont big">&#xf1992;</span>|md_fraction_one_half|
|<span class="nerdfont big">&#xf08e0;</span>|md_freebsd|
|<span class="nerdfont big">&#xf1957;</span>|md_french_fries|
|<span class="nerdfont big">&#xf0eb4;</span>|md_frequently_asked_questions|
|<span class="nerdfont big">&#xf0290;</span>|md_fridge|
|<span class="nerdfont big">&#xf11b1;</span>|md_fridge_alert|
|<span class="nerdfont big">&#xf11b2;</span>|md_fridge_alert_outline|
|<span class="nerdfont big">&#xf0292;</span>|md_fridge_bottom|
|<span class="nerdfont big">&#xf15ee;</span>|md_fridge_industrial|
|<span class="nerdfont big">&#xf15ef;</span>|md_fridge_industrial_alert|
|<span class="nerdfont big">&#xf15f0;</span>|md_fridge_industrial_alert_outline|
|<span class="nerdfont big">&#xf15f1;</span>|md_fridge_industrial_off|
|<span class="nerdfont big">&#xf15f2;</span>|md_fridge_industrial_off_outline|
|<span class="nerdfont big">&#xf15f3;</span>|md_fridge_industrial_outline|
|<span class="nerdfont big">&#xf11af;</span>|md_fridge_off|
|<span class="nerdfont big">&#xf11b0;</span>|md_fridge_off_outline|
|<span class="nerdfont big">&#xf028f;</span>|md_fridge_outline|
|<span class="nerdfont big">&#xf0291;</span>|md_fridge_top|
|<span class="nerdfont big">&#xf15f4;</span>|md_fridge_variant|
|<span class="nerdfont big">&#xf15f5;</span>|md_fridge_variant_alert|
|<span class="nerdfont big">&#xf15f6;</span>|md_fridge_variant_alert_outline|
|<span class="nerdfont big">&#xf15f7;</span>|md_fridge_variant_off|
|<span class="nerdfont big">&#xf15f8;</span>|md_fridge_variant_off_outline|
|<span class="nerdfont big">&#xf15f9;</span>|md_fridge_variant_outline|
|<span class="nerdfont big">&#xf1042;</span>|md_fruit_cherries|
|<span class="nerdfont big">&#xf13f8;</span>|md_fruit_cherries_off|
|<span class="nerdfont big">&#xf1043;</span>|md_fruit_citrus|
|<span class="nerdfont big">&#xf13f9;</span>|md_fruit_citrus_off|
|<span class="nerdfont big">&#xf1044;</span>|md_fruit_grapes|
|<span class="nerdfont big">&#xf1045;</span>|md_fruit_grapes_outline|
|<span class="nerdfont big">&#xf1a0e;</span>|md_fruit_pear|
|<span class="nerdfont big">&#xf1046;</span>|md_fruit_pineapple|
|<span class="nerdfont big">&#xf1047;</span>|md_fruit_watermelon|
|<span class="nerdfont big">&#xf07ca;</span>|md_fuel|
|<span class="nerdfont big">&#xf18b5;</span>|md_fuel_cell|
|<span class="nerdfont big">&#xf0293;</span>|md_fullscreen|
|<span class="nerdfont big">&#xf0294;</span>|md_fullscreen_exit|
|<span class="nerdfont big">&#xf0295;</span>|md_function|
|<span class="nerdfont big">&#xf0871;</span>|md_function_variant|
|<span class="nerdfont big">&#xf1081;</span>|md_furigana_horizontal|
|<span class="nerdfont big">&#xf1082;</span>|md_furigana_vertical|
|<span class="nerdfont big">&#xf0c85;</span>|md_fuse|
|<span class="nerdfont big">&#xf142d;</span>|md_fuse_alert|
|<span class="nerdfont big">&#xf0c86;</span>|md_fuse_blade|
|<span class="nerdfont big">&#xf142c;</span>|md_fuse_off|
|<span class="nerdfont big">&#xf0296;</span>|md_gamepad|
|<span class="nerdfont big">&#xf0e33;</span>|md_gamepad_circle|
|<span class="nerdfont big">&#xf0e34;</span>|md_gamepad_circle_down|
|<span class="nerdfont big">&#xf0e35;</span>|md_gamepad_circle_left|
|<span class="nerdfont big">&#xf0e36;</span>|md_gamepad_circle_outline|
|<span class="nerdfont big">&#xf0e37;</span>|md_gamepad_circle_right|
|<span class="nerdfont big">&#xf0e38;</span>|md_gamepad_circle_up|
|<span class="nerdfont big">&#xf0e39;</span>|md_gamepad_down|
|<span class="nerdfont big">&#xf0e3a;</span>|md_gamepad_left|
|<span class="nerdfont big">&#xf1919;</span>|md_gamepad_outline|
|<span class="nerdfont big">&#xf0e3b;</span>|md_gamepad_right|
|<span class="nerdfont big">&#xf0e3c;</span>|md_gamepad_round|
|<span class="nerdfont big">&#xf0e3d;</span>|md_gamepad_round_down|
|<span class="nerdfont big">&#xf0e3e;</span>|md_gamepad_round_left|
|<span class="nerdfont big">&#xf0e3f;</span>|md_gamepad_round_outline|
|<span class="nerdfont big">&#xf0e40;</span>|md_gamepad_round_right|
|<span class="nerdfont big">&#xf0e41;</span>|md_gamepad_round_up|
|<span class="nerdfont big">&#xf0eb5;</span>|md_gamepad_square|
|<span class="nerdfont big">&#xf0eb6;</span>|md_gamepad_square_outline|
|<span class="nerdfont big">&#xf0e42;</span>|md_gamepad_up|
|<span class="nerdfont big">&#xf0297;</span>|md_gamepad_variant|
|<span class="nerdfont big">&#xf0eb7;</span>|md_gamepad_variant_outline|
|<span class="nerdfont big">&#xf10ee;</span>|md_gamma|
|<span class="nerdfont big">&#xf0dd1;</span>|md_gantry_crane|
|<span class="nerdfont big">&#xf06d9;</span>|md_garage|
|<span class="nerdfont big">&#xf0872;</span>|md_garage_alert|
|<span class="nerdfont big">&#xf12d5;</span>|md_garage_alert_variant|
|<span class="nerdfont big">&#xf17fb;</span>|md_garage_lock|
|<span class="nerdfont big">&#xf06da;</span>|md_garage_open|
|<span class="nerdfont big">&#xf12d4;</span>|md_garage_open_variant|
|<span class="nerdfont big">&#xf12d3;</span>|md_garage_variant|
|<span class="nerdfont big">&#xf17fc;</span>|md_garage_variant_lock|
|<span class="nerdfont big">&#xf1a1b;</span>|md_gas_burner|
|<span class="nerdfont big">&#xf0647;</span>|md_gas_cylinder|
|<span class="nerdfont big">&#xf0298;</span>|md_gas_station|
|<span class="nerdfont big">&#xf1409;</span>|md_gas_station_off|
|<span class="nerdfont big">&#xf140a;</span>|md_gas_station_off_outline|
|<span class="nerdfont big">&#xf0eb8;</span>|md_gas_station_outline|
|<span class="nerdfont big">&#xf0299;</span>|md_gate|
|<span class="nerdfont big">&#xf17f8;</span>|md_gate_alert|
|<span class="nerdfont big">&#xf08e1;</span>|md_gate_and|
|<span class="nerdfont big">&#xf17f7;</span>|md_gate_arrow_left|
|<span class="nerdfont big">&#xf1169;</span>|md_gate_arrow_right|
|<span class="nerdfont big">&#xf08e2;</span>|md_gate_nand|
|<span class="nerdfont big">&#xf08e3;</span>|md_gate_nor|
|<span class="nerdfont big">&#xf08e4;</span>|md_gate_not|
|<span class="nerdfont big">&#xf116a;</span>|md_gate_open|
|<span class="nerdfont big">&#xf08e5;</span>|md_gate_or|
|<span class="nerdfont big">&#xf08e6;</span>|md_gate_xnor|
|<span class="nerdfont big">&#xf08e7;</span>|md_gate_xor|
|<span class="nerdfont big">&#xf0e43;</span>|md_gatsby|
|<span class="nerdfont big">&#xf029a;</span>|md_gauge|
|<span class="nerdfont big">&#xf0873;</span>|md_gauge_empty|
|<span class="nerdfont big">&#xf0874;</span>|md_gauge_full|
|<span class="nerdfont big">&#xf0875;</span>|md_gauge_low|
|<span class="nerdfont big">&#xf029b;</span>|md_gavel|
|<span class="nerdfont big">&#xf029c;</span>|md_gender_female|
|<span class="nerdfont big">&#xf029d;</span>|md_gender_male|
|<span class="nerdfont big">&#xf029e;</span>|md_gender_male_female|
|<span class="nerdfont big">&#xf113f;</span>|md_gender_male_female_variant|
|<span class="nerdfont big">&#xf1140;</span>|md_gender_non_binary|
|<span class="nerdfont big">&#xf029f;</span>|md_gender_transgender|
|<span class="nerdfont big">&#xf08e8;</span>|md_gentoo|
|<span class="nerdfont big">&#xf07cb;</span>|md_gesture|
|<span class="nerdfont big">&#xf073c;</span>|md_gesture_double_tap|
|<span class="nerdfont big">&#xf0abd;</span>|md_gesture_pinch|
|<span class="nerdfont big">&#xf0abe;</span>|md_gesture_spread|
|<span class="nerdfont big">&#xf0d76;</span>|md_gesture_swipe|
|<span class="nerdfont big">&#xf073d;</span>|md_gesture_swipe_down|
|<span class="nerdfont big">&#xf0abf;</span>|md_gesture_swipe_horizontal|
|<span class="nerdfont big">&#xf073e;</span>|md_gesture_swipe_left|
|<span class="nerdfont big">&#xf073f;</span>|md_gesture_swipe_right|
|<span class="nerdfont big">&#xf0740;</span>|md_gesture_swipe_up|
|<span class="nerdfont big">&#xf0ac0;</span>|md_gesture_swipe_vertical|
|<span class="nerdfont big">&#xf0741;</span>|md_gesture_tap|
|<span class="nerdfont big">&#xf12a9;</span>|md_gesture_tap_box|
|<span class="nerdfont big">&#xf12a8;</span>|md_gesture_tap_button|
|<span class="nerdfont big">&#xf0d77;</span>|md_gesture_tap_hold|
|<span class="nerdfont big">&#xf0742;</span>|md_gesture_two_double_tap|
|<span class="nerdfont big">&#xf0743;</span>|md_gesture_two_tap|
|<span class="nerdfont big">&#xf02a0;</span>|md_ghost|
|<span class="nerdfont big">&#xf09f5;</span>|md_ghost_off|
|<span class="nerdfont big">&#xf165c;</span>|md_ghost_off_outline|
|<span class="nerdfont big">&#xf165d;</span>|md_ghost_outline|
|<span class="nerdfont big">&#xf0e44;</span>|md_gift|
|<span class="nerdfont big">&#xf16ef;</span>|md_gift_off|
|<span class="nerdfont big">&#xf16f0;</span>|md_gift_off_outline|
|<span class="nerdfont big">&#xf16f1;</span>|md_gift_open|
|<span class="nerdfont big">&#xf16f2;</span>|md_gift_open_outline|
|<span class="nerdfont big">&#xf02a1;</span>|md_gift_outline|
|<span class="nerdfont big">&#xf02a2;</span>|md_git|
|<span class="nerdfont big">&#xf02a4;</span>|md_github|
|<span class="nerdfont big">&#xf0ba0;</span>|md_gitlab|
|<span class="nerdfont big">&#xf0356;</span>|md_glass_cocktail|
|<span class="nerdfont big">&#xf15e6;</span>|md_glass_cocktail_off|
|<span class="nerdfont big">&#xf02a5;</span>|md_glass_flute|
|<span class="nerdfont big">&#xf1873;</span>|md_glass_fragile|
|<span class="nerdfont big">&#xf02a6;</span>|md_glass_mug|
|<span class="nerdfont big">&#xf15e7;</span>|md_glass_mug_off|
|<span class="nerdfont big">&#xf1116;</span>|md_glass_mug_variant|
|<span class="nerdfont big">&#xf15e8;</span>|md_glass_mug_variant_off|
|<span class="nerdfont big">&#xf130d;</span>|md_glass_pint_outline|
|<span class="nerdfont big">&#xf02a7;</span>|md_glass_stange|
|<span class="nerdfont big">&#xf02a8;</span>|md_glass_tulip|
|<span class="nerdfont big">&#xf0876;</span>|md_glass_wine|
|<span class="nerdfont big">&#xf02aa;</span>|md_glasses|
|<span class="nerdfont big">&#xf12d7;</span>|md_globe_light|
|<span class="nerdfont big">&#xf08e9;</span>|md_globe_model|
|<span class="nerdfont big">&#xf02ab;</span>|md_gmail|
|<span class="nerdfont big">&#xf02ac;</span>|md_gnome|
|<span class="nerdfont big">&#xf0d79;</span>|md_go_kart|
|<span class="nerdfont big">&#xf0d7a;</span>|md_go_kart_track|
|<span class="nerdfont big">&#xf0ba1;</span>|md_gog|
|<span class="nerdfont big">&#xf124f;</span>|md_gold|
|<span class="nerdfont big">&#xf0823;</span>|md_golf|
|<span class="nerdfont big">&#xf11a4;</span>|md_golf_cart|
|<span class="nerdfont big">&#xf1083;</span>|md_golf_tee|
|<span class="nerdfont big">&#xf0686;</span>|md_gondola|
|<span class="nerdfont big">&#xf0d7b;</span>|md_goodreads|
|<span class="nerdfont big">&#xf02ad;</span>|md_google|
|<span class="nerdfont big">&#xf0c87;</span>|md_google_ads|
|<span class="nerdfont big">&#xf07cc;</span>|md_google_analytics|
|<span class="nerdfont big">&#xf07cd;</span>|md_google_assistant|
|<span class="nerdfont big">&#xf02ae;</span>|md_google_cardboard|
|<span class="nerdfont big">&#xf02af;</span>|md_google_chrome|
|<span class="nerdfont big">&#xf02b0;</span>|md_google_circles|
|<span class="nerdfont big">&#xf02b1;</span>|md_google_circles_communities|
|<span class="nerdfont big">&#xf02b2;</span>|md_google_circles_extended|
|<span class="nerdfont big">&#xf02b3;</span>|md_google_circles_group|
|<span class="nerdfont big">&#xf02c0;</span>|md_google_classroom|
|<span class="nerdfont big">&#xf11f6;</span>|md_google_cloud|
|<span class="nerdfont big">&#xf02b4;</span>|md_google_controller|
|<span class="nerdfont big">&#xf02b5;</span>|md_google_controller_off|
|<span class="nerdfont big">&#xf1362;</span>|md_google_downasaur|
|<span class="nerdfont big">&#xf02b6;</span>|md_google_drive|
|<span class="nerdfont big">&#xf02b7;</span>|md_google_earth|
|<span class="nerdfont big">&#xf096c;</span>|md_google_fit|
|<span class="nerdfont big">&#xf02b8;</span>|md_google_glass|
|<span class="nerdfont big">&#xf02c9;</span>|md_google_hangouts|
|<span class="nerdfont big">&#xf0824;</span>|md_google_home|
|<span class="nerdfont big">&#xf06dc;</span>|md_google_keep|
|<span class="nerdfont big">&#xf09f6;</span>|md_google_lens|
|<span class="nerdfont big">&#xf05f5;</span>|md_google_maps|
|<span class="nerdfont big">&#xf1048;</span>|md_google_my_business|
|<span class="nerdfont big">&#xf02b9;</span>|md_google_nearby|
|<span class="nerdfont big">&#xf02bc;</span>|md_google_play|
|<span class="nerdfont big">&#xf02bd;</span>|md_google_plus|
|<span class="nerdfont big">&#xf0eb9;</span>|md_google_podcast|
|<span class="nerdfont big">&#xf09f7;</span>|md_google_spreadsheet|
|<span class="nerdfont big">&#xf0c88;</span>|md_google_street_view|
|<span class="nerdfont big">&#xf02bf;</span>|md_google_translate|
|<span class="nerdfont big">&#xf174a;</span>|md_gradient_horizontal|
|<span class="nerdfont big">&#xf06a0;</span>|md_gradient_vertical|
|<span class="nerdfont big">&#xf0d7c;</span>|md_grain|
|<span class="nerdfont big">&#xf1049;</span>|md_graph|
|<span class="nerdfont big">&#xf104a;</span>|md_graph_outline|
|<span class="nerdfont big">&#xf0877;</span>|md_graphql|
|<span class="nerdfont big">&#xf1510;</span>|md_grass|
|<span class="nerdfont big">&#xf0ba2;</span>|md_grave_stone|
|<span class="nerdfont big">&#xf0648;</span>|md_grease_pencil|
|<span class="nerdfont big">&#xf096d;</span>|md_greater_than|
|<span class="nerdfont big">&#xf096e;</span>|md_greater_than_or_equal|
|<span class="nerdfont big">&#xf002d;</span>|md_greenhouse|
|<span class="nerdfont big">&#xf02c1;</span>|md_grid|
|<span class="nerdfont big">&#xf0758;</span>|md_grid_large|
|<span class="nerdfont big">&#xf02c2;</span>|md_grid_off|
|<span class="nerdfont big">&#xf0e45;</span>|md_grill|
|<span class="nerdfont big">&#xf118a;</span>|md_grill_outline|
|<span class="nerdfont big">&#xf02c3;</span>|md_group|
|<span class="nerdfont big">&#xf0771;</span>|md_guitar_acoustic|
|<span class="nerdfont big">&#xf02c4;</span>|md_guitar_electric|
|<span class="nerdfont big">&#xf02c5;</span>|md_guitar_pick|
|<span class="nerdfont big">&#xf02c6;</span>|md_guitar_pick_outline|
|<span class="nerdfont big">&#xf0825;</span>|md_guy_fawkes_mask|
|<span class="nerdfont big">&#xf1a41;</span>|md_gymnastics|
|<span class="nerdfont big">&#xf0ac1;</span>|md_hail|
|<span class="nerdfont big">&#xf10ef;</span>|md_hair_dryer|
|<span class="nerdfont big">&#xf10f0;</span>|md_hair_dryer_outline|
|<span class="nerdfont big">&#xf0ba3;</span>|md_halloween|
|<span class="nerdfont big">&#xf0685;</span>|md_hamburger|
|<span class="nerdfont big">&#xf1776;</span>|md_hamburger_check|
|<span class="nerdfont big">&#xf1777;</span>|md_hamburger_minus|
|<span class="nerdfont big">&#xf1778;</span>|md_hamburger_off|
|<span class="nerdfont big">&#xf1779;</span>|md_hamburger_plus|
|<span class="nerdfont big">&#xf177a;</span>|md_hamburger_remove|
|<span class="nerdfont big">&#xf08ea;</span>|md_hammer|
|<span class="nerdfont big">&#xf1322;</span>|md_hammer_screwdriver|
|<span class="nerdfont big">&#xf1887;</span>|md_hammer_sickle|
|<span class="nerdfont big">&#xf1323;</span>|md_hammer_wrench|
|<span class="nerdfont big">&#xf0e46;</span>|md_hand_back_left|
|<span class="nerdfont big">&#xf1830;</span>|md_hand_back_left_off|
|<span class="nerdfont big">&#xf1832;</span>|md_hand_back_left_off_outline|
|<span class="nerdfont big">&#xf182c;</span>|md_hand_back_left_outline|
|<span class="nerdfont big">&#xf0e47;</span>|md_hand_back_right|
|<span class="nerdfont big">&#xf1831;</span>|md_hand_back_right_off|
|<span class="nerdfont big">&#xf1833;</span>|md_hand_back_right_off_outline|
|<span class="nerdfont big">&#xf182d;</span>|md_hand_back_right_outline|
|<span class="nerdfont big">&#xf194b;</span>|md_hand_clap|
|<span class="nerdfont big">&#xf1a42;</span>|md_hand_clap_off|
|<span class="nerdfont big">&#xf188f;</span>|md_hand_coin|
|<span class="nerdfont big">&#xf1890;</span>|md_hand_coin_outline|
|<span class="nerdfont big">&#xf18b6;</span>|md_hand_extended|
|<span class="nerdfont big">&#xf18b7;</span>|md_hand_extended_outline|
|<span class="nerdfont big">&#xf182b;</span>|md_hand_front_left|
|<span class="nerdfont big">&#xf182e;</span>|md_hand_front_left_outline|
|<span class="nerdfont big">&#xf0a4f;</span>|md_hand_front_right|
|<span class="nerdfont big">&#xf182f;</span>|md_hand_front_right_outline|
|<span class="nerdfont big">&#xf10f1;</span>|md_hand_heart|
|<span class="nerdfont big">&#xf157e;</span>|md_hand_heart_outline|
|<span class="nerdfont big">&#xf0a50;</span>|md_hand_okay|
|<span class="nerdfont big">&#xf0a51;</span>|md_hand_peace|
|<span class="nerdfont big">&#xf0a52;</span>|md_hand_peace_variant|
|<span class="nerdfont big">&#xf0a53;</span>|md_hand_pointing_down|
|<span class="nerdfont big">&#xf0a54;</span>|md_hand_pointing_left|
|<span class="nerdfont big">&#xf02c7;</span>|md_hand_pointing_right|
|<span class="nerdfont big">&#xf0a55;</span>|md_hand_pointing_up|
|<span class="nerdfont big">&#xf0e48;</span>|md_hand_saw|
|<span class="nerdfont big">&#xf157f;</span>|md_hand_wash|
|<span class="nerdfont big">&#xf1580;</span>|md_hand_wash_outline|
|<span class="nerdfont big">&#xf139f;</span>|md_hand_water|
|<span class="nerdfont big">&#xf1821;</span>|md_hand_wave|
|<span class="nerdfont big">&#xf1822;</span>|md_hand_wave_outline|
|<span class="nerdfont big">&#xf0f53;</span>|md_handball|
|<span class="nerdfont big">&#xf113e;</span>|md_handcuffs|
|<span class="nerdfont big">&#xf0579;</span>|md_hands_pray|
|<span class="nerdfont big">&#xf1218;</span>|md_handshake|
|<span class="nerdfont big">&#xf15a1;</span>|md_handshake_outline|
|<span class="nerdfont big">&#xf02c8;</span>|md_hanger|
|<span class="nerdfont big">&#xf096f;</span>|md_hard_hat|
|<span class="nerdfont big">&#xf02ca;</span>|md_harddisk|
|<span class="nerdfont big">&#xf104b;</span>|md_harddisk_plus|
|<span class="nerdfont big">&#xf104c;</span>|md_harddisk_remove|
|<span class="nerdfont big">&#xf0ba4;</span>|md_hat_fedora|
|<span class="nerdfont big">&#xf0c89;</span>|md_hazard_lights|
|<span class="nerdfont big">&#xf0d7d;</span>|md_hdr|
|<span class="nerdfont big">&#xf0d7e;</span>|md_hdr_off|
|<span class="nerdfont big">&#xf135e;</span>|md_head|
|<span class="nerdfont big">&#xf1338;</span>|md_head_alert|
|<span class="nerdfont big">&#xf1339;</span>|md_head_alert_outline|
|<span class="nerdfont big">&#xf133a;</span>|md_head_check|
|<span class="nerdfont big">&#xf133b;</span>|md_head_check_outline|
|<span class="nerdfont big">&#xf133c;</span>|md_head_cog|
|<span class="nerdfont big">&#xf133d;</span>|md_head_cog_outline|
|<span class="nerdfont big">&#xf133e;</span>|md_head_dots_horizontal|
|<span class="nerdfont big">&#xf133f;</span>|md_head_dots_horizontal_outline|
|<span class="nerdfont big">&#xf1340;</span>|md_head_flash|
|<span class="nerdfont big">&#xf1341;</span>|md_head_flash_outline|
|<span class="nerdfont big">&#xf1342;</span>|md_head_heart|
|<span class="nerdfont big">&#xf1343;</span>|md_head_heart_outline|
|<span class="nerdfont big">&#xf1344;</span>|md_head_lightbulb|
|<span class="nerdfont big">&#xf1345;</span>|md_head_lightbulb_outline|
|<span class="nerdfont big">&#xf1346;</span>|md_head_minus|
|<span class="nerdfont big">&#xf1347;</span>|md_head_minus_outline|
|<span class="nerdfont big">&#xf135f;</span>|md_head_outline|
|<span class="nerdfont big">&#xf1348;</span>|md_head_plus|
|<span class="nerdfont big">&#xf1349;</span>|md_head_plus_outline|
|<span class="nerdfont big">&#xf134a;</span>|md_head_question|
|<span class="nerdfont big">&#xf134b;</span>|md_head_question_outline|
|<span class="nerdfont big">&#xf134c;</span>|md_head_remove|
|<span class="nerdfont big">&#xf134d;</span>|md_head_remove_outline|
|<span class="nerdfont big">&#xf134e;</span>|md_head_snowflake|
|<span class="nerdfont big">&#xf134f;</span>|md_head_snowflake_outline|
|<span class="nerdfont big">&#xf1350;</span>|md_head_sync|
|<span class="nerdfont big">&#xf1351;</span>|md_head_sync_outline|
|<span class="nerdfont big">&#xf02cb;</span>|md_headphones|
|<span class="nerdfont big">&#xf0970;</span>|md_headphones_bluetooth|
|<span class="nerdfont big">&#xf02cc;</span>|md_headphones_box|
|<span class="nerdfont big">&#xf07ce;</span>|md_headphones_off|
|<span class="nerdfont big">&#xf02cd;</span>|md_headphones_settings|
|<span class="nerdfont big">&#xf02ce;</span>|md_headset|
|<span class="nerdfont big">&#xf02cf;</span>|md_headset_dock|
|<span class="nerdfont big">&#xf02d0;</span>|md_headset_off|
|<span class="nerdfont big">&#xf08d0;</span>|md_heart|
|<span class="nerdfont big">&#xf08d0;</span>|md_heart|
|<span class="nerdfont big">&#xf02d2;</span>|md_heart_box|
|<span class="nerdfont big">&#xf02d3;</span>|md_heart_box_outline|
|<span class="nerdfont big">&#xf02d4;</span>|md_heart_broken|
|<span class="nerdfont big">&#xf0d14;</span>|md_heart_broken_outline|
|<span class="nerdfont big">&#xf0971;</span>|md_heart_circle|
|<span class="nerdfont big">&#xf0972;</span>|md_heart_circle_outline|
|<span class="nerdfont big">&#xf1663;</span>|md_heart_cog|
|<span class="nerdfont big">&#xf1664;</span>|md_heart_cog_outline|
|<span class="nerdfont big">&#xf0ef9;</span>|md_heart_flash|
|<span class="nerdfont big">&#xf06df;</span>|md_heart_half|
|<span class="nerdfont big">&#xf06de;</span>|md_heart_half_full|
|<span class="nerdfont big">&#xf06e0;</span>|md_heart_half_outline|
|<span class="nerdfont big">&#xf142f;</span>|md_heart_minus|
|<span class="nerdfont big">&#xf1432;</span>|md_heart_minus_outline|
|<span class="nerdfont big">&#xf0a56;</span>|md_heart_multiple|
|<span class="nerdfont big">&#xf0a57;</span>|md_heart_multiple_outline|
|<span class="nerdfont big">&#xf0759;</span>|md_heart_off|
|<span class="nerdfont big">&#xf1434;</span>|md_heart_off_outline|
|<span class="nerdfont big">&#xf18a0;</span>|md_heart_outline|
|<span class="nerdfont big">&#xf18a0;</span>|md_heart_outline|
|<span class="nerdfont big">&#xf142e;</span>|md_heart_plus|
|<span class="nerdfont big">&#xf1431;</span>|md_heart_plus_outline|
|<span class="nerdfont big">&#xf05f6;</span>|md_heart_pulse|
|<span class="nerdfont big">&#xf1430;</span>|md_heart_remove|
|<span class="nerdfont big">&#xf1433;</span>|md_heart_remove_outline|
|<span class="nerdfont big">&#xf1665;</span>|md_heart_settings|
|<span class="nerdfont big">&#xf1666;</span>|md_heart_settings_outline|
|<span class="nerdfont big">&#xf1a43;</span>|md_heat_pump|
|<span class="nerdfont big">&#xf1a44;</span>|md_heat_pump_outline|
|<span class="nerdfont big">&#xf1a45;</span>|md_heat_wave|
|<span class="nerdfont big">&#xf1aaf;</span>|md_heating_coil|
|<span class="nerdfont big">&#xf0ac2;</span>|md_helicopter|
|<span class="nerdfont big">&#xf02d6;</span>|md_help|
|<span class="nerdfont big">&#xf078b;</span>|md_help_box|
|<span class="nerdfont big">&#xf02d7;</span>|md_help_circle|
|<span class="nerdfont big">&#xf0625;</span>|md_help_circle_outline|
|<span class="nerdfont big">&#xf06f5;</span>|md_help_network|
|<span class="nerdfont big">&#xf0c8a;</span>|md_help_network_outline|
|<span class="nerdfont big">&#xf0ba5;</span>|md_help_rhombus|
|<span class="nerdfont big">&#xf0ba6;</span>|md_help_rhombus_outline|
|<span class="nerdfont big">&#xf12a7;</span>|md_hexadecimal|
|<span class="nerdfont big">&#xf02d8;</span>|md_hexagon|
|<span class="nerdfont big">&#xf06e1;</span>|md_hexagon_multiple|
|<span class="nerdfont big">&#xf10f2;</span>|md_hexagon_multiple_outline|
|<span class="nerdfont big">&#xf02d9;</span>|md_hexagon_outline|
|<span class="nerdfont big">&#xf0ac3;</span>|md_hexagon_slice_1|
|<span class="nerdfont big">&#xf0ac4;</span>|md_hexagon_slice_2|
|<span class="nerdfont big">&#xf0ac5;</span>|md_hexagon_slice_3|
|<span class="nerdfont big">&#xf0ac6;</span>|md_hexagon_slice_4|
|<span class="nerdfont big">&#xf0ac7;</span>|md_hexagon_slice_5|
|<span class="nerdfont big">&#xf0ac8;</span>|md_hexagon_slice_6|
|<span class="nerdfont big">&#xf0ac9;</span>|md_hexagram|
|<span class="nerdfont big">&#xf0aca;</span>|md_hexagram_outline|
|<span class="nerdfont big">&#xf07cf;</span>|md_high_definition|
|<span class="nerdfont big">&#xf0878;</span>|md_high_definition_box|
|<span class="nerdfont big">&#xf05f7;</span>|md_highway|
|<span class="nerdfont big">&#xf0d7f;</span>|md_hiking|
|<span class="nerdfont big">&#xf02da;</span>|md_history|
|<span class="nerdfont big">&#xf0879;</span>|md_hockey_puck|
|<span class="nerdfont big">&#xf087a;</span>|md_hockey_sticks|
|<span class="nerdfont big">&#xf02db;</span>|md_hololens|
|<span class="nerdfont big">&#xf02dc;</span>|md_home|
|<span class="nerdfont big">&#xf0826;</span>|md_home_account|
|<span class="nerdfont big">&#xf087b;</span>|md_home_alert|
|<span class="nerdfont big">&#xf15d0;</span>|md_home_alert_outline|
|<span class="nerdfont big">&#xf0eba;</span>|md_home_analytics|
|<span class="nerdfont big">&#xf07d0;</span>|md_home_assistant|
|<span class="nerdfont big">&#xf07d1;</span>|md_home_automation|
|<span class="nerdfont big">&#xf1901;</span>|md_home_battery|
|<span class="nerdfont big">&#xf1902;</span>|md_home_battery_outline|
|<span class="nerdfont big">&#xf07d2;</span>|md_home_circle|
|<span class="nerdfont big">&#xf104d;</span>|md_home_circle_outline|
|<span class="nerdfont big">&#xf0d15;</span>|md_home_city|
|<span class="nerdfont big">&#xf0d16;</span>|md_home_city_outline|
|<span class="nerdfont big">&#xf1a12;</span>|md_home_clock|
|<span class="nerdfont big">&#xf1a13;</span>|md_home_clock_outline|
|<span class="nerdfont big">&#xf1159;</span>|md_home_edit|
|<span class="nerdfont big">&#xf115a;</span>|md_home_edit_outline|
|<span class="nerdfont big">&#xf0f9b;</span>|md_home_export_outline|
|<span class="nerdfont big">&#xf0efa;</span>|md_home_flood|
|<span class="nerdfont big">&#xf0dd2;</span>|md_home_floor_0|
|<span class="nerdfont big">&#xf0d80;</span>|md_home_floor_1|
|<span class="nerdfont big">&#xf0d81;</span>|md_home_floor_2|
|<span class="nerdfont big">&#xf0d82;</span>|md_home_floor_3|
|<span class="nerdfont big">&#xf0d83;</span>|md_home_floor_a|
|<span class="nerdfont big">&#xf0d84;</span>|md_home_floor_b|
|<span class="nerdfont big">&#xf0d85;</span>|md_home_floor_g|
|<span class="nerdfont big">&#xf0d86;</span>|md_home_floor_l|
|<span class="nerdfont big">&#xf0dd3;</span>|md_home_floor_negative_1|
|<span class="nerdfont big">&#xf0dd4;</span>|md_home_group|
|<span class="nerdfont big">&#xf19c1;</span>|md_home_group_minus|
|<span class="nerdfont big">&#xf19c0;</span>|md_home_group_plus|
|<span class="nerdfont big">&#xf19c2;</span>|md_home_group_remove|
|<span class="nerdfont big">&#xf0827;</span>|md_home_heart|
|<span class="nerdfont big">&#xf0f9c;</span>|md_home_import_outline|
|<span class="nerdfont big">&#xf1251;</span>|md_home_lightbulb|
|<span class="nerdfont big">&#xf1252;</span>|md_home_lightbulb_outline|
|<span class="nerdfont big">&#xf1903;</span>|md_home_lightning_bolt|
|<span class="nerdfont big">&#xf1904;</span>|md_home_lightning_bolt_outline|
|<span class="nerdfont big">&#xf08eb;</span>|md_home_lock|
|<span class="nerdfont big">&#xf08ec;</span>|md_home_lock_open|
|<span class="nerdfont big">&#xf05f8;</span>|md_home_map_marker|
|<span class="nerdfont big">&#xf0974;</span>|md_home_minus|
|<span class="nerdfont big">&#xf13d5;</span>|md_home_minus_outline|
|<span class="nerdfont big">&#xf02dd;</span>|md_home_modern|
|<span class="nerdfont big">&#xf1a46;</span>|md_home_off|
|<span class="nerdfont big">&#xf1a47;</span>|md_home_off_outline|
|<span class="nerdfont big">&#xf06a1;</span>|md_home_outline|
|<span class="nerdfont big">&#xf0975;</span>|md_home_plus|
|<span class="nerdfont big">&#xf13d6;</span>|md_home_plus_outline|
|<span class="nerdfont big">&#xf1247;</span>|md_home_remove|
|<span class="nerdfont big">&#xf13d7;</span>|md_home_remove_outline|
|<span class="nerdfont big">&#xf112b;</span>|md_home_roof|
|<span class="nerdfont big">&#xf13b0;</span>|md_home_search|
|<span class="nerdfont big">&#xf13b1;</span>|md_home_search_outline|
|<span class="nerdfont big">&#xf1794;</span>|md_home_switch|
|<span class="nerdfont big">&#xf1795;</span>|md_home_switch_outline|
|<span class="nerdfont big">&#xf0f54;</span>|md_home_thermometer|
|<span class="nerdfont big">&#xf0f55;</span>|md_home_thermometer_outline|
|<span class="nerdfont big">&#xf02de;</span>|md_home_variant|
|<span class="nerdfont big">&#xf0ba7;</span>|md_home_variant_outline|
|<span class="nerdfont big">&#xf06e2;</span>|md_hook|
|<span class="nerdfont big">&#xf06e3;</span>|md_hook_off|
|<span class="nerdfont big">&#xf0e56;</span>|md_hoop_house|
|<span class="nerdfont big">&#xf02df;</span>|md_hops|
|<span class="nerdfont big">&#xf10f3;</span>|md_horizontal_rotate_clockwise|
|<span class="nerdfont big">&#xf10f4;</span>|md_horizontal_rotate_counterclockwise|
|<span class="nerdfont big">&#xf15bf;</span>|md_horse|
|<span class="nerdfont big">&#xf15c0;</span>|md_horse_human|
|<span class="nerdfont big">&#xf15c1;</span>|md_horse_variant|
|<span class="nerdfont big">&#xf186e;</span>|md_horse_variant_fast|
|<span class="nerdfont big">&#xf0a58;</span>|md_horseshoe|
|<span class="nerdfont big">&#xf0ff6;</span>|md_hospital|
|<span class="nerdfont big">&#xf02e0;</span>|md_hospital_box|
|<span class="nerdfont big">&#xf0ff7;</span>|md_hospital_box_outline|
|<span class="nerdfont big">&#xf02e1;</span>|md_hospital_building|
|<span class="nerdfont big">&#xf02e2;</span>|md_hospital_marker|
|<span class="nerdfont big">&#xf0828;</span>|md_hot_tub|
|<span class="nerdfont big">&#xf1478;</span>|md_hours_24|
|<span class="nerdfont big">&#xf0d17;</span>|md_hubspot|
|<span class="nerdfont big">&#xf0829;</span>|md_hulu|
|<span class="nerdfont big">&#xf02e6;</span>|md_human|
|<span class="nerdfont big">&#xf138b;</span>|md_human_baby_changing_table|
|<span class="nerdfont big">&#xf1581;</span>|md_human_cane|
|<span class="nerdfont big">&#xf159b;</span>|md_human_capacity_decrease|
|<span class="nerdfont big">&#xf159c;</span>|md_human_capacity_increase|
|<span class="nerdfont big">&#xf02e7;</span>|md_human_child|
|<span class="nerdfont big">&#xf1980;</span>|md_human_dolly|
|<span class="nerdfont big">&#xf14e8;</span>|md_human_edit|
|<span class="nerdfont big">&#xf0649;</span>|md_human_female|
|<span class="nerdfont big">&#xf0a59;</span>|md_human_female_boy|
|<span class="nerdfont big">&#xf15c9;</span>|md_human_female_dance|
|<span class="nerdfont big">&#xf0a5a;</span>|md_human_female_female|
|<span class="nerdfont big">&#xf0a5b;</span>|md_human_female_girl|
|<span class="nerdfont big">&#xf17c4;</span>|md_human_greeting|
|<span class="nerdfont big">&#xf159d;</span>|md_human_greeting_proximity|
|<span class="nerdfont big">&#xf064a;</span>|md_human_greeting_variant|
|<span class="nerdfont big">&#xf064b;</span>|md_human_handsdown|
|<span class="nerdfont big">&#xf064c;</span>|md_human_handsup|
|<span class="nerdfont big">&#xf064d;</span>|md_human_male|
|<span class="nerdfont big">&#xf0890;</span>|md_human_male_board|
|<span class="nerdfont big">&#xf0846;</span>|md_human_male_board_poll|
|<span class="nerdfont big">&#xf0a5c;</span>|md_human_male_boy|
|<span class="nerdfont big">&#xf138c;</span>|md_human_male_child|
|<span class="nerdfont big">&#xf02e8;</span>|md_human_male_female|
|<span class="nerdfont big">&#xf1823;</span>|md_human_male_female_child|
|<span class="nerdfont big">&#xf0a5d;</span>|md_human_male_girl|
|<span class="nerdfont big">&#xf0efb;</span>|md_human_male_height|
|<span class="nerdfont big">&#xf0efc;</span>|md_human_male_height_variant|
|<span class="nerdfont big">&#xf0a5e;</span>|md_human_male_male|
|<span class="nerdfont big">&#xf1848;</span>|md_human_non_binary|
|<span class="nerdfont big">&#xf05cf;</span>|md_human_pregnant|
|<span class="nerdfont big">&#xf1571;</span>|md_human_queue|
|<span class="nerdfont big">&#xf11e9;</span>|md_human_scooter|
|<span class="nerdfont big">&#xf138d;</span>|md_human_wheelchair|
|<span class="nerdfont big">&#xf1981;</span>|md_human_white_cane|
|<span class="nerdfont big">&#xf0744;</span>|md_humble_bundle|
|<span class="nerdfont big">&#xf1352;</span>|md_hvac|
|<span class="nerdfont big">&#xf159e;</span>|md_hvac_off|
|<span class="nerdfont big">&#xf1324;</span>|md_hydraulic_oil_level|
|<span class="nerdfont big">&#xf1325;</span>|md_hydraulic_oil_temperature|
|<span class="nerdfont big">&#xf12e5;</span>|md_hydro_power|
|<span class="nerdfont big">&#xf1894;</span>|md_hydrogen_station|
|<span class="nerdfont big">&#xf082a;</span>|md_ice_cream|
|<span class="nerdfont big">&#xf0e52;</span>|md_ice_cream_off|
|<span class="nerdfont big">&#xf0efd;</span>|md_ice_pop|
|<span class="nerdfont big">&#xf0fc0;</span>|md_id_card|
|<span class="nerdfont big">&#xf0efe;</span>|md_identifier|
|<span class="nerdfont big">&#xf1331;</span>|md_ideogram_cjk|
|<span class="nerdfont big">&#xf1332;</span>|md_ideogram_cjk_variant|
|<span class="nerdfont big">&#xf02e9;</span>|md_image|
|<span class="nerdfont big">&#xf02ea;</span>|md_image_album|
|<span class="nerdfont big">&#xf02eb;</span>|md_image_area|
|<span class="nerdfont big">&#xf02ec;</span>|md_image_area_close|
|<span class="nerdfont big">&#xf0fc1;</span>|md_image_auto_adjust|
|<span class="nerdfont big">&#xf02ed;</span>|md_image_broken|
|<span class="nerdfont big">&#xf02ee;</span>|md_image_broken_variant|
|<span class="nerdfont big">&#xf11e3;</span>|md_image_edit|
|<span class="nerdfont big">&#xf11e4;</span>|md_image_edit_outline|
|<span class="nerdfont big">&#xf02f0;</span>|md_image_filter_black_white|
|<span class="nerdfont big">&#xf02f1;</span>|md_image_filter_center_focus|
|<span class="nerdfont big">&#xf0eff;</span>|md_image_filter_center_focus_strong|
|<span class="nerdfont big">&#xf0f00;</span>|md_image_filter_center_focus_strong_outline|
|<span class="nerdfont big">&#xf02f2;</span>|md_image_filter_center_focus_weak|
|<span class="nerdfont big">&#xf02f3;</span>|md_image_filter_drama|
|<span class="nerdfont big">&#xf02f4;</span>|md_image_filter_frames|
|<span class="nerdfont big">&#xf0509;</span>|md_image_filter_hdr|
|<span class="nerdfont big">&#xf0509;</span>|md_image_filter_hdr|
|<span class="nerdfont big">&#xf02f6;</span>|md_image_filter_none|
|<span class="nerdfont big">&#xf02f7;</span>|md_image_filter_tilt_shift|
|<span class="nerdfont big">&#xf02f8;</span>|md_image_filter_vintage|
|<span class="nerdfont big">&#xf0e49;</span>|md_image_frame|
|<span class="nerdfont big">&#xf1ab0;</span>|md_image_lock|
|<span class="nerdfont big">&#xf1ab1;</span>|md_image_lock_outline|
|<span class="nerdfont big">&#xf177b;</span>|md_image_marker|
|<span class="nerdfont big">&#xf177c;</span>|md_image_marker_outline|
|<span class="nerdfont big">&#xf1419;</span>|md_image_minus|
|<span class="nerdfont big">&#xf09f8;</span>|md_image_move|
|<span class="nerdfont big">&#xf02f9;</span>|md_image_multiple|
|<span class="nerdfont big">&#xf02ef;</span>|md_image_multiple_outline|
|<span class="nerdfont big">&#xf082b;</span>|md_image_off|
|<span class="nerdfont big">&#xf11d1;</span>|md_image_off_outline|
|<span class="nerdfont big">&#xf0976;</span>|md_image_outline|
|<span class="nerdfont big">&#xf087c;</span>|md_image_plus|
|<span class="nerdfont big">&#xf19fe;</span>|md_image_refresh|
|<span class="nerdfont big">&#xf19ff;</span>|md_image_refresh_outline|
|<span class="nerdfont big">&#xf1418;</span>|md_image_remove|
|<span class="nerdfont big">&#xf0977;</span>|md_image_search|
|<span class="nerdfont big">&#xf0978;</span>|md_image_search_outline|
|<span class="nerdfont big">&#xf0c8d;</span>|md_image_size_select_actual|
|<span class="nerdfont big">&#xf0c8e;</span>|md_image_size_select_large|
|<span class="nerdfont big">&#xf0c8f;</span>|md_image_size_select_small|
|<span class="nerdfont big">&#xf1a00;</span>|md_image_sync|
|<span class="nerdfont big">&#xf1a01;</span>|md_image_sync_outline|
|<span class="nerdfont big">&#xf160d;</span>|md_image_text|
|<span class="nerdfont big">&#xf02fa;</span>|md_import|
|<span class="nerdfont big">&#xf0687;</span>|md_inbox|
|<span class="nerdfont big">&#xf02fb;</span>|md_inbox_arrow_down|
|<span class="nerdfont big">&#xf1270;</span>|md_inbox_arrow_down_outline|
|<span class="nerdfont big">&#xf03d1;</span>|md_inbox_arrow_up|
|<span class="nerdfont big">&#xf1271;</span>|md_inbox_arrow_up_outline|
|<span class="nerdfont big">&#xf1272;</span>|md_inbox_full|
|<span class="nerdfont big">&#xf1273;</span>|md_inbox_full_outline|
|<span class="nerdfont big">&#xf08b0;</span>|md_inbox_multiple|
|<span class="nerdfont big">&#xf0ba8;</span>|md_inbox_multiple_outline|
|<span class="nerdfont big">&#xf1274;</span>|md_inbox_outline|
|<span class="nerdfont big">&#xf159f;</span>|md_inbox_remove|
|<span class="nerdfont big">&#xf15a0;</span>|md_inbox_remove_outline|
|<span class="nerdfont big">&#xf05f9;</span>|md_incognito|
|<span class="nerdfont big">&#xf1421;</span>|md_incognito_circle|
|<span class="nerdfont big">&#xf1422;</span>|md_incognito_circle_off|
|<span class="nerdfont big">&#xf0075;</span>|md_incognito_off|
|<span class="nerdfont big">&#xf184c;</span>|md_induction|
|<span class="nerdfont big">&#xf06e4;</span>|md_infinity|
|<span class="nerdfont big">&#xf02fc;</span>|md_information|
|<span class="nerdfont big">&#xf178c;</span>|md_information_off|
|<span class="nerdfont big">&#xf178d;</span>|md_information_off_outline|
|<span class="nerdfont big">&#xf02fd;</span>|md_information_outline|
|<span class="nerdfont big">&#xf064e;</span>|md_information_variant|
|<span class="nerdfont big">&#xf02fe;</span>|md_instagram|
|<span class="nerdfont big">&#xf104e;</span>|md_instrument_triangle|
|<span class="nerdfont big">&#xf1913;</span>|md_integrated_circuit_chip|
|<span class="nerdfont big">&#xf0301;</span>|md_invert_colors|
|<span class="nerdfont big">&#xf0e4a;</span>|md_invert_colors_off|
|<span class="nerdfont big">&#xf12e8;</span>|md_iobroker|
|<span class="nerdfont big">&#xf0a5f;</span>|md_ip|
|<span class="nerdfont big">&#xf0a60;</span>|md_ip_network|
|<span class="nerdfont big">&#xf0c90;</span>|md_ip_network_outline|
|<span class="nerdfont big">&#xf1982;</span>|md_ip_outline|
|<span class="nerdfont big">&#xf0c91;</span>|md_ipod|
|<span class="nerdfont big">&#xf1824;</span>|md_iron|
|<span class="nerdfont big">&#xf1838;</span>|md_iron_board|
|<span class="nerdfont big">&#xf1825;</span>|md_iron_outline|
|<span class="nerdfont big">&#xf104f;</span>|md_island|
|<span class="nerdfont big">&#xf10b9;</span>|md_iv_bag|
|<span class="nerdfont big">&#xf0dd5;</span>|md_jabber|
|<span class="nerdfont big">&#xf0302;</span>|md_jeepney|
|<span class="nerdfont big">&#xf0f01;</span>|md_jellyfish|
|<span class="nerdfont big">&#xf0f02;</span>|md_jellyfish_outline|
|<span class="nerdfont big">&#xf0303;</span>|md_jira|
|<span class="nerdfont big">&#xf087d;</span>|md_jquery|
|<span class="nerdfont big">&#xf0304;</span>|md_jsfiddle|
|<span class="nerdfont big">&#xf12ff;</span>|md_jump_rope|
|<span class="nerdfont big">&#xf0d87;</span>|md_kabaddi|
|<span class="nerdfont big">&#xf1558;</span>|md_kangaroo|
|<span class="nerdfont big">&#xf082c;</span>|md_karate|
|<span class="nerdfont big">&#xf08af;</span>|md_kayaking|
|<span class="nerdfont big">&#xf0305;</span>|md_keg|
|<span class="nerdfont big">&#xf05fa;</span>|md_kettle|
|<span class="nerdfont big">&#xf1317;</span>|md_kettle_alert|
|<span class="nerdfont big">&#xf1318;</span>|md_kettle_alert_outline|
|<span class="nerdfont big">&#xf131b;</span>|md_kettle_off|
|<span class="nerdfont big">&#xf131c;</span>|md_kettle_off_outline|
|<span class="nerdfont big">&#xf0f56;</span>|md_kettle_outline|
|<span class="nerdfont big">&#xf173c;</span>|md_kettle_pour_over|
|<span class="nerdfont big">&#xf1319;</span>|md_kettle_steam|
|<span class="nerdfont big">&#xf131a;</span>|md_kettle_steam_outline|
|<span class="nerdfont big">&#xf1300;</span>|md_kettlebell|
|<span class="nerdfont big">&#xf0306;</span>|md_key|
|<span class="nerdfont big">&#xf1983;</span>|md_key_alert|
|<span class="nerdfont big">&#xf1984;</span>|md_key_alert_outline|
|<span class="nerdfont big">&#xf1312;</span>|md_key_arrow_right|
|<span class="nerdfont big">&#xf1574;</span>|md_key_chain|
|<span class="nerdfont big">&#xf1575;</span>|md_key_chain_variant|
|<span class="nerdfont big">&#xf0307;</span>|md_key_change|
|<span class="nerdfont big">&#xf119f;</span>|md_key_link|
|<span class="nerdfont big">&#xf0308;</span>|md_key_minus|
|<span class="nerdfont big">&#xf0dd6;</span>|md_key_outline|
|<span class="nerdfont big">&#xf0309;</span>|md_key_plus|
|<span class="nerdfont big">&#xf030a;</span>|md_key_remove|
|<span class="nerdfont big">&#xf119e;</span>|md_key_star|
|<span class="nerdfont big">&#xf030b;</span>|md_key_variant|
|<span class="nerdfont big">&#xf0fc2;</span>|md_key_wireless|
|<span class="nerdfont big">&#xf030c;</span>|md_keyboard|
|<span class="nerdfont big">&#xf030d;</span>|md_keyboard_backspace|
|<span class="nerdfont big">&#xf030e;</span>|md_keyboard_caps|
|<span class="nerdfont big">&#xf030f;</span>|md_keyboard_close|
|<span class="nerdfont big">&#xf12b7;</span>|md_keyboard_esc|
|<span class="nerdfont big">&#xf12ab;</span>|md_keyboard_f1|
|<span class="nerdfont big">&#xf12ac;</span>|md_keyboard_f2|
|<span class="nerdfont big">&#xf12ad;</span>|md_keyboard_f3|
|<span class="nerdfont big">&#xf12ae;</span>|md_keyboard_f4|
|<span class="nerdfont big">&#xf12af;</span>|md_keyboard_f5|
|<span class="nerdfont big">&#xf12b0;</span>|md_keyboard_f6|
|<span class="nerdfont big">&#xf12b1;</span>|md_keyboard_f7|
|<span class="nerdfont big">&#xf12b2;</span>|md_keyboard_f8|
|<span class="nerdfont big">&#xf12b3;</span>|md_keyboard_f9|
|<span class="nerdfont big">&#xf12b4;</span>|md_keyboard_f10|
|<span class="nerdfont big">&#xf12b5;</span>|md_keyboard_f11|
|<span class="nerdfont big">&#xf12b6;</span>|md_keyboard_f12|
|<span class="nerdfont big">&#xf0310;</span>|md_keyboard_off|
|<span class="nerdfont big">&#xf0e4b;</span>|md_keyboard_off_outline|
|<span class="nerdfont big">&#xf097b;</span>|md_keyboard_outline|
|<span class="nerdfont big">&#xf0311;</span>|md_keyboard_return|
|<span class="nerdfont big">&#xf09f9;</span>|md_keyboard_settings|
|<span class="nerdfont big">&#xf09fa;</span>|md_keyboard_settings_outline|
|<span class="nerdfont big">&#xf1050;</span>|md_keyboard_space|
|<span class="nerdfont big">&#xf0312;</span>|md_keyboard_tab|
|<span class="nerdfont big">&#xf0325;</span>|md_keyboard_tab_reverse|
|<span class="nerdfont big">&#xf0313;</span>|md_keyboard_variant|
|<span class="nerdfont big">&#xf10fd;</span>|md_khanda|
|<span class="nerdfont big">&#xf0745;</span>|md_kickstarter|
|<span class="nerdfont big">&#xf1985;</span>|md_kite|
|<span class="nerdfont big">&#xf1986;</span>|md_kite_outline|
|<span class="nerdfont big">&#xf1744;</span>|md_kitesurfing|
|<span class="nerdfont big">&#xf135b;</span>|md_klingon|
|<span class="nerdfont big">&#xf09fb;</span>|md_knife|
|<span class="nerdfont big">&#xf09fc;</span>|md_knife_military|
|<span class="nerdfont big">&#xf173f;</span>|md_koala|
|<span class="nerdfont big">&#xf0314;</span>|md_kodi|
|<span class="nerdfont big">&#xf10fe;</span>|md_kubernetes|
|<span class="nerdfont big">&#xf0315;</span>|md_label|
|<span class="nerdfont big">&#xf1375;</span>|md_label_multiple|
|<span class="nerdfont big">&#xf1376;</span>|md_label_multiple_outline|
|<span class="nerdfont big">&#xf0acb;</span>|md_label_off|
|<span class="nerdfont big">&#xf0acc;</span>|md_label_off_outline|
|<span class="nerdfont big">&#xf0316;</span>|md_label_outline|
|<span class="nerdfont big">&#xf12ea;</span>|md_label_percent|
|<span class="nerdfont big">&#xf12eb;</span>|md_label_percent_outline|
|<span class="nerdfont big">&#xf0acd;</span>|md_label_variant|
|<span class="nerdfont big">&#xf0ace;</span>|md_label_variant_outline|
|<span class="nerdfont big">&#xf15a2;</span>|md_ladder|
|<span class="nerdfont big">&#xf082d;</span>|md_ladybug|
|<span class="nerdfont big">&#xf0627;</span>|md_lambda|
|<span class="nerdfont big">&#xf06b5;</span>|md_lamp|
|<span class="nerdfont big">&#xf17d0;</span>|md_lamp_outline|
|<span class="nerdfont big">&#xf1576;</span>|md_lamps|
|<span class="nerdfont big">&#xf17d1;</span>|md_lamps_outline|
|<span class="nerdfont big">&#xf0317;</span>|md_lan|
|<span class="nerdfont big">&#xf12aa;</span>|md_lan_check|
|<span class="nerdfont big">&#xf0318;</span>|md_lan_connect|
|<span class="nerdfont big">&#xf0319;</span>|md_lan_disconnect|
|<span class="nerdfont big">&#xf031a;</span>|md_lan_pending|
|<span class="nerdfont big">&#xf1ab2;</span>|md_land_fields|
|<span class="nerdfont big">&#xf1ab3;</span>|md_land_plots|
|<span class="nerdfont big">&#xf1ab4;</span>|md_land_plots_circle|
|<span class="nerdfont big">&#xf1ab5;</span>|md_land_plots_circle_variant|
|<span class="nerdfont big">&#xf1ab6;</span>|md_land_rows_horizontal|
|<span class="nerdfont big">&#xf1ab7;</span>|md_land_rows_vertical|
|<span class="nerdfont big">&#xf1a48;</span>|md_landslide|
|<span class="nerdfont big">&#xf1a49;</span>|md_landslide_outline|
|<span class="nerdfont big">&#xf0671;</span>|md_language_c|
|<span class="nerdfont big">&#xf0672;</span>|md_language_cpp|
|<span class="nerdfont big">&#xf031b;</span>|md_language_csharp|
|<span class="nerdfont big">&#xf031c;</span>|md_language_css3|
|<span class="nerdfont big">&#xf121a;</span>|md_language_fortran|
|<span class="nerdfont big">&#xf07d3;</span>|md_language_go|
|<span class="nerdfont big">&#xf0c92;</span>|md_language_haskell|
|<span class="nerdfont big">&#xf031d;</span>|md_language_html5|
|<span class="nerdfont big">&#xf0b37;</span>|md_language_java|
|<span class="nerdfont big">&#xf031e;</span>|md_language_javascript|
|<span class="nerdfont big">&#xf1219;</span>|md_language_kotlin|
|<span class="nerdfont big">&#xf08b1;</span>|md_language_lua|
|<span class="nerdfont big">&#xf0354;</span>|md_language_markdown|
|<span class="nerdfont big">&#xf0f5b;</span>|md_language_markdown_outline|
|<span class="nerdfont big">&#xf031f;</span>|md_language_php|
|<span class="nerdfont big">&#xf0320;</span>|md_language_python|
|<span class="nerdfont big">&#xf07d4;</span>|md_language_r|
|<span class="nerdfont big">&#xf0d2d;</span>|md_language_ruby|
|<span class="nerdfont big">&#xf0acf;</span>|md_language_ruby_on_rails|
|<span class="nerdfont big">&#xf1617;</span>|md_language_rust|
|<span class="nerdfont big">&#xf06e5;</span>|md_language_swift|
|<span class="nerdfont big">&#xf06e6;</span>|md_language_typescript|
|<span class="nerdfont big">&#xf0673;</span>|md_language_xaml|
|<span class="nerdfont big">&#xf0322;</span>|md_laptop|
|<span class="nerdfont big">&#xf1a4a;</span>|md_laptop_account|
|<span class="nerdfont big">&#xf06e7;</span>|md_laptop_off|
|<span class="nerdfont big">&#xf0ad0;</span>|md_laravel|
|<span class="nerdfont big">&#xf1484;</span>|md_laser_pointer|
|<span class="nerdfont big">&#xf0f03;</span>|md_lasso|
|<span class="nerdfont big">&#xf0446;</span>|md_lastpass|
|<span class="nerdfont big">&#xf0f57;</span>|md_latitude|
|<span class="nerdfont big">&#xf0327;</span>|md_launch|
|<span class="nerdfont big">&#xf07d5;</span>|md_lava_lamp|
|<span class="nerdfont big">&#xf0328;</span>|md_layers|
|<span class="nerdfont big">&#xf1892;</span>|md_layers_edit|
|<span class="nerdfont big">&#xf0e4c;</span>|md_layers_minus|
|<span class="nerdfont big">&#xf0329;</span>|md_layers_off|
|<span class="nerdfont big">&#xf09fd;</span>|md_layers_off_outline|
|<span class="nerdfont big">&#xf09fe;</span>|md_layers_outline|
|<span class="nerdfont big">&#xf0e4d;</span>|md_layers_plus|
|<span class="nerdfont big">&#xf0e4e;</span>|md_layers_remove|
|<span class="nerdfont big">&#xf1206;</span>|md_layers_search|
|<span class="nerdfont big">&#xf1207;</span>|md_layers_search_outline|
|<span class="nerdfont big">&#xf0f58;</span>|md_layers_triple|
|<span class="nerdfont big">&#xf0f59;</span>|md_layers_triple_outline|
|<span class="nerdfont big">&#xf064f;</span>|md_lead_pencil|
|<span class="nerdfont big">&#xf032a;</span>|md_leaf|
|<span class="nerdfont big">&#xf1905;</span>|md_leaf_circle|
|<span class="nerdfont big">&#xf1906;</span>|md_leaf_circle_outline|
|<span class="nerdfont big">&#xf0c93;</span>|md_leaf_maple|
|<span class="nerdfont big">&#xf12da;</span>|md_leaf_maple_off|
|<span class="nerdfont big">&#xf12d9;</span>|md_leaf_off|
|<span class="nerdfont big">&#xf0dd7;</span>|md_leak|
|<span class="nerdfont big">&#xf0dd8;</span>|md_leak_off|
|<span class="nerdfont big">&#xf1af0;</span>|md_lecturn|
|<span class="nerdfont big">&#xf032b;</span>|md_led_off|
|<span class="nerdfont big">&#xf032c;</span>|md_led_on|
|<span class="nerdfont big">&#xf032d;</span>|md_led_outline|
|<span class="nerdfont big">&#xf07d6;</span>|md_led_strip|
|<span class="nerdfont big">&#xf1051;</span>|md_led_strip_variant|
|<span class="nerdfont big">&#xf1a4b;</span>|md_led_strip_variant_off|
|<span class="nerdfont big">&#xf032e;</span>|md_led_variant_off|
|<span class="nerdfont big">&#xf032f;</span>|md_led_variant_on|
|<span class="nerdfont big">&#xf0330;</span>|md_led_variant_outline|
|<span class="nerdfont big">&#xf117d;</span>|md_leek|
|<span class="nerdfont big">&#xf097c;</span>|md_less_than|
|<span class="nerdfont big">&#xf097d;</span>|md_less_than_or_equal|
|<span class="nerdfont big">&#xf0331;</span>|md_library|
|<span class="nerdfont big">&#xf1a22;</span>|md_library_outline|
|<span class="nerdfont big">&#xf0ba9;</span>|md_library_shelves|
|<span class="nerdfont big">&#xf0fc3;</span>|md_license|
|<span class="nerdfont big">&#xf087e;</span>|md_lifebuoy|
|<span class="nerdfont big">&#xf1987;</span>|md_light_flood_down|
|<span class="nerdfont big">&#xf1988;</span>|md_light_flood_up|
|<span class="nerdfont big">&#xf179b;</span>|md_light_recessed|
|<span class="nerdfont big">&#xf097e;</span>|md_light_switch|
|<span class="nerdfont big">&#xf1a24;</span>|md_light_switch_off|
|<span class="nerdfont big">&#xf0335;</span>|md_lightbulb|
|<span class="nerdfont big">&#xf19e1;</span>|md_lightbulb_alert|
|<span class="nerdfont big">&#xf19e2;</span>|md_lightbulb_alert_outline|
|<span class="nerdfont big">&#xf1800;</span>|md_lightbulb_auto|
|<span class="nerdfont big">&#xf1801;</span>|md_lightbulb_auto_outline|
|<span class="nerdfont big">&#xf1208;</span>|md_lightbulb_cfl|
|<span class="nerdfont big">&#xf1209;</span>|md_lightbulb_cfl_off|
|<span class="nerdfont big">&#xf1275;</span>|md_lightbulb_cfl_spiral|
|<span class="nerdfont big">&#xf12c3;</span>|md_lightbulb_cfl_spiral_off|
|<span class="nerdfont big">&#xf1804;</span>|md_lightbulb_fluorescent_tube|
|<span class="nerdfont big">&#xf1805;</span>|md_lightbulb_fluorescent_tube_outline|
|<span class="nerdfont big">&#xf1253;</span>|md_lightbulb_group|
|<span class="nerdfont big">&#xf12cd;</span>|md_lightbulb_group_off|
|<span class="nerdfont big">&#xf12ce;</span>|md_lightbulb_group_off_outline|
|<span class="nerdfont big">&#xf1254;</span>|md_lightbulb_group_outline|
|<span class="nerdfont big">&#xf1255;</span>|md_lightbulb_multiple|
|<span class="nerdfont big">&#xf12cf;</span>|md_lightbulb_multiple_off|
|<span class="nerdfont big">&#xf12d0;</span>|md_lightbulb_multiple_off_outline|
|<span class="nerdfont big">&#xf1256;</span>|md_lightbulb_multiple_outline|
|<span class="nerdfont big">&#xf1a4c;</span>|md_lightbulb_night|
|<span class="nerdfont big">&#xf1a4d;</span>|md_lightbulb_night_outline|
|<span class="nerdfont big">&#xf0e4f;</span>|md_lightbulb_off|
|<span class="nerdfont big">&#xf0e50;</span>|md_lightbulb_off_outline|
|<span class="nerdfont big">&#xf06e8;</span>|md_lightbulb_on|
|<span class="nerdfont big">&#xf1a4e;</span>|md_lightbulb_on_10|
|<span class="nerdfont big">&#xf1a4f;</span>|md_lightbulb_on_20|
|<span class="nerdfont big">&#xf1a50;</span>|md_lightbulb_on_30|
|<span class="nerdfont big">&#xf1a51;</span>|md_lightbulb_on_40|
|<span class="nerdfont big">&#xf1a52;</span>|md_lightbulb_on_50|
|<span class="nerdfont big">&#xf1a53;</span>|md_lightbulb_on_60|
|<span class="nerdfont big">&#xf1a54;</span>|md_lightbulb_on_70|
|<span class="nerdfont big">&#xf1a55;</span>|md_lightbulb_on_80|
|<span class="nerdfont big">&#xf1a56;</span>|md_lightbulb_on_90|
|<span class="nerdfont big">&#xf06e9;</span>|md_lightbulb_on_outline|
|<span class="nerdfont big">&#xf0336;</span>|md_lightbulb_outline|
|<span class="nerdfont big">&#xf19e3;</span>|md_lightbulb_question|
|<span class="nerdfont big">&#xf19e4;</span>|md_lightbulb_question_outline|
|<span class="nerdfont big">&#xf17f4;</span>|md_lightbulb_spot|
|<span class="nerdfont big">&#xf17f5;</span>|md_lightbulb_spot_off|
|<span class="nerdfont big">&#xf1802;</span>|md_lightbulb_variant|
|<span class="nerdfont big">&#xf1803;</span>|md_lightbulb_variant_outline|
|<span class="nerdfont big">&#xf09ff;</span>|md_lighthouse|
|<span class="nerdfont big">&#xf0a00;</span>|md_lighthouse_on|
|<span class="nerdfont big">&#xf140b;</span>|md_lightning_bolt|
|<span class="nerdfont big">&#xf0820;</span>|md_lightning_bolt_circle|
|<span class="nerdfont big">&#xf140c;</span>|md_lightning_bolt_outline|
|<span class="nerdfont big">&#xf0624;</span>|md_line_scan|
|<span class="nerdfont big">&#xf1476;</span>|md_lingerie|
|<span class="nerdfont big">&#xf0337;</span>|md_link|
|<span class="nerdfont big">&#xf0d1a;</span>|md_link_box|
|<span class="nerdfont big">&#xf0d1b;</span>|md_link_box_outline|
|<span class="nerdfont big">&#xf0d1c;</span>|md_link_box_variant|
|<span class="nerdfont big">&#xf0d1d;</span>|md_link_box_variant_outline|
|<span class="nerdfont big">&#xf10ba;</span>|md_link_lock|
|<span class="nerdfont big">&#xf0338;</span>|md_link_off|
|<span class="nerdfont big">&#xf0c94;</span>|md_link_plus|
|<span class="nerdfont big">&#xf0339;</span>|md_link_variant|
|<span class="nerdfont big">&#xf10ff;</span>|md_link_variant_minus|
|<span class="nerdfont big">&#xf033a;</span>|md_link_variant_off|
|<span class="nerdfont big">&#xf1100;</span>|md_link_variant_plus|
|<span class="nerdfont big">&#xf1101;</span>|md_link_variant_remove|
|<span class="nerdfont big">&#xf033b;</span>|md_linkedin|
|<span class="nerdfont big">&#xf033d;</span>|md_linux|
|<span class="nerdfont big">&#xf08ed;</span>|md_linux_mint|
|<span class="nerdfont big">&#xf13b5;</span>|md_lipstick|
|<span class="nerdfont big">&#xf1826;</span>|md_liquid_spot|
|<span class="nerdfont big">&#xf191e;</span>|md_liquor|
|<span class="nerdfont big">&#xf15ab;</span>|md_list_status|
|<span class="nerdfont big">&#xf0a61;</span>|md_litecoin|
|<span class="nerdfont big">&#xf0772;</span>|md_loading|
|<span class="nerdfont big">&#xf0fc4;</span>|md_location_enter|
|<span class="nerdfont big">&#xf0fc5;</span>|md_location_exit|
|<span class="nerdfont big">&#xf033e;</span>|md_lock|
|<span class="nerdfont big">&#xf08ee;</span>|md_lock_alert|
|<span class="nerdfont big">&#xf15d1;</span>|md_lock_alert_outline|
|<span class="nerdfont big">&#xf139a;</span>|md_lock_check|
|<span class="nerdfont big">&#xf16a8;</span>|md_lock_check_outline|
|<span class="nerdfont big">&#xf097f;</span>|md_lock_clock|
|<span class="nerdfont big">&#xf16a9;</span>|md_lock_minus|
|<span class="nerdfont big">&#xf16aa;</span>|md_lock_minus_outline|
|<span class="nerdfont big">&#xf1671;</span>|md_lock_off|
|<span class="nerdfont big">&#xf1672;</span>|md_lock_off_outline|
|<span class="nerdfont big">&#xf033f;</span>|md_lock_open|
|<span class="nerdfont big">&#xf139b;</span>|md_lock_open_alert|
|<span class="nerdfont big">&#xf15d2;</span>|md_lock_open_alert_outline|
|<span class="nerdfont big">&#xf139c;</span>|md_lock_open_check|
|<span class="nerdfont big">&#xf16ab;</span>|md_lock_open_check_outline|
|<span class="nerdfont big">&#xf16ac;</span>|md_lock_open_minus|
|<span class="nerdfont big">&#xf16ad;</span>|md_lock_open_minus_outline|
|<span class="nerdfont big">&#xf0340;</span>|md_lock_open_outline|
|<span class="nerdfont big">&#xf16ae;</span>|md_lock_open_plus|
|<span class="nerdfont big">&#xf16af;</span>|md_lock_open_plus_outline|
|<span class="nerdfont big">&#xf16b0;</span>|md_lock_open_remove|
|<span class="nerdfont big">&#xf16b1;</span>|md_lock_open_remove_outline|
|<span class="nerdfont big">&#xf0fc6;</span>|md_lock_open_variant|
|<span class="nerdfont big">&#xf0fc7;</span>|md_lock_open_variant_outline|
|<span class="nerdfont big">&#xf0341;</span>|md_lock_outline|
|<span class="nerdfont big">&#xf06ea;</span>|md_lock_pattern|
|<span class="nerdfont big">&#xf05fb;</span>|md_lock_plus|
|<span class="nerdfont big">&#xf16b2;</span>|md_lock_plus_outline|
|<span class="nerdfont big">&#xf08ef;</span>|md_lock_question|
|<span class="nerdfont big">&#xf16b3;</span>|md_lock_remove|
|<span class="nerdfont big">&#xf16b4;</span>|md_lock_remove_outline|
|<span class="nerdfont big">&#xf0773;</span>|md_lock_reset|
|<span class="nerdfont big">&#xf08b2;</span>|md_lock_smart|
|<span class="nerdfont big">&#xf07d7;</span>|md_locker|
|<span class="nerdfont big">&#xf07d8;</span>|md_locker_multiple|
|<span class="nerdfont big">&#xf0342;</span>|md_login|
|<span class="nerdfont big">&#xf0343;</span>|md_logout|
|<span class="nerdfont big">&#xf05fd;</span>|md_logout_variant|
|<span class="nerdfont big">&#xf0f5a;</span>|md_longitude|
|<span class="nerdfont big">&#xf0344;</span>|md_looks|
|<span class="nerdfont big">&#xf1582;</span>|md_lotion|
|<span class="nerdfont big">&#xf1583;</span>|md_lotion_outline|
|<span class="nerdfont big">&#xf1584;</span>|md_lotion_plus|
|<span class="nerdfont big">&#xf1585;</span>|md_lotion_plus_outline|
|<span class="nerdfont big">&#xf0345;</span>|md_loupe|
|<span class="nerdfont big">&#xf0346;</span>|md_lumx|
|<span class="nerdfont big">&#xf1084;</span>|md_lungs|
|<span class="nerdfont big">&#xf1843;</span>|md_mace|
|<span class="nerdfont big">&#xf0324;</span>|md_magazine_pistol|
|<span class="nerdfont big">&#xf0323;</span>|md_magazine_rifle|
|<span class="nerdfont big">&#xf1844;</span>|md_magic_staff|
|<span class="nerdfont big">&#xf0347;</span>|md_magnet|
|<span class="nerdfont big">&#xf0348;</span>|md_magnet_on|
|<span class="nerdfont big">&#xf0349;</span>|md_magnify|
|<span class="nerdfont big">&#xf0980;</span>|md_magnify_close|
|<span class="nerdfont big">&#xf1874;</span>|md_magnify_expand|
|<span class="nerdfont big">&#xf034a;</span>|md_magnify_minus|
|<span class="nerdfont big">&#xf0a62;</span>|md_magnify_minus_cursor|
|<span class="nerdfont big">&#xf06ec;</span>|md_magnify_minus_outline|
|<span class="nerdfont big">&#xf034b;</span>|md_magnify_plus|
|<span class="nerdfont big">&#xf0a63;</span>|md_magnify_plus_cursor|
|<span class="nerdfont big">&#xf06ed;</span>|md_magnify_plus_outline|
|<span class="nerdfont big">&#xf120c;</span>|md_magnify_remove_cursor|
|<span class="nerdfont big">&#xf120d;</span>|md_magnify_remove_outline|
|<span class="nerdfont big">&#xf1276;</span>|md_magnify_scan|
|<span class="nerdfont big">&#xf0ebb;</span>|md_mail|
|<span class="nerdfont big">&#xf06ee;</span>|md_mailbox|
|<span class="nerdfont big">&#xf0d88;</span>|md_mailbox_open|
|<span class="nerdfont big">&#xf0d89;</span>|md_mailbox_open_outline|
|<span class="nerdfont big">&#xf0d8a;</span>|md_mailbox_open_up|
|<span class="nerdfont big">&#xf0d8b;</span>|md_mailbox_open_up_outline|
|<span class="nerdfont big">&#xf0d8c;</span>|md_mailbox_outline|
|<span class="nerdfont big">&#xf0d8d;</span>|md_mailbox_up|
|<span class="nerdfont big">&#xf0d8e;</span>|md_mailbox_up_outline|
|<span class="nerdfont big">&#xf160a;</span>|md_manjaro|
|<span class="nerdfont big">&#xf034d;</span>|md_map|
|<span class="nerdfont big">&#xf0ebc;</span>|md_map_check|
|<span class="nerdfont big">&#xf0ebd;</span>|md_map_check_outline|
|<span class="nerdfont big">&#xf0d1e;</span>|md_map_clock|
|<span class="nerdfont big">&#xf0d1f;</span>|md_map_clock_outline|
|<span class="nerdfont big">&#xf0a01;</span>|md_map_legend|
|<span class="nerdfont big">&#xf034e;</span>|md_map_marker|
|<span class="nerdfont big">&#xf18e3;</span>|md_map_marker_account|
|<span class="nerdfont big">&#xf18e4;</span>|md_map_marker_account_outline|
|<span class="nerdfont big">&#xf0f05;</span>|md_map_marker_alert|
|<span class="nerdfont big">&#xf0f06;</span>|md_map_marker_alert_outline|
|<span class="nerdfont big">&#xf0c95;</span>|md_map_marker_check|
|<span class="nerdfont big">&#xf12fb;</span>|md_map_marker_check_outline|
|<span class="nerdfont big">&#xf034f;</span>|md_map_marker_circle|
|<span class="nerdfont big">&#xf08f0;</span>|md_map_marker_distance|
|<span class="nerdfont big">&#xf1102;</span>|md_map_marker_down|
|<span class="nerdfont big">&#xf12db;</span>|md_map_marker_left|
|<span class="nerdfont big">&#xf12dd;</span>|md_map_marker_left_outline|
|<span class="nerdfont big">&#xf0650;</span>|md_map_marker_minus|
|<span class="nerdfont big">&#xf12f9;</span>|md_map_marker_minus_outline|
|<span class="nerdfont big">&#xf0350;</span>|md_map_marker_multiple|
|<span class="nerdfont big">&#xf1277;</span>|md_map_marker_multiple_outline|
|<span class="nerdfont big">&#xf0351;</span>|md_map_marker_off|
|<span class="nerdfont big">&#xf12fd;</span>|md_map_marker_off_outline|
|<span class="nerdfont big">&#xf07d9;</span>|md_map_marker_outline|
|<span class="nerdfont big">&#xf0d20;</span>|md_map_marker_path|
|<span class="nerdfont big">&#xf0651;</span>|md_map_marker_plus|
|<span class="nerdfont big">&#xf12f8;</span>|md_map_marker_plus_outline|
|<span class="nerdfont big">&#xf0f07;</span>|md_map_marker_question|
|<span class="nerdfont big">&#xf0f08;</span>|md_map_marker_question_outline|
|<span class="nerdfont big">&#xf0352;</span>|md_map_marker_radius|
|<span class="nerdfont big">&#xf12fc;</span>|md_map_marker_radius_outline|
|<span class="nerdfont big">&#xf0f09;</span>|md_map_marker_remove|
|<span class="nerdfont big">&#xf12fa;</span>|md_map_marker_remove_outline|
|<span class="nerdfont big">&#xf0f0a;</span>|md_map_marker_remove_variant|
|<span class="nerdfont big">&#xf12dc;</span>|md_map_marker_right|
|<span class="nerdfont big">&#xf12de;</span>|md_map_marker_right_outline|
|<span class="nerdfont big">&#xf1608;</span>|md_map_marker_star|
|<span class="nerdfont big">&#xf1609;</span>|md_map_marker_star_outline|
|<span class="nerdfont big">&#xf1103;</span>|md_map_marker_up|
|<span class="nerdfont big">&#xf0981;</span>|md_map_minus|
|<span class="nerdfont big">&#xf0982;</span>|md_map_outline|
|<span class="nerdfont big">&#xf0983;</span>|md_map_plus|
|<span class="nerdfont big">&#xf0984;</span>|md_map_search|
|<span class="nerdfont big">&#xf0985;</span>|md_map_search_outline|
|<span class="nerdfont big">&#xf0baa;</span>|md_mapbox|
|<span class="nerdfont big">&#xf0353;</span>|md_margin|
|<span class="nerdfont big">&#xf0652;</span>|md_marker|
|<span class="nerdfont big">&#xf0dd9;</span>|md_marker_cancel|
|<span class="nerdfont big">&#xf0355;</span>|md_marker_check|
|<span class="nerdfont big">&#xf0ad1;</span>|md_mastodon|
|<span class="nerdfont big">&#xf0986;</span>|md_material_design|
|<span class="nerdfont big">&#xf0357;</span>|md_material_ui|
|<span class="nerdfont big">&#xf0358;</span>|md_math_compass|
|<span class="nerdfont big">&#xf0c96;</span>|md_math_cos|
|<span class="nerdfont big">&#xf0fc8;</span>|md_math_integral|
|<span class="nerdfont big">&#xf0fc9;</span>|md_math_integral_box|
|<span class="nerdfont big">&#xf1085;</span>|md_math_log|
|<span class="nerdfont big">&#xf0fca;</span>|md_math_norm|
|<span class="nerdfont big">&#xf0fcb;</span>|md_math_norm_box|
|<span class="nerdfont big">&#xf0c97;</span>|md_math_sin|
|<span class="nerdfont big">&#xf0c98;</span>|md_math_tan|
|<span class="nerdfont big">&#xf0628;</span>|md_matrix|
|<span class="nerdfont big">&#xf0987;</span>|md_medal|
|<span class="nerdfont big">&#xf1326;</span>|md_medal_outline|
|<span class="nerdfont big">&#xf06ef;</span>|md_medical_bag|
|<span class="nerdfont big">&#xf1ab8;</span>|md_medical_cotton_swab|
|<span class="nerdfont big">&#xf117b;</span>|md_meditation|
|<span class="nerdfont big">&#xf035b;</span>|md_memory|
|<span class="nerdfont big">&#xf17d4;</span>|md_menorah|
|<span class="nerdfont big">&#xf17d5;</span>|md_menorah_fire|
|<span class="nerdfont big">&#xf035c;</span>|md_menu|
|<span class="nerdfont big">&#xf035d;</span>|md_menu_down|
|<span class="nerdfont big">&#xf06b6;</span>|md_menu_down_outline|
|<span class="nerdfont big">&#xf035e;</span>|md_menu_left|
|<span class="nerdfont big">&#xf0a02;</span>|md_menu_left_outline|
|<span class="nerdfont big">&#xf0bab;</span>|md_menu_open|
|<span class="nerdfont big">&#xf035f;</span>|md_menu_right|
|<span class="nerdfont big">&#xf0a03;</span>|md_menu_right_outline|
|<span class="nerdfont big">&#xf0a64;</span>|md_menu_swap|
|<span class="nerdfont big">&#xf0a65;</span>|md_menu_swap_outline|
|<span class="nerdfont big">&#xf0360;</span>|md_menu_up|
|<span class="nerdfont big">&#xf06b7;</span>|md_menu_up_outline|
|<span class="nerdfont big">&#xf0f5c;</span>|md_merge|
|<span class="nerdfont big">&#xf0361;</span>|md_message|
|<span class="nerdfont big">&#xf0362;</span>|md_message_alert|
|<span class="nerdfont big">&#xf0a04;</span>|md_message_alert_outline|
|<span class="nerdfont big">&#xf12f2;</span>|md_message_arrow_left|
|<span class="nerdfont big">&#xf12f3;</span>|md_message_arrow_left_outline|
|<span class="nerdfont big">&#xf12f4;</span>|md_message_arrow_right|
|<span class="nerdfont big">&#xf12f5;</span>|md_message_arrow_right_outline|
|<span class="nerdfont big">&#xf1941;</span>|md_message_badge|
|<span class="nerdfont big">&#xf1942;</span>|md_message_badge_outline|
|<span class="nerdfont big">&#xf15ac;</span>|md_message_bookmark|
|<span class="nerdfont big">&#xf15ad;</span>|md_message_bookmark_outline|
|<span class="nerdfont big">&#xf06a2;</span>|md_message_bulleted|
|<span class="nerdfont big">&#xf06a3;</span>|md_message_bulleted_off|
|<span class="nerdfont big">&#xf06f1;</span>|md_message_cog|
|<span class="nerdfont big">&#xf1172;</span>|md_message_cog_outline|
|<span class="nerdfont big">&#xf0363;</span>|md_message_draw|
|<span class="nerdfont big">&#xf19cc;</span>|md_message_fast|
|<span class="nerdfont big">&#xf19cd;</span>|md_message_fast_outline|
|<span class="nerdfont big">&#xf15a9;</span>|md_message_flash|
|<span class="nerdfont big">&#xf15aa;</span>|md_message_flash_outline|
|<span class="nerdfont big">&#xf0364;</span>|md_message_image|
|<span class="nerdfont big">&#xf116c;</span>|md_message_image_outline|
|<span class="nerdfont big">&#xf0fcc;</span>|md_message_lock|
|<span class="nerdfont big">&#xf116d;</span>|md_message_lock_outline|
|<span class="nerdfont big">&#xf116e;</span>|md_message_minus|
|<span class="nerdfont big">&#xf116f;</span>|md_message_minus_outline|
|<span class="nerdfont big">&#xf164d;</span>|md_message_off|
|<span class="nerdfont big">&#xf164e;</span>|md_message_off_outline|
|<span class="nerdfont big">&#xf0365;</span>|md_message_outline|
|<span class="nerdfont big">&#xf0653;</span>|md_message_plus|
|<span class="nerdfont big">&#xf10bb;</span>|md_message_plus_outline|
|<span class="nerdfont big">&#xf0366;</span>|md_message_processing|
|<span class="nerdfont big">&#xf1170;</span>|md_message_processing_outline|
|<span class="nerdfont big">&#xf173a;</span>|md_message_question|
|<span class="nerdfont big">&#xf173b;</span>|md_message_question_outline|
|<span class="nerdfont big">&#xf0367;</span>|md_message_reply|
|<span class="nerdfont big">&#xf173d;</span>|md_message_reply_outline|
|<span class="nerdfont big">&#xf0368;</span>|md_message_reply_text|
|<span class="nerdfont big">&#xf173e;</span>|md_message_reply_text_outline|
|<span class="nerdfont big">&#xf06f0;</span>|md_message_settings|
|<span class="nerdfont big">&#xf1171;</span>|md_message_settings_outline|
|<span class="nerdfont big">&#xf069a;</span>|md_message_star|
|<span class="nerdfont big">&#xf1250;</span>|md_message_star_outline|
|<span class="nerdfont big">&#xf0369;</span>|md_message_text|
|<span class="nerdfont big">&#xf1173;</span>|md_message_text_clock|
|<span class="nerdfont big">&#xf1174;</span>|md_message_text_clock_outline|
|<span class="nerdfont big">&#xf19ce;</span>|md_message_text_fast|
|<span class="nerdfont big">&#xf19cf;</span>|md_message_text_fast_outline|
|<span class="nerdfont big">&#xf0fcd;</span>|md_message_text_lock|
|<span class="nerdfont big">&#xf1175;</span>|md_message_text_lock_outline|
|<span class="nerdfont big">&#xf036a;</span>|md_message_text_outline|
|<span class="nerdfont big">&#xf036b;</span>|md_message_video|
|<span class="nerdfont big">&#xf0629;</span>|md_meteor|
|<span class="nerdfont big">&#xf1a57;</span>|md_meter_electric|
|<span class="nerdfont big">&#xf1a58;</span>|md_meter_electric_outline|
|<span class="nerdfont big">&#xf1a59;</span>|md_meter_gas|
|<span class="nerdfont big">&#xf1a5a;</span>|md_meter_gas_outline|
|<span class="nerdfont big">&#xf07da;</span>|md_metronome|
|<span class="nerdfont big">&#xf07db;</span>|md_metronome_tick|
|<span class="nerdfont big">&#xf07dc;</span>|md_micro_sd|
|<span class="nerdfont big">&#xf036c;</span>|md_microphone|
|<span class="nerdfont big">&#xf08b3;</span>|md_microphone_minus|
|<span class="nerdfont big">&#xf036d;</span>|md_microphone_off|
|<span class="nerdfont big">&#xf036e;</span>|md_microphone_outline|
|<span class="nerdfont big">&#xf08b4;</span>|md_microphone_plus|
|<span class="nerdfont big">&#xf1989;</span>|md_microphone_question|
|<span class="nerdfont big">&#xf198a;</span>|md_microphone_question_outline|
|<span class="nerdfont big">&#xf036f;</span>|md_microphone_settings|
|<span class="nerdfont big">&#xf0370;</span>|md_microphone_variant|
|<span class="nerdfont big">&#xf0371;</span>|md_microphone_variant_off|
|<span class="nerdfont big">&#xf0654;</span>|md_microscope|
|<span class="nerdfont big">&#xf0372;</span>|md_microsoft|
|<span class="nerdfont big">&#xf138e;</span>|md_microsoft_access|
|<span class="nerdfont big">&#xf0805;</span>|md_microsoft_azure|
|<span class="nerdfont big">&#xf0fd5;</span>|md_microsoft_azure_devops|
|<span class="nerdfont big">&#xf00a4;</span>|md_microsoft_bing|
|<span class="nerdfont big">&#xf0988;</span>|md_microsoft_dynamics_365|
|<span class="nerdfont big">&#xf01e9;</span>|md_microsoft_edge|
|<span class="nerdfont big">&#xf138f;</span>|md_microsoft_excel|
|<span class="nerdfont big">&#xf0300;</span>|md_microsoft_internet_explorer|
|<span class="nerdfont big">&#xf03c6;</span>|md_microsoft_office|
|<span class="nerdfont big">&#xf03ca;</span>|md_microsoft_onedrive|
|<span class="nerdfont big">&#xf0747;</span>|md_microsoft_onenote|
|<span class="nerdfont big">&#xf0d22;</span>|md_microsoft_outlook|
|<span class="nerdfont big">&#xf1390;</span>|md_microsoft_powerpoint|
|<span class="nerdfont big">&#xf1391;</span>|md_microsoft_sharepoint|
|<span class="nerdfont big">&#xf02bb;</span>|md_microsoft_teams|
|<span class="nerdfont big">&#xf0610;</span>|md_microsoft_visual_studio|
|<span class="nerdfont big">&#xf0a1e;</span>|md_microsoft_visual_studio_code|
|<span class="nerdfont big">&#xf05b3;</span>|md_microsoft_windows|
|<span class="nerdfont big">&#xf0a21;</span>|md_microsoft_windows_classic|
|<span class="nerdfont big">&#xf1392;</span>|md_microsoft_word|
|<span class="nerdfont big">&#xf05b9;</span>|md_microsoft_xbox|
|<span class="nerdfont big">&#xf05ba;</span>|md_microsoft_xbox_controller|
|<span class="nerdfont big">&#xf074b;</span>|md_microsoft_xbox_controller_battery_alert|
|<span class="nerdfont big">&#xf0a22;</span>|md_microsoft_xbox_controller_battery_charging|
|<span class="nerdfont big">&#xf074c;</span>|md_microsoft_xbox_controller_battery_empty|
|<span class="nerdfont big">&#xf074d;</span>|md_microsoft_xbox_controller_battery_full|
|<span class="nerdfont big">&#xf074e;</span>|md_microsoft_xbox_controller_battery_low|
|<span class="nerdfont big">&#xf074f;</span>|md_microsoft_xbox_controller_battery_medium|
|<span class="nerdfont big">&#xf0750;</span>|md_microsoft_xbox_controller_battery_unknown|
|<span class="nerdfont big">&#xf0e6f;</span>|md_microsoft_xbox_controller_menu|
|<span class="nerdfont big">&#xf05bb;</span>|md_microsoft_xbox_controller_off|
|<span class="nerdfont big">&#xf0e70;</span>|md_microsoft_xbox_controller_view|
|<span class="nerdfont big">&#xf0c99;</span>|md_microwave|
|<span class="nerdfont big">&#xf1423;</span>|md_microwave_off|
|<span class="nerdfont big">&#xf0f5d;</span>|md_middleware|
|<span class="nerdfont big">&#xf0f5e;</span>|md_middleware_outline|
|<span class="nerdfont big">&#xf08f1;</span>|md_midi|
|<span class="nerdfont big">&#xf08f2;</span>|md_midi_port|
|<span class="nerdfont big">&#xf0dda;</span>|md_mine|
|<span class="nerdfont big">&#xf0373;</span>|md_minecraft|
|<span class="nerdfont big">&#xf0a05;</span>|md_mini_sd|
|<span class="nerdfont big">&#xf0a06;</span>|md_minidisc|
|<span class="nerdfont big">&#xf0374;</span>|md_minus|
|<span class="nerdfont big">&#xf0375;</span>|md_minus_box|
|<span class="nerdfont big">&#xf1141;</span>|md_minus_box_multiple|
|<span class="nerdfont big">&#xf1142;</span>|md_minus_box_multiple_outline|
|<span class="nerdfont big">&#xf06f2;</span>|md_minus_box_outline|
|<span class="nerdfont big">&#xf0376;</span>|md_minus_circle|
|<span class="nerdfont big">&#xf035a;</span>|md_minus_circle_multiple|
|<span class="nerdfont big">&#xf0ad3;</span>|md_minus_circle_multiple_outline|
|<span class="nerdfont big">&#xf1459;</span>|md_minus_circle_off|
|<span class="nerdfont big">&#xf145a;</span>|md_minus_circle_off_outline|
|<span class="nerdfont big">&#xf0377;</span>|md_minus_circle_outline|
|<span class="nerdfont big">&#xf0378;</span>|md_minus_network|
|<span class="nerdfont big">&#xf0c9a;</span>|md_minus_network_outline|
|<span class="nerdfont big">&#xf1639;</span>|md_minus_thick|
|<span class="nerdfont big">&#xf11fd;</span>|md_mirror|
|<span class="nerdfont big">&#xf179f;</span>|md_mirror_rectangle|
|<span class="nerdfont big">&#xf17a0;</span>|md_mirror_variant|
|<span class="nerdfont big">&#xf0d8f;</span>|md_mixed_martial_arts|
|<span class="nerdfont big">&#xf087f;</span>|md_mixed_reality|
|<span class="nerdfont big">&#xf0bac;</span>|md_molecule|
|<span class="nerdfont big">&#xf12fe;</span>|md_molecule_co|
|<span class="nerdfont big">&#xf07e4;</span>|md_molecule_co2|
|<span class="nerdfont big">&#xf0379;</span>|md_monitor|
|<span class="nerdfont big">&#xf1a5b;</span>|md_monitor_account|
|<span class="nerdfont big">&#xf19d0;</span>|md_monitor_arrow_down|
|<span class="nerdfont big">&#xf19d1;</span>|md_monitor_arrow_down_variant|
|<span class="nerdfont big">&#xf0989;</span>|md_monitor_cellphone|
|<span class="nerdfont big">&#xf098a;</span>|md_monitor_cellphone_star|
|<span class="nerdfont big">&#xf0a07;</span>|md_monitor_dashboard|
|<span class="nerdfont big">&#xf12c6;</span>|md_monitor_edit|
|<span class="nerdfont big">&#xf13b4;</span>|md_monitor_eye|
|<span class="nerdfont big">&#xf0ddb;</span>|md_monitor_lock|
|<span class="nerdfont big">&#xf037a;</span>|md_monitor_multiple|
|<span class="nerdfont big">&#xf0d90;</span>|md_monitor_off|
|<span class="nerdfont big">&#xf0e51;</span>|md_monitor_screenshot|
|<span class="nerdfont big">&#xf1483;</span>|md_monitor_share|
|<span class="nerdfont big">&#xf1104;</span>|md_monitor_shimmer|
|<span class="nerdfont big">&#xf1876;</span>|md_monitor_small|
|<span class="nerdfont big">&#xf0f5f;</span>|md_monitor_speaker|
|<span class="nerdfont big">&#xf0f60;</span>|md_monitor_speaker_off|
|<span class="nerdfont big">&#xf0ddc;</span>|md_monitor_star|
|<span class="nerdfont big">&#xf0f61;</span>|md_moon_first_quarter|
|<span class="nerdfont big">&#xf0f62;</span>|md_moon_full|
|<span class="nerdfont big">&#xf0f63;</span>|md_moon_last_quarter|
|<span class="nerdfont big">&#xf0f64;</span>|md_moon_new|
|<span class="nerdfont big">&#xf0f65;</span>|md_moon_waning_crescent|
|<span class="nerdfont big">&#xf0f66;</span>|md_moon_waning_gibbous|
|<span class="nerdfont big">&#xf0f67;</span>|md_moon_waxing_crescent|
|<span class="nerdfont big">&#xf0f68;</span>|md_moon_waxing_gibbous|
|<span class="nerdfont big">&#xf1086;</span>|md_moped|
|<span class="nerdfont big">&#xf15b7;</span>|md_moped_electric|
|<span class="nerdfont big">&#xf15b8;</span>|md_moped_electric_outline|
|<span class="nerdfont big">&#xf15b9;</span>|md_moped_outline|
|<span class="nerdfont big">&#xf037b;</span>|md_more|
|<span class="nerdfont big">&#xf1748;</span>|md_mortar_pestle|
|<span class="nerdfont big">&#xf03f1;</span>|md_mortar_pestle_plus|
|<span class="nerdfont big">&#xf1827;</span>|md_mosque|
|<span class="nerdfont big">&#xf1314;</span>|md_mother_heart|
|<span class="nerdfont big">&#xf0d21;</span>|md_mother_nurse|
|<span class="nerdfont big">&#xf15b2;</span>|md_motion|
|<span class="nerdfont big">&#xf15b3;</span>|md_motion_outline|
|<span class="nerdfont big">&#xf1590;</span>|md_motion_pause|
|<span class="nerdfont big">&#xf1592;</span>|md_motion_pause_outline|
|<span class="nerdfont big">&#xf158f;</span>|md_motion_play|
|<span class="nerdfont big">&#xf1591;</span>|md_motion_play_outline|
|<span class="nerdfont big">&#xf0d91;</span>|md_motion_sensor|
|<span class="nerdfont big">&#xf1435;</span>|md_motion_sensor_off|
|<span class="nerdfont big">&#xf037c;</span>|md_motorbike|
|<span class="nerdfont big">&#xf15ba;</span>|md_motorbike_electric|
|<span class="nerdfont big">&#xf037d;</span>|md_mouse|
|<span class="nerdfont big">&#xf098b;</span>|md_mouse_bluetooth|
|<span class="nerdfont big">&#xf1550;</span>|md_mouse_move_down|
|<span class="nerdfont big">&#xf1551;</span>|md_mouse_move_up|
|<span class="nerdfont big">&#xf1552;</span>|md_mouse_move_vertical|
|<span class="nerdfont big">&#xf037e;</span>|md_mouse_off|
|<span class="nerdfont big">&#xf037f;</span>|md_mouse_variant|
|<span class="nerdfont big">&#xf0380;</span>|md_mouse_variant_off|
|<span class="nerdfont big">&#xf0655;</span>|md_move_resize|
|<span class="nerdfont big">&#xf0656;</span>|md_move_resize_variant|
|<span class="nerdfont big">&#xf0381;</span>|md_movie|
|<span class="nerdfont big">&#xf16f3;</span>|md_movie_check|
|<span class="nerdfont big">&#xf16f4;</span>|md_movie_check_outline|
|<span class="nerdfont big">&#xf16f5;</span>|md_movie_cog|
|<span class="nerdfont big">&#xf16f6;</span>|md_movie_cog_outline|
|<span class="nerdfont big">&#xf1122;</span>|md_movie_edit|
|<span class="nerdfont big">&#xf1123;</span>|md_movie_edit_outline|
|<span class="nerdfont big">&#xf1124;</span>|md_movie_filter|
|<span class="nerdfont big">&#xf1125;</span>|md_movie_filter_outline|
|<span class="nerdfont big">&#xf16f7;</span>|md_movie_minus|
|<span class="nerdfont big">&#xf16f8;</span>|md_movie_minus_outline|
|<span class="nerdfont big">&#xf16f9;</span>|md_movie_off|
|<span class="nerdfont big">&#xf16fa;</span>|md_movie_off_outline|
|<span class="nerdfont big">&#xf0fce;</span>|md_movie_open|
|<span class="nerdfont big">&#xf16fb;</span>|md_movie_open_check|
|<span class="nerdfont big">&#xf16fc;</span>|md_movie_open_check_outline|
|<span class="nerdfont big">&#xf16fd;</span>|md_movie_open_cog|
|<span class="nerdfont big">&#xf16fe;</span>|md_movie_open_cog_outline|
|<span class="nerdfont big">&#xf16ff;</span>|md_movie_open_edit|
|<span class="nerdfont big">&#xf1700;</span>|md_movie_open_edit_outline|
|<span class="nerdfont big">&#xf1701;</span>|md_movie_open_minus|
|<span class="nerdfont big">&#xf1702;</span>|md_movie_open_minus_outline|
|<span class="nerdfont big">&#xf1703;</span>|md_movie_open_off|
|<span class="nerdfont big">&#xf1704;</span>|md_movie_open_off_outline|
|<span class="nerdfont big">&#xf0fcf;</span>|md_movie_open_outline|
|<span class="nerdfont big">&#xf1705;</span>|md_movie_open_play|
|<span class="nerdfont big">&#xf1706;</span>|md_movie_open_play_outline|
|<span class="nerdfont big">&#xf1707;</span>|md_movie_open_plus|
|<span class="nerdfont big">&#xf1708;</span>|md_movie_open_plus_outline|
|<span class="nerdfont big">&#xf1709;</span>|md_movie_open_remove|
|<span class="nerdfont big">&#xf170a;</span>|md_movie_open_remove_outline|
|<span class="nerdfont big">&#xf170b;</span>|md_movie_open_settings|
|<span class="nerdfont big">&#xf170c;</span>|md_movie_open_settings_outline|
|<span class="nerdfont big">&#xf170d;</span>|md_movie_open_star|
|<span class="nerdfont big">&#xf170e;</span>|md_movie_open_star_outline|
|<span class="nerdfont big">&#xf0ddd;</span>|md_movie_outline|
|<span class="nerdfont big">&#xf170f;</span>|md_movie_play|
|<span class="nerdfont big">&#xf1710;</span>|md_movie_play_outline|
|<span class="nerdfont big">&#xf1711;</span>|md_movie_plus|
|<span class="nerdfont big">&#xf1712;</span>|md_movie_plus_outline|
|<span class="nerdfont big">&#xf1713;</span>|md_movie_remove|
|<span class="nerdfont big">&#xf1714;</span>|md_movie_remove_outline|
|<span class="nerdfont big">&#xf07de;</span>|md_movie_roll|
|<span class="nerdfont big">&#xf11d2;</span>|md_movie_search|
|<span class="nerdfont big">&#xf11d3;</span>|md_movie_search_outline|
|<span class="nerdfont big">&#xf1715;</span>|md_movie_settings|
|<span class="nerdfont big">&#xf1716;</span>|md_movie_settings_outline|
|<span class="nerdfont big">&#xf1717;</span>|md_movie_star|
|<span class="nerdfont big">&#xf1718;</span>|md_movie_star_outline|
|<span class="nerdfont big">&#xf166f;</span>|md_mower|
|<span class="nerdfont big">&#xf1670;</span>|md_mower_bag|
|<span class="nerdfont big">&#xf098c;</span>|md_muffin|
|<span class="nerdfont big">&#xf1893;</span>|md_multicast|
|<span class="nerdfont big">&#xf0382;</span>|md_multiplication|
|<span class="nerdfont big">&#xf0383;</span>|md_multiplication_box|
|<span class="nerdfont big">&#xf07df;</span>|md_mushroom|
|<span class="nerdfont big">&#xf13fa;</span>|md_mushroom_off|
|<span class="nerdfont big">&#xf13fb;</span>|md_mushroom_off_outline|
|<span class="nerdfont big">&#xf07e0;</span>|md_mushroom_outline|
|<span class="nerdfont big">&#xf075a;</span>|md_music|
|<span class="nerdfont big">&#xf0f69;</span>|md_music_accidental_double_flat|
|<span class="nerdfont big">&#xf0f6a;</span>|md_music_accidental_double_sharp|
|<span class="nerdfont big">&#xf0f6b;</span>|md_music_accidental_flat|
|<span class="nerdfont big">&#xf0f6c;</span>|md_music_accidental_natural|
|<span class="nerdfont big">&#xf0f6d;</span>|md_music_accidental_sharp|
|<span class="nerdfont big">&#xf0384;</span>|md_music_box|
|<span class="nerdfont big">&#xf0333;</span>|md_music_box_multiple|
|<span class="nerdfont big">&#xf0f04;</span>|md_music_box_multiple_outline|
|<span class="nerdfont big">&#xf0385;</span>|md_music_box_outline|
|<span class="nerdfont big">&#xf0386;</span>|md_music_circle|
|<span class="nerdfont big">&#xf0ad4;</span>|md_music_circle_outline|
|<span class="nerdfont big">&#xf0f6e;</span>|md_music_clef_alto|
|<span class="nerdfont big">&#xf0f6f;</span>|md_music_clef_bass|
|<span class="nerdfont big">&#xf0f70;</span>|md_music_clef_treble|
|<span class="nerdfont big">&#xf0388;</span>|md_music_note|
|<span class="nerdfont big">&#xf0388;</span>|md_music_note|
|<span class="nerdfont big">&#xf05fe;</span>|md_music_note_bluetooth|
|<span class="nerdfont big">&#xf05ff;</span>|md_music_note_bluetooth_off|
|<span class="nerdfont big">&#xf0f71;</span>|md_music_note_eighth_dotted|
|<span class="nerdfont big">&#xf0389;</span>|md_music_note_half|
|<span class="nerdfont big">&#xf0f72;</span>|md_music_note_half_dotted|
|<span class="nerdfont big">&#xf038a;</span>|md_music_note_off|
|<span class="nerdfont big">&#xf0f73;</span>|md_music_note_off_outline|
|<span class="nerdfont big">&#xf0f74;</span>|md_music_note_outline|
|<span class="nerdfont big">&#xf0dde;</span>|md_music_note_plus|
|<span class="nerdfont big">&#xf038b;</span>|md_music_note_quarter|
|<span class="nerdfont big">&#xf0f75;</span>|md_music_note_quarter_dotted|
|<span class="nerdfont big">&#xf038c;</span>|md_music_note_sixteenth|
|<span class="nerdfont big">&#xf0f76;</span>|md_music_note_sixteenth_dotted|
|<span class="nerdfont big">&#xf038d;</span>|md_music_note_whole|
|<span class="nerdfont big">&#xf0f77;</span>|md_music_note_whole_dotted|
|<span class="nerdfont big">&#xf075b;</span>|md_music_off|
|<span class="nerdfont big">&#xf0f78;</span>|md_music_rest_eighth|
|<span class="nerdfont big">&#xf0f79;</span>|md_music_rest_half|
|<span class="nerdfont big">&#xf0f7a;</span>|md_music_rest_quarter|
|<span class="nerdfont big">&#xf0f7b;</span>|md_music_rest_sixteenth|
|<span class="nerdfont big">&#xf0f7c;</span>|md_music_rest_whole|
|<span class="nerdfont big">&#xf15de;</span>|md_mustache|
|<span class="nerdfont big">&#xf0ddf;</span>|md_nail|
|<span class="nerdfont big">&#xf08f3;</span>|md_nas|
|<span class="nerdfont big">&#xf0880;</span>|md_nativescript|
|<span class="nerdfont big">&#xf038e;</span>|md_nature|
|<span class="nerdfont big">&#xf038f;</span>|md_nature_people|
|<span class="nerdfont big">&#xf0390;</span>|md_navigation|
|<span class="nerdfont big">&#xf1607;</span>|md_navigation_outline|
|<span class="nerdfont big">&#xf18f1;</span>|md_navigation_variant_outline|
|<span class="nerdfont big">&#xf18f0;</span>|md_near_me|
|<span class="nerdfont big">&#xf18f0;</span>|md_near_me|
|<span class="nerdfont big">&#xf0f0b;</span>|md_necklace|
|<span class="nerdfont big">&#xf0391;</span>|md_needle|
|<span class="nerdfont big">&#xf19d2;</span>|md_needle_off|
|<span class="nerdfont big">&#xf0746;</span>|md_netflix|
|<span class="nerdfont big">&#xf06f3;</span>|md_network|
|<span class="nerdfont big">&#xf0c9b;</span>|md_network_off|
|<span class="nerdfont big">&#xf0c9c;</span>|md_network_off_outline|
|<span class="nerdfont big">&#xf0c9d;</span>|md_network_outline|
|<span class="nerdfont big">&#xf1acb;</span>|md_network_pos|
|<span class="nerdfont big">&#xf08f4;</span>|md_network_strength_1|
|<span class="nerdfont big">&#xf08f5;</span>|md_network_strength_1_alert|
|<span class="nerdfont big">&#xf08f6;</span>|md_network_strength_2|
|<span class="nerdfont big">&#xf08f7;</span>|md_network_strength_2_alert|
|<span class="nerdfont big">&#xf08f8;</span>|md_network_strength_3|
|<span class="nerdfont big">&#xf08f9;</span>|md_network_strength_3_alert|
|<span class="nerdfont big">&#xf08fa;</span>|md_network_strength_4|
|<span class="nerdfont big">&#xf08fb;</span>|md_network_strength_4_alert|
|<span class="nerdfont big">&#xf191a;</span>|md_network_strength_4_cog|
|<span class="nerdfont big">&#xf08fc;</span>|md_network_strength_off|
|<span class="nerdfont big">&#xf08fd;</span>|md_network_strength_off_outline|
|<span class="nerdfont big">&#xf08fe;</span>|md_network_strength_outline|
|<span class="nerdfont big">&#xf0394;</span>|md_new_box|
|<span class="nerdfont big">&#xf0395;</span>|md_newspaper|
|<span class="nerdfont big">&#xf1943;</span>|md_newspaper_check|
|<span class="nerdfont big">&#xf0f0c;</span>|md_newspaper_minus|
|<span class="nerdfont big">&#xf0f0d;</span>|md_newspaper_plus|
|<span class="nerdfont big">&#xf1944;</span>|md_newspaper_remove|
|<span class="nerdfont big">&#xf1001;</span>|md_newspaper_variant|
|<span class="nerdfont big">&#xf1002;</span>|md_newspaper_variant_multiple|
|<span class="nerdfont big">&#xf1003;</span>|md_newspaper_variant_multiple_outline|
|<span class="nerdfont big">&#xf1004;</span>|md_newspaper_variant_outline|
|<span class="nerdfont big">&#xf0396;</span>|md_nfc|
|<span class="nerdfont big">&#xf0e53;</span>|md_nfc_search_variant|
|<span class="nerdfont big">&#xf0397;</span>|md_nfc_tap|
|<span class="nerdfont big">&#xf0398;</span>|md_nfc_variant|
|<span class="nerdfont big">&#xf0e54;</span>|md_nfc_variant_off|
|<span class="nerdfont big">&#xf0774;</span>|md_ninja|
|<span class="nerdfont big">&#xf1393;</span>|md_nintendo_game_boy|
|<span class="nerdfont big">&#xf07e1;</span>|md_nintendo_switch|
|<span class="nerdfont big">&#xf05ab;</span>|md_nintendo_wii|
|<span class="nerdfont big">&#xf072d;</span>|md_nintendo_wiiu|
|<span class="nerdfont big">&#xf1105;</span>|md_nix|
|<span class="nerdfont big">&#xf0399;</span>|md_nodejs|
|<span class="nerdfont big">&#xf117e;</span>|md_noodles|
|<span class="nerdfont big">&#xf098d;</span>|md_not_equal|
|<span class="nerdfont big">&#xf098e;</span>|md_not_equal_variant|
|<span class="nerdfont big">&#xf039a;</span>|md_note|
|<span class="nerdfont big">&#xf177d;</span>|md_note_alert|
|<span class="nerdfont big">&#xf177e;</span>|md_note_alert_outline|
|<span class="nerdfont big">&#xf177f;</span>|md_note_check|
|<span class="nerdfont big">&#xf1780;</span>|md_note_check_outline|
|<span class="nerdfont big">&#xf1781;</span>|md_note_edit|
|<span class="nerdfont big">&#xf1782;</span>|md_note_edit_outline|
|<span class="nerdfont big">&#xf164f;</span>|md_note_minus|
|<span class="nerdfont big">&#xf1650;</span>|md_note_minus_outline|
|<span class="nerdfont big">&#xf06b8;</span>|md_note_multiple|
|<span class="nerdfont big">&#xf06b9;</span>|md_note_multiple_outline|
|<span class="nerdfont big">&#xf1783;</span>|md_note_off|
|<span class="nerdfont big">&#xf1784;</span>|md_note_off_outline|
|<span class="nerdfont big">&#xf039b;</span>|md_note_outline|
|<span class="nerdfont big">&#xf039c;</span>|md_note_plus|
|<span class="nerdfont big">&#xf039d;</span>|md_note_plus_outline|
|<span class="nerdfont big">&#xf1651;</span>|md_note_remove|
|<span class="nerdfont big">&#xf1652;</span>|md_note_remove_outline|
|<span class="nerdfont big">&#xf1653;</span>|md_note_search|
|<span class="nerdfont big">&#xf1654;</span>|md_note_search_outline|
|<span class="nerdfont big">&#xf039e;</span>|md_note_text|
|<span class="nerdfont big">&#xf11d7;</span>|md_note_text_outline|
|<span class="nerdfont big">&#xf082e;</span>|md_notebook|
|<span class="nerdfont big">&#xf14f5;</span>|md_notebook_check|
|<span class="nerdfont big">&#xf14f6;</span>|md_notebook_check_outline|
|<span class="nerdfont big">&#xf14e7;</span>|md_notebook_edit|
|<span class="nerdfont big">&#xf14e9;</span>|md_notebook_edit_outline|
|<span class="nerdfont big">&#xf1a0b;</span>|md_notebook_heart|
|<span class="nerdfont big">&#xf1a0c;</span>|md_notebook_heart_outline|
|<span class="nerdfont big">&#xf1610;</span>|md_notebook_minus|
|<span class="nerdfont big">&#xf1611;</span>|md_notebook_minus_outline|
|<span class="nerdfont big">&#xf0e55;</span>|md_notebook_multiple|
|<span class="nerdfont big">&#xf0ebf;</span>|md_notebook_outline|
|<span class="nerdfont big">&#xf1612;</span>|md_notebook_plus|
|<span class="nerdfont big">&#xf1613;</span>|md_notebook_plus_outline|
|<span class="nerdfont big">&#xf1614;</span>|md_notebook_remove|
|<span class="nerdfont big">&#xf1615;</span>|md_notebook_remove_outline|
|<span class="nerdfont big">&#xf039f;</span>|md_notification_clear_all|
|<span class="nerdfont big">&#xf06f7;</span>|md_npm|
|<span class="nerdfont big">&#xf06a4;</span>|md_nuke|
|<span class="nerdfont big">&#xf07e2;</span>|md_null|
|<span class="nerdfont big">&#xf03a0;</span>|md_numeric|
|<span class="nerdfont big">&#xf03a1;</span>|md_numeric_0_box|
|<span class="nerdfont big">&#xf0f0e;</span>|md_numeric_0_box_multiple|
|<span class="nerdfont big">&#xf03a2;</span>|md_numeric_0_box_multiple_outline|
|<span class="nerdfont big">&#xf03a3;</span>|md_numeric_0_box_outline|
|<span class="nerdfont big">&#xf0b3a;</span>|md_numeric_1|
|<span class="nerdfont big">&#xf03a4;</span>|md_numeric_1_box|
|<span class="nerdfont big">&#xf0f0f;</span>|md_numeric_1_box_multiple|
|<span class="nerdfont big">&#xf03a5;</span>|md_numeric_1_box_multiple_outline|
|<span class="nerdfont big">&#xf03a6;</span>|md_numeric_1_box_outline|
|<span class="nerdfont big">&#xf0ca0;</span>|md_numeric_1_circle|
|<span class="nerdfont big">&#xf0ca1;</span>|md_numeric_1_circle_outline|
|<span class="nerdfont big">&#xf0b3b;</span>|md_numeric_2|
|<span class="nerdfont big">&#xf03a7;</span>|md_numeric_2_box|
|<span class="nerdfont big">&#xf0f10;</span>|md_numeric_2_box_multiple|
|<span class="nerdfont big">&#xf03a8;</span>|md_numeric_2_box_multiple_outline|
|<span class="nerdfont big">&#xf03a9;</span>|md_numeric_2_box_outline|
|<span class="nerdfont big">&#xf0ca2;</span>|md_numeric_2_circle|
|<span class="nerdfont big">&#xf0ca3;</span>|md_numeric_2_circle_outline|
|<span class="nerdfont big">&#xf0b3c;</span>|md_numeric_3|
|<span class="nerdfont big">&#xf03aa;</span>|md_numeric_3_box|
|<span class="nerdfont big">&#xf0f11;</span>|md_numeric_3_box_multiple|
|<span class="nerdfont big">&#xf03ab;</span>|md_numeric_3_box_multiple_outline|
|<span class="nerdfont big">&#xf03ac;</span>|md_numeric_3_box_outline|
|<span class="nerdfont big">&#xf0ca4;</span>|md_numeric_3_circle|
|<span class="nerdfont big">&#xf0ca5;</span>|md_numeric_3_circle_outline|
|<span class="nerdfont big">&#xf0b3d;</span>|md_numeric_4|
|<span class="nerdfont big">&#xf03ad;</span>|md_numeric_4_box|
|<span class="nerdfont big">&#xf0f12;</span>|md_numeric_4_box_multiple|
|<span class="nerdfont big">&#xf03b2;</span>|md_numeric_4_box_multiple_outline|
|<span class="nerdfont big">&#xf03ae;</span>|md_numeric_4_box_outline|
|<span class="nerdfont big">&#xf0ca6;</span>|md_numeric_4_circle|
|<span class="nerdfont big">&#xf0ca7;</span>|md_numeric_4_circle_outline|
|<span class="nerdfont big">&#xf0b3e;</span>|md_numeric_5|
|<span class="nerdfont big">&#xf03b1;</span>|md_numeric_5_box|
|<span class="nerdfont big">&#xf0f13;</span>|md_numeric_5_box_multiple|
|<span class="nerdfont big">&#xf03af;</span>|md_numeric_5_box_multiple_outline|
|<span class="nerdfont big">&#xf03b0;</span>|md_numeric_5_box_outline|
|<span class="nerdfont big">&#xf0ca8;</span>|md_numeric_5_circle|
|<span class="nerdfont big">&#xf0ca9;</span>|md_numeric_5_circle_outline|
|<span class="nerdfont big">&#xf0b3f;</span>|md_numeric_6|
|<span class="nerdfont big">&#xf03b3;</span>|md_numeric_6_box|
|<span class="nerdfont big">&#xf0f14;</span>|md_numeric_6_box_multiple|
|<span class="nerdfont big">&#xf03b4;</span>|md_numeric_6_box_multiple_outline|
|<span class="nerdfont big">&#xf03b5;</span>|md_numeric_6_box_outline|
|<span class="nerdfont big">&#xf0caa;</span>|md_numeric_6_circle|
|<span class="nerdfont big">&#xf0cab;</span>|md_numeric_6_circle_outline|
|<span class="nerdfont big">&#xf0b40;</span>|md_numeric_7|
|<span class="nerdfont big">&#xf03b6;</span>|md_numeric_7_box|
|<span class="nerdfont big">&#xf0f15;</span>|md_numeric_7_box_multiple|
|<span class="nerdfont big">&#xf03b7;</span>|md_numeric_7_box_multiple_outline|
|<span class="nerdfont big">&#xf03b8;</span>|md_numeric_7_box_outline|
|<span class="nerdfont big">&#xf0cac;</span>|md_numeric_7_circle|
|<span class="nerdfont big">&#xf0cad;</span>|md_numeric_7_circle_outline|
|<span class="nerdfont big">&#xf0b41;</span>|md_numeric_8|
|<span class="nerdfont big">&#xf03b9;</span>|md_numeric_8_box|
|<span class="nerdfont big">&#xf0f16;</span>|md_numeric_8_box_multiple|
|<span class="nerdfont big">&#xf03ba;</span>|md_numeric_8_box_multiple_outline|
|<span class="nerdfont big">&#xf03bb;</span>|md_numeric_8_box_outline|
|<span class="nerdfont big">&#xf0cae;</span>|md_numeric_8_circle|
|<span class="nerdfont big">&#xf0caf;</span>|md_numeric_8_circle_outline|
|<span class="nerdfont big">&#xf0b42;</span>|md_numeric_9|
|<span class="nerdfont big">&#xf03bc;</span>|md_numeric_9_box|
|<span class="nerdfont big">&#xf0f17;</span>|md_numeric_9_box_multiple|
|<span class="nerdfont big">&#xf03bd;</span>|md_numeric_9_box_multiple_outline|
|<span class="nerdfont big">&#xf03be;</span>|md_numeric_9_box_outline|
|<span class="nerdfont big">&#xf0cb0;</span>|md_numeric_9_circle|
|<span class="nerdfont big">&#xf0cb1;</span>|md_numeric_9_circle_outline|
|<span class="nerdfont big">&#xf0fee;</span>|md_numeric_9_plus|
|<span class="nerdfont big">&#xf03bf;</span>|md_numeric_9_plus_box|
|<span class="nerdfont big">&#xf0f18;</span>|md_numeric_9_plus_box_multiple|
|<span class="nerdfont big">&#xf03c0;</span>|md_numeric_9_plus_box_multiple_outline|
|<span class="nerdfont big">&#xf03c1;</span>|md_numeric_9_plus_box_outline|
|<span class="nerdfont big">&#xf0cb2;</span>|md_numeric_9_plus_circle|
|<span class="nerdfont big">&#xf0cb3;</span>|md_numeric_9_plus_circle_outline|
|<span class="nerdfont big">&#xf0fe9;</span>|md_numeric_10|
|<span class="nerdfont big">&#xf0f7d;</span>|md_numeric_10_box|
|<span class="nerdfont big">&#xf0fea;</span>|md_numeric_10_box_multiple|
|<span class="nerdfont big">&#xf0feb;</span>|md_numeric_10_box_multiple_outline|
|<span class="nerdfont big">&#xf0f7e;</span>|md_numeric_10_box_outline|
|<span class="nerdfont big">&#xf0fec;</span>|md_numeric_10_circle|
|<span class="nerdfont big">&#xf0fed;</span>|md_numeric_10_circle_outline|
|<span class="nerdfont big">&#xf1052;</span>|md_numeric_negative_1|
|<span class="nerdfont big">&#xf19d3;</span>|md_numeric_off|
|<span class="nerdfont big">&#xf15cb;</span>|md_numeric_positive_1|
|<span class="nerdfont big">&#xf06f8;</span>|md_nut|
|<span class="nerdfont big">&#xf03c2;</span>|md_nutrition|
|<span class="nerdfont big">&#xf1106;</span>|md_nuxt|
|<span class="nerdfont big">&#xf067c;</span>|md_oar|
|<span class="nerdfont big">&#xf0de0;</span>|md_ocarina|
|<span class="nerdfont big">&#xf12e9;</span>|md_oci|
|<span class="nerdfont big">&#xf113a;</span>|md_ocr|
|<span class="nerdfont big">&#xf03c3;</span>|md_octagon|
|<span class="nerdfont big">&#xf03c4;</span>|md_octagon_outline|
|<span class="nerdfont big">&#xf06f9;</span>|md_octagram|
|<span class="nerdfont big">&#xf0775;</span>|md_octagram_outline|
|<span class="nerdfont big">&#xf1950;</span>|md_octahedron|
|<span class="nerdfont big">&#xf1951;</span>|md_octahedron_off|
|<span class="nerdfont big">&#xf03c5;</span>|md_odnoklassniki|
|<span class="nerdfont big">&#xf121b;</span>|md_offer|
|<span class="nerdfont big">&#xf0991;</span>|md_office_building|
|<span class="nerdfont big">&#xf1949;</span>|md_office_building_cog|
|<span class="nerdfont big">&#xf194a;</span>|md_office_building_cog_outline|
|<span class="nerdfont big">&#xf1520;</span>|md_office_building_marker|
|<span class="nerdfont big">&#xf1521;</span>|md_office_building_marker_outline|
|<span class="nerdfont big">&#xf151f;</span>|md_office_building_outline|
|<span class="nerdfont big">&#xf03c7;</span>|md_oil|
|<span class="nerdfont big">&#xf0f19;</span>|md_oil_lamp|
|<span class="nerdfont big">&#xf1053;</span>|md_oil_level|
|<span class="nerdfont big">&#xf0ff8;</span>|md_oil_temperature|
|<span class="nerdfont big">&#xf0973;</span>|md_om|
|<span class="nerdfont big">&#xf03c9;</span>|md_omega|
|<span class="nerdfont big">&#xf0bad;</span>|md_one_up|
|<span class="nerdfont big">&#xf0881;</span>|md_onepassword|
|<span class="nerdfont big">&#xf05cc;</span>|md_opacity|
|<span class="nerdfont big">&#xf03cb;</span>|md_open_in_app|
|<span class="nerdfont big">&#xf03cc;</span>|md_open_in_new|
|<span class="nerdfont big">&#xf0bae;</span>|md_open_source_initiative|
|<span class="nerdfont big">&#xf03cd;</span>|md_openid|
|<span class="nerdfont big">&#xf03ce;</span>|md_opera|
|<span class="nerdfont big">&#xf0018;</span>|md_orbit|
|<span class="nerdfont big">&#xf15db;</span>|md_orbit_variant|
|<span class="nerdfont big">&#xf020d;</span>|md_order_alphabetical_ascending|
|<span class="nerdfont big">&#xf0d07;</span>|md_order_alphabetical_descending|
|<span class="nerdfont big">&#xf02be;</span>|md_order_bool_ascending|
|<span class="nerdfont big">&#xf098f;</span>|md_order_bool_ascending_variant|
|<span class="nerdfont big">&#xf1384;</span>|md_order_bool_descending|
|<span class="nerdfont big">&#xf0990;</span>|md_order_bool_descending_variant|
|<span class="nerdfont big">&#xf0545;</span>|md_order_numeric_ascending|
|<span class="nerdfont big">&#xf0546;</span>|md_order_numeric_descending|
|<span class="nerdfont big">&#xf0b43;</span>|md_origin|
|<span class="nerdfont big">&#xf03cf;</span>|md_ornament|
|<span class="nerdfont big">&#xf03d0;</span>|md_ornament_variant|
|<span class="nerdfont big">&#xf1054;</span>|md_outdoor_lamp|
|<span class="nerdfont big">&#xf1005;</span>|md_overscan|
|<span class="nerdfont big">&#xf03d2;</span>|md_owl|
|<span class="nerdfont big">&#xf0baf;</span>|md_pac_man|
|<span class="nerdfont big">&#xf03d3;</span>|md_package|
|<span class="nerdfont big">&#xf03d4;</span>|md_package_down|
|<span class="nerdfont big">&#xf03d5;</span>|md_package_up|
|<span class="nerdfont big">&#xf03d6;</span>|md_package_variant|
|<span class="nerdfont big">&#xf03d7;</span>|md_package_variant_closed|
|<span class="nerdfont big">&#xf19d4;</span>|md_package_variant_closed_minus|
|<span class="nerdfont big">&#xf19d5;</span>|md_package_variant_closed_plus|
|<span class="nerdfont big">&#xf19d6;</span>|md_package_variant_closed_remove|
|<span class="nerdfont big">&#xf19d7;</span>|md_package_variant_minus|
|<span class="nerdfont big">&#xf19d8;</span>|md_package_variant_plus|
|<span class="nerdfont big">&#xf19d9;</span>|md_package_variant_remove|
|<span class="nerdfont big">&#xf0600;</span>|md_page_first|
|<span class="nerdfont big">&#xf0601;</span>|md_page_last|
|<span class="nerdfont big">&#xf06fa;</span>|md_page_layout_body|
|<span class="nerdfont big">&#xf06fb;</span>|md_page_layout_footer|
|<span class="nerdfont big">&#xf06fc;</span>|md_page_layout_header|
|<span class="nerdfont big">&#xf0f7f;</span>|md_page_layout_header_footer|
|<span class="nerdfont big">&#xf06fd;</span>|md_page_layout_sidebar_left|
|<span class="nerdfont big">&#xf06fe;</span>|md_page_layout_sidebar_right|
|<span class="nerdfont big">&#xf0bb0;</span>|md_page_next|
|<span class="nerdfont big">&#xf0bb1;</span>|md_page_next_outline|
|<span class="nerdfont big">&#xf0bb2;</span>|md_page_previous|
|<span class="nerdfont big">&#xf0bb3;</span>|md_page_previous_outline|
|<span class="nerdfont big">&#xf1417;</span>|md_pail|
|<span class="nerdfont big">&#xf1437;</span>|md_pail_minus|
|<span class="nerdfont big">&#xf143c;</span>|md_pail_minus_outline|
|<span class="nerdfont big">&#xf1439;</span>|md_pail_off|
|<span class="nerdfont big">&#xf143e;</span>|md_pail_off_outline|
|<span class="nerdfont big">&#xf143a;</span>|md_pail_outline|
|<span class="nerdfont big">&#xf1436;</span>|md_pail_plus|
|<span class="nerdfont big">&#xf143b;</span>|md_pail_plus_outline|
|<span class="nerdfont big">&#xf1438;</span>|md_pail_remove|
|<span class="nerdfont big">&#xf143d;</span>|md_pail_remove_outline|
|<span class="nerdfont big">&#xf03d8;</span>|md_palette|
|<span class="nerdfont big">&#xf03d9;</span>|md_palette_advanced|
|<span class="nerdfont big">&#xf0e0c;</span>|md_palette_outline|
|<span class="nerdfont big">&#xf08b5;</span>|md_palette_swatch|
|<span class="nerdfont big">&#xf135c;</span>|md_palette_swatch_outline|
|<span class="nerdfont big">&#xf195a;</span>|md_palette_swatch_variant|
|<span class="nerdfont big">&#xf1055;</span>|md_palm_tree|
|<span class="nerdfont big">&#xf0bb4;</span>|md_pan|
|<span class="nerdfont big">&#xf0bb5;</span>|md_pan_bottom_left|
|<span class="nerdfont big">&#xf0bb6;</span>|md_pan_bottom_right|
|<span class="nerdfont big">&#xf0bb7;</span>|md_pan_down|
|<span class="nerdfont big">&#xf0bb8;</span>|md_pan_horizontal|
|<span class="nerdfont big">&#xf0bb9;</span>|md_pan_left|
|<span class="nerdfont big">&#xf0bba;</span>|md_pan_right|
|<span class="nerdfont big">&#xf0bbb;</span>|md_pan_top_left|
|<span class="nerdfont big">&#xf0bbc;</span>|md_pan_top_right|
|<span class="nerdfont big">&#xf0bbd;</span>|md_pan_up|
|<span class="nerdfont big">&#xf0bbe;</span>|md_pan_vertical|
|<span class="nerdfont big">&#xf03da;</span>|md_panda|
|<span class="nerdfont big">&#xf03db;</span>|md_pandora|
|<span class="nerdfont big">&#xf03dc;</span>|md_panorama|
|<span class="nerdfont big">&#xf03dd;</span>|md_panorama_fisheye|
|<span class="nerdfont big">&#xf1928;</span>|md_panorama_horizontal|
|<span class="nerdfont big">&#xf03de;</span>|md_panorama_horizontal_outline|
|<span class="nerdfont big">&#xf198c;</span>|md_panorama_outline|
|<span class="nerdfont big">&#xf198d;</span>|md_panorama_sphere|
|<span class="nerdfont big">&#xf198e;</span>|md_panorama_sphere_outline|
|<span class="nerdfont big">&#xf198f;</span>|md_panorama_variant|
|<span class="nerdfont big">&#xf1990;</span>|md_panorama_variant_outline|
|<span class="nerdfont big">&#xf1929;</span>|md_panorama_vertical|
|<span class="nerdfont big">&#xf03df;</span>|md_panorama_vertical_outline|
|<span class="nerdfont big">&#xf195f;</span>|md_panorama_wide_angle|
|<span class="nerdfont big">&#xf03e0;</span>|md_panorama_wide_angle_outline|
|<span class="nerdfont big">&#xf03e1;</span>|md_paper_cut_vertical|
|<span class="nerdfont big">&#xf1157;</span>|md_paper_roll|
|<span class="nerdfont big">&#xf1158;</span>|md_paper_roll_outline|
|<span class="nerdfont big">&#xf03e2;</span>|md_paperclip|
|<span class="nerdfont big">&#xf1ac6;</span>|md_paperclip_check|
|<span class="nerdfont big">&#xf19da;</span>|md_paperclip_lock|
|<span class="nerdfont big">&#xf1ac7;</span>|md_paperclip_minus|
|<span class="nerdfont big">&#xf1ac8;</span>|md_paperclip_off|
|<span class="nerdfont big">&#xf1ac9;</span>|md_paperclip_plus|
|<span class="nerdfont big">&#xf1aca;</span>|md_paperclip_remove|
|<span class="nerdfont big">&#xf0cb4;</span>|md_parachute|
|<span class="nerdfont big">&#xf0cb5;</span>|md_parachute_outline|
|<span class="nerdfont big">&#xf1745;</span>|md_paragliding|
|<span class="nerdfont big">&#xf03e3;</span>|md_parking|
|<span class="nerdfont big">&#xf1056;</span>|md_party_popper|
|<span class="nerdfont big">&#xf07e3;</span>|md_passport|
|<span class="nerdfont big">&#xf0de1;</span>|md_passport_biometric|
|<span class="nerdfont big">&#xf1160;</span>|md_pasta|
|<span class="nerdfont big">&#xf0f80;</span>|md_patio_heater|
|<span class="nerdfont big">&#xf0882;</span>|md_patreon|
|<span class="nerdfont big">&#xf03e4;</span>|md_pause|
|<span class="nerdfont big">&#xf03e5;</span>|md_pause_circle|
|<span class="nerdfont big">&#xf03e6;</span>|md_pause_circle_outline|
|<span class="nerdfont big">&#xf03e7;</span>|md_pause_octagon|
|<span class="nerdfont big">&#xf03e8;</span>|md_pause_octagon_outline|
|<span class="nerdfont big">&#xf03e9;</span>|md_paw|
|<span class="nerdfont big">&#xf0657;</span>|md_paw_off|
|<span class="nerdfont big">&#xf1676;</span>|md_paw_off_outline|
|<span class="nerdfont big">&#xf1675;</span>|md_paw_outline|
|<span class="nerdfont big">&#xf0884;</span>|md_peace|
|<span class="nerdfont big">&#xf0ffc;</span>|md_peanut|
|<span class="nerdfont big">&#xf0ffd;</span>|md_peanut_off|
|<span class="nerdfont big">&#xf0fff;</span>|md_peanut_off_outline|
|<span class="nerdfont big">&#xf0ffe;</span>|md_peanut_outline|
|<span class="nerdfont big">&#xf03ea;</span>|md_pen|
|<span class="nerdfont big">&#xf0de2;</span>|md_pen_lock|
|<span class="nerdfont big">&#xf0de3;</span>|md_pen_minus|
|<span class="nerdfont big">&#xf0de4;</span>|md_pen_off|
|<span class="nerdfont big">&#xf0de5;</span>|md_pen_plus|
|<span class="nerdfont big">&#xf0de6;</span>|md_pen_remove|
|<span class="nerdfont big">&#xf03eb;</span>|md_pencil|
|<span class="nerdfont big">&#xf03ec;</span>|md_pencil_box|
|<span class="nerdfont big">&#xf1144;</span>|md_pencil_box_multiple|
|<span class="nerdfont big">&#xf1145;</span>|md_pencil_box_multiple_outline|
|<span class="nerdfont big">&#xf03ed;</span>|md_pencil_box_outline|
|<span class="nerdfont big">&#xf06ff;</span>|md_pencil_circle|
|<span class="nerdfont big">&#xf0776;</span>|md_pencil_circle_outline|
|<span class="nerdfont big">&#xf03ee;</span>|md_pencil_lock|
|<span class="nerdfont big">&#xf0de7;</span>|md_pencil_lock_outline|
|<span class="nerdfont big">&#xf0de8;</span>|md_pencil_minus|
|<span class="nerdfont big">&#xf0de9;</span>|md_pencil_minus_outline|
|<span class="nerdfont big">&#xf03ef;</span>|md_pencil_off|
|<span class="nerdfont big">&#xf0dea;</span>|md_pencil_off_outline|
|<span class="nerdfont big">&#xf0cb6;</span>|md_pencil_outline|
|<span class="nerdfont big">&#xf0deb;</span>|md_pencil_plus|
|<span class="nerdfont big">&#xf0dec;</span>|md_pencil_plus_outline|
|<span class="nerdfont big">&#xf0ded;</span>|md_pencil_remove|
|<span class="nerdfont big">&#xf0dee;</span>|md_pencil_remove_outline|
|<span class="nerdfont big">&#xf1353;</span>|md_pencil_ruler|
|<span class="nerdfont big">&#xf0ec0;</span>|md_penguin|
|<span class="nerdfont big">&#xf0701;</span>|md_pentagon|
|<span class="nerdfont big">&#xf0700;</span>|md_pentagon_outline|
|<span class="nerdfont big">&#xf1667;</span>|md_pentagram|
|<span class="nerdfont big">&#xf03f0;</span>|md_percent|
|<span class="nerdfont big">&#xf1a02;</span>|md_percent_box|
|<span class="nerdfont big">&#xf1a03;</span>|md_percent_box_outline|
|<span class="nerdfont big">&#xf1a04;</span>|md_percent_circle|
|<span class="nerdfont big">&#xf1a05;</span>|md_percent_circle_outline|
|<span class="nerdfont big">&#xf1278;</span>|md_percent_outline|
|<span class="nerdfont big">&#xf08b6;</span>|md_periodic_table|
|<span class="nerdfont big">&#xf0d23;</span>|md_perspective_less|
|<span class="nerdfont big">&#xf0d24;</span>|md_perspective_more|
|<span class="nerdfont big">&#xf17c5;</span>|md_ph|
|<span class="nerdfont big">&#xf03f2;</span>|md_phone|
|<span class="nerdfont big">&#xf0f1a;</span>|md_phone_alert|
|<span class="nerdfont big">&#xf118e;</span>|md_phone_alert_outline|
|<span class="nerdfont big">&#xf03f3;</span>|md_phone_bluetooth|
|<span class="nerdfont big">&#xf118f;</span>|md_phone_bluetooth_outline|
|<span class="nerdfont big">&#xf10bc;</span>|md_phone_cancel|
|<span class="nerdfont big">&#xf1190;</span>|md_phone_cancel_outline|
|<span class="nerdfont big">&#xf11a9;</span>|md_phone_check|
|<span class="nerdfont big">&#xf11aa;</span>|md_phone_check_outline|
|<span class="nerdfont big">&#xf0602;</span>|md_phone_classic|
|<span class="nerdfont big">&#xf1279;</span>|md_phone_classic_off|
|<span class="nerdfont big">&#xf19db;</span>|md_phone_clock|
|<span class="nerdfont big">&#xf1559;</span>|md_phone_dial|
|<span class="nerdfont big">&#xf155a;</span>|md_phone_dial_outline|
|<span class="nerdfont big">&#xf03f4;</span>|md_phone_forward|
|<span class="nerdfont big">&#xf1191;</span>|md_phone_forward_outline|
|<span class="nerdfont big">&#xf03f5;</span>|md_phone_hangup|
|<span class="nerdfont big">&#xf1192;</span>|md_phone_hangup_outline|
|<span class="nerdfont big">&#xf03f6;</span>|md_phone_in_talk|
|<span class="nerdfont big">&#xf1182;</span>|md_phone_in_talk_outline|
|<span class="nerdfont big">&#xf03f7;</span>|md_phone_incoming|
|<span class="nerdfont big">&#xf1193;</span>|md_phone_incoming_outline|
|<span class="nerdfont big">&#xf03f8;</span>|md_phone_lock|
|<span class="nerdfont big">&#xf1194;</span>|md_phone_lock_outline|
|<span class="nerdfont big">&#xf03f9;</span>|md_phone_log|
|<span class="nerdfont big">&#xf1195;</span>|md_phone_log_outline|
|<span class="nerdfont big">&#xf1196;</span>|md_phone_message|
|<span class="nerdfont big">&#xf1197;</span>|md_phone_message_outline|
|<span class="nerdfont big">&#xf0658;</span>|md_phone_minus|
|<span class="nerdfont big">&#xf1198;</span>|md_phone_minus_outline|
|<span class="nerdfont big">&#xf03fa;</span>|md_phone_missed|
|<span class="nerdfont big">&#xf11a5;</span>|md_phone_missed_outline|
|<span class="nerdfont big">&#xf0def;</span>|md_phone_off|
|<span class="nerdfont big">&#xf11a6;</span>|md_phone_off_outline|
|<span class="nerdfont big">&#xf03fb;</span>|md_phone_outgoing|
|<span class="nerdfont big">&#xf1199;</span>|md_phone_outgoing_outline|
|<span class="nerdfont big">&#xf0df0;</span>|md_phone_outline|
|<span class="nerdfont big">&#xf03fc;</span>|md_phone_paused|
|<span class="nerdfont big">&#xf119a;</span>|md_phone_paused_outline|
|<span class="nerdfont big">&#xf0659;</span>|md_phone_plus|
|<span class="nerdfont big">&#xf119b;</span>|md_phone_plus_outline|
|<span class="nerdfont big">&#xf1993;</span>|md_phone_refresh|
|<span class="nerdfont big">&#xf1994;</span>|md_phone_refresh_outline|
|<span class="nerdfont big">&#xf152f;</span>|md_phone_remove|
|<span class="nerdfont big">&#xf1530;</span>|md_phone_remove_outline|
|<span class="nerdfont big">&#xf082f;</span>|md_phone_return|
|<span class="nerdfont big">&#xf119c;</span>|md_phone_return_outline|
|<span class="nerdfont big">&#xf11ab;</span>|md_phone_ring|
|<span class="nerdfont big">&#xf11ac;</span>|md_phone_ring_outline|
|<span class="nerdfont big">&#xf0885;</span>|md_phone_rotate_landscape|
|<span class="nerdfont big">&#xf0886;</span>|md_phone_rotate_portrait|
|<span class="nerdfont big">&#xf03fd;</span>|md_phone_settings|
|<span class="nerdfont big">&#xf119d;</span>|md_phone_settings_outline|
|<span class="nerdfont big">&#xf1995;</span>|md_phone_sync|
|<span class="nerdfont big">&#xf1996;</span>|md_phone_sync_outline|
|<span class="nerdfont big">&#xf03fe;</span>|md_phone_voip|
|<span class="nerdfont big">&#xf03ff;</span>|md_pi|
|<span class="nerdfont big">&#xf0400;</span>|md_pi_box|
|<span class="nerdfont big">&#xf0df1;</span>|md_pi_hole|
|<span class="nerdfont big">&#xf067d;</span>|md_piano|
|<span class="nerdfont big">&#xf0698;</span>|md_piano_off|
|<span class="nerdfont big">&#xf08b7;</span>|md_pickaxe|
|<span class="nerdfont big">&#xf0e57;</span>|md_picture_in_picture_bottom_right|
|<span class="nerdfont big">&#xf0e58;</span>|md_picture_in_picture_bottom_right_outline|
|<span class="nerdfont big">&#xf0e59;</span>|md_picture_in_picture_top_right|
|<span class="nerdfont big">&#xf0e5a;</span>|md_picture_in_picture_top_right_outline|
|<span class="nerdfont big">&#xf0887;</span>|md_pier|
|<span class="nerdfont big">&#xf0888;</span>|md_pier_crane|
|<span class="nerdfont big">&#xf0401;</span>|md_pig|
|<span class="nerdfont big">&#xf1006;</span>|md_pig_variant|
|<span class="nerdfont big">&#xf1678;</span>|md_pig_variant_outline|
|<span class="nerdfont big">&#xf1007;</span>|md_piggy_bank|
|<span class="nerdfont big">&#xf1679;</span>|md_piggy_bank_outline|
|<span class="nerdfont big">&#xf0402;</span>|md_pill|
|<span class="nerdfont big">&#xf1a5c;</span>|md_pill_off|
|<span class="nerdfont big">&#xf0702;</span>|md_pillar|
|<span class="nerdfont big">&#xf0403;</span>|md_pin|
|<span class="nerdfont big">&#xf0404;</span>|md_pin_off|
|<span class="nerdfont big">&#xf0930;</span>|md_pin_off_outline|
|<span class="nerdfont big">&#xf0931;</span>|md_pin_outline|
|<span class="nerdfont big">&#xf0405;</span>|md_pine_tree|
|<span class="nerdfont big">&#xf0406;</span>|md_pine_tree_box|
|<span class="nerdfont big">&#xf141a;</span>|md_pine_tree_fire|
|<span class="nerdfont big">&#xf0407;</span>|md_pinterest|
|<span class="nerdfont big">&#xf0ad5;</span>|md_pinwheel|
|<span class="nerdfont big">&#xf0ad6;</span>|md_pinwheel_outline|
|<span class="nerdfont big">&#xf07e5;</span>|md_pipe|
|<span class="nerdfont big">&#xf07e6;</span>|md_pipe_disconnected|
|<span class="nerdfont big">&#xf0889;</span>|md_pipe_leak|
|<span class="nerdfont big">&#xf184d;</span>|md_pipe_valve|
|<span class="nerdfont big">&#xf1354;</span>|md_pipe_wrench|
|<span class="nerdfont big">&#xf0a08;</span>|md_pirate|
|<span class="nerdfont big">&#xf0703;</span>|md_pistol|
|<span class="nerdfont big">&#xf088a;</span>|md_piston|
|<span class="nerdfont big">&#xf1553;</span>|md_pitchfork|
|<span class="nerdfont big">&#xf0409;</span>|md_pizza|
|<span class="nerdfont big">&#xf040a;</span>|md_play|
|<span class="nerdfont big">&#xf127a;</span>|md_play_box|
|<span class="nerdfont big">&#xf1a16;</span>|md_play_box_lock|
|<span class="nerdfont big">&#xf1a17;</span>|md_play_box_lock_open|
|<span class="nerdfont big">&#xf1a18;</span>|md_play_box_lock_open_outline|
|<span class="nerdfont big">&#xf1a19;</span>|md_play_box_lock_outline|
|<span class="nerdfont big">&#xf0d19;</span>|md_play_box_multiple|
|<span class="nerdfont big">&#xf13e6;</span>|md_play_box_multiple_outline|
|<span class="nerdfont big">&#xf040b;</span>|md_play_box_outline|
|<span class="nerdfont big">&#xf040c;</span>|md_play_circle|
|<span class="nerdfont big">&#xf040d;</span>|md_play_circle_outline|
|<span class="nerdfont big">&#xf088b;</span>|md_play_network|
|<span class="nerdfont big">&#xf0cb7;</span>|md_play_network_outline|
|<span class="nerdfont big">&#xf0f1b;</span>|md_play_outline|
|<span class="nerdfont big">&#xf040e;</span>|md_play_pause|
|<span class="nerdfont big">&#xf040f;</span>|md_play_protected_content|
|<span class="nerdfont big">&#xf08ff;</span>|md_play_speed|
|<span class="nerdfont big">&#xf05c7;</span>|md_playlist_check|
|<span class="nerdfont big">&#xf0900;</span>|md_playlist_edit|
|<span class="nerdfont big">&#xf0410;</span>|md_playlist_minus|
|<span class="nerdfont big">&#xf0cb8;</span>|md_playlist_music|
|<span class="nerdfont big">&#xf0cb9;</span>|md_playlist_music_outline|
|<span class="nerdfont big">&#xf0411;</span>|md_playlist_play|
|<span class="nerdfont big">&#xf0412;</span>|md_playlist_plus|
|<span class="nerdfont big">&#xf0413;</span>|md_playlist_remove|
|<span class="nerdfont big">&#xf0df2;</span>|md_playlist_star|
|<span class="nerdfont big">&#xf06ba;</span>|md_plex|
|<span class="nerdfont big">&#xf19a4;</span>|md_pliers|
|<span class="nerdfont big">&#xf0415;</span>|md_plus|
|<span class="nerdfont big">&#xf0416;</span>|md_plus_box|
|<span class="nerdfont big">&#xf0334;</span>|md_plus_box_multiple|
|<span class="nerdfont big">&#xf1143;</span>|md_plus_box_multiple_outline|
|<span class="nerdfont big">&#xf0704;</span>|md_plus_box_outline|
|<span class="nerdfont big">&#xf0417;</span>|md_plus_circle|
|<span class="nerdfont big">&#xf034c;</span>|md_plus_circle_multiple|
|<span class="nerdfont big">&#xf0418;</span>|md_plus_circle_multiple_outline|
|<span class="nerdfont big">&#xf0419;</span>|md_plus_circle_outline|
|<span class="nerdfont big">&#xf1a5d;</span>|md_plus_lock|
|<span class="nerdfont big">&#xf1a5e;</span>|md_plus_lock_open|
|<span class="nerdfont big">&#xf0992;</span>|md_plus_minus|
|<span class="nerdfont big">&#xf0993;</span>|md_plus_minus_box|
|<span class="nerdfont big">&#xf14c9;</span>|md_plus_minus_variant|
|<span class="nerdfont big">&#xf041a;</span>|md_plus_network|
|<span class="nerdfont big">&#xf0cba;</span>|md_plus_network_outline|
|<span class="nerdfont big">&#xf0705;</span>|md_plus_outline|
|<span class="nerdfont big">&#xf11ec;</span>|md_plus_thick|
|<span class="nerdfont big">&#xf0994;</span>|md_podcast|
|<span class="nerdfont big">&#xf0d25;</span>|md_podium|
|<span class="nerdfont big">&#xf0d26;</span>|md_podium_bronze|
|<span class="nerdfont big">&#xf0d27;</span>|md_podium_gold|
|<span class="nerdfont big">&#xf0d28;</span>|md_podium_silver|
|<span class="nerdfont big">&#xf0d92;</span>|md_point_of_sale|
|<span class="nerdfont big">&#xf041d;</span>|md_pokeball|
|<span class="nerdfont big">&#xf0a09;</span>|md_pokemon_go|
|<span class="nerdfont big">&#xf0830;</span>|md_poker_chip|
|<span class="nerdfont big">&#xf041e;</span>|md_polaroid|
|<span class="nerdfont big">&#xf1167;</span>|md_police_badge|
|<span class="nerdfont big">&#xf1168;</span>|md_police_badge_outline|
|<span class="nerdfont big">&#xf1839;</span>|md_police_station|
|<span class="nerdfont big">&#xf041f;</span>|md_poll|
|<span class="nerdfont big">&#xf14c3;</span>|md_polo|
|<span class="nerdfont big">&#xf0421;</span>|md_polymer|
|<span class="nerdfont big">&#xf0606;</span>|md_pool|
|<span class="nerdfont big">&#xf1a5f;</span>|md_pool_thermometer|
|<span class="nerdfont big">&#xf0422;</span>|md_popcorn|
|<span class="nerdfont big">&#xf1008;</span>|md_post|
|<span class="nerdfont big">&#xf1a60;</span>|md_post_lamp|
|<span class="nerdfont big">&#xf1009;</span>|md_post_outline|
|<span class="nerdfont big">&#xf0cbb;</span>|md_postage_stamp|
|<span class="nerdfont big">&#xf02e5;</span>|md_pot|
|<span class="nerdfont big">&#xf065b;</span>|md_pot_mix|
|<span class="nerdfont big">&#xf0677;</span>|md_pot_mix_outline|
|<span class="nerdfont big">&#xf02ff;</span>|md_pot_outline|
|<span class="nerdfont big">&#xf065a;</span>|md_pot_steam|
|<span class="nerdfont big">&#xf0326;</span>|md_pot_steam_outline|
|<span class="nerdfont big">&#xf0423;</span>|md_pound|
|<span class="nerdfont big">&#xf0424;</span>|md_pound_box|
|<span class="nerdfont big">&#xf117f;</span>|md_pound_box_outline|
|<span class="nerdfont big">&#xf0425;</span>|md_power|
|<span class="nerdfont big">&#xf0901;</span>|md_power_cycle|
|<span class="nerdfont big">&#xf0902;</span>|md_power_off|
|<span class="nerdfont big">&#xf0903;</span>|md_power_on|
|<span class="nerdfont big">&#xf06a5;</span>|md_power_plug|
|<span class="nerdfont big">&#xf06a6;</span>|md_power_plug_off|
|<span class="nerdfont big">&#xf1424;</span>|md_power_plug_off_outline|
|<span class="nerdfont big">&#xf1425;</span>|md_power_plug_outline|
|<span class="nerdfont big">&#xf0426;</span>|md_power_settings|
|<span class="nerdfont big">&#xf0904;</span>|md_power_sleep|
|<span class="nerdfont big">&#xf0427;</span>|md_power_socket|
|<span class="nerdfont big">&#xf0905;</span>|md_power_socket_au|
|<span class="nerdfont big">&#xf0fb3;</span>|md_power_socket_ch|
|<span class="nerdfont big">&#xf1107;</span>|md_power_socket_de|
|<span class="nerdfont big">&#xf07e7;</span>|md_power_socket_eu|
|<span class="nerdfont big">&#xf1108;</span>|md_power_socket_fr|
|<span class="nerdfont big">&#xf14ff;</span>|md_power_socket_it|
|<span class="nerdfont big">&#xf1109;</span>|md_power_socket_jp|
|<span class="nerdfont big">&#xf07e8;</span>|md_power_socket_uk|
|<span class="nerdfont big">&#xf07e9;</span>|md_power_socket_us|
|<span class="nerdfont big">&#xf0906;</span>|md_power_standby|
|<span class="nerdfont big">&#xf0a0a;</span>|md_powershell|
|<span class="nerdfont big">&#xf0706;</span>|md_prescription|
|<span class="nerdfont big">&#xf0428;</span>|md_presentation|
|<span class="nerdfont big">&#xf0429;</span>|md_presentation_play|
|<span class="nerdfont big">&#xf1562;</span>|md_pretzel|
|<span class="nerdfont big">&#xf042a;</span>|md_printer|
|<span class="nerdfont big">&#xf042b;</span>|md_printer_3d|
|<span class="nerdfont big">&#xf0e5b;</span>|md_printer_3d_nozzle|
|<span class="nerdfont big">&#xf11c0;</span>|md_printer_3d_nozzle_alert|
|<span class="nerdfont big">&#xf11c1;</span>|md_printer_3d_nozzle_alert_outline|
|<span class="nerdfont big">&#xf18b8;</span>|md_printer_3d_nozzle_heat|
|<span class="nerdfont big">&#xf18b9;</span>|md_printer_3d_nozzle_heat_outline|
|<span class="nerdfont big">&#xf0e5c;</span>|md_printer_3d_nozzle_outline|
|<span class="nerdfont big">&#xf042c;</span>|md_printer_alert|
|<span class="nerdfont big">&#xf1146;</span>|md_printer_check|
|<span class="nerdfont big">&#xf1458;</span>|md_printer_eye|
|<span class="nerdfont big">&#xf0e5d;</span>|md_printer_off|
|<span class="nerdfont big">&#xf1785;</span>|md_printer_off_outline|
|<span class="nerdfont big">&#xf1786;</span>|md_printer_outline|
|<span class="nerdfont big">&#xf1057;</span>|md_printer_pos|
|<span class="nerdfont big">&#xf1457;</span>|md_printer_search|
|<span class="nerdfont big">&#xf0707;</span>|md_printer_settings|
|<span class="nerdfont big">&#xf0a0b;</span>|md_printer_wireless|
|<span class="nerdfont big">&#xf0603;</span>|md_priority_high|
|<span class="nerdfont big">&#xf0604;</span>|md_priority_low|
|<span class="nerdfont big">&#xf042d;</span>|md_professional_hexagon|
|<span class="nerdfont big">&#xf0cbc;</span>|md_progress_alert|
|<span class="nerdfont big">&#xf0995;</span>|md_progress_check|
|<span class="nerdfont big">&#xf0996;</span>|md_progress_clock|
|<span class="nerdfont big">&#xf110a;</span>|md_progress_close|
|<span class="nerdfont big">&#xf0997;</span>|md_progress_download|
|<span class="nerdfont big">&#xf1787;</span>|md_progress_pencil|
|<span class="nerdfont big">&#xf1522;</span>|md_progress_question|
|<span class="nerdfont big">&#xf1788;</span>|md_progress_star|
|<span class="nerdfont big">&#xf0998;</span>|md_progress_upload|
|<span class="nerdfont big">&#xf0cbd;</span>|md_progress_wrench|
|<span class="nerdfont big">&#xf042e;</span>|md_projector|
|<span class="nerdfont big">&#xf1a23;</span>|md_projector_off|
|<span class="nerdfont big">&#xf042f;</span>|md_projector_screen|
|<span class="nerdfont big">&#xf180d;</span>|md_projector_screen_off|
|<span class="nerdfont big">&#xf180e;</span>|md_projector_screen_off_outline|
|<span class="nerdfont big">&#xf1724;</span>|md_projector_screen_outline|
|<span class="nerdfont big">&#xf180f;</span>|md_projector_screen_variant|
|<span class="nerdfont big">&#xf1810;</span>|md_projector_screen_variant_off|
|<span class="nerdfont big">&#xf1811;</span>|md_projector_screen_variant_off_outline|
|<span class="nerdfont big">&#xf1812;</span>|md_projector_screen_variant_outline|
|<span class="nerdfont big">&#xf1357;</span>|md_propane_tank|
|<span class="nerdfont big">&#xf1358;</span>|md_propane_tank_outline|
|<span class="nerdfont big">&#xf0fd8;</span>|md_protocol|
|<span class="nerdfont big">&#xf06a7;</span>|md_publish|
|<span class="nerdfont big">&#xf1945;</span>|md_publish_off|
|<span class="nerdfont big">&#xf0430;</span>|md_pulse|
|<span class="nerdfont big">&#xf1402;</span>|md_pump|
|<span class="nerdfont big">&#xf0bbf;</span>|md_pumpkin|
|<span class="nerdfont big">&#xf0f1c;</span>|md_purse|
|<span class="nerdfont big">&#xf0f1d;</span>|md_purse_outline|
|<span class="nerdfont big">&#xf0431;</span>|md_puzzle|
|<span class="nerdfont big">&#xf1426;</span>|md_puzzle_check|
|<span class="nerdfont big">&#xf1427;</span>|md_puzzle_check_outline|
|<span class="nerdfont big">&#xf14d3;</span>|md_puzzle_edit|
|<span class="nerdfont big">&#xf14d9;</span>|md_puzzle_edit_outline|
|<span class="nerdfont big">&#xf14d4;</span>|md_puzzle_heart|
|<span class="nerdfont big">&#xf14da;</span>|md_puzzle_heart_outline|
|<span class="nerdfont big">&#xf14d1;</span>|md_puzzle_minus|
|<span class="nerdfont big">&#xf14d7;</span>|md_puzzle_minus_outline|
|<span class="nerdfont big">&#xf0a66;</span>|md_puzzle_outline|
|<span class="nerdfont big">&#xf14d0;</span>|md_puzzle_plus|
|<span class="nerdfont big">&#xf14d6;</span>|md_puzzle_plus_outline|
|<span class="nerdfont big">&#xf14d2;</span>|md_puzzle_remove|
|<span class="nerdfont big">&#xf14d8;</span>|md_puzzle_remove_outline|
|<span class="nerdfont big">&#xf14d5;</span>|md_puzzle_star|
|<span class="nerdfont big">&#xf14db;</span>|md_puzzle_star_outline|
|<span class="nerdfont big">&#xf1952;</span>|md_pyramid|
|<span class="nerdfont big">&#xf1953;</span>|md_pyramid_off|
|<span class="nerdfont big">&#xf0999;</span>|md_qi|
|<span class="nerdfont big">&#xf0605;</span>|md_qqchat|
|<span class="nerdfont big">&#xf0432;</span>|md_qrcode|
|<span class="nerdfont big">&#xf08b8;</span>|md_qrcode_edit|
|<span class="nerdfont big">&#xf118c;</span>|md_qrcode_minus|
|<span class="nerdfont big">&#xf118b;</span>|md_qrcode_plus|
|<span class="nerdfont big">&#xf118d;</span>|md_qrcode_remove|
|<span class="nerdfont big">&#xf0433;</span>|md_qrcode_scan|
|<span class="nerdfont big">&#xf0434;</span>|md_quadcopter|
|<span class="nerdfont big">&#xf0435;</span>|md_quality_high|
|<span class="nerdfont big">&#xf0a0c;</span>|md_quality_low|
|<span class="nerdfont big">&#xf0a0d;</span>|md_quality_medium|
|<span class="nerdfont big">&#xf0d29;</span>|md_quora|
|<span class="nerdfont big">&#xf0907;</span>|md_rabbit|
|<span class="nerdfont big">&#xf1a61;</span>|md_rabbit_variant|
|<span class="nerdfont big">&#xf1a62;</span>|md_rabbit_variant_outline|
|<span class="nerdfont big">&#xf0d93;</span>|md_racing_helmet|
|<span class="nerdfont big">&#xf0d94;</span>|md_racquetball|
|<span class="nerdfont big">&#xf0437;</span>|md_radar|
|<span class="nerdfont big">&#xf0438;</span>|md_radiator|
|<span class="nerdfont big">&#xf0ad7;</span>|md_radiator_disabled|
|<span class="nerdfont big">&#xf0ad8;</span>|md_radiator_off|
|<span class="nerdfont big">&#xf0439;</span>|md_radio|
|<span class="nerdfont big">&#xf0cbe;</span>|md_radio_am|
|<span class="nerdfont big">&#xf0cbf;</span>|md_radio_fm|
|<span class="nerdfont big">&#xf043a;</span>|md_radio_handheld|
|<span class="nerdfont big">&#xf121c;</span>|md_radio_off|
|<span class="nerdfont big">&#xf043b;</span>|md_radio_tower|
|<span class="nerdfont big">&#xf043c;</span>|md_radioactive|
|<span class="nerdfont big">&#xf185d;</span>|md_radioactive_circle|
|<span class="nerdfont big">&#xf185e;</span>|md_radioactive_circle_outline|
|<span class="nerdfont big">&#xf0ec1;</span>|md_radioactive_off|
|<span class="nerdfont big">&#xf043e;</span>|md_radiobox_marked|
|<span class="nerdfont big">&#xf14c5;</span>|md_radiology_box|
|<span class="nerdfont big">&#xf14c6;</span>|md_radiology_box_outline|
|<span class="nerdfont big">&#xf0cc0;</span>|md_radius|
|<span class="nerdfont big">&#xf0cc1;</span>|md_radius_outline|
|<span class="nerdfont big">&#xf0f1e;</span>|md_railroad_light|
|<span class="nerdfont big">&#xf1544;</span>|md_rake|
|<span class="nerdfont big">&#xf043f;</span>|md_raspberry_pi|
|<span class="nerdfont big">&#xf1a0f;</span>|md_raw|
|<span class="nerdfont big">&#xf1a10;</span>|md_raw_off|
|<span class="nerdfont big">&#xf0440;</span>|md_ray_end|
|<span class="nerdfont big">&#xf0441;</span>|md_ray_end_arrow|
|<span class="nerdfont big">&#xf0442;</span>|md_ray_start|
|<span class="nerdfont big">&#xf0443;</span>|md_ray_start_arrow|
|<span class="nerdfont big">&#xf0444;</span>|md_ray_start_end|
|<span class="nerdfont big">&#xf15d8;</span>|md_ray_start_vertex_end|
|<span class="nerdfont big">&#xf0445;</span>|md_ray_vertex|
|<span class="nerdfont big">&#xf1997;</span>|md_razor_double_edge|
|<span class="nerdfont big">&#xf1998;</span>|md_razor_single_edge|
|<span class="nerdfont big">&#xf0708;</span>|md_react|
|<span class="nerdfont big">&#xf0447;</span>|md_read|
|<span class="nerdfont big">&#xf0449;</span>|md_receipt|
|<span class="nerdfont big">&#xf19dc;</span>|md_receipt_outline|
|<span class="nerdfont big">&#xf1a63;</span>|md_receipt_text_check|
|<span class="nerdfont big">&#xf1a64;</span>|md_receipt_text_check_outline|
|<span class="nerdfont big">&#xf1a65;</span>|md_receipt_text_minus|
|<span class="nerdfont big">&#xf1a66;</span>|md_receipt_text_minus_outline|
|<span class="nerdfont big">&#xf1a67;</span>|md_receipt_text_plus|
|<span class="nerdfont big">&#xf1a68;</span>|md_receipt_text_plus_outline|
|<span class="nerdfont big">&#xf1a69;</span>|md_receipt_text_remove|
|<span class="nerdfont big">&#xf1a6a;</span>|md_receipt_text_remove_outline|
|<span class="nerdfont big">&#xf044a;</span>|md_record|
|<span class="nerdfont big">&#xf0ec2;</span>|md_record_circle|
|<span class="nerdfont big">&#xf0ec3;</span>|md_record_circle_outline|
|<span class="nerdfont big">&#xf099a;</span>|md_record_player|
|<span class="nerdfont big">&#xf044b;</span>|md_record_rec|
|<span class="nerdfont big">&#xf0e5e;</span>|md_rectangle|
|<span class="nerdfont big">&#xf0e5f;</span>|md_rectangle_outline|
|<span class="nerdfont big">&#xf044c;</span>|md_recycle|
|<span class="nerdfont big">&#xf139d;</span>|md_recycle_variant|
|<span class="nerdfont big">&#xf044d;</span>|md_reddit|
|<span class="nerdfont big">&#xf111b;</span>|md_redhat|
|<span class="nerdfont big">&#xf044e;</span>|md_redo|
|<span class="nerdfont big">&#xf044f;</span>|md_redo_variant|
|<span class="nerdfont big">&#xf0a0e;</span>|md_reflect_horizontal|
|<span class="nerdfont big">&#xf0a0f;</span>|md_reflect_vertical|
|<span class="nerdfont big">&#xf0450;</span>|md_refresh|
|<span class="nerdfont big">&#xf18f2;</span>|md_refresh_auto|
|<span class="nerdfont big">&#xf1377;</span>|md_refresh_circle|
|<span class="nerdfont big">&#xf0451;</span>|md_regex|
|<span class="nerdfont big">&#xf0a67;</span>|md_registered_trademark|
|<span class="nerdfont big">&#xf1588;</span>|md_reiterate|
|<span class="nerdfont big">&#xf1496;</span>|md_relation_many_to_many|
|<span class="nerdfont big">&#xf1497;</span>|md_relation_many_to_one|
|<span class="nerdfont big">&#xf1498;</span>|md_relation_many_to_one_or_many|
|<span class="nerdfont big">&#xf1499;</span>|md_relation_many_to_only_one|
|<span class="nerdfont big">&#xf149a;</span>|md_relation_many_to_zero_or_many|
|<span class="nerdfont big">&#xf149b;</span>|md_relation_many_to_zero_or_one|
|<span class="nerdfont big">&#xf149c;</span>|md_relation_one_or_many_to_many|
|<span class="nerdfont big">&#xf149d;</span>|md_relation_one_or_many_to_one|
|<span class="nerdfont big">&#xf149e;</span>|md_relation_one_or_many_to_one_or_many|
|<span class="nerdfont big">&#xf149f;</span>|md_relation_one_or_many_to_only_one|
|<span class="nerdfont big">&#xf14a0;</span>|md_relation_one_or_many_to_zero_or_many|
|<span class="nerdfont big">&#xf14a1;</span>|md_relation_one_or_many_to_zero_or_one|
|<span class="nerdfont big">&#xf14a2;</span>|md_relation_one_to_many|
|<span class="nerdfont big">&#xf14a3;</span>|md_relation_one_to_one|
|<span class="nerdfont big">&#xf14a4;</span>|md_relation_one_to_one_or_many|
|<span class="nerdfont big">&#xf14a5;</span>|md_relation_one_to_only_one|
|<span class="nerdfont big">&#xf14a6;</span>|md_relation_one_to_zero_or_many|
|<span class="nerdfont big">&#xf14a7;</span>|md_relation_one_to_zero_or_one|
|<span class="nerdfont big">&#xf14a8;</span>|md_relation_only_one_to_many|
|<span class="nerdfont big">&#xf14a9;</span>|md_relation_only_one_to_one|
|<span class="nerdfont big">&#xf14aa;</span>|md_relation_only_one_to_one_or_many|
|<span class="nerdfont big">&#xf14ab;</span>|md_relation_only_one_to_only_one|
|<span class="nerdfont big">&#xf14ac;</span>|md_relation_only_one_to_zero_or_many|
|<span class="nerdfont big">&#xf14ad;</span>|md_relation_only_one_to_zero_or_one|
|<span class="nerdfont big">&#xf14ae;</span>|md_relation_zero_or_many_to_many|
|<span class="nerdfont big">&#xf14af;</span>|md_relation_zero_or_many_to_one|
|<span class="nerdfont big">&#xf14b0;</span>|md_relation_zero_or_many_to_one_or_many|
|<span class="nerdfont big">&#xf14b1;</span>|md_relation_zero_or_many_to_only_one|
|<span class="nerdfont big">&#xf14b2;</span>|md_relation_zero_or_many_to_zero_or_many|
|<span class="nerdfont big">&#xf14b3;</span>|md_relation_zero_or_many_to_zero_or_one|
|<span class="nerdfont big">&#xf14b4;</span>|md_relation_zero_or_one_to_many|
|<span class="nerdfont big">&#xf14b5;</span>|md_relation_zero_or_one_to_one|
|<span class="nerdfont big">&#xf14b6;</span>|md_relation_zero_or_one_to_one_or_many|
|<span class="nerdfont big">&#xf14b7;</span>|md_relation_zero_or_one_to_only_one|
|<span class="nerdfont big">&#xf14b8;</span>|md_relation_zero_or_one_to_zero_or_many|
|<span class="nerdfont big">&#xf14b9;</span>|md_relation_zero_or_one_to_zero_or_one|
|<span class="nerdfont big">&#xf0452;</span>|md_relative_scale|
|<span class="nerdfont big">&#xf0453;</span>|md_reload|
|<span class="nerdfont big">&#xf110b;</span>|md_reload_alert|
|<span class="nerdfont big">&#xf088c;</span>|md_reminder|
|<span class="nerdfont big">&#xf0454;</span>|md_remote|
|<span class="nerdfont big">&#xf08b9;</span>|md_remote_desktop|
|<span class="nerdfont big">&#xf0ec4;</span>|md_remote_off|
|<span class="nerdfont big">&#xf0ec5;</span>|md_remote_tv|
|<span class="nerdfont big">&#xf0ec6;</span>|md_remote_tv_off|
|<span class="nerdfont big">&#xf0455;</span>|md_rename_box|
|<span class="nerdfont big">&#xf0688;</span>|md_reorder_horizontal|
|<span class="nerdfont big">&#xf0689;</span>|md_reorder_vertical|
|<span class="nerdfont big">&#xf0456;</span>|md_repeat|
|<span class="nerdfont big">&#xf0457;</span>|md_repeat_off|
|<span class="nerdfont big">&#xf0458;</span>|md_repeat_once|
|<span class="nerdfont big">&#xf0547;</span>|md_repeat_variant|
|<span class="nerdfont big">&#xf0459;</span>|md_replay|
|<span class="nerdfont big">&#xf045a;</span>|md_reply|
|<span class="nerdfont big">&#xf045b;</span>|md_reply_all|
|<span class="nerdfont big">&#xf0f1f;</span>|md_reply_all_outline|
|<span class="nerdfont big">&#xf11ae;</span>|md_reply_circle|
|<span class="nerdfont big">&#xf0f20;</span>|md_reply_outline|
|<span class="nerdfont big">&#xf045c;</span>|md_reproduction|
|<span class="nerdfont big">&#xf0b44;</span>|md_resistor|
|<span class="nerdfont big">&#xf0b45;</span>|md_resistor_nodes|
|<span class="nerdfont big">&#xf0a68;</span>|md_resize|
|<span class="nerdfont big">&#xf045d;</span>|md_resize_bottom_right|
|<span class="nerdfont big">&#xf045e;</span>|md_responsive|
|<span class="nerdfont big">&#xf0709;</span>|md_restart|
|<span class="nerdfont big">&#xf110c;</span>|md_restart_alert|
|<span class="nerdfont big">&#xf0d95;</span>|md_restart_off|
|<span class="nerdfont big">&#xf099b;</span>|md_restore|
|<span class="nerdfont big">&#xf110d;</span>|md_restore_alert|
|<span class="nerdfont big">&#xf045f;</span>|md_rewind|
|<span class="nerdfont big">&#xf11f9;</span>|md_rewind_5|
|<span class="nerdfont big">&#xf0d2a;</span>|md_rewind_10|
|<span class="nerdfont big">&#xf1946;</span>|md_rewind_15|
|<span class="nerdfont big">&#xf0d96;</span>|md_rewind_30|
|<span class="nerdfont big">&#xf160c;</span>|md_rewind_60|
|<span class="nerdfont big">&#xf070a;</span>|md_rewind_outline|
|<span class="nerdfont big">&#xf070b;</span>|md_rhombus|
|<span class="nerdfont big">&#xf0a10;</span>|md_rhombus_medium|
|<span class="nerdfont big">&#xf14dc;</span>|md_rhombus_medium_outline|
|<span class="nerdfont big">&#xf070c;</span>|md_rhombus_outline|
|<span class="nerdfont big">&#xf0a11;</span>|md_rhombus_split|
|<span class="nerdfont big">&#xf14dd;</span>|md_rhombus_split_outline|
|<span class="nerdfont big">&#xf0460;</span>|md_ribbon|
|<span class="nerdfont big">&#xf07ea;</span>|md_rice|
|<span class="nerdfont big">&#xf15bb;</span>|md_rickshaw|
|<span class="nerdfont big">&#xf15bc;</span>|md_rickshaw_electric|
|<span class="nerdfont big">&#xf07eb;</span>|md_ring|
|<span class="nerdfont big">&#xf0e60;</span>|md_rivet|
|<span class="nerdfont big">&#xf0461;</span>|md_road|
|<span class="nerdfont big">&#xf0462;</span>|md_road_variant|
|<span class="nerdfont big">&#xf1058;</span>|md_robber|
|<span class="nerdfont big">&#xf06a9;</span>|md_robot|
|<span class="nerdfont big">&#xf169d;</span>|md_robot_angry|
|<span class="nerdfont big">&#xf169e;</span>|md_robot_angry_outline|
|<span class="nerdfont big">&#xf169f;</span>|md_robot_confused|
|<span class="nerdfont big">&#xf16a0;</span>|md_robot_confused_outline|
|<span class="nerdfont big">&#xf16a1;</span>|md_robot_dead|
|<span class="nerdfont big">&#xf16a2;</span>|md_robot_dead_outline|
|<span class="nerdfont big">&#xf16a3;</span>|md_robot_excited|
|<span class="nerdfont big">&#xf16a4;</span>|md_robot_excited_outline|
|<span class="nerdfont big">&#xf1719;</span>|md_robot_happy|
|<span class="nerdfont big">&#xf171a;</span>|md_robot_happy_outline|
|<span class="nerdfont big">&#xf0b46;</span>|md_robot_industrial|
|<span class="nerdfont big">&#xf1a1a;</span>|md_robot_industrial_outline|
|<span class="nerdfont big">&#xf16a5;</span>|md_robot_love|
|<span class="nerdfont big">&#xf16a6;</span>|md_robot_love_outline|
|<span class="nerdfont big">&#xf11f7;</span>|md_robot_mower|
|<span class="nerdfont big">&#xf11f3;</span>|md_robot_mower_outline|
|<span class="nerdfont big">&#xf16a7;</span>|md_robot_off|
|<span class="nerdfont big">&#xf167b;</span>|md_robot_off_outline|
|<span class="nerdfont big">&#xf167a;</span>|md_robot_outline|
|<span class="nerdfont big">&#xf070d;</span>|md_robot_vacuum|
|<span class="nerdfont big">&#xf0908;</span>|md_robot_vacuum_variant|
|<span class="nerdfont big">&#xf0463;</span>|md_rocket|
|<span class="nerdfont big">&#xf14de;</span>|md_rocket_launch|
|<span class="nerdfont big">&#xf14df;</span>|md_rocket_launch_outline|
|<span class="nerdfont big">&#xf13af;</span>|md_rocket_outline|
|<span class="nerdfont big">&#xf1327;</span>|md_rodent|
|<span class="nerdfont big">&#xf1a6b;</span>|md_roller_shade|
|<span class="nerdfont big">&#xf1a6c;</span>|md_roller_shade_closed|
|<span class="nerdfont big">&#xf0d2b;</span>|md_roller_skate|
|<span class="nerdfont big">&#xf0145;</span>|md_roller_skate_off|
|<span class="nerdfont big">&#xf0d2c;</span>|md_rollerblade|
|<span class="nerdfont big">&#xf002e;</span>|md_rollerblade_off|
|<span class="nerdfont big">&#xf0bc0;</span>|md_rollupjs|
|<span class="nerdfont big">&#xf1ab9;</span>|md_rolodex|
|<span class="nerdfont big">&#xf1aba;</span>|md_rolodex_outline|
|<span class="nerdfont big">&#xf1089;</span>|md_roman_numeral_2|
|<span class="nerdfont big">&#xf108a;</span>|md_roman_numeral_3|
|<span class="nerdfont big">&#xf108b;</span>|md_roman_numeral_4|
|<span class="nerdfont big">&#xf108d;</span>|md_roman_numeral_6|
|<span class="nerdfont big">&#xf108e;</span>|md_roman_numeral_7|
|<span class="nerdfont big">&#xf108f;</span>|md_roman_numeral_8|
|<span class="nerdfont big">&#xf1090;</span>|md_roman_numeral_9|
|<span class="nerdfont big">&#xf088d;</span>|md_room_service|
|<span class="nerdfont big">&#xf0d97;</span>|md_room_service_outline|
|<span class="nerdfont big">&#xf1999;</span>|md_rotate_360|
|<span class="nerdfont big">&#xf0ec7;</span>|md_rotate_3d|
|<span class="nerdfont big">&#xf0464;</span>|md_rotate_3d_variant|
|<span class="nerdfont big">&#xf0465;</span>|md_rotate_left|
|<span class="nerdfont big">&#xf0466;</span>|md_rotate_left_variant|
|<span class="nerdfont big">&#xf0d98;</span>|md_rotate_orbit|
|<span class="nerdfont big">&#xf0467;</span>|md_rotate_right|
|<span class="nerdfont big">&#xf0468;</span>|md_rotate_right_variant|
|<span class="nerdfont big">&#xf0607;</span>|md_rounded_corner|
|<span class="nerdfont big">&#xf11e2;</span>|md_router|
|<span class="nerdfont big">&#xf1087;</span>|md_router_network|
|<span class="nerdfont big">&#xf0469;</span>|md_router_wireless|
|<span class="nerdfont big">&#xf15a3;</span>|md_router_wireless_off|
|<span class="nerdfont big">&#xf0a69;</span>|md_router_wireless_settings|
|<span class="nerdfont big">&#xf046a;</span>|md_routes|
|<span class="nerdfont big">&#xf1059;</span>|md_routes_clock|
|<span class="nerdfont big">&#xf0608;</span>|md_rowing|
|<span class="nerdfont big">&#xf046b;</span>|md_rss|
|<span class="nerdfont big">&#xf046c;</span>|md_rss_box|
|<span class="nerdfont big">&#xf0f21;</span>|md_rss_off|
|<span class="nerdfont big">&#xf1475;</span>|md_rug|
|<span class="nerdfont big">&#xf0d99;</span>|md_rugby|
|<span class="nerdfont big">&#xf046d;</span>|md_ruler|
|<span class="nerdfont big">&#xf0cc2;</span>|md_ruler_square|
|<span class="nerdfont big">&#xf0ebe;</span>|md_ruler_square_compass|
|<span class="nerdfont big">&#xf070e;</span>|md_run|
|<span class="nerdfont big">&#xf046e;</span>|md_run_fast|
|<span class="nerdfont big">&#xf11d4;</span>|md_rv_truck|
|<span class="nerdfont big">&#xf0d2e;</span>|md_sack|
|<span class="nerdfont big">&#xf0d2f;</span>|md_sack_percent|
|<span class="nerdfont big">&#xf0a6a;</span>|md_safe|
|<span class="nerdfont big">&#xf127c;</span>|md_safe_square|
|<span class="nerdfont big">&#xf127d;</span>|md_safe_square_outline|
|<span class="nerdfont big">&#xf0d30;</span>|md_safety_goggles|
|<span class="nerdfont big">&#xf0ec8;</span>|md_sail_boat|
|<span class="nerdfont big">&#xf1aef;</span>|md_sail_boat_sink|
|<span class="nerdfont big">&#xf046f;</span>|md_sale|
|<span class="nerdfont big">&#xf1a06;</span>|md_sale_outline|
|<span class="nerdfont big">&#xf088e;</span>|md_salesforce|
|<span class="nerdfont big">&#xf07ec;</span>|md_sass|
|<span class="nerdfont big">&#xf0470;</span>|md_satellite|
|<span class="nerdfont big">&#xf0909;</span>|md_satellite_uplink|
|<span class="nerdfont big">&#xf0471;</span>|md_satellite_variant|
|<span class="nerdfont big">&#xf08ba;</span>|md_sausage|
|<span class="nerdfont big">&#xf1789;</span>|md_sausage_off|
|<span class="nerdfont big">&#xf0e61;</span>|md_saw_blade|
|<span class="nerdfont big">&#xf147a;</span>|md_sawtooth_wave|
|<span class="nerdfont big">&#xf0609;</span>|md_saxophone|
|<span class="nerdfont big">&#xf0472;</span>|md_scale|
|<span class="nerdfont big">&#xf05d1;</span>|md_scale_balance|
|<span class="nerdfont big">&#xf0473;</span>|md_scale_bathroom|
|<span class="nerdfont big">&#xf105a;</span>|md_scale_off|
|<span class="nerdfont big">&#xf19b8;</span>|md_scale_unbalanced|
|<span class="nerdfont big">&#xf13d8;</span>|md_scan_helper|
|<span class="nerdfont big">&#xf06ab;</span>|md_scanner|
|<span class="nerdfont big">&#xf090a;</span>|md_scanner_off|
|<span class="nerdfont big">&#xf0ec9;</span>|md_scatter_plot|
|<span class="nerdfont big">&#xf0eca;</span>|md_scatter_plot_outline|
|<span class="nerdfont big">&#xf1958;</span>|md_scent|
|<span class="nerdfont big">&#xf1959;</span>|md_scent_off|
|<span class="nerdfont big">&#xf0474;</span>|md_school|
|<span class="nerdfont big">&#xf1180;</span>|md_school_outline|
|<span class="nerdfont big">&#xf0a6b;</span>|md_scissors_cutting|
|<span class="nerdfont big">&#xf15bd;</span>|md_scooter|
|<span class="nerdfont big">&#xf15be;</span>|md_scooter_electric|
|<span class="nerdfont big">&#xf127e;</span>|md_scoreboard|
|<span class="nerdfont big">&#xf127f;</span>|md_scoreboard_outline|
|<span class="nerdfont big">&#xf0475;</span>|md_screen_rotation|
|<span class="nerdfont big">&#xf0478;</span>|md_screen_rotation_lock|
|<span class="nerdfont big">&#xf0df3;</span>|md_screw_flat_top|
|<span class="nerdfont big">&#xf0df4;</span>|md_screw_lag|
|<span class="nerdfont big">&#xf0df5;</span>|md_screw_machine_flat_top|
|<span class="nerdfont big">&#xf0df6;</span>|md_screw_machine_round_top|
|<span class="nerdfont big">&#xf0df7;</span>|md_screw_round_top|
|<span class="nerdfont big">&#xf0476;</span>|md_screwdriver|
|<span class="nerdfont big">&#xf0bc1;</span>|md_script|
|<span class="nerdfont big">&#xf0477;</span>|md_script_outline|
|<span class="nerdfont big">&#xf0bc2;</span>|md_script_text|
|<span class="nerdfont big">&#xf1725;</span>|md_script_text_key|
|<span class="nerdfont big">&#xf1726;</span>|md_script_text_key_outline|
|<span class="nerdfont big">&#xf0bc3;</span>|md_script_text_outline|
|<span class="nerdfont big">&#xf1727;</span>|md_script_text_play|
|<span class="nerdfont big">&#xf1728;</span>|md_script_text_play_outline|
|<span class="nerdfont big">&#xf0479;</span>|md_sd|
|<span class="nerdfont big">&#xf047a;</span>|md_seal|
|<span class="nerdfont big">&#xf0fd9;</span>|md_seal_variant|
|<span class="nerdfont big">&#xf070f;</span>|md_search_web|
|<span class="nerdfont big">&#xf0cc3;</span>|md_seat|
|<span class="nerdfont big">&#xf047b;</span>|md_seat_flat|
|<span class="nerdfont big">&#xf047c;</span>|md_seat_flat_angled|
|<span class="nerdfont big">&#xf047d;</span>|md_seat_individual_suite|
|<span class="nerdfont big">&#xf047e;</span>|md_seat_legroom_extra|
|<span class="nerdfont big">&#xf047f;</span>|md_seat_legroom_normal|
|<span class="nerdfont big">&#xf0480;</span>|md_seat_legroom_reduced|
|<span class="nerdfont big">&#xf0cc4;</span>|md_seat_outline|
|<span class="nerdfont big">&#xf1249;</span>|md_seat_passenger|
|<span class="nerdfont big">&#xf0481;</span>|md_seat_recline_extra|
|<span class="nerdfont big">&#xf0482;</span>|md_seat_recline_normal|
|<span class="nerdfont big">&#xf0cc5;</span>|md_seatbelt|
|<span class="nerdfont big">&#xf0483;</span>|md_security|
|<span class="nerdfont big">&#xf0484;</span>|md_security_network|
|<span class="nerdfont big">&#xf0e62;</span>|md_seed|
|<span class="nerdfont big">&#xf13fd;</span>|md_seed_off|
|<span class="nerdfont big">&#xf13fe;</span>|md_seed_off_outline|
|<span class="nerdfont big">&#xf0e63;</span>|md_seed_outline|
|<span class="nerdfont big">&#xf1a6d;</span>|md_seed_plus|
|<span class="nerdfont big">&#xf1a6e;</span>|md_seed_plus_outline|
|<span class="nerdfont big">&#xf15a4;</span>|md_seesaw|
|<span class="nerdfont big">&#xf0ecb;</span>|md_segment|
|<span class="nerdfont big">&#xf0485;</span>|md_select|
|<span class="nerdfont big">&#xf0486;</span>|md_select_all|
|<span class="nerdfont big">&#xf0d31;</span>|md_select_color|
|<span class="nerdfont big">&#xf0ad9;</span>|md_select_compare|
|<span class="nerdfont big">&#xf0a6c;</span>|md_select_drag|
|<span class="nerdfont big">&#xf0f82;</span>|md_select_group|
|<span class="nerdfont big">&#xf0487;</span>|md_select_inverse|
|<span class="nerdfont big">&#xf1280;</span>|md_select_marker|
|<span class="nerdfont big">&#xf1281;</span>|md_select_multiple|
|<span class="nerdfont big">&#xf1282;</span>|md_select_multiple_marker|
|<span class="nerdfont big">&#xf0488;</span>|md_select_off|
|<span class="nerdfont big">&#xf0fda;</span>|md_select_place|
|<span class="nerdfont big">&#xf17c1;</span>|md_select_remove|
|<span class="nerdfont big">&#xf1204;</span>|md_select_search|
|<span class="nerdfont big">&#xf0489;</span>|md_selection|
|<span class="nerdfont big">&#xf0a6d;</span>|md_selection_drag|
|<span class="nerdfont big">&#xf0d32;</span>|md_selection_ellipse|
|<span class="nerdfont big">&#xf0f22;</span>|md_selection_ellipse_arrow_inside|
|<span class="nerdfont big">&#xf17c2;</span>|md_selection_ellipse_remove|
|<span class="nerdfont big">&#xf1283;</span>|md_selection_marker|
|<span class="nerdfont big">&#xf1285;</span>|md_selection_multiple|
|<span class="nerdfont big">&#xf1284;</span>|md_selection_multiple_marker|
|<span class="nerdfont big">&#xf0777;</span>|md_selection_off|
|<span class="nerdfont big">&#xf17c3;</span>|md_selection_remove|
|<span class="nerdfont big">&#xf1205;</span>|md_selection_search|
|<span class="nerdfont big">&#xf1316;</span>|md_semantic_web|
|<span class="nerdfont big">&#xf048a;</span>|md_send|
|<span class="nerdfont big">&#xf1161;</span>|md_send_check|
|<span class="nerdfont big">&#xf1162;</span>|md_send_check_outline|
|<span class="nerdfont big">&#xf0df8;</span>|md_send_circle|
|<span class="nerdfont big">&#xf0df9;</span>|md_send_circle_outline|
|<span class="nerdfont big">&#xf1163;</span>|md_send_clock|
|<span class="nerdfont big">&#xf1164;</span>|md_send_clock_outline|
|<span class="nerdfont big">&#xf07ed;</span>|md_send_lock|
|<span class="nerdfont big">&#xf1166;</span>|md_send_lock_outline|
|<span class="nerdfont big">&#xf1165;</span>|md_send_outline|
|<span class="nerdfont big">&#xf065c;</span>|md_serial_port|
|<span class="nerdfont big">&#xf048b;</span>|md_server|
|<span class="nerdfont big">&#xf048c;</span>|md_server_minus|
|<span class="nerdfont big">&#xf048d;</span>|md_server_network|
|<span class="nerdfont big">&#xf048e;</span>|md_server_network_off|
|<span class="nerdfont big">&#xf048f;</span>|md_server_off|
|<span class="nerdfont big">&#xf0490;</span>|md_server_plus|
|<span class="nerdfont big">&#xf0491;</span>|md_server_remove|
|<span class="nerdfont big">&#xf0492;</span>|md_server_security|
|<span class="nerdfont big">&#xf0778;</span>|md_set_all|
|<span class="nerdfont big">&#xf0779;</span>|md_set_center|
|<span class="nerdfont big">&#xf077a;</span>|md_set_center_right|
|<span class="nerdfont big">&#xf077b;</span>|md_set_left|
|<span class="nerdfont big">&#xf077c;</span>|md_set_left_center|
|<span class="nerdfont big">&#xf077d;</span>|md_set_left_right|
|<span class="nerdfont big">&#xf14e0;</span>|md_set_merge|
|<span class="nerdfont big">&#xf077e;</span>|md_set_none|
|<span class="nerdfont big">&#xf077f;</span>|md_set_right|
|<span class="nerdfont big">&#xf14e1;</span>|md_set_split|
|<span class="nerdfont big">&#xf145d;</span>|md_set_square|
|<span class="nerdfont big">&#xf099f;</span>|md_set_top_box|
|<span class="nerdfont big">&#xf0a6e;</span>|md_settings_helper|
|<span class="nerdfont big">&#xf110e;</span>|md_shaker|
|<span class="nerdfont big">&#xf110f;</span>|md_shaker_outline|
|<span class="nerdfont big">&#xf0831;</span>|md_shape|
|<span class="nerdfont big">&#xf065d;</span>|md_shape_circle_plus|
|<span class="nerdfont big">&#xf0832;</span>|md_shape_outline|
|<span class="nerdfont big">&#xf11fa;</span>|md_shape_oval_plus|
|<span class="nerdfont big">&#xf0495;</span>|md_shape_plus|
|<span class="nerdfont big">&#xf065e;</span>|md_shape_polygon_plus|
|<span class="nerdfont big">&#xf065f;</span>|md_shape_rectangle_plus|
|<span class="nerdfont big">&#xf0660;</span>|md_shape_square_plus|
|<span class="nerdfont big">&#xf14fa;</span>|md_shape_square_rounded_plus|
|<span class="nerdfont big">&#xf0496;</span>|md_share|
|<span class="nerdfont big">&#xf11f4;</span>|md_share_all|
|<span class="nerdfont big">&#xf11f5;</span>|md_share_all_outline|
|<span class="nerdfont big">&#xf11ad;</span>|md_share_circle|
|<span class="nerdfont big">&#xf0f23;</span>|md_share_off|
|<span class="nerdfont big">&#xf0f24;</span>|md_share_off_outline|
|<span class="nerdfont big">&#xf0932;</span>|md_share_outline|
|<span class="nerdfont big">&#xf0497;</span>|md_share_variant|
|<span class="nerdfont big">&#xf1514;</span>|md_share_variant_outline|
|<span class="nerdfont big">&#xf18ba;</span>|md_shark|
|<span class="nerdfont big">&#xf1673;</span>|md_shark_fin|
|<span class="nerdfont big">&#xf1674;</span>|md_shark_fin_outline|
|<span class="nerdfont big">&#xf18bb;</span>|md_shark_off|
|<span class="nerdfont big">&#xf0cc6;</span>|md_sheep|
|<span class="nerdfont big">&#xf0498;</span>|md_shield|
|<span class="nerdfont big">&#xf088f;</span>|md_shield_account|
|<span class="nerdfont big">&#xf0a12;</span>|md_shield_account_outline|
|<span class="nerdfont big">&#xf15a7;</span>|md_shield_account_variant|
|<span class="nerdfont big">&#xf15a8;</span>|md_shield_account_variant_outline|
|<span class="nerdfont big">&#xf06bb;</span>|md_shield_airplane|
|<span class="nerdfont big">&#xf0cc7;</span>|md_shield_airplane_outline|
|<span class="nerdfont big">&#xf0ecc;</span>|md_shield_alert|
|<span class="nerdfont big">&#xf0ecd;</span>|md_shield_alert_outline|
|<span class="nerdfont big">&#xf13da;</span>|md_shield_bug|
|<span class="nerdfont big">&#xf13db;</span>|md_shield_bug_outline|
|<span class="nerdfont big">&#xf0f83;</span>|md_shield_car|
|<span class="nerdfont big">&#xf0565;</span>|md_shield_check|
|<span class="nerdfont big">&#xf0cc8;</span>|md_shield_check_outline|
|<span class="nerdfont big">&#xf0cc9;</span>|md_shield_cross|
|<span class="nerdfont big">&#xf0cca;</span>|md_shield_cross_outline|
|<span class="nerdfont big">&#xf18bc;</span>|md_shield_crown|
|<span class="nerdfont big">&#xf18bd;</span>|md_shield_crown_outline|
|<span class="nerdfont big">&#xf11a0;</span>|md_shield_edit|
|<span class="nerdfont big">&#xf11a1;</span>|md_shield_edit_outline|
|<span class="nerdfont big">&#xf1360;</span>|md_shield_half|
|<span class="nerdfont big">&#xf0780;</span>|md_shield_half_full|
|<span class="nerdfont big">&#xf068a;</span>|md_shield_home|
|<span class="nerdfont big">&#xf0ccb;</span>|md_shield_home_outline|
|<span class="nerdfont big">&#xf0bc4;</span>|md_shield_key|
|<span class="nerdfont big">&#xf0bc5;</span>|md_shield_key_outline|
|<span class="nerdfont big">&#xf0d33;</span>|md_shield_link_variant|
|<span class="nerdfont big">&#xf0d34;</span>|md_shield_link_variant_outline|
|<span class="nerdfont big">&#xf099d;</span>|md_shield_lock|
|<span class="nerdfont big">&#xf199a;</span>|md_shield_lock_open|
|<span class="nerdfont big">&#xf199b;</span>|md_shield_lock_open_outline|
|<span class="nerdfont big">&#xf0ccc;</span>|md_shield_lock_outline|
|<span class="nerdfont big">&#xf1828;</span>|md_shield_moon|
|<span class="nerdfont big">&#xf1829;</span>|md_shield_moon_outline|
|<span class="nerdfont big">&#xf099e;</span>|md_shield_off|
|<span class="nerdfont big">&#xf099c;</span>|md_shield_off_outline|
|<span class="nerdfont big">&#xf0499;</span>|md_shield_outline|
|<span class="nerdfont big">&#xf0ada;</span>|md_shield_plus|
|<span class="nerdfont big">&#xf0adb;</span>|md_shield_plus_outline|
|<span class="nerdfont big">&#xf00aa;</span>|md_shield_refresh|
|<span class="nerdfont big">&#xf01e0;</span>|md_shield_refresh_outline|
|<span class="nerdfont big">&#xf0adc;</span>|md_shield_remove|
|<span class="nerdfont big">&#xf0add;</span>|md_shield_remove_outline|
|<span class="nerdfont big">&#xf0d9a;</span>|md_shield_search|
|<span class="nerdfont big">&#xf113b;</span>|md_shield_star|
|<span class="nerdfont big">&#xf113c;</span>|md_shield_star_outline|
|<span class="nerdfont big">&#xf105d;</span>|md_shield_sun|
|<span class="nerdfont big">&#xf105e;</span>|md_shield_sun_outline|
|<span class="nerdfont big">&#xf18be;</span>|md_shield_sword|
|<span class="nerdfont big">&#xf18bf;</span>|md_shield_sword_outline|
|<span class="nerdfont big">&#xf11a2;</span>|md_shield_sync|
|<span class="nerdfont big">&#xf11a3;</span>|md_shield_sync_outline|
|<span class="nerdfont big">&#xf1545;</span>|md_shimmer|
|<span class="nerdfont big">&#xf0833;</span>|md_ship_wheel|
|<span class="nerdfont big">&#xf184e;</span>|md_shipping_pallet|
|<span class="nerdfont big">&#xf15ca;</span>|md_shoe_ballet|
|<span class="nerdfont big">&#xf15c7;</span>|md_shoe_cleat|
|<span class="nerdfont big">&#xf0b47;</span>|md_shoe_formal|
|<span class="nerdfont big">&#xf0b48;</span>|md_shoe_heel|
|<span class="nerdfont big">&#xf0dfa;</span>|md_shoe_print|
|<span class="nerdfont big">&#xf15c8;</span>|md_shoe_sneaker|
|<span class="nerdfont big">&#xf049a;</span>|md_shopping|
|<span class="nerdfont big">&#xf049b;</span>|md_shopping_music|
|<span class="nerdfont big">&#xf11d5;</span>|md_shopping_outline|
|<span class="nerdfont big">&#xf0f84;</span>|md_shopping_search|
|<span class="nerdfont big">&#xf1a6f;</span>|md_shopping_search_outline|
|<span class="nerdfont big">&#xf14f9;</span>|md_shore|
|<span class="nerdfont big">&#xf0710;</span>|md_shovel|
|<span class="nerdfont big">&#xf0711;</span>|md_shovel_off|
|<span class="nerdfont big">&#xf09a0;</span>|md_shower|
|<span class="nerdfont big">&#xf09a1;</span>|md_shower_head|
|<span class="nerdfont big">&#xf049c;</span>|md_shredder|
|<span class="nerdfont big">&#xf049d;</span>|md_shuffle|
|<span class="nerdfont big">&#xf049e;</span>|md_shuffle_disabled|
|<span class="nerdfont big">&#xf049f;</span>|md_shuffle_variant|
|<span class="nerdfont big">&#xf137f;</span>|md_shuriken|
|<span class="nerdfont big">&#xf18c0;</span>|md_sickle|
|<span class="nerdfont big">&#xf04a0;</span>|md_sigma|
|<span class="nerdfont big">&#xf062b;</span>|md_sigma_lower|
|<span class="nerdfont big">&#xf04a1;</span>|md_sign_caution|
|<span class="nerdfont big">&#xf0781;</span>|md_sign_direction|
|<span class="nerdfont big">&#xf1000;</span>|md_sign_direction_minus|
|<span class="nerdfont big">&#xf0fdc;</span>|md_sign_direction_plus|
|<span class="nerdfont big">&#xf0fdd;</span>|md_sign_direction_remove|
|<span class="nerdfont big">&#xf14f8;</span>|md_sign_pole|
|<span class="nerdfont big">&#xf1118;</span>|md_sign_real_estate|
|<span class="nerdfont big">&#xf0782;</span>|md_sign_text|
|<span class="nerdfont big">&#xf04a2;</span>|md_signal|
|<span class="nerdfont big">&#xf0712;</span>|md_signal_2g|
|<span class="nerdfont big">&#xf0713;</span>|md_signal_3g|
|<span class="nerdfont big">&#xf0714;</span>|md_signal_4g|
|<span class="nerdfont big">&#xf0a6f;</span>|md_signal_5g|
|<span class="nerdfont big">&#xf08bc;</span>|md_signal_cellular_1|
|<span class="nerdfont big">&#xf08bd;</span>|md_signal_cellular_2|
|<span class="nerdfont big">&#xf08be;</span>|md_signal_cellular_3|
|<span class="nerdfont big">&#xf08bf;</span>|md_signal_cellular_outline|
|<span class="nerdfont big">&#xf0e64;</span>|md_signal_distance_variant|
|<span class="nerdfont big">&#xf0715;</span>|md_signal_hspa|
|<span class="nerdfont big">&#xf0716;</span>|md_signal_hspa_plus|
|<span class="nerdfont big">&#xf0783;</span>|md_signal_off|
|<span class="nerdfont big">&#xf060a;</span>|md_signal_variant|
|<span class="nerdfont big">&#xf0dfb;</span>|md_signature|
|<span class="nerdfont big">&#xf0dfc;</span>|md_signature_freehand|
|<span class="nerdfont big">&#xf0dfd;</span>|md_signature_image|
|<span class="nerdfont big">&#xf0dfe;</span>|md_signature_text|
|<span class="nerdfont big">&#xf0b49;</span>|md_silo|
|<span class="nerdfont big">&#xf04a3;</span>|md_silverware|
|<span class="nerdfont big">&#xf0fde;</span>|md_silverware_clean|
|<span class="nerdfont big">&#xf04a4;</span>|md_silverware_fork|
|<span class="nerdfont big">&#xf0a70;</span>|md_silverware_fork_knife|
|<span class="nerdfont big">&#xf04a5;</span>|md_silverware_spoon|
|<span class="nerdfont big">&#xf04a6;</span>|md_silverware_variant|
|<span class="nerdfont big">&#xf04a7;</span>|md_sim|
|<span class="nerdfont big">&#xf04a8;</span>|md_sim_alert|
|<span class="nerdfont big">&#xf15d3;</span>|md_sim_alert_outline|
|<span class="nerdfont big">&#xf04a9;</span>|md_sim_off|
|<span class="nerdfont big">&#xf15d4;</span>|md_sim_off_outline|
|<span class="nerdfont big">&#xf15d5;</span>|md_sim_outline|
|<span class="nerdfont big">&#xf131d;</span>|md_simple_icons|
|<span class="nerdfont big">&#xf0adf;</span>|md_sina_weibo|
|<span class="nerdfont big">&#xf095b;</span>|md_sine_wave|
|<span class="nerdfont big">&#xf04aa;</span>|md_sitemap|
|<span class="nerdfont big">&#xf199c;</span>|md_sitemap_outline|
|<span class="nerdfont big">&#xf13a5;</span>|md_size_m|
|<span class="nerdfont big">&#xf13a4;</span>|md_size_s|
|<span class="nerdfont big">&#xf13a7;</span>|md_size_xl|
|<span class="nerdfont big">&#xf13a3;</span>|md_size_xs|
|<span class="nerdfont big">&#xf13a8;</span>|md_size_xxl|
|<span class="nerdfont big">&#xf13a2;</span>|md_size_xxs|
|<span class="nerdfont big">&#xf13a9;</span>|md_size_xxxl|
|<span class="nerdfont big">&#xf0d35;</span>|md_skate|
|<span class="nerdfont big">&#xf0699;</span>|md_skate_off|
|<span class="nerdfont big">&#xf14c2;</span>|md_skateboard|
|<span class="nerdfont big">&#xf0501;</span>|md_skateboarding|
|<span class="nerdfont big">&#xf0d36;</span>|md_skew_less|
|<span class="nerdfont big">&#xf0d37;</span>|md_skew_more|
|<span class="nerdfont big">&#xf1304;</span>|md_ski|
|<span class="nerdfont big">&#xf1305;</span>|md_ski_cross_country|
|<span class="nerdfont big">&#xf1306;</span>|md_ski_water|
|<span class="nerdfont big">&#xf04ab;</span>|md_skip_backward|
|<span class="nerdfont big">&#xf0f25;</span>|md_skip_backward_outline|
|<span class="nerdfont big">&#xf04ac;</span>|md_skip_forward|
|<span class="nerdfont big">&#xf0f26;</span>|md_skip_forward_outline|
|<span class="nerdfont big">&#xf04ad;</span>|md_skip_next|
|<span class="nerdfont big">&#xf0661;</span>|md_skip_next_circle|
|<span class="nerdfont big">&#xf0662;</span>|md_skip_next_circle_outline|
|<span class="nerdfont big">&#xf0f27;</span>|md_skip_next_outline|
|<span class="nerdfont big">&#xf04ae;</span>|md_skip_previous|
|<span class="nerdfont big">&#xf0663;</span>|md_skip_previous_circle|
|<span class="nerdfont big">&#xf0664;</span>|md_skip_previous_circle_outline|
|<span class="nerdfont big">&#xf0f28;</span>|md_skip_previous_outline|
|<span class="nerdfont big">&#xf068c;</span>|md_skull|
|<span class="nerdfont big">&#xf0bc6;</span>|md_skull_crossbones|
|<span class="nerdfont big">&#xf0bc7;</span>|md_skull_crossbones_outline|
|<span class="nerdfont big">&#xf0bc8;</span>|md_skull_outline|
|<span class="nerdfont big">&#xf14c7;</span>|md_skull_scan|
|<span class="nerdfont big">&#xf14c8;</span>|md_skull_scan_outline|
|<span class="nerdfont big">&#xf04af;</span>|md_skype|
|<span class="nerdfont big">&#xf04b0;</span>|md_skype_business|
|<span class="nerdfont big">&#xf04b1;</span>|md_slack|
|<span class="nerdfont big">&#xf0fdf;</span>|md_slash_forward|
|<span class="nerdfont big">&#xf0fe0;</span>|md_slash_forward_box|
|<span class="nerdfont big">&#xf041b;</span>|md_sledding|
|<span class="nerdfont big">&#xf04b2;</span>|md_sleep|
|<span class="nerdfont big">&#xf04b3;</span>|md_sleep_off|
|<span class="nerdfont big">&#xf15a5;</span>|md_slide|
|<span class="nerdfont big">&#xf0dff;</span>|md_slope_downhill|
|<span class="nerdfont big">&#xf0e00;</span>|md_slope_uphill|
|<span class="nerdfont big">&#xf1114;</span>|md_slot_machine|
|<span class="nerdfont big">&#xf1115;</span>|md_slot_machine_outline|
|<span class="nerdfont big">&#xf10bd;</span>|md_smart_card|
|<span class="nerdfont big">&#xf18f7;</span>|md_smart_card_off|
|<span class="nerdfont big">&#xf18f8;</span>|md_smart_card_off_outline|
|<span class="nerdfont big">&#xf10be;</span>|md_smart_card_outline|
|<span class="nerdfont big">&#xf10bf;</span>|md_smart_card_reader|
|<span class="nerdfont big">&#xf10c0;</span>|md_smart_card_reader_outline|
|<span class="nerdfont big">&#xf0a71;</span>|md_smog|
|<span class="nerdfont big">&#xf1799;</span>|md_smoke|
|<span class="nerdfont big">&#xf0392;</span>|md_smoke_detector|
|<span class="nerdfont big">&#xf192e;</span>|md_smoke_detector_alert|
|<span class="nerdfont big">&#xf192f;</span>|md_smoke_detector_alert_outline|
|<span class="nerdfont big">&#xf1809;</span>|md_smoke_detector_off|
|<span class="nerdfont big">&#xf180a;</span>|md_smoke_detector_off_outline|
|<span class="nerdfont big">&#xf1808;</span>|md_smoke_detector_outline|
|<span class="nerdfont big">&#xf180b;</span>|md_smoke_detector_variant|
|<span class="nerdfont big">&#xf1930;</span>|md_smoke_detector_variant_alert|
|<span class="nerdfont big">&#xf180c;</span>|md_smoke_detector_variant_off|
|<span class="nerdfont big">&#xf04b4;</span>|md_smoking|
|<span class="nerdfont big">&#xf04b5;</span>|md_smoking_off|
|<span class="nerdfont big">&#xf140d;</span>|md_smoking_pipe|
|<span class="nerdfont big">&#xf1428;</span>|md_smoking_pipe_off|
|<span class="nerdfont big">&#xf1677;</span>|md_snail|
|<span class="nerdfont big">&#xf150e;</span>|md_snake|
|<span class="nerdfont big">&#xf04b6;</span>|md_snapchat|
|<span class="nerdfont big">&#xf1307;</span>|md_snowboard|
|<span class="nerdfont big">&#xf0717;</span>|md_snowflake|
|<span class="nerdfont big">&#xf0f29;</span>|md_snowflake_alert|
|<span class="nerdfont big">&#xf1a70;</span>|md_snowflake_check|
|<span class="nerdfont big">&#xf12cb;</span>|md_snowflake_melt|
|<span class="nerdfont big">&#xf14e3;</span>|md_snowflake_off|
|<span class="nerdfont big">&#xf1a71;</span>|md_snowflake_thermometer|
|<span class="nerdfont big">&#xf0f2a;</span>|md_snowflake_variant|
|<span class="nerdfont big">&#xf04b7;</span>|md_snowman|
|<span class="nerdfont big">&#xf06dd;</span>|md_snowmobile|
|<span class="nerdfont big">&#xf1a72;</span>|md_snowshoeing|
|<span class="nerdfont big">&#xf04b8;</span>|md_soccer|
|<span class="nerdfont big">&#xf0834;</span>|md_soccer_field|
|<span class="nerdfont big">&#xf1579;</span>|md_social_distance_2_meters|
|<span class="nerdfont big">&#xf157a;</span>|md_social_distance_6_feet|
|<span class="nerdfont big">&#xf04b9;</span>|md_sofa|
|<span class="nerdfont big">&#xf156d;</span>|md_sofa_outline|
|<span class="nerdfont big">&#xf156e;</span>|md_sofa_single|
|<span class="nerdfont big">&#xf156f;</span>|md_sofa_single_outline|
|<span class="nerdfont big">&#xf0d9b;</span>|md_solar_panel|
|<span class="nerdfont big">&#xf0d9c;</span>|md_solar_panel_large|
|<span class="nerdfont big">&#xf0a72;</span>|md_solar_power|
|<span class="nerdfont big">&#xf1a73;</span>|md_solar_power_variant|
|<span class="nerdfont big">&#xf1a74;</span>|md_solar_power_variant_outline|
|<span class="nerdfont big">&#xf1092;</span>|md_soldering_iron|
|<span class="nerdfont big">&#xf068d;</span>|md_solid|
|<span class="nerdfont big">&#xf0414;</span>|md_sony_playstation|
|<span class="nerdfont big">&#xf04ba;</span>|md_sort|
|<span class="nerdfont big">&#xf05bd;</span>|md_sort_alphabetical_ascending|
|<span class="nerdfont big">&#xf1148;</span>|md_sort_alphabetical_ascending_variant|
|<span class="nerdfont big">&#xf05bf;</span>|md_sort_alphabetical_descending|
|<span class="nerdfont big">&#xf1149;</span>|md_sort_alphabetical_descending_variant|
|<span class="nerdfont big">&#xf04bb;</span>|md_sort_alphabetical_variant|
|<span class="nerdfont big">&#xf04bc;</span>|md_sort_ascending|
|<span class="nerdfont big">&#xf1385;</span>|md_sort_bool_ascending|
|<span class="nerdfont big">&#xf1386;</span>|md_sort_bool_ascending_variant|
|<span class="nerdfont big">&#xf1387;</span>|md_sort_bool_descending|
|<span class="nerdfont big">&#xf1388;</span>|md_sort_bool_descending_variant|
|<span class="nerdfont big">&#xf1547;</span>|md_sort_calendar_ascending|
|<span class="nerdfont big">&#xf1548;</span>|md_sort_calendar_descending|
|<span class="nerdfont big">&#xf1549;</span>|md_sort_clock_ascending|
|<span class="nerdfont big">&#xf154a;</span>|md_sort_clock_ascending_outline|
|<span class="nerdfont big">&#xf154b;</span>|md_sort_clock_descending|
|<span class="nerdfont big">&#xf154c;</span>|md_sort_clock_descending_outline|
|<span class="nerdfont big">&#xf04bd;</span>|md_sort_descending|
|<span class="nerdfont big">&#xf1389;</span>|md_sort_numeric_ascending|
|<span class="nerdfont big">&#xf090d;</span>|md_sort_numeric_ascending_variant|
|<span class="nerdfont big">&#xf138a;</span>|md_sort_numeric_descending|
|<span class="nerdfont big">&#xf0ad2;</span>|md_sort_numeric_descending_variant|
|<span class="nerdfont big">&#xf04be;</span>|md_sort_numeric_variant|
|<span class="nerdfont big">&#xf033c;</span>|md_sort_reverse_variant|
|<span class="nerdfont big">&#xf04bf;</span>|md_sort_variant|
|<span class="nerdfont big">&#xf0ccd;</span>|md_sort_variant_lock|
|<span class="nerdfont big">&#xf0cce;</span>|md_sort_variant_lock_open|
|<span class="nerdfont big">&#xf1abb;</span>|md_sort_variant_off|
|<span class="nerdfont big">&#xf1147;</span>|md_sort_variant_remove|
|<span class="nerdfont big">&#xf17db;</span>|md_soundbar|
|<span class="nerdfont big">&#xf04c0;</span>|md_soundcloud|
|<span class="nerdfont big">&#xf062c;</span>|md_source_branch|
|<span class="nerdfont big">&#xf14cf;</span>|md_source_branch_check|
|<span class="nerdfont big">&#xf14cb;</span>|md_source_branch_minus|
|<span class="nerdfont big">&#xf14ca;</span>|md_source_branch_plus|
|<span class="nerdfont big">&#xf14cd;</span>|md_source_branch_refresh|
|<span class="nerdfont big">&#xf14cc;</span>|md_source_branch_remove|
|<span class="nerdfont big">&#xf14ce;</span>|md_source_branch_sync|
|<span class="nerdfont big">&#xf0718;</span>|md_source_commit|
|<span class="nerdfont big">&#xf0719;</span>|md_source_commit_end|
|<span class="nerdfont big">&#xf071a;</span>|md_source_commit_end_local|
|<span class="nerdfont big">&#xf071b;</span>|md_source_commit_local|
|<span class="nerdfont big">&#xf071c;</span>|md_source_commit_next_local|
|<span class="nerdfont big">&#xf071d;</span>|md_source_commit_start|
|<span class="nerdfont big">&#xf071e;</span>|md_source_commit_start_next_local|
|<span class="nerdfont big">&#xf04c1;</span>|md_source_fork|
|<span class="nerdfont big">&#xf062d;</span>|md_source_merge|
|<span class="nerdfont big">&#xf04c2;</span>|md_source_pull|
|<span class="nerdfont big">&#xf0ccf;</span>|md_source_repository|
|<span class="nerdfont big">&#xf0cd0;</span>|md_source_repository_multiple|
|<span class="nerdfont big">&#xf07ee;</span>|md_soy_sauce|
|<span class="nerdfont big">&#xf13fc;</span>|md_soy_sauce_off|
|<span class="nerdfont big">&#xf0cd1;</span>|md_spa|
|<span class="nerdfont big">&#xf0cd2;</span>|md_spa_outline|
|<span class="nerdfont big">&#xf0bc9;</span>|md_space_invaders|
|<span class="nerdfont big">&#xf1383;</span>|md_space_station|
|<span class="nerdfont big">&#xf0e65;</span>|md_spade|
|<span class="nerdfont big">&#xf04c3;</span>|md_speaker|
|<span class="nerdfont big">&#xf09a2;</span>|md_speaker_bluetooth|
|<span class="nerdfont big">&#xf0d38;</span>|md_speaker_multiple|
|<span class="nerdfont big">&#xf04c4;</span>|md_speaker_off|
|<span class="nerdfont big">&#xf071f;</span>|md_speaker_wireless|
|<span class="nerdfont big">&#xf1845;</span>|md_spear|
|<span class="nerdfont big">&#xf04c5;</span>|md_speedometer|
|<span class="nerdfont big">&#xf0f85;</span>|md_speedometer_medium|
|<span class="nerdfont big">&#xf0f86;</span>|md_speedometer_slow|
|<span class="nerdfont big">&#xf04c6;</span>|md_spellcheck|
|<span class="nerdfont big">&#xf1954;</span>|md_sphere|
|<span class="nerdfont big">&#xf1955;</span>|md_sphere_off|
|<span class="nerdfont big">&#xf11ea;</span>|md_spider|
|<span class="nerdfont big">&#xf11eb;</span>|md_spider_thread|
|<span class="nerdfont big">&#xf0bca;</span>|md_spider_web|
|<span class="nerdfont big">&#xf14f1;</span>|md_spirit_level|
|<span class="nerdfont big">&#xf1429;</span>|md_spoon_sugar|
|<span class="nerdfont big">&#xf04c7;</span>|md_spotify|
|<span class="nerdfont big">&#xf04c8;</span>|md_spotlight|
|<span class="nerdfont big">&#xf04c9;</span>|md_spotlight_beam|
|<span class="nerdfont big">&#xf0665;</span>|md_spray|
|<span class="nerdfont big">&#xf0ae0;</span>|md_spray_bottle|
|<span class="nerdfont big">&#xf105f;</span>|md_sprinkler|
|<span class="nerdfont big">&#xf199d;</span>|md_sprinkler_fire|
|<span class="nerdfont big">&#xf1060;</span>|md_sprinkler_variant|
|<span class="nerdfont big">&#xf0e66;</span>|md_sprout|
|<span class="nerdfont big">&#xf0e67;</span>|md_sprout_outline|
|<span class="nerdfont big">&#xf0764;</span>|md_square|
|<span class="nerdfont big">&#xf1500;</span>|md_square_circle|
|<span class="nerdfont big">&#xf090c;</span>|md_square_edit_outline|
|<span class="nerdfont big">&#xf0a13;</span>|md_square_medium|
|<span class="nerdfont big">&#xf0a14;</span>|md_square_medium_outline|
|<span class="nerdfont big">&#xf12ee;</span>|md_square_off|
|<span class="nerdfont big">&#xf12ef;</span>|md_square_off_outline|
|<span class="nerdfont big">&#xf1854;</span>|md_square_opacity|
|<span class="nerdfont big">&#xf0763;</span>|md_square_outline|
|<span class="nerdfont big">&#xf0784;</span>|md_square_root|
|<span class="nerdfont big">&#xf09a3;</span>|md_square_root_box|
|<span class="nerdfont big">&#xf14fb;</span>|md_square_rounded|
|<span class="nerdfont big">&#xf1a07;</span>|md_square_rounded_badge|
|<span class="nerdfont big">&#xf1a08;</span>|md_square_rounded_badge_outline|
|<span class="nerdfont big">&#xf14fc;</span>|md_square_rounded_outline|
|<span class="nerdfont big">&#xf0a15;</span>|md_square_small|
|<span class="nerdfont big">&#xf147b;</span>|md_square_wave|
|<span class="nerdfont big">&#xf0ae1;</span>|md_squeegee|
|<span class="nerdfont big">&#xf08c0;</span>|md_ssh|
|<span class="nerdfont big">&#xf060b;</span>|md_stack_exchange|
|<span class="nerdfont big">&#xf04cc;</span>|md_stack_overflow|
|<span class="nerdfont big">&#xf0359;</span>|md_stackpath|
|<span class="nerdfont big">&#xf0ff9;</span>|md_stadium|
|<span class="nerdfont big">&#xf0720;</span>|md_stadium_variant|
|<span class="nerdfont big">&#xf04cd;</span>|md_stairs|
|<span class="nerdfont big">&#xf139e;</span>|md_stairs_box|
|<span class="nerdfont big">&#xf12be;</span>|md_stairs_down|
|<span class="nerdfont big">&#xf12bd;</span>|md_stairs_up|
|<span class="nerdfont big">&#xf0d39;</span>|md_stamper|
|<span class="nerdfont big">&#xf07ef;</span>|md_standard_definition|
|<span class="nerdfont big">&#xf04ce;</span>|md_star|
|<span class="nerdfont big">&#xf0a73;</span>|md_star_box|
|<span class="nerdfont big">&#xf1286;</span>|md_star_box_multiple|
|<span class="nerdfont big">&#xf1287;</span>|md_star_box_multiple_outline|
|<span class="nerdfont big">&#xf0a74;</span>|md_star_box_outline|
|<span class="nerdfont big">&#xf1566;</span>|md_star_check|
|<span class="nerdfont big">&#xf156a;</span>|md_star_check_outline|
|<span class="nerdfont big">&#xf04cf;</span>|md_star_circle|
|<span class="nerdfont big">&#xf09a4;</span>|md_star_circle_outline|
|<span class="nerdfont big">&#xf1668;</span>|md_star_cog|
|<span class="nerdfont big">&#xf1669;</span>|md_star_cog_outline|
|<span class="nerdfont big">&#xf0979;</span>|md_star_crescent|
|<span class="nerdfont big">&#xf097a;</span>|md_star_david|
|<span class="nerdfont big">&#xf09a5;</span>|md_star_face|
|<span class="nerdfont big">&#xf0ae2;</span>|md_star_four_points|
|<span class="nerdfont big">&#xf0ae3;</span>|md_star_four_points_outline|
|<span class="nerdfont big">&#xf0246;</span>|md_star_half|
|<span class="nerdfont big">&#xf04d0;</span>|md_star_half_full|
|<span class="nerdfont big">&#xf1564;</span>|md_star_minus|
|<span class="nerdfont big">&#xf1568;</span>|md_star_minus_outline|
|<span class="nerdfont big">&#xf04d1;</span>|md_star_off|
|<span class="nerdfont big">&#xf155b;</span>|md_star_off_outline|
|<span class="nerdfont big">&#xf04d2;</span>|md_star_outline|
|<span class="nerdfont big">&#xf1563;</span>|md_star_plus|
|<span class="nerdfont big">&#xf1567;</span>|md_star_plus_outline|
|<span class="nerdfont big">&#xf1565;</span>|md_star_remove|
|<span class="nerdfont big">&#xf1569;</span>|md_star_remove_outline|
|<span class="nerdfont big">&#xf166a;</span>|md_star_settings|
|<span class="nerdfont big">&#xf166b;</span>|md_star_settings_outline|
|<span class="nerdfont big">&#xf1741;</span>|md_star_shooting|
|<span class="nerdfont big">&#xf1742;</span>|md_star_shooting_outline|
|<span class="nerdfont big">&#xf0ae4;</span>|md_star_three_points|
|<span class="nerdfont big">&#xf0ae5;</span>|md_star_three_points_outline|
|<span class="nerdfont big">&#xf11ef;</span>|md_state_machine|
|<span class="nerdfont big">&#xf04d3;</span>|md_steam|
|<span class="nerdfont big">&#xf04d4;</span>|md_steering|
|<span class="nerdfont big">&#xf090e;</span>|md_steering_off|
|<span class="nerdfont big">&#xf04d5;</span>|md_step_backward|
|<span class="nerdfont big">&#xf04d6;</span>|md_step_backward_2|
|<span class="nerdfont big">&#xf04d7;</span>|md_step_forward|
|<span class="nerdfont big">&#xf04d8;</span>|md_step_forward_2|
|<span class="nerdfont big">&#xf04d9;</span>|md_stethoscope|
|<span class="nerdfont big">&#xf1364;</span>|md_sticker|
|<span class="nerdfont big">&#xf1365;</span>|md_sticker_alert|
|<span class="nerdfont big">&#xf1366;</span>|md_sticker_alert_outline|
|<span class="nerdfont big">&#xf1367;</span>|md_sticker_check|
|<span class="nerdfont big">&#xf1368;</span>|md_sticker_check_outline|
|<span class="nerdfont big">&#xf05d0;</span>|md_sticker_circle_outline|
|<span class="nerdfont big">&#xf0785;</span>|md_sticker_emoji|
|<span class="nerdfont big">&#xf1369;</span>|md_sticker_minus|
|<span class="nerdfont big">&#xf136a;</span>|md_sticker_minus_outline|
|<span class="nerdfont big">&#xf136b;</span>|md_sticker_outline|
|<span class="nerdfont big">&#xf136c;</span>|md_sticker_plus|
|<span class="nerdfont big">&#xf136d;</span>|md_sticker_plus_outline|
|<span class="nerdfont big">&#xf136e;</span>|md_sticker_remove|
|<span class="nerdfont big">&#xf136f;</span>|md_sticker_remove_outline|
|<span class="nerdfont big">&#xf178e;</span>|md_sticker_text|
|<span class="nerdfont big">&#xf178f;</span>|md_sticker_text_outline|
|<span class="nerdfont big">&#xf04da;</span>|md_stocking|
|<span class="nerdfont big">&#xf1093;</span>|md_stomach|
|<span class="nerdfont big">&#xf195d;</span>|md_stool|
|<span class="nerdfont big">&#xf195e;</span>|md_stool_outline|
|<span class="nerdfont big">&#xf04db;</span>|md_stop|
|<span class="nerdfont big">&#xf0666;</span>|md_stop_circle|
|<span class="nerdfont big">&#xf0667;</span>|md_stop_circle_outline|
|<span class="nerdfont big">&#xf1a75;</span>|md_storage_tank|
|<span class="nerdfont big">&#xf1a76;</span>|md_storage_tank_outline|
|<span class="nerdfont big">&#xf04dc;</span>|md_store|
|<span class="nerdfont big">&#xf04dd;</span>|md_store_24_hour|
|<span class="nerdfont big">&#xf18c1;</span>|md_store_alert|
|<span class="nerdfont big">&#xf18c2;</span>|md_store_alert_outline|
|<span class="nerdfont big">&#xf18c3;</span>|md_store_check|
|<span class="nerdfont big">&#xf18c4;</span>|md_store_check_outline|
|<span class="nerdfont big">&#xf18c5;</span>|md_store_clock|
|<span class="nerdfont big">&#xf18c6;</span>|md_store_clock_outline|
|<span class="nerdfont big">&#xf18c7;</span>|md_store_cog|
|<span class="nerdfont big">&#xf18c8;</span>|md_store_cog_outline|
|<span class="nerdfont big">&#xf18c9;</span>|md_store_edit|
|<span class="nerdfont big">&#xf18ca;</span>|md_store_edit_outline|
|<span class="nerdfont big">&#xf18cb;</span>|md_store_marker|
|<span class="nerdfont big">&#xf18cc;</span>|md_store_marker_outline|
|<span class="nerdfont big">&#xf165e;</span>|md_store_minus|
|<span class="nerdfont big">&#xf18cd;</span>|md_store_minus_outline|
|<span class="nerdfont big">&#xf18ce;</span>|md_store_off|
|<span class="nerdfont big">&#xf18cf;</span>|md_store_off_outline|
|<span class="nerdfont big">&#xf1361;</span>|md_store_outline|
|<span class="nerdfont big">&#xf165f;</span>|md_store_plus|
|<span class="nerdfont big">&#xf18d0;</span>|md_store_plus_outline|
|<span class="nerdfont big">&#xf1660;</span>|md_store_remove|
|<span class="nerdfont big">&#xf18d1;</span>|md_store_remove_outline|
|<span class="nerdfont big">&#xf18d2;</span>|md_store_search|
|<span class="nerdfont big">&#xf18d3;</span>|md_store_search_outline|
|<span class="nerdfont big">&#xf18d4;</span>|md_store_settings|
|<span class="nerdfont big">&#xf18d5;</span>|md_store_settings_outline|
|<span class="nerdfont big">&#xf07c7;</span>|md_storefront|
|<span class="nerdfont big">&#xf10c1;</span>|md_storefront_outline|
|<span class="nerdfont big">&#xf04de;</span>|md_stove|
|<span class="nerdfont big">&#xf11d6;</span>|md_strategy|
|<span class="nerdfont big">&#xf0f2b;</span>|md_stretch_to_page|
|<span class="nerdfont big">&#xf0f2c;</span>|md_stretch_to_page_outline|
|<span class="nerdfont big">&#xf12ba;</span>|md_string_lights|
|<span class="nerdfont big">&#xf12bb;</span>|md_string_lights_off|
|<span class="nerdfont big">&#xf060c;</span>|md_subdirectory_arrow_left|
|<span class="nerdfont big">&#xf060d;</span>|md_subdirectory_arrow_right|
|<span class="nerdfont big">&#xf156c;</span>|md_submarine|
|<span class="nerdfont big">&#xf0a16;</span>|md_subtitles|
|<span class="nerdfont big">&#xf0a17;</span>|md_subtitles_outline|
|<span class="nerdfont big">&#xf06ac;</span>|md_subway|
|<span class="nerdfont big">&#xf0d9d;</span>|md_subway_alert_variant|
|<span class="nerdfont big">&#xf04df;</span>|md_subway_variant|
|<span class="nerdfont big">&#xf0786;</span>|md_summit|
|<span class="nerdfont big">&#xf1a77;</span>|md_sun_clock|
|<span class="nerdfont big">&#xf1a78;</span>|md_sun_clock_outline|
|<span class="nerdfont big">&#xf19a5;</span>|md_sun_compass|
|<span class="nerdfont big">&#xf1796;</span>|md_sun_snowflake|
|<span class="nerdfont big">&#xf1a79;</span>|md_sun_snowflake_variant|
|<span class="nerdfont big">&#xf18d6;</span>|md_sun_thermometer|
|<span class="nerdfont big">&#xf18d7;</span>|md_sun_thermometer_outline|
|<span class="nerdfont big">&#xf17fe;</span>|md_sun_wireless|
|<span class="nerdfont big">&#xf17ff;</span>|md_sun_wireless_outline|
|<span class="nerdfont big">&#xf04e0;</span>|md_sunglasses|
|<span class="nerdfont big">&#xf1746;</span>|md_surfing|
|<span class="nerdfont big">&#xf05c5;</span>|md_surround_sound|
|<span class="nerdfont big">&#xf07f0;</span>|md_surround_sound_2_0|
|<span class="nerdfont big">&#xf1729;</span>|md_surround_sound_2_1|
|<span class="nerdfont big">&#xf07f1;</span>|md_surround_sound_3_1|
|<span class="nerdfont big">&#xf07f2;</span>|md_surround_sound_5_1|
|<span class="nerdfont big">&#xf172a;</span>|md_surround_sound_5_1_2|
|<span class="nerdfont big">&#xf07f3;</span>|md_surround_sound_7_1|
|<span class="nerdfont big">&#xf0721;</span>|md_svg|
|<span class="nerdfont big">&#xf04e1;</span>|md_swap_horizontal|
|<span class="nerdfont big">&#xf0bcd;</span>|md_swap_horizontal_bold|
|<span class="nerdfont big">&#xf0fe1;</span>|md_swap_horizontal_circle|
|<span class="nerdfont big">&#xf0fe2;</span>|md_swap_horizontal_circle_outline|
|<span class="nerdfont big">&#xf08c1;</span>|md_swap_horizontal_variant|
|<span class="nerdfont big">&#xf04e2;</span>|md_swap_vertical|
|<span class="nerdfont big">&#xf0bce;</span>|md_swap_vertical_bold|
|<span class="nerdfont big">&#xf0fe3;</span>|md_swap_vertical_circle|
|<span class="nerdfont big">&#xf0fe4;</span>|md_swap_vertical_circle_outline|
|<span class="nerdfont big">&#xf08c2;</span>|md_swap_vertical_variant|
|<span class="nerdfont big">&#xf04e3;</span>|md_swim|
|<span class="nerdfont big">&#xf04e4;</span>|md_switch|
|<span class="nerdfont big">&#xf04e5;</span>|md_sword|
|<span class="nerdfont big">&#xf0787;</span>|md_sword_cross|
|<span class="nerdfont big">&#xf1333;</span>|md_syllabary_hangul|
|<span class="nerdfont big">&#xf1334;</span>|md_syllabary_hiragana|
|<span class="nerdfont big">&#xf1335;</span>|md_syllabary_katakana|
|<span class="nerdfont big">&#xf1336;</span>|md_syllabary_katakana_halfwidth|
|<span class="nerdfont big">&#xf1501;</span>|md_symbol|
|<span class="nerdfont big">&#xf0ae6;</span>|md_symfony|
|<span class="nerdfont big">&#xf04e6;</span>|md_sync|
|<span class="nerdfont big">&#xf04e7;</span>|md_sync_alert|
|<span class="nerdfont big">&#xf1378;</span>|md_sync_circle|
|<span class="nerdfont big">&#xf04e8;</span>|md_sync_off|
|<span class="nerdfont big">&#xf04e9;</span>|md_tab|
|<span class="nerdfont big">&#xf0b4b;</span>|md_tab_minus|
|<span class="nerdfont big">&#xf075c;</span>|md_tab_plus|
|<span class="nerdfont big">&#xf0b4c;</span>|md_tab_remove|
|<span class="nerdfont big">&#xf199e;</span>|md_tab_search|
|<span class="nerdfont big">&#xf04ea;</span>|md_tab_unselected|
|<span class="nerdfont big">&#xf04eb;</span>|md_table|
|<span class="nerdfont big">&#xf13b9;</span>|md_table_account|
|<span class="nerdfont big">&#xf13ba;</span>|md_table_alert|
|<span class="nerdfont big">&#xf13bb;</span>|md_table_arrow_down|
|<span class="nerdfont big">&#xf13bc;</span>|md_table_arrow_left|
|<span class="nerdfont big">&#xf13bd;</span>|md_table_arrow_right|
|<span class="nerdfont big">&#xf13be;</span>|md_table_arrow_up|
|<span class="nerdfont big">&#xf0a18;</span>|md_table_border|
|<span class="nerdfont big">&#xf13bf;</span>|md_table_cancel|
|<span class="nerdfont big">&#xf1061;</span>|md_table_chair|
|<span class="nerdfont big">&#xf13c0;</span>|md_table_check|
|<span class="nerdfont big">&#xf13c1;</span>|md_table_clock|
|<span class="nerdfont big">&#xf13c2;</span>|md_table_cog|
|<span class="nerdfont big">&#xf0835;</span>|md_table_column|
|<span class="nerdfont big">&#xf04ec;</span>|md_table_column_plus_after|
|<span class="nerdfont big">&#xf04ed;</span>|md_table_column_plus_before|
|<span class="nerdfont big">&#xf04ee;</span>|md_table_column_remove|
|<span class="nerdfont big">&#xf04ef;</span>|md_table_column_width|
|<span class="nerdfont big">&#xf04f0;</span>|md_table_edit|
|<span class="nerdfont big">&#xf1094;</span>|md_table_eye|
|<span class="nerdfont big">&#xf13c3;</span>|md_table_eye_off|
|<span class="nerdfont big">&#xf05bc;</span>|md_table_furniture|
|<span class="nerdfont big">&#xf121d;</span>|md_table_headers_eye|
|<span class="nerdfont big">&#xf121e;</span>|md_table_headers_eye_off|
|<span class="nerdfont big">&#xf13c4;</span>|md_table_heart|
|<span class="nerdfont big">&#xf13c5;</span>|md_table_key|
|<span class="nerdfont big">&#xf04f1;</span>|md_table_large|
|<span class="nerdfont big">&#xf0f87;</span>|md_table_large_plus|
|<span class="nerdfont big">&#xf0f88;</span>|md_table_large_remove|
|<span class="nerdfont big">&#xf13c6;</span>|md_table_lock|
|<span class="nerdfont big">&#xf09a6;</span>|md_table_merge_cells|
|<span class="nerdfont big">&#xf13c7;</span>|md_table_minus|
|<span class="nerdfont big">&#xf13c8;</span>|md_table_multiple|
|<span class="nerdfont big">&#xf13c9;</span>|md_table_network|
|<span class="nerdfont big">&#xf0836;</span>|md_table_of_contents|
|<span class="nerdfont big">&#xf13ca;</span>|md_table_off|
|<span class="nerdfont big">&#xf1743;</span>|md_table_picnic|
|<span class="nerdfont big">&#xf183c;</span>|md_table_pivot|
|<span class="nerdfont big">&#xf0a75;</span>|md_table_plus|
|<span class="nerdfont big">&#xf13a0;</span>|md_table_refresh|
|<span class="nerdfont big">&#xf0a76;</span>|md_table_remove|
|<span class="nerdfont big">&#xf0837;</span>|md_table_row|
|<span class="nerdfont big">&#xf04f2;</span>|md_table_row_height|
|<span class="nerdfont big">&#xf04f3;</span>|md_table_row_plus_after|
|<span class="nerdfont big">&#xf04f4;</span>|md_table_row_plus_before|
|<span class="nerdfont big">&#xf04f5;</span>|md_table_row_remove|
|<span class="nerdfont big">&#xf090f;</span>|md_table_search|
|<span class="nerdfont big">&#xf0838;</span>|md_table_settings|
|<span class="nerdfont big">&#xf142a;</span>|md_table_split_cell|
|<span class="nerdfont big">&#xf13cb;</span>|md_table_star|
|<span class="nerdfont big">&#xf13a1;</span>|md_table_sync|
|<span class="nerdfont big">&#xf0e68;</span>|md_table_tennis|
|<span class="nerdfont big">&#xf04f6;</span>|md_tablet|
|<span class="nerdfont big">&#xf04f7;</span>|md_tablet_android|
|<span class="nerdfont big">&#xf09a7;</span>|md_tablet_cellphone|
|<span class="nerdfont big">&#xf0ece;</span>|md_tablet_dashboard|
|<span class="nerdfont big">&#xf0762;</span>|md_taco|
|<span class="nerdfont big">&#xf04f9;</span>|md_tag|
|<span class="nerdfont big">&#xf172b;</span>|md_tag_arrow_down|
|<span class="nerdfont big">&#xf172c;</span>|md_tag_arrow_down_outline|
|<span class="nerdfont big">&#xf172d;</span>|md_tag_arrow_left|
|<span class="nerdfont big">&#xf172e;</span>|md_tag_arrow_left_outline|
|<span class="nerdfont big">&#xf172f;</span>|md_tag_arrow_right|
|<span class="nerdfont big">&#xf1730;</span>|md_tag_arrow_right_outline|
|<span class="nerdfont big">&#xf1731;</span>|md_tag_arrow_up|
|<span class="nerdfont big">&#xf1732;</span>|md_tag_arrow_up_outline|
|<span class="nerdfont big">&#xf1a7a;</span>|md_tag_check|
|<span class="nerdfont big">&#xf1a7b;</span>|md_tag_check_outline|
|<span class="nerdfont big">&#xf04fa;</span>|md_tag_faces|
|<span class="nerdfont big">&#xf068b;</span>|md_tag_heart|
|<span class="nerdfont big">&#xf0bcf;</span>|md_tag_heart_outline|
|<span class="nerdfont big">&#xf0910;</span>|md_tag_minus|
|<span class="nerdfont big">&#xf121f;</span>|md_tag_minus_outline|
|<span class="nerdfont big">&#xf04fb;</span>|md_tag_multiple|
|<span class="nerdfont big">&#xf12f7;</span>|md_tag_multiple_outline|
|<span class="nerdfont big">&#xf1220;</span>|md_tag_off|
|<span class="nerdfont big">&#xf1221;</span>|md_tag_off_outline|
|<span class="nerdfont big">&#xf04fc;</span>|md_tag_outline|
|<span class="nerdfont big">&#xf0722;</span>|md_tag_plus|
|<span class="nerdfont big">&#xf1222;</span>|md_tag_plus_outline|
|<span class="nerdfont big">&#xf0723;</span>|md_tag_remove|
|<span class="nerdfont big">&#xf1223;</span>|md_tag_remove_outline|
|<span class="nerdfont big">&#xf1907;</span>|md_tag_search|
|<span class="nerdfont big">&#xf1908;</span>|md_tag_search_outline|
|<span class="nerdfont big">&#xf1224;</span>|md_tag_text|
|<span class="nerdfont big">&#xf04fd;</span>|md_tag_text_outline|
|<span class="nerdfont big">&#xf13ff;</span>|md_tailwind|
|<span class="nerdfont big">&#xf1abc;</span>|md_tally_mark_1|
|<span class="nerdfont big">&#xf1abd;</span>|md_tally_mark_2|
|<span class="nerdfont big">&#xf1abe;</span>|md_tally_mark_3|
|<span class="nerdfont big">&#xf1abf;</span>|md_tally_mark_4|
|<span class="nerdfont big">&#xf1ac0;</span>|md_tally_mark_5|
|<span class="nerdfont big">&#xf04f8;</span>|md_tangram|
|<span class="nerdfont big">&#xf0d3a;</span>|md_tank|
|<span class="nerdfont big">&#xf0fe5;</span>|md_tanker_truck|
|<span class="nerdfont big">&#xf16df;</span>|md_tape_drive|
|<span class="nerdfont big">&#xf0b4d;</span>|md_tape_measure|
|<span class="nerdfont big">&#xf04fe;</span>|md_target|
|<span class="nerdfont big">&#xf0bd0;</span>|md_target_account|
|<span class="nerdfont big">&#xf0a77;</span>|md_target_variant|
|<span class="nerdfont big">&#xf04ff;</span>|md_taxi|
|<span class="nerdfont big">&#xf0d9e;</span>|md_tea|
|<span class="nerdfont big">&#xf0d9f;</span>|md_tea_outline|
|<span class="nerdfont big">&#xf0500;</span>|md_teamviewer|
|<span class="nerdfont big">&#xf18fb;</span>|md_teddy_bear|
|<span class="nerdfont big">&#xf0b4e;</span>|md_telescope|
|<span class="nerdfont big">&#xf0502;</span>|md_television|
|<span class="nerdfont big">&#xf1356;</span>|md_television_ambient_light|
|<span class="nerdfont big">&#xf0839;</span>|md_television_box|
|<span class="nerdfont big">&#xf07f4;</span>|md_television_classic|
|<span class="nerdfont big">&#xf083a;</span>|md_television_classic_off|
|<span class="nerdfont big">&#xf0503;</span>|md_television_guide|
|<span class="nerdfont big">&#xf083b;</span>|md_television_off|
|<span class="nerdfont big">&#xf0f89;</span>|md_television_pause|
|<span class="nerdfont big">&#xf0ecf;</span>|md_television_play|
|<span class="nerdfont big">&#xf1110;</span>|md_television_shimmer|
|<span class="nerdfont big">&#xf0f8a;</span>|md_television_stop|
|<span class="nerdfont big">&#xf0504;</span>|md_temperature_celsius|
|<span class="nerdfont big">&#xf0505;</span>|md_temperature_fahrenheit|
|<span class="nerdfont big">&#xf0506;</span>|md_temperature_kelvin|
|<span class="nerdfont big">&#xf0da0;</span>|md_tennis|
|<span class="nerdfont big">&#xf0507;</span>|md_tennis_ball|
|<span class="nerdfont big">&#xf0508;</span>|md_tent|
|<span class="nerdfont big">&#xf1062;</span>|md_terraform|
|<span class="nerdfont big">&#xf0668;</span>|md_test_tube|
|<span class="nerdfont big">&#xf0911;</span>|md_test_tube_empty|
|<span class="nerdfont big">&#xf0912;</span>|md_test_tube_off|
|<span class="nerdfont big">&#xf09a8;</span>|md_text|
|<span class="nerdfont big">&#xf1570;</span>|md_text_account|
|<span class="nerdfont big">&#xf021a;</span>|md_text_box|
|<span class="nerdfont big">&#xf0ea6;</span>|md_text_box_check|
|<span class="nerdfont big">&#xf0ea7;</span>|md_text_box_check_outline|
|<span class="nerdfont big">&#xf1a7c;</span>|md_text_box_edit|
|<span class="nerdfont big">&#xf1a7d;</span>|md_text_box_edit_outline|
|<span class="nerdfont big">&#xf0ea8;</span>|md_text_box_minus|
|<span class="nerdfont big">&#xf0ea9;</span>|md_text_box_minus_outline|
|<span class="nerdfont big">&#xf0ab7;</span>|md_text_box_multiple|
|<span class="nerdfont big">&#xf0ab8;</span>|md_text_box_multiple_outline|
|<span class="nerdfont big">&#xf09ed;</span>|md_text_box_outline|
|<span class="nerdfont big">&#xf0eaa;</span>|md_text_box_plus|
|<span class="nerdfont big">&#xf0eab;</span>|md_text_box_plus_outline|
|<span class="nerdfont big">&#xf0eac;</span>|md_text_box_remove|
|<span class="nerdfont big">&#xf0ead;</span>|md_text_box_remove_outline|
|<span class="nerdfont big">&#xf0eae;</span>|md_text_box_search|
|<span class="nerdfont big">&#xf0eaf;</span>|md_text_box_search_outline|
|<span class="nerdfont big">&#xf09aa;</span>|md_text_long|
|<span class="nerdfont big">&#xf113d;</span>|md_text_recognition|
|<span class="nerdfont big">&#xf13b8;</span>|md_text_search|
|<span class="nerdfont big">&#xf1a7e;</span>|md_text_search_variant|
|<span class="nerdfont big">&#xf0669;</span>|md_text_shadow|
|<span class="nerdfont big">&#xf09a9;</span>|md_text_short|
|<span class="nerdfont big">&#xf050a;</span>|md_text_to_speech|
|<span class="nerdfont big">&#xf050b;</span>|md_text_to_speech_off|
|<span class="nerdfont big">&#xf050c;</span>|md_texture|
|<span class="nerdfont big">&#xf0fe6;</span>|md_texture_box|
|<span class="nerdfont big">&#xf050d;</span>|md_theater|
|<span class="nerdfont big">&#xf050e;</span>|md_theme_light_dark|
|<span class="nerdfont big">&#xf050f;</span>|md_thermometer|
|<span class="nerdfont big">&#xf0e01;</span>|md_thermometer_alert|
|<span class="nerdfont big">&#xf1895;</span>|md_thermometer_bluetooth|
|<span class="nerdfont big">&#xf1a7f;</span>|md_thermometer_check|
|<span class="nerdfont big">&#xf0e02;</span>|md_thermometer_chevron_down|
|<span class="nerdfont big">&#xf0e03;</span>|md_thermometer_chevron_up|
|<span class="nerdfont big">&#xf10c2;</span>|md_thermometer_high|
|<span class="nerdfont big">&#xf0510;</span>|md_thermometer_lines|
|<span class="nerdfont big">&#xf10c3;</span>|md_thermometer_low|
|<span class="nerdfont big">&#xf0e04;</span>|md_thermometer_minus|
|<span class="nerdfont big">&#xf1531;</span>|md_thermometer_off|
|<span class="nerdfont big">&#xf0e05;</span>|md_thermometer_plus|
|<span class="nerdfont big">&#xf1a80;</span>|md_thermometer_water|
|<span class="nerdfont big">&#xf0393;</span>|md_thermostat|
|<span class="nerdfont big">&#xf0891;</span>|md_thermostat_box|
|<span class="nerdfont big">&#xf07f6;</span>|md_thought_bubble|
|<span class="nerdfont big">&#xf07f7;</span>|md_thought_bubble_outline|
|<span class="nerdfont big">&#xf0511;</span>|md_thumb_down|
|<span class="nerdfont big">&#xf0512;</span>|md_thumb_down_outline|
|<span class="nerdfont big">&#xf0513;</span>|md_thumb_up|
|<span class="nerdfont big">&#xf0514;</span>|md_thumb_up_outline|
|<span class="nerdfont big">&#xf0515;</span>|md_thumbs_up_down|
|<span class="nerdfont big">&#xf1914;</span>|md_thumbs_up_down_outline|
|<span class="nerdfont big">&#xf0516;</span>|md_ticket|
|<span class="nerdfont big">&#xf0517;</span>|md_ticket_account|
|<span class="nerdfont big">&#xf0518;</span>|md_ticket_confirmation|
|<span class="nerdfont big">&#xf13aa;</span>|md_ticket_confirmation_outline|
|<span class="nerdfont big">&#xf0913;</span>|md_ticket_outline|
|<span class="nerdfont big">&#xf0724;</span>|md_ticket_percent|
|<span class="nerdfont big">&#xf142b;</span>|md_ticket_percent_outline|
|<span class="nerdfont big">&#xf0519;</span>|md_tie|
|<span class="nerdfont big">&#xf0725;</span>|md_tilde|
|<span class="nerdfont big">&#xf18f3;</span>|md_tilde_off|
|<span class="nerdfont big">&#xf051a;</span>|md_timelapse|
|<span class="nerdfont big">&#xf0bd1;</span>|md_timeline|
|<span class="nerdfont big">&#xf0f95;</span>|md_timeline_alert|
|<span class="nerdfont big">&#xf0f98;</span>|md_timeline_alert_outline|
|<span class="nerdfont big">&#xf1532;</span>|md_timeline_check|
|<span class="nerdfont big">&#xf1533;</span>|md_timeline_check_outline|
|<span class="nerdfont big">&#xf11fb;</span>|md_timeline_clock|
|<span class="nerdfont big">&#xf11fc;</span>|md_timeline_clock_outline|
|<span class="nerdfont big">&#xf0f99;</span>|md_timeline_help|
|<span class="nerdfont big">&#xf0f9a;</span>|md_timeline_help_outline|
|<span class="nerdfont big">&#xf1534;</span>|md_timeline_minus|
|<span class="nerdfont big">&#xf1535;</span>|md_timeline_minus_outline|
|<span class="nerdfont big">&#xf0bd2;</span>|md_timeline_outline|
|<span class="nerdfont big">&#xf0f96;</span>|md_timeline_plus|
|<span class="nerdfont big">&#xf0f97;</span>|md_timeline_plus_outline|
|<span class="nerdfont big">&#xf1536;</span>|md_timeline_remove|
|<span class="nerdfont big">&#xf1537;</span>|md_timeline_remove_outline|
|<span class="nerdfont big">&#xf0bd3;</span>|md_timeline_text|
|<span class="nerdfont big">&#xf0bd4;</span>|md_timeline_text_outline|
|<span class="nerdfont big">&#xf13ab;</span>|md_timer|
|<span class="nerdfont big">&#xf051d;</span>|md_timer_3|
|<span class="nerdfont big">&#xf051c;</span>|md_timer_10|
|<span class="nerdfont big">&#xf1acc;</span>|md_timer_alert|
|<span class="nerdfont big">&#xf1acd;</span>|md_timer_alert_outline|
|<span class="nerdfont big">&#xf1ace;</span>|md_timer_cancel|
|<span class="nerdfont big">&#xf1acf;</span>|md_timer_cancel_outline|
|<span class="nerdfont big">&#xf1ad0;</span>|md_timer_check|
|<span class="nerdfont big">&#xf1ad1;</span>|md_timer_check_outline|
|<span class="nerdfont big">&#xf1925;</span>|md_timer_cog|
|<span class="nerdfont big">&#xf1926;</span>|md_timer_cog_outline|
|<span class="nerdfont big">&#xf1ad2;</span>|md_timer_edit|
|<span class="nerdfont big">&#xf1ad3;</span>|md_timer_edit_outline|
|<span class="nerdfont big">&#xf1ad4;</span>|md_timer_lock|
|<span class="nerdfont big">&#xf1ad5;</span>|md_timer_lock_open|
|<span class="nerdfont big">&#xf1ad6;</span>|md_timer_lock_open_outline|
|<span class="nerdfont big">&#xf1ad7;</span>|md_timer_lock_outline|
|<span class="nerdfont big">&#xf1ad8;</span>|md_timer_marker|
|<span class="nerdfont big">&#xf1ad9;</span>|md_timer_marker_outline|
|<span class="nerdfont big">&#xf1ada;</span>|md_timer_minus|
|<span class="nerdfont big">&#xf1adb;</span>|md_timer_minus_outline|
|<span class="nerdfont big">&#xf1adc;</span>|md_timer_music|
|<span class="nerdfont big">&#xf1add;</span>|md_timer_music_outline|
|<span class="nerdfont big">&#xf13ac;</span>|md_timer_off|
|<span class="nerdfont big">&#xf051e;</span>|md_timer_off_outline|
|<span class="nerdfont big">&#xf051b;</span>|md_timer_outline|
|<span class="nerdfont big">&#xf1ade;</span>|md_timer_pause|
|<span class="nerdfont big">&#xf1adf;</span>|md_timer_pause_outline|
|<span class="nerdfont big">&#xf1ae0;</span>|md_timer_play|
|<span class="nerdfont big">&#xf1ae1;</span>|md_timer_play_outline|
|<span class="nerdfont big">&#xf1ae2;</span>|md_timer_plus|
|<span class="nerdfont big">&#xf1ae3;</span>|md_timer_plus_outline|
|<span class="nerdfont big">&#xf1ae4;</span>|md_timer_refresh|
|<span class="nerdfont big">&#xf1ae5;</span>|md_timer_refresh_outline|
|<span class="nerdfont big">&#xf1ae6;</span>|md_timer_remove|
|<span class="nerdfont big">&#xf1ae7;</span>|md_timer_remove_outline|
|<span class="nerdfont big">&#xf051f;</span>|md_timer_sand|
|<span class="nerdfont big">&#xf199f;</span>|md_timer_sand_complete|
|<span class="nerdfont big">&#xf06ad;</span>|md_timer_sand_empty|
|<span class="nerdfont big">&#xf078c;</span>|md_timer_sand_full|
|<span class="nerdfont big">&#xf19a0;</span>|md_timer_sand_paused|
|<span class="nerdfont big">&#xf1923;</span>|md_timer_settings|
|<span class="nerdfont big">&#xf1924;</span>|md_timer_settings_outline|
|<span class="nerdfont big">&#xf1ae8;</span>|md_timer_star|
|<span class="nerdfont big">&#xf1ae9;</span>|md_timer_star_outline|
|<span class="nerdfont big">&#xf1aea;</span>|md_timer_stop|
|<span class="nerdfont big">&#xf1aeb;</span>|md_timer_stop_outline|
|<span class="nerdfont big">&#xf1aec;</span>|md_timer_sync|
|<span class="nerdfont big">&#xf1aed;</span>|md_timer_sync_outline|
|<span class="nerdfont big">&#xf0520;</span>|md_timetable|
|<span class="nerdfont big">&#xf1896;</span>|md_tire|
|<span class="nerdfont big">&#xf1063;</span>|md_toaster|
|<span class="nerdfont big">&#xf11b7;</span>|md_toaster_off|
|<span class="nerdfont big">&#xf0cd3;</span>|md_toaster_oven|
|<span class="nerdfont big">&#xf0521;</span>|md_toggle_switch|
|<span class="nerdfont big">&#xf0522;</span>|md_toggle_switch_off|
|<span class="nerdfont big">&#xf0a19;</span>|md_toggle_switch_off_outline|
|<span class="nerdfont big">&#xf0a1a;</span>|md_toggle_switch_outline|
|<span class="nerdfont big">&#xf1a25;</span>|md_toggle_switch_variant|
|<span class="nerdfont big">&#xf1a26;</span>|md_toggle_switch_variant_off|
|<span class="nerdfont big">&#xf09ab;</span>|md_toilet|
|<span class="nerdfont big">&#xf09ac;</span>|md_toolbox|
|<span class="nerdfont big">&#xf09ad;</span>|md_toolbox_outline|
|<span class="nerdfont big">&#xf1064;</span>|md_tools|
|<span class="nerdfont big">&#xf0523;</span>|md_tooltip|
|<span class="nerdfont big">&#xf000c;</span>|md_tooltip_account|
|<span class="nerdfont big">&#xf183b;</span>|md_tooltip_cellphone|
|<span class="nerdfont big">&#xf155c;</span>|md_tooltip_check|
|<span class="nerdfont big">&#xf155d;</span>|md_tooltip_check_outline|
|<span class="nerdfont big">&#xf0524;</span>|md_tooltip_edit|
|<span class="nerdfont big">&#xf12c5;</span>|md_tooltip_edit_outline|
|<span class="nerdfont big">&#xf0525;</span>|md_tooltip_image|
|<span class="nerdfont big">&#xf0bd5;</span>|md_tooltip_image_outline|
|<span class="nerdfont big">&#xf155e;</span>|md_tooltip_minus|
|<span class="nerdfont big">&#xf155f;</span>|md_tooltip_minus_outline|
|<span class="nerdfont big">&#xf0526;</span>|md_tooltip_outline|
|<span class="nerdfont big">&#xf0bd6;</span>|md_tooltip_plus|
|<span class="nerdfont big">&#xf0527;</span>|md_tooltip_plus_outline|
|<span class="nerdfont big">&#xf1560;</span>|md_tooltip_remove|
|<span class="nerdfont big">&#xf1561;</span>|md_tooltip_remove_outline|
|<span class="nerdfont big">&#xf0528;</span>|md_tooltip_text|
|<span class="nerdfont big">&#xf0bd7;</span>|md_tooltip_text_outline|
|<span class="nerdfont big">&#xf08c3;</span>|md_tooth|
|<span class="nerdfont big">&#xf0529;</span>|md_tooth_outline|
|<span class="nerdfont big">&#xf1129;</span>|md_toothbrush|
|<span class="nerdfont big">&#xf112c;</span>|md_toothbrush_electric|
|<span class="nerdfont big">&#xf112a;</span>|md_toothbrush_paste|
|<span class="nerdfont big">&#xf1606;</span>|md_torch|
|<span class="nerdfont big">&#xf0d3b;</span>|md_tortoise|
|<span class="nerdfont big">&#xf12b8;</span>|md_toslink|
|<span class="nerdfont big">&#xf09ae;</span>|md_tournament|
|<span class="nerdfont big">&#xf083c;</span>|md_tow_truck|
|<span class="nerdfont big">&#xf0681;</span>|md_tower_beach|
|<span class="nerdfont big">&#xf0682;</span>|md_tower_fire|
|<span class="nerdfont big">&#xf1875;</span>|md_town_hall|
|<span class="nerdfont big">&#xf1288;</span>|md_toy_brick|
|<span class="nerdfont big">&#xf1289;</span>|md_toy_brick_marker|
|<span class="nerdfont big">&#xf128a;</span>|md_toy_brick_marker_outline|
|<span class="nerdfont big">&#xf128b;</span>|md_toy_brick_minus|
|<span class="nerdfont big">&#xf128c;</span>|md_toy_brick_minus_outline|
|<span class="nerdfont big">&#xf128d;</span>|md_toy_brick_outline|
|<span class="nerdfont big">&#xf128e;</span>|md_toy_brick_plus|
|<span class="nerdfont big">&#xf128f;</span>|md_toy_brick_plus_outline|
|<span class="nerdfont big">&#xf1290;</span>|md_toy_brick_remove|
|<span class="nerdfont big">&#xf1291;</span>|md_toy_brick_remove_outline|
|<span class="nerdfont big">&#xf1292;</span>|md_toy_brick_search|
|<span class="nerdfont big">&#xf1293;</span>|md_toy_brick_search_outline|
|<span class="nerdfont big">&#xf0914;</span>|md_track_light|
|<span class="nerdfont big">&#xf07f8;</span>|md_trackpad|
|<span class="nerdfont big">&#xf0933;</span>|md_trackpad_lock|
|<span class="nerdfont big">&#xf0892;</span>|md_tractor|
|<span class="nerdfont big">&#xf14c4;</span>|md_tractor_variant|
|<span class="nerdfont big">&#xf0a78;</span>|md_trademark|
|<span class="nerdfont big">&#xf137c;</span>|md_traffic_cone|
|<span class="nerdfont big">&#xf052b;</span>|md_traffic_light|
|<span class="nerdfont big">&#xf182a;</span>|md_traffic_light_outline|
|<span class="nerdfont big">&#xf052c;</span>|md_train|
|<span class="nerdfont big">&#xf0bd8;</span>|md_train_car|
|<span class="nerdfont big">&#xf1733;</span>|md_train_car_passenger|
|<span class="nerdfont big">&#xf1734;</span>|md_train_car_passenger_door|
|<span class="nerdfont big">&#xf1735;</span>|md_train_car_passenger_door_open|
|<span class="nerdfont big">&#xf1736;</span>|md_train_car_passenger_variant|
|<span class="nerdfont big">&#xf08c4;</span>|md_train_variant|
|<span class="nerdfont big">&#xf052d;</span>|md_tram|
|<span class="nerdfont big">&#xf0fe7;</span>|md_tram_side|
|<span class="nerdfont big">&#xf052e;</span>|md_transcribe|
|<span class="nerdfont big">&#xf052f;</span>|md_transcribe_close|
|<span class="nerdfont big">&#xf1065;</span>|md_transfer|
|<span class="nerdfont big">&#xf0da1;</span>|md_transfer_down|
|<span class="nerdfont big">&#xf0da2;</span>|md_transfer_left|
|<span class="nerdfont big">&#xf0530;</span>|md_transfer_right|
|<span class="nerdfont big">&#xf0da3;</span>|md_transfer_up|
|<span class="nerdfont big">&#xf0d3c;</span>|md_transit_connection|
|<span class="nerdfont big">&#xf1546;</span>|md_transit_connection_horizontal|
|<span class="nerdfont big">&#xf0d3d;</span>|md_transit_connection_variant|
|<span class="nerdfont big">&#xf0f8b;</span>|md_transit_detour|
|<span class="nerdfont big">&#xf1515;</span>|md_transit_skip|
|<span class="nerdfont big">&#xf06ae;</span>|md_transit_transfer|
|<span class="nerdfont big">&#xf0915;</span>|md_transition|
|<span class="nerdfont big">&#xf0916;</span>|md_transition_masked|
|<span class="nerdfont big">&#xf05ca;</span>|md_translate|
|<span class="nerdfont big">&#xf0e06;</span>|md_translate_off|
|<span class="nerdfont big">&#xf0d3e;</span>|md_transmission_tower|
|<span class="nerdfont big">&#xf192c;</span>|md_transmission_tower_export|
|<span class="nerdfont big">&#xf192d;</span>|md_transmission_tower_import|
|<span class="nerdfont big">&#xf19dd;</span>|md_transmission_tower_off|
|<span class="nerdfont big">&#xf0a79;</span>|md_trash_can|
|<span class="nerdfont big">&#xf0a7a;</span>|md_trash_can_outline|
|<span class="nerdfont big">&#xf1294;</span>|md_tray|
|<span class="nerdfont big">&#xf1295;</span>|md_tray_alert|
|<span class="nerdfont big">&#xf0120;</span>|md_tray_arrow_down|
|<span class="nerdfont big">&#xf011d;</span>|md_tray_arrow_up|
|<span class="nerdfont big">&#xf1296;</span>|md_tray_full|
|<span class="nerdfont big">&#xf1297;</span>|md_tray_minus|
|<span class="nerdfont big">&#xf1298;</span>|md_tray_plus|
|<span class="nerdfont big">&#xf1299;</span>|md_tray_remove|
|<span class="nerdfont big">&#xf0726;</span>|md_treasure_chest|
|<span class="nerdfont big">&#xf0531;</span>|md_tree|
|<span class="nerdfont big">&#xf0e69;</span>|md_tree_outline|
|<span class="nerdfont big">&#xf0532;</span>|md_trello|
|<span class="nerdfont big">&#xf0533;</span>|md_trending_down|
|<span class="nerdfont big">&#xf0534;</span>|md_trending_neutral|
|<span class="nerdfont big">&#xf0535;</span>|md_trending_up|
|<span class="nerdfont big">&#xf0536;</span>|md_triangle|
|<span class="nerdfont big">&#xf0537;</span>|md_triangle_outline|
|<span class="nerdfont big">&#xf1a09;</span>|md_triangle_small_down|
|<span class="nerdfont big">&#xf1a0a;</span>|md_triangle_small_up|
|<span class="nerdfont big">&#xf147c;</span>|md_triangle_wave|
|<span class="nerdfont big">&#xf0bd9;</span>|md_triforce|
|<span class="nerdfont big">&#xf0538;</span>|md_trophy|
|<span class="nerdfont big">&#xf0539;</span>|md_trophy_award|
|<span class="nerdfont big">&#xf0da4;</span>|md_trophy_broken|
|<span class="nerdfont big">&#xf053a;</span>|md_trophy_outline|
|<span class="nerdfont big">&#xf053b;</span>|md_trophy_variant|
|<span class="nerdfont big">&#xf053c;</span>|md_trophy_variant_outline|
|<span class="nerdfont big">&#xf053d;</span>|md_truck|
|<span class="nerdfont big">&#xf19de;</span>|md_truck_alert|
|<span class="nerdfont big">&#xf19df;</span>|md_truck_alert_outline|
|<span class="nerdfont big">&#xf18d8;</span>|md_truck_cargo_container|
|<span class="nerdfont big">&#xf0cd4;</span>|md_truck_check|
|<span class="nerdfont big">&#xf129a;</span>|md_truck_check_outline|
|<span class="nerdfont big">&#xf053e;</span>|md_truck_delivery|
|<span class="nerdfont big">&#xf129b;</span>|md_truck_delivery_outline|
|<span class="nerdfont big">&#xf0788;</span>|md_truck_fast|
|<span class="nerdfont big">&#xf129c;</span>|md_truck_fast_outline|
|<span class="nerdfont big">&#xf1891;</span>|md_truck_flatbed|
|<span class="nerdfont big">&#xf19ae;</span>|md_truck_minus|
|<span class="nerdfont big">&#xf19bd;</span>|md_truck_minus_outline|
|<span class="nerdfont big">&#xf129d;</span>|md_truck_outline|
|<span class="nerdfont big">&#xf19ad;</span>|md_truck_plus|
|<span class="nerdfont big">&#xf19bc;</span>|md_truck_plus_outline|
|<span class="nerdfont big">&#xf19af;</span>|md_truck_remove|
|<span class="nerdfont big">&#xf19be;</span>|md_truck_remove_outline|
|<span class="nerdfont big">&#xf19a6;</span>|md_truck_snowflake|
|<span class="nerdfont big">&#xf0727;</span>|md_truck_trailer|
|<span class="nerdfont big">&#xf1096;</span>|md_trumpet|
|<span class="nerdfont big">&#xf0a7b;</span>|md_tshirt_crew|
|<span class="nerdfont big">&#xf053f;</span>|md_tshirt_crew_outline|
|<span class="nerdfont big">&#xf0a7c;</span>|md_tshirt_v|
|<span class="nerdfont big">&#xf0540;</span>|md_tshirt_v_outline|
|<span class="nerdfont big">&#xf1a81;</span>|md_tsunami|
|<span class="nerdfont big">&#xf0917;</span>|md_tumble_dryer|
|<span class="nerdfont big">&#xf11ba;</span>|md_tumble_dryer_alert|
|<span class="nerdfont big">&#xf11bb;</span>|md_tumble_dryer_off|
|<span class="nerdfont big">&#xf062e;</span>|md_tune|
|<span class="nerdfont big">&#xf1542;</span>|md_tune_variant|
|<span class="nerdfont big">&#xf066a;</span>|md_tune_vertical|
|<span class="nerdfont big">&#xf1543;</span>|md_tune_vertical_variant|
|<span class="nerdfont big">&#xf183d;</span>|md_tunnel|
|<span class="nerdfont big">&#xf183e;</span>|md_tunnel_outline|
|<span class="nerdfont big">&#xf1a82;</span>|md_turbine|
|<span class="nerdfont big">&#xf171b;</span>|md_turkey|
|<span class="nerdfont big">&#xf0cd5;</span>|md_turnstile|
|<span class="nerdfont big">&#xf0cd6;</span>|md_turnstile_outline|
|<span class="nerdfont big">&#xf0cd7;</span>|md_turtle|
|<span class="nerdfont big">&#xf0543;</span>|md_twitch|
|<span class="nerdfont big">&#xf0544;</span>|md_twitter|
|<span class="nerdfont big">&#xf09af;</span>|md_two_factor_authentication|
|<span class="nerdfont big">&#xf0f2d;</span>|md_typewriter|
|<span class="nerdfont big">&#xf0bda;</span>|md_ubisoft|
|<span class="nerdfont big">&#xf0548;</span>|md_ubuntu|
|<span class="nerdfont big">&#xf10c4;</span>|md_ufo|
|<span class="nerdfont big">&#xf10c5;</span>|md_ufo_outline|
|<span class="nerdfont big">&#xf07f9;</span>|md_ultra_high_definition|
|<span class="nerdfont big">&#xf0549;</span>|md_umbraco|
|<span class="nerdfont big">&#xf054a;</span>|md_umbrella|
|<span class="nerdfont big">&#xf188a;</span>|md_umbrella_beach|
|<span class="nerdfont big">&#xf188b;</span>|md_umbrella_beach_outline|
|<span class="nerdfont big">&#xf09b0;</span>|md_umbrella_closed|
|<span class="nerdfont big">&#xf13e2;</span>|md_umbrella_closed_outline|
|<span class="nerdfont big">&#xf13e1;</span>|md_umbrella_closed_variant|
|<span class="nerdfont big">&#xf054b;</span>|md_umbrella_outline|
|<span class="nerdfont big">&#xf054c;</span>|md_undo|
|<span class="nerdfont big">&#xf054d;</span>|md_undo_variant|
|<span class="nerdfont big">&#xf054e;</span>|md_unfold_less_horizontal|
|<span class="nerdfont big">&#xf0760;</span>|md_unfold_less_vertical|
|<span class="nerdfont big">&#xf054f;</span>|md_unfold_more_horizontal|
|<span class="nerdfont big">&#xf0761;</span>|md_unfold_more_vertical|
|<span class="nerdfont big">&#xf0550;</span>|md_ungroup|
|<span class="nerdfont big">&#xf0ed0;</span>|md_unicode|
|<span class="nerdfont big">&#xf15c2;</span>|md_unicorn|
|<span class="nerdfont big">&#xf15c3;</span>|md_unicorn_variant|
|<span class="nerdfont big">&#xf15e5;</span>|md_unicycle|
|<span class="nerdfont big">&#xf06af;</span>|md_unity|
|<span class="nerdfont big">&#xf09b1;</span>|md_unreal|
|<span class="nerdfont big">&#xf06b0;</span>|md_update|
|<span class="nerdfont big">&#xf0552;</span>|md_upload|
|<span class="nerdfont big">&#xf1373;</span>|md_upload_lock|
|<span class="nerdfont big">&#xf1374;</span>|md_upload_lock_outline|
|<span class="nerdfont big">&#xf083d;</span>|md_upload_multiple|
|<span class="nerdfont big">&#xf06f6;</span>|md_upload_network|
|<span class="nerdfont big">&#xf0cd8;</span>|md_upload_network_outline|
|<span class="nerdfont big">&#xf10c6;</span>|md_upload_off|
|<span class="nerdfont big">&#xf10c7;</span>|md_upload_off_outline|
|<span class="nerdfont big">&#xf0e07;</span>|md_upload_outline|
|<span class="nerdfont big">&#xf0553;</span>|md_usb|
|<span class="nerdfont big">&#xf129e;</span>|md_usb_flash_drive|
|<span class="nerdfont big">&#xf129f;</span>|md_usb_flash_drive_outline|
|<span class="nerdfont big">&#xf11f0;</span>|md_usb_port|
|<span class="nerdfont big">&#xf19a1;</span>|md_vacuum|
|<span class="nerdfont big">&#xf19a2;</span>|md_vacuum_outline|
|<span class="nerdfont big">&#xf1066;</span>|md_valve|
|<span class="nerdfont big">&#xf1067;</span>|md_valve_closed|
|<span class="nerdfont big">&#xf1068;</span>|md_valve_open|
|<span class="nerdfont big">&#xf07fa;</span>|md_van_passenger|
|<span class="nerdfont big">&#xf07fb;</span>|md_van_utility|
|<span class="nerdfont big">&#xf07fc;</span>|md_vanish|
|<span class="nerdfont big">&#xf1554;</span>|md_vanish_quarter|
|<span class="nerdfont big">&#xf11e1;</span>|md_vanity_light|
|<span class="nerdfont big">&#xf0ae7;</span>|md_variable|
|<span class="nerdfont big">&#xf1111;</span>|md_variable_box|
|<span class="nerdfont big">&#xf0554;</span>|md_vector_arrange_above|
|<span class="nerdfont big">&#xf0555;</span>|md_vector_arrange_below|
|<span class="nerdfont big">&#xf0ae8;</span>|md_vector_bezier|
|<span class="nerdfont big">&#xf0556;</span>|md_vector_circle|
|<span class="nerdfont big">&#xf0557;</span>|md_vector_circle_variant|
|<span class="nerdfont big">&#xf0558;</span>|md_vector_combine|
|<span class="nerdfont big">&#xf0559;</span>|md_vector_curve|
|<span class="nerdfont big">&#xf055a;</span>|md_vector_difference|
|<span class="nerdfont big">&#xf055b;</span>|md_vector_difference_ab|
|<span class="nerdfont big">&#xf055c;</span>|md_vector_difference_ba|
|<span class="nerdfont big">&#xf0893;</span>|md_vector_ellipse|
|<span class="nerdfont big">&#xf055d;</span>|md_vector_intersection|
|<span class="nerdfont big">&#xf055e;</span>|md_vector_line|
|<span class="nerdfont big">&#xf0fe8;</span>|md_vector_link|
|<span class="nerdfont big">&#xf055f;</span>|md_vector_point|
|<span class="nerdfont big">&#xf0560;</span>|md_vector_polygon|
|<span class="nerdfont big">&#xf1856;</span>|md_vector_polygon_variant|
|<span class="nerdfont big">&#xf0561;</span>|md_vector_polyline|
|<span class="nerdfont big">&#xf1225;</span>|md_vector_polyline_edit|
|<span class="nerdfont big">&#xf1226;</span>|md_vector_polyline_minus|
|<span class="nerdfont big">&#xf1227;</span>|md_vector_polyline_plus|
|<span class="nerdfont big">&#xf1228;</span>|md_vector_polyline_remove|
|<span class="nerdfont big">&#xf074a;</span>|md_vector_radius|
|<span class="nerdfont big">&#xf05c6;</span>|md_vector_rectangle|
|<span class="nerdfont big">&#xf0562;</span>|md_vector_selection|
|<span class="nerdfont big">&#xf0001;</span>|md_vector_square|
|<span class="nerdfont big">&#xf1857;</span>|md_vector_square_close|
|<span class="nerdfont big">&#xf18d9;</span>|md_vector_square_edit|
|<span class="nerdfont big">&#xf18da;</span>|md_vector_square_minus|
|<span class="nerdfont big">&#xf1858;</span>|md_vector_square_open|
|<span class="nerdfont big">&#xf18db;</span>|md_vector_square_plus|
|<span class="nerdfont big">&#xf18dc;</span>|md_vector_square_remove|
|<span class="nerdfont big">&#xf0563;</span>|md_vector_triangle|
|<span class="nerdfont big">&#xf0564;</span>|md_vector_union|
|<span class="nerdfont big">&#xf0a1b;</span>|md_vhs|
|<span class="nerdfont big">&#xf0566;</span>|md_vibrate|
|<span class="nerdfont big">&#xf0cd9;</span>|md_vibrate_off|
|<span class="nerdfont big">&#xf0567;</span>|md_video|
|<span class="nerdfont big">&#xf1a1c;</span>|md_video_2d|
|<span class="nerdfont big">&#xf07fd;</span>|md_video_3d|
|<span class="nerdfont big">&#xf13d9;</span>|md_video_3d_off|
|<span class="nerdfont big">&#xf0ed1;</span>|md_video_3d_variant|
|<span class="nerdfont big">&#xf083e;</span>|md_video_4k_box|
|<span class="nerdfont big">&#xf0919;</span>|md_video_account|
|<span class="nerdfont big">&#xf00fd;</span>|md_video_box|
|<span class="nerdfont big">&#xf00fe;</span>|md_video_box_off|
|<span class="nerdfont big">&#xf1069;</span>|md_video_check|
|<span class="nerdfont big">&#xf106a;</span>|md_video_check_outline|
|<span class="nerdfont big">&#xf152e;</span>|md_video_high_definition|
|<span class="nerdfont big">&#xf091a;</span>|md_video_image|
|<span class="nerdfont big">&#xf083f;</span>|md_video_input_antenna|
|<span class="nerdfont big">&#xf0840;</span>|md_video_input_component|
|<span class="nerdfont big">&#xf0841;</span>|md_video_input_hdmi|
|<span class="nerdfont big">&#xf0f8c;</span>|md_video_input_scart|
|<span class="nerdfont big">&#xf0842;</span>|md_video_input_svideo|
|<span class="nerdfont big">&#xf19a9;</span>|md_video_marker|
|<span class="nerdfont big">&#xf19aa;</span>|md_video_marker_outline|
|<span class="nerdfont big">&#xf09b2;</span>|md_video_minus|
|<span class="nerdfont big">&#xf02ba;</span>|md_video_minus_outline|
|<span class="nerdfont big">&#xf0568;</span>|md_video_off|
|<span class="nerdfont big">&#xf0bdb;</span>|md_video_off_outline|
|<span class="nerdfont big">&#xf0bdc;</span>|md_video_outline|
|<span class="nerdfont big">&#xf09b3;</span>|md_video_plus|
|<span class="nerdfont big">&#xf01d3;</span>|md_video_plus_outline|
|<span class="nerdfont big">&#xf091b;</span>|md_video_stabilization|
|<span class="nerdfont big">&#xf0569;</span>|md_video_switch|
|<span class="nerdfont big">&#xf0790;</span>|md_video_switch_outline|
|<span class="nerdfont big">&#xf0a1c;</span>|md_video_vintage|
|<span class="nerdfont big">&#xf0ed2;</span>|md_video_wireless|
|<span class="nerdfont big">&#xf0ed3;</span>|md_video_wireless_outline|
|<span class="nerdfont big">&#xf056a;</span>|md_view_agenda|
|<span class="nerdfont big">&#xf11d8;</span>|md_view_agenda_outline|
|<span class="nerdfont big">&#xf056b;</span>|md_view_array|
|<span class="nerdfont big">&#xf1485;</span>|md_view_array_outline|
|<span class="nerdfont big">&#xf056c;</span>|md_view_carousel|
|<span class="nerdfont big">&#xf1486;</span>|md_view_carousel_outline|
|<span class="nerdfont big">&#xf056d;</span>|md_view_column|
|<span class="nerdfont big">&#xf1487;</span>|md_view_column_outline|
|<span class="nerdfont big">&#xf0e6a;</span>|md_view_comfy|
|<span class="nerdfont big">&#xf1488;</span>|md_view_comfy_outline|
|<span class="nerdfont big">&#xf0e6b;</span>|md_view_compact|
|<span class="nerdfont big">&#xf0e6c;</span>|md_view_compact_outline|
|<span class="nerdfont big">&#xf056e;</span>|md_view_dashboard|
|<span class="nerdfont big">&#xf1947;</span>|md_view_dashboard_edit|
|<span class="nerdfont big">&#xf1948;</span>|md_view_dashboard_edit_outline|
|<span class="nerdfont big">&#xf0a1d;</span>|md_view_dashboard_outline|
|<span class="nerdfont big">&#xf0843;</span>|md_view_dashboard_variant|
|<span class="nerdfont big">&#xf1489;</span>|md_view_dashboard_variant_outline|
|<span class="nerdfont big">&#xf056f;</span>|md_view_day|
|<span class="nerdfont big">&#xf148a;</span>|md_view_day_outline|
|<span class="nerdfont big">&#xf1888;</span>|md_view_gallery|
|<span class="nerdfont big">&#xf1889;</span>|md_view_gallery_outline|
|<span class="nerdfont big">&#xf0570;</span>|md_view_grid|
|<span class="nerdfont big">&#xf11d9;</span>|md_view_grid_outline|
|<span class="nerdfont big">&#xf0f8d;</span>|md_view_grid_plus|
|<span class="nerdfont big">&#xf11da;</span>|md_view_grid_plus_outline|
|<span class="nerdfont big">&#xf0571;</span>|md_view_headline|
|<span class="nerdfont big">&#xf0572;</span>|md_view_list|
|<span class="nerdfont big">&#xf148b;</span>|md_view_list_outline|
|<span class="nerdfont big">&#xf0573;</span>|md_view_module|
|<span class="nerdfont big">&#xf148c;</span>|md_view_module_outline|
|<span class="nerdfont big">&#xf0728;</span>|md_view_parallel|
|<span class="nerdfont big">&#xf148d;</span>|md_view_parallel_outline|
|<span class="nerdfont big">&#xf0574;</span>|md_view_quilt|
|<span class="nerdfont big">&#xf148e;</span>|md_view_quilt_outline|
|<span class="nerdfont big">&#xf0729;</span>|md_view_sequential|
|<span class="nerdfont big">&#xf148f;</span>|md_view_sequential_outline|
|<span class="nerdfont big">&#xf0bcb;</span>|md_view_split_horizontal|
|<span class="nerdfont big">&#xf0bcc;</span>|md_view_split_vertical|
|<span class="nerdfont big">&#xf0575;</span>|md_view_stream|
|<span class="nerdfont big">&#xf1490;</span>|md_view_stream_outline|
|<span class="nerdfont big">&#xf0576;</span>|md_view_week|
|<span class="nerdfont big">&#xf1491;</span>|md_view_week_outline|
|<span class="nerdfont big">&#xf0577;</span>|md_vimeo|
|<span class="nerdfont big">&#xf060f;</span>|md_violin|
|<span class="nerdfont big">&#xf0894;</span>|md_virtual_reality|
|<span class="nerdfont big">&#xf13b6;</span>|md_virus|
|<span class="nerdfont big">&#xf18e1;</span>|md_virus_off|
|<span class="nerdfont big">&#xf18e2;</span>|md_virus_off_outline|
|<span class="nerdfont big">&#xf13b7;</span>|md_virus_outline|
|<span class="nerdfont big">&#xf057c;</span>|md_vlc|
|<span class="nerdfont big">&#xf057d;</span>|md_voicemail|
|<span class="nerdfont big">&#xf1a83;</span>|md_volcano|
|<span class="nerdfont big">&#xf1a84;</span>|md_volcano_outline|
|<span class="nerdfont big">&#xf09b4;</span>|md_volleyball|
|<span class="nerdfont big">&#xf057e;</span>|md_volume_high|
|<span class="nerdfont big">&#xf057f;</span>|md_volume_low|
|<span class="nerdfont big">&#xf0580;</span>|md_volume_medium|
|<span class="nerdfont big">&#xf075e;</span>|md_volume_minus|
|<span class="nerdfont big">&#xf075f;</span>|md_volume_mute|
|<span class="nerdfont big">&#xf0581;</span>|md_volume_off|
|<span class="nerdfont big">&#xf075d;</span>|md_volume_plus|
|<span class="nerdfont big">&#xf1120;</span>|md_volume_source|
|<span class="nerdfont big">&#xf0e08;</span>|md_volume_variant_off|
|<span class="nerdfont big">&#xf1121;</span>|md_volume_vibrate|
|<span class="nerdfont big">&#xf0a1f;</span>|md_vote|
|<span class="nerdfont big">&#xf0a20;</span>|md_vote_outline|
|<span class="nerdfont big">&#xf0582;</span>|md_vpn|
|<span class="nerdfont big">&#xf0844;</span>|md_vuejs|
|<span class="nerdfont big">&#xf0e6d;</span>|md_vuetify|
|<span class="nerdfont big">&#xf0583;</span>|md_walk|
|<span class="nerdfont big">&#xf07fe;</span>|md_wall|
|<span class="nerdfont big">&#xf1a11;</span>|md_wall_fire|
|<span class="nerdfont big">&#xf091c;</span>|md_wall_sconce|
|<span class="nerdfont big">&#xf091d;</span>|md_wall_sconce_flat|
|<span class="nerdfont big">&#xf17c9;</span>|md_wall_sconce_flat_outline|
|<span class="nerdfont big">&#xf041c;</span>|md_wall_sconce_flat_variant|
|<span class="nerdfont big">&#xf17ca;</span>|md_wall_sconce_flat_variant_outline|
|<span class="nerdfont big">&#xf17cb;</span>|md_wall_sconce_outline|
|<span class="nerdfont big">&#xf0748;</span>|md_wall_sconce_round|
|<span class="nerdfont big">&#xf17cc;</span>|md_wall_sconce_round_outline|
|<span class="nerdfont big">&#xf091e;</span>|md_wall_sconce_round_variant|
|<span class="nerdfont big">&#xf17cd;</span>|md_wall_sconce_round_variant_outline|
|<span class="nerdfont big">&#xf0584;</span>|md_wallet|
|<span class="nerdfont big">&#xf0585;</span>|md_wallet_giftcard|
|<span class="nerdfont big">&#xf0586;</span>|md_wallet_membership|
|<span class="nerdfont big">&#xf0bdd;</span>|md_wallet_outline|
|<span class="nerdfont big">&#xf0f8e;</span>|md_wallet_plus|
|<span class="nerdfont big">&#xf0f8f;</span>|md_wallet_plus_outline|
|<span class="nerdfont big">&#xf0587;</span>|md_wallet_travel|
|<span class="nerdfont big">&#xf0e09;</span>|md_wallpaper|
|<span class="nerdfont big">&#xf0588;</span>|md_wan|
|<span class="nerdfont big">&#xf0f90;</span>|md_wardrobe|
|<span class="nerdfont big">&#xf0f91;</span>|md_wardrobe_outline|
|<span class="nerdfont big">&#xf0f81;</span>|md_warehouse|
|<span class="nerdfont big">&#xf072a;</span>|md_washing_machine|
|<span class="nerdfont big">&#xf11bc;</span>|md_washing_machine_alert|
|<span class="nerdfont big">&#xf11bd;</span>|md_washing_machine_off|
|<span class="nerdfont big">&#xf0589;</span>|md_watch|
|<span class="nerdfont big">&#xf058a;</span>|md_watch_export|
|<span class="nerdfont big">&#xf0895;</span>|md_watch_export_variant|
|<span class="nerdfont big">&#xf058b;</span>|md_watch_import|
|<span class="nerdfont big">&#xf0896;</span>|md_watch_import_variant|
|<span class="nerdfont big">&#xf0897;</span>|md_watch_variant|
|<span class="nerdfont big">&#xf06b1;</span>|md_watch_vibrate|
|<span class="nerdfont big">&#xf0cda;</span>|md_watch_vibrate_off|
|<span class="nerdfont big">&#xf058c;</span>|md_water|
|<span class="nerdfont big">&#xf1502;</span>|md_water_alert|
|<span class="nerdfont big">&#xf1503;</span>|md_water_alert_outline|
|<span class="nerdfont big">&#xf0f92;</span>|md_water_boiler|
|<span class="nerdfont big">&#xf11b3;</span>|md_water_boiler_alert|
|<span class="nerdfont big">&#xf11b4;</span>|md_water_boiler_off|
|<span class="nerdfont big">&#xf1504;</span>|md_water_check|
|<span class="nerdfont big">&#xf1505;</span>|md_water_check_outline|
|<span class="nerdfont big">&#xf1806;</span>|md_water_circle|
|<span class="nerdfont big">&#xf1506;</span>|md_water_minus|
|<span class="nerdfont big">&#xf1507;</span>|md_water_minus_outline|
|<span class="nerdfont big">&#xf058d;</span>|md_water_off|
|<span class="nerdfont big">&#xf1508;</span>|md_water_off_outline|
|<span class="nerdfont big">&#xf1855;</span>|md_water_opacity|
|<span class="nerdfont big">&#xf0e0a;</span>|md_water_outline|
|<span class="nerdfont big">&#xf058e;</span>|md_water_percent|
|<span class="nerdfont big">&#xf1509;</span>|md_water_percent_alert|
|<span class="nerdfont big">&#xf150a;</span>|md_water_plus|
|<span class="nerdfont big">&#xf150b;</span>|md_water_plus_outline|
|<span class="nerdfont big">&#xf12a0;</span>|md_water_polo|
|<span class="nerdfont big">&#xf058f;</span>|md_water_pump|
|<span class="nerdfont big">&#xf0f93;</span>|md_water_pump_off|
|<span class="nerdfont big">&#xf150c;</span>|md_water_remove|
|<span class="nerdfont big">&#xf150d;</span>|md_water_remove_outline|
|<span class="nerdfont big">&#xf17c6;</span>|md_water_sync|
|<span class="nerdfont big">&#xf1a85;</span>|md_water_thermometer|
|<span class="nerdfont big">&#xf1a86;</span>|md_water_thermometer_outline|
|<span class="nerdfont big">&#xf106b;</span>|md_water_well|
|<span class="nerdfont big">&#xf106c;</span>|md_water_well_outline|
|<span class="nerdfont big">&#xf1849;</span>|md_waterfall|
|<span class="nerdfont big">&#xf1481;</span>|md_watering_can|
|<span class="nerdfont big">&#xf1482;</span>|md_watering_can_outline|
|<span class="nerdfont big">&#xf0612;</span>|md_watermark|
|<span class="nerdfont big">&#xf0f2e;</span>|md_wave|
|<span class="nerdfont big">&#xf147d;</span>|md_waveform|
|<span class="nerdfont big">&#xf078d;</span>|md_waves|
|<span class="nerdfont big">&#xf1859;</span>|md_waves_arrow_left|
|<span class="nerdfont big">&#xf185a;</span>|md_waves_arrow_right|
|<span class="nerdfont big">&#xf185b;</span>|md_waves_arrow_up|
|<span class="nerdfont big">&#xf0bde;</span>|md_waze|
|<span class="nerdfont big">&#xf0590;</span>|md_weather_cloudy|
|<span class="nerdfont big">&#xf0f2f;</span>|md_weather_cloudy_alert|
|<span class="nerdfont big">&#xf0e6e;</span>|md_weather_cloudy_arrow_right|
|<span class="nerdfont big">&#xf18f6;</span>|md_weather_cloudy_clock|
|<span class="nerdfont big">&#xf0591;</span>|md_weather_fog|
|<span class="nerdfont big">&#xf0592;</span>|md_weather_hail|
|<span class="nerdfont big">&#xf0f30;</span>|md_weather_hazy|
|<span class="nerdfont big">&#xf0898;</span>|md_weather_hurricane|
|<span class="nerdfont big">&#xf0593;</span>|md_weather_lightning|
|<span class="nerdfont big">&#xf067e;</span>|md_weather_lightning_rainy|
|<span class="nerdfont big">&#xf0594;</span>|md_weather_night|
|<span class="nerdfont big">&#xf0f31;</span>|md_weather_night_partly_cloudy|
|<span class="nerdfont big">&#xf0595;</span>|md_weather_partly_cloudy|
|<span class="nerdfont big">&#xf0f32;</span>|md_weather_partly_lightning|
|<span class="nerdfont big">&#xf0f33;</span>|md_weather_partly_rainy|
|<span class="nerdfont big">&#xf0f34;</span>|md_weather_partly_snowy|
|<span class="nerdfont big">&#xf0f35;</span>|md_weather_partly_snowy_rainy|
|<span class="nerdfont big">&#xf0596;</span>|md_weather_pouring|
|<span class="nerdfont big">&#xf0597;</span>|md_weather_rainy|
|<span class="nerdfont big">&#xf0598;</span>|md_weather_snowy|
|<span class="nerdfont big">&#xf0f36;</span>|md_weather_snowy_heavy|
|<span class="nerdfont big">&#xf067f;</span>|md_weather_snowy_rainy|
|<span class="nerdfont big">&#xf0599;</span>|md_weather_sunny|
|<span class="nerdfont big">&#xf0f37;</span>|md_weather_sunny_alert|
|<span class="nerdfont big">&#xf14e4;</span>|md_weather_sunny_off|
|<span class="nerdfont big">&#xf059a;</span>|md_weather_sunset|
|<span class="nerdfont big">&#xf059b;</span>|md_weather_sunset_down|
|<span class="nerdfont big">&#xf059c;</span>|md_weather_sunset_up|
|<span class="nerdfont big">&#xf0f38;</span>|md_weather_tornado|
|<span class="nerdfont big">&#xf059d;</span>|md_weather_windy|
|<span class="nerdfont big">&#xf059e;</span>|md_weather_windy_variant|
|<span class="nerdfont big">&#xf059f;</span>|md_web|
|<span class="nerdfont big">&#xf0f94;</span>|md_web_box|
|<span class="nerdfont big">&#xf1790;</span>|md_web_cancel|
|<span class="nerdfont big">&#xf0789;</span>|md_web_check|
|<span class="nerdfont big">&#xf124a;</span>|md_web_clock|
|<span class="nerdfont big">&#xf10a0;</span>|md_web_minus|
|<span class="nerdfont big">&#xf0a8e;</span>|md_web_off|
|<span class="nerdfont big">&#xf0033;</span>|md_web_plus|
|<span class="nerdfont big">&#xf1791;</span>|md_web_refresh|
|<span class="nerdfont big">&#xf0551;</span>|md_web_remove|
|<span class="nerdfont big">&#xf1792;</span>|md_web_sync|
|<span class="nerdfont big">&#xf05a0;</span>|md_webcam|
|<span class="nerdfont big">&#xf1737;</span>|md_webcam_off|
|<span class="nerdfont big">&#xf062f;</span>|md_webhook|
|<span class="nerdfont big">&#xf072b;</span>|md_webpack|
|<span class="nerdfont big">&#xf1248;</span>|md_webrtc|
|<span class="nerdfont big">&#xf0611;</span>|md_wechat|
|<span class="nerdfont big">&#xf05a1;</span>|md_weight|
|<span class="nerdfont big">&#xf0d3f;</span>|md_weight_gram|
|<span class="nerdfont big">&#xf05a2;</span>|md_weight_kilogram|
|<span class="nerdfont big">&#xf115d;</span>|md_weight_lifter|
|<span class="nerdfont big">&#xf09b5;</span>|md_weight_pound|
|<span class="nerdfont big">&#xf05a3;</span>|md_whatsapp|
|<span class="nerdfont big">&#xf14f2;</span>|md_wheel_barrow|
|<span class="nerdfont big">&#xf1a87;</span>|md_wheelchair|
|<span class="nerdfont big">&#xf05a4;</span>|md_wheelchair_accessibility|
|<span class="nerdfont big">&#xf09b6;</span>|md_whistle|
|<span class="nerdfont big">&#xf12bc;</span>|md_whistle_outline|
|<span class="nerdfont big">&#xf05a5;</span>|md_white_balance_auto|
|<span class="nerdfont big">&#xf05a6;</span>|md_white_balance_incandescent|
|<span class="nerdfont big">&#xf05a7;</span>|md_white_balance_iridescent|
|<span class="nerdfont big">&#xf05a8;</span>|md_white_balance_sunny|
|<span class="nerdfont big">&#xf072c;</span>|md_widgets|
|<span class="nerdfont big">&#xf1355;</span>|md_widgets_outline|
|<span class="nerdfont big">&#xf05a9;</span>|md_wifi|
|<span class="nerdfont big">&#xf16b5;</span>|md_wifi_alert|
|<span class="nerdfont big">&#xf16b6;</span>|md_wifi_arrow_down|
|<span class="nerdfont big">&#xf16b7;</span>|md_wifi_arrow_left|
|<span class="nerdfont big">&#xf16b8;</span>|md_wifi_arrow_left_right|
|<span class="nerdfont big">&#xf16b9;</span>|md_wifi_arrow_right|
|<span class="nerdfont big">&#xf16ba;</span>|md_wifi_arrow_up|
|<span class="nerdfont big">&#xf16bb;</span>|md_wifi_arrow_up_down|
|<span class="nerdfont big">&#xf16bc;</span>|md_wifi_cancel|
|<span class="nerdfont big">&#xf16bd;</span>|md_wifi_check|
|<span class="nerdfont big">&#xf16be;</span>|md_wifi_cog|
|<span class="nerdfont big">&#xf16bf;</span>|md_wifi_lock|
|<span class="nerdfont big">&#xf16c0;</span>|md_wifi_lock_open|
|<span class="nerdfont big">&#xf16c1;</span>|md_wifi_marker|
|<span class="nerdfont big">&#xf16c2;</span>|md_wifi_minus|
|<span class="nerdfont big">&#xf05aa;</span>|md_wifi_off|
|<span class="nerdfont big">&#xf16c3;</span>|md_wifi_plus|
|<span class="nerdfont big">&#xf16c4;</span>|md_wifi_refresh|
|<span class="nerdfont big">&#xf16c5;</span>|md_wifi_remove|
|<span class="nerdfont big">&#xf16c6;</span>|md_wifi_settings|
|<span class="nerdfont big">&#xf0e0b;</span>|md_wifi_star|
|<span class="nerdfont big">&#xf091f;</span>|md_wifi_strength_1|
|<span class="nerdfont big">&#xf0920;</span>|md_wifi_strength_1_alert|
|<span class="nerdfont big">&#xf0921;</span>|md_wifi_strength_1_lock|
|<span class="nerdfont big">&#xf16cb;</span>|md_wifi_strength_1_lock_open|
|<span class="nerdfont big">&#xf0922;</span>|md_wifi_strength_2|
|<span class="nerdfont big">&#xf0923;</span>|md_wifi_strength_2_alert|
|<span class="nerdfont big">&#xf0924;</span>|md_wifi_strength_2_lock|
|<span class="nerdfont big">&#xf16cc;</span>|md_wifi_strength_2_lock_open|
|<span class="nerdfont big">&#xf0925;</span>|md_wifi_strength_3|
|<span class="nerdfont big">&#xf0926;</span>|md_wifi_strength_3_alert|
|<span class="nerdfont big">&#xf0927;</span>|md_wifi_strength_3_lock|
|<span class="nerdfont big">&#xf16cd;</span>|md_wifi_strength_3_lock_open|
|<span class="nerdfont big">&#xf0928;</span>|md_wifi_strength_4|
|<span class="nerdfont big">&#xf0929;</span>|md_wifi_strength_4_alert|
|<span class="nerdfont big">&#xf092a;</span>|md_wifi_strength_4_lock|
|<span class="nerdfont big">&#xf16ce;</span>|md_wifi_strength_4_lock_open|
|<span class="nerdfont big">&#xf092b;</span>|md_wifi_strength_alert_outline|
|<span class="nerdfont big">&#xf16cf;</span>|md_wifi_strength_lock_open_outline|
|<span class="nerdfont big">&#xf092c;</span>|md_wifi_strength_lock_outline|
|<span class="nerdfont big">&#xf092d;</span>|md_wifi_strength_off|
|<span class="nerdfont big">&#xf092e;</span>|md_wifi_strength_off_outline|
|<span class="nerdfont big">&#xf092f;</span>|md_wifi_strength_outline|
|<span class="nerdfont big">&#xf16c7;</span>|md_wifi_sync|
|<span class="nerdfont big">&#xf05ac;</span>|md_wikipedia|
|<span class="nerdfont big">&#xf1a88;</span>|md_wind_power|
|<span class="nerdfont big">&#xf1a89;</span>|md_wind_power_outline|
|<span class="nerdfont big">&#xf0da5;</span>|md_wind_turbine|
|<span class="nerdfont big">&#xf19ab;</span>|md_wind_turbine_alert|
|<span class="nerdfont big">&#xf19ac;</span>|md_wind_turbine_check|
|<span class="nerdfont big">&#xf05ad;</span>|md_window_close|
|<span class="nerdfont big">&#xf05ae;</span>|md_window_closed|
|<span class="nerdfont big">&#xf11db;</span>|md_window_closed_variant|
|<span class="nerdfont big">&#xf05af;</span>|md_window_maximize|
|<span class="nerdfont big">&#xf05b0;</span>|md_window_minimize|
|<span class="nerdfont big">&#xf05b1;</span>|md_window_open|
|<span class="nerdfont big">&#xf11dc;</span>|md_window_open_variant|
|<span class="nerdfont big">&#xf05b2;</span>|md_window_restore|
|<span class="nerdfont big">&#xf111c;</span>|md_window_shutter|
|<span class="nerdfont big">&#xf111d;</span>|md_window_shutter_alert|
|<span class="nerdfont big">&#xf1a8a;</span>|md_window_shutter_cog|
|<span class="nerdfont big">&#xf111e;</span>|md_window_shutter_open|
|<span class="nerdfont big">&#xf1a8b;</span>|md_window_shutter_settings|
|<span class="nerdfont big">&#xf15fa;</span>|md_windsock|
|<span class="nerdfont big">&#xf0ae9;</span>|md_wiper|
|<span class="nerdfont big">&#xf0da6;</span>|md_wiper_wash|
|<span class="nerdfont big">&#xf18df;</span>|md_wiper_wash_alert|
|<span class="nerdfont big">&#xf1477;</span>|md_wizard_hat|
|<span class="nerdfont big">&#xf05b4;</span>|md_wordpress|
|<span class="nerdfont big">&#xf05b6;</span>|md_wrap|
|<span class="nerdfont big">&#xf0bdf;</span>|md_wrap_disabled|
|<span class="nerdfont big">&#xf05b7;</span>|md_wrench|
|<span class="nerdfont big">&#xf19a3;</span>|md_wrench_clock|
|<span class="nerdfont big">&#xf0be0;</span>|md_wrench_outline|
|<span class="nerdfont big">&#xf0845;</span>|md_xamarin|
|<span class="nerdfont big">&#xf05c0;</span>|md_xml|
|<span class="nerdfont big">&#xf07ff;</span>|md_xmpp|
|<span class="nerdfont big">&#xf0b4f;</span>|md_yahoo|
|<span class="nerdfont big">&#xf05c1;</span>|md_yeast|
|<span class="nerdfont big">&#xf0680;</span>|md_yin_yang|
|<span class="nerdfont big">&#xf117c;</span>|md_yoga|
|<span class="nerdfont big">&#xf05c3;</span>|md_youtube|
|<span class="nerdfont big">&#xf0848;</span>|md_youtube_gaming|
|<span class="nerdfont big">&#xf0847;</span>|md_youtube_studio|
|<span class="nerdfont big">&#xf0d40;</span>|md_youtube_subscription|
|<span class="nerdfont big">&#xf0448;</span>|md_youtube_tv|
|<span class="nerdfont big">&#xf1516;</span>|md_yurt|
|<span class="nerdfont big">&#xf0aea;</span>|md_z_wave|
|<span class="nerdfont big">&#xf0aeb;</span>|md_zend|
|<span class="nerdfont big">&#xf0d41;</span>|md_zigbee|
|<span class="nerdfont big">&#xf05c4;</span>|md_zip_box|
|<span class="nerdfont big">&#xf0ffa;</span>|md_zip_box_outline|
|<span class="nerdfont big">&#xf0a23;</span>|md_zip_disk|
|<span class="nerdfont big">&#xf0a7d;</span>|md_zodiac_aquarius|
|<span class="nerdfont big">&#xf0a7e;</span>|md_zodiac_aries|
|<span class="nerdfont big">&#xf0a7f;</span>|md_zodiac_cancer|
|<span class="nerdfont big">&#xf0a80;</span>|md_zodiac_capricorn|
|<span class="nerdfont big">&#xf0a81;</span>|md_zodiac_gemini|
|<span class="nerdfont big">&#xf0a82;</span>|md_zodiac_leo|
|<span class="nerdfont big">&#xf0a83;</span>|md_zodiac_libra|
|<span class="nerdfont big">&#xf0a84;</span>|md_zodiac_pisces|
|<span class="nerdfont big">&#xf0a85;</span>|md_zodiac_sagittarius|
|<span class="nerdfont big">&#xf0a86;</span>|md_zodiac_scorpio|
|<span class="nerdfont big">&#xf0a87;</span>|md_zodiac_taurus|
|<span class="nerdfont big">&#xf0a88;</span>|md_zodiac_virgo|
|<span class="nerdfont big">&#xf406;</span>|oct_accessibility|
|<span class="nerdfont big">&#xf40b;</span>|oct_accessibility_inset|
|<span class="nerdfont big">&#xf421;</span>|oct_alert|
|<span class="nerdfont big">&#xf40c;</span>|oct_alert_fill|
|<span class="nerdfont big">&#xf40e;</span>|oct_apps|
|<span class="nerdfont big">&#xf411;</span>|oct_archive|
|<span class="nerdfont big">&#xf416;</span>|oct_arrow_both|
|<span class="nerdfont big">&#xf433;</span>|oct_arrow_down|
|<span class="nerdfont big">&#xf424;</span>|oct_arrow_down_left|
|<span class="nerdfont big">&#xf43e;</span>|oct_arrow_down_right|
|<span class="nerdfont big">&#xf434;</span>|oct_arrow_left|
|<span class="nerdfont big">&#xf432;</span>|oct_arrow_right|
|<span class="nerdfont big">&#xf443;</span>|oct_arrow_switch|
|<span class="nerdfont big">&#xf431;</span>|oct_arrow_up|
|<span class="nerdfont big">&#xf45c;</span>|oct_arrow_up_left|
|<span class="nerdfont big">&#xf46c;</span>|oct_arrow_up_right|
|<span class="nerdfont big">&#xf499;</span>|oct_beaker|
|<span class="nerdfont big">&#xf49a;</span>|oct_bell|
|<span class="nerdfont big">&#xf476;</span>|oct_bell_fill|
|<span class="nerdfont big">&#xf478;</span>|oct_bell_slash|
|<span class="nerdfont big">&#xf479;</span>|oct_blocked|
|<span class="nerdfont big">&#xf49d;</span>|oct_bold|
|<span class="nerdfont big">&#xf405;</span>|oct_book|
|<span class="nerdfont big">&#xf461;</span>|oct_bookmark|
|<span class="nerdfont big">&#xf47a;</span>|oct_bookmark_fill|
|<span class="nerdfont big">&#xf533;</span>|oct_bookmark_slash|
|<span class="nerdfont big">&#xf493;</span>|oct_bookmark_slash_fill|
|<span class="nerdfont big">&#xf491;</span>|oct_briefcase|
|<span class="nerdfont big">&#xf43c;</span>|oct_broadcast|
|<span class="nerdfont big">&#xf488;</span>|oct_browser|
|<span class="nerdfont big">&#xf46f;</span>|oct_bug|
|<span class="nerdfont big">&#xf49b;</span>|oct_cache|
|<span class="nerdfont big">&#xf455;</span>|oct_calendar|
|<span class="nerdfont big">&#xf42e;</span>|oct_check|
|<span class="nerdfont big">&#xf49e;</span>|oct_check_circle|
|<span class="nerdfont big">&#xf4a4;</span>|oct_check_circle_fill|
|<span class="nerdfont big">&#xf4a7;</span>|oct_checkbox|
|<span class="nerdfont big">&#xf45e;</span>|oct_checklist|
|<span class="nerdfont big">&#xf47c;</span>|oct_chevron_down|
|<span class="nerdfont big">&#xf47d;</span>|oct_chevron_left|
|<span class="nerdfont big">&#xf460;</span>|oct_chevron_right|
|<span class="nerdfont big">&#xf47b;</span>|oct_chevron_up|
|<span class="nerdfont big">&#xf4aa;</span>|oct_circle|
|<span class="nerdfont big">&#xf468;</span>|oct_circle_slash|
|<span class="nerdfont big">&#xf43a;</span>|oct_clock|
|<span class="nerdfont big">&#xf4ab;</span>|oct_clock_fill|
|<span class="nerdfont big">&#xf4ac;</span>|oct_cloud|
|<span class="nerdfont big">&#xf4ad;</span>|oct_cloud_offline|
|<span class="nerdfont big">&#xf44f;</span>|oct_code|
|<span class="nerdfont big">&#xf4ae;</span>|oct_code_of_conduct|
|<span class="nerdfont big">&#xf4af;</span>|oct_code_review|
|<span class="nerdfont big">&#xf4b0;</span>|oct_code_square|
|<span class="nerdfont big">&#xf4b1;</span>|oct_codescan|
|<span class="nerdfont big">&#xf4b2;</span>|oct_codescan_checkmark|
|<span class="nerdfont big">&#xf4b3;</span>|oct_codespaces|
|<span class="nerdfont big">&#xf4b4;</span>|oct_columns|
|<span class="nerdfont big">&#xf4b5;</span>|oct_command_palette|
|<span class="nerdfont big">&#xf41f;</span>|oct_comment|
|<span class="nerdfont big">&#xf442;</span>|oct_comment_discussion|
|<span class="nerdfont big">&#xf4b6;</span>|oct_commit|
|<span class="nerdfont big">&#xf4b7;</span>|oct_container|
|<span class="nerdfont big">&#xf4b8;</span>|oct_copilot|
|<span class="nerdfont big">&#xf4b9;</span>|oct_copilot_error|
|<span class="nerdfont big">&#xf4ba;</span>|oct_copilot_warning|
|<span class="nerdfont big">&#xf4bb;</span>|oct_copy|
|<span class="nerdfont big">&#xf4bc;</span>|oct_cpu|
|<span class="nerdfont big">&#xf439;</span>|oct_credit_card|
|<span class="nerdfont big">&#xf4bd;</span>|oct_cross_reference|
|<span class="nerdfont big">&#xf48b;</span>|oct_dash|
|<span class="nerdfont big">&#xf472;</span>|oct_database|
|<span class="nerdfont big">&#xf4be;</span>|oct_dependabot|
|<span class="nerdfont big">&#xf498;</span>|oct_desktop_download|
|<span class="nerdfont big">&#xf446;</span>|oct_device_camera|
|<span class="nerdfont big">&#xf447;</span>|oct_device_camera_video|
|<span class="nerdfont big">&#xf4a9;</span>|oct_device_desktop|
|<span class="nerdfont big">&#xf42c;</span>|oct_device_mobile|
|<span class="nerdfont big">&#xf4bf;</span>|oct_diamond|
|<span class="nerdfont big">&#xf440;</span>|oct_diff|
|<span class="nerdfont big">&#xf457;</span>|oct_diff_added|
|<span class="nerdfont big">&#xf474;</span>|oct_diff_ignored|
|<span class="nerdfont big">&#xf459;</span>|oct_diff_modified|
|<span class="nerdfont big">&#xf458;</span>|oct_diff_removed|
|<span class="nerdfont big">&#xf45a;</span>|oct_diff_renamed|
|<span class="nerdfont big">&#xf4c0;</span>|oct_discussion_closed|
|<span class="nerdfont big">&#xf4c1;</span>|oct_discussion_duplicate|
|<span class="nerdfont big">&#xf4c2;</span>|oct_discussion_outdated|
|<span class="nerdfont big">&#xf4c3;</span>|oct_dot|
|<span class="nerdfont big">&#xf444;</span>|oct_dot_fill|
|<span class="nerdfont big">&#xf409;</span>|oct_download|
|<span class="nerdfont big">&#xf4c4;</span>|oct_duplicate|
|<span class="nerdfont big">&#xf475;</span>|oct_ellipsis|
|<span class="nerdfont big">&#xf441;</span>|oct_eye|
|<span class="nerdfont big">&#xf4c5;</span>|oct_eye_closed|
|<span class="nerdfont big">&#xf4c6;</span>|oct_feed_discussion|
|<span class="nerdfont big">&#xf4c7;</span>|oct_feed_forked|
|<span class="nerdfont big">&#xf4c8;</span>|oct_feed_heart|
|<span class="nerdfont big">&#xf4c9;</span>|oct_feed_merged|
|<span class="nerdfont big">&#xf4ca;</span>|oct_feed_person|
|<span class="nerdfont big">&#xf4cb;</span>|oct_feed_repo|
|<span class="nerdfont big">&#xf4cc;</span>|oct_feed_rocket|
|<span class="nerdfont big">&#xf4cd;</span>|oct_feed_star|
|<span class="nerdfont big">&#xf4ce;</span>|oct_feed_tag|
|<span class="nerdfont big">&#xf4cf;</span>|oct_feed_trophy|
|<span class="nerdfont big">&#xf4a5;</span>|oct_file|
|<span class="nerdfont big">&#xf4d0;</span>|oct_file_added|
|<span class="nerdfont big">&#xf4d1;</span>|oct_file_badge|
|<span class="nerdfont big">&#xf471;</span>|oct_file_binary|
|<span class="nerdfont big">&#xf40d;</span>|oct_file_code|
|<span class="nerdfont big">&#xf4d2;</span>|oct_file_diff|
|<span class="nerdfont big">&#xf413;</span>|oct_file_directory|
|<span class="nerdfont big">&#xf4d3;</span>|oct_file_directory_fill|
|<span class="nerdfont big">&#xf4d4;</span>|oct_file_directory_open_fill|
|<span class="nerdfont big">&#xf40f;</span>|oct_file_media|
|<span class="nerdfont big">&#xf4d5;</span>|oct_file_moved|
|<span class="nerdfont big">&#xf4d6;</span>|oct_file_removed|
|<span class="nerdfont big">&#xf414;</span>|oct_file_submodule|
|<span class="nerdfont big">&#xf482;</span>|oct_file_symlink_directory|
|<span class="nerdfont big">&#xf481;</span>|oct_file_symlink_file|
|<span class="nerdfont big">&#xf410;</span>|oct_file_zip|
|<span class="nerdfont big">&#xf4d7;</span>|oct_filter|
|<span class="nerdfont big">&#xf4d8;</span>|oct_fiscal_host|
|<span class="nerdfont big">&#xf490;</span>|oct_flame|
|<span class="nerdfont big">&#xf48c;</span>|oct_fold|
|<span class="nerdfont big">&#xf4d9;</span>|oct_fold_down|
|<span class="nerdfont big">&#xf4da;</span>|oct_fold_up|
|<span class="nerdfont big">&#xf423;</span>|oct_gear|
|<span class="nerdfont big">&#xf436;</span>|oct_gift|
|<span class="nerdfont big">&#xf418;</span>|oct_git_branch|
|<span class="nerdfont big">&#xf417;</span>|oct_git_commit|
|<span class="nerdfont big">&#xf47f;</span>|oct_git_compare|
|<span class="nerdfont big">&#xf419;</span>|oct_git_merge|
|<span class="nerdfont big">&#xf4db;</span>|oct_git_merge_queue|
|<span class="nerdfont big">&#xf407;</span>|oct_git_pull_request|
|<span class="nerdfont big">&#xf4dc;</span>|oct_git_pull_request_closed|
|<span class="nerdfont big">&#xf4dd;</span>|oct_git_pull_request_draft|
|<span class="nerdfont big">&#xf484;</span>|oct_globe|
|<span class="nerdfont big">&#xf4de;</span>|oct_goal|
|<span class="nerdfont big">&#xf4a6;</span>|oct_grabber|
|<span class="nerdfont big">&#xf437;</span>|oct_graph|
|<span class="nerdfont big">&#xf4df;</span>|oct_hash|
|<span class="nerdfont big">&#xf4e0;</span>|oct_heading|
|<span class="nerdfont big">&#x2665;</span>|oct_heart|
|<span class="nerdfont big">&#xf4e1;</span>|oct_heart_fill|
|<span class="nerdfont big">&#xf464;</span>|oct_history|
|<span class="nerdfont big">&#xf46d;</span>|oct_home|
|<span class="nerdfont big">&#xf4e2;</span>|oct_home_fill|
|<span class="nerdfont big">&#xf45b;</span>|oct_horizontal_rule|
|<span class="nerdfont big">&#xf4e3;</span>|oct_hourglass|
|<span class="nerdfont big">&#xf477;</span>|oct_hubot|
|<span class="nerdfont big">&#xf4e4;</span>|oct_id_badge|
|<span class="nerdfont big">&#xf4e5;</span>|oct_image|
|<span class="nerdfont big">&#xf48d;</span>|oct_inbox|
|<span class="nerdfont big">&#xf4e6;</span>|oct_infinity|
|<span class="nerdfont big">&#xf449;</span>|oct_info|
|<span class="nerdfont big">&#xf41d;</span>|oct_issue_closed|
|<span class="nerdfont big">&#xf4e7;</span>|oct_issue_draft|
|<span class="nerdfont big">&#xf41b;</span>|oct_issue_opened|
|<span class="nerdfont big">&#xf41c;</span>|oct_issue_reopened|
|<span class="nerdfont big">&#xf4e8;</span>|oct_issue_tracked_by|
|<span class="nerdfont big">&#xf4e9;</span>|oct_issue_tracks|
|<span class="nerdfont big">&#xf49f;</span>|oct_italic|
|<span class="nerdfont big">&#xf4ea;</span>|oct_iterations|
|<span class="nerdfont big">&#xf4eb;</span>|oct_kebab_horizontal|
|<span class="nerdfont big">&#xf43d;</span>|oct_key|
|<span class="nerdfont big">&#xf4ec;</span>|oct_key_asterisk|
|<span class="nerdfont big">&#xf495;</span>|oct_law|
|<span class="nerdfont big">&#xf400;</span>|oct_light_bulb|
|<span class="nerdfont big">&#xf44c;</span>|oct_link|
|<span class="nerdfont big">&#xf465;</span>|oct_link_external|
|<span class="nerdfont big">&#xf452;</span>|oct_list_ordered|
|<span class="nerdfont big">&#xf451;</span>|oct_list_unordered|
|<span class="nerdfont big">&#xf450;</span>|oct_location|
|<span class="nerdfont big">&#xf456;</span>|oct_lock|
|<span class="nerdfont big">&#xf4ed;</span>|oct_log|
|<span class="nerdfont big">&#xf480;</span>|oct_logo_gist|
|<span class="nerdfont big">&#xf470;</span>|oct_logo_github|
|<span class="nerdfont big">&#xf42f;</span>|oct_mail|
|<span class="nerdfont big">&#xf408;</span>|oct_mark_github|
|<span class="nerdfont big">&#xf48a;</span>|oct_markdown|
|<span class="nerdfont big">&#xf45f;</span>|oct_megaphone|
|<span class="nerdfont big">&#xf486;</span>|oct_mention|
|<span class="nerdfont big">&#xf463;</span>|oct_meter|
|<span class="nerdfont big">&#xf45d;</span>|oct_milestone|
|<span class="nerdfont big">&#xf41a;</span>|oct_mirror|
|<span class="nerdfont big">&#xf4ee;</span>|oct_moon|
|<span class="nerdfont big">&#xf494;</span>|oct_mortar_board|
|<span class="nerdfont big">&#xf4ef;</span>|oct_move_to_bottom|
|<span class="nerdfont big">&#xf4f0;</span>|oct_move_to_end|
|<span class="nerdfont big">&#xf4f1;</span>|oct_move_to_start|
|<span class="nerdfont big">&#xf4f2;</span>|oct_move_to_top|
|<span class="nerdfont big">&#xf4f3;</span>|oct_multi_select|
|<span class="nerdfont big">&#xf466;</span>|oct_mute|
|<span class="nerdfont big">&#xf4f4;</span>|oct_no_entry|
|<span class="nerdfont big">&#xf4f5;</span>|oct_north_star|
|<span class="nerdfont big">&#xf4f6;</span>|oct_note|
|<span class="nerdfont big">&#xf4f7;</span>|oct_number|
|<span class="nerdfont big">&#xf42b;</span>|oct_organization|
|<span class="nerdfont big">&#xf487;</span>|oct_package|
|<span class="nerdfont big">&#xf4f8;</span>|oct_package_dependencies|
|<span class="nerdfont big">&#xf4f9;</span>|oct_package_dependents|
|<span class="nerdfont big">&#xf48f;</span>|oct_paintbrush|
|<span class="nerdfont big">&#xf4fa;</span>|oct_paper_airplane|
|<span class="nerdfont big">&#xf4fb;</span>|oct_paperclip|
|<span class="nerdfont big">&#xf4fc;</span>|oct_passkey_fill|
|<span class="nerdfont big">&#xf429;</span>|oct_paste|
|<span class="nerdfont big">&#xf448;</span>|oct_pencil|
|<span class="nerdfont big">&#xf4fd;</span>|oct_people|
|<span class="nerdfont big">&#xf415;</span>|oct_person|
|<span class="nerdfont big">&#xf4fe;</span>|oct_person_add|
|<span class="nerdfont big">&#xf4ff;</span>|oct_person_fill|
|<span class="nerdfont big">&#xf435;</span>|oct_pin|
|<span class="nerdfont big">&#xf500;</span>|oct_play|
|<span class="nerdfont big">&#xf492;</span>|oct_plug|
|<span class="nerdfont big">&#xf44d;</span>|oct_plus|
|<span class="nerdfont big">&#xf501;</span>|oct_plus_circle|
|<span class="nerdfont big">&#xf502;</span>|oct_project|
|<span class="nerdfont big">&#xf503;</span>|oct_project_roadmap|
|<span class="nerdfont big">&#xf504;</span>|oct_project_symlink|
|<span class="nerdfont big">&#xf505;</span>|oct_project_template|
|<span class="nerdfont big">&#xf469;</span>|oct_pulse|
|<span class="nerdfont big">&#xf420;</span>|oct_question|
|<span class="nerdfont big">&#xf453;</span>|oct_quote|
|<span class="nerdfont big">&#xf430;</span>|oct_read|
|<span class="nerdfont big">&#xf506;</span>|oct_rel_file_path|
|<span class="nerdfont big">&#xf4a8;</span>|oct_reply|
|<span class="nerdfont big">&#xf401;</span>|oct_repo|
|<span class="nerdfont big">&#xf43f;</span>|oct_repo_clone|
|<span class="nerdfont big">&#xf507;</span>|oct_repo_deleted|
|<span class="nerdfont big">&#xf402;</span>|oct_repo_forked|
|<span class="nerdfont big">&#xf508;</span>|oct_repo_locked|
|<span class="nerdfont big">&#xf404;</span>|oct_repo_pull|
|<span class="nerdfont big">&#xf403;</span>|oct_repo_push|
|<span class="nerdfont big">&#xf509;</span>|oct_repo_template|
|<span class="nerdfont big">&#xf50a;</span>|oct_report|
|<span class="nerdfont big">&#xf427;</span>|oct_rocket|
|<span class="nerdfont big">&#xf50b;</span>|oct_rows|
|<span class="nerdfont big">&#xf428;</span>|oct_rss|
|<span class="nerdfont big">&#xf43b;</span>|oct_ruby|
|<span class="nerdfont big">&#xf50c;</span>|oct_screen_full|
|<span class="nerdfont big">&#xf50d;</span>|oct_screen_normal|
|<span class="nerdfont big">&#xf422;</span>|oct_search|
|<span class="nerdfont big">&#xf473;</span>|oct_server|
|<span class="nerdfont big">&#xf50e;</span>|oct_share|
|<span class="nerdfont big">&#xf50f;</span>|oct_share_android|
|<span class="nerdfont big">&#xf49c;</span>|oct_shield|
|<span class="nerdfont big">&#xf510;</span>|oct_shield_check|
|<span class="nerdfont big">&#xf511;</span>|oct_shield_lock|
|<span class="nerdfont big">&#xf512;</span>|oct_shield_slash|
|<span class="nerdfont big">&#xf513;</span>|oct_shield_x|
|<span class="nerdfont big">&#xf514;</span>|oct_sidebar_collapse|
|<span class="nerdfont big">&#xf515;</span>|oct_sidebar_expand|
|<span class="nerdfont big">&#xf42a;</span>|oct_sign_in|
|<span class="nerdfont big">&#xf426;</span>|oct_sign_out|
|<span class="nerdfont big">&#xf516;</span>|oct_single_select|
|<span class="nerdfont big">&#xf517;</span>|oct_skip|
|<span class="nerdfont big">&#xf518;</span>|oct_skip_fill|
|<span class="nerdfont big">&#xf462;</span>|oct_sliders|
|<span class="nerdfont big">&#xf4a2;</span>|oct_smiley|
|<span class="nerdfont big">&#xf519;</span>|oct_sort_asc|
|<span class="nerdfont big">&#xf51a;</span>|oct_sort_desc|
|<span class="nerdfont big">&#xf51b;</span>|oct_sparkle_fill|
|<span class="nerdfont big">&#xf51c;</span>|oct_sponsor_tiers|
|<span class="nerdfont big">&#xf51d;</span>|oct_square|
|<span class="nerdfont big">&#xf445;</span>|oct_square_fill|
|<span class="nerdfont big">&#xf483;</span>|oct_squirrel|
|<span class="nerdfont big">&#xf51e;</span>|oct_stack|
|<span class="nerdfont big">&#xf41e;</span>|oct_star|
|<span class="nerdfont big">&#xf51f;</span>|oct_star_fill|
|<span class="nerdfont big">&#xf46e;</span>|oct_stop|
|<span class="nerdfont big">&#xf520;</span>|oct_stopwatch|
|<span class="nerdfont big">&#xf521;</span>|oct_strikethrough|
|<span class="nerdfont big">&#xf522;</span>|oct_sun|
|<span class="nerdfont big">&#xf46a;</span>|oct_sync|
|<span class="nerdfont big">&#xf523;</span>|oct_tab|
|<span class="nerdfont big">&#xf524;</span>|oct_tab_external|
|<span class="nerdfont big">&#xf525;</span>|oct_table|
|<span class="nerdfont big">&#xf412;</span>|oct_tag|
|<span class="nerdfont big">&#xf4a0;</span>|oct_tasklist|
|<span class="nerdfont big">&#xf46b;</span>|oct_telescope|
|<span class="nerdfont big">&#xf526;</span>|oct_telescope_fill|
|<span class="nerdfont big">&#xf489;</span>|oct_terminal|
|<span class="nerdfont big">&#xf44e;</span>|oct_three_bars|
|<span class="nerdfont big">&#xf497;</span>|oct_thumbsdown|
|<span class="nerdfont big">&#xf496;</span>|oct_thumbsup|
|<span class="nerdfont big">&#xf425;</span>|oct_tools|
|<span class="nerdfont big">&#xf48e;</span>|oct_trash|
|<span class="nerdfont big">&#xf44b;</span>|oct_triangle_down|
|<span class="nerdfont big">&#xf438;</span>|oct_triangle_left|
|<span class="nerdfont big">&#xf44a;</span>|oct_triangle_right|
|<span class="nerdfont big">&#xf47e;</span>|oct_triangle_up|
|<span class="nerdfont big">&#xf527;</span>|oct_trophy|
|<span class="nerdfont big">&#xf528;</span>|oct_typography|
|<span class="nerdfont big">&#xf42d;</span>|oct_unfold|
|<span class="nerdfont big">&#xf529;</span>|oct_unlink|
|<span class="nerdfont big">&#xf52a;</span>|oct_unlock|
|<span class="nerdfont big">&#xf485;</span>|oct_unmute|
|<span class="nerdfont big">&#xf52b;</span>|oct_unread|
|<span class="nerdfont big">&#xf4a3;</span>|oct_unverified|
|<span class="nerdfont big">&#xf40a;</span>|oct_upload|
|<span class="nerdfont big">&#xf4a1;</span>|oct_verified|
|<span class="nerdfont big">&#xf454;</span>|oct_versions|
|<span class="nerdfont big">&#xf52c;</span>|oct_video|
|<span class="nerdfont big">&#xf52d;</span>|oct_webhook|
|<span class="nerdfont big">&#xf52e;</span>|oct_workflow|
|<span class="nerdfont big">&#xf467;</span>|oct_x|
|<span class="nerdfont big">&#xf52f;</span>|oct_x_circle|
|<span class="nerdfont big">&#xf530;</span>|oct_x_circle_fill|
|<span class="nerdfont big">&#x26a1;</span>|oct_zap|
|<span class="nerdfont big">&#xf531;</span>|oct_zoom_in|
|<span class="nerdfont big">&#xf532;</span>|oct_zoom_out|
|<span class="nerdfont big">&#xe0a0;</span>|pl_branch|
|<span class="nerdfont big">&#xe0a2;</span>|pl_hostname|
|<span class="nerdfont big">&#xe0b0;</span>|pl_left_hard_divider|
|<span class="nerdfont big">&#xe0b1;</span>|pl_left_soft_divider|
|<span class="nerdfont big">&#xe0a1;</span>|pl_line_number|
|<span class="nerdfont big">&#xe0b2;</span>|pl_right_hard_divider|
|<span class="nerdfont big">&#xe0b3;</span>|pl_right_soft_divider|
|<span class="nerdfont big">&#xe0b9;</span>|ple_backslash_separator|
|<span class="nerdfont big">&#xe0bf;</span>|ple_backslash_separator_redundant|
|<span class="nerdfont big">&#xe0a3;</span>|ple_column_number|
|<span class="nerdfont big">&#xe0c0;</span>|ple_flame_thick|
|<span class="nerdfont big">&#xe0c2;</span>|ple_flame_thick_mirrored|
|<span class="nerdfont big">&#xe0c1;</span>|ple_flame_thin|
|<span class="nerdfont big">&#xe0c3;</span>|ple_flame_thin_mirrored|
|<span class="nerdfont big">&#xe0bb;</span>|ple_forwardslash_separator|
|<span class="nerdfont big">&#xe0bd;</span>|ple_forwardslash_separator_redundant|
|<span class="nerdfont big">&#xe0cc;</span>|ple_honeycomb|
|<span class="nerdfont big">&#xe0cd;</span>|ple_honeycomb_outline|
|<span class="nerdfont big">&#xe0c8;</span>|ple_ice_waveform|
|<span class="nerdfont big">&#xe0ca;</span>|ple_ice_waveform_mirrored|
|<span class="nerdfont big">&#xe0b6;</span>|ple_left_half_circle_thick|
|<span class="nerdfont big">&#xe0b7;</span>|ple_left_half_circle_thin|
|<span class="nerdfont big">&#xe0d0;</span>|ple_lego_block_facing|
|<span class="nerdfont big">&#xe0d1;</span>|ple_lego_block_sideways|
|<span class="nerdfont big">&#xe0ce;</span>|ple_lego_separator|
|<span class="nerdfont big">&#xe0cf;</span>|ple_lego_separator_thin|
|<span class="nerdfont big">&#xe0b8;</span>|ple_lower_left_triangle|
|<span class="nerdfont big">&#xe0ba;</span>|ple_lower_right_triangle|
|<span class="nerdfont big">&#xe0c6;</span>|ple_pixelated_squares_big|
|<span class="nerdfont big">&#xe0c7;</span>|ple_pixelated_squares_big_mirrored|
|<span class="nerdfont big">&#xe0c4;</span>|ple_pixelated_squares_small|
|<span class="nerdfont big">&#xe0c5;</span>|ple_pixelated_squares_small_mirrored|
|<span class="nerdfont big">&#xe0b4;</span>|ple_right_half_circle_thick|
|<span class="nerdfont big">&#xe0b5;</span>|ple_right_half_circle_thin|
|<span class="nerdfont big">&#xe0d2;</span>|ple_trapezoid_top_bottom|
|<span class="nerdfont big">&#xe0d4;</span>|ple_trapezoid_top_bottom_mirrored|
|<span class="nerdfont big">&#xe0bc;</span>|ple_upper_left_triangle|
|<span class="nerdfont big">&#xe0be;</span>|ple_upper_right_triangle|
|<span class="nerdfont big">&#xe007;</span>|pom_away|
|<span class="nerdfont big">&#xe000;</span>|pom_clean_code|
|<span class="nerdfont big">&#xe00a;</span>|pom_external_interruption|
|<span class="nerdfont big">&#xe009;</span>|pom_internal_interruption|
|<span class="nerdfont big">&#xe006;</span>|pom_long_pause|
|<span class="nerdfont big">&#xe008;</span>|pom_pair_programming|
|<span class="nerdfont big">&#xe001;</span>|pom_pomodoro_done|
|<span class="nerdfont big">&#xe002;</span>|pom_pomodoro_estimated|
|<span class="nerdfont big">&#xe004;</span>|pom_pomodoro_squashed|
|<span class="nerdfont big">&#xe003;</span>|pom_pomodoro_ticking|
|<span class="nerdfont big">&#xe005;</span>|pom_short_pause|
|<span class="nerdfont big">&#xe635;</span>|seti_apple|
|<span class="nerdfont big">&#xe636;</span>|seti_argdown|
|<span class="nerdfont big">&#xe637;</span>|seti_asm|
|<span class="nerdfont big">&#xe638;</span>|seti_audio|
|<span class="nerdfont big">&#xe639;</span>|seti_babel|
|<span class="nerdfont big">&#xe63a;</span>|seti_bazel|
|<span class="nerdfont big">&#xe63b;</span>|seti_bicep|
|<span class="nerdfont big">&#xe61a;</span>|seti_bower|
|<span class="nerdfont big">&#xe63c;</span>|seti_bsl|
|<span class="nerdfont big">&#xe649;</span>|seti_c|
|<span class="nerdfont big">&#xe648;</span>|seti_c_sharp|
|<span class="nerdfont big">&#xe63e;</span>|seti_cake|
|<span class="nerdfont big">&#xe63d;</span>|seti_cake_php|
|<span class="nerdfont big">&#xe63f;</span>|seti_checkbox|
|<span class="nerdfont big">&#xe640;</span>|seti_checkbox_unchecked|
|<span class="nerdfont big">&#xe641;</span>|seti_clock|
|<span class="nerdfont big">&#xe642;</span>|seti_clojure|
|<span class="nerdfont big">&#xe643;</span>|seti_code_climate|
|<span class="nerdfont big">&#xe644;</span>|seti_code_search|
|<span class="nerdfont big">&#xe61b;</span>|seti_coffee|
|<span class="nerdfont big">&#xe645;</span>|seti_coldfusion|
|<span class="nerdfont big">&#xe615;</span>|seti_config|
|<span class="nerdfont big">&#xe646;</span>|seti_cpp|
|<span class="nerdfont big">&#xe647;</span>|seti_crystal_embedded|
|<span class="nerdfont big">&#xe614;</span>|seti_css|
|<span class="nerdfont big">&#xe64a;</span>|seti_csv|
|<span class="nerdfont big">&#xe64b;</span>|seti_cu|
|<span class="nerdfont big">&#xe651;</span>|seti_d|
|<span class="nerdfont big">&#xe64c;</span>|seti_dart|
|<span class="nerdfont big">&#xe64d;</span>|seti_db|
|<span class="nerdfont big">&#xe64e;</span>|seti_default|
|<span class="nerdfont big">&#xe64f;</span>|seti_deprecation_cop|
|<span class="nerdfont big">&#xe650;</span>|seti_docker|
|<span class="nerdfont big">&#xe652;</span>|seti_editorconfig|
|<span class="nerdfont big">&#xe618;</span>|seti_ejs|
|<span class="nerdfont big">&#xe653;</span>|seti_elixir_script|
|<span class="nerdfont big">&#xe654;</span>|seti_error|
|<span class="nerdfont big">&#xe655;</span>|seti_eslint|
|<span class="nerdfont big">&#xe656;</span>|seti_ethereum|
|<span class="nerdfont big">&#xe65a;</span>|seti_f_sharp|
|<span class="nerdfont big">&#xe623;</span>|seti_favicon|
|<span class="nerdfont big">&#xe657;</span>|seti_firebase|
|<span class="nerdfont big">&#xe658;</span>|seti_firefox|
|<span class="nerdfont big">&#xe613;</span>|seti_folder|
|<span class="nerdfont big">&#xe659;</span>|seti_font|
|<span class="nerdfont big">&#xe65d;</span>|seti_git|
|<span class="nerdfont big">&#xe65b;</span>|seti_github|
|<span class="nerdfont big">&#xe65c;</span>|seti_gitlab|
|<span class="nerdfont big">&#xe627;</span>|seti_go|
|<span class="nerdfont big">&#xe65e;</span>|seti_go2|
|<span class="nerdfont big">&#xe65f;</span>|seti_godot|
|<span class="nerdfont big">&#xe660;</span>|seti_gradle|
|<span class="nerdfont big">&#xe661;</span>|seti_grails|
|<span class="nerdfont big">&#xe662;</span>|seti_graphql|
|<span class="nerdfont big">&#xe611;</span>|seti_grunt|
|<span class="nerdfont big">&#xe610;</span>|seti_gulp|
|<span class="nerdfont big">&#xe663;</span>|seti_hacklang|
|<span class="nerdfont big">&#xe664;</span>|seti_haml|
|<span class="nerdfont big">&#xe665;</span>|seti_happenings|
|<span class="nerdfont big">&#xe61f;</span>|seti_haskell|
|<span class="nerdfont big">&#xe666;</span>|seti_haxe|
|<span class="nerdfont big">&#xe607;</span>|seti_heroku|
|<span class="nerdfont big">&#xe667;</span>|seti_hex|
|<span class="nerdfont big">&#xe60e;</span>|seti_html|
|<span class="nerdfont big">&#xe668;</span>|seti_ignored|
|<span class="nerdfont big">&#xe669;</span>|seti_illustrator|
|<span class="nerdfont big">&#xe60d;</span>|seti_image|
|<span class="nerdfont big">&#xe66a;</span>|seti_info|
|<span class="nerdfont big">&#xe66b;</span>|seti_ionic|
|<span class="nerdfont big">&#xe66c;</span>|seti_jade|
|<span class="nerdfont big">&#xe66d;</span>|seti_java|
|<span class="nerdfont big">&#xe60c;</span>|seti_javascript|
|<span class="nerdfont big">&#xe66e;</span>|seti_jenkins|
|<span class="nerdfont big">&#xe66f;</span>|seti_jinja|
|<span class="nerdfont big">&#xe60b;</span>|seti_json|
|<span class="nerdfont big">&#xe624;</span>|seti_julia|
|<span class="nerdfont big">&#xe622;</span>|seti_karma|
|<span class="nerdfont big">&#xe60a;</span>|seti_license|
|<span class="nerdfont big">&#xe670;</span>|seti_liquid|
|<span class="nerdfont big">&#xe671;</span>|seti_livescript|
|<span class="nerdfont big">&#xe672;</span>|seti_lock|
|<span class="nerdfont big">&#xe620;</span>|seti_lua|
|<span class="nerdfont big">&#xe673;</span>|seti_makefile|
|<span class="nerdfont big">&#xe609;</span>|seti_markdown|
|<span class="nerdfont big">&#xe674;</span>|seti_maven|
|<span class="nerdfont big">&#xe675;</span>|seti_mdo|
|<span class="nerdfont big">&#xe60f;</span>|seti_mustache|
|<span class="nerdfont big">&#xe676;</span>|seti_new_file|
|<span class="nerdfont big">&#xe677;</span>|seti_nim|
|<span class="nerdfont big">&#xe678;</span>|seti_notebook|
|<span class="nerdfont big">&#xe616;</span>|seti_npm|
|<span class="nerdfont big">&#xe679;</span>|seti_nunjucks|
|<span class="nerdfont big">&#xe67a;</span>|seti_ocaml|
|<span class="nerdfont big">&#xe67b;</span>|seti_odata|
|<span class="nerdfont big">&#xe67c;</span>|seti_pddl|
|<span class="nerdfont big">&#xe67d;</span>|seti_pdf|
|<span class="nerdfont big">&#xe67e;</span>|seti_perl|
|<span class="nerdfont big">&#xe67f;</span>|seti_photoshop|
|<span class="nerdfont big">&#xe608;</span>|seti_php|
|<span class="nerdfont big">&#xe680;</span>|seti_pipeline|
|<span class="nerdfont big">&#xe681;</span>|seti_plan|
|<span class="nerdfont big">&#xe682;</span>|seti_platformio|
|<span class="nerdfont big">&#xe683;</span>|seti_powershell|
|<span class="nerdfont big">&#xe684;</span>|seti_prisma|
|<span class="nerdfont big">&#xe601;</span>|seti_project|
|<span class="nerdfont big">&#xe685;</span>|seti_prolog|
|<span class="nerdfont big">&#xe686;</span>|seti_pug|
|<span class="nerdfont big">&#xe631;</span>|seti_puppet|
|<span class="nerdfont big">&#xe606;</span>|seti_python|
|<span class="nerdfont big">&#xe68a;</span>|seti_r|
|<span class="nerdfont big">&#xe604;</span>|seti_rails|
|<span class="nerdfont big">&#xe625;</span>|seti_react|
|<span class="nerdfont big">&#xe687;</span>|seti_reasonml|
|<span class="nerdfont big">&#xe688;</span>|seti_rescript|
|<span class="nerdfont big">&#xe689;</span>|seti_rollup|
|<span class="nerdfont big">&#xe605;</span>|seti_ruby|
|<span class="nerdfont big">&#xe68b;</span>|seti_rust|
|<span class="nerdfont big">&#xe68c;</span>|seti_salesforce|
|<span class="nerdfont big">&#xe603;</span>|seti_sass|
|<span class="nerdfont big">&#xe68d;</span>|seti_sbt|
|<span class="nerdfont big">&#xe68e;</span>|seti_scala|
|<span class="nerdfont big">&#xe68f;</span>|seti_search|
|<span class="nerdfont big">&#xe690;</span>|seti_settings|
|<span class="nerdfont big">&#xe691;</span>|seti_shell|
|<span class="nerdfont big">&#xe692;</span>|seti_slim|
|<span class="nerdfont big">&#xe693;</span>|seti_smarty|
|<span class="nerdfont big">&#xe694;</span>|seti_spring|
|<span class="nerdfont big">&#xe695;</span>|seti_stylelint|
|<span class="nerdfont big">&#xe600;</span>|seti_stylus|
|<span class="nerdfont big">&#xe696;</span>|seti_sublime|
|<span class="nerdfont big">&#xe697;</span>|seti_svelte|
|<span class="nerdfont big">&#xe698;</span>|seti_svg|
|<span class="nerdfont big">&#xe699;</span>|seti_swift|
|<span class="nerdfont big">&#xe69a;</span>|seti_terraform|
|<span class="nerdfont big">&#xe69b;</span>|seti_tex|
|<span class="nerdfont big">&#xe69c;</span>|seti_todo|
|<span class="nerdfont big">&#xe69d;</span>|seti_tsconfig|
|<span class="nerdfont big">&#xe61c;</span>|seti_twig|
|<span class="nerdfont big">&#xe628;</span>|seti_typescript|
|<span class="nerdfont big">&#xe69e;</span>|seti_vala|
|<span class="nerdfont big">&#xe69f;</span>|seti_video|
|<span class="nerdfont big">&#xe6a0;</span>|seti_vue|
|<span class="nerdfont big">&#xe6a1;</span>|seti_wasm|
|<span class="nerdfont big">&#xe6a2;</span>|seti_wat|
|<span class="nerdfont big">&#xe6a3;</span>|seti_webpack|
|<span class="nerdfont big">&#xe6a4;</span>|seti_wgt|
|<span class="nerdfont big">&#xe6a5;</span>|seti_word|
|<span class="nerdfont big">&#xe6a6;</span>|seti_xls|
|<span class="nerdfont big">&#xe619;</span>|seti_xml|
|<span class="nerdfont big">&#xe6a7;</span>|seti_yarn|
|<span class="nerdfont big">&#xe6a8;</span>|seti_yml|
|<span class="nerdfont big">&#xe6a9;</span>|seti_zig|
|<span class="nerdfont big">&#xe6aa;</span>|seti_zip|
|<span class="nerdfont big">&#xe36e;</span>|weather_alien|
|<span class="nerdfont big">&#xe345;</span>|weather_aliens|
|<span class="nerdfont big">&#xe372;</span>|weather_barometer|
|<span class="nerdfont big">&#xe339;</span>|weather_celsius|
|<span class="nerdfont big">&#xe33d;</span>|weather_cloud|
|<span class="nerdfont big">&#xe33a;</span>|weather_cloud_down|
|<span class="nerdfont big">&#xe33b;</span>|weather_cloud_refresh|
|<span class="nerdfont big">&#xe33c;</span>|weather_cloud_up|
|<span class="nerdfont big">&#xe312;</span>|weather_cloudy|
|<span class="nerdfont big">&#xe310;</span>|weather_cloudy_gusts|
|<span class="nerdfont big">&#xe311;</span>|weather_cloudy_windy|
|<span class="nerdfont big">&#xe302;</span>|weather_day_cloudy|
|<span class="nerdfont big">&#xe300;</span>|weather_day_cloudy_gusts|
|<span class="nerdfont big">&#xe376;</span>|weather_day_cloudy_high|
|<span class="nerdfont big">&#xe301;</span>|weather_day_cloudy_windy|
|<span class="nerdfont big">&#xe303;</span>|weather_day_fog|
|<span class="nerdfont big">&#xe304;</span>|weather_day_hail|
|<span class="nerdfont big">&#xe3ae;</span>|weather_day_haze|
|<span class="nerdfont big">&#xe3bc;</span>|weather_day_light_wind|
|<span class="nerdfont big">&#xe305;</span>|weather_day_lightning|
|<span class="nerdfont big">&#xe308;</span>|weather_day_rain|
|<span class="nerdfont big">&#xe306;</span>|weather_day_rain_mix|
|<span class="nerdfont big">&#xe307;</span>|weather_day_rain_wind|
|<span class="nerdfont big">&#xe309;</span>|weather_day_showers|
|<span class="nerdfont big">&#xe3aa;</span>|weather_day_sleet|
|<span class="nerdfont big">&#xe362;</span>|weather_day_sleet_storm|
|<span class="nerdfont big">&#xe30a;</span>|weather_day_snow|
|<span class="nerdfont big">&#xe365;</span>|weather_day_snow_thunderstorm|
|<span class="nerdfont big">&#xe35f;</span>|weather_day_snow_wind|
|<span class="nerdfont big">&#xe30b;</span>|weather_day_sprinkle|
|<span class="nerdfont big">&#xe30e;</span>|weather_day_storm_showers|
|<span class="nerdfont big">&#xe30d;</span>|weather_day_sunny|
|<span class="nerdfont big">&#xe30c;</span>|weather_day_sunny_overcast|
|<span class="nerdfont big">&#xe30f;</span>|weather_day_thunderstorm|
|<span class="nerdfont big">&#xe37d;</span>|weather_day_windy|
|<span class="nerdfont big">&#xe33e;</span>|weather_degrees|
|<span class="nerdfont big">&#xe340;</span>|weather_direction_down|
|<span class="nerdfont big">&#xe33f;</span>|weather_direction_down_left|
|<span class="nerdfont big">&#xe380;</span>|weather_direction_down_right|
|<span class="nerdfont big">&#xe344;</span>|weather_direction_left|
|<span class="nerdfont big">&#xe349;</span>|weather_direction_right|
|<span class="nerdfont big">&#xe353;</span>|weather_direction_up|
|<span class="nerdfont big">&#xe37f;</span>|weather_direction_up_left|
|<span class="nerdfont big">&#xe352;</span>|weather_direction_up_right|
|<span class="nerdfont big">&#xe35d;</span>|weather_dust|
|<span class="nerdfont big">&#xe3be;</span>|weather_earthquake|
|<span class="nerdfont big">&#xe341;</span>|weather_fahrenheit|
|<span class="nerdfont big">&#xe3bf;</span>|weather_fire|
|<span class="nerdfont big">&#xe375;</span>|weather_flood|
|<span class="nerdfont big">&#xe313;</span>|weather_fog|
|<span class="nerdfont big">&#xe3c5;</span>|weather_gale_warning|
|<span class="nerdfont big">&#xe314;</span>|weather_hail|
|<span class="nerdfont big">&#xe343;</span>|weather_horizon|
|<span class="nerdfont big">&#xe342;</span>|weather_horizon_alt|
|<span class="nerdfont big">&#xe36b;</span>|weather_hot|
|<span class="nerdfont big">&#xe373;</span>|weather_humidity|
|<span class="nerdfont big">&#xe36c;</span>|weather_hurricane|
|<span class="nerdfont big">&#xe3c7;</span>|weather_hurricane_warning|
|<span class="nerdfont big">&#xe315;</span>|weather_lightning|
|<span class="nerdfont big">&#xe369;</span>|weather_lunar_eclipse|
|<span class="nerdfont big">&#xe36a;</span>|weather_meteor|
|<span class="nerdfont big">&#xe3ce;</span>|weather_moon_alt_first_quarter|
|<span class="nerdfont big">&#xe3d5;</span>|weather_moon_alt_full|
|<span class="nerdfont big">&#xe3e3;</span>|weather_moon_alt_new|
|<span class="nerdfont big">&#xe3dc;</span>|weather_moon_alt_third_quarter|
|<span class="nerdfont big">&#xe3dd;</span>|weather_moon_alt_waning_crescent_1|
|<span class="nerdfont big">&#xe3de;</span>|weather_moon_alt_waning_crescent_2|
|<span class="nerdfont big">&#xe3df;</span>|weather_moon_alt_waning_crescent_3|
|<span class="nerdfont big">&#xe3e0;</span>|weather_moon_alt_waning_crescent_4|
|<span class="nerdfont big">&#xe3e1;</span>|weather_moon_alt_waning_crescent_5|
|<span class="nerdfont big">&#xe3e2;</span>|weather_moon_alt_waning_crescent_6|
|<span class="nerdfont big">&#xe3d6;</span>|weather_moon_alt_waning_gibbous_1|
|<span class="nerdfont big">&#xe3d7;</span>|weather_moon_alt_waning_gibbous_2|
|<span class="nerdfont big">&#xe3d8;</span>|weather_moon_alt_waning_gibbous_3|
|<span class="nerdfont big">&#xe3d9;</span>|weather_moon_alt_waning_gibbous_4|
|<span class="nerdfont big">&#xe3da;</span>|weather_moon_alt_waning_gibbous_5|
|<span class="nerdfont big">&#xe3db;</span>|weather_moon_alt_waning_gibbous_6|
|<span class="nerdfont big">&#xe3c8;</span>|weather_moon_alt_waxing_crescent_1|
|<span class="nerdfont big">&#xe3c9;</span>|weather_moon_alt_waxing_crescent_2|
|<span class="nerdfont big">&#xe3ca;</span>|weather_moon_alt_waxing_crescent_3|
|<span class="nerdfont big">&#xe3cb;</span>|weather_moon_alt_waxing_crescent_4|
|<span class="nerdfont big">&#xe3cc;</span>|weather_moon_alt_waxing_crescent_5|
|<span class="nerdfont big">&#xe3cd;</span>|weather_moon_alt_waxing_crescent_6|
|<span class="nerdfont big">&#xe3cf;</span>|weather_moon_alt_waxing_gibbous_1|
|<span class="nerdfont big">&#xe3d0;</span>|weather_moon_alt_waxing_gibbous_2|
|<span class="nerdfont big">&#xe3d1;</span>|weather_moon_alt_waxing_gibbous_3|
|<span class="nerdfont big">&#xe3d2;</span>|weather_moon_alt_waxing_gibbous_4|
|<span class="nerdfont big">&#xe3d3;</span>|weather_moon_alt_waxing_gibbous_5|
|<span class="nerdfont big">&#xe3d4;</span>|weather_moon_alt_waxing_gibbous_6|
|<span class="nerdfont big">&#xe394;</span>|weather_moon_first_quarter|
|<span class="nerdfont big">&#xe39b;</span>|weather_moon_full|
|<span class="nerdfont big">&#xe38d;</span>|weather_moon_new|
|<span class="nerdfont big">&#xe3a2;</span>|weather_moon_third_quarter|
|<span class="nerdfont big">&#xe3a3;</span>|weather_moon_waning_crescent_1|
|<span class="nerdfont big">&#xe3a4;</span>|weather_moon_waning_crescent_2|
|<span class="nerdfont big">&#xe3a5;</span>|weather_moon_waning_crescent_3|
|<span class="nerdfont big">&#xe3a6;</span>|weather_moon_waning_crescent_4|
|<span class="nerdfont big">&#xe3a7;</span>|weather_moon_waning_crescent_5|
|<span class="nerdfont big">&#xe3a8;</span>|weather_moon_waning_crescent_6|
|<span class="nerdfont big">&#xe39c;</span>|weather_moon_waning_gibbous_1|
|<span class="nerdfont big">&#xe39d;</span>|weather_moon_waning_gibbous_2|
|<span class="nerdfont big">&#xe39e;</span>|weather_moon_waning_gibbous_3|
|<span class="nerdfont big">&#xe39f;</span>|weather_moon_waning_gibbous_4|
|<span class="nerdfont big">&#xe3a0;</span>|weather_moon_waning_gibbous_5|
|<span class="nerdfont big">&#xe3a1;</span>|weather_moon_waning_gibbous_6|
|<span class="nerdfont big">&#xe38e;</span>|weather_moon_waxing_crescent_1|
|<span class="nerdfont big">&#xe38f;</span>|weather_moon_waxing_crescent_2|
|<span class="nerdfont big">&#xe390;</span>|weather_moon_waxing_crescent_3|
|<span class="nerdfont big">&#xe391;</span>|weather_moon_waxing_crescent_4|
|<span class="nerdfont big">&#xe392;</span>|weather_moon_waxing_crescent_5|
|<span class="nerdfont big">&#xe393;</span>|weather_moon_waxing_crescent_6|
|<span class="nerdfont big">&#xe395;</span>|weather_moon_waxing_gibbous_1|
|<span class="nerdfont big">&#xe396;</span>|weather_moon_waxing_gibbous_2|
|<span class="nerdfont big">&#xe397;</span>|weather_moon_waxing_gibbous_3|
|<span class="nerdfont big">&#xe398;</span>|weather_moon_waxing_gibbous_4|
|<span class="nerdfont big">&#xe399;</span>|weather_moon_waxing_gibbous_5|
|<span class="nerdfont big">&#xe39a;</span>|weather_moon_waxing_gibbous_6|
|<span class="nerdfont big">&#xe3c1;</span>|weather_moonrise|
|<span class="nerdfont big">&#xe3c2;</span>|weather_moonset|
|<span class="nerdfont big">&#xe374;</span>|weather_na|
|<span class="nerdfont big">&#xe37e;</span>|weather_night_alt_cloudy|
|<span class="nerdfont big">&#xe31f;</span>|weather_night_alt_cloudy_gusts|
|<span class="nerdfont big">&#xe377;</span>|weather_night_alt_cloudy_high|
|<span class="nerdfont big">&#xe320;</span>|weather_night_alt_cloudy_windy|
|<span class="nerdfont big">&#xe321;</span>|weather_night_alt_hail|
|<span class="nerdfont big">&#xe322;</span>|weather_night_alt_lightning|
|<span class="nerdfont big">&#xe379;</span>|weather_night_alt_partly_cloudy|
|<span class="nerdfont big">&#xe325;</span>|weather_night_alt_rain|
|<span class="nerdfont big">&#xe323;</span>|weather_night_alt_rain_mix|
|<span class="nerdfont big">&#xe324;</span>|weather_night_alt_rain_wind|
|<span class="nerdfont big">&#xe326;</span>|weather_night_alt_showers|
|<span class="nerdfont big">&#xe3ac;</span>|weather_night_alt_sleet|
|<span class="nerdfont big">&#xe364;</span>|weather_night_alt_sleet_storm|
|<span class="nerdfont big">&#xe327;</span>|weather_night_alt_snow|
|<span class="nerdfont big">&#xe367;</span>|weather_night_alt_snow_thunderstorm|
|<span class="nerdfont big">&#xe361;</span>|weather_night_alt_snow_wind|
|<span class="nerdfont big">&#xe328;</span>|weather_night_alt_sprinkle|
|<span class="nerdfont big">&#xe329;</span>|weather_night_alt_storm_showers|
|<span class="nerdfont big">&#xe32a;</span>|weather_night_alt_thunderstorm|
|<span class="nerdfont big">&#xe32b;</span>|weather_night_clear|
|<span class="nerdfont big">&#xe32e;</span>|weather_night_cloudy|
|<span class="nerdfont big">&#xe32c;</span>|weather_night_cloudy_gusts|
|<span class="nerdfont big">&#xe378;</span>|weather_night_cloudy_high|
|<span class="nerdfont big">&#xe32d;</span>|weather_night_cloudy_windy|
|<span class="nerdfont big">&#xe346;</span>|weather_night_fog|
|<span class="nerdfont big">&#xe32f;</span>|weather_night_hail|
|<span class="nerdfont big">&#xe330;</span>|weather_night_lightning|
|<span class="nerdfont big">&#xe37b;</span>|weather_night_partly_cloudy|
|<span class="nerdfont big">&#xe333;</span>|weather_night_rain|
|<span class="nerdfont big">&#xe331;</span>|weather_night_rain_mix|
|<span class="nerdfont big">&#xe332;</span>|weather_night_rain_wind|
|<span class="nerdfont big">&#xe334;</span>|weather_night_showers|
|<span class="nerdfont big">&#xe3ab;</span>|weather_night_sleet|
|<span class="nerdfont big">&#xe363;</span>|weather_night_sleet_storm|
|<span class="nerdfont big">&#xe335;</span>|weather_night_snow|
|<span class="nerdfont big">&#xe366;</span>|weather_night_snow_thunderstorm|
|<span class="nerdfont big">&#xe360;</span>|weather_night_snow_wind|
|<span class="nerdfont big">&#xe336;</span>|weather_night_sprinkle|
|<span class="nerdfont big">&#xe337;</span>|weather_night_storm_showers|
|<span class="nerdfont big">&#xe338;</span>|weather_night_thunderstorm|
|<span class="nerdfont big">&#xe318;</span>|weather_rain|
|<span class="nerdfont big">&#xe316;</span>|weather_rain_mix|
|<span class="nerdfont big">&#xe317;</span>|weather_rain_wind|
|<span class="nerdfont big">&#xe371;</span>|weather_raindrop|
|<span class="nerdfont big">&#xe34a;</span>|weather_raindrops|
|<span class="nerdfont big">&#xe348;</span>|weather_refresh|
|<span class="nerdfont big">&#xe347;</span>|weather_refresh_alt|
|<span class="nerdfont big">&#xe37a;</span>|weather_sandstorm|
|<span class="nerdfont big">&#xe319;</span>|weather_showers|
|<span class="nerdfont big">&#xe3ad;</span>|weather_sleet|
|<span class="nerdfont big">&#xe3c4;</span>|weather_small_craft_advisory|
|<span class="nerdfont big">&#xe36d;</span>|weather_smog|
|<span class="nerdfont big">&#xe35c;</span>|weather_smoke|
|<span class="nerdfont big">&#xe31a;</span>|weather_snow|
|<span class="nerdfont big">&#xe35e;</span>|weather_snow_wind|
|<span class="nerdfont big">&#xe36f;</span>|weather_snowflake_cold|
|<span class="nerdfont big">&#xe368;</span>|weather_solar_eclipse|
|<span class="nerdfont big">&#xe31b;</span>|weather_sprinkle|
|<span class="nerdfont big">&#xe370;</span>|weather_stars|
|<span class="nerdfont big">&#xe31c;</span>|weather_storm_showers|
|<span class="nerdfont big">&#xe3c6;</span>|weather_storm_warning|
|<span class="nerdfont big">&#xe34b;</span>|weather_strong_wind|
|<span class="nerdfont big">&#xe34c;</span>|weather_sunrise|
|<span class="nerdfont big">&#xe34d;</span>|weather_sunset|
|<span class="nerdfont big">&#xe350;</span>|weather_thermometer|
|<span class="nerdfont big">&#xe34e;</span>|weather_thermometer_exterior|
|<span class="nerdfont big">&#xe34f;</span>|weather_thermometer_internal|
|<span class="nerdfont big">&#xe31d;</span>|weather_thunderstorm|
|<span class="nerdfont big">&#xe382;</span>|weather_time_1|
|<span class="nerdfont big">&#xe383;</span>|weather_time_2|
|<span class="nerdfont big">&#xe384;</span>|weather_time_3|
|<span class="nerdfont big">&#xe385;</span>|weather_time_4|
|<span class="nerdfont big">&#xe386;</span>|weather_time_5|
|<span class="nerdfont big">&#xe387;</span>|weather_time_6|
|<span class="nerdfont big">&#xe388;</span>|weather_time_7|
|<span class="nerdfont big">&#xe389;</span>|weather_time_8|
|<span class="nerdfont big">&#xe38a;</span>|weather_time_9|
|<span class="nerdfont big">&#xe38b;</span>|weather_time_10|
|<span class="nerdfont big">&#xe38c;</span>|weather_time_11|
|<span class="nerdfont big">&#xe381;</span>|weather_time_12|
|<span class="nerdfont big">&#xe351;</span>|weather_tornado|
|<span class="nerdfont big">&#xe3c3;</span>|weather_train|
|<span class="nerdfont big">&#xe3bd;</span>|weather_tsunami|
|<span class="nerdfont big">&#xe37c;</span>|weather_umbrella|
|<span class="nerdfont big">&#xe3c0;</span>|weather_volcano|
|<span class="nerdfont big">&#xe3af;</span>|weather_wind_beaufort_0|
|<span class="nerdfont big">&#xe3b0;</span>|weather_wind_beaufort_1|
|<span class="nerdfont big">&#xe3b1;</span>|weather_wind_beaufort_2|
|<span class="nerdfont big">&#xe3b2;</span>|weather_wind_beaufort_3|
|<span class="nerdfont big">&#xe3b3;</span>|weather_wind_beaufort_4|
|<span class="nerdfont big">&#xe3b4;</span>|weather_wind_beaufort_5|
|<span class="nerdfont big">&#xe3b5;</span>|weather_wind_beaufort_6|
|<span class="nerdfont big">&#xe3b6;</span>|weather_wind_beaufort_7|
|<span class="nerdfont big">&#xe3b7;</span>|weather_wind_beaufort_8|
|<span class="nerdfont big">&#xe3b8;</span>|weather_wind_beaufort_9|
|<span class="nerdfont big">&#xe3b9;</span>|weather_wind_beaufort_10|
|<span class="nerdfont big">&#xe3ba;</span>|weather_wind_beaufort_11|
|<span class="nerdfont big">&#xe3bb;</span>|weather_wind_beaufort_12|
|<span class="nerdfont big">&#xe3a9;</span>|weather_wind_direction|
|<span class="nerdfont big">&#xe35b;</span>|weather_wind_east|
|<span class="nerdfont big">&#xe35a;</span>|weather_wind_north|
|<span class="nerdfont big">&#xe359;</span>|weather_wind_north_east|
|<span class="nerdfont big">&#xe358;</span>|weather_wind_north_west|
|<span class="nerdfont big">&#xe357;</span>|weather_wind_south|
|<span class="nerdfont big">&#xe356;</span>|weather_wind_south_east|
|<span class="nerdfont big">&#xe355;</span>|weather_wind_south_west|
|<span class="nerdfont big">&#xe354;</span>|weather_wind_west|
|<span class="nerdfont big">&#xe31e;</span>|weather_windy|
