// Code generated by protoc-gen-go.
// source: udf.proto
// DO NOT EDIT!

/*
Package agent is a generated protocol buffer package.

It is generated from these files:
	udf.proto

It has these top-level messages:
	InfoRequest
	InfoResponse
	OptionInfo
	InitRequest
	Option
	OptionValue
	InitResponse
	SnapshotRequest
	SnapshotResponse
	RestoreRequest
	RestoreResponse
	KeepaliveRequest
	KeepaliveResponse
	ErrorResponse
	BeginBatch
	Point
	EndBatch
	Request
	Response
*/
package agent

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type EdgeType int32

const (
	EdgeType_STREAM EdgeType = 0
	EdgeType_BATCH  EdgeType = 1
)

var EdgeType_name = map[int32]string{
	0: "STREAM",
	1: "BATCH",
}
var EdgeType_value = map[string]int32{
	"STREAM": 0,
	"BATCH":  1,
}

func (x EdgeType) String() string {
	return proto.EnumName(EdgeType_name, int32(x))
}
func (EdgeType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type ValueType int32

const (
	ValueType_BOOL     ValueType = 0
	ValueType_INT      ValueType = 1
	ValueType_DOUBLE   ValueType = 2
	ValueType_STRING   ValueType = 3
	ValueType_DURATION ValueType = 4
)

var ValueType_name = map[int32]string{
	0: "BOOL",
	1: "INT",
	2: "DOUBLE",
	3: "STRING",
	4: "DURATION",
}
var ValueType_value = map[string]int32{
	"BOOL":     0,
	"INT":      1,
	"DOUBLE":   2,
	"STRING":   3,
	"DURATION": 4,
}

func (x ValueType) String() string {
	return proto.EnumName(ValueType_name, int32(x))
}
func (ValueType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Request that the process return information about available Options.
type InfoRequest struct {
}

func (m *InfoRequest) Reset()                    { *m = InfoRequest{} }
func (m *InfoRequest) String() string            { return proto.CompactTextString(m) }
func (*InfoRequest) ProtoMessage()               {}
func (*InfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type InfoResponse struct {
	Wants    EdgeType               `protobuf:"varint,1,opt,name=wants,enum=agent.EdgeType" json:"wants,omitempty"`
	Provides EdgeType               `protobuf:"varint,2,opt,name=provides,enum=agent.EdgeType" json:"provides,omitempty"`
	Options  map[string]*OptionInfo `protobuf:"bytes,3,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *InfoResponse) Reset()                    { *m = InfoResponse{} }
func (m *InfoResponse) String() string            { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()               {}
func (*InfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *InfoResponse) GetOptions() map[string]*OptionInfo {
	if m != nil {
		return m.Options
	}
	return nil
}

type OptionInfo struct {
	ValueTypes []ValueType `protobuf:"varint,1,rep,name=valueTypes,enum=agent.ValueType" json:"valueTypes,omitempty"`
}

func (m *OptionInfo) Reset()                    { *m = OptionInfo{} }
func (m *OptionInfo) String() string            { return proto.CompactTextString(m) }
func (*OptionInfo) ProtoMessage()               {}
func (*OptionInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Request that the process initialize itself with the provided options.
type InitRequest struct {
	Options []*Option `protobuf:"bytes,1,rep,name=options" json:"options,omitempty"`
	TaskID  string    `protobuf:"bytes,2,opt,name=taskID" json:"taskID,omitempty"`
	NodeID  string    `protobuf:"bytes,3,opt,name=nodeID" json:"nodeID,omitempty"`
}

func (m *InitRequest) Reset()                    { *m = InitRequest{} }
func (m *InitRequest) String() string            { return proto.CompactTextString(m) }
func (*InitRequest) ProtoMessage()               {}
func (*InitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *InitRequest) GetOptions() []*Option {
	if m != nil {
		return m.Options
	}
	return nil
}

type Option struct {
	Name   string         `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Values []*OptionValue `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
}

func (m *Option) Reset()                    { *m = Option{} }
func (m *Option) String() string            { return proto.CompactTextString(m) }
func (*Option) ProtoMessage()               {}
func (*Option) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Option) GetValues() []*OptionValue {
	if m != nil {
		return m.Values
	}
	return nil
}

type OptionValue struct {
	Type ValueType `protobuf:"varint,1,opt,name=type,enum=agent.ValueType" json:"type,omitempty"`
	// Types that are valid to be assigned to Value:
	//	*OptionValue_BoolValue
	//	*OptionValue_IntValue
	//	*OptionValue_DoubleValue
	//	*OptionValue_StringValue
	//	*OptionValue_DurationValue
	Value isOptionValue_Value `protobuf_oneof:"value"`
}

func (m *OptionValue) Reset()                    { *m = OptionValue{} }
func (m *OptionValue) String() string            { return proto.CompactTextString(m) }
func (*OptionValue) ProtoMessage()               {}
func (*OptionValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isOptionValue_Value interface {
	isOptionValue_Value()
}

type OptionValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,2,opt,name=boolValue,oneof"`
}
type OptionValue_IntValue struct {
	IntValue int64 `protobuf:"varint,3,opt,name=intValue,oneof"`
}
type OptionValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=doubleValue,oneof"`
}
type OptionValue_StringValue struct {
	StringValue string `protobuf:"bytes,5,opt,name=stringValue,oneof"`
}
type OptionValue_DurationValue struct {
	DurationValue int64 `protobuf:"varint,6,opt,name=durationValue,oneof"`
}

func (*OptionValue_BoolValue) isOptionValue_Value()     {}
func (*OptionValue_IntValue) isOptionValue_Value()      {}
func (*OptionValue_DoubleValue) isOptionValue_Value()   {}
func (*OptionValue_StringValue) isOptionValue_Value()   {}
func (*OptionValue_DurationValue) isOptionValue_Value() {}

func (m *OptionValue) GetValue() isOptionValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *OptionValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*OptionValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *OptionValue) GetIntValue() int64 {
	if x, ok := m.GetValue().(*OptionValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *OptionValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*OptionValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *OptionValue) GetStringValue() string {
	if x, ok := m.GetValue().(*OptionValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *OptionValue) GetDurationValue() int64 {
	if x, ok := m.GetValue().(*OptionValue_DurationValue); ok {
		return x.DurationValue
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OptionValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OptionValue_OneofMarshaler, _OptionValue_OneofUnmarshaler, _OptionValue_OneofSizer, []interface{}{
		(*OptionValue_BoolValue)(nil),
		(*OptionValue_IntValue)(nil),
		(*OptionValue_DoubleValue)(nil),
		(*OptionValue_StringValue)(nil),
		(*OptionValue_DurationValue)(nil),
	}
}

func _OptionValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OptionValue)
	// value
	switch x := m.Value.(type) {
	case *OptionValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *OptionValue_IntValue:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntValue))
	case *OptionValue_DoubleValue:
		b.EncodeVarint(4<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *OptionValue_StringValue:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *OptionValue_DurationValue:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.DurationValue))
	case nil:
	default:
		return fmt.Errorf("OptionValue.Value has unexpected type %T", x)
	}
	return nil
}

func _OptionValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OptionValue)
	switch tag {
	case 2: // value.boolValue
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &OptionValue_BoolValue{x != 0}
		return true, err
	case 3: // value.intValue
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &OptionValue_IntValue{int64(x)}
		return true, err
	case 4: // value.doubleValue
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &OptionValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 5: // value.stringValue
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &OptionValue_StringValue{x}
		return true, err
	case 6: // value.durationValue
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &OptionValue_DurationValue{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _OptionValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OptionValue)
	// value
	switch x := m.Value.(type) {
	case *OptionValue_BoolValue:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += 1
	case *OptionValue_IntValue:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntValue))
	case *OptionValue_DoubleValue:
		n += proto.SizeVarint(4<<3 | proto.WireFixed64)
		n += 8
	case *OptionValue_StringValue:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *OptionValue_DurationValue:
		n += proto.SizeVarint(6<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.DurationValue))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Respond to Kapacitor whether initialization was successful.
type InitResponse struct {
	Success bool   `protobuf:"varint,1,opt,name=success" json:"success,omitempty"`
	Error   string `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
}

func (m *InitResponse) Reset()                    { *m = InitResponse{} }
func (m *InitResponse) String() string            { return proto.CompactTextString(m) }
func (*InitResponse) ProtoMessage()               {}
func (*InitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// Request that the process provide a snapshot of its state.
type SnapshotRequest struct {
}

func (m *SnapshotRequest) Reset()                    { *m = SnapshotRequest{} }
func (m *SnapshotRequest) String() string            { return proto.CompactTextString(m) }
func (*SnapshotRequest) ProtoMessage()               {}
func (*SnapshotRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Respond to Kapacitor with a serialized snapshot of the running state.
type SnapshotResponse struct {
	Snapshot []byte `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (m *SnapshotResponse) Reset()                    { *m = SnapshotResponse{} }
func (m *SnapshotResponse) String() string            { return proto.CompactTextString(m) }
func (*SnapshotResponse) ProtoMessage()               {}
func (*SnapshotResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// Request that the process restore its state from a snapshot.
type RestoreRequest struct {
	Snapshot []byte `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (m *RestoreRequest) Reset()                    { *m = RestoreRequest{} }
func (m *RestoreRequest) String() string            { return proto.CompactTextString(m) }
func (*RestoreRequest) ProtoMessage()               {}
func (*RestoreRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// Respond with success or failure to a RestoreRequest
type RestoreResponse struct {
	Success bool   `protobuf:"varint,1,opt,name=success" json:"success,omitempty"`
	Error   string `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
}

func (m *RestoreResponse) Reset()                    { *m = RestoreResponse{} }
func (m *RestoreResponse) String() string            { return proto.CompactTextString(m) }
func (*RestoreResponse) ProtoMessage()               {}
func (*RestoreResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

// Request that the process respond with a Keepalive to verify it is responding.
type KeepaliveRequest struct {
	// The number of nanoseconds since the epoch.
	// Used only for debugging keepalive requests.
	Time int64 `protobuf:"varint,1,opt,name=time" json:"time,omitempty"`
}

func (m *KeepaliveRequest) Reset()                    { *m = KeepaliveRequest{} }
func (m *KeepaliveRequest) String() string            { return proto.CompactTextString(m) }
func (*KeepaliveRequest) ProtoMessage()               {}
func (*KeepaliveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

// Respond to KeepaliveRequest
type KeepaliveResponse struct {
	// The number of nanoseconds since the epoch.
	// Used only for debugging keepalive requests.
	Time int64 `protobuf:"varint,1,opt,name=time" json:"time,omitempty"`
}

func (m *KeepaliveResponse) Reset()                    { *m = KeepaliveResponse{} }
func (m *KeepaliveResponse) String() string            { return proto.CompactTextString(m) }
func (*KeepaliveResponse) ProtoMessage()               {}
func (*KeepaliveResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// Sent from the process to Kapacitor indicating an error has occurred.
// If an ErrorResponse is received, Kapacitor will terminate the process.
type ErrorResponse struct {
	Error string `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *ErrorResponse) Reset()                    { *m = ErrorResponse{} }
func (m *ErrorResponse) String() string            { return proto.CompactTextString(m) }
func (*ErrorResponse) ProtoMessage()               {}
func (*ErrorResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

// Indicates the beginning of a batch.
// All subsequent points should be considered
// part of the batch until EndBatch arrives.
// This includes grouping. Batches of
// differing groups may not be interleaved.
//
// All the meta data but tmax is provided,
// since tmax may not be known at
// the beginning of a batch.
//
// Size is the number of points in the batch.
// If size is 0 then the batch has an undetermined size.
type BeginBatch struct {
	Name   string            `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Group  string            `protobuf:"bytes,2,opt,name=group" json:"group,omitempty"`
	Tags   map[string]string `protobuf:"bytes,3,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Size   int64             `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
	ByName bool              `protobuf:"varint,5,opt,name=byName" json:"byName,omitempty"`
}

func (m *BeginBatch) Reset()                    { *m = BeginBatch{} }
func (m *BeginBatch) String() string            { return proto.CompactTextString(m) }
func (*BeginBatch) ProtoMessage()               {}
func (*BeginBatch) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *BeginBatch) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// Message containing information about a single data point.
// Can be sent on it's own or bookended by BeginBatch and EndBatch messages.
type Point struct {
	Time            int64              `protobuf:"varint,1,opt,name=time" json:"time,omitempty"`
	Name            string             `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	Database        string             `protobuf:"bytes,3,opt,name=database" json:"database,omitempty"`
	RetentionPolicy string             `protobuf:"bytes,4,opt,name=retentionPolicy" json:"retentionPolicy,omitempty"`
	Group           string             `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	Dimensions      []string           `protobuf:"bytes,6,rep,name=dimensions" json:"dimensions,omitempty"`
	Tags            map[string]string  `protobuf:"bytes,7,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	FieldsDouble    map[string]float64 `protobuf:"bytes,8,rep,name=fieldsDouble" json:"fieldsDouble,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"fixed64,2,opt,name=value"`
	FieldsInt       map[string]int64   `protobuf:"bytes,9,rep,name=fieldsInt" json:"fieldsInt,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	FieldsString    map[string]string  `protobuf:"bytes,10,rep,name=fieldsString" json:"fieldsString,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	FieldsBool      map[string]bool    `protobuf:"bytes,12,rep,name=fieldsBool" json:"fieldsBool,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	ByName          bool               `protobuf:"varint,11,opt,name=byName" json:"byName,omitempty"`
}

func (m *Point) Reset()                    { *m = Point{} }
func (m *Point) String() string            { return proto.CompactTextString(m) }
func (*Point) ProtoMessage()               {}
func (*Point) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *Point) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Point) GetFieldsDouble() map[string]float64 {
	if m != nil {
		return m.FieldsDouble
	}
	return nil
}

func (m *Point) GetFieldsInt() map[string]int64 {
	if m != nil {
		return m.FieldsInt
	}
	return nil
}

func (m *Point) GetFieldsString() map[string]string {
	if m != nil {
		return m.FieldsString
	}
	return nil
}

func (m *Point) GetFieldsBool() map[string]bool {
	if m != nil {
		return m.FieldsBool
	}
	return nil
}

// Indicates the end of a batch and contains
// all meta data associated with the batch.
// The same meta information is provided for
// ease of use with the addition of tmax since it
// may not be know at BeginBatch.
type EndBatch struct {
	Name   string            `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Group  string            `protobuf:"bytes,2,opt,name=group" json:"group,omitempty"`
	Tmax   int64             `protobuf:"varint,3,opt,name=tmax" json:"tmax,omitempty"`
	Tags   map[string]string `protobuf:"bytes,4,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ByName bool              `protobuf:"varint,5,opt,name=byName" json:"byName,omitempty"`
}

func (m *EndBatch) Reset()                    { *m = EndBatch{} }
func (m *EndBatch) String() string            { return proto.CompactTextString(m) }
func (*EndBatch) ProtoMessage()               {}
func (*EndBatch) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *EndBatch) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// Request message wrapper -- sent from Kapacitor to process
type Request struct {
	// Types that are valid to be assigned to Message:
	//	*Request_Info
	//	*Request_Init
	//	*Request_Keepalive
	//	*Request_Snapshot
	//	*Request_Restore
	//	*Request_Begin
	//	*Request_Point
	//	*Request_End
	Message isRequest_Message `protobuf_oneof:"message"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type isRequest_Message interface {
	isRequest_Message()
}

type Request_Info struct {
	Info *InfoRequest `protobuf:"bytes,1,opt,name=info,oneof"`
}
type Request_Init struct {
	Init *InitRequest `protobuf:"bytes,2,opt,name=init,oneof"`
}
type Request_Keepalive struct {
	Keepalive *KeepaliveRequest `protobuf:"bytes,3,opt,name=keepalive,oneof"`
}
type Request_Snapshot struct {
	Snapshot *SnapshotRequest `protobuf:"bytes,4,opt,name=snapshot,oneof"`
}
type Request_Restore struct {
	Restore *RestoreRequest `protobuf:"bytes,5,opt,name=restore,oneof"`
}
type Request_Begin struct {
	Begin *BeginBatch `protobuf:"bytes,16,opt,name=begin,oneof"`
}
type Request_Point struct {
	Point *Point `protobuf:"bytes,17,opt,name=point,oneof"`
}
type Request_End struct {
	End *EndBatch `protobuf:"bytes,18,opt,name=end,oneof"`
}

func (*Request_Info) isRequest_Message()      {}
func (*Request_Init) isRequest_Message()      {}
func (*Request_Keepalive) isRequest_Message() {}
func (*Request_Snapshot) isRequest_Message()  {}
func (*Request_Restore) isRequest_Message()   {}
func (*Request_Begin) isRequest_Message()     {}
func (*Request_Point) isRequest_Message()     {}
func (*Request_End) isRequest_Message()       {}

func (m *Request) GetMessage() isRequest_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Request) GetInfo() *InfoRequest {
	if x, ok := m.GetMessage().(*Request_Info); ok {
		return x.Info
	}
	return nil
}

func (m *Request) GetInit() *InitRequest {
	if x, ok := m.GetMessage().(*Request_Init); ok {
		return x.Init
	}
	return nil
}

func (m *Request) GetKeepalive() *KeepaliveRequest {
	if x, ok := m.GetMessage().(*Request_Keepalive); ok {
		return x.Keepalive
	}
	return nil
}

func (m *Request) GetSnapshot() *SnapshotRequest {
	if x, ok := m.GetMessage().(*Request_Snapshot); ok {
		return x.Snapshot
	}
	return nil
}

func (m *Request) GetRestore() *RestoreRequest {
	if x, ok := m.GetMessage().(*Request_Restore); ok {
		return x.Restore
	}
	return nil
}

func (m *Request) GetBegin() *BeginBatch {
	if x, ok := m.GetMessage().(*Request_Begin); ok {
		return x.Begin
	}
	return nil
}

func (m *Request) GetPoint() *Point {
	if x, ok := m.GetMessage().(*Request_Point); ok {
		return x.Point
	}
	return nil
}

func (m *Request) GetEnd() *EndBatch {
	if x, ok := m.GetMessage().(*Request_End); ok {
		return x.End
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Request) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Request_OneofMarshaler, _Request_OneofUnmarshaler, _Request_OneofSizer, []interface{}{
		(*Request_Info)(nil),
		(*Request_Init)(nil),
		(*Request_Keepalive)(nil),
		(*Request_Snapshot)(nil),
		(*Request_Restore)(nil),
		(*Request_Begin)(nil),
		(*Request_Point)(nil),
		(*Request_End)(nil),
	}
}

func _Request_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Request)
	// message
	switch x := m.Message.(type) {
	case *Request_Info:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Info); err != nil {
			return err
		}
	case *Request_Init:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Init); err != nil {
			return err
		}
	case *Request_Keepalive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Keepalive); err != nil {
			return err
		}
	case *Request_Snapshot:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Snapshot); err != nil {
			return err
		}
	case *Request_Restore:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Restore); err != nil {
			return err
		}
	case *Request_Begin:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Begin); err != nil {
			return err
		}
	case *Request_Point:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Point); err != nil {
			return err
		}
	case *Request_End:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.End); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Request.Message has unexpected type %T", x)
	}
	return nil
}

func _Request_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Request)
	switch tag {
	case 1: // message.info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoRequest)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Info{msg}
		return true, err
	case 2: // message.init
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InitRequest)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Init{msg}
		return true, err
	case 3: // message.keepalive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(KeepaliveRequest)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Keepalive{msg}
		return true, err
	case 4: // message.snapshot
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SnapshotRequest)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Snapshot{msg}
		return true, err
	case 5: // message.restore
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RestoreRequest)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Restore{msg}
		return true, err
	case 16: // message.begin
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BeginBatch)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Begin{msg}
		return true, err
	case 17: // message.point
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Point)
		err := b.DecodeMessage(msg)
		m.Message = &Request_Point{msg}
		return true, err
	case 18: // message.end
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndBatch)
		err := b.DecodeMessage(msg)
		m.Message = &Request_End{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Request_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Request)
	// message
	switch x := m.Message.(type) {
	case *Request_Info:
		s := proto.Size(x.Info)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_Init:
		s := proto.Size(x.Init)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_Keepalive:
		s := proto.Size(x.Keepalive)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_Snapshot:
		s := proto.Size(x.Snapshot)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_Restore:
		s := proto.Size(x.Restore)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_Begin:
		s := proto.Size(x.Begin)
		n += proto.SizeVarint(16<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_Point:
		s := proto.Size(x.Point)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Request_End:
		s := proto.Size(x.End)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message wrapper -- sent from process to Kapacitor
type Response struct {
	// Types that are valid to be assigned to Message:
	//	*Response_Info
	//	*Response_Init
	//	*Response_Keepalive
	//	*Response_Snapshot
	//	*Response_Restore
	//	*Response_Error
	//	*Response_Begin
	//	*Response_Point
	//	*Response_End
	Message isResponse_Message `protobuf_oneof:"message"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

type isResponse_Message interface {
	isResponse_Message()
}

type Response_Info struct {
	Info *InfoResponse `protobuf:"bytes,1,opt,name=info,oneof"`
}
type Response_Init struct {
	Init *InitResponse `protobuf:"bytes,2,opt,name=init,oneof"`
}
type Response_Keepalive struct {
	Keepalive *KeepaliveResponse `protobuf:"bytes,3,opt,name=keepalive,oneof"`
}
type Response_Snapshot struct {
	Snapshot *SnapshotResponse `protobuf:"bytes,4,opt,name=snapshot,oneof"`
}
type Response_Restore struct {
	Restore *RestoreResponse `protobuf:"bytes,5,opt,name=restore,oneof"`
}
type Response_Error struct {
	Error *ErrorResponse `protobuf:"bytes,6,opt,name=error,oneof"`
}
type Response_Begin struct {
	Begin *BeginBatch `protobuf:"bytes,16,opt,name=begin,oneof"`
}
type Response_Point struct {
	Point *Point `protobuf:"bytes,17,opt,name=point,oneof"`
}
type Response_End struct {
	End *EndBatch `protobuf:"bytes,18,opt,name=end,oneof"`
}

func (*Response_Info) isResponse_Message()      {}
func (*Response_Init) isResponse_Message()      {}
func (*Response_Keepalive) isResponse_Message() {}
func (*Response_Snapshot) isResponse_Message()  {}
func (*Response_Restore) isResponse_Message()   {}
func (*Response_Error) isResponse_Message()     {}
func (*Response_Begin) isResponse_Message()     {}
func (*Response_Point) isResponse_Message()     {}
func (*Response_End) isResponse_Message()       {}

func (m *Response) GetMessage() isResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Response) GetInfo() *InfoResponse {
	if x, ok := m.GetMessage().(*Response_Info); ok {
		return x.Info
	}
	return nil
}

func (m *Response) GetInit() *InitResponse {
	if x, ok := m.GetMessage().(*Response_Init); ok {
		return x.Init
	}
	return nil
}

func (m *Response) GetKeepalive() *KeepaliveResponse {
	if x, ok := m.GetMessage().(*Response_Keepalive); ok {
		return x.Keepalive
	}
	return nil
}

func (m *Response) GetSnapshot() *SnapshotResponse {
	if x, ok := m.GetMessage().(*Response_Snapshot); ok {
		return x.Snapshot
	}
	return nil
}

func (m *Response) GetRestore() *RestoreResponse {
	if x, ok := m.GetMessage().(*Response_Restore); ok {
		return x.Restore
	}
	return nil
}

func (m *Response) GetError() *ErrorResponse {
	if x, ok := m.GetMessage().(*Response_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Response) GetBegin() *BeginBatch {
	if x, ok := m.GetMessage().(*Response_Begin); ok {
		return x.Begin
	}
	return nil
}

func (m *Response) GetPoint() *Point {
	if x, ok := m.GetMessage().(*Response_Point); ok {
		return x.Point
	}
	return nil
}

func (m *Response) GetEnd() *EndBatch {
	if x, ok := m.GetMessage().(*Response_End); ok {
		return x.End
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Response) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Response_OneofMarshaler, _Response_OneofUnmarshaler, _Response_OneofSizer, []interface{}{
		(*Response_Info)(nil),
		(*Response_Init)(nil),
		(*Response_Keepalive)(nil),
		(*Response_Snapshot)(nil),
		(*Response_Restore)(nil),
		(*Response_Error)(nil),
		(*Response_Begin)(nil),
		(*Response_Point)(nil),
		(*Response_End)(nil),
	}
}

func _Response_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Response)
	// message
	switch x := m.Message.(type) {
	case *Response_Info:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Info); err != nil {
			return err
		}
	case *Response_Init:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Init); err != nil {
			return err
		}
	case *Response_Keepalive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Keepalive); err != nil {
			return err
		}
	case *Response_Snapshot:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Snapshot); err != nil {
			return err
		}
	case *Response_Restore:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Restore); err != nil {
			return err
		}
	case *Response_Error:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case *Response_Begin:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Begin); err != nil {
			return err
		}
	case *Response_Point:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Point); err != nil {
			return err
		}
	case *Response_End:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.End); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Response.Message has unexpected type %T", x)
	}
	return nil
}

func _Response_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Response)
	switch tag {
	case 1: // message.info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InfoResponse)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Info{msg}
		return true, err
	case 2: // message.init
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InitResponse)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Init{msg}
		return true, err
	case 3: // message.keepalive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(KeepaliveResponse)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Keepalive{msg}
		return true, err
	case 4: // message.snapshot
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SnapshotResponse)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Snapshot{msg}
		return true, err
	case 5: // message.restore
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RestoreResponse)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Restore{msg}
		return true, err
	case 6: // message.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ErrorResponse)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Error{msg}
		return true, err
	case 16: // message.begin
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BeginBatch)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Begin{msg}
		return true, err
	case 17: // message.point
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Point)
		err := b.DecodeMessage(msg)
		m.Message = &Response_Point{msg}
		return true, err
	case 18: // message.end
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndBatch)
		err := b.DecodeMessage(msg)
		m.Message = &Response_End{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Response_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Response)
	// message
	switch x := m.Message.(type) {
	case *Response_Info:
		s := proto.Size(x.Info)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Init:
		s := proto.Size(x.Init)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Keepalive:
		s := proto.Size(x.Keepalive)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Snapshot:
		s := proto.Size(x.Snapshot)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Restore:
		s := proto.Size(x.Restore)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Error:
		s := proto.Size(x.Error)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Begin:
		s := proto.Size(x.Begin)
		n += proto.SizeVarint(16<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_Point:
		s := proto.Size(x.Point)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Response_End:
		s := proto.Size(x.End)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*InfoRequest)(nil), "agent.InfoRequest")
	proto.RegisterType((*InfoResponse)(nil), "agent.InfoResponse")
	proto.RegisterType((*OptionInfo)(nil), "agent.OptionInfo")
	proto.RegisterType((*InitRequest)(nil), "agent.InitRequest")
	proto.RegisterType((*Option)(nil), "agent.Option")
	proto.RegisterType((*OptionValue)(nil), "agent.OptionValue")
	proto.RegisterType((*InitResponse)(nil), "agent.InitResponse")
	proto.RegisterType((*SnapshotRequest)(nil), "agent.SnapshotRequest")
	proto.RegisterType((*SnapshotResponse)(nil), "agent.SnapshotResponse")
	proto.RegisterType((*RestoreRequest)(nil), "agent.RestoreRequest")
	proto.RegisterType((*RestoreResponse)(nil), "agent.RestoreResponse")
	proto.RegisterType((*KeepaliveRequest)(nil), "agent.KeepaliveRequest")
	proto.RegisterType((*KeepaliveResponse)(nil), "agent.KeepaliveResponse")
	proto.RegisterType((*ErrorResponse)(nil), "agent.ErrorResponse")
	proto.RegisterType((*BeginBatch)(nil), "agent.BeginBatch")
	proto.RegisterType((*Point)(nil), "agent.Point")
	proto.RegisterType((*EndBatch)(nil), "agent.EndBatch")
	proto.RegisterType((*Request)(nil), "agent.Request")
	proto.RegisterType((*Response)(nil), "agent.Response")
	proto.RegisterEnum("agent.EdgeType", EdgeType_name, EdgeType_value)
	proto.RegisterEnum("agent.ValueType", ValueType_name, ValueType_value)
}

func init() { proto.RegisterFile("udf.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1151 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xc4, 0x57, 0xdd, 0x72, 0xdb, 0xc4,
	0x17, 0xaf, 0x22, 0xcb, 0x96, 0x8e, 0x9d, 0x58, 0xde, 0xe6, 0x9f, 0xea, 0x1f, 0x3a, 0x99, 0x20,
	0x68, 0x9b, 0x84, 0x62, 0xc0, 0xc0, 0x50, 0x3a, 0x05, 0x26, 0xc6, 0x86, 0x78, 0x68, 0xe3, 0x8e,
	0xe2, 0xf6, 0x5e, 0x8e, 0x36, 0xae, 0x26, 0x8e, 0x64, 0x24, 0x39, 0x60, 0xae, 0x78, 0x1c, 0x1e,
	0x80, 0x87, 0xe0, 0x82, 0x27, 0x61, 0x86, 0x77, 0x60, 0xbf, 0xb4, 0x5a, 0xd9, 0x86, 0x4c, 0x99,
	0xce, 0x70, 0xa7, 0x3d, 0xe7, 0x77, 0xbe, 0xcf, 0x9e, 0xb3, 0x02, 0x6b, 0x1e, 0x5c, 0xb4, 0x67,
	0x49, 0x9c, 0xc5, 0xc8, 0xf0, 0x27, 0x38, 0xca, 0xdc, 0x4d, 0xa8, 0x0f, 0xa2, 0x8b, 0xd8, 0xc3,
	0xdf, 0xcf, 0x71, 0x9a, 0xb9, 0x7f, 0x6a, 0xd0, 0xe0, 0xe7, 0x74, 0x16, 0x47, 0x29, 0x46, 0xf7,
	0xc0, 0xf8, 0xc1, 0x8f, 0xb2, 0xd4, 0xd1, 0xf6, 0xb5, 0x83, 0xad, 0x4e, 0xb3, 0xcd, 0xc4, 0xda,
	0xfd, 0x60, 0x82, 0x47, 0x8b, 0x19, 0xf6, 0x38, 0x17, 0xbd, 0x07, 0x26, 0x51, 0x7b, 0x1d, 0x06,
	0x38, 0x75, 0x36, 0xd6, 0x23, 0x25, 0x00, 0x3d, 0x86, 0x5a, 0x3c, 0xcb, 0x42, 0xa2, 0xdf, 0xd1,
	0xf7, 0xf5, 0x83, 0x7a, 0x67, 0x5f, 0x60, 0x55, 0xcb, 0xed, 0x21, 0x87, 0xf4, 0xa3, 0x2c, 0x59,
	0x78, 0xb9, 0xc0, 0xee, 0x33, 0x68, 0xa8, 0x0c, 0x64, 0x83, 0x7e, 0x89, 0x17, 0xcc, 0x3b, 0xcb,
	0xa3, 0x9f, 0xe8, 0x01, 0x18, 0xd7, 0xfe, 0x74, 0x8e, 0x99, 0x1f, 0xf5, 0x4e, 0x4b, 0xe8, 0xe6,
	0x52, 0xcc, 0x02, 0xe7, 0x3f, 0xde, 0x78, 0xa4, 0xb9, 0x5f, 0x02, 0x14, 0x0c, 0xf4, 0x21, 0x00,
	0x63, 0x51, 0x7f, 0x69, 0xc4, 0x3a, 0x89, 0xc3, 0x16, 0xf2, 0x2f, 0x73, 0x86, 0xa7, 0x60, 0xdc,
	0x0b, 0x9a, 0xbe, 0x30, 0x13, 0xe9, 0x23, 0xb6, 0x65, 0x64, 0x1a, 0x8b, 0x6c, 0xb3, 0x64, 0x5d,
	0x86, 0x81, 0x76, 0xa0, 0x9a, 0xf9, 0xe9, 0xe5, 0xa0, 0xc7, 0xbc, 0xb4, 0x3c, 0x71, 0xa2, 0xf4,
	0x28, 0x0e, 0x30, 0xa1, 0xeb, 0x9c, 0xce, 0x4f, 0xee, 0x09, 0x54, 0xb9, 0x0a, 0x84, 0xa0, 0x12,
	0xf9, 0x57, 0x58, 0x44, 0xcc, 0xbe, 0xd1, 0x11, 0x54, 0x99, 0x4f, 0x34, 0xf7, 0xd4, 0x2a, 0x2a,
	0x59, 0x65, 0x9e, 0x7b, 0x02, 0xe1, 0xfe, 0xa1, 0x41, 0x5d, 0xa1, 0xa3, 0x77, 0xa1, 0x92, 0x91,
	0x50, 0x44, 0x7d, 0x57, 0xa3, 0x65, 0x5c, 0xb4, 0x07, 0xd6, 0x38, 0x8e, 0xa7, 0x2f, 0x65, 0x62,
	0xcd, 0x93, 0x5b, 0x5e, 0x41, 0x42, 0x77, 0xc1, 0x0c, 0xa3, 0x8c, 0xb3, 0xa9, 0xe7, 0x3a, 0x61,
	0x4b, 0x0a, 0x72, 0xa1, 0x1e, 0xc4, 0xf3, 0xf1, 0x14, 0x73, 0x40, 0x85, 0x00, 0x34, 0x02, 0x50,
	0x89, 0x14, 0x93, 0x66, 0x49, 0x18, 0x4d, 0x38, 0xc6, 0xa0, 0xe1, 0x51, 0x8c, 0x42, 0x44, 0xf7,
	0x61, 0x33, 0x98, 0x27, 0xbe, 0x74, 0xde, 0xa9, 0x0a, 0x53, 0x65, 0x72, 0xb7, 0x26, 0x5a, 0x80,
	0x94, 0xb7, 0xc1, 0xcb, 0x23, 0xba, 0xd9, 0x81, 0x5a, 0x3a, 0x3f, 0x3f, 0xc7, 0x29, 0xef, 0x67,
	0xd3, 0xcb, 0x8f, 0x68, 0x1b, 0x0c, 0x9c, 0x24, 0x71, 0x22, 0xea, 0xc1, 0x0f, 0x6e, 0x0b, 0x9a,
	0x67, 0x91, 0x3f, 0x4b, 0x5f, 0xc5, 0x79, 0x89, 0xdd, 0x36, 0xd8, 0x05, 0x49, 0xa8, 0xdd, 0x05,
	0x33, 0x15, 0x34, 0xa6, 0xb7, 0xe1, 0xc9, 0xb3, 0xfb, 0x10, 0xb6, 0x08, 0x2e, 0x8b, 0x13, 0x9c,
	0x37, 0xc9, 0x3f, 0xa1, 0x8f, 0xa1, 0x29, 0xd1, 0xff, 0xd2, 0xe7, 0xfb, 0x60, 0x7f, 0x87, 0xf1,
	0xcc, 0x9f, 0x86, 0xd7, 0xd2, 0x24, 0x69, 0x9a, 0x2c, 0x14, 0x4d, 0xa3, 0x7b, 0xec, 0xdb, 0x7d,
	0x00, 0x2d, 0x05, 0x27, 0x8c, 0xad, 0x03, 0xde, 0x83, 0xcd, 0x3e, 0xd5, 0x2c, 0x41, 0xd2, 0xae,
	0xa6, 0xda, 0xfd, 0x5d, 0x03, 0xe8, 0xe2, 0x49, 0x18, 0x75, 0xfd, 0xec, 0xfc, 0xd5, 0xda, 0x3e,
	0x25, 0x82, 0x93, 0x24, 0x9e, 0xcf, 0x72, 0x87, 0xd9, 0x01, 0x7d, 0x40, 0x6c, 0xfa, 0x93, 0x7c,
	0x16, 0xbc, 0x25, 0x3a, 0xb0, 0x50, 0xd5, 0x1e, 0x11, 0x2e, 0x1f, 0x03, 0x0c, 0x48, 0x55, 0xa7,
	0xe1, 0x4f, 0xbc, 0x8f, 0x88, 0x93, 0xf4, 0x9b, 0x5e, 0x9c, 0xf1, 0xe2, 0x94, 0x1a, 0x34, 0x58,
	0x92, 0xc4, 0x69, 0xf7, 0x33, 0xb0, 0xa4, 0xf8, 0x9a, 0x61, 0xb1, 0xad, 0x0e, 0x0b, 0x4b, 0x9d,
	0x0c, 0xbf, 0x54, 0xc1, 0x78, 0x1e, 0x93, 0x16, 0x5e, 0x97, 0x13, 0x19, 0xdd, 0x86, 0x12, 0x1d,
	0xa9, 0x6b, 0xe0, 0x67, 0xfe, 0xd8, 0x4f, 0xb1, 0xb8, 0xbd, 0xf2, 0x8c, 0x0e, 0xa0, 0x99, 0xe0,
	0x8c, 0xc4, 0x45, 0x7a, 0xf4, 0x79, 0x3c, 0x0d, 0xcf, 0x17, 0xcc, 0x7b, 0xcb, 0x5b, 0x26, 0x17,
	0x39, 0x32, 0xd4, 0x1c, 0xed, 0x01, 0x04, 0xc4, 0x6e, 0x94, 0xb2, 0xd9, 0x52, 0x25, 0x99, 0xb2,
	0x3c, 0x85, 0x42, 0x26, 0x00, 0xcf, 0x61, 0x8d, 0xe5, 0x70, 0x47, 0xe4, 0x90, 0xf9, 0xbf, 0x92,
	0xbe, 0x2e, 0x34, 0x2e, 0x42, 0x3c, 0x0d, 0xd2, 0x1e, 0xbb, 0x7e, 0x8e, 0xc9, 0x64, 0xf6, 0x4a,
	0x32, 0xdf, 0x28, 0x00, 0x2e, 0x5b, 0x92, 0x41, 0x9f, 0x83, 0xc5, 0xcf, 0x83, 0x28, 0x73, 0xac,
	0x52, 0xe1, 0x54, 0x05, 0x84, 0xcb, 0xa5, 0x0b, 0x74, 0x61, 0xfe, 0x8c, 0xdd, 0x6c, 0x07, 0xfe,
	0xd6, 0x3c, 0x07, 0x94, 0xcc, 0x73, 0x12, 0x7a, 0x02, 0xc0, 0xcf, 0x5d, 0x32, 0x81, 0x9c, 0x06,
	0xd3, 0x70, 0x77, 0x8d, 0x06, 0xca, 0xe6, 0xf2, 0x0a, 0x5e, 0xe9, 0x95, 0xfa, 0x1b, 0xe9, 0x95,
	0xdd, 0xaf, 0xa0, 0xb5, 0x92, 0xb0, 0x9b, 0x14, 0x68, 0xaa, 0x82, 0x27, 0xb0, 0x55, 0x4e, 0xd8,
	0x4d, 0xd2, 0xfa, 0x5a, 0xf3, 0x4a, 0xc2, 0x5e, 0xcb, 0xff, 0x2f, 0xa0, 0xb9, 0x94, 0xaf, 0x9b,
	0xc4, 0x4d, 0xf5, 0xaa, 0xfc, 0xa6, 0x81, 0xd9, 0x8f, 0x82, 0xd7, 0xbd, 0xf7, 0xf4, 0x5e, 0x5d,
	0xf9, 0x3f, 0xf2, 0x7d, 0xe1, 0xb1, 0x6f, 0xf4, 0xbe, 0xe8, 0xe3, 0x0a, 0x2b, 0xe9, 0xff, 0xf3,
	0x37, 0x84, 0x50, 0xbe, 0xd2, 0xca, 0x6f, 0xfc, 0xd6, 0xff, 0xac, 0x43, 0x2d, 0x1f, 0x9a, 0x07,
	0x50, 0x09, 0xc9, 0xab, 0x80, 0x09, 0x16, 0x3b, 0x55, 0x79, 0x2d, 0x91, 0xc5, 0xc3, 0x10, 0x1c,
	0x19, 0x66, 0xe2, 0xc5, 0x51, 0x20, 0xe5, 0xc3, 0x80, 0x23, 0xc3, 0x0c, 0x11, 0xc7, 0x2e, 0xf3,
	0xa1, 0xcb, 0x02, 0xaf, 0x77, 0xee, 0x08, 0xf8, 0xf2, 0xd0, 0xa6, 0x0b, 0x56, 0x62, 0xd1, 0x27,
	0xca, 0xd2, 0xa8, 0x30, 0xb9, 0xfc, 0x92, 0x2f, 0x2d, 0x28, 0xba, 0x78, 0x73, 0x24, 0xfa, 0x08,
	0x6a, 0x09, 0x5f, 0x27, 0x2c, 0x41, 0xf5, 0xce, 0xff, 0x84, 0x50, 0x79, 0x25, 0x11, 0x99, 0x1c,
	0x87, 0x0e, 0xc1, 0x18, 0xd3, 0xd1, 0xeb, 0xd8, 0xa5, 0xe7, 0x53, 0x31, 0x8e, 0x09, 0x98, 0x23,
	0xc8, 0xd3, 0xc1, 0x98, 0xd1, 0xcb, 0xe6, 0xb4, 0x18, 0xb4, 0xa1, 0x5e, 0x40, 0x8a, 0x62, 0x4c,
	0xf4, 0x0e, 0xe8, 0x38, 0x0a, 0x1c, 0xc4, 0x30, 0xcd, 0xa5, 0x8a, 0x12, 0x18, 0xe5, 0x76, 0x2d,
	0xa8, 0x5d, 0x91, 0x95, 0x46, 0x98, 0xee, 0xaf, 0x3a, 0x98, 0x72, 0xd5, 0x1c, 0x96, 0x6a, 0x70,
	0x7b, 0xcd, 0x3b, 0x51, 0x16, 0xe1, 0xb0, 0x54, 0x84, 0xdb, 0xa5, 0x22, 0xa8, 0x50, 0x52, 0x85,
	0x47, 0xab, 0x55, 0x70, 0x56, 0xab, 0x20, 0x85, 0x94, 0x32, 0x7c, 0xba, 0x52, 0x86, 0x3b, 0x2b,
	0x65, 0x90, 0x72, 0x45, 0x1d, 0x3a, 0xcb, 0x75, 0xd8, 0x59, 0xae, 0x83, 0x14, 0x92, 0x85, 0x78,
	0x98, 0x6f, 0xd9, 0x2a, 0x93, 0xd8, 0xce, 0x33, 0xa7, 0xae, 0x62, 0x9a, 0x65, 0x06, 0xfa, 0xcf,
	0xcb, 0x76, 0xf4, 0x36, 0x99, 0x01, 0xe2, 0xa9, 0x8f, 0x00, 0xaa, 0x67, 0x23, 0xaf, 0x7f, 0xfc,
	0xcc, 0xbe, 0x85, 0x2c, 0x30, 0xba, 0xc7, 0xa3, 0xaf, 0x4f, 0x6c, 0xed, 0xa8, 0x07, 0x96, 0x7c,
	0x57, 0x22, 0x13, 0x2a, 0xdd, 0xe1, 0xf0, 0x29, 0x41, 0xd4, 0x40, 0x1f, 0x9c, 0x8e, 0x6c, 0x8d,
	0x8a, 0xf5, 0x86, 0x2f, 0xba, 0x4f, 0xfb, 0xf6, 0x86, 0x50, 0x31, 0x38, 0xfd, 0xd6, 0xd6, 0x51,
	0x03, 0xcc, 0xde, 0x0b, 0xef, 0x78, 0x34, 0x18, 0x9e, 0xda, 0x95, 0x71, 0x95, 0xfd, 0xbf, 0x7c,
	0xfc, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x71, 0xb7, 0xac, 0x48, 0xcc, 0x0c, 0x00, 0x00,
}
