#include "defs.h"
#include <stdio.h>
#include "printtext.h"
#include "imageio.h"
#include "enhance.h"
#include "arglist.h"
#ifdef USE_CLUSTER
#include "cluster.h"
#endif

void printerrorstring(char* title,char *errormessage) {

   if (errormessage!=NULL) fprintf(stderr,"%s: Error: %s!\n\n",title,errormessage);
   fprintf(stderr,"This program will create an image containing\n   the highlights of the detected edges in the specified source image!\n\n");
   fprintf(stderr,"Usage: %s [ -s <value> | --size=<value> ] \\\n        [ -a <value> | --amount=<value> ] \\\n        [ -q <value> | --quality=<value> ] \\\n",title);
#ifdef USE_CLUSTER
   fprintf(stderr,"        [ -j <threads> ] \\\n");
#endif
   fprintf(stderr,"        <source1> [<destination>] [[--help] [-h]\n\n");
   fprintf(stderr,"    size: The brush size for edge enhancing in 1/100 pixels.\n");
   fprintf(stderr,"          default is \"--size=400\"\n");
   fprintf(stderr,"  amount: Enlightenment factor in %% for edges found.\n");
   fprintf(stderr,"          default is \"--amount=2000\"\n");
   fprintf(stderr," quality: Size of the destination image in %%\n");
   fprintf(stderr,"          default is \"--quality=50\"\n");
   fprintf(stderr,"          (maximum is 100)\n\n");
}

int main (int argc, char *argv[]) {
   ImagePtr imsource, imdest;	/*Working images*/
   int answer;			/*return value*/
   int size,amount,quality;		/*option parameters*/
   char* valuechar;		/*option chars*/
   struct arglist* carglist;	/*commandline options*/
#ifdef USE_CLUSTER
   int threads;					/*number of threads*/
#endif

   carglist = arglist_new(argc, argv);
   arglist_addarg (carglist,"--help",0);
   arglist_addarg (carglist,"-h",0);
   arglist_addarg (carglist,"-s",1);
   arglist_addarg (carglist,"--size",1);
   arglist_addarg (carglist,"-a",1);
   arglist_addarg (carglist,"--amount",1);
   arglist_addarg (carglist,"-q",1);
   arglist_addarg (carglist,"--quality",1);
   arglist_addarg (carglist,"-j",1);

   printwelcomestring();

   if ((arglist_arggiven(carglist,"--help")==0) || (arglist_arggiven(carglist,"-h")==0)) {
      printerrorstring(argv[0],NULL);
      printusagestring();
      return -1;
   }

   if ((arglist_parameter(carglist,"VOIDARGS",2)!=NULL) || (arglist_parameter(carglist,"VOIDARGS",0)==NULL)){
      printerrorstring(argv[0],"Error parsing commandline");
      printusagestring();
      return -1;
   }
   /*Check parameter count*/

#ifdef USE_CLUSTER
   threads=DEFAULT_THREADS;
   if (arglist_arggiven(carglist,"-j")==0) {
      threads=arglist_integer(arglist_parameter(carglist,"-j",0));
   }
   if (threads<1) {
      printerrorstring(argv[0],"Error parsing commandline,\nprocess amount <threads> has to be greater 0.");
      printusagestring();
      return -1;
   }
   /*Check process count */

   cluster_setpnum(threads);
#endif

   if ((arglist_arggiven(carglist,"--quality")==0) || (arglist_arggiven(carglist,"-q")==0)) {
      valuechar=arglist_parameter(carglist,"-q",0);
      if (valuechar==NULL) {
         valuechar=arglist_parameter(carglist,"--quality",0);
      }
      quality=arglist_integer(valuechar);
      if (quality<=0) {
         printerrorstring(argv[0],"Error parsing commandline,\nquality <value> has to be any positive interger");
         printusagestring();
         return -1;
      }
   } else {
      quality=50;
   }

   if ((arglist_arggiven(carglist,"--amount")==0) || (arglist_arggiven(carglist,"-a")==0)) {
      valuechar=arglist_parameter(carglist,"-a",0);
      if (valuechar==NULL) {
         valuechar=arglist_parameter(carglist,"--amount",0);
      }
      amount=arglist_integer(valuechar);
      if (amount<=0) {
         printerrorstring(argv[0],"Error parsing commandline,\namount <value> has to be any positive interger");
         printusagestring();
         return -1;
      }
   } else {
      amount=2000;
   }

   if ((arglist_arggiven(carglist,"--size")==0) || (arglist_arggiven(carglist,"-s")==0)) {
      valuechar=arglist_parameter(carglist,"-s",0);
      if (valuechar==NULL) {
         valuechar=arglist_parameter(carglist,"--size",0);
      }
      size=arglist_integer(valuechar);
      if (size<=0) {
         printerrorstring(argv[0],"Error parsing commandline,\nsize <value> has to be any positive interger");
         printusagestring();
         return -1;
      }
   } else {
      size=400;
   }

   imsource=loadim(arglist_parameter(carglist,"VOIDARGS",0));
   if (imsource==NULL) {
      printerrorstring(argv[0],"Error loading source image 1");
      printusagestring();
      return -1;
   }
   /*Load Sourcefile*/

   answer=enhance(&imdest,imsource,size,amount,quality);
   /*Do the main work in enhance.h*/

   if (arglist_parameter(carglist,"VOIDARGS",1)!=NULL) {
      if (saveim(imdest,arglist_parameter(carglist,"VOIDARGS",1))!=0) {
         printerrorstring(argv[0],"Error saving destination image");
      }
      /*Save the resulting image*/
   }

   destroyim(imsource);
   destroyim(imdest);
   /*We free our memory*/

   fprintf(stderr,"Total amount of edge enhancement is:\n");
   fprintf(stdout,"%i\n",answer);
   
   arglist_kill(carglist);
   /*i forgot to kill the commandline argument list*/

   return 0;

}
