/*
 *   idevice.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                         
 *   blwtt.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
//  This class encapsulates everything needed to track call restrictions
//  for an individual device such as modem, fax.  This class is
//  built up using an array of the UnsuccessfulRecord class.  An overview
//  of operations can be found in mwbl.txt.
//
//  All public functions in this class must be protected so that only
//  one operates at a time.  This is the responsibility of the calling code.
//  This will prevent problems between the viewer and the devices using
//  blacklist services.  The case where a reset occurs while a device is
//  dialing (has a dial handle checked out) is allowed for in the DialResults
//  function.
//
//
//
//
//
//****************************************************************************

#if !defined(DEVICE_H)
#define DEVICE_H  1


//---- includes --------------------------------------------------------------

#include <unsucces.h>


//---- defines ---------------------------------------------------------------

  // This defines the maximum number of phone numbers that will be tracked for
  // each device type.
  #define MAX_BL_NUMBER_LIST       20

  // This define is used to specify that the dial handle for a manual call
  // does not point to an UnsuccessfulRecord
  #define NO_RECORD                            MAX_BL_NUMBER_LIST + 1

  // This define is used to initalize a dial handle to nothing.  Zero is
  // a valid arrary index value but is not a valid dial handle.
  #define NO_DIAL_HANDLE                       0



//-----------------------------------------------------------------------------
typedef struct _blDevice
{
  // This marks if an instantiation is reserved by a device.
  BOOL   bDeviceReserved;
  
  // This records the device type (from mwblapi.h) of the device that has
  // reserved this instance.
  ULONG  ulDeviceType;

  // This records the name of the device that has reserved this instance.
  char   szDeviceName[MAX_DEVICE_NAME_SIZE];

  // This specifies if this instance of a Device has been initialized.
  // The memory gets initialized during construction but can also be initialized
  // at any time during execution.
  BOOL   bInitialized;

  // The stores the last dial time stamp to be used in usAllCallDelay enforcement.
  time_t LastDeviceDialTime;

  // The records the dial handle given out when permission to dial was granted.
  ULONG  ulDialHandleInUse;

  // Used to remember the type of dial being made:  manual or automatic
  ULONG  ulDialTypeInUse;

  // This instantiates an array of UnsuccessfulRecord objects to handle
  // individual phone numbers call unsuccessfully by this device.
  UnsuccessfulRecord Unsuccessful[MAX_BL_NUMBER_LIST];

} blDevice;

void devInitDevice(blDevice *pDev);
ULONG devReset (blDevice *pDev);
ULONG devRegister(blDevice *pDev, ULONG ulLocalDeviceType, char FAR * lpszDeviceName);
ULONG devUnregister(blDevice *pDev);
ULONG devRequestDialPermission (blDevice *pDev, ULONG ulDialType,
				char  FAR *lpszPhoneNumber,
				ULONG FAR *lpulDialStatus,
				ULONG FAR *lpulDialHandle,
				ULONG FAR *lpulDelayTime);
ULONG devDialResults (blDevice *pDev, ULONG ulDialHandle, ULONG ulDialStatus);
ULONG devGetInfo  (blDevice *pDev, struct BL_Settings FAR *lpBLsettings);
ULONG devGetNumberList (blDevice *pDev, ULONG ulMaxListSize,
			struct BL_NumberListItem FAR *lpNumberList);
ULONG devInternalReset (blDevice *pDev);
ULONG devFindDialHandle (blDevice *pDev, char FAR *lpszPhoneNumber, ULONG ulDialType,
			 ULONG FAR *lpulDialHandle);
ULONG devIsDeviceReserved(blDevice *pDev);
#endif // !defined(DEVICE_H)
