/*
 *   mwmdash.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*****************************************************************************/
/* These routines handle the parsing of "-" (dash) AT Commands.              */
/* mwmDashCommand is called from mwmCmdParseATcmd when an '&' is encountered */
/* in the AT command string.                                                 */
/* If the following character is recognized as a valid Ampersand Command,    */
/* the appropriate routine is called.  If not, MWM_ATCMD_ERROR is returned.  */
/*****************************************************************************/
#include "mwmparse.h"
#include "mwmparsi.h"
#include "v42itcb.h"
#include "stddef.h"

USHORT mwmDashCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
  USHORT usCommandLength = 0;
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmdash::mwmDashCommand entry\n");
  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"J",strlen("J"))) {
    /*************************************************************************/
    /* This is a -J command....                                              */
    /*************************************************************************/
    usCommandLength = strlen("J");
    psi->usNextATIndex += usCommandLength;
    
    /*************************************************************************/
    /* If the PP results of this command will fit into the buffer.           */
    /*************************************************************************/
    if ( (psi->usNextPPIndex + PP_DASH_J_CMD_SPACE) < PP_BUFFER_THRESHOLD) {
      /***********************************************************************/
      /* Get the parameter from the command string                           */
      /***********************************************************************/
      usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                          &psi->usNextATIndex);
      
      usParserStatus = mwmDashJCommand(psi, usParm);
      
    } else {
      /***********************************************************************/
      /* There is not enough room left in this PP Command buffer to          */
      /* process this command....                                            */
      /***********************************************************************/
      usParserStatus = MWM_GET_MORE_BUFFERS;
      psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
    }
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SSE",strlen("SSE")))
  {
    /*************************************************************************/
    /* This is a -SSE command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SSE");
    psi->usNextATIndex += usCommandLength;

    /*************************************************************************/
    /* Step over = if there is one.                                          */
    /*************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '=')
    {
      psi->usNextATIndex++;
      usCommandLength++;
    }

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);


    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SMT=",strlen("SMT=")))
  {
    /*************************************************************************/
    /* This is a -SMT= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SMT=");
    psi->usNextATIndex += usCommandLength;
    
    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SMT?",strlen("SMT?")))
  {
    /*************************************************************************/
    /* This is a -SMT? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SMT?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SMT0",strlen("SMT0")))
  {
    /*************************************************************************/
    /* This is a -SMT0 command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SMT0");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SMT1",strlen("SMT1")))
  {
    /*************************************************************************/
    /* This is a -SMT1 command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SMT1");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SVV",strlen("SVV")))
  {
    /*************************************************************************/
    /* This is a -SVV command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SVV");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SAC",strlen("SAC")))
  {
    /*************************************************************************/
    /* This is a -SAC command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SAC");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SSQ",strlen("SSQ")))
  {
    /*************************************************************************/
    /* This is a -SSQ command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SSQ");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SDA",strlen("SDA")))
  {
    /*************************************************************************/
    /* This is a -SDA command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SDA");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SIP0",strlen("SIP0")))
  {
    /*************************************************************************/
    /* This is a -SIP0 command.... (treat like -SIP)                         */
    /*************************************************************************/
    usCommandLength = strlen("SIP0");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SIP",strlen("SIP")))
  {
    /*************************************************************************/
    /* This is a -SIP command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SIP");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SIC",strlen("SIC")))
  {
    /*************************************************************************/
    /* This is a -SIC command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("SIC");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SSP=",strlen("SSP=")))
  {
    /*************************************************************************/
    /* This is a -SSP= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SSP=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SSP?",strlen("SSP?")))
  {
    /*************************************************************************/
    /* This is a -SSP? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SSP?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SDS=",strlen("SDS=")))
  {
    /*************************************************************************/
    /* This is a -SDS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SDS=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SDS?",strlen("SDS?")))
  {
    /*************************************************************************/
    /* This is a -SDS? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SDS?");
    psi->usNextATIndex += usCommandLength;
    
    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SCD=",strlen("SCD=")))
  {
    /*************************************************************************/
    /* This is a -SCD= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SCD=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SCD?",strlen("SCD?")))
  {
    /*************************************************************************/
    /* This is a -SCD? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SCD?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SQR=",strlen("SQR=")))
  {
    /*************************************************************************/
    /* This is a -SQR= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SQR=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SQR?",strlen("SQR?")))
  {
    /*************************************************************************/
    /* This is a -SQR? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SQR?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SSR=",strlen("SSR=")))
  {
    /*************************************************************************/
    /* This is a -SSR= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SSR=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SSR?",strlen("SSR?")))
  {
    /*************************************************************************/
    /* This is a -SSR? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SSR?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SER?",strlen("SER?")))
  {
    /*************************************************************************/
    /* This is a -SER? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SER?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SDR=",strlen("SDR=")))
  {
    /*************************************************************************/
    /* This is a -SDR= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SDR=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmCidpDashSDRCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SDR?",strlen("SDR?")))
  {
    /*************************************************************************/
    /* This is a #SDR? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SDR?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmCidpDRingQuery(psi);
  }

  else
    usParserStatus = MWM_ATCMD_ERROR;


  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex-= usCommandLength;

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmdash::mwmDashCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT mwmDashJCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmdash::mwmDashJCommand entry\n");
  if (usParm < 2)
  {
/*    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2A | psi->usParserMode);*/
/*    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;*/
    /**********************************************************************/
    /* Update Register                                                    */
    /**********************************************************************/
    mwmParseQueryModemRegisters(&Registers);
    Registers.DashJ = usParm;
    mwmParseSetModemRegisters(&Registers);

  }
  else
    usParserStatus = MWM_ATCMD_ERROR;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmdash::mwmDashJCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}















