/* theme.c generated by valac 0.46.3, the Vala compiler
 * generated from theme.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>

#define PASANG_TYPE_THEME_ITEM (pasang_theme_item_get_type ())
typedef struct _PasangThemeItem PasangThemeItem;

#define PASANG_TYPE_THEME (pasang_theme_get_type ())
#define PASANG_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME, PasangTheme))
#define PASANG_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME, PasangThemeClass))
#define PASANG_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME))
#define PASANG_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME))
#define PASANG_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME, PasangThemeClass))

typedef struct _PasangTheme PasangTheme;
typedef struct _PasangThemeClass PasangThemeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PASANG_TYPE_FILM (pasang_film_get_type ())
typedef struct _PasangFilm PasangFilm;
typedef struct _PasangThemePrivate PasangThemePrivate;

#define PASANG_TYPE_GAME_VIEW (pasang_game_view_get_type ())
#define PASANG_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_VIEW, PasangGameView))
#define PASANG_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))
#define PASANG_IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_VIEW))
#define PASANG_IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_VIEW))
#define PASANG_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))

typedef struct _PasangGameView PasangGameView;
typedef struct _PasangGameViewClass PasangGameViewClass;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;
enum  {
	PASANG_THEME_0_PROPERTY,
	PASANG_THEME_TIME_SPAN_PROPERTY,
	PASANG_THEME_NUM_PROPERTIES
};
static GParamSpec* pasang_theme_properties[PASANG_THEME_NUM_PROPERTIES];

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
typedef struct _PasangMovePrivate PasangMovePrivate;
typedef struct _PasangGamePrivate PasangGamePrivate;
typedef struct _PasangGameViewPrivate PasangGameViewPrivate;

#define PASANG_TYPE_GAME_SERIES (pasang_game_series_get_type ())
#define PASANG_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeries))
#define PASANG_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))
#define PASANG_IS_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_SERIES))
#define PASANG_IS_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_SERIES))
#define PASANG_GAME_SERIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))

typedef struct _PasangGameSeries PasangGameSeries;
typedef struct _PasangGameSeriesClass PasangGameSeriesClass;

#define PASANG_TYPE_THEME_SWITCH (pasang_theme_switch_get_type ())
#define PASANG_THEME_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitch))
#define PASANG_THEME_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitchClass))
#define PASANG_IS_THEME_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME_SWITCH))
#define PASANG_IS_THEME_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME_SWITCH))
#define PASANG_THEME_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME_SWITCH, PasangThemeSwitchClass))

typedef struct _PasangThemeSwitch PasangThemeSwitch;
typedef struct _PasangThemeSwitchClass PasangThemeSwitchClass;
typedef struct _PasangThemeSwitchPrivate PasangThemeSwitchPrivate;
enum  {
	PASANG_THEME_SWITCH_0_PROPERTY,
	PASANG_THEME_SWITCH_THEME_PROPERTY,
	PASANG_THEME_SWITCH_NUM_PROPERTIES
};
static GParamSpec* pasang_theme_switch_properties[PASANG_THEME_SWITCH_NUM_PROPERTIES];

#define PASANG_TYPE_THEME2_D (pasang_theme2_d_get_type ())
#define PASANG_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_D, PasangTheme2D))
#define PASANG_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_D, PasangTheme2DClass))
#define PASANG_IS_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_D))
#define PASANG_IS_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_D))
#define PASANG_THEME2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_D, PasangTheme2DClass))

typedef struct _PasangTheme2D PasangTheme2D;
typedef struct _PasangTheme2DClass PasangTheme2DClass;

#define PASANG_TYPE_THEME2_DCAIRO (pasang_theme2_dcairo_get_type ())
#define PASANG_THEME2_DCAIRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairo))
#define PASANG_THEME2_DCAIRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairoClass))
#define PASANG_IS_THEME2_DCAIRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_DCAIRO))
#define PASANG_IS_THEME2_DCAIRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_DCAIRO))
#define PASANG_THEME2_DCAIRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_DCAIRO, PasangTheme2DCairoClass))

typedef struct _PasangTheme2DCairo PasangTheme2DCairo;
typedef struct _PasangTheme2DCairoClass PasangTheme2DCairoClass;

#define PASANG_TYPE_THEME2_DFILE (pasang_theme2_dfile_get_type ())
#define PASANG_THEME2_DFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_DFILE, PasangTheme2DFile))
#define PASANG_THEME2_DFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_DFILE, PasangTheme2DFileClass))
#define PASANG_IS_THEME2_DFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_DFILE))
#define PASANG_IS_THEME2_DFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_DFILE))
#define PASANG_THEME2_DFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_DFILE, PasangTheme2DFileClass))

typedef struct _PasangTheme2DFile PasangTheme2DFile;
typedef struct _PasangTheme2DFileClass PasangTheme2DFileClass;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
enum  {
	PASANG_THEME_SWITCH_CHANGED_SIGNAL,
	PASANG_THEME_SWITCH_NUM_SIGNALS
};
static guint pasang_theme_switch_signals[PASANG_THEME_SWITCH_NUM_SIGNALS] = {0};

struct _PasangThemeItem {
	gchar* name;
	gchar* path;
	GdkPixbuf* pixbuf;
	gchar* license;
	gchar* artist;
	gchar* comment;
	PasangTheme* engine;
};

struct _PasangFilm {
	gint stop;
	gint length;
	gint viewed;
	gint n;
};

struct _PasangPoint {
	gint x;
	gint y;
};

struct _PasangTheme {
	GObject parent_instance;
	PasangThemePrivate * priv;
	PasangThemeItem* items;
	gint items_length1;
	gint _items_size_;
	PasangFilm* films;
	gint films_length1;
	gint _films_size_;
	gint* cycles;
	gint cycles_length1;
	gint _cycles_size_;
};

struct _PasangThemeClass {
	GObjectClass parent_class;
	PasangTheme* (*select) (PasangTheme* self, const gchar* path, gint width, gint height);
	void (*resize) (PasangTheme* self, gint width, gint height);
	void (*free) (PasangTheme* self);
	void (*draw) (PasangTheme* self, PasangGameView* game_view, cairo_t* cr);
	void (*queue_draw_piece) (PasangTheme* self, GtkDrawingArea* view, PasangPiece piece, PasangPoint* p);
	gint (*count_frames) (PasangTheme* self, PasangPiece piece);
	void (*to_point) (PasangTheme* self, gint pos, gboolean rotated, PasangPoint* result);
	gint (*to_position) (PasangTheme* self, PasangGame* game, PasangPoint* p, gboolean rotated, gboolean precise);
	gint (*to_side) (PasangTheme* self, PasangPoint* p);
};

struct _PasangThemePrivate {
	gdouble _time_span;
	gdouble prev_lapse;
	PasangPoint prev_kas_point;
};

struct _PasangMove {
	GObject parent_instance;
	PasangMovePrivate * priv;
	gint* booties;
	gint booties_length1;
};

struct _PasangMoveClass {
	GObjectClass parent_class;
};

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

struct _PasangGameView {
	GtkDrawingArea parent_instance;
	PasangGameViewPrivate * priv;
	PasangPoint kas_point;
};

struct _PasangGameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PasangThemeSwitch {
	GtkBox parent_instance;
	PasangThemeSwitchPrivate * priv;
};

struct _PasangThemeSwitchClass {
	GtkBoxClass parent_class;
};

struct _PasangThemeSwitchPrivate {
	PasangTheme* _theme;
	PasangTheme** themes;
	gint themes_length1;
	gint _themes_size_;
	PasangThemeItem* theme_items;
	gint theme_items_length1;
	gint _theme_items_size_;
	GtkAllocation size;
	GtkTreeView* tree_view;
	GtkTreeSelection* tree_selection;
	GtkListStore* tree_model;
};

static gint PasangTheme_private_offset;
static gpointer pasang_theme_parent_class = NULL;
static gint PasangThemeSwitch_private_offset;
static gpointer pasang_theme_switch_parent_class = NULL;

GType pasang_theme_item_get_type (void) G_GNUC_CONST;
GType pasang_theme_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme, g_object_unref)
PasangThemeItem* pasang_theme_item_dup (const PasangThemeItem* self);
void pasang_theme_item_free (PasangThemeItem* self);
void pasang_theme_item_copy (const PasangThemeItem* self,
                             PasangThemeItem* dest);
void pasang_theme_item_destroy (PasangThemeItem* self);
void pasang_theme_item_init (PasangThemeItem *self);
GType pasang_film_get_type (void) G_GNUC_CONST;
PasangFilm* pasang_film_dup (const PasangFilm* self);
void pasang_film_free (PasangFilm* self);
void pasang_film_init (PasangFilm *self);
GType pasang_game_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameView, g_object_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
static void _vala_PasangThemeItem_array_free (PasangThemeItem * array,
                                       gint array_length);
#define PASANG_BOARD_SIZE (13 * 13)
PasangTheme* pasang_theme_select (PasangTheme* self,
                                  const gchar* path,
                                  gint width,
                                  gint height);
static PasangTheme* pasang_theme_real_select (PasangTheme* self,
                                       const gchar* path,
                                       gint width,
                                       gint height);
void pasang_theme_resize (PasangTheme* self,
                          gint width,
                          gint height);
static void pasang_theme_real_resize (PasangTheme* self,
                               gint width,
                               gint height);
void pasang_theme_free (PasangTheme* self);
static void pasang_theme_real_free (PasangTheme* self);
void pasang_theme_draw (PasangTheme* self,
                        PasangGameView* game_view,
                        cairo_t* cr);
static void pasang_theme_real_draw (PasangTheme* self,
                             PasangGameView* game_view,
                             cairo_t* cr);
void pasang_theme_queue_draw_piece (PasangTheme* self,
                                    GtkDrawingArea* view,
                                    PasangPiece piece,
                                    PasangPoint* p);
static void pasang_theme_real_queue_draw_piece (PasangTheme* self,
                                         GtkDrawingArea* view,
                                         PasangPiece piece,
                                         PasangPoint* p);
gint pasang_theme_count_frames (PasangTheme* self,
                                PasangPiece piece);
static gint pasang_theme_real_count_frames (PasangTheme* self,
                                     PasangPiece piece);
void pasang_theme_to_point (PasangTheme* self,
                            gint pos,
                            gboolean rotated,
                            PasangPoint* result);
static void pasang_theme_real_to_point (PasangTheme* self,
                                 gint pos,
                                 gboolean rotated,
                                 PasangPoint* result);
gint pasang_theme_to_position (PasangTheme* self,
                               PasangGame* game,
                               PasangPoint* p,
                               gboolean rotated,
                               gboolean precise);
static gint pasang_theme_real_to_position (PasangTheme* self,
                                    PasangGame* game,
                                    PasangPoint* p,
                                    gboolean rotated,
                                    gboolean precise);
gint pasang_theme_to_side (PasangTheme* self,
                           PasangPoint* p);
static gint pasang_theme_real_to_side (PasangTheme* self,
                                PasangPoint* p);
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
void pasang_theme_pick_booties (PasangTheme* self,
                                PasangGame* game,
                                PasangMove* move,
                                gboolean full);
void pasang_theme_pick_kas (PasangTheme* self,
                            PasangGame* game);
PasangPiece pasang_game_get_kas (PasangGame* self);
void pasang_theme_drop_pieces (PasangTheme* self);
void pasang_theme_drop_kas (PasangTheme* self,
                            PasangGame* game);
gboolean pasang_theme_animate (PasangTheme* self,
                               PasangGameView* game_view,
                               gdouble lapse);
static gboolean _pasang_point_equal (const PasangPoint * s1,
                              const PasangPoint * s2);
GType pasang_game_series_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameSeries, g_object_unref)
PasangGameSeries* pasang_game_view_get_game (PasangGameView* self);
gboolean pasang_piece_is_real (PasangPiece self);
gboolean pasang_piece_is_kas (PasangPiece self);
void pasang_game_view_queue_draw_piece (PasangGameView* self,
                                        gint position);
PasangTheme* pasang_theme_construct (GType object_type);
gdouble pasang_theme_get_time_span (PasangTheme* self);
void pasang_theme_set_time_span (PasangTheme* self,
                                 gdouble value);
static GObject * pasang_theme_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void pasang_theme_finalize (GObject * obj);
static void _vala_pasang_theme_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_pasang_theme_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
GType pasang_theme_switch_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangThemeSwitch, g_object_unref)
PasangTheme2DCairo* pasang_theme2_dcairo_new (void);
PasangTheme2DCairo* pasang_theme2_dcairo_construct (GType object_type);
GType pasang_theme2_d_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2D, g_object_unref)
GType pasang_theme2_dcairo_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2DCairo, g_object_unref)
PasangTheme2DFile* pasang_theme2_dfile_new (void);
PasangTheme2DFile* pasang_theme2_dfile_construct (GType object_type);
GType pasang_theme2_dfile_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2DFile, g_object_unref)
PasangThemeSwitch* pasang_theme_switch_new (void);
PasangThemeSwitch* pasang_theme_switch_construct (GType object_type);
static void pasang_theme_switch_set_theme (PasangThemeSwitch* self,
                                    PasangTheme* value);
static void __lambda15_ (PasangThemeSwitch* self);
static void ___lambda15__pasang_theme2_dcairo_changed (PasangTheme2DCairo* _sender,
                                                gpointer self);
static void pasang_theme_switch_put_contents (PasangThemeSwitch* self);
static GtkWidget* pasang_theme_switch_create_theme_list (PasangThemeSwitch* self);
static void _vala_array_add30 (PasangThemeItem* * array,
                        int* length,
                        int* size,
                        const PasangThemeItem* value);
static void pasang_theme_switch_on_selection (PasangThemeSwitch* self);
static void _pasang_theme_switch_on_selection_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                   gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
PasangTheme* pasang_theme_switch_get_theme (PasangThemeSwitch* self);
void pasang_theme_switch_random (PasangThemeSwitch* self);
void pasang_theme_switch_resize (PasangThemeSwitch* self,
                                 GtkAllocation* allocation);
static void pasang_theme_switch_finalize (GObject * obj);
static void _vala_pasang_theme_switch_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_pasang_theme_switch_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

void
pasang_theme_item_init (PasangThemeItem *self)
{
#line 29 "theme.vala"
	memset (self, 0, sizeof (PasangThemeItem));
#line 30 "theme.vala"
	_g_free0 ((*self).license);
#line 30 "theme.vala"
	(*self).license = NULL;
#line 31 "theme.vala"
	_g_free0 ((*self).artist);
#line 31 "theme.vala"
	(*self).artist = NULL;
#line 32 "theme.vala"
	_g_free0 ((*self).comment);
#line 32 "theme.vala"
	(*self).comment = NULL;
#line 479 "theme.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 21 "theme.vala"
	return self ? g_object_ref (self) : NULL;
#line 487 "theme.c"
}

void
pasang_theme_item_copy (const PasangThemeItem* self,
                        PasangThemeItem* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	PasangTheme* _tmp12_;
	PasangTheme* _tmp13_;
#line 21 "theme.vala"
	_tmp0_ = (*self).name;
#line 21 "theme.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 21 "theme.vala"
	_g_free0 ((*dest).name);
#line 21 "theme.vala"
	(*dest).name = _tmp1_;
#line 21 "theme.vala"
	_tmp2_ = (*self).path;
#line 21 "theme.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 21 "theme.vala"
	_g_free0 ((*dest).path);
#line 21 "theme.vala"
	(*dest).path = _tmp3_;
#line 21 "theme.vala"
	_tmp4_ = (*self).pixbuf;
#line 21 "theme.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 21 "theme.vala"
	_g_object_unref0 ((*dest).pixbuf);
#line 21 "theme.vala"
	(*dest).pixbuf = _tmp5_;
#line 21 "theme.vala"
	_tmp6_ = (*self).license;
#line 21 "theme.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 21 "theme.vala"
	_g_free0 ((*dest).license);
#line 21 "theme.vala"
	(*dest).license = _tmp7_;
#line 21 "theme.vala"
	_tmp8_ = (*self).artist;
#line 21 "theme.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 21 "theme.vala"
	_g_free0 ((*dest).artist);
#line 21 "theme.vala"
	(*dest).artist = _tmp9_;
#line 21 "theme.vala"
	_tmp10_ = (*self).comment;
#line 21 "theme.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 21 "theme.vala"
	_g_free0 ((*dest).comment);
#line 21 "theme.vala"
	(*dest).comment = _tmp11_;
#line 21 "theme.vala"
	_tmp12_ = (*self).engine;
#line 21 "theme.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 21 "theme.vala"
	_g_object_unref0 ((*dest).engine);
#line 21 "theme.vala"
	(*dest).engine = _tmp13_;
#line 564 "theme.c"
}

void
pasang_theme_item_destroy (PasangThemeItem* self)
{
#line 22 "theme.vala"
	_g_free0 ((*self).name);
#line 23 "theme.vala"
	_g_free0 ((*self).path);
#line 24 "theme.vala"
	_g_object_unref0 ((*self).pixbuf);
#line 25 "theme.vala"
	_g_free0 ((*self).license);
#line 26 "theme.vala"
	_g_free0 ((*self).artist);
#line 27 "theme.vala"
	_g_free0 ((*self).comment);
#line 28 "theme.vala"
	_g_object_unref0 ((*self).engine);
#line 584 "theme.c"
}

PasangThemeItem*
pasang_theme_item_dup (const PasangThemeItem* self)
{
	PasangThemeItem* dup;
#line 21 "theme.vala"
	dup = g_new0 (PasangThemeItem, 1);
#line 21 "theme.vala"
	pasang_theme_item_copy (self, dup);
#line 21 "theme.vala"
	return dup;
#line 597 "theme.c"
}

void
pasang_theme_item_free (PasangThemeItem* self)
{
#line 21 "theme.vala"
	pasang_theme_item_destroy (self);
#line 21 "theme.vala"
	g_free (self);
#line 607 "theme.c"
}

GType
pasang_theme_item_get_type (void)
{
	static volatile gsize pasang_theme_item_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_theme_item_type_id__volatile)) {
		GType pasang_theme_item_type_id;
		pasang_theme_item_type_id = g_boxed_type_register_static ("PasangThemeItem", (GBoxedCopyFunc) pasang_theme_item_dup, (GBoxedFreeFunc) pasang_theme_item_free);
		g_once_init_leave (&pasang_theme_item_type_id__volatile, pasang_theme_item_type_id);
	}
	return pasang_theme_item_type_id__volatile;
}

void
pasang_film_init (PasangFilm *self)
{
#line 44 "theme.vala"
	memset (self, 0, sizeof (PasangFilm));
#line 45 "theme.vala"
	(*self).stop = 0;
#line 46 "theme.vala"
	(*self).length = 1;
#line 47 "theme.vala"
	(*self).viewed = 0;
#line 48 "theme.vala"
	(*self).n = 0;
#line 635 "theme.c"
}

PasangFilm*
pasang_film_dup (const PasangFilm* self)
{
	PasangFilm* dup;
#line 39 "theme.vala"
	dup = g_new0 (PasangFilm, 1);
#line 39 "theme.vala"
	memcpy (dup, self, sizeof (PasangFilm));
#line 39 "theme.vala"
	return dup;
#line 648 "theme.c"
}

void
pasang_film_free (PasangFilm* self)
{
#line 39 "theme.vala"
	g_free (self);
#line 656 "theme.c"
}

GType
pasang_film_get_type (void)
{
	static volatile gsize pasang_film_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_film_type_id__volatile)) {
		GType pasang_film_type_id;
		pasang_film_type_id = g_boxed_type_register_static ("PasangFilm", (GBoxedCopyFunc) pasang_film_dup, (GBoxedFreeFunc) pasang_film_free);
		g_once_init_leave (&pasang_film_type_id__volatile, pasang_film_type_id);
	}
	return pasang_film_type_id__volatile;
}

static inline gpointer
pasang_theme_get_instance_private (PasangTheme* self)
{
	return G_STRUCT_MEMBER_P (self, PasangTheme_private_offset);
}

static void
_vala_PasangThemeItem_array_free (PasangThemeItem * array,
                                  gint array_length)
{
#line 57 "theme.vala"
	if (array != NULL) {
#line 683 "theme.c"
		int i;
#line 57 "theme.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 57 "theme.vala"
			pasang_theme_item_destroy (&array[i]);
#line 689 "theme.c"
		}
	}
#line 57 "theme.vala"
	g_free (array);
#line 694 "theme.c"
}

/**
     * Used by ThemeSelector to select one of the actual themes listed in items[].
     */
static PasangTheme*
pasang_theme_real_select (PasangTheme* self,
                          const gchar* path,
                          gint width,
                          gint height)
{
#line 62 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_select'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 62 "theme.vala"
	return NULL;
#line 710 "theme.c"
}

PasangTheme*
pasang_theme_select (PasangTheme* self,
                     const gchar* path,
                     gint width,
                     gint height)
{
#line 62 "theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "theme.vala"
	return PASANG_THEME_GET_CLASS (self)->select (self, path, width, height);
#line 723 "theme.c"
}

/**
     * ThemeSelector invokes this so that screen images can be prepared.
     */
static void
pasang_theme_real_resize (PasangTheme* self,
                          gint width,
                          gint height)
{
#line 67 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_resize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 67 "theme.vala"
	return;
#line 738 "theme.c"
}

void
pasang_theme_resize (PasangTheme* self,
                     gint width,
                     gint height)
{
#line 67 "theme.vala"
	g_return_if_fail (self != NULL);
#line 67 "theme.vala"
	PASANG_THEME_GET_CLASS (self)->resize (self, width, height);
#line 750 "theme.c"
}

/**
     * Maintain a small footprint. Free memory when this meta-theme
     * is not used.
     */
static void
pasang_theme_real_free (PasangTheme* self)
{
#line 73 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_free'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 73 "theme.vala"
	return;
#line 764 "theme.c"
}

void
pasang_theme_free (PasangTheme* self)
{
#line 73 "theme.vala"
	g_return_if_fail (self != NULL);
#line 73 "theme.vala"
	PASANG_THEME_GET_CLASS (self)->free (self);
#line 774 "theme.c"
}

static void
pasang_theme_real_draw (PasangTheme* self,
                        PasangGameView* game_view,
                        cairo_t* cr)
{
#line 89 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_draw'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 89 "theme.vala"
	return;
#line 786 "theme.c"
}

void
pasang_theme_draw (PasangTheme* self,
                   PasangGameView* game_view,
                   cairo_t* cr)
{
#line 89 "theme.vala"
	g_return_if_fail (self != NULL);
#line 89 "theme.vala"
	PASANG_THEME_GET_CLASS (self)->draw (self, game_view, cr);
#line 798 "theme.c"
}

static void
pasang_theme_real_queue_draw_piece (PasangTheme* self,
                                    GtkDrawingArea* view,
                                    PasangPiece piece,
                                    PasangPoint* p)
{
#line 90 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_queue_draw_piece'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 90 "theme.vala"
	return;
#line 811 "theme.c"
}

void
pasang_theme_queue_draw_piece (PasangTheme* self,
                               GtkDrawingArea* view,
                               PasangPiece piece,
                               PasangPoint* p)
{
#line 90 "theme.vala"
	g_return_if_fail (self != NULL);
#line 90 "theme.vala"
	PASANG_THEME_GET_CLASS (self)->queue_draw_piece (self, view, piece, p);
#line 824 "theme.c"
}

static gint
pasang_theme_real_count_frames (PasangTheme* self,
                                PasangPiece piece)
{
	gint _tmp0_ = 0;
#line 91 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_count_frames'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 91 "theme.vala"
	return _tmp0_;
#line 836 "theme.c"
}

gint
pasang_theme_count_frames (PasangTheme* self,
                           PasangPiece piece)
{
#line 91 "theme.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 91 "theme.vala"
	return PASANG_THEME_GET_CLASS (self)->count_frames (self, piece);
#line 847 "theme.c"
}

/**
     * Convert board position to screen coordinates.
     */
static void
pasang_theme_real_to_point (PasangTheme* self,
                            gint pos,
                            gboolean rotated,
                            PasangPoint* result)
{
#line 96 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_to_point'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 96 "theme.vala"
	return;
#line 863 "theme.c"
}

void
pasang_theme_to_point (PasangTheme* self,
                       gint pos,
                       gboolean rotated,
                       PasangPoint* result)
{
#line 96 "theme.vala"
	g_return_if_fail (self != NULL);
#line 96 "theme.vala"
	PASANG_THEME_GET_CLASS (self)->to_point (self, pos, rotated, result);
#line 876 "theme.c"
}

/**
     * Convert screen coordinates p to board position.
     * Return -1 if p is not touching any pieces on the game board
     * (or a dragged kas is not touching any junction).
     */
static gint
pasang_theme_real_to_position (PasangTheme* self,
                               PasangGame* game,
                               PasangPoint* p,
                               gboolean rotated,
                               gboolean precise)
{
	gint _tmp0_ = 0;
#line 103 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_to_position'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 103 "theme.vala"
	return _tmp0_;
#line 896 "theme.c"
}

gint
pasang_theme_to_position (PasangTheme* self,
                          PasangGame* game,
                          PasangPoint* p,
                          gboolean rotated,
                          gboolean precise)
{
#line 103 "theme.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 103 "theme.vala"
	return PASANG_THEME_GET_CLASS (self)->to_position (self, game, p, rotated, precise);
#line 910 "theme.c"
}

/**
     * Return 0 if p is within the TOP side of the board,
     * 1 if within the BOTTOM side,
     * -1 if outside
     */
static gint
pasang_theme_real_to_side (PasangTheme* self,
                           PasangPoint* p)
{
	gint _tmp0_ = 0;
#line 110 "theme.vala"
	g_critical ("Type `%s' does not implement abstract method `pasang_theme_to_side'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 110 "theme.vala"
	return _tmp0_;
#line 927 "theme.c"
}

gint
pasang_theme_to_side (PasangTheme* self,
                      PasangPoint* p)
{
#line 110 "theme.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 110 "theme.vala"
	return PASANG_THEME_GET_CLASS (self)->to_side (self, p);
#line 938 "theme.c"
}

/**
     * Start the visual effect of picking up pieces to capture.
     * full==false means pick half-way.
     */
void
pasang_theme_pick_booties (PasangTheme* self,
                           PasangGame* game,
                           PasangMove* move,
                           gboolean full)
{
	gint* _tmp0_;
	gint _tmp0__length1;
#line 116 "theme.vala"
	g_return_if_fail (self != NULL);
#line 116 "theme.vala"
	g_return_if_fail (game != NULL);
#line 117 "theme.vala"
	if (move == NULL) {
#line 117 "theme.vala"
		return;
#line 961 "theme.c"
	}
#line 118 "theme.vala"
	_tmp0_ = move->booties;
#line 118 "theme.vala"
	_tmp0__length1 = move->booties_length1;
#line 967 "theme.c"
	{
		gint* pos_collection = NULL;
		gint pos_collection_length1 = 0;
		gint _pos_collection_size_ = 0;
		gint pos_it = 0;
#line 118 "theme.vala"
		pos_collection = _tmp0_;
#line 118 "theme.vala"
		pos_collection_length1 = _tmp0__length1;
#line 118 "theme.vala"
		for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
#line 979 "theme.c"
			gint pos = 0;
#line 118 "theme.vala"
			pos = pos_collection[pos_it];
#line 983 "theme.c"
			{
				PasangPiece piece = 0;
				PasangPiece* _tmp1_;
				gint _tmp1__length1;
				PasangPiece _tmp2_;
				gint num_frames = 0;
				PasangPiece _tmp3_;
				PasangFilm* _tmp4_;
				gint _tmp4__length1;
				gint half_way = 0;
				gint _tmp5_ = 0;
				PasangFilm* _tmp6_;
				gint _tmp6__length1;
#line 119 "theme.vala"
				_tmp1_ = game->board;
#line 119 "theme.vala"
				_tmp1__length1 = game->board_length1;
#line 119 "theme.vala"
				_tmp2_ = _tmp1_[pos];
#line 119 "theme.vala"
				piece = _tmp2_;
#line 121 "theme.vala"
				_tmp3_ = piece;
#line 121 "theme.vala"
				num_frames = pasang_theme_count_frames (self, _tmp3_);
#line 122 "theme.vala"
				_tmp4_ = self->films;
#line 122 "theme.vala"
				_tmp4__length1 = self->films_length1;
#line 122 "theme.vala"
				_tmp4_[pos].length = num_frames;
#line 123 "theme.vala"
				half_way = ((num_frames + 1) / 2) - 1;
#line 124 "theme.vala"
				if (full) {
#line 124 "theme.vala"
					_tmp5_ = num_frames - 1;
#line 1021 "theme.c"
				} else {
#line 124 "theme.vala"
					_tmp5_ = half_way;
#line 1025 "theme.c"
				}
#line 124 "theme.vala"
				_tmp6_ = self->films;
#line 124 "theme.vala"
				_tmp6__length1 = self->films_length1;
#line 124 "theme.vala"
				_tmp6_[pos].stop = _tmp5_;
#line 125 "theme.vala"
				if (full) {
#line 1035 "theme.c"
					PasangFilm* _tmp7_;
					gint _tmp7__length1;
					PasangFilm* _tmp8_;
					gint _tmp8__length1;
					PasangFilm _tmp9_;
#line 125 "theme.vala"
					_tmp7_ = self->films;
#line 125 "theme.vala"
					_tmp7__length1 = self->films_length1;
#line 125 "theme.vala"
					_tmp8_ = self->films;
#line 125 "theme.vala"
					_tmp8__length1 = self->films_length1;
#line 125 "theme.vala"
					_tmp9_ = _tmp8_[pos];
#line 125 "theme.vala"
					_tmp7_[pos].n = _tmp9_.viewed;
#line 1053 "theme.c"
				}
			}
		}
	}
}

/**
     * Start the visual effect of picking up the kas that is currently being dragged.
     * full==false means pick half-way.
     */
void
pasang_theme_pick_kas (PasangTheme* self,
                       PasangGame* game)
{
	gint num_frames = 0;
	PasangPiece _tmp0_;
	PasangPiece _tmp1_;
	PasangFilm* _tmp2_;
	gint _tmp2__length1;
	PasangPiece _tmp3_;
	PasangPiece _tmp4_;
	PasangFilm* _tmp5_;
	gint _tmp5__length1;
	PasangPiece _tmp6_;
	PasangPiece _tmp7_;
#line 133 "theme.vala"
	g_return_if_fail (self != NULL);
#line 133 "theme.vala"
	g_return_if_fail (game != NULL);
#line 134 "theme.vala"
	_tmp0_ = pasang_game_get_kas (game);
#line 134 "theme.vala"
	_tmp1_ = _tmp0_;
#line 134 "theme.vala"
	num_frames = pasang_theme_count_frames (self, _tmp1_);
#line 135 "theme.vala"
	_tmp2_ = self->films;
#line 135 "theme.vala"
	_tmp2__length1 = self->films_length1;
#line 135 "theme.vala"
	_tmp3_ = pasang_game_get_kas (game);
#line 135 "theme.vala"
	_tmp4_ = _tmp3_;
#line 135 "theme.vala"
	_tmp2_[_tmp4_].length = num_frames;
#line 136 "theme.vala"
	_tmp5_ = self->films;
#line 136 "theme.vala"
	_tmp5__length1 = self->films_length1;
#line 136 "theme.vala"
	_tmp6_ = pasang_game_get_kas (game);
#line 136 "theme.vala"
	_tmp7_ = _tmp6_;
#line 136 "theme.vala"
	_tmp5_[_tmp7_].stop = num_frames - 1;
#line 1109 "theme.c"
}

/**
     * Start the visual effect of dropping pieces.
     */
void
pasang_theme_drop_pieces (PasangTheme* self)
{
#line 142 "theme.vala"
	g_return_if_fail (self != NULL);
#line 1120 "theme.c"
	{
		gint pos = 0;
#line 143 "theme.vala"
		pos = 2;
#line 1125 "theme.c"
		{
			gboolean _tmp0_ = FALSE;
#line 143 "theme.vala"
			_tmp0_ = TRUE;
#line 143 "theme.vala"
			while (TRUE) {
#line 1132 "theme.c"
				PasangFilm* _tmp2_;
				gint _tmp2__length1;
#line 143 "theme.vala"
				if (!_tmp0_) {
#line 1137 "theme.c"
					gint _tmp1_;
#line 143 "theme.vala"
					_tmp1_ = pos;
#line 143 "theme.vala"
					pos = _tmp1_ + 1;
#line 1143 "theme.c"
				}
#line 143 "theme.vala"
				_tmp0_ = FALSE;
#line 143 "theme.vala"
				if (!(pos < PASANG_BOARD_SIZE)) {
#line 143 "theme.vala"
					break;
#line 1151 "theme.c"
				}
#line 144 "theme.vala"
				_tmp2_ = self->films;
#line 144 "theme.vala"
				_tmp2__length1 = self->films_length1;
#line 144 "theme.vala"
				_tmp2_[pos].stop = 0;
#line 1159 "theme.c"
			}
		}
	}
}

/**
     * Start the visual effect of dropping the kas.
     */
void
pasang_theme_drop_kas (PasangTheme* self,
                       PasangGame* game)
{
#line 151 "theme.vala"
	g_return_if_fail (self != NULL);
#line 151 "theme.vala"
	g_return_if_fail (game != NULL);
#line 1176 "theme.c"
	{
		gint i = 0;
#line 152 "theme.vala"
		i = 0;
#line 1181 "theme.c"
		{
			gboolean _tmp0_ = FALSE;
#line 152 "theme.vala"
			_tmp0_ = TRUE;
#line 152 "theme.vala"
			while (TRUE) {
#line 1188 "theme.c"
				PasangFilm* _tmp2_;
				gint _tmp2__length1;
				gint pos = 0;
				gint* _tmp3_;
				gint _tmp3__length1;
				gint _tmp4_;
				PasangFilm* _tmp5_;
				gint _tmp5__length1;
				PasangFilm* _tmp6_;
				gint _tmp6__length1;
				PasangFilm* _tmp7_;
				gint _tmp7__length1;
				PasangFilm _tmp8_;
				PasangFilm* _tmp9_;
				gint _tmp9__length1;
				PasangFilm* _tmp10_;
				gint _tmp10__length1;
				PasangFilm _tmp11_;
				PasangFilm* _tmp12_;
				gint _tmp12__length1;
				PasangFilm* _tmp13_;
				gint _tmp13__length1;
				PasangFilm _tmp14_;
#line 152 "theme.vala"
				if (!_tmp0_) {
#line 1214 "theme.c"
					gint _tmp1_;
#line 152 "theme.vala"
					_tmp1_ = i;
#line 152 "theme.vala"
					i = _tmp1_ + 1;
#line 1220 "theme.c"
				}
#line 152 "theme.vala"
				_tmp0_ = FALSE;
#line 152 "theme.vala"
				if (!(i < 2)) {
#line 152 "theme.vala"
					break;
#line 1228 "theme.c"
				}
#line 153 "theme.vala"
				_tmp2_ = self->films;
#line 153 "theme.vala"
				_tmp2__length1 = self->films_length1;
#line 153 "theme.vala"
				_tmp2_[i].stop = 0;
#line 154 "theme.vala"
				_tmp3_ = game->kas_position;
#line 154 "theme.vala"
				_tmp3__length1 = game->kas_position_length1;
#line 154 "theme.vala"
				_tmp4_ = _tmp3_[i];
#line 154 "theme.vala"
				pos = _tmp4_;
#line 155 "theme.vala"
				if (pos == 0) {
#line 155 "theme.vala"
					continue;
#line 1248 "theme.c"
				}
#line 156 "theme.vala"
				_tmp5_ = self->films;
#line 156 "theme.vala"
				_tmp5__length1 = self->films_length1;
#line 156 "theme.vala"
				_tmp5_[pos].stop = 0;
#line 157 "theme.vala"
				_tmp6_ = self->films;
#line 157 "theme.vala"
				_tmp6__length1 = self->films_length1;
#line 157 "theme.vala"
				_tmp7_ = self->films;
#line 157 "theme.vala"
				_tmp7__length1 = self->films_length1;
#line 157 "theme.vala"
				_tmp8_ = _tmp7_[i];
#line 157 "theme.vala"
				_tmp6_[pos].length = _tmp8_.length;
#line 158 "theme.vala"
				_tmp9_ = self->films;
#line 158 "theme.vala"
				_tmp9__length1 = self->films_length1;
#line 158 "theme.vala"
				_tmp10_ = self->films;
#line 158 "theme.vala"
				_tmp10__length1 = self->films_length1;
#line 158 "theme.vala"
				_tmp11_ = _tmp10_[i];
#line 158 "theme.vala"
				_tmp9_[pos].n = _tmp11_.n;
#line 159 "theme.vala"
				_tmp12_ = self->films;
#line 159 "theme.vala"
				_tmp12__length1 = self->films_length1;
#line 159 "theme.vala"
				_tmp13_ = self->films;
#line 159 "theme.vala"
				_tmp13__length1 = self->films_length1;
#line 159 "theme.vala"
				_tmp14_ = _tmp13_[i];
#line 159 "theme.vala"
				_tmp12_[pos].viewed = _tmp14_.viewed;
#line 1292 "theme.c"
			}
		}
	}
}

/**
     * Advance animation frames.
     * lapse is in the range 0..1
     * Return true if still animating.
     *
     * If cycle is zero, then the film is played sequentially.
     * If positive, then a portion is played repeatedly.
     * If negative, then a portion is played repeatedly forward and backward.
     *
     * e.g., for film.stop == 6
     *   cycle = 0       n     0 1 2 3 4 5 6 stop
     *                  viewed 0 1 2 3 4 5 6 stop
     *
     *   cycle = 3       n     0 1 2*3 4 5 6*3 4 5 6*3 4 5 6 ...
     *                  viewed 0 1 2 3 4 5 6 3 4 5 6 3 4 5 6 ...   
     *
     *   cycle < -3      n     0 1 2*3 4 5 6 7 8*3 4 5 6 7 8 ...
     *                  viewed 0 1 2 3 4 5 6 5 4 3 4 5 6 5 4 ...
     */
static gboolean
_pasang_point_equal (const PasangPoint * s1,
                     const PasangPoint * s2)
{
#line 194 "theme.vala"
	if (s1 == s2) {
#line 194 "theme.vala"
		return TRUE;
#line 1325 "theme.c"
	}
#line 194 "theme.vala"
	if (s1 == NULL) {
#line 194 "theme.vala"
		return FALSE;
#line 1331 "theme.c"
	}
#line 194 "theme.vala"
	if (s2 == NULL) {
#line 194 "theme.vala"
		return FALSE;
#line 1337 "theme.c"
	}
#line 194 "theme.vala"
	if (s1->x != s2->x) {
#line 194 "theme.vala"
		return FALSE;
#line 1343 "theme.c"
	}
#line 194 "theme.vala"
	if (s1->y != s2->y) {
#line 194 "theme.vala"
		return FALSE;
#line 1349 "theme.c"
	}
#line 194 "theme.vala"
	return TRUE;
#line 1353 "theme.c"
}

gboolean
pasang_theme_animate (PasangTheme* self,
                      PasangGameView* game_view,
                      gdouble lapse)
{
	gboolean kas_changed = FALSE;
	PasangPoint _tmp0_;
	PasangPoint _tmp1_;
	gboolean animating = FALSE;
	gboolean result = FALSE;
#line 192 "theme.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 192 "theme.vala"
	g_return_val_if_fail (game_view != NULL, FALSE);
#line 194 "theme.vala"
	_tmp0_ = self->priv->prev_kas_point;
#line 194 "theme.vala"
	_tmp1_ = game_view->kas_point;
#line 194 "theme.vala"
	kas_changed = _pasang_point_equal (&_tmp0_, &_tmp1_) != TRUE;
#line 195 "theme.vala"
	animating = kas_changed;
#line 1378 "theme.c"
	{
		gint pos = 0;
#line 196 "theme.vala"
		pos = 0;
#line 1383 "theme.c"
		{
			gboolean _tmp2_ = FALSE;
#line 196 "theme.vala"
			_tmp2_ = TRUE;
#line 196 "theme.vala"
			while (TRUE) {
#line 1390 "theme.c"
				PasangFilm* film = NULL;
				PasangFilm* _tmp4_;
				gint _tmp4__length1;
				PasangPiece _tmp5_ = 0;
				PasangPiece piece = 0;
				gint _tmp10_ = 0;
				PasangPiece _tmp11_;
				gint cycle = 0;
				gboolean _tmp15_ = FALSE;
				PasangPiece _tmp16_;
				gboolean _tmp19_ = FALSE;
				PasangFilm* _tmp20_;
				PasangFilm* _tmp21_;
				PasangFilm* _tmp24_;
				PasangFilm* _tmp25_;
				gint _tmp26_ = 0;
				gboolean _tmp27_ = FALSE;
				PasangPiece _tmp28_;
				gint max = 0;
				PasangFilm* _tmp41_;
				gint _tmp42_ = 0;
				gboolean _tmp43_ = FALSE;
				PasangFilm* _tmp47_;
#line 196 "theme.vala"
				if (!_tmp2_) {
#line 1416 "theme.c"
					gint _tmp3_;
#line 196 "theme.vala"
					_tmp3_ = pos;
#line 196 "theme.vala"
					pos = _tmp3_ + 1;
#line 1422 "theme.c"
				}
#line 196 "theme.vala"
				_tmp2_ = FALSE;
#line 196 "theme.vala"
				if (!(pos < PASANG_BOARD_SIZE)) {
#line 196 "theme.vala"
					break;
#line 1430 "theme.c"
				}
#line 197 "theme.vala"
				_tmp4_ = self->films;
#line 197 "theme.vala"
				_tmp4__length1 = self->films_length1;
#line 197 "theme.vala"
				film = &_tmp4_[pos];
#line 198 "theme.vala"
				if (pos <= 1) {
#line 198 "theme.vala"
					_tmp5_ = (PasangPiece) pos;
#line 1442 "theme.c"
				} else {
					PasangGameSeries* _tmp6_;
					PasangGameSeries* _tmp7_;
					PasangPiece* _tmp8_;
					gint _tmp8__length1;
					PasangPiece _tmp9_;
#line 198 "theme.vala"
					_tmp6_ = pasang_game_view_get_game (game_view);
#line 198 "theme.vala"
					_tmp7_ = _tmp6_;
#line 198 "theme.vala"
					_tmp8_ = ((PasangGame*) _tmp7_)->board;
#line 198 "theme.vala"
					_tmp8__length1 = ((PasangGame*) _tmp7_)->board_length1;
#line 198 "theme.vala"
					_tmp9_ = _tmp8_[pos];
#line 198 "theme.vala"
					_tmp5_ = _tmp9_;
#line 1461 "theme.c"
				}
#line 198 "theme.vala"
				piece = _tmp5_;
#line 199 "theme.vala"
				_tmp11_ = piece;
#line 199 "theme.vala"
				if (pasang_piece_is_real (_tmp11_)) {
#line 1469 "theme.c"
					gint* _tmp12_;
					gint _tmp12__length1;
					PasangPiece _tmp13_;
					gint _tmp14_;
#line 199 "theme.vala"
					_tmp12_ = self->cycles;
#line 199 "theme.vala"
					_tmp12__length1 = self->cycles_length1;
#line 199 "theme.vala"
					_tmp13_ = piece;
#line 199 "theme.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 199 "theme.vala"
					_tmp10_ = _tmp14_;
#line 1484 "theme.c"
				} else {
#line 199 "theme.vala"
					_tmp10_ = 0;
#line 1488 "theme.c"
				}
#line 199 "theme.vala"
				cycle = _tmp10_;
#line 200 "theme.vala"
				_tmp16_ = piece;
#line 200 "theme.vala"
				if (!pasang_piece_is_kas (_tmp16_)) {
#line 1496 "theme.c"
					PasangFilm* _tmp17_;
					PasangFilm* _tmp18_;
#line 200 "theme.vala"
					_tmp17_ = film;
#line 200 "theme.vala"
					_tmp18_ = film;
#line 200 "theme.vala"
					_tmp15_ = (*_tmp17_).stop == ((*_tmp18_).length - 1);
#line 1505 "theme.c"
				} else {
#line 200 "theme.vala"
					_tmp15_ = FALSE;
#line 1509 "theme.c"
				}
#line 200 "theme.vala"
				if (_tmp15_) {
#line 200 "theme.vala"
					cycle = 0;
#line 1515 "theme.c"
				}
#line 203 "theme.vala"
				_tmp20_ = film;
#line 203 "theme.vala"
				_tmp21_ = film;
#line 203 "theme.vala"
				if ((*_tmp20_).n == (*_tmp21_).stop) {
#line 1523 "theme.c"
					gboolean _tmp22_ = FALSE;
					PasangFilm* _tmp23_;
#line 203 "theme.vala"
					_tmp23_ = film;
#line 203 "theme.vala"
					if ((*_tmp23_).stop == 0) {
#line 203 "theme.vala"
						_tmp22_ = TRUE;
#line 1532 "theme.c"
					} else {
#line 203 "theme.vala"
						_tmp22_ = cycle == 0;
#line 1536 "theme.c"
					}
#line 203 "theme.vala"
					_tmp19_ = _tmp22_;
#line 1540 "theme.c"
				} else {
#line 203 "theme.vala"
					_tmp19_ = FALSE;
#line 1544 "theme.c"
				}
#line 203 "theme.vala"
				if (_tmp19_) {
#line 203 "theme.vala"
					continue;
#line 1550 "theme.c"
				}
#line 205 "theme.vala"
				animating = TRUE;
#line 207 "theme.vala"
				_tmp24_ = film;
#line 207 "theme.vala"
				_tmp25_ = film;
#line 207 "theme.vala"
				if (((gint) (lapse * (*_tmp24_).length)) == ((gint) (self->priv->prev_lapse * (*_tmp25_).length))) {
#line 208 "theme.vala"
					continue;
#line 1562 "theme.c"
				}
#line 209 "theme.vala"
				_tmp28_ = piece;
#line 209 "theme.vala"
				if (pasang_piece_is_kas (_tmp28_)) {
#line 209 "theme.vala"
					_tmp27_ = TRUE;
#line 1570 "theme.c"
				} else {
					PasangFilm* _tmp29_;
					PasangFilm* _tmp30_;
#line 209 "theme.vala"
					_tmp29_ = film;
#line 209 "theme.vala"
					_tmp30_ = film;
#line 209 "theme.vala"
					_tmp27_ = (*_tmp29_).stop == ((*_tmp30_).length - 1);
#line 1580 "theme.c"
				}
#line 209 "theme.vala"
				if (_tmp27_) {
#line 1584 "theme.c"
					PasangFilm* _tmp31_;
#line 209 "theme.vala"
					_tmp31_ = film;
#line 209 "theme.vala"
					_tmp26_ = (*_tmp31_).length - 1;
#line 1590 "theme.c"
				} else {
					PasangFilm* _tmp32_;
#line 209 "theme.vala"
					_tmp32_ = film;
#line 209 "theme.vala"
					_tmp26_ = (((*_tmp32_).length + 1) / 2) - 1;
#line 1597 "theme.c"
				}
#line 209 "theme.vala"
				max = _tmp26_;
#line 210 "theme.vala"
				if (cycle <= 0) {
#line 1603 "theme.c"
					gint _tmp33_ = 0;
					PasangFilm* _tmp34_;
					PasangFilm* _tmp35_;
#line 211 "theme.vala"
					_tmp34_ = film;
#line 211 "theme.vala"
					if ((*_tmp34_).stop == 0) {
#line 211 "theme.vala"
						_tmp33_ = -1;
#line 1613 "theme.c"
					} else {
#line 211 "theme.vala"
						_tmp33_ = 1;
#line 1617 "theme.c"
					}
#line 211 "theme.vala"
					(*film).n = (*film).n + _tmp33_;
#line 212 "theme.vala"
					_tmp35_ = film;
#line 212 "theme.vala"
					if ((*_tmp35_).n >= (max - cycle)) {
#line 212 "theme.vala"
						(*film).n = max + cycle;
#line 1627 "theme.c"
					}
				} else {
					gint _tmp36_ = 0;
					gboolean _tmp37_ = FALSE;
					PasangFilm* _tmp38_;
					PasangFilm* _tmp40_;
#line 215 "theme.vala"
					_tmp38_ = film;
#line 215 "theme.vala"
					if ((*_tmp38_).stop == 0) {
#line 1638 "theme.c"
						PasangFilm* _tmp39_;
#line 215 "theme.vala"
						_tmp39_ = film;
#line 215 "theme.vala"
						_tmp37_ = (*_tmp39_).n <= (max - cycle);
#line 1644 "theme.c"
					} else {
#line 215 "theme.vala"
						_tmp37_ = FALSE;
#line 1648 "theme.c"
					}
#line 215 "theme.vala"
					if (_tmp37_) {
#line 215 "theme.vala"
						_tmp36_ = -1;
#line 1654 "theme.c"
					} else {
#line 215 "theme.vala"
						_tmp36_ = 1;
#line 1658 "theme.c"
					}
#line 215 "theme.vala"
					(*film).n = (*film).n + _tmp36_;
#line 216 "theme.vala"
					_tmp40_ = film;
#line 216 "theme.vala"
					if ((*_tmp40_).n > max) {
#line 216 "theme.vala"
						(*film).n = max - cycle;
#line 1668 "theme.c"
					}
				}
#line 218 "theme.vala"
				_tmp41_ = film;
#line 218 "theme.vala"
				if ((*_tmp41_).n < 0) {
#line 219 "theme.vala"
					g_debug ("theme.vala:219: Theme file is malformed");
#line 220 "theme.vala"
					(*film).n = 0;
#line 1679 "theme.c"
				}
#line 222 "theme.vala"
				if (cycle < 0) {
#line 1683 "theme.c"
					PasangFilm* _tmp44_;
#line 222 "theme.vala"
					_tmp44_ = film;
#line 222 "theme.vala"
					_tmp43_ = (*_tmp44_).n > max;
#line 1689 "theme.c"
				} else {
#line 222 "theme.vala"
					_tmp43_ = FALSE;
#line 1693 "theme.c"
				}
#line 222 "theme.vala"
				if (_tmp43_) {
#line 1697 "theme.c"
					PasangFilm* _tmp45_;
#line 222 "theme.vala"
					_tmp45_ = film;
#line 222 "theme.vala"
					_tmp42_ = (max * 2) - (*_tmp45_).n;
#line 1703 "theme.c"
				} else {
					PasangFilm* _tmp46_;
#line 222 "theme.vala"
					_tmp46_ = film;
#line 222 "theme.vala"
					_tmp42_ = (*_tmp46_).n;
#line 1710 "theme.c"
				}
#line 222 "theme.vala"
				(*film).viewed = _tmp42_;
#line 223 "theme.vala"
				_tmp47_ = film;
#line 223 "theme.vala"
				if ((*_tmp47_).viewed < 0) {
#line 224 "theme.vala"
					g_debug ("theme.vala:224: Negative frame number");
#line 225 "theme.vala"
					(*film).viewed = 0;
#line 1722 "theme.c"
				}
#line 227 "theme.vala"
				if (pos > 1) {
#line 228 "theme.vala"
					pasang_game_view_queue_draw_piece (game_view, pos);
#line 1728 "theme.c"
				} else {
#line 231 "theme.vala"
					kas_changed = TRUE;
#line 1732 "theme.c"
				}
			}
		}
	}
#line 234 "theme.vala"
	if (kas_changed) {
#line 1739 "theme.c"
		PasangGameSeries* _tmp48_;
		PasangGameSeries* _tmp49_;
		PasangPiece _tmp50_;
		PasangPiece _tmp51_;
		PasangPoint _tmp52_;
		PasangGameSeries* _tmp53_;
		PasangGameSeries* _tmp54_;
		PasangPiece _tmp55_;
		PasangPiece _tmp56_;
		PasangPoint _tmp57_;
		PasangPoint _tmp58_;
#line 235 "theme.vala"
		_tmp48_ = pasang_game_view_get_game (game_view);
#line 235 "theme.vala"
		_tmp49_ = _tmp48_;
#line 235 "theme.vala"
		_tmp50_ = pasang_game_get_kas ((PasangGame*) _tmp49_);
#line 235 "theme.vala"
		_tmp51_ = _tmp50_;
#line 235 "theme.vala"
		_tmp52_ = self->priv->prev_kas_point;
#line 235 "theme.vala"
		pasang_theme_queue_draw_piece (self, (GtkDrawingArea*) game_view, _tmp51_, &_tmp52_);
#line 236 "theme.vala"
		_tmp53_ = pasang_game_view_get_game (game_view);
#line 236 "theme.vala"
		_tmp54_ = _tmp53_;
#line 236 "theme.vala"
		_tmp55_ = pasang_game_get_kas ((PasangGame*) _tmp54_);
#line 236 "theme.vala"
		_tmp56_ = _tmp55_;
#line 236 "theme.vala"
		_tmp57_ = game_view->kas_point;
#line 236 "theme.vala"
		pasang_theme_queue_draw_piece (self, (GtkDrawingArea*) game_view, _tmp56_, &_tmp57_);
#line 237 "theme.vala"
		_tmp58_ = game_view->kas_point;
#line 237 "theme.vala"
		self->priv->prev_kas_point = _tmp58_;
#line 1779 "theme.c"
	}
#line 239 "theme.vala"
	self->priv->prev_lapse = lapse;
#line 240 "theme.vala"
	result = animating;
#line 240 "theme.vala"
	return result;
#line 1787 "theme.c"
}

PasangTheme*
pasang_theme_construct (GType object_type)
{
	PasangTheme * self = NULL;
#line 52 "theme.vala"
	self = (PasangTheme*) g_object_new (object_type, NULL);
#line 52 "theme.vala"
	return self;
#line 1798 "theme.c"
}

gdouble
pasang_theme_get_time_span (PasangTheme* self)
{
	gdouble result;
#line 78 "theme.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 78 "theme.vala"
	result = self->priv->_time_span;
#line 78 "theme.vala"
	return result;
#line 1811 "theme.c"
}

void
pasang_theme_set_time_span (PasangTheme* self,
                            gdouble value)
{
#line 78 "theme.vala"
	g_return_if_fail (self != NULL);
#line 78 "theme.vala"
	if (pasang_theme_get_time_span (self) != value) {
#line 78 "theme.vala"
		self->priv->_time_span = value;
#line 78 "theme.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_theme_properties[PASANG_THEME_TIME_SPAN_PROPERTY]);
#line 1826 "theme.c"
	}
}

static GObject *
pasang_theme_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PasangTheme * self;
#line 82 "theme.vala"
	parent_class = G_OBJECT_CLASS (pasang_theme_parent_class);
#line 82 "theme.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 82 "theme.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME, PasangTheme);
#line 1844 "theme.c"
	{
		gint i = 0;
#line 83 "theme.vala"
		i = 0;
#line 1849 "theme.c"
		{
			gboolean _tmp0_ = FALSE;
#line 83 "theme.vala"
			_tmp0_ = TRUE;
#line 83 "theme.vala"
			while (TRUE) {
#line 1856 "theme.c"
				PasangFilm* _tmp2_;
				gint _tmp2__length1;
				PasangFilm* _tmp3_;
				gint _tmp3__length1;
				PasangFilm _tmp4_ = {0};
#line 83 "theme.vala"
				if (!_tmp0_) {
#line 1864 "theme.c"
					gint _tmp1_;
#line 83 "theme.vala"
					_tmp1_ = i;
#line 83 "theme.vala"
					i = _tmp1_ + 1;
#line 1870 "theme.c"
				}
#line 83 "theme.vala"
				_tmp0_ = FALSE;
#line 83 "theme.vala"
				_tmp2_ = self->films;
#line 83 "theme.vala"
				_tmp2__length1 = self->films_length1;
#line 83 "theme.vala"
				if (!(i < _tmp2__length1)) {
#line 83 "theme.vala"
					break;
#line 1882 "theme.c"
				}
#line 83 "theme.vala"
				_tmp3_ = self->films;
#line 83 "theme.vala"
				_tmp3__length1 = self->films_length1;
#line 83 "theme.vala"
				pasang_film_init (&_tmp4_);
#line 83 "theme.vala"
				_tmp3_[i] = _tmp4_;
#line 1892 "theme.c"
			}
		}
	}
#line 84 "theme.vala"
	pasang_theme_set_time_span (self, 1.3);
#line 82 "theme.vala"
	return obj;
#line 1900 "theme.c"
}

static void
pasang_theme_class_init (PasangThemeClass * klass,
                         gpointer klass_data)
{
#line 52 "theme.vala"
	pasang_theme_parent_class = g_type_class_peek_parent (klass);
#line 52 "theme.vala"
	g_type_class_adjust_private_offset (klass, &PasangTheme_private_offset);
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->select = (PasangTheme* (*) (PasangTheme*, const gchar*, gint, gint)) pasang_theme_real_select;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->resize = (void (*) (PasangTheme*, gint, gint)) pasang_theme_real_resize;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->free = (void (*) (PasangTheme*)) pasang_theme_real_free;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->draw = (void (*) (PasangTheme*, PasangGameView*, cairo_t*)) pasang_theme_real_draw;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->queue_draw_piece = (void (*) (PasangTheme*, GtkDrawingArea*, PasangPiece, PasangPoint*)) pasang_theme_real_queue_draw_piece;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->count_frames = (gint (*) (PasangTheme*, PasangPiece)) pasang_theme_real_count_frames;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->to_point = (void (*) (PasangTheme*, gint, gboolean, PasangPoint*)) pasang_theme_real_to_point;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->to_position = (gint (*) (PasangTheme*, PasangGame*, PasangPoint*, gboolean, gboolean)) pasang_theme_real_to_position;
#line 52 "theme.vala"
	((PasangThemeClass *) klass)->to_side = (gint (*) (PasangTheme*, PasangPoint*)) pasang_theme_real_to_side;
#line 52 "theme.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_theme_get_property;
#line 52 "theme.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_pasang_theme_set_property;
#line 52 "theme.vala"
	G_OBJECT_CLASS (klass)->constructor = pasang_theme_constructor;
#line 52 "theme.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_theme_finalize;
#line 1937 "theme.c"
	/**
	     * How many seconds it take to play an entire sequence of film frames.
	     */
#line 52 "theme.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_THEME_TIME_SPAN_PROPERTY, pasang_theme_properties[PASANG_THEME_TIME_SPAN_PROPERTY] = g_param_spec_double ("time-span", "time-span", "time-span", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1943 "theme.c"
}

static void
pasang_theme_instance_init (PasangTheme * self,
                            gpointer klass)
{
	PasangFilm* _tmp0_;
	gint* _tmp1_;
#line 52 "theme.vala"
	self->priv = pasang_theme_get_instance_private (self);
#line 80 "theme.vala"
	_tmp0_ = g_new0 (PasangFilm, PASANG_BOARD_SIZE);
#line 80 "theme.vala"
	self->films = _tmp0_;
#line 80 "theme.vala"
	self->films_length1 = PASANG_BOARD_SIZE;
#line 80 "theme.vala"
	self->_films_size_ = self->films_length1;
#line 87 "theme.vala"
	_tmp1_ = g_new0 (gint, PASANG_PIECE_COUNT);
#line 87 "theme.vala"
	self->cycles = _tmp1_;
#line 87 "theme.vala"
	self->cycles_length1 = PASANG_PIECE_COUNT;
#line 87 "theme.vala"
	self->_cycles_size_ = self->cycles_length1;
#line 166 "theme.vala"
	self->priv->prev_lapse = (gdouble) 0;
#line 1972 "theme.c"
}

static void
pasang_theme_finalize (GObject * obj)
{
	PasangTheme * self;
#line 52 "theme.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME, PasangTheme);
#line 57 "theme.vala"
	self->items = (_vala_PasangThemeItem_array_free (self->items, self->items_length1), NULL);
#line 80 "theme.vala"
	self->films = (g_free (self->films), NULL);
#line 87 "theme.vala"
	self->cycles = (g_free (self->cycles), NULL);
#line 52 "theme.vala"
	G_OBJECT_CLASS (pasang_theme_parent_class)->finalize (obj);
#line 1989 "theme.c"
}

GType
pasang_theme_get_type (void)
{
	static volatile gsize pasang_theme_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_theme_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangTheme), 0, (GInstanceInitFunc) pasang_theme_instance_init, NULL };
		GType pasang_theme_type_id;
		pasang_theme_type_id = g_type_register_static (G_TYPE_OBJECT, "PasangTheme", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		PasangTheme_private_offset = g_type_add_instance_private (pasang_theme_type_id, sizeof (PasangThemePrivate));
		g_once_init_leave (&pasang_theme_type_id__volatile, pasang_theme_type_id);
	}
	return pasang_theme_type_id__volatile;
}

static void
_vala_pasang_theme_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PasangTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_THEME, PasangTheme);
#line 52 "theme.vala"
	switch (property_id) {
#line 52 "theme.vala"
		case PASANG_THEME_TIME_SPAN_PROPERTY:
#line 52 "theme.vala"
		g_value_set_double (value, pasang_theme_get_time_span (self));
#line 52 "theme.vala"
		break;
#line 2022 "theme.c"
		default:
#line 52 "theme.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "theme.vala"
		break;
#line 2028 "theme.c"
	}
}

static void
_vala_pasang_theme_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PasangTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_THEME, PasangTheme);
#line 52 "theme.vala"
	switch (property_id) {
#line 52 "theme.vala"
		case PASANG_THEME_TIME_SPAN_PROPERTY:
#line 52 "theme.vala"
		pasang_theme_set_time_span (self, g_value_get_double (value));
#line 52 "theme.vala"
		break;
#line 2048 "theme.c"
		default:
#line 52 "theme.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "theme.vala"
		break;
#line 2054 "theme.c"
	}
}

static inline gpointer
pasang_theme_switch_get_instance_private (PasangThemeSwitch* self)
{
	return G_STRUCT_MEMBER_P (self, PasangThemeSwitch_private_offset);
}

static void
__lambda15_ (PasangThemeSwitch* self)
{
#line 261 "theme.vala"
	g_signal_emit (self, pasang_theme_switch_signals[PASANG_THEME_SWITCH_CHANGED_SIGNAL], 0);
#line 2069 "theme.c"
}

static void
___lambda15__pasang_theme2_dcairo_changed (PasangTheme2DCairo* _sender,
                                           gpointer self)
{
#line 260 "theme.vala"
	__lambda15_ ((PasangThemeSwitch*) self);
#line 2078 "theme.c"
}

PasangThemeSwitch*
pasang_theme_switch_construct (GType object_type)
{
	PasangThemeSwitch * self = NULL;
	PasangTheme** _tmp0_;
	gint _tmp0__length1;
	PasangTheme* _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	PasangTheme* _tmp4_;
	PasangTheme* _tmp5_;
	PasangTheme** _tmp6_;
	gint _tmp6__length1;
	PasangTheme* _tmp7_;
#line 256 "theme.vala"
	self = (PasangThemeSwitch*) g_object_new (object_type, NULL);
#line 257 "theme.vala"
	_tmp0_ = self->priv->themes;
#line 257 "theme.vala"
	_tmp0__length1 = self->priv->themes_length1;
#line 257 "theme.vala"
	_tmp1_ = _tmp0_[0];
#line 257 "theme.vala"
	_tmp2_ = self->priv->size;
#line 257 "theme.vala"
	_tmp3_ = self->priv->size;
#line 257 "theme.vala"
	_tmp4_ = pasang_theme_select (_tmp1_, "0", _tmp2_.width, _tmp3_.height);
#line 257 "theme.vala"
	_tmp5_ = _tmp4_;
#line 257 "theme.vala"
	pasang_theme_switch_set_theme (self, _tmp5_);
#line 257 "theme.vala"
	_g_object_unref0 (_tmp5_);
#line 260 "theme.vala"
	_tmp6_ = self->priv->themes;
#line 260 "theme.vala"
	_tmp6__length1 = self->priv->themes_length1;
#line 260 "theme.vala"
	_tmp7_ = _tmp6_[0];
#line 260 "theme.vala"
	g_signal_connect_object (PASANG_IS_THEME2_DCAIRO (_tmp7_) ? ((PasangTheme2DCairo*) _tmp7_) : NULL, "changed", (GCallback) ___lambda15__pasang_theme2_dcairo_changed, self, 0);
#line 263 "theme.vala"
	pasang_theme_switch_put_contents (self);
#line 256 "theme.vala"
	return self;
#line 2127 "theme.c"
}

PasangThemeSwitch*
pasang_theme_switch_new (void)
{
#line 256 "theme.vala"
	return pasang_theme_switch_construct (PASANG_TYPE_THEME_SWITCH);
#line 2135 "theme.c"
}

static void
pasang_theme_switch_put_contents (PasangThemeSwitch* self)
{
	GtkStyleContext* _tmp0_;
	GtkWidget* list = NULL;
	GtkWidget* _tmp1_;
#line 266 "theme.vala"
	g_return_if_fail (self != NULL);
#line 267 "theme.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 267 "theme.vala"
	gtk_style_context_add_class (_tmp0_, "box-top-level");
#line 268 "theme.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 269 "theme.vala"
	_tmp1_ = pasang_theme_switch_create_theme_list (self);
#line 269 "theme.vala"
	list = _tmp1_;
#line 270 "theme.vala"
	gtk_widget_set_size_request (list, 300, 350);
#line 271 "theme.vala"
	gtk_container_add ((GtkContainer*) self, list);
#line 272 "theme.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 266 "theme.vala"
	_g_object_unref0 (list);
#line 2164 "theme.c"
}

static void
_vala_array_add30 (PasangThemeItem* * array,
                   int* length,
                   int* size,
                   const PasangThemeItem* value)
{
#line 285 "theme.vala"
	if ((*length) == (*size)) {
#line 285 "theme.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 285 "theme.vala"
		*array = g_renew (PasangThemeItem, *array, *size);
#line 2179 "theme.c"
	}
#line 285 "theme.vala"
	(*array)[(*length)++] = *value;
#line 2183 "theme.c"
}

static void
_pasang_theme_switch_on_selection_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                              gpointer self)
{
#line 295 "theme.vala"
	pasang_theme_switch_on_selection ((PasangThemeSwitch*) self);
#line 2192 "theme.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 300 "theme.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 2200 "theme.c"
}

static GtkWidget*
pasang_theme_switch_create_theme_list (PasangThemeSwitch* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkCellRendererPixbuf* _tmp5_;
	GtkCellRendererPixbuf* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkCellRendererText* _tmp9_;
	PasangTheme** _tmp10_;
	gint _tmp10__length1;
	GtkTreeView* _tmp32_;
	GtkTreeSelection* _tmp33_;
	GtkTreeSelection* _tmp34_;
	GtkTreeSelection* _tmp35_;
	GtkTreeView* _tmp36_;
	GtkTreeView* _tmp37_;
	GtkTreeView* _tmp38_;
	GtkTreePath* _tmp39_;
	GtkTreePath* _tmp40_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp41_;
	GtkTreeView* _tmp42_;
	GtkWidget* result = NULL;
#line 275 "theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 277 "theme.vala"
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
#line 277 "theme.vala"
	g_object_ref_sink (_tmp0_);
#line 277 "theme.vala"
	_g_object_unref0 (self->priv->tree_view);
#line 277 "theme.vala"
	self->priv->tree_view = _tmp0_;
#line 278 "theme.vala"
	_tmp1_ = self->priv->tree_view;
#line 278 "theme.vala"
	_tmp2_ = gtk_list_store_new (2, gdk_pixbuf_get_type (), G_TYPE_STRING, -1);
#line 278 "theme.vala"
	_g_object_unref0 (self->priv->tree_model);
#line 278 "theme.vala"
	self->priv->tree_model = _tmp2_;
#line 278 "theme.vala"
	_tmp3_ = self->priv->tree_model;
#line 278 "theme.vala"
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) _tmp3_);
#line 279 "theme.vala"
	_tmp4_ = self->priv->tree_view;
#line 279 "theme.vala"
	_tmp5_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 279 "theme.vala"
	g_object_ref_sink (_tmp5_);
#line 279 "theme.vala"
	_tmp6_ = _tmp5_;
#line 279 "theme.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp4_, -1, "Pixbuf", (GtkCellRenderer*) _tmp6_, "pixbuf", 0, NULL);
#line 279 "theme.vala"
	_g_object_unref0 (_tmp6_);
#line 280 "theme.vala"
	_tmp7_ = self->priv->tree_view;
#line 280 "theme.vala"
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 280 "theme.vala"
	g_object_ref_sink (_tmp8_);
#line 280 "theme.vala"
	_tmp9_ = _tmp8_;
#line 280 "theme.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp7_, -1, "Theme Name", (GtkCellRenderer*) _tmp9_, "text", 1, NULL);
#line 280 "theme.vala"
	_g_object_unref0 (_tmp9_);
#line 283 "theme.vala"
	_tmp10_ = self->priv->themes;
#line 283 "theme.vala"
	_tmp10__length1 = self->priv->themes_length1;
#line 2281 "theme.c"
	{
		PasangTheme** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
#line 283 "theme.vala"
		t_collection = _tmp10_;
#line 283 "theme.vala"
		t_collection_length1 = _tmp10__length1;
#line 283 "theme.vala"
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
#line 2293 "theme.c"
			PasangTheme* _tmp11_;
			PasangTheme* t = NULL;
#line 283 "theme.vala"
			_tmp11_ = _g_object_ref0 (t_collection[t_it]);
#line 283 "theme.vala"
			t = _tmp11_;
#line 2300 "theme.c"
			{
				PasangTheme* _tmp12_;
				PasangThemeItem* _tmp13_;
				gint _tmp13__length1;
#line 284 "theme.vala"
				_tmp12_ = t;
#line 284 "theme.vala"
				_tmp13_ = _tmp12_->items;
#line 284 "theme.vala"
				_tmp13__length1 = _tmp12_->items_length1;
#line 2311 "theme.c"
				{
					PasangThemeItem* item_collection = NULL;
					gint item_collection_length1 = 0;
					gint _item_collection_size_ = 0;
					gint item_it = 0;
#line 284 "theme.vala"
					item_collection = _tmp13_;
#line 284 "theme.vala"
					item_collection_length1 = _tmp13__length1;
#line 284 "theme.vala"
					for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
#line 2323 "theme.c"
						PasangThemeItem _tmp14_;
						PasangThemeItem _tmp15_ = {0};
						PasangThemeItem item = {0};
#line 284 "theme.vala"
						_tmp14_ = item_collection[item_it];
#line 284 "theme.vala"
						pasang_theme_item_copy (&_tmp14_, &_tmp15_);
#line 284 "theme.vala"
						item = _tmp15_;
#line 2333 "theme.c"
						{
							PasangThemeItem* _tmp16_;
							gint _tmp16__length1;
							PasangThemeItem _tmp17_;
							PasangThemeItem _tmp18_;
							PasangThemeItem _tmp19_ = {0};
							GtkTreeIter iter = {0};
							GtkListStore* _tmp20_;
							GtkTreeIter _tmp21_ = {0};
							GtkListStore* _tmp22_;
							GtkTreeIter _tmp23_;
							PasangThemeItem _tmp24_;
							GdkPixbuf* _tmp25_;
							GValue _tmp26_ = {0};
							GtkListStore* _tmp27_;
							GtkTreeIter _tmp28_;
							PasangThemeItem _tmp29_;
							const gchar* _tmp30_;
							GValue _tmp31_ = {0};
#line 285 "theme.vala"
							_tmp16_ = self->priv->theme_items;
#line 285 "theme.vala"
							_tmp16__length1 = self->priv->theme_items_length1;
#line 285 "theme.vala"
							_tmp17_ = item;
#line 285 "theme.vala"
							_tmp18_ = _tmp17_;
#line 285 "theme.vala"
							pasang_theme_item_copy (&_tmp18_, &_tmp19_);
#line 285 "theme.vala"
							_vala_array_add30 (&self->priv->theme_items, &self->priv->theme_items_length1, &self->priv->_theme_items_size_, &_tmp19_);
#line 287 "theme.vala"
							_tmp20_ = self->priv->tree_model;
#line 287 "theme.vala"
							gtk_list_store_append (_tmp20_, &_tmp21_);
#line 287 "theme.vala"
							iter = _tmp21_;
#line 288 "theme.vala"
							_tmp22_ = self->priv->tree_model;
#line 288 "theme.vala"
							_tmp23_ = iter;
#line 288 "theme.vala"
							_tmp24_ = item;
#line 288 "theme.vala"
							_tmp25_ = _tmp24_.pixbuf;
#line 288 "theme.vala"
							g_value_init (&_tmp26_, gdk_pixbuf_get_type ());
#line 288 "theme.vala"
							g_value_set_object (&_tmp26_, _tmp25_);
#line 288 "theme.vala"
							gtk_list_store_set_value (_tmp22_, &_tmp23_, 0, &_tmp26_);
#line 288 "theme.vala"
							G_IS_VALUE (&_tmp26_) ? (g_value_unset (&_tmp26_), NULL) : NULL;
#line 289 "theme.vala"
							_tmp27_ = self->priv->tree_model;
#line 289 "theme.vala"
							_tmp28_ = iter;
#line 289 "theme.vala"
							_tmp29_ = item;
#line 289 "theme.vala"
							_tmp30_ = _tmp29_.name;
#line 289 "theme.vala"
							g_value_init (&_tmp31_, G_TYPE_STRING);
#line 289 "theme.vala"
							g_value_set_string (&_tmp31_, _tmp30_);
#line 289 "theme.vala"
							gtk_list_store_set_value (_tmp27_, &_tmp28_, 1, &_tmp31_);
#line 289 "theme.vala"
							G_IS_VALUE (&_tmp31_) ? (g_value_unset (&_tmp31_), NULL) : NULL;
#line 284 "theme.vala"
							pasang_theme_item_destroy (&item);
#line 2405 "theme.c"
						}
					}
				}
#line 283 "theme.vala"
				_g_object_unref0 (t);
#line 2411 "theme.c"
			}
		}
	}
#line 294 "theme.vala"
	_tmp32_ = self->priv->tree_view;
#line 294 "theme.vala"
	_tmp33_ = gtk_tree_view_get_selection (_tmp32_);
#line 294 "theme.vala"
	_tmp34_ = _g_object_ref0 (_tmp33_);
#line 294 "theme.vala"
	_g_object_unref0 (self->priv->tree_selection);
#line 294 "theme.vala"
	self->priv->tree_selection = _tmp34_;
#line 295 "theme.vala"
	_tmp35_ = self->priv->tree_selection;
#line 295 "theme.vala"
	g_signal_connect_object (_tmp35_, "changed", (GCallback) _pasang_theme_switch_on_selection_gtk_tree_selection_changed, self, 0);
#line 298 "theme.vala"
	_tmp36_ = self->priv->tree_view;
#line 298 "theme.vala"
	gtk_tree_view_columns_autosize (_tmp36_);
#line 299 "theme.vala"
	_tmp37_ = self->priv->tree_view;
#line 299 "theme.vala"
	gtk_tree_view_set_headers_visible (_tmp37_, FALSE);
#line 300 "theme.vala"
	_tmp38_ = self->priv->tree_view;
#line 300 "theme.vala"
	_tmp39_ = gtk_tree_path_new_from_string ("0");
#line 300 "theme.vala"
	_tmp40_ = _tmp39_;
#line 300 "theme.vala"
	gtk_tree_view_set_cursor (_tmp38_, _tmp40_, NULL, FALSE);
#line 300 "theme.vala"
	__vala_GtkTreePath_free0 (_tmp40_);
#line 301 "theme.vala"
	_tmp41_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 301 "theme.vala"
	g_object_ref_sink (_tmp41_);
#line 301 "theme.vala"
	scrolled = _tmp41_;
#line 302 "theme.vala"
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
#line 303 "theme.vala"
	_tmp42_ = self->priv->tree_view;
#line 303 "theme.vala"
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp42_);
#line 305 "theme.vala"
	result = (GtkWidget*) scrolled;
#line 305 "theme.vala"
	return result;
#line 2463 "theme.c"
}

/**
     * Callback whenever a different theme is selected.
     * Side effect: requested_theme
     */
static void
pasang_theme_switch_on_selection (PasangThemeSwitch* self)
{
	GtkTreeSelection* _tmp0_;
#line 312 "theme.vala"
	g_return_if_fail (self != NULL);
#line 313 "theme.vala"
	_tmp0_ = self->priv->tree_selection;
#line 313 "theme.vala"
	if (gtk_tree_selection_count_selected_rows (_tmp0_) == 1) {
#line 2480 "theme.c"
		GtkTreeIter iter = {0};
		GtkTreeModel* model = NULL;
		GtkTreeSelection* _tmp1_;
		GtkTreeModel* _tmp2_ = NULL;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeModel* _tmp4_;
		gint n = 0;
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gint _tmp11_;
		PasangThemeItem item = {0};
		PasangThemeItem* _tmp12_;
		gint _tmp12__length1;
		PasangThemeItem _tmp13_;
		PasangThemeItem _tmp14_;
		PasangThemeItem _tmp15_ = {0};
		PasangTheme* _tmp16_;
		PasangThemeItem _tmp17_;
		PasangTheme* _tmp18_;
		PasangThemeItem _tmp19_;
		const gchar* _tmp20_;
		GtkAllocation _tmp21_;
		GtkAllocation _tmp22_;
		PasangTheme* _tmp23_;
		PasangTheme* _tmp24_;
		PasangTheme* _tmp25_;
#line 316 "theme.vala"
		_tmp1_ = self->priv->tree_selection;
#line 316 "theme.vala"
		gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
#line 316 "theme.vala"
		_g_object_unref0 (model);
#line 316 "theme.vala"
		_tmp4_ = _g_object_ref0 (_tmp2_);
#line 316 "theme.vala"
		model = _tmp4_;
#line 316 "theme.vala"
		iter = _tmp3_;
#line 317 "theme.vala"
		_tmp5_ = model;
#line 317 "theme.vala"
		_tmp6_ = iter;
#line 317 "theme.vala"
		_tmp7_ = gtk_tree_model_get_path (_tmp5_, &_tmp6_);
#line 317 "theme.vala"
		_tmp8_ = _tmp7_;
#line 317 "theme.vala"
		_tmp9_ = gtk_tree_path_to_string (_tmp8_);
#line 317 "theme.vala"
		_tmp10_ = _tmp9_;
#line 317 "theme.vala"
		_tmp11_ = atoi (_tmp10_);
#line 317 "theme.vala"
		_g_free0 (_tmp10_);
#line 317 "theme.vala"
		__vala_GtkTreePath_free0 (_tmp8_);
#line 317 "theme.vala"
		n = _tmp11_;
#line 318 "theme.vala"
		_tmp12_ = self->priv->theme_items;
#line 318 "theme.vala"
		_tmp12__length1 = self->priv->theme_items_length1;
#line 318 "theme.vala"
		_tmp13_ = _tmp12_[n];
#line 318 "theme.vala"
		_tmp14_ = _tmp13_;
#line 318 "theme.vala"
		pasang_theme_item_copy (&_tmp14_, &_tmp15_);
#line 318 "theme.vala"
		item = _tmp15_;
#line 319 "theme.vala"
		_tmp16_ = self->priv->_theme;
#line 319 "theme.vala"
		pasang_theme_free (_tmp16_);
#line 320 "theme.vala"
		_tmp17_ = item;
#line 320 "theme.vala"
		_tmp18_ = _tmp17_.engine;
#line 320 "theme.vala"
		_tmp19_ = item;
#line 320 "theme.vala"
		_tmp20_ = _tmp19_.path;
#line 320 "theme.vala"
		_tmp21_ = self->priv->size;
#line 320 "theme.vala"
		_tmp22_ = self->priv->size;
#line 320 "theme.vala"
		_tmp23_ = pasang_theme_select (_tmp18_, _tmp20_, _tmp21_.width, _tmp22_.height);
#line 320 "theme.vala"
		_tmp24_ = _tmp23_;
#line 320 "theme.vala"
		pasang_theme_switch_set_theme (self, _tmp24_);
#line 320 "theme.vala"
		_g_object_unref0 (_tmp24_);
#line 321 "theme.vala"
		_tmp25_ = self->priv->_theme;
#line 321 "theme.vala"
		if (_tmp25_ == NULL) {
#line 2583 "theme.c"
			PasangTheme** _tmp26_;
			gint _tmp26__length1;
			PasangTheme* _tmp27_;
			GtkAllocation _tmp28_;
			GtkAllocation _tmp29_;
			PasangTheme* _tmp30_;
			PasangTheme* _tmp31_;
			PasangThemeItem* _tmp32_;
			gint _tmp32__length1;
			PasangThemeItem _tmp33_;
			PasangThemeItem _tmp34_;
			PasangThemeItem _tmp35_ = {0};
#line 322 "theme.vala"
			_tmp26_ = self->priv->themes;
#line 322 "theme.vala"
			_tmp26__length1 = self->priv->themes_length1;
#line 322 "theme.vala"
			_tmp27_ = _tmp26_[0];
#line 322 "theme.vala"
			_tmp28_ = self->priv->size;
#line 322 "theme.vala"
			_tmp29_ = self->priv->size;
#line 322 "theme.vala"
			_tmp30_ = pasang_theme_select (_tmp27_, "0", _tmp28_.width, _tmp29_.height);
#line 322 "theme.vala"
			_tmp31_ = _tmp30_;
#line 322 "theme.vala"
			pasang_theme_switch_set_theme (self, _tmp31_);
#line 322 "theme.vala"
			_g_object_unref0 (_tmp31_);
#line 323 "theme.vala"
			_tmp32_ = self->priv->theme_items;
#line 323 "theme.vala"
			_tmp32__length1 = self->priv->theme_items_length1;
#line 323 "theme.vala"
			_tmp33_ = _tmp32_[0];
#line 323 "theme.vala"
			_tmp34_ = _tmp33_;
#line 323 "theme.vala"
			pasang_theme_item_copy (&_tmp34_, &_tmp35_);
#line 323 "theme.vala"
			pasang_theme_item_destroy (&item);
#line 323 "theme.vala"
			item = _tmp35_;
#line 2628 "theme.c"
		}
#line 325 "theme.vala"
		g_signal_emit (self, pasang_theme_switch_signals[PASANG_THEME_SWITCH_CHANGED_SIGNAL], 0);
#line 313 "theme.vala"
		pasang_theme_item_destroy (&item);
#line 313 "theme.vala"
		_g_object_unref0 (model);
#line 2636 "theme.c"
	}
}

/**
     * Select a random theme.
     * Side effect: requested_theme, indirectly through on_selection.
     */
void
pasang_theme_switch_random (PasangThemeSwitch* self)
{
	gint rnd = 0;
	PasangThemeItem* _tmp0_;
	gint _tmp0__length1;
	GtkTreePath* path = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_;
#line 333 "theme.vala"
	g_return_if_fail (self != NULL);
#line 334 "theme.vala"
	_tmp0_ = self->priv->theme_items;
#line 334 "theme.vala"
	_tmp0__length1 = self->priv->theme_items_length1;
#line 334 "theme.vala"
	rnd = (gint) g_random_int_range ((gint32) 0, (gint32) _tmp0__length1);
#line 335 "theme.vala"
	_tmp1_ = g_strdup_printf ("%i", rnd);
#line 335 "theme.vala"
	_tmp2_ = _tmp1_;
#line 335 "theme.vala"
	_tmp3_ = gtk_tree_path_new_from_string (_tmp2_);
#line 335 "theme.vala"
	_tmp4_ = _tmp3_;
#line 335 "theme.vala"
	_g_free0 (_tmp2_);
#line 335 "theme.vala"
	path = _tmp4_;
#line 336 "theme.vala"
	_tmp5_ = self->priv->tree_selection;
#line 336 "theme.vala"
	gtk_tree_selection_unselect_all (_tmp5_);
#line 337 "theme.vala"
	_tmp6_ = self->priv->tree_view;
#line 337 "theme.vala"
	gtk_tree_view_scroll_to_cell (_tmp6_, path, NULL, FALSE, (gfloat) 0, (gfloat) 0);
#line 338 "theme.vala"
	_tmp7_ = self->priv->tree_selection;
#line 338 "theme.vala"
	gtk_tree_selection_select_path (_tmp7_, path);
#line 333 "theme.vala"
	__vala_GtkTreePath_free0 (path);
#line 2692 "theme.c"
}

void
pasang_theme_switch_resize (PasangThemeSwitch* self,
                            GtkAllocation* allocation)
{
	GtkAllocation _tmp0_;
	PasangTheme* _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
#line 341 "theme.vala"
	g_return_if_fail (self != NULL);
#line 341 "theme.vala"
	g_return_if_fail (allocation != NULL);
#line 342 "theme.vala"
	_tmp0_ = *allocation;
#line 342 "theme.vala"
	self->priv->size = _tmp0_;
#line 343 "theme.vala"
	_tmp1_ = self->priv->_theme;
#line 343 "theme.vala"
	_tmp2_ = self->priv->size;
#line 343 "theme.vala"
	_tmp3_ = self->priv->size;
#line 343 "theme.vala"
	pasang_theme_resize (_tmp1_, _tmp2_.width, _tmp3_.height);
#line 344 "theme.vala"
	g_signal_emit (self, pasang_theme_switch_signals[PASANG_THEME_SWITCH_CHANGED_SIGNAL], 0);
#line 2721 "theme.c"
}

PasangTheme*
pasang_theme_switch_get_theme (PasangThemeSwitch* self)
{
	PasangTheme* result;
	PasangTheme* _tmp0_;
#line 247 "theme.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 247 "theme.vala"
	_tmp0_ = self->priv->_theme;
#line 247 "theme.vala"
	result = _tmp0_;
#line 247 "theme.vala"
	return result;
#line 2737 "theme.c"
}

static void
pasang_theme_switch_set_theme (PasangThemeSwitch* self,
                               PasangTheme* value)
{
#line 247 "theme.vala"
	g_return_if_fail (self != NULL);
#line 247 "theme.vala"
	if (pasang_theme_switch_get_theme (self) != value) {
#line 2748 "theme.c"
		PasangTheme* _tmp0_;
#line 247 "theme.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 247 "theme.vala"
		_g_object_unref0 (self->priv->_theme);
#line 247 "theme.vala"
		self->priv->_theme = _tmp0_;
#line 247 "theme.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_theme_switch_properties[PASANG_THEME_SWITCH_THEME_PROPERTY]);
#line 2758 "theme.c"
	}
}

static void
pasang_theme_switch_class_init (PasangThemeSwitchClass * klass,
                                gpointer klass_data)
{
#line 245 "theme.vala"
	pasang_theme_switch_parent_class = g_type_class_peek_parent (klass);
#line 245 "theme.vala"
	g_type_class_adjust_private_offset (klass, &PasangThemeSwitch_private_offset);
#line 245 "theme.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_theme_switch_get_property;
#line 245 "theme.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_pasang_theme_switch_set_property;
#line 245 "theme.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_theme_switch_finalize;
#line 245 "theme.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_THEME_SWITCH_THEME_PROPERTY, pasang_theme_switch_properties[PASANG_THEME_SWITCH_THEME_PROPERTY] = g_param_spec_object ("theme", "theme", "theme", PASANG_TYPE_THEME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 245 "theme.vala"
	pasang_theme_switch_signals[PASANG_THEME_SWITCH_CHANGED_SIGNAL] = g_signal_new ("changed", PASANG_TYPE_THEME_SWITCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2780 "theme.c"
}

static void
pasang_theme_switch_instance_init (PasangThemeSwitch * self,
                                   gpointer klass)
{
	PasangTheme2DCairo* _tmp0_;
	PasangTheme2DFile* _tmp1_;
	PasangTheme** _tmp2_;
	PasangThemeItem* _tmp3_;
	GtkAllocation _tmp4_ = {0};
#line 245 "theme.vala"
	self->priv = pasang_theme_switch_get_instance_private (self);
#line 248 "theme.vala"
	_tmp0_ = pasang_theme2_dcairo_new ();
#line 248 "theme.vala"
	_tmp1_ = pasang_theme2_dfile_new ();
#line 248 "theme.vala"
	_tmp2_ = g_new0 (PasangTheme*, 2 + 1);
#line 248 "theme.vala"
	_tmp2_[0] = (PasangTheme*) _tmp0_;
#line 248 "theme.vala"
	_tmp2_[1] = (PasangTheme*) _tmp1_;
#line 248 "theme.vala"
	self->priv->themes = _tmp2_;
#line 248 "theme.vala"
	self->priv->themes_length1 = 2;
#line 248 "theme.vala"
	self->priv->_themes_size_ = self->priv->themes_length1;
#line 249 "theme.vala"
	_tmp3_ = g_new0 (PasangThemeItem, 0);
#line 249 "theme.vala"
	self->priv->theme_items = _tmp3_;
#line 249 "theme.vala"
	self->priv->theme_items_length1 = 0;
#line 249 "theme.vala"
	self->priv->_theme_items_size_ = self->priv->theme_items_length1;
#line 250 "theme.vala"
	memset (&_tmp4_, 0, sizeof (GtkAllocation));
#line 250 "theme.vala"
	_tmp4_.width = 100;
#line 250 "theme.vala"
	_tmp4_.height = 100;
#line 250 "theme.vala"
	self->priv->size = _tmp4_;
#line 2826 "theme.c"
}

static void
pasang_theme_switch_finalize (GObject * obj)
{
	PasangThemeSwitch * self;
#line 245 "theme.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME_SWITCH, PasangThemeSwitch);
#line 247 "theme.vala"
	_g_object_unref0 (self->priv->_theme);
#line 248 "theme.vala"
	self->priv->themes = (_vala_array_free (self->priv->themes, self->priv->themes_length1, (GDestroyNotify) g_object_unref), NULL);
#line 249 "theme.vala"
	self->priv->theme_items = (_vala_PasangThemeItem_array_free (self->priv->theme_items, self->priv->theme_items_length1), NULL);
#line 252 "theme.vala"
	_g_object_unref0 (self->priv->tree_view);
#line 253 "theme.vala"
	_g_object_unref0 (self->priv->tree_selection);
#line 254 "theme.vala"
	_g_object_unref0 (self->priv->tree_model);
#line 245 "theme.vala"
	G_OBJECT_CLASS (pasang_theme_switch_parent_class)->finalize (obj);
#line 2849 "theme.c"
}

GType
pasang_theme_switch_get_type (void)
{
	static volatile gsize pasang_theme_switch_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_theme_switch_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangThemeSwitchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_theme_switch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangThemeSwitch), 0, (GInstanceInitFunc) pasang_theme_switch_instance_init, NULL };
		GType pasang_theme_switch_type_id;
		pasang_theme_switch_type_id = g_type_register_static (gtk_box_get_type (), "PasangThemeSwitch", &g_define_type_info, 0);
		PasangThemeSwitch_private_offset = g_type_add_instance_private (pasang_theme_switch_type_id, sizeof (PasangThemeSwitchPrivate));
		g_once_init_leave (&pasang_theme_switch_type_id__volatile, pasang_theme_switch_type_id);
	}
	return pasang_theme_switch_type_id__volatile;
}

static void
_vala_pasang_theme_switch_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PasangThemeSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_THEME_SWITCH, PasangThemeSwitch);
#line 245 "theme.vala"
	switch (property_id) {
#line 245 "theme.vala"
		case PASANG_THEME_SWITCH_THEME_PROPERTY:
#line 245 "theme.vala"
		g_value_set_object (value, pasang_theme_switch_get_theme (self));
#line 245 "theme.vala"
		break;
#line 2882 "theme.c"
		default:
#line 245 "theme.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 245 "theme.vala"
		break;
#line 2888 "theme.c"
	}
}

static void
_vala_pasang_theme_switch_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PasangThemeSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_THEME_SWITCH, PasangThemeSwitch);
#line 245 "theme.vala"
	switch (property_id) {
#line 245 "theme.vala"
		case PASANG_THEME_SWITCH_THEME_PROPERTY:
#line 245 "theme.vala"
		pasang_theme_switch_set_theme (self, g_value_get_object (value));
#line 245 "theme.vala"
		break;
#line 2908 "theme.c"
		default:
#line 245 "theme.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 245 "theme.vala"
		break;
#line 2914 "theme.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

