// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceFilterFrontendOKCode is the HTTP code returned for type ReplaceFilterFrontendOK
const ReplaceFilterFrontendOKCode int = 200

/*
ReplaceFilterFrontendOK Filter replaced

swagger:response replaceFilterFrontendOK
*/
type ReplaceFilterFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewReplaceFilterFrontendOK creates ReplaceFilterFrontendOK with default headers values
func NewReplaceFilterFrontendOK() *ReplaceFilterFrontendOK {

	return &ReplaceFilterFrontendOK{}
}

// WithPayload adds the payload to the replace filter frontend o k response
func (o *ReplaceFilterFrontendOK) WithPayload(payload *models.Filter) *ReplaceFilterFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter frontend o k response
func (o *ReplaceFilterFrontendOK) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFilterFrontendAcceptedCode is the HTTP code returned for type ReplaceFilterFrontendAccepted
const ReplaceFilterFrontendAcceptedCode int = 202

/*
ReplaceFilterFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceFilterFrontendAccepted
*/
type ReplaceFilterFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewReplaceFilterFrontendAccepted creates ReplaceFilterFrontendAccepted with default headers values
func NewReplaceFilterFrontendAccepted() *ReplaceFilterFrontendAccepted {

	return &ReplaceFilterFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace filter frontend accepted response
func (o *ReplaceFilterFrontendAccepted) WithReloadID(reloadID string) *ReplaceFilterFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace filter frontend accepted response
func (o *ReplaceFilterFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace filter frontend accepted response
func (o *ReplaceFilterFrontendAccepted) WithPayload(payload *models.Filter) *ReplaceFilterFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter frontend accepted response
func (o *ReplaceFilterFrontendAccepted) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFilterFrontendBadRequestCode is the HTTP code returned for type ReplaceFilterFrontendBadRequest
const ReplaceFilterFrontendBadRequestCode int = 400

/*
ReplaceFilterFrontendBadRequest Bad request

swagger:response replaceFilterFrontendBadRequest
*/
type ReplaceFilterFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFilterFrontendBadRequest creates ReplaceFilterFrontendBadRequest with default headers values
func NewReplaceFilterFrontendBadRequest() *ReplaceFilterFrontendBadRequest {

	return &ReplaceFilterFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace filter frontend bad request response
func (o *ReplaceFilterFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceFilterFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace filter frontend bad request response
func (o *ReplaceFilterFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace filter frontend bad request response
func (o *ReplaceFilterFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceFilterFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter frontend bad request response
func (o *ReplaceFilterFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFilterFrontendNotFoundCode is the HTTP code returned for type ReplaceFilterFrontendNotFound
const ReplaceFilterFrontendNotFoundCode int = 404

/*
ReplaceFilterFrontendNotFound The specified resource was not found

swagger:response replaceFilterFrontendNotFound
*/
type ReplaceFilterFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFilterFrontendNotFound creates ReplaceFilterFrontendNotFound with default headers values
func NewReplaceFilterFrontendNotFound() *ReplaceFilterFrontendNotFound {

	return &ReplaceFilterFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace filter frontend not found response
func (o *ReplaceFilterFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceFilterFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace filter frontend not found response
func (o *ReplaceFilterFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace filter frontend not found response
func (o *ReplaceFilterFrontendNotFound) WithPayload(payload *models.Error) *ReplaceFilterFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter frontend not found response
func (o *ReplaceFilterFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceFilterFrontendDefault General Error

swagger:response replaceFilterFrontendDefault
*/
type ReplaceFilterFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFilterFrontendDefault creates ReplaceFilterFrontendDefault with default headers values
func NewReplaceFilterFrontendDefault(code int) *ReplaceFilterFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceFilterFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace filter frontend default response
func (o *ReplaceFilterFrontendDefault) WithStatusCode(code int) *ReplaceFilterFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace filter frontend default response
func (o *ReplaceFilterFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace filter frontend default response
func (o *ReplaceFilterFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceFilterFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace filter frontend default response
func (o *ReplaceFilterFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace filter frontend default response
func (o *ReplaceFilterFrontendDefault) WithPayload(payload *models.Error) *ReplaceFilterFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace filter frontend default response
func (o *ReplaceFilterFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFilterFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
